/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Time;
import java.nio.FloatBuffer;
import java.util.concurrent.Future;
import mindustry.Vars;

public class ParticleRenderer {
    static final boolean useAsync = true;
    static final int maxParticles = 100000;
    static final int maxParticlesPerFrame = 25000;
    static final int particleSize = 9;
    static final int particleVertexSize = 4;
    static final float globalDrag = 0.05f;
    static final float cullPadding = 24.0f;
    static final VertexAttribute[] attributes = new VertexAttribute[]{VertexAttribute.position, new VertexAttribute(1, "a_size"), VertexAttribute.color};
    static Shader shader;
    float[] data = new float[900000];
    volatile int count;
    float[] addBuffer = new float[225000];
    int addCount;
    Mesh mesh = new Mesh(false, 100000, 0, attributes);
    float[] vertexBuffer = new float[400000];
    volatile int vertexBufferLength;
    @Nullable
    Future<?> asyncTask;

    public int count() {
        return this.count;
    }

    public void updateAndRender() {
        if (!Vars.state.isPaused()) {
            this.update();
        }
        this.render();
    }

    public void update() {
        if (this.asyncTask != null) {
            try {
                this.asyncTask.get();
            }
            catch (Exception e) {
                Log.err(e);
            }
        }
        int maxAdded = Math.min(100000 - this.count, this.addCount);
        int addOffset = this.addCount - maxAdded;
        if (maxAdded > 0) {
            System.arraycopy(this.addBuffer, addOffset * 9, this.data, this.count * 9, maxAdded * 9);
        }
        this.count += maxAdded;
        this.addCount = 0;
        this.uploadMeshData(this.mesh);
        this.asyncTask = Vars.mainExecutor.submit(this::updateAsync);
    }

    void updateAsync() {
        this.count = ParticleRenderer.update(this.data, this.count, Time.delta);
        this.buildVertices();
    }

    public void render() {
        if (shader == null) {
            ParticleRenderer.makeShader();
        }
        Gl.enable(34370);
        shader.bind();
        shader.setUniformMatrix4("u_mat", Core.camera.mat);
        shader.setUniformf("u_scaling", (float)Core.graphics.getWidth() / Core.camera.width);
        this.mesh.render(shader, 0);
    }

    public void add(float x, float y, float lifetime, float vx, float vy, float sizeFrom, float sizeTo, float color) {
        if (this.addCount * 9 >= this.addBuffer.length || !Rect.contains(x - Core.camera.width / 2.0f - sizeFrom - 24.0f, y - Core.camera.height / 2.0f - sizeFrom - 24.0f, Core.camera.width + sizeFrom * 2.0f + 48.0f, Core.camera.height + sizeFrom * 2.0f + 48.0f, x, y)) {
            return;
        }
        float[] buf = this.addBuffer;
        int i = this.addCount * 9;
        buf[i + 0] = 0.0f;
        buf[i + 1] = lifetime;
        buf[i + 2] = x;
        buf[i + 3] = y;
        buf[i + 4] = vx;
        buf[i + 5] = vy;
        buf[i + 6] = sizeFrom * 2.0f;
        buf[i + 7] = sizeTo * 2.0f;
        buf[i + 8] = color;
        ++this.addCount;
    }

    void buildVertices() {
        float[] data = this.data;
        float count = this.count * 9;
        float[] vertices = this.vertexBuffer;
        int bufferIndex = 0;
        int i = 0;
        while ((float)i < count) {
            float color = data[i + 8];
            float size = Mathf.lerp(data[i + 6], data[i + 7], Mathf.clamp(data[i] / data[i + 1]));
            vertices[bufferIndex + 0] = data[i + 2];
            vertices[bufferIndex + 1] = data[i + 3];
            vertices[bufferIndex + 2] = size;
            vertices[bufferIndex + 3] = color;
            bufferIndex += 4;
            i += 9;
        }
        this.vertexBufferLength = bufferIndex;
    }

    void uploadMeshData(Mesh mesh) {
        FloatBuffer buffer = mesh.getVerticesBuffer();
        buffer.position(0);
        buffer.limit(this.vertexBufferLength);
        buffer.put(this.vertexBuffer, 0, this.vertexBufferLength);
        buffer.position(0);
    }

    static int update(float[] data, int count, float delta) {
        int head = count * 9;
        float dragValue = Math.max(1.0f - 0.05f * delta, 0.0f);
        for (int i = 0; i < head; i += 9) {
            int n = i;
            data[n] = data[n] + delta;
            if (data[i] >= data[i + 1]) {
                if (head > 9) {
                    System.arraycopy(data, head - 9, data, i, 9);
                }
                head -= 9;
                i -= 9;
                continue;
            }
            int n2 = i + 2;
            data[n2] = data[n2] + data[i + 4] * delta;
            int n3 = i + 3;
            data[n3] = data[n3] + data[i + 5] * delta;
            int n4 = i + 4;
            data[n4] = data[n4] * dragValue;
            int n5 = i + 5;
            data[n5] = data[n5] * dragValue;
        }
        return head / 9;
    }

    static void makeShader() {
        shader = new Shader("uniform mat4 u_mat;\nuniform float u_scaling;\n\nattribute vec4 a_position;\nattribute float a_size;\nattribute vec4 a_color;\n\nvarying vec4 v_color;\n\nvoid main(){\n    v_color = a_color;\n\n    gl_Position = u_mat * a_position;\n    gl_PointSize = a_size * u_scaling;\n}\n", "varying lowp vec4 v_color;\n\n#define RAD1 0.43\n#define RAD2 0.5\n\n\nvoid main(){\n    vec2 delta = gl_PointCoord - vec2(0.5);\n    gl_FragColor = vec4(v_color.rgb, v_color.a * (1.0-smoothstep(RAD1*RAD1, RAD2*RAD2, delta.x * delta.x + delta.y * delta.y)));\n}\n");
    }
}

