/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class DistortFilter
extends GenerateFilter {
    public float scl = 40.0f;
    public float mag = 5.0f;

    @Override
    public FilterOption[] options() {
        return new FilterOption.SliderOption[]{new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 200.0f), new FilterOption.SliderOption("mag", () -> this.mag, f -> {
            this.mag = f;
        }, 0.5f, 100.0f)};
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public char icon() {
        return '\uf8c5';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        Tile tile = in.tile((float)in.x + this.noise(in, this.scl, this.mag) - this.mag / 2.0f, (float)in.y + this.noise(1, in, this.scl, this.mag) - this.mag / 2.0f);
        in.floor = tile.floor();
        if (!tile.block().synthetic() && !in.block.synthetic()) {
            in.block = tile.block();
        }
        in.overlay = tile.overlay();
    }
}

