/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.Events;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.WorldLabel;
import mindustry.ui.Fonts;

public class Menus {
    private static final Seq<MenuListener> menuListeners = new Seq();
    private static final Seq<TextInputListener> textInputListeners = new Seq();

    public static int registerMenu(MenuListener listener) {
        menuListeners.add(listener);
        return Menus.menuListeners.size - 1;
    }

    public static int registerTextInput(TextInputListener listener) {
        textInputListeners.add(listener);
        return Menus.textInputListeners.size - 1;
    }

    public static void menu(int menuId, String title, String message, String[][] options) {
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        if (options == null) {
            options = new String[0][0];
        }
        Vars.ui.showMenu(title, message, options, option -> Call.menuChoose(Vars.player, menuId, option));
    }

    public static void followUpMenu(int menuId, String title, String message, String[][] options) {
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        if (options == null) {
            options = new String[0][0];
        }
        Vars.ui.showFollowUpMenu(menuId, title, message, options, option -> Call.menuChoose(Vars.player, menuId, option));
    }

    public static void hideFollowUpMenu(int menuId) {
        Vars.ui.hideFollowUpMenu(menuId);
    }

    public static void menuChoose(@Nullable Player player, int menuId, int option) {
        if (player != null) {
            Events.fire(new EventType.MenuOptionChooseEvent(player, menuId, option));
            if (menuId >= 0 && menuId < Menus.menuListeners.size) {
                menuListeners.get(menuId).get(player, option);
            }
        }
    }

    public static void textInput(int textInputId, String title, String message, int textLength, String def, boolean numeric) {
        Menus.textInput(textInputId, title, message, textLength, def, numeric, false);
    }

    public static void textInput(int textInputId, String title, String message, int textLength, String def, boolean numeric, boolean allowEmpty) {
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        if (def == null) {
            def = "";
        }
        Vars.ui.showTextInput(title, message, textLength, def, numeric, allowEmpty, text -> Call.textInputResult(Vars.player, textInputId, text), () -> Call.textInputResult(Vars.player, textInputId, null));
    }

    public static void textInputResult(@Nullable Player player, int textInputId, @Nullable String text) {
        if (player != null) {
            Events.fire(new EventType.TextInputEvent(player, textInputId, text));
            if (textInputId >= 0 && textInputId < Menus.textInputListeners.size) {
                textInputListeners.get(textInputId).get(player, text);
            }
        }
    }

    public static void setHudText(String message) {
        if (message == null) {
            return;
        }
        Vars.ui.hudfrag.setHudText(message);
    }

    public static void hideHudText() {
        Vars.ui.hudfrag.toggleHudText(false);
    }

    public static void setHudTextReliable(String message) {
        Menus.setHudText(message);
    }

    public static void announce(String message) {
        if (message == null) {
            return;
        }
        Vars.ui.announce(message);
    }

    public static void infoMessage(String message) {
        if (message == null) {
            return;
        }
        Vars.ui.showText("", message);
    }

    public static void infoPopup(String message, float duration, int align, int top, int left, int bottom, int right) {
        if (message == null) {
            return;
        }
        Vars.ui.showInfoPopup(message, duration, align, top, left, bottom, right);
    }

    public static void label(String message, float duration, float worldx, float worldy) {
        if (message == null) {
            return;
        }
        Vars.ui.showLabel(message, duration, worldx, worldy);
    }

    public static void infoPopupReliable(String message, float duration, int align, int top, int left, int bottom, int right) {
        if (message == null) {
            return;
        }
        Vars.ui.showInfoPopup(message, duration, align, top, left, bottom, right);
    }

    public static void labelReliable(String message, float duration, float worldx, float worldy) {
        Menus.label(message, duration, worldx, worldy);
    }

    public static void infoToast(String message, float duration) {
        if (message == null) {
            return;
        }
        Vars.ui.showInfoToast(message, duration);
    }

    public static void warningToast(int unicode, String text) {
        if (text == null || Fonts.icon.getData().getGlyph((char)unicode) == null) {
            return;
        }
        Vars.ui.hudfrag.showToast(Fonts.getGlyph(Fonts.icon, (char)unicode), text);
    }

    public static void openURI(String uri) {
        if (uri == null) {
            return;
        }
        Vars.ui.showConfirm(Core.bundle.format("linkopen", uri), () -> Core.app.openURI(uri));
    }

    public static void removeWorldLabel(int id) {
        WorldLabel label = Groups.label.getByID(id);
        if (label != null) {
            label.remove();
        }
    }

    public static interface MenuListener {
        public void get(Player var1, int var2);
    }

    public static interface TextInputListener {
        public void get(Player var1, @Nullable String var2);
    }
}

