/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;

public class DirectionBridge
extends Block {
    private static BuildPlan otherReq;
    private int otherDst = 0;
    public TextureRegion bridgeRegion;
    public TextureRegion bridgeBotRegion;
    public TextureRegion bridgeLiquidRegion;
    public TextureRegion arrowRegion;
    public TextureRegion dirRegion;
    public int range = 4;

    public DirectionBridge(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.rotate = true;
        this.group = BlockGroup.transportation;
        this.noUpdateDisabled = true;
        this.priority = -1.0f;
        this.envEnabled = 7;
        this.drawArrow = false;
        this.allowDiagonal = false;
        this.regionRotated1 = 1;
    }

    @Override
    public void init() {
        this.updateClipRadius(((float)this.range + 0.5f) * 8.0f);
        super.init();
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.dirRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public void drawPlanConfigTop(BuildPlan plan, Eachable<BuildPlan> list) {
        otherReq = null;
        this.otherDst = this.range;
        Point2 d = Geometry.d4(plan.rotation);
        list.each(other -> {
            int dst;
            if (other.block == this && plan != other && Mathf.clamp(other.x - plan.x, -1, 1) == d.x && Mathf.clamp(other.y - plan.y, -1, 1) == d.y && (dst = Math.max(Math.abs(other.x - plan.x), Math.abs(other.y - plan.y))) <= this.otherDst) {
                otherReq = other;
                this.otherDst = dst;
            }
        });
        if (otherReq != null) {
            this.drawBridge(plan.rotation, plan.drawx(), plan.drawy(), otherReq.drawx(), otherReq.drawy(), null);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.dirRegion};
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, this, rotation, (point, other) -> Math.max(Math.abs(point.x - other.x), Math.abs(point.y - other.y)) <= this.range);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid, boolean line) {
        DirectionBridgeBuild build;
        Building building;
        Tile other;
        int i;
        int dy;
        int dx;
        int length = this.range;
        if (line) {
            block0: for (int d = 0; d < 4; ++d) {
                if (d == (rotation + 2) % 4) continue;
                dx = Geometry.d4x(d);
                dy = Geometry.d4y(d);
                for (i = 1; i <= this.range; ++i) {
                    other = Vars.world.tile(x - dx * i, y - dy * i);
                    if (other == null || !((building = other.build) instanceof DirectionBridgeBuild)) continue;
                    build = (DirectionBridgeBuild)building;
                    if (build.block != this || build.team != Vars.player.team()) continue;
                    if (build.rotation != d) continue block0;
                    Building from = other.build;
                    Drawf.dashLine(Pal.place, from.x + (float)dx * 6.0f, from.y + (float)dy * 6.0f, from.x + (float)(dx * i * 8), from.y + (float)(dy * i * 8));
                    Drawf.square(from.x, from.y, (float)(from.block.size * 8) / 2.0f + 2.5f, 0.0f, Pal.place);
                    continue block0;
                }
            }
        }
        Building found = null;
        dx = Geometry.d4x(rotation);
        dy = Geometry.d4y(rotation);
        for (i = 1; i <= this.range; ++i) {
            other = Vars.world.tile(x + dx * i, y + dy * i);
            if (other == null || !((building = other.build) instanceof DirectionBridgeBuild)) continue;
            build = (DirectionBridgeBuild)building;
            if (build.block != this || build.team != Vars.player.team()) continue;
            length = i;
            found = other.build;
            break;
        }
        if (line || found != null) {
            Drawf.dashLine(Pal.placing, (float)(x * 8) + (float)dx * 6.0f, (float)(y * 8) + (float)dy * 6.0f, x * 8 + dx * length * 8, y * 8 + dy * length * 8);
        }
        if (found != null) {
            if (line) {
                Drawf.square(found.x, found.y, (float)(found.block.size * 8) / 2.0f + 2.5f, 0.0f);
            } else {
                Drawf.square(found.x, found.y, 2.0f);
            }
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        this.drawPlace(x, y, rotation, valid, true);
    }

    public void drawBridge(int rotation, float x1, float y1, float x2, float y2, @Nullable Color liquidColor) {
        Draw.alpha(Renderer.bridgeOpacity);
        float angle = Angles.angle(x1, y1, x2, y2);
        float cx = (x1 + x2) / 2.0f;
        float cy = (y1 + y2) / 2.0f;
        float len = Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)) - (float)(this.size * 8);
        Draw.rect(this.bridgeRegion, cx, cy, len, (float)this.bridgeRegion.height * this.bridgeRegion.scl(), angle);
        if (liquidColor != null) {
            Draw.color(liquidColor, liquidColor.a * Renderer.bridgeOpacity);
            Draw.rect(this.bridgeLiquidRegion, cx, cy, len, (float)this.bridgeLiquidRegion.height * this.bridgeLiquidRegion.scl(), angle);
            Draw.color();
            Draw.alpha(Renderer.bridgeOpacity);
        }
        if (this.bridgeBotRegion.found()) {
            Draw.color(0.4f, 0.4f, 0.4f, 0.4f * Renderer.bridgeOpacity);
            Draw.rect(this.bridgeBotRegion, cx, cy, len, (float)this.bridgeBotRegion.height * this.bridgeBotRegion.scl(), angle);
            Draw.reset();
        }
        Draw.alpha(Renderer.bridgeOpacity);
        for (float i = 6.0f; i <= len + (float)(this.size * 8) - 5.0f; i += 5.0f) {
            Draw.rect(this.arrowRegion, x1 + (float)Geometry.d4x(rotation) * i, y1 + (float)Geometry.d4y(rotation) * i, angle);
        }
        Draw.reset();
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            return Math.abs(y1 - y2) <= this.range;
        }
        if (y1 == y2) {
            return Math.abs(x1 - x2) <= this.range;
        }
        return false;
    }

    public class DirectionBridgeBuild
    extends Building {
        public DirectionBridgeBuild[] occupied = new DirectionBridgeBuild[4];
        @Nullable
        public DirectionBridgeBuild lastLink;

        @Override
        public void draw() {
            Draw.rect(this.block.region, this.x, this.y);
            Draw.rect(DirectionBridge.this.dirRegion, this.x, this.y, this.rotdeg());
            DirectionBridgeBuild link = this.findLink();
            if (link != null) {
                Draw.z(69.0f);
                DirectionBridge.this.drawBridge(this.rotation, this.x, this.y, link.x, link.y, null);
            }
        }

        @Override
        public void drawSelect() {
            DirectionBridge.this.drawPlace(this.tile.x, this.tile.y, this.rotation, true, false);
            for (int dir = 0; dir < 4; ++dir) {
                if (dir == this.rotation) continue;
                int dx = Geometry.d4x(dir);
                int dy = Geometry.d4y(dir);
                DirectionBridgeBuild found = this.occupied[(dir + 2) % 4];
                if (found == null) continue;
                int length = Math.max(Math.abs(found.tileX() - this.tileX()), Math.abs(found.tileY() - this.tileY()));
                Drawf.dashLine(Pal.place, found.x - (float)dx * 6.0f, found.y - (float)dy * 6.0f, found.x - (float)(dx * length * 8), found.y - (float)(dy * length * 8));
                Drawf.square(found.x, found.y, 2.0f, 45.0f, Pal.place);
            }
        }

        @Nullable
        public DirectionBridgeBuild findLink() {
            for (int i = 1; i <= DirectionBridge.this.range; ++i) {
                Building building;
                Tile other = this.tile.nearby(Geometry.d4x(this.rotation) * i, Geometry.d4y(this.rotation) * i);
                if (other == null || !((building = other.build) instanceof DirectionBridgeBuild)) continue;
                DirectionBridgeBuild build = (DirectionBridgeBuild)building;
                if (build.block != DirectionBridge.this || build.team != this.team) continue;
                return build;
            }
            return null;
        }
    }
}

