/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.Core;
import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.lang.invoke.LambdaMetafactory;
import mindustry.ctype.Content;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.meta.BlockGroup;

public class PayloadBlock
extends Block {
    public float payloadSpeed = 0.7f;
    public float payloadRotateSpeed = 5.0f;
    public String regionSuffix = "";
    public TextureRegion topRegion;
    public TextureRegion outRegion;
    public TextureRegion inRegion;

    public PayloadBlock(String name) {
        super(name);
        this.update = true;
        this.sync = true;
        this.group = BlockGroup.payloads;
        this.acceptsUnitPayloads = true;
        this.envEnabled |= 6;
    }

    @Override
    public void load() {
        super.load();
        this.topRegion = this.findFactoryRegion("-top");
        this.outRegion = this.findFactoryRegion("-out");
        this.inRegion = this.findFactoryRegion("-in");
    }

    protected TextureRegion findFactoryRegion(String suf) {
        TextureAtlas.AtlasRegion region = Core.atlas.find(this.name + suf);
        if (!region.found() && this.minfo.mod != null) {
            region = Core.atlas.find(this.minfo.mod.name + "-factory" + suf + "-" + this.size + this.regionSuffix);
        }
        if (!region.found()) {
            region = Core.atlas.find("factory" + suf + "-" + this.size + this.regionSuffix);
        }
        return region;
    }

    public static boolean blends(Building build, int direction) {
        int size = build.block.size;
        int trns = build.block.size / 2 + 1;
        Building accept = build.nearby(Geometry.d4((int)direction).x * trns, Geometry.d4((int)direction).y * trns);
        return accept != null && accept.block.outputsPayload && (accept.block.size == size && Math.abs(accept.tileX() - build.tileX()) % size == 0 && Math.abs(accept.tileY() - build.tileY()) % size == 0 && (accept.block.rotate && accept.tileX() + Geometry.d4((int)accept.rotation).x * size == build.tileX() && accept.tileY() + Geometry.d4((int)accept.rotation).y * size == build.tileY() || !accept.block.rotate || !accept.block.outputFacing) || accept.block.size != size && (accept.rotation % 2 == 0 ? Math.abs(accept.y - build.y) <= (float)Math.abs(size * 8 - accept.block.size * 8) / 2.0f : Math.abs(accept.x - build.x) <= (float)Math.abs(size * 8 - accept.block.size * 8) / 2.0f) && (!accept.block.rotate || accept.front() == build || !accept.block.outputFacing));
    }

    /*
     * Unable to fully structure code
     */
    public static void pushOutput(Payload payload, float progress) {
        block2: {
            thresh = 0.55f;
            if (!(progress >= thresh)) break block2;
            if (!(payload instanceof UnitPayload)) ** GOTO lbl-1000
            u = (UnitPayload)payload;
            if (u.unit.type.allowLegStep) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            legStep = v0;
            size = payload.size();
            radius = size / 2.0f;
            x = payload.x();
            y = payload.y();
            scl = Mathf.clamp((progress - thresh) / (1.0f - thresh) * 1.1f);
            Groups.unit.intersect(x - size / 2.0f, y - size / 2.0f, size, size, (Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$pushOutput$0(mindustry.world.blocks.payloads.Payload float boolean float float float mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)((Payload)payload, (float)radius, (boolean)legStep, (float)x, (float)y, (float)scl));
        }
    }

    private static /* synthetic */ void lambda$pushOutput$0(Payload payload, float radius, boolean legStep, float x, float y, float scl, Unit u) {
        float dst = u.dst(payload);
        float rs = radius + u.hitSize / 2.0f;
        if (u.isGrounded() && u.type.allowLegStep == legStep && dst < rs) {
            u.vel.add(Tmp.v1.set(u.x - x, u.y - y).setLength(Math.min(rs - dst, 1.0f)).scl(scl));
        }
    }

    public class PayloadBlockBuild<T extends Payload>
    extends Building {
        @Nullable
        public T payload;
        public Vec2 payVector = new Vec2();
        public float payRotation;
        public boolean carried;

        public boolean acceptUnitPayload(Unit unit) {
            return false;
        }

        @Override
        public boolean canControlSelect(Unit unit) {
            return !unit.spawnedByCore && unit.type.allowedInPayloads && this.payload == null && this.acceptUnitPayload(unit) && unit.tileOn() != null && unit.tileOn().build == this;
        }

        @Override
        public void onControlSelect(Unit player) {
            float x = player.x;
            float y = player.y;
            this.handleUnitPayload(player, p -> {
                this.payload = p;
            });
            this.payVector.set(x, y).sub(this).clamp((float)(-PayloadBlock.this.size * 8) / 2.0f, (float)(-PayloadBlock.this.size * 8) / 2.0f, (float)(PayloadBlock.this.size * 8) / 2.0f, (float)(PayloadBlock.this.size * 8) / 2.0f);
            this.payRotation = player.rotation;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.payload == null;
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            this.payload = payload;
            this.payVector.set(source).sub(this).clamp((float)(-PayloadBlock.this.size * 8) / 2.0f, (float)(-PayloadBlock.this.size * 8) / 2.0f, (float)(PayloadBlock.this.size * 8) / 2.0f, (float)(PayloadBlock.this.size * 8) / 2.0f);
            this.payRotation = payload.rotation();
            this.updatePayload();
        }

        @Override
        public Payload getPayload() {
            return this.payload;
        }

        @Override
        public void pickedUp() {
            this.carried = true;
        }

        @Override
        public void drawTeamTop() {
            this.carried = false;
        }

        @Override
        public Payload takePayload() {
            T t = this.payload;
            this.payload = null;
            return t;
        }

        @Override
        public void onRemoved() {
            super.onRemoved();
            if (this.payload != null && !this.carried) {
                this.payload.dump();
            }
        }

        @Override
        public void updateTile() {
            if (this.payload != null) {
                this.payload.update(null, this);
            }
        }

        @Override
        public void onDestroyed() {
            if (this.payload != null) {
                this.payload.destroyed();
            }
            super.onDestroyed();
        }

        public boolean blends(int direction) {
            return PayloadBlock.blends(this, direction);
        }

        public void updatePayload() {
            if (this.payload != null) {
                this.payload.set(this.x + this.payVector.x, this.y + this.payVector.y, this.payRotation);
            }
        }

        public boolean moveInPayload() {
            return this.moveInPayload(true);
        }

        public boolean moveInPayload(boolean rotate) {
            if (this.payload == null) {
                return false;
            }
            this.updatePayload();
            if (rotate) {
                this.payRotation = Angles.moveToward(this.payRotation, this.block.rotate ? this.rotdeg() : 90.0f, PayloadBlock.this.payloadRotateSpeed * this.delta());
            }
            this.payVector.approach(Vec2.ZERO, PayloadBlock.this.payloadSpeed * this.delta());
            return this.hasArrived();
        }

        public void moveOutPayload() {
            boolean canMove;
            if (this.payload == null) {
                return;
            }
            this.updatePayload();
            Vec2 dest = Tmp.v1.trns(this.rotdeg(), (float)(PayloadBlock.this.size * 8) / 2.0f);
            this.payRotation = Angles.moveToward(this.payRotation, this.rotdeg(), PayloadBlock.this.payloadRotateSpeed * this.delta());
            this.payVector.approach(dest, PayloadBlock.this.payloadSpeed * this.delta());
            Building front = this.front();
            boolean canDump = front == null || !front.tile.solid();
            boolean bl = canMove = front != null && (front.block.outputsPayload || front.block.acceptsPayload);
            if (canDump && !canMove) {
                PayloadBlock.pushOutput(this.payload, 1.0f - this.payVector.dst(dest) / ((float)(PayloadBlock.this.size * 8) / 2.0f));
            }
            if (this.payVector.within(dest, 0.001f)) {
                this.payVector.clamp((float)(-PayloadBlock.this.size * 8) / 2.0f, (float)(-PayloadBlock.this.size * 8) / 2.0f, (float)(PayloadBlock.this.size * 8) / 2.0f, (float)(PayloadBlock.this.size * 8) / 2.0f);
                if (canMove) {
                    if (this.movePayload((Payload)this.payload)) {
                        this.payload = null;
                    }
                } else if (canDump) {
                    this.dumpPayload();
                }
            }
        }

        public void dumpPayload() {
            float tx = Angles.trnsx(this.payload.rotation(), 0.1f);
            float ty = Angles.trnsy(this.payload.rotation(), 0.1f);
            this.payload.set(this.payload.x() + tx, this.payload.y() + ty, this.payload.rotation());
            if (this.payload.dump()) {
                this.payload = null;
            } else {
                this.payload.set(this.payload.x() - tx, this.payload.y() - ty, this.payload.rotation());
            }
        }

        public boolean hasArrived() {
            return this.payVector.isZero(0.01f);
        }

        public void drawPayload() {
            if (this.payload != null) {
                this.updatePayload();
                Draw.z(35.0f);
                this.payload.draw();
            }
        }

        @Override
        public double sense(Content content) {
            T t = this.payload;
            if (t instanceof UnitPayload) {
                UnitPayload up = (UnitPayload)t;
                if (up.unit.type == content) {
                    return 1.0;
                }
            }
            if ((t = this.payload) instanceof BuildPayload) {
                BuildPayload bp = (BuildPayload)t;
                if (bp.build.block == content) {
                    return 1.0;
                }
            }
            return super.sense(content);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.payVector.x);
            write.f(this.payVector.y);
            write.f(this.payRotation);
            Payload.write(this.payload, write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.payVector.set(read.f(), read.f());
            this.payRotation = read.f();
            this.payload = Payload.read(read);
        }
    }
}

