/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.draw.DrawBlock;

public class DrawArcSmelt
extends DrawBlock {
    public Color flameColor = Color.valueOf("f58349");
    public Color midColor = Color.valueOf("f2d585");
    public float flameRad = 1.0f;
    public float circleSpace = 2.0f;
    public float flameRadiusScl = 3.0f;
    public float flameRadiusMag = 0.3f;
    public float circleStroke = 1.5f;
    public float x = 0.0f;
    public float y = 0.0f;
    public float alpha = 0.68f;
    public int particles = 25;
    public float particleLife = 40.0f;
    public float particleRad = 7.0f;
    public float particleStroke = 1.1f;
    public float particleLen = 3.0f;
    public boolean drawCenter = true;
    public Blending blending = Blending.additive;

    @Override
    public void draw(Building build) {
        if (build.warmup() > 0.0f && this.flameColor.a > 0.001f) {
            Lines.stroke(this.circleStroke * build.warmup());
            float si = Mathf.absin(this.flameRadiusScl, this.flameRadiusMag);
            float a = this.alpha * build.warmup();
            Draw.blend(this.blending);
            Draw.color(this.midColor, a);
            if (this.drawCenter) {
                Fill.circle(build.x + this.x, build.y + this.y, this.flameRad + si);
            }
            Draw.color(this.flameColor, a);
            if (this.drawCenter) {
                Lines.circle(build.x + this.x, build.y + this.y, (this.flameRad + this.circleSpace + si) * build.warmup());
            }
            Lines.stroke(this.particleStroke * build.warmup());
            float base = Time.time / this.particleLife;
            rand.setSeed(build.id);
            for (int i = 0; i < this.particles; ++i) {
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float angle = rand.random(360.0f);
                float len = this.particleRad * Interp.pow2Out.apply(fin);
                Lines.lineAngle(build.x + Angles.trnsx(angle, len) + this.x, build.y + Angles.trnsy(angle, len) + this.y, angle, this.particleLen * fout * build.warmup());
            }
            Draw.blend();
            Draw.reset();
        }
    }
}

