/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawFade
extends DrawBlock {
    public String suffix = "-top";
    public float alpha = 0.6f;
    public float scale = 3.0f;
    public TextureRegion region;

    @Override
    public void draw(Building build) {
        Draw.alpha(Mathf.absin(build.totalProgress(), this.scale, this.alpha) * build.warmup());
        Draw.rect(this.region, build.x, build.y);
        Draw.reset();
    }

    @Override
    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
    }
}

