/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.draw.DrawBlock;

public class DrawLiquidTile
extends DrawBlock {
    public Liquid drawLiquid;
    public float padding;
    public float padLeft = -1.0f;
    public float padRight = -1.0f;
    public float padTop = -1.0f;
    public float padBottom = -1.0f;
    public float alpha = 1.0f;

    public DrawLiquidTile(Liquid drawLiquid, float padding) {
        this.drawLiquid = drawLiquid;
        this.padding = padding;
    }

    public DrawLiquidTile(Liquid drawLiquid) {
        this.drawLiquid = drawLiquid;
    }

    public DrawLiquidTile() {
    }

    @Override
    public void draw(Building build) {
        Liquid drawn = this.drawLiquid != null ? this.drawLiquid : build.liquids.current();
        LiquidBlock.drawTiledFrames(build.block.size, build.x, build.y, this.padLeft, this.padRight, this.padTop, this.padBottom, drawn, build.liquids.get(drawn) / build.block.liquidCapacity * this.alpha);
    }

    @Override
    public void load(Block block) {
        if (this.padLeft < 0.0f) {
            this.padLeft = this.padding;
        }
        if (this.padRight < 0.0f) {
            this.padRight = this.padding;
        }
        if (this.padTop < 0.0f) {
            this.padTop = this.padding;
        }
        if (this.padBottom < 0.0f) {
            this.padBottom = this.padding;
        }
    }
}

