/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta;

import arc.struct.ObjectMap;
import arc.util.Nullable;
import mindustry.Vars;

public class Attribute {
    public static Attribute[] all = new Attribute[0];
    public static ObjectMap<String, Attribute> map = new ObjectMap();
    public static final Attribute heat = Attribute.add("heat");
    public static final Attribute spores = Attribute.add("spores");
    public static final Attribute water = Attribute.add("water");
    public static final Attribute oil = Attribute.add("oil");
    public static final Attribute light = Attribute.add("light");
    public static final Attribute sand = Attribute.add("sand");
    public static final Attribute steam = Attribute.add("steam");
    public final int id;
    public final String name;

    public float env() {
        if (Vars.state == null) {
            return 0.0f;
        }
        return Vars.state.envAttrs.get(this);
    }

    Attribute(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Attribute get(String name) {
        return map.getThrow(name, () -> new IllegalArgumentException("Unknown Attribute type: " + name));
    }

    @Nullable
    public static Attribute getOrNull(String name) {
        return map.get(name);
    }

    public static boolean exists(String name) {
        return map.containsKey(name);
    }

    public static Attribute add(String name) {
        Attribute a = new Attribute(all.length, name);
        Attribute[] prev = all;
        all = new Attribute[all.length + 1];
        System.arraycopy(prev, 0, all, 0, a.id);
        Attribute.all[a.id] = a;
        map.put(name, a);
        return a;
    }
}

