function getBridge() {
  const bridge = globalThis.__NAPCAT_BRIDGE__;
  if (!bridge) throw new Error('[QCE Overlay] Bridge未初始化');
  return bridge;
}

export const FriendApi = {
  async getBuddy(forceRefresh = false) {
    const { core } = getBridge();
    const impl = core?.apis?.FriendApi?.getBuddy || core?.apis?.friend?.getBuddy;
    if (!impl) throw new Error('[QCE Overlay] FriendApi.getBuddy 不可用');
    return impl.call(core.apis.FriendApi || core.apis.friend, forceRefresh);
  }
};

export const NTQQFriendApi = FriendApi;
export default FriendApi;
