import * as path from 'path';
import path__default, { dirname, join } from 'path';
import * as fs from 'fs';
import fs__default, { promises, existsSync as existsSync$1, readFileSync as readFileSync$1, mkdirSync, statSync as statSync$1, writeFileSync } from 'fs';
import fsProm, { stat as stat$1, readdir, unlink as unlink$1 } from 'fs/promises';
import { ReadableStream as ReadableStream$1 } from 'node:stream/web';
import * as stream$3 from 'node:stream';
import stream__default, { Readable, PassThrough, pipeline } from 'node:stream';
import fs$1, { open, stat, constants as constants$1, writeFile, unlink, readdir as readdir$1 } from 'node:fs/promises';
import { createRequire } from 'module';
import https$1 from 'node:https';
import http from 'node:http';
import * as crypto$2 from 'crypto';
import crypto__default, { randomUUID, createHmac, createHash as createHash$1 } from 'crypto';
import path$1, { basename, resolve as resolve$1, dirname as dirname$1, join as join$1 } from 'node:path';
import os$1, { constants, platform, arch } from 'node:os';
import fs$2, { readFileSync, statSync, createReadStream, existsSync, unlink as unlink$2 } from 'node:fs';
import * as crypto$1 from 'node:crypto';
import crypto__default$1, { createHash, randomBytes, randomUUID as randomUUID$1 } from 'node:crypto';
import * as os from 'os';
import os__default from 'os';
import * as net from 'node:net';
import net__default, { isIP } from 'node:net';
import assert$1 from 'node:assert';
import * as zlib from 'node:zlib';
import zlib__default from 'node:zlib';
import require$$0$4, { promisify } from 'util';
import require$$0$5, { EventEmitter as EventEmitter$2 } from 'events';
import require$$0$6 from 'buffer';
import require$$1$2, { gunzipSync as gunzipSync$1 } from 'zlib';
import require$$1$1 from 'string_decoder';
import require$$0$7, { createServer as createServer$1 } from 'http';
import * as https from 'https';
import https__default, { createServer } from 'https';
import { fileURLToPath, URL as URL$2 } from 'url';
import EventEmitter, { EventEmitter as EventEmitter$1 } from 'node:events';
import express, { Router } from 'express';
import { WebSocketServer, WebSocket } from 'ws';
import * as net$1 from 'net';
import { Socket } from 'net';
import { fork, execFile } from 'child_process';
import { Worker as Worker$1 } from 'worker_threads';
import { C as ConoutWorkerMessage, g as getWorkerPipeName } from './conout-D9oph_Le.js';
import { fileURLToPath as fileURLToPath$1 } from 'node:url';
import * as tty from 'tty';
import { Buffer as Buffer$1 } from 'node:buffer';
import require$$1$3, { PassThrough as PassThrough$1, Writable } from 'stream';
import require$$0$8 from 'constants';
import require$$2$2 from 'assert';
import { decode, isSilk, isWav, getDuration, getWavFileInfo } from 'silk-wasm';
import { dlopen } from 'node:process';
import { pipeline as pipeline$1 } from 'stream/promises';
import * as process$1 from 'process';

/**
 * Get the type of a JSON value.
 * Distinguishes between array, null and object.
 */
function typeofJsonValue(value) {
    let t = typeof value;
    if (t == "object") {
        if (Array.isArray(value))
            return "array";
        if (value === null)
            return "null";
    }
    return t;
}
/**
 * Is this a JSON object (instead of an array or null)?
 */
function isJsonObject(value) {
    return value !== null && typeof value == "object" && !Array.isArray(value);
}

// lookup table from base64 character to byte
let encTable = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
// lookup table from base64 character *code* to byte because lookup by number is fast
let decTable = [];
for (let i = 0; i < encTable.length; i++)
    decTable[encTable[i].charCodeAt(0)] = i;
// support base64url variants
decTable["-".charCodeAt(0)] = encTable.indexOf("+");
decTable["_".charCodeAt(0)] = encTable.indexOf("/");
/**
 * Decodes a base64 string to a byte array.
 *
 * - ignores white-space, including line breaks and tabs
 * - allows inner padding (can decode concatenated base64 strings)
 * - does not require padding
 * - understands base64url encoding:
 *   "-" instead of "+",
 *   "_" instead of "/",
 *   no padding
 */
function base64decode(base64Str) {
    // estimate byte size, not accounting for inner padding and whitespace
    let es = base64Str.length * 3 / 4;
    // if (es % 3 !== 0)
    // throw new Error('invalid base64 string');
    if (base64Str[base64Str.length - 2] == '=')
        es -= 2;
    else if (base64Str[base64Str.length - 1] == '=')
        es -= 1;
    let bytes = new Uint8Array(es), bytePos = 0, // position in byte array
    groupPos = 0, // position in base64 group
    b, // current byte
    p = 0 // previous byte
    ;
    for (let i = 0; i < base64Str.length; i++) {
        b = decTable[base64Str.charCodeAt(i)];
        if (b === undefined) {
            // noinspection FallThroughInSwitchStatementJS
            switch (base64Str[i]) {
                case '=':
                    groupPos = 0; // reset state when padding found
                case '\n':
                case '\r':
                case '\t':
                case ' ':
                    continue; // skip white-space, and padding
                default:
                    throw Error(`invalid base64 string.`);
            }
        }
        switch (groupPos) {
            case 0:
                p = b;
                groupPos = 1;
                break;
            case 1:
                bytes[bytePos++] = p << 2 | (b & 48) >> 4;
                p = b;
                groupPos = 2;
                break;
            case 2:
                bytes[bytePos++] = (p & 15) << 4 | (b & 60) >> 2;
                p = b;
                groupPos = 3;
                break;
            case 3:
                bytes[bytePos++] = (p & 3) << 6 | b;
                groupPos = 0;
                break;
        }
    }
    if (groupPos == 1)
        throw Error(`invalid base64 string.`);
    return bytes.subarray(0, bytePos);
}
/**
 * Encodes a byte array to a base64 string.
 * Adds padding at the end.
 * Does not insert newlines.
 */
function base64encode(bytes) {
    let base64 = '', groupPos = 0, // position in base64 group
    b, // current byte
    p = 0; // carry over from previous byte
    for (let i = 0; i < bytes.length; i++) {
        b = bytes[i];
        switch (groupPos) {
            case 0:
                base64 += encTable[b >> 2];
                p = (b & 3) << 4;
                groupPos = 1;
                break;
            case 1:
                base64 += encTable[p | b >> 4];
                p = (b & 15) << 2;
                groupPos = 2;
                break;
            case 2:
                base64 += encTable[p | b >> 6];
                base64 += encTable[b & 63];
                groupPos = 0;
                break;
        }
    }
    // padding required?
    if (groupPos) {
        base64 += encTable[p];
        base64 += '=';
        if (groupPos == 1)
            base64 += '=';
    }
    return base64;
}

/**
 * This handler implements the default behaviour for unknown fields.
 * When reading data, unknown fields are stored on the message, in a
 * symbol property.
 * When writing data, the symbol property is queried and unknown fields
 * are serialized into the output again.
 */
var UnknownFieldHandler;
(function (UnknownFieldHandler) {
    /**
     * The symbol used to store unknown fields for a message.
     * The property must conform to `UnknownFieldContainer`.
     */
    UnknownFieldHandler.symbol = Symbol.for("protobuf-ts/unknown");
    /**
     * Store an unknown field during binary read directly on the message.
     * This method is compatible with `BinaryReadOptions.readUnknownField`.
     */
    UnknownFieldHandler.onRead = (typeName, message, fieldNo, wireType, data) => {
        let container = is(message) ? message[UnknownFieldHandler.symbol] : message[UnknownFieldHandler.symbol] = [];
        container.push({ no: fieldNo, wireType, data });
    };
    /**
     * Write unknown fields stored for the message to the writer.
     * This method is compatible with `BinaryWriteOptions.writeUnknownFields`.
     */
    UnknownFieldHandler.onWrite = (typeName, message, writer) => {
        for (let { no, wireType, data } of UnknownFieldHandler.list(message))
            writer.tag(no, wireType).raw(data);
    };
    /**
     * List unknown fields stored for the message.
     * Note that there may be multiples fields with the same number.
     */
    UnknownFieldHandler.list = (message, fieldNo) => {
        if (is(message)) {
            let all = message[UnknownFieldHandler.symbol];
            return fieldNo ? all.filter(uf => uf.no == fieldNo) : all;
        }
        return [];
    };
    /**
     * Returns the last unknown field by field number.
     */
    UnknownFieldHandler.last = (message, fieldNo) => UnknownFieldHandler.list(message, fieldNo).slice(-1)[0];
    const is = (message) => message && Array.isArray(message[UnknownFieldHandler.symbol]);
})(UnknownFieldHandler || (UnknownFieldHandler = {}));
/**
 * Protobuf binary format wire types.
 *
 * A wire type provides just enough information to find the length of the
 * following value.
 *
 * See https://developers.google.com/protocol-buffers/docs/encoding#structure
 */
var WireType;
(function (WireType) {
    /**
     * Used for int32, int64, uint32, uint64, sint32, sint64, bool, enum
     */
    WireType[WireType["Varint"] = 0] = "Varint";
    /**
     * Used for fixed64, sfixed64, double.
     * Always 8 bytes with little-endian byte order.
     */
    WireType[WireType["Bit64"] = 1] = "Bit64";
    /**
     * Used for string, bytes, embedded messages, packed repeated fields
     *
     * Only repeated numeric types (types which use the varint, 32-bit,
     * or 64-bit wire types) can be packed. In proto3, such fields are
     * packed by default.
     */
    WireType[WireType["LengthDelimited"] = 2] = "LengthDelimited";
    /**
     * Used for groups
     * @deprecated
     */
    WireType[WireType["StartGroup"] = 3] = "StartGroup";
    /**
     * Used for groups
     * @deprecated
     */
    WireType[WireType["EndGroup"] = 4] = "EndGroup";
    /**
     * Used for fixed32, sfixed32, float.
     * Always 4 bytes with little-endian byte order.
     */
    WireType[WireType["Bit32"] = 5] = "Bit32";
})(WireType || (WireType = {}));

// Copyright 2008 Google Inc.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
// * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Code generated by the Protocol Buffer compiler is owned by the owner
// of the input file used when generating it.  This code is not
// standalone and requires a support library to be linked with it.  This
// support library is itself covered by the above license.
/**
 * Read a 64 bit varint as two JS numbers.
 *
 * Returns tuple:
 * [0]: low bits
 * [0]: high bits
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/buffer_decoder.js#L175
 */
function varint64read() {
    let lowBits = 0;
    let highBits = 0;
    for (let shift = 0; shift < 28; shift += 7) {
        let b = this.buf[this.pos++];
        lowBits |= (b & 0x7F) << shift;
        if ((b & 0x80) == 0) {
            this.assertBounds();
            return [lowBits, highBits];
        }
    }
    let middleByte = this.buf[this.pos++];
    // last four bits of the first 32 bit number
    lowBits |= (middleByte & 0x0F) << 28;
    // 3 upper bits are part of the next 32 bit number
    highBits = (middleByte & 0x70) >> 4;
    if ((middleByte & 0x80) == 0) {
        this.assertBounds();
        return [lowBits, highBits];
    }
    for (let shift = 3; shift <= 31; shift += 7) {
        let b = this.buf[this.pos++];
        highBits |= (b & 0x7F) << shift;
        if ((b & 0x80) == 0) {
            this.assertBounds();
            return [lowBits, highBits];
        }
    }
    throw new Error('invalid varint');
}
/**
 * Write a 64 bit varint, given as two JS numbers, to the given bytes array.
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/writer.js#L344
 */
function varint64write(lo, hi, bytes) {
    for (let i = 0; i < 28; i = i + 7) {
        const shift = lo >>> i;
        const hasNext = !((shift >>> 7) == 0 && hi == 0);
        const byte = (hasNext ? shift | 0x80 : shift) & 0xFF;
        bytes.push(byte);
        if (!hasNext) {
            return;
        }
    }
    const splitBits = ((lo >>> 28) & 0x0F) | ((hi & 0x07) << 4);
    const hasMoreBits = !((hi >> 3) == 0);
    bytes.push((hasMoreBits ? splitBits | 0x80 : splitBits) & 0xFF);
    if (!hasMoreBits) {
        return;
    }
    for (let i = 3; i < 31; i = i + 7) {
        const shift = hi >>> i;
        const hasNext = !((shift >>> 7) == 0);
        const byte = (hasNext ? shift | 0x80 : shift) & 0xFF;
        bytes.push(byte);
        if (!hasNext) {
            return;
        }
    }
    bytes.push((hi >>> 31) & 0x01);
}
// constants for binary math
const TWO_PWR_32_DBL$1 = (1 << 16) * (1 << 16);
/**
 * Parse decimal string of 64 bit integer value as two JS numbers.
 *
 * Returns tuple:
 * [0]: minus sign?
 * [1]: low bits
 * [2]: high bits
 *
 * Copyright 2008 Google Inc.
 */
function int64fromString(dec) {
    // Check for minus sign.
    let minus = dec[0] == '-';
    if (minus)
        dec = dec.slice(1);
    // Work 6 decimal digits at a time, acting like we're converting base 1e6
    // digits to binary. This is safe to do with floating point math because
    // Number.isSafeInteger(ALL_32_BITS * 1e6) == true.
    const base = 1e6;
    let lowBits = 0;
    let highBits = 0;
    function add1e6digit(begin, end) {
        // Note: Number('') is 0.
        const digit1e6 = Number(dec.slice(begin, end));
        highBits *= base;
        lowBits = lowBits * base + digit1e6;
        // Carry bits from lowBits to highBits
        if (lowBits >= TWO_PWR_32_DBL$1) {
            highBits = highBits + ((lowBits / TWO_PWR_32_DBL$1) | 0);
            lowBits = lowBits % TWO_PWR_32_DBL$1;
        }
    }
    add1e6digit(-24, -18);
    add1e6digit(-18, -12);
    add1e6digit(-12, -6);
    add1e6digit(-6);
    return [minus, lowBits, highBits];
}
/**
 * Format 64 bit integer value (as two JS numbers) to decimal string.
 *
 * Copyright 2008 Google Inc.
 */
function int64toString(bitsLow, bitsHigh) {
    // Skip the expensive conversion if the number is small enough to use the
    // built-in conversions.
    if ((bitsHigh >>> 0) <= 0x1FFFFF) {
        return '' + (TWO_PWR_32_DBL$1 * bitsHigh + (bitsLow >>> 0));
    }
    // What this code is doing is essentially converting the input number from
    // base-2 to base-1e7, which allows us to represent the 64-bit range with
    // only 3 (very large) digits. Those digits are then trivial to convert to
    // a base-10 string.
    // The magic numbers used here are -
    // 2^24 = 16777216 = (1,6777216) in base-1e7.
    // 2^48 = 281474976710656 = (2,8147497,6710656) in base-1e7.
    // Split 32:32 representation into 16:24:24 representation so our
    // intermediate digits don't overflow.
    let low = bitsLow & 0xFFFFFF;
    let mid = (((bitsLow >>> 24) | (bitsHigh << 8)) >>> 0) & 0xFFFFFF;
    let high = (bitsHigh >> 16) & 0xFFFF;
    // Assemble our three base-1e7 digits, ignoring carries. The maximum
    // value in a digit at this step is representable as a 48-bit integer, which
    // can be stored in a 64-bit floating point number.
    let digitA = low + (mid * 6777216) + (high * 6710656);
    let digitB = mid + (high * 8147497);
    let digitC = (high * 2);
    // Apply carries from A to B and from B to C.
    let base = 10000000;
    if (digitA >= base) {
        digitB += Math.floor(digitA / base);
        digitA %= base;
    }
    if (digitB >= base) {
        digitC += Math.floor(digitB / base);
        digitB %= base;
    }
    // Convert base-1e7 digits to base-10, with optional leading zeroes.
    function decimalFrom1e7(digit1e7, needLeadingZeros) {
        let partial = digit1e7 ? String(digit1e7) : '';
        if (needLeadingZeros) {
            return '0000000'.slice(partial.length) + partial;
        }
        return partial;
    }
    return decimalFrom1e7(digitC, /*needLeadingZeros=*/ 0) +
        decimalFrom1e7(digitB, /*needLeadingZeros=*/ digitC) +
        // If the final 1e7 digit didn't need leading zeros, we would have
        // returned via the trivial code path at the top.
        decimalFrom1e7(digitA, /*needLeadingZeros=*/ 1);
}
/**
 * Write a 32 bit varint, signed or unsigned. Same as `varint64write(0, value, bytes)`
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/1b18833f4f2a2f681f4e4a25cdf3b0a43115ec26/js/binary/encoder.js#L144
 */
function varint32write(value, bytes) {
    if (value >= 0) {
        // write value as varint 32
        while (value > 0x7f) {
            bytes.push((value & 0x7f) | 0x80);
            value = value >>> 7;
        }
        bytes.push(value);
    }
    else {
        for (let i = 0; i < 9; i++) {
            bytes.push(value & 127 | 128);
            value = value >> 7;
        }
        bytes.push(1);
    }
}
/**
 * Read an unsigned 32 bit varint.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/buffer_decoder.js#L220
 */
function varint32read() {
    let b = this.buf[this.pos++];
    let result = b & 0x7F;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 7;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 14;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 21;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    // Extract only last 4 bits
    b = this.buf[this.pos++];
    result |= (b & 0x0F) << 28;
    for (let readBytes = 5; ((b & 0x80) !== 0) && readBytes < 10; readBytes++)
        b = this.buf[this.pos++];
    if ((b & 0x80) != 0)
        throw new Error('invalid varint');
    this.assertBounds();
    // Result can have 32 bits, convert it to unsigned
    return result >>> 0;
}

let BI;
function detectBi() {
    const dv = new DataView(new ArrayBuffer(8));
    const ok = globalThis.BigInt !== undefined
        && typeof dv.getBigInt64 === "function"
        && typeof dv.getBigUint64 === "function"
        && typeof dv.setBigInt64 === "function"
        && typeof dv.setBigUint64 === "function";
    BI = ok ? {
        MIN: BigInt("-9223372036854775808"),
        MAX: BigInt("9223372036854775807"),
        UMIN: BigInt("0"),
        UMAX: BigInt("18446744073709551615"),
        C: BigInt,
        V: dv,
    } : undefined;
}
detectBi();
function assertBi(bi) {
    if (!bi)
        throw new Error("BigInt unavailable, see https://github.com/timostamm/protobuf-ts/blob/v1.0.8/MANUAL.md#bigint-support");
}
// used to validate from(string) input (when bigint is unavailable)
const RE_DECIMAL_STR = /^-?[0-9]+$/;
// constants for binary math
const TWO_PWR_32_DBL = 0x100000000;
const HALF_2_PWR_32 = 0x080000000;
// base class for PbLong and PbULong provides shared code
class SharedPbLong {
    /**
     * Create a new instance with the given bits.
     */
    constructor(lo, hi) {
        this.lo = lo | 0;
        this.hi = hi | 0;
    }
    /**
     * Is this instance equal to 0?
     */
    isZero() {
        return this.lo == 0 && this.hi == 0;
    }
    /**
     * Convert to a native number.
     */
    toNumber() {
        let result = this.hi * TWO_PWR_32_DBL + (this.lo >>> 0);
        if (!Number.isSafeInteger(result))
            throw new Error("cannot convert to safe number");
        return result;
    }
}
/**
 * 64-bit unsigned integer as two 32-bit values.
 * Converts between `string`, `number` and `bigint` representations.
 */
class PbULong extends SharedPbLong {
    /**
     * Create instance from a `string`, `number` or `bigint`.
     */
    static from(value) {
        if (BI)
            // noinspection FallThroughInSwitchStatementJS
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    if (value == "")
                        throw new Error('string is no integer');
                    value = BI.C(value);
                case "number":
                    if (value === 0)
                        return this.ZERO;
                    value = BI.C(value);
                case "bigint":
                    if (!value)
                        return this.ZERO;
                    if (value < BI.UMIN)
                        throw new Error('signed value for ulong');
                    if (value > BI.UMAX)
                        throw new Error('ulong too large');
                    BI.V.setBigUint64(0, value, true);
                    return new PbULong(BI.V.getInt32(0, true), BI.V.getInt32(4, true));
            }
        else
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    value = value.trim();
                    if (!RE_DECIMAL_STR.test(value))
                        throw new Error('string is no integer');
                    let [minus, lo, hi] = int64fromString(value);
                    if (minus)
                        throw new Error('signed value for ulong');
                    return new PbULong(lo, hi);
                case "number":
                    if (value == 0)
                        return this.ZERO;
                    if (!Number.isSafeInteger(value))
                        throw new Error('number is no integer');
                    if (value < 0)
                        throw new Error('signed value for ulong');
                    return new PbULong(value, value / TWO_PWR_32_DBL);
            }
        throw new Error('unknown value ' + typeof value);
    }
    /**
     * Convert to decimal string.
     */
    toString() {
        return BI ? this.toBigInt().toString() : int64toString(this.lo, this.hi);
    }
    /**
     * Convert to native bigint.
     */
    toBigInt() {
        assertBi(BI);
        BI.V.setInt32(0, this.lo, true);
        BI.V.setInt32(4, this.hi, true);
        return BI.V.getBigUint64(0, true);
    }
}
/**
 * ulong 0 singleton.
 */
PbULong.ZERO = new PbULong(0, 0);
/**
 * 64-bit signed integer as two 32-bit values.
 * Converts between `string`, `number` and `bigint` representations.
 */
class PbLong extends SharedPbLong {
    /**
     * Create instance from a `string`, `number` or `bigint`.
     */
    static from(value) {
        if (BI)
            // noinspection FallThroughInSwitchStatementJS
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    if (value == "")
                        throw new Error('string is no integer');
                    value = BI.C(value);
                case "number":
                    if (value === 0)
                        return this.ZERO;
                    value = BI.C(value);
                case "bigint":
                    if (!value)
                        return this.ZERO;
                    if (value < BI.MIN)
                        throw new Error('signed long too small');
                    if (value > BI.MAX)
                        throw new Error('signed long too large');
                    BI.V.setBigInt64(0, value, true);
                    return new PbLong(BI.V.getInt32(0, true), BI.V.getInt32(4, true));
            }
        else
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    value = value.trim();
                    if (!RE_DECIMAL_STR.test(value))
                        throw new Error('string is no integer');
                    let [minus, lo, hi] = int64fromString(value);
                    if (minus) {
                        if (hi > HALF_2_PWR_32 || (hi == HALF_2_PWR_32 && lo != 0))
                            throw new Error('signed long too small');
                    }
                    else if (hi >= HALF_2_PWR_32)
                        throw new Error('signed long too large');
                    let pbl = new PbLong(lo, hi);
                    return minus ? pbl.negate() : pbl;
                case "number":
                    if (value == 0)
                        return this.ZERO;
                    if (!Number.isSafeInteger(value))
                        throw new Error('number is no integer');
                    return value > 0
                        ? new PbLong(value, value / TWO_PWR_32_DBL)
                        : new PbLong(-value, -value / TWO_PWR_32_DBL).negate();
            }
        throw new Error('unknown value ' + typeof value);
    }
    /**
     * Do we have a minus sign?
     */
    isNegative() {
        return (this.hi & HALF_2_PWR_32) !== 0;
    }
    /**
     * Negate two's complement.
     * Invert all the bits and add one to the result.
     */
    negate() {
        let hi = ~this.hi, lo = this.lo;
        if (lo)
            lo = ~lo + 1;
        else
            hi += 1;
        return new PbLong(lo, hi);
    }
    /**
     * Convert to decimal string.
     */
    toString() {
        if (BI)
            return this.toBigInt().toString();
        if (this.isNegative()) {
            let n = this.negate();
            return '-' + int64toString(n.lo, n.hi);
        }
        return int64toString(this.lo, this.hi);
    }
    /**
     * Convert to native bigint.
     */
    toBigInt() {
        assertBi(BI);
        BI.V.setInt32(0, this.lo, true);
        BI.V.setInt32(4, this.hi, true);
        return BI.V.getBigInt64(0, true);
    }
}
/**
 * long 0 singleton.
 */
PbLong.ZERO = new PbLong(0, 0);

const defaultsRead$1 = {
    readUnknownField: true,
    readerFactory: bytes => new BinaryReader(bytes),
};
/**
 * Make options for reading binary data form partial options.
 */
function binaryReadOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsRead$1), options) : defaultsRead$1;
}
class BinaryReader {
    constructor(buf, textDecoder) {
        this.varint64 = varint64read; // dirty cast for `this`
        /**
         * Read a `uint32` field, an unsigned 32 bit varint.
         */
        this.uint32 = varint32read; // dirty cast for `this` and access to protected `buf`
        this.buf = buf;
        this.len = buf.length;
        this.pos = 0;
        this.view = new DataView(buf.buffer, buf.byteOffset, buf.byteLength);
        this.textDecoder = textDecoder !== null && textDecoder !== void 0 ? textDecoder : new TextDecoder("utf-8", {
            fatal: true,
            ignoreBOM: true,
        });
    }
    /**
     * Reads a tag - field number and wire type.
     */
    tag() {
        let tag = this.uint32(), fieldNo = tag >>> 3, wireType = tag & 7;
        if (fieldNo <= 0 || wireType < 0 || wireType > 5)
            throw new Error("illegal tag: field no " + fieldNo + " wire type " + wireType);
        return [fieldNo, wireType];
    }
    /**
     * Skip one element on the wire and return the skipped data.
     * Supports WireType.StartGroup since v2.0.0-alpha.23.
     */
    skip(wireType) {
        let start = this.pos;
        // noinspection FallThroughInSwitchStatementJS
        switch (wireType) {
            case WireType.Varint:
                while (this.buf[this.pos++] & 0x80) {
                    // ignore
                }
                break;
            case WireType.Bit64:
                this.pos += 4;
            case WireType.Bit32:
                this.pos += 4;
                break;
            case WireType.LengthDelimited:
                let len = this.uint32();
                this.pos += len;
                break;
            case WireType.StartGroup:
                // From descriptor.proto: Group type is deprecated, not supported in proto3.
                // But we must still be able to parse and treat as unknown.
                let t;
                while ((t = this.tag()[1]) !== WireType.EndGroup) {
                    this.skip(t);
                }
                break;
            default:
                throw new Error("cant skip wire type " + wireType);
        }
        this.assertBounds();
        return this.buf.subarray(start, this.pos);
    }
    /**
     * Throws error if position in byte array is out of range.
     */
    assertBounds() {
        if (this.pos > this.len)
            throw new RangeError("premature EOF");
    }
    /**
     * Read a `int32` field, a signed 32 bit varint.
     */
    int32() {
        return this.uint32() | 0;
    }
    /**
     * Read a `sint32` field, a signed, zigzag-encoded 32-bit varint.
     */
    sint32() {
        let zze = this.uint32();
        // decode zigzag
        return (zze >>> 1) ^ -(zze & 1);
    }
    /**
     * Read a `int64` field, a signed 64-bit varint.
     */
    int64() {
        return new PbLong(...this.varint64());
    }
    /**
     * Read a `uint64` field, an unsigned 64-bit varint.
     */
    uint64() {
        return new PbULong(...this.varint64());
    }
    /**
     * Read a `sint64` field, a signed, zig-zag-encoded 64-bit varint.
     */
    sint64() {
        let [lo, hi] = this.varint64();
        // decode zig zag
        let s = -(lo & 1);
        lo = ((lo >>> 1 | (hi & 1) << 31) ^ s);
        hi = (hi >>> 1 ^ s);
        return new PbLong(lo, hi);
    }
    /**
     * Read a `bool` field, a variant.
     */
    bool() {
        let [lo, hi] = this.varint64();
        return lo !== 0 || hi !== 0;
    }
    /**
     * Read a `fixed32` field, an unsigned, fixed-length 32-bit integer.
     */
    fixed32() {
        return this.view.getUint32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `sfixed32` field, a signed, fixed-length 32-bit integer.
     */
    sfixed32() {
        return this.view.getInt32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `fixed64` field, an unsigned, fixed-length 64 bit integer.
     */
    fixed64() {
        return new PbULong(this.sfixed32(), this.sfixed32());
    }
    /**
     * Read a `fixed64` field, a signed, fixed-length 64-bit integer.
     */
    sfixed64() {
        return new PbLong(this.sfixed32(), this.sfixed32());
    }
    /**
     * Read a `float` field, 32-bit floating point number.
     */
    float() {
        return this.view.getFloat32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `double` field, a 64-bit floating point number.
     */
    double() {
        return this.view.getFloat64((this.pos += 8) - 8, true);
    }
    /**
     * Read a `bytes` field, length-delimited arbitrary data.
     */
    bytes() {
        let len = this.uint32();
        let start = this.pos;
        this.pos += len;
        this.assertBounds();
        return this.buf.subarray(start, start + len);
    }
    /**
     * Read a `string` field, length-delimited data converted to UTF-8 text.
     */
    string() {
        return this.textDecoder.decode(this.bytes());
    }
}

/**
 * assert that condition is true or throw error (with message)
 */
function assert(condition, msg) {
    if (!condition) {
        throw new Error(msg);
    }
}
const FLOAT32_MAX = 3.4028234663852886e+38, FLOAT32_MIN = -34028234663852886e22, UINT32_MAX = 0xFFFFFFFF, INT32_MAX = 0X7FFFFFFF, INT32_MIN = -2147483648;
function assertInt32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid int 32: ' + typeof arg);
    if (!Number.isInteger(arg) || arg > INT32_MAX || arg < INT32_MIN)
        throw new Error('invalid int 32: ' + arg);
}
function assertUInt32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid uint 32: ' + typeof arg);
    if (!Number.isInteger(arg) || arg > UINT32_MAX || arg < 0)
        throw new Error('invalid uint 32: ' + arg);
}
function assertFloat32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid float 32: ' + typeof arg);
    if (!Number.isFinite(arg))
        return;
    if (arg > FLOAT32_MAX || arg < FLOAT32_MIN)
        throw new Error('invalid float 32: ' + arg);
}

const defaultsWrite$1 = {
    writeUnknownFields: true,
    writerFactory: () => new BinaryWriter(),
};
/**
 * Make options for writing binary data form partial options.
 */
function binaryWriteOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsWrite$1), options) : defaultsWrite$1;
}
class BinaryWriter {
    constructor(textEncoder) {
        /**
         * Previous fork states.
         */
        this.stack = [];
        this.textEncoder = textEncoder !== null && textEncoder !== void 0 ? textEncoder : new TextEncoder();
        this.chunks = [];
        this.buf = [];
    }
    /**
     * Return all bytes written and reset this writer.
     */
    finish() {
        this.chunks.push(new Uint8Array(this.buf)); // flush the buffer
        let len = 0;
        for (let i = 0; i < this.chunks.length; i++)
            len += this.chunks[i].length;
        let bytes = new Uint8Array(len);
        let offset = 0;
        for (let i = 0; i < this.chunks.length; i++) {
            bytes.set(this.chunks[i], offset);
            offset += this.chunks[i].length;
        }
        this.chunks = [];
        return bytes;
    }
    /**
     * Start a new fork for length-delimited data like a message
     * or a packed repeated field.
     *
     * Must be joined later with `join()`.
     */
    fork() {
        this.stack.push({ chunks: this.chunks, buf: this.buf });
        this.chunks = [];
        this.buf = [];
        return this;
    }
    /**
     * Join the last fork. Write its length and bytes, then
     * return to the previous state.
     */
    join() {
        // get chunk of fork
        let chunk = this.finish();
        // restore previous state
        let prev = this.stack.pop();
        if (!prev)
            throw new Error('invalid state, fork stack empty');
        this.chunks = prev.chunks;
        this.buf = prev.buf;
        // write length of chunk as varint
        this.uint32(chunk.byteLength);
        return this.raw(chunk);
    }
    /**
     * Writes a tag (field number and wire type).
     *
     * Equivalent to `uint32( (fieldNo << 3 | type) >>> 0 )`.
     *
     * Generated code should compute the tag ahead of time and call `uint32()`.
     */
    tag(fieldNo, type) {
        return this.uint32((fieldNo << 3 | type) >>> 0);
    }
    /**
     * Write a chunk of raw bytes.
     */
    raw(chunk) {
        if (this.buf.length) {
            this.chunks.push(new Uint8Array(this.buf));
            this.buf = [];
        }
        this.chunks.push(chunk);
        return this;
    }
    /**
     * Write a `uint32` value, an unsigned 32 bit varint.
     */
    uint32(value) {
        assertUInt32(value);
        // write value as varint 32, inlined for speed
        while (value > 0x7f) {
            this.buf.push((value & 0x7f) | 0x80);
            value = value >>> 7;
        }
        this.buf.push(value);
        return this;
    }
    /**
     * Write a `int32` value, a signed 32 bit varint.
     */
    int32(value) {
        assertInt32(value);
        varint32write(value, this.buf);
        return this;
    }
    /**
     * Write a `bool` value, a variant.
     */
    bool(value) {
        this.buf.push(value ? 1 : 0);
        return this;
    }
    /**
     * Write a `bytes` value, length-delimited arbitrary data.
     */
    bytes(value) {
        this.uint32(value.byteLength); // write length of chunk as varint
        return this.raw(value);
    }
    /**
     * Write a `string` value, length-delimited data converted to UTF-8 text.
     */
    string(value) {
        let chunk = this.textEncoder.encode(value);
        this.uint32(chunk.byteLength); // write length of chunk as varint
        return this.raw(chunk);
    }
    /**
     * Write a `float` value, 32-bit floating point number.
     */
    float(value) {
        assertFloat32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setFloat32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `double` value, a 64-bit floating point number.
     */
    double(value) {
        let chunk = new Uint8Array(8);
        new DataView(chunk.buffer).setFloat64(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `fixed32` value, an unsigned, fixed-length 32-bit integer.
     */
    fixed32(value) {
        assertUInt32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setUint32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `sfixed32` value, a signed, fixed-length 32-bit integer.
     */
    sfixed32(value) {
        assertInt32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setInt32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `sint32` value, a signed, zigzag-encoded 32-bit varint.
     */
    sint32(value) {
        assertInt32(value);
        // zigzag encode
        value = ((value << 1) ^ (value >> 31)) >>> 0;
        varint32write(value, this.buf);
        return this;
    }
    /**
     * Write a `fixed64` value, a signed, fixed-length 64-bit integer.
     */
    sfixed64(value) {
        let chunk = new Uint8Array(8);
        let view = new DataView(chunk.buffer);
        let long = PbLong.from(value);
        view.setInt32(0, long.lo, true);
        view.setInt32(4, long.hi, true);
        return this.raw(chunk);
    }
    /**
     * Write a `fixed64` value, an unsigned, fixed-length 64 bit integer.
     */
    fixed64(value) {
        let chunk = new Uint8Array(8);
        let view = new DataView(chunk.buffer);
        let long = PbULong.from(value);
        view.setInt32(0, long.lo, true);
        view.setInt32(4, long.hi, true);
        return this.raw(chunk);
    }
    /**
     * Write a `int64` value, a signed 64-bit varint.
     */
    int64(value) {
        let long = PbLong.from(value);
        varint64write(long.lo, long.hi, this.buf);
        return this;
    }
    /**
     * Write a `sint64` value, a signed, zig-zag-encoded 64-bit varint.
     */
    sint64(value) {
        let long = PbLong.from(value), 
        // zigzag encode
        sign = long.hi >> 31, lo = (long.lo << 1) ^ sign, hi = ((long.hi << 1) | (long.lo >>> 31)) ^ sign;
        varint64write(lo, hi, this.buf);
        return this;
    }
    /**
     * Write a `uint64` value, an unsigned 64-bit varint.
     */
    uint64(value) {
        let long = PbULong.from(value);
        varint64write(long.lo, long.hi, this.buf);
        return this;
    }
}

const defaultsWrite = {
    emitDefaultValues: false,
    enumAsInteger: false,
    useProtoFieldName: false,
    prettySpaces: 0,
}, defaultsRead = {
    ignoreUnknownFields: false,
};
/**
 * Make options for reading JSON data from partial options.
 */
function jsonReadOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsRead), options) : defaultsRead;
}
/**
 * Make options for writing JSON data from partial options.
 */
function jsonWriteOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsWrite), options) : defaultsWrite;
}

/**
 * The symbol used as a key on message objects to store the message type.
 *
 * Note that this is an experimental feature - it is here to stay, but
 * implementation details may change without notice.
 */
const MESSAGE_TYPE = Symbol.for("protobuf-ts/message-type");

/**
 * Converts snake_case to lowerCamelCase.
 *
 * Should behave like protoc:
 * https://github.com/protocolbuffers/protobuf/blob/e8ae137c96444ea313485ed1118c5e43b2099cf1/src/google/protobuf/compiler/java/java_helpers.cc#L118
 */
function lowerCamelCase(snakeCase) {
    let capNext = false;
    const sb = [];
    for (let i = 0; i < snakeCase.length; i++) {
        let next = snakeCase.charAt(i);
        if (next == '_') {
            capNext = true;
        }
        else if (/\d/.test(next)) {
            sb.push(next);
            capNext = true;
        }
        else if (capNext) {
            sb.push(next.toUpperCase());
            capNext = false;
        }
        else if (i == 0) {
            sb.push(next.toLowerCase());
        }
        else {
            sb.push(next);
        }
    }
    return sb.join('');
}

/**
 * Scalar value types. This is a subset of field types declared by protobuf
 * enum google.protobuf.FieldDescriptorProto.Type The types GROUP and MESSAGE
 * are omitted, but the numerical values are identical.
 */
var ScalarType;
(function (ScalarType) {
    // 0 is reserved for errors.
    // Order is weird for historical reasons.
    ScalarType[ScalarType["DOUBLE"] = 1] = "DOUBLE";
    ScalarType[ScalarType["FLOAT"] = 2] = "FLOAT";
    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
    // negative values are likely.
    ScalarType[ScalarType["INT64"] = 3] = "INT64";
    ScalarType[ScalarType["UINT64"] = 4] = "UINT64";
    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
    // negative values are likely.
    ScalarType[ScalarType["INT32"] = 5] = "INT32";
    ScalarType[ScalarType["FIXED64"] = 6] = "FIXED64";
    ScalarType[ScalarType["FIXED32"] = 7] = "FIXED32";
    ScalarType[ScalarType["BOOL"] = 8] = "BOOL";
    ScalarType[ScalarType["STRING"] = 9] = "STRING";
    // Tag-delimited aggregate.
    // Group type is deprecated and not supported in proto3. However, Proto3
    // implementations should still be able to parse the group wire format and
    // treat group fields as unknown fields.
    // TYPE_GROUP = 10,
    // TYPE_MESSAGE = 11,  // Length-delimited aggregate.
    // New in version 2.
    ScalarType[ScalarType["BYTES"] = 12] = "BYTES";
    ScalarType[ScalarType["UINT32"] = 13] = "UINT32";
    // TYPE_ENUM = 14,
    ScalarType[ScalarType["SFIXED32"] = 15] = "SFIXED32";
    ScalarType[ScalarType["SFIXED64"] = 16] = "SFIXED64";
    ScalarType[ScalarType["SINT32"] = 17] = "SINT32";
    ScalarType[ScalarType["SINT64"] = 18] = "SINT64";
})(ScalarType || (ScalarType = {}));
/**
 * JavaScript representation of 64 bit integral types. Equivalent to the
 * field option "jstype".
 *
 * By default, protobuf-ts represents 64 bit types as `bigint`.
 *
 * You can change the default behaviour by enabling the plugin parameter
 * `long_type_string`, which will represent 64 bit types as `string`.
 *
 * Alternatively, you can change the behaviour for individual fields
 * with the field option "jstype":
 *
 * ```protobuf
 * uint64 my_field = 1 [jstype = JS_STRING];
 * uint64 other_field = 2 [jstype = JS_NUMBER];
 * ```
 */
var LongType;
(function (LongType) {
    /**
     * Use JavaScript `bigint`.
     *
     * Field option `[jstype = JS_NORMAL]`.
     */
    LongType[LongType["BIGINT"] = 0] = "BIGINT";
    /**
     * Use JavaScript `string`.
     *
     * Field option `[jstype = JS_STRING]`.
     */
    LongType[LongType["STRING"] = 1] = "STRING";
    /**
     * Use JavaScript `number`.
     *
     * Large values will loose precision.
     *
     * Field option `[jstype = JS_NUMBER]`.
     */
    LongType[LongType["NUMBER"] = 2] = "NUMBER";
})(LongType || (LongType = {}));
/**
 * Protobuf 2.1.0 introduced packed repeated fields.
 * Setting the field option `[packed = true]` enables packing.
 *
 * In proto3, all repeated fields are packed by default.
 * Setting the field option `[packed = false]` disables packing.
 *
 * Packed repeated fields are encoded with a single tag,
 * then a length-delimiter, then the element values.
 *
 * Unpacked repeated fields are encoded with a tag and
 * value for each element.
 *
 * `bytes` and `string` cannot be packed.
 */
var RepeatType;
(function (RepeatType) {
    /**
     * The field is not repeated.
     */
    RepeatType[RepeatType["NO"] = 0] = "NO";
    /**
     * The field is repeated and should be packed.
     * Invalid for `bytes` and `string`, they cannot be packed.
     */
    RepeatType[RepeatType["PACKED"] = 1] = "PACKED";
    /**
     * The field is repeated but should not be packed.
     * The only valid repeat type for repeated `bytes` and `string`.
     */
    RepeatType[RepeatType["UNPACKED"] = 2] = "UNPACKED";
})(RepeatType || (RepeatType = {}));
/**
 * Turns PartialFieldInfo into FieldInfo.
 */
function normalizeFieldInfo(field) {
    var _a, _b, _c, _d;
    field.localName = (_a = field.localName) !== null && _a !== void 0 ? _a : lowerCamelCase(field.name);
    field.jsonName = (_b = field.jsonName) !== null && _b !== void 0 ? _b : lowerCamelCase(field.name);
    field.repeat = (_c = field.repeat) !== null && _c !== void 0 ? _c : RepeatType.NO;
    field.opt = (_d = field.opt) !== null && _d !== void 0 ? _d : (field.repeat ? false : field.oneof ? false : field.kind == "message");
    return field;
}

/**
 * Is the given value a valid oneof group?
 *
 * We represent protobuf `oneof` as algebraic data types (ADT) in generated
 * code. But when working with messages of unknown type, the ADT does not
 * help us.
 *
 * This type guard checks if the given object adheres to the ADT rules, which
 * are as follows:
 *
 * 1) Must be an object.
 *
 * 2) Must have a "oneofKind" discriminator property.
 *
 * 3) If "oneofKind" is `undefined`, no member field is selected. The object
 * must not have any other properties.
 *
 * 4) If "oneofKind" is a `string`, the member field with this name is
 * selected.
 *
 * 5) If a member field is selected, the object must have a second property
 * with this name. The property must not be `undefined`.
 *
 * 6) No extra properties are allowed. The object has either one property
 * (no selection) or two properties (selection).
 *
 */
function isOneofGroup(any) {
    if (typeof any != 'object' || any === null || !any.hasOwnProperty('oneofKind')) {
        return false;
    }
    switch (typeof any.oneofKind) {
        case "string":
            if (any[any.oneofKind] === undefined)
                return false;
            return Object.keys(any).length == 2;
        case "undefined":
            return Object.keys(any).length == 1;
        default:
            return false;
    }
}

// noinspection JSMethodCanBeStatic
class ReflectionTypeCheck {
    constructor(info) {
        var _a;
        this.fields = (_a = info.fields) !== null && _a !== void 0 ? _a : [];
    }
    prepare() {
        if (this.data)
            return;
        const req = [], known = [], oneofs = [];
        for (let field of this.fields) {
            if (field.oneof) {
                if (!oneofs.includes(field.oneof)) {
                    oneofs.push(field.oneof);
                    req.push(field.oneof);
                    known.push(field.oneof);
                }
            }
            else {
                known.push(field.localName);
                switch (field.kind) {
                    case "scalar":
                    case "enum":
                        if (!field.opt || field.repeat)
                            req.push(field.localName);
                        break;
                    case "message":
                        if (field.repeat)
                            req.push(field.localName);
                        break;
                    case "map":
                        req.push(field.localName);
                        break;
                }
            }
        }
        this.data = { req, known, oneofs: Object.values(oneofs) };
    }
    /**
     * Is the argument a valid message as specified by the
     * reflection information?
     *
     * Checks all field types recursively. The `depth`
     * specifies how deep into the structure the check will be.
     *
     * With a depth of 0, only the presence of fields
     * is checked.
     *
     * With a depth of 1 or more, the field types are checked.
     *
     * With a depth of 2 or more, the members of map, repeated
     * and message fields are checked.
     *
     * Message fields will be checked recursively with depth - 1.
     *
     * The number of map entries / repeated values being checked
     * is < depth.
     */
    is(message, depth, allowExcessProperties = false) {
        if (depth < 0)
            return true;
        if (message === null || message === undefined || typeof message != 'object')
            return false;
        this.prepare();
        let keys = Object.keys(message), data = this.data;
        // if a required field is missing in arg, this cannot be a T
        if (keys.length < data.req.length || data.req.some(n => !keys.includes(n)))
            return false;
        if (!allowExcessProperties) {
            // if the arg contains a key we dont know, this is not a literal T
            if (keys.some(k => !data.known.includes(k)))
                return false;
        }
        // "With a depth of 0, only the presence and absence of fields is checked."
        // "With a depth of 1 or more, the field types are checked."
        if (depth < 1) {
            return true;
        }
        // check oneof group
        for (const name of data.oneofs) {
            const group = message[name];
            if (!isOneofGroup(group))
                return false;
            if (group.oneofKind === undefined)
                continue;
            const field = this.fields.find(f => f.localName === group.oneofKind);
            if (!field)
                return false; // we found no field, but have a kind, something is wrong
            if (!this.field(group[group.oneofKind], field, allowExcessProperties, depth))
                return false;
        }
        // check types
        for (const field of this.fields) {
            if (field.oneof !== undefined)
                continue;
            if (!this.field(message[field.localName], field, allowExcessProperties, depth))
                return false;
        }
        return true;
    }
    field(arg, field, allowExcessProperties, depth) {
        let repeated = field.repeat;
        switch (field.kind) {
            case "scalar":
                if (arg === undefined)
                    return field.opt;
                if (repeated)
                    return this.scalars(arg, field.T, depth, field.L);
                return this.scalar(arg, field.T, field.L);
            case "enum":
                if (arg === undefined)
                    return field.opt;
                if (repeated)
                    return this.scalars(arg, ScalarType.INT32, depth);
                return this.scalar(arg, ScalarType.INT32);
            case "message":
                if (arg === undefined)
                    return true;
                if (repeated)
                    return this.messages(arg, field.T(), allowExcessProperties, depth);
                return this.message(arg, field.T(), allowExcessProperties, depth);
            case "map":
                if (typeof arg != 'object' || arg === null)
                    return false;
                if (depth < 2)
                    return true;
                if (!this.mapKeys(arg, field.K, depth))
                    return false;
                switch (field.V.kind) {
                    case "scalar":
                        return this.scalars(Object.values(arg), field.V.T, depth, field.V.L);
                    case "enum":
                        return this.scalars(Object.values(arg), ScalarType.INT32, depth);
                    case "message":
                        return this.messages(Object.values(arg), field.V.T(), allowExcessProperties, depth);
                }
                break;
        }
        return true;
    }
    message(arg, type, allowExcessProperties, depth) {
        if (allowExcessProperties) {
            return type.isAssignable(arg, depth);
        }
        return type.is(arg, depth);
    }
    messages(arg, type, allowExcessProperties, depth) {
        if (!Array.isArray(arg))
            return false;
        if (depth < 2)
            return true;
        if (allowExcessProperties) {
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!type.isAssignable(arg[i], depth - 1))
                    return false;
        }
        else {
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!type.is(arg[i], depth - 1))
                    return false;
        }
        return true;
    }
    scalar(arg, type, longType) {
        let argType = typeof arg;
        switch (type) {
            case ScalarType.UINT64:
            case ScalarType.FIXED64:
            case ScalarType.INT64:
            case ScalarType.SFIXED64:
            case ScalarType.SINT64:
                switch (longType) {
                    case LongType.BIGINT:
                        return argType == "bigint";
                    case LongType.NUMBER:
                        return argType == "number" && !isNaN(arg);
                    default:
                        return argType == "string";
                }
            case ScalarType.BOOL:
                return argType == 'boolean';
            case ScalarType.STRING:
                return argType == 'string';
            case ScalarType.BYTES:
                return arg instanceof Uint8Array;
            case ScalarType.DOUBLE:
            case ScalarType.FLOAT:
                return argType == 'number' && !isNaN(arg);
            default:
                // case ScalarType.UINT32:
                // case ScalarType.FIXED32:
                // case ScalarType.INT32:
                // case ScalarType.SINT32:
                // case ScalarType.SFIXED32:
                return argType == 'number' && Number.isInteger(arg);
        }
    }
    scalars(arg, type, depth, longType) {
        if (!Array.isArray(arg))
            return false;
        if (depth < 2)
            return true;
        if (Array.isArray(arg))
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!this.scalar(arg[i], type, longType))
                    return false;
        return true;
    }
    mapKeys(map, type, depth) {
        let keys = Object.keys(map);
        switch (type) {
            case ScalarType.INT32:
            case ScalarType.FIXED32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
            case ScalarType.UINT32:
                return this.scalars(keys.slice(0, depth).map(k => parseInt(k)), type, depth);
            case ScalarType.BOOL:
                return this.scalars(keys.slice(0, depth).map(k => k == 'true' ? true : k == 'false' ? false : k), type, depth);
            default:
                return this.scalars(keys, type, depth, LongType.STRING);
        }
    }
}

/**
 * Utility method to convert a PbLong or PbUlong to a JavaScript
 * representation during runtime.
 *
 * Works with generated field information, `undefined` is equivalent
 * to `STRING`.
 */
function reflectionLongConvert(long, type) {
    switch (type) {
        case LongType.BIGINT:
            return long.toBigInt();
        case LongType.NUMBER:
            return long.toNumber();
        default:
            // case undefined:
            // case LongType.STRING:
            return long.toString();
    }
}

/**
 * Reads proto3 messages in canonical JSON format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 */
class ReflectionJsonReader {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        var _a;
        if (this.fMap === undefined) {
            this.fMap = {};
            const fieldsInput = (_a = this.info.fields) !== null && _a !== void 0 ? _a : [];
            for (const field of fieldsInput) {
                this.fMap[field.name] = field;
                this.fMap[field.jsonName] = field;
                this.fMap[field.localName] = field;
            }
        }
    }
    // Cannot parse JSON <type of jsonValue> for <type name>#<fieldName>.
    assert(condition, fieldName, jsonValue) {
        if (!condition) {
            let what = typeofJsonValue(jsonValue);
            if (what == "number" || what == "boolean")
                what = jsonValue.toString();
            throw new Error(`Cannot parse JSON ${what} for ${this.info.typeName}#${fieldName}`);
        }
    }
    /**
     * Reads a message from canonical JSON format into the target message.
     *
     * Repeated fields are appended. Map entries are added, overwriting
     * existing keys.
     *
     * If a message field is already present, it will be merged with the
     * new data.
     */
    read(input, message, options) {
        this.prepare();
        const oneofsHandled = [];
        for (const [jsonKey, jsonValue] of Object.entries(input)) {
            const field = this.fMap[jsonKey];
            if (!field) {
                if (!options.ignoreUnknownFields)
                    throw new Error(`Found unknown field while reading ${this.info.typeName} from JSON format. JSON key: ${jsonKey}`);
                continue;
            }
            const localName = field.localName;
            // handle oneof ADT
            let target; // this will be the target for the field value, whether it is member of a oneof or not
            if (field.oneof) {
                if (jsonValue === null && (field.kind !== 'enum' || field.T()[0] !== 'google.protobuf.NullValue')) {
                    continue;
                }
                // since json objects are unordered by specification, it is not possible to take the last of multiple oneofs
                if (oneofsHandled.includes(field.oneof))
                    throw new Error(`Multiple members of the oneof group "${field.oneof}" of ${this.info.typeName} are present in JSON.`);
                oneofsHandled.push(field.oneof);
                target = message[field.oneof] = {
                    oneofKind: localName
                };
            }
            else {
                target = message;
            }
            // we have handled oneof above. we just have read the value into `target`.
            if (field.kind == 'map') {
                if (jsonValue === null) {
                    continue;
                }
                // check input
                this.assert(isJsonObject(jsonValue), field.name, jsonValue);
                // our target to put map entries into
                const fieldObj = target[localName];
                // read entries
                for (const [jsonObjKey, jsonObjValue] of Object.entries(jsonValue)) {
                    this.assert(jsonObjValue !== null, field.name + " map value", null);
                    // read value
                    let val;
                    switch (field.V.kind) {
                        case "message":
                            val = field.V.T().internalJsonRead(jsonObjValue, options);
                            break;
                        case "enum":
                            val = this.enum(field.V.T(), jsonObjValue, field.name, options.ignoreUnknownFields);
                            if (val === false)
                                continue;
                            break;
                        case "scalar":
                            val = this.scalar(jsonObjValue, field.V.T, field.V.L, field.name);
                            break;
                    }
                    this.assert(val !== undefined, field.name + " map value", jsonObjValue);
                    // read key
                    let key = jsonObjKey;
                    if (field.K == ScalarType.BOOL)
                        key = key == "true" ? true : key == "false" ? false : key;
                    key = this.scalar(key, field.K, LongType.STRING, field.name).toString();
                    fieldObj[key] = val;
                }
            }
            else if (field.repeat) {
                if (jsonValue === null)
                    continue;
                // check input
                this.assert(Array.isArray(jsonValue), field.name, jsonValue);
                // our target to put array entries into
                const fieldArr = target[localName];
                // read array entries
                for (const jsonItem of jsonValue) {
                    this.assert(jsonItem !== null, field.name, null);
                    let val;
                    switch (field.kind) {
                        case "message":
                            val = field.T().internalJsonRead(jsonItem, options);
                            break;
                        case "enum":
                            val = this.enum(field.T(), jsonItem, field.name, options.ignoreUnknownFields);
                            if (val === false)
                                continue;
                            break;
                        case "scalar":
                            val = this.scalar(jsonItem, field.T, field.L, field.name);
                            break;
                    }
                    this.assert(val !== undefined, field.name, jsonValue);
                    fieldArr.push(val);
                }
            }
            else {
                switch (field.kind) {
                    case "message":
                        if (jsonValue === null && field.T().typeName != 'google.protobuf.Value') {
                            this.assert(field.oneof === undefined, field.name + " (oneof member)", null);
                            continue;
                        }
                        target[localName] = field.T().internalJsonRead(jsonValue, options, target[localName]);
                        break;
                    case "enum":
                        if (jsonValue === null)
                            continue;
                        let val = this.enum(field.T(), jsonValue, field.name, options.ignoreUnknownFields);
                        if (val === false)
                            continue;
                        target[localName] = val;
                        break;
                    case "scalar":
                        if (jsonValue === null)
                            continue;
                        target[localName] = this.scalar(jsonValue, field.T, field.L, field.name);
                        break;
                }
            }
        }
    }
    /**
     * Returns `false` for unrecognized string representations.
     *
     * google.protobuf.NullValue accepts only JSON `null` (or the old `"NULL_VALUE"`).
     */
    enum(type, json, fieldName, ignoreUnknownFields) {
        if (type[0] == 'google.protobuf.NullValue')
            assert(json === null || json === "NULL_VALUE", `Unable to parse field ${this.info.typeName}#${fieldName}, enum ${type[0]} only accepts null.`);
        if (json === null)
            // we require 0 to be default value for all enums
            return 0;
        switch (typeof json) {
            case "number":
                assert(Number.isInteger(json), `Unable to parse field ${this.info.typeName}#${fieldName}, enum can only be integral number, got ${json}.`);
                return json;
            case "string":
                let localEnumName = json;
                if (type[2] && json.substring(0, type[2].length) === type[2])
                    // lookup without the shared prefix
                    localEnumName = json.substring(type[2].length);
                let enumNumber = type[1][localEnumName];
                if (typeof enumNumber === 'undefined' && ignoreUnknownFields) {
                    return false;
                }
                assert(typeof enumNumber == "number", `Unable to parse field ${this.info.typeName}#${fieldName}, enum ${type[0]} has no value for "${json}".`);
                return enumNumber;
        }
        assert(false, `Unable to parse field ${this.info.typeName}#${fieldName}, cannot parse enum value from ${typeof json}".`);
    }
    scalar(json, type, longType, fieldName) {
        let e;
        try {
            switch (type) {
                // float, double: JSON value will be a number or one of the special string values "NaN", "Infinity", and "-Infinity".
                // Either numbers or strings are accepted. Exponent notation is also accepted.
                case ScalarType.DOUBLE:
                case ScalarType.FLOAT:
                    if (json === null)
                        return .0;
                    if (json === "NaN")
                        return Number.NaN;
                    if (json === "Infinity")
                        return Number.POSITIVE_INFINITY;
                    if (json === "-Infinity")
                        return Number.NEGATIVE_INFINITY;
                    if (json === "") {
                        e = "empty string";
                        break;
                    }
                    if (typeof json == "string" && json.trim().length !== json.length) {
                        e = "extra whitespace";
                        break;
                    }
                    if (typeof json != "string" && typeof json != "number") {
                        break;
                    }
                    let float = Number(json);
                    if (Number.isNaN(float)) {
                        e = "not a number";
                        break;
                    }
                    if (!Number.isFinite(float)) {
                        // infinity and -infinity are handled by string representation above, so this is an error
                        e = "too large or small";
                        break;
                    }
                    if (type == ScalarType.FLOAT)
                        assertFloat32(float);
                    return float;
                // int32, fixed32, uint32: JSON value will be a decimal number. Either numbers or strings are accepted.
                case ScalarType.INT32:
                case ScalarType.FIXED32:
                case ScalarType.SFIXED32:
                case ScalarType.SINT32:
                case ScalarType.UINT32:
                    if (json === null)
                        return 0;
                    let int32;
                    if (typeof json == "number")
                        int32 = json;
                    else if (json === "")
                        e = "empty string";
                    else if (typeof json == "string") {
                        if (json.trim().length !== json.length)
                            e = "extra whitespace";
                        else
                            int32 = Number(json);
                    }
                    if (int32 === undefined)
                        break;
                    if (type == ScalarType.UINT32)
                        assertUInt32(int32);
                    else
                        assertInt32(int32);
                    return int32;
                // int64, fixed64, uint64: JSON value will be a decimal string. Either numbers or strings are accepted.
                case ScalarType.INT64:
                case ScalarType.SFIXED64:
                case ScalarType.SINT64:
                    if (json === null)
                        return reflectionLongConvert(PbLong.ZERO, longType);
                    if (typeof json != "number" && typeof json != "string")
                        break;
                    return reflectionLongConvert(PbLong.from(json), longType);
                case ScalarType.FIXED64:
                case ScalarType.UINT64:
                    if (json === null)
                        return reflectionLongConvert(PbULong.ZERO, longType);
                    if (typeof json != "number" && typeof json != "string")
                        break;
                    return reflectionLongConvert(PbULong.from(json), longType);
                // bool:
                case ScalarType.BOOL:
                    if (json === null)
                        return false;
                    if (typeof json !== "boolean")
                        break;
                    return json;
                // string:
                case ScalarType.STRING:
                    if (json === null)
                        return "";
                    if (typeof json !== "string") {
                        e = "extra whitespace";
                        break;
                    }
                    try {
                        encodeURIComponent(json);
                    }
                    catch (e) {
                        e = "invalid UTF8";
                        break;
                    }
                    return json;
                // bytes: JSON value will be the data encoded as a string using standard base64 encoding with paddings.
                // Either standard or URL-safe base64 encoding with/without paddings are accepted.
                case ScalarType.BYTES:
                    if (json === null || json === "")
                        return new Uint8Array(0);
                    if (typeof json !== 'string')
                        break;
                    return base64decode(json);
            }
        }
        catch (error) {
            e = error.message;
        }
        this.assert(false, fieldName + (e ? " - " + e : ""), json);
    }
}

/**
 * Writes proto3 messages in canonical JSON format using reflection
 * information.
 *
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 */
class ReflectionJsonWriter {
    constructor(info) {
        var _a;
        this.fields = (_a = info.fields) !== null && _a !== void 0 ? _a : [];
    }
    /**
     * Converts the message to a JSON object, based on the field descriptors.
     */
    write(message, options) {
        const json = {}, source = message;
        for (const field of this.fields) {
            // field is not part of a oneof, simply write as is
            if (!field.oneof) {
                let jsonValue = this.field(field, source[field.localName], options);
                if (jsonValue !== undefined)
                    json[options.useProtoFieldName ? field.name : field.jsonName] = jsonValue;
                continue;
            }
            // field is part of a oneof
            const group = source[field.oneof];
            if (group.oneofKind !== field.localName)
                continue; // not selected, skip
            const opt = field.kind == 'scalar' || field.kind == 'enum'
                ? Object.assign(Object.assign({}, options), { emitDefaultValues: true }) : options;
            let jsonValue = this.field(field, group[field.localName], opt);
            assert(jsonValue !== undefined);
            json[options.useProtoFieldName ? field.name : field.jsonName] = jsonValue;
        }
        return json;
    }
    field(field, value, options) {
        let jsonValue = undefined;
        if (field.kind == 'map') {
            assert(typeof value == "object" && value !== null);
            const jsonObj = {};
            switch (field.V.kind) {
                case "scalar":
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        const val = this.scalar(field.V.T, entryValue, field.name, false, true);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
                case "message":
                    const messageType = field.V.T();
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        const val = this.message(messageType, entryValue, field.name, options);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
                case "enum":
                    const enumInfo = field.V.T();
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        assert(entryValue === undefined || typeof entryValue == 'number');
                        const val = this.enum(enumInfo, entryValue, field.name, false, true, options.enumAsInteger);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
            }
            if (options.emitDefaultValues || Object.keys(jsonObj).length > 0)
                jsonValue = jsonObj;
        }
        else if (field.repeat) {
            assert(Array.isArray(value));
            const jsonArr = [];
            switch (field.kind) {
                case "scalar":
                    for (let i = 0; i < value.length; i++) {
                        const val = this.scalar(field.T, value[i], field.name, field.opt, true);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
                case "enum":
                    const enumInfo = field.T();
                    for (let i = 0; i < value.length; i++) {
                        assert(value[i] === undefined || typeof value[i] == 'number');
                        const val = this.enum(enumInfo, value[i], field.name, field.opt, true, options.enumAsInteger);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
                case "message":
                    const messageType = field.T();
                    for (let i = 0; i < value.length; i++) {
                        const val = this.message(messageType, value[i], field.name, options);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
            }
            // add converted array to json output
            if (options.emitDefaultValues || jsonArr.length > 0 || options.emitDefaultValues)
                jsonValue = jsonArr;
        }
        else {
            switch (field.kind) {
                case "scalar":
                    jsonValue = this.scalar(field.T, value, field.name, field.opt, options.emitDefaultValues);
                    break;
                case "enum":
                    jsonValue = this.enum(field.T(), value, field.name, field.opt, options.emitDefaultValues, options.enumAsInteger);
                    break;
                case "message":
                    jsonValue = this.message(field.T(), value, field.name, options);
                    break;
            }
        }
        return jsonValue;
    }
    /**
     * Returns `null` as the default for google.protobuf.NullValue.
     */
    enum(type, value, fieldName, optional, emitDefaultValues, enumAsInteger) {
        if (type[0] == 'google.protobuf.NullValue')
            return !emitDefaultValues && !optional ? undefined : null;
        if (value === undefined) {
            assert(optional);
            return undefined;
        }
        if (value === 0 && !emitDefaultValues && !optional)
            // we require 0 to be default value for all enums
            return undefined;
        assert(typeof value == 'number');
        assert(Number.isInteger(value));
        if (enumAsInteger || !type[1].hasOwnProperty(value))
            // if we don't now the enum value, just return the number
            return value;
        if (type[2])
            // restore the dropped prefix
            return type[2] + type[1][value];
        return type[1][value];
    }
    message(type, value, fieldName, options) {
        if (value === undefined)
            return options.emitDefaultValues ? null : undefined;
        return type.internalJsonWrite(value, options);
    }
    scalar(type, value, fieldName, optional, emitDefaultValues) {
        if (value === undefined) {
            assert(optional);
            return undefined;
        }
        const ed = emitDefaultValues || optional;
        // noinspection FallThroughInSwitchStatementJS
        switch (type) {
            // int32, fixed32, uint32: JSON value will be a decimal number. Either numbers or strings are accepted.
            case ScalarType.INT32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
                if (value === 0)
                    return ed ? 0 : undefined;
                assertInt32(value);
                return value;
            case ScalarType.FIXED32:
            case ScalarType.UINT32:
                if (value === 0)
                    return ed ? 0 : undefined;
                assertUInt32(value);
                return value;
            // float, double: JSON value will be a number or one of the special string values "NaN", "Infinity", and "-Infinity".
            // Either numbers or strings are accepted. Exponent notation is also accepted.
            case ScalarType.FLOAT:
                assertFloat32(value);
            case ScalarType.DOUBLE:
                if (value === 0)
                    return ed ? 0 : undefined;
                assert(typeof value == 'number');
                if (Number.isNaN(value))
                    return 'NaN';
                if (value === Number.POSITIVE_INFINITY)
                    return 'Infinity';
                if (value === Number.NEGATIVE_INFINITY)
                    return '-Infinity';
                return value;
            // string:
            case ScalarType.STRING:
                if (value === "")
                    return ed ? '' : undefined;
                assert(typeof value == 'string');
                return value;
            // bool:
            case ScalarType.BOOL:
                if (value === false)
                    return ed ? false : undefined;
                assert(typeof value == 'boolean');
                return value;
            // JSON value will be a decimal string. Either numbers or strings are accepted.
            case ScalarType.UINT64:
            case ScalarType.FIXED64:
                assert(typeof value == 'number' || typeof value == 'string' || typeof value == 'bigint');
                let ulong = PbULong.from(value);
                if (ulong.isZero() && !ed)
                    return undefined;
                return ulong.toString();
            // JSON value will be a decimal string. Either numbers or strings are accepted.
            case ScalarType.INT64:
            case ScalarType.SFIXED64:
            case ScalarType.SINT64:
                assert(typeof value == 'number' || typeof value == 'string' || typeof value == 'bigint');
                let long = PbLong.from(value);
                if (long.isZero() && !ed)
                    return undefined;
                return long.toString();
            // bytes: JSON value will be the data encoded as a string using standard base64 encoding with paddings.
            // Either standard or URL-safe base64 encoding with/without paddings are accepted.
            case ScalarType.BYTES:
                assert(value instanceof Uint8Array);
                if (!value.byteLength)
                    return ed ? "" : undefined;
                return base64encode(value);
        }
    }
}

/**
 * Creates the default value for a scalar type.
 */
function reflectionScalarDefault(type, longType = LongType.STRING) {
    switch (type) {
        case ScalarType.BOOL:
            return false;
        case ScalarType.UINT64:
        case ScalarType.FIXED64:
            return reflectionLongConvert(PbULong.ZERO, longType);
        case ScalarType.INT64:
        case ScalarType.SFIXED64:
        case ScalarType.SINT64:
            return reflectionLongConvert(PbLong.ZERO, longType);
        case ScalarType.DOUBLE:
        case ScalarType.FLOAT:
            return 0.0;
        case ScalarType.BYTES:
            return new Uint8Array(0);
        case ScalarType.STRING:
            return "";
        default:
            // case ScalarType.INT32:
            // case ScalarType.UINT32:
            // case ScalarType.SINT32:
            // case ScalarType.FIXED32:
            // case ScalarType.SFIXED32:
            return 0;
    }
}

/**
 * Reads proto3 messages in binary format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/encoding
 */
class ReflectionBinaryReader {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        var _a;
        if (!this.fieldNoToField) {
            const fieldsInput = (_a = this.info.fields) !== null && _a !== void 0 ? _a : [];
            this.fieldNoToField = new Map(fieldsInput.map(field => [field.no, field]));
        }
    }
    /**
     * Reads a message from binary format into the target message.
     *
     * Repeated fields are appended. Map entries are added, overwriting
     * existing keys.
     *
     * If a message field is already present, it will be merged with the
     * new data.
     */
    read(reader, message, options, length) {
        this.prepare();
        const end = length === undefined ? reader.len : reader.pos + length;
        while (reader.pos < end) {
            // read the tag and find the field
            const [fieldNo, wireType] = reader.tag(), field = this.fieldNoToField.get(fieldNo);
            if (!field) {
                let u = options.readUnknownField;
                if (u == "throw")
                    throw new Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.info.typeName}`);
                let d = reader.skip(wireType);
                if (u !== false)
                    (u === true ? UnknownFieldHandler.onRead : u)(this.info.typeName, message, fieldNo, wireType, d);
                continue;
            }
            // target object for the field we are reading
            let target = message, repeated = field.repeat, localName = field.localName;
            // if field is member of oneof ADT, use ADT as target
            if (field.oneof) {
                target = target[field.oneof];
                // if other oneof member selected, set new ADT
                if (target.oneofKind !== localName)
                    target = message[field.oneof] = {
                        oneofKind: localName
                    };
            }
            // we have handled oneof above, we just have read the value into `target[localName]`
            switch (field.kind) {
                case "scalar":
                case "enum":
                    let T = field.kind == "enum" ? ScalarType.INT32 : field.T;
                    let L = field.kind == "scalar" ? field.L : undefined;
                    if (repeated) {
                        let arr = target[localName]; // safe to assume presence of array, oneof cannot contain repeated values
                        if (wireType == WireType.LengthDelimited && T != ScalarType.STRING && T != ScalarType.BYTES) {
                            let e = reader.uint32() + reader.pos;
                            while (reader.pos < e)
                                arr.push(this.scalar(reader, T, L));
                        }
                        else
                            arr.push(this.scalar(reader, T, L));
                    }
                    else
                        target[localName] = this.scalar(reader, T, L);
                    break;
                case "message":
                    if (repeated) {
                        let arr = target[localName]; // safe to assume presence of array, oneof cannot contain repeated values
                        let msg = field.T().internalBinaryRead(reader, reader.uint32(), options);
                        arr.push(msg);
                    }
                    else
                        target[localName] = field.T().internalBinaryRead(reader, reader.uint32(), options, target[localName]);
                    break;
                case "map":
                    let [mapKey, mapVal] = this.mapEntry(field, reader, options);
                    // safe to assume presence of map object, oneof cannot contain repeated values
                    target[localName][mapKey] = mapVal;
                    break;
            }
        }
    }
    /**
     * Read a map field, expecting key field = 1, value field = 2
     */
    mapEntry(field, reader, options) {
        let length = reader.uint32();
        let end = reader.pos + length;
        let key = undefined; // javascript only allows number or string for object properties
        let val = undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    if (field.K == ScalarType.BOOL)
                        key = reader.bool().toString();
                    else
                        // long types are read as string, number types are okay as number
                        key = this.scalar(reader, field.K, LongType.STRING);
                    break;
                case 2:
                    switch (field.V.kind) {
                        case "scalar":
                            val = this.scalar(reader, field.V.T, field.V.L);
                            break;
                        case "enum":
                            val = reader.int32();
                            break;
                        case "message":
                            val = field.V.T().internalBinaryRead(reader, reader.uint32(), options);
                            break;
                    }
                    break;
                default:
                    throw new Error(`Unknown field ${fieldNo} (wire type ${wireType}) in map entry for ${this.info.typeName}#${field.name}`);
            }
        }
        if (key === undefined) {
            let keyRaw = reflectionScalarDefault(field.K);
            key = field.K == ScalarType.BOOL ? keyRaw.toString() : keyRaw;
        }
        if (val === undefined)
            switch (field.V.kind) {
                case "scalar":
                    val = reflectionScalarDefault(field.V.T, field.V.L);
                    break;
                case "enum":
                    val = 0;
                    break;
                case "message":
                    val = field.V.T().create();
                    break;
            }
        return [key, val];
    }
    scalar(reader, type, longType) {
        switch (type) {
            case ScalarType.INT32:
                return reader.int32();
            case ScalarType.STRING:
                return reader.string();
            case ScalarType.BOOL:
                return reader.bool();
            case ScalarType.DOUBLE:
                return reader.double();
            case ScalarType.FLOAT:
                return reader.float();
            case ScalarType.INT64:
                return reflectionLongConvert(reader.int64(), longType);
            case ScalarType.UINT64:
                return reflectionLongConvert(reader.uint64(), longType);
            case ScalarType.FIXED64:
                return reflectionLongConvert(reader.fixed64(), longType);
            case ScalarType.FIXED32:
                return reader.fixed32();
            case ScalarType.BYTES:
                return reader.bytes();
            case ScalarType.UINT32:
                return reader.uint32();
            case ScalarType.SFIXED32:
                return reader.sfixed32();
            case ScalarType.SFIXED64:
                return reflectionLongConvert(reader.sfixed64(), longType);
            case ScalarType.SINT32:
                return reader.sint32();
            case ScalarType.SINT64:
                return reflectionLongConvert(reader.sint64(), longType);
        }
    }
}

/**
 * Writes proto3 messages in binary format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/encoding
 */
class ReflectionBinaryWriter {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        if (!this.fields) {
            const fieldsInput = this.info.fields ? this.info.fields.concat() : [];
            this.fields = fieldsInput.sort((a, b) => a.no - b.no);
        }
    }
    /**
     * Writes the message to binary format.
     */
    write(message, writer, options) {
        this.prepare();
        for (const field of this.fields) {
            let value, // this will be our field value, whether it is member of a oneof or not
            emitDefault, // whether we emit the default value (only true for oneof members)
            repeated = field.repeat, localName = field.localName;
            // handle oneof ADT
            if (field.oneof) {
                const group = message[field.oneof];
                if (group.oneofKind !== localName)
                    continue; // if field is not selected, skip
                value = group[localName];
                emitDefault = true;
            }
            else {
                value = message[localName];
                emitDefault = false;
            }
            // we have handled oneof above. we just have to honor `emitDefault`.
            switch (field.kind) {
                case "scalar":
                case "enum":
                    let T = field.kind == "enum" ? ScalarType.INT32 : field.T;
                    if (repeated) {
                        assert(Array.isArray(value));
                        if (repeated == RepeatType.PACKED)
                            this.packed(writer, T, field.no, value);
                        else
                            for (const item of value)
                                this.scalar(writer, T, field.no, item, true);
                    }
                    else if (value === undefined)
                        assert(field.opt);
                    else
                        this.scalar(writer, T, field.no, value, emitDefault || field.opt);
                    break;
                case "message":
                    if (repeated) {
                        assert(Array.isArray(value));
                        for (const item of value)
                            this.message(writer, options, field.T(), field.no, item);
                    }
                    else {
                        this.message(writer, options, field.T(), field.no, value);
                    }
                    break;
                case "map":
                    assert(typeof value == 'object' && value !== null);
                    for (const [key, val] of Object.entries(value))
                        this.mapEntry(writer, options, field, key, val);
                    break;
            }
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u === true ? UnknownFieldHandler.onWrite : u)(this.info.typeName, message, writer);
    }
    mapEntry(writer, options, field, key, value) {
        writer.tag(field.no, WireType.LengthDelimited);
        writer.fork();
        // javascript only allows number or string for object properties
        // we convert from our representation to the protobuf type
        let keyValue = key;
        switch (field.K) {
            case ScalarType.INT32:
            case ScalarType.FIXED32:
            case ScalarType.UINT32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
                keyValue = Number.parseInt(key);
                break;
            case ScalarType.BOOL:
                assert(key == 'true' || key == 'false');
                keyValue = key == 'true';
                break;
        }
        // write key, expecting key field number = 1
        this.scalar(writer, field.K, 1, keyValue, true);
        // write value, expecting value field number = 2
        switch (field.V.kind) {
            case 'scalar':
                this.scalar(writer, field.V.T, 2, value, true);
                break;
            case 'enum':
                this.scalar(writer, ScalarType.INT32, 2, value, true);
                break;
            case 'message':
                this.message(writer, options, field.V.T(), 2, value);
                break;
        }
        writer.join();
    }
    message(writer, options, handler, fieldNo, value) {
        if (value === undefined)
            return;
        handler.internalBinaryWrite(value, writer.tag(fieldNo, WireType.LengthDelimited).fork(), options);
        writer.join();
    }
    /**
     * Write a single scalar value.
     */
    scalar(writer, type, fieldNo, value, emitDefault) {
        let [wireType, method, isDefault] = this.scalarInfo(type, value);
        if (!isDefault || emitDefault) {
            writer.tag(fieldNo, wireType);
            writer[method](value);
        }
    }
    /**
     * Write an array of scalar values in packed format.
     */
    packed(writer, type, fieldNo, value) {
        if (!value.length)
            return;
        assert(type !== ScalarType.BYTES && type !== ScalarType.STRING);
        // write tag
        writer.tag(fieldNo, WireType.LengthDelimited);
        // begin length-delimited
        writer.fork();
        // write values without tags
        let [, method,] = this.scalarInfo(type);
        for (let i = 0; i < value.length; i++)
            writer[method](value[i]);
        // end length delimited
        writer.join();
    }
    /**
     * Get information for writing a scalar value.
     *
     * Returns tuple:
     * [0]: appropriate WireType
     * [1]: name of the appropriate method of IBinaryWriter
     * [2]: whether the given value is a default value
     *
     * If argument `value` is omitted, [2] is always false.
     */
    scalarInfo(type, value) {
        let t = WireType.Varint;
        let m;
        let i = value === undefined;
        let d = value === 0;
        switch (type) {
            case ScalarType.INT32:
                m = "int32";
                break;
            case ScalarType.STRING:
                d = i || !value.length;
                t = WireType.LengthDelimited;
                m = "string";
                break;
            case ScalarType.BOOL:
                d = value === false;
                m = "bool";
                break;
            case ScalarType.UINT32:
                m = "uint32";
                break;
            case ScalarType.DOUBLE:
                t = WireType.Bit64;
                m = "double";
                break;
            case ScalarType.FLOAT:
                t = WireType.Bit32;
                m = "float";
                break;
            case ScalarType.INT64:
                d = i || PbLong.from(value).isZero();
                m = "int64";
                break;
            case ScalarType.UINT64:
                d = i || PbULong.from(value).isZero();
                m = "uint64";
                break;
            case ScalarType.FIXED64:
                d = i || PbULong.from(value).isZero();
                t = WireType.Bit64;
                m = "fixed64";
                break;
            case ScalarType.BYTES:
                d = i || !value.byteLength;
                t = WireType.LengthDelimited;
                m = "bytes";
                break;
            case ScalarType.FIXED32:
                t = WireType.Bit32;
                m = "fixed32";
                break;
            case ScalarType.SFIXED32:
                t = WireType.Bit32;
                m = "sfixed32";
                break;
            case ScalarType.SFIXED64:
                d = i || PbLong.from(value).isZero();
                t = WireType.Bit64;
                m = "sfixed64";
                break;
            case ScalarType.SINT32:
                m = "sint32";
                break;
            case ScalarType.SINT64:
                d = i || PbLong.from(value).isZero();
                m = "sint64";
                break;
        }
        return [t, m, i || d];
    }
}

/**
 * Creates an instance of the generic message, using the field
 * information.
 */
function reflectionCreate(type) {
    /**
     * This ternary can be removed in the next major version.
     * The `Object.create()` code path utilizes a new `messagePrototype`
     * property on the `IMessageType` which has this same `MESSAGE_TYPE`
     * non-enumerable property on it. Doing it this way means that we only
     * pay the cost of `Object.defineProperty()` once per `IMessageType`
     * class of once per "instance". The falsy code path is only provided
     * for backwards compatibility in cases where the runtime library is
     * updated without also updating the generated code.
     */
    const msg = type.messagePrototype
        ? Object.create(type.messagePrototype)
        : Object.defineProperty({}, MESSAGE_TYPE, { value: type });
    for (let field of type.fields) {
        let name = field.localName;
        if (field.opt)
            continue;
        if (field.oneof)
            msg[field.oneof] = { oneofKind: undefined };
        else if (field.repeat)
            msg[name] = [];
        else
            switch (field.kind) {
                case "scalar":
                    msg[name] = reflectionScalarDefault(field.T, field.L);
                    break;
                case "enum":
                    // we require 0 to be default value for all enums
                    msg[name] = 0;
                    break;
                case "map":
                    msg[name] = {};
                    break;
            }
    }
    return msg;
}

/**
 * Copy partial data into the target message.
 *
 * If a singular scalar or enum field is present in the source, it
 * replaces the field in the target.
 *
 * If a singular message field is present in the source, it is merged
 * with the target field by calling mergePartial() of the responsible
 * message type.
 *
 * If a repeated field is present in the source, its values replace
 * all values in the target array, removing extraneous values.
 * Repeated message fields are copied, not merged.
 *
 * If a map field is present in the source, entries are added to the
 * target map, replacing entries with the same key. Entries that only
 * exist in the target remain. Entries with message values are copied,
 * not merged.
 *
 * Note that this function differs from protobuf merge semantics,
 * which appends repeated fields.
 */
function reflectionMergePartial(info, target, source) {
    let fieldValue, // the field value we are working with
    input = source, output; // where we want our field value to go
    for (let field of info.fields) {
        let name = field.localName;
        if (field.oneof) {
            const group = input[field.oneof]; // this is the oneof`s group in the source
            if ((group === null || group === void 0 ? void 0 : group.oneofKind) == undefined) { // the user is free to omit
                continue; // we skip this field, and all other members too
            }
            fieldValue = group[name]; // our value comes from the the oneof group of the source
            output = target[field.oneof]; // and our output is the oneof group of the target
            output.oneofKind = group.oneofKind; // always update discriminator
            if (fieldValue == undefined) {
                delete output[name]; // remove any existing value
                continue; // skip further work on field
            }
        }
        else {
            fieldValue = input[name]; // we are using the source directly
            output = target; // we want our field value to go directly into the target
            if (fieldValue == undefined) {
                continue; // skip further work on field, existing value is used as is
            }
        }
        if (field.repeat)
            output[name].length = fieldValue.length; // resize target array to match source array
        // now we just work with `fieldValue` and `output` to merge the value
        switch (field.kind) {
            case "scalar":
            case "enum":
                if (field.repeat)
                    for (let i = 0; i < fieldValue.length; i++)
                        output[name][i] = fieldValue[i]; // not a reference type
                else
                    output[name] = fieldValue; // not a reference type
                break;
            case "message":
                let T = field.T();
                if (field.repeat)
                    for (let i = 0; i < fieldValue.length; i++)
                        output[name][i] = T.create(fieldValue[i]);
                else if (output[name] === undefined)
                    output[name] = T.create(fieldValue); // nothing to merge with
                else
                    T.mergePartial(output[name], fieldValue);
                break;
            case "map":
                // Map and repeated fields are simply overwritten, not appended or merged
                switch (field.V.kind) {
                    case "scalar":
                    case "enum":
                        Object.assign(output[name], fieldValue); // elements are not reference types
                        break;
                    case "message":
                        let T = field.V.T();
                        for (let k of Object.keys(fieldValue))
                            output[name][k] = T.create(fieldValue[k]);
                        break;
                }
                break;
        }
    }
}

/**
 * Determines whether two message of the same type have the same field values.
 * Checks for deep equality, traversing repeated fields, oneof groups, maps
 * and messages recursively.
 * Will also return true if both messages are `undefined`.
 */
function reflectionEquals(info, a, b) {
    if (a === b)
        return true;
    if (!a || !b)
        return false;
    for (let field of info.fields) {
        let localName = field.localName;
        let val_a = field.oneof ? a[field.oneof][localName] : a[localName];
        let val_b = field.oneof ? b[field.oneof][localName] : b[localName];
        switch (field.kind) {
            case "enum":
            case "scalar":
                let t = field.kind == "enum" ? ScalarType.INT32 : field.T;
                if (!(field.repeat
                    ? repeatedPrimitiveEq(t, val_a, val_b)
                    : primitiveEq(t, val_a, val_b)))
                    return false;
                break;
            case "map":
                if (!(field.V.kind == "message"
                    ? repeatedMsgEq(field.V.T(), objectValues(val_a), objectValues(val_b))
                    : repeatedPrimitiveEq(field.V.kind == "enum" ? ScalarType.INT32 : field.V.T, objectValues(val_a), objectValues(val_b))))
                    return false;
                break;
            case "message":
                let T = field.T();
                if (!(field.repeat
                    ? repeatedMsgEq(T, val_a, val_b)
                    : T.equals(val_a, val_b)))
                    return false;
                break;
        }
    }
    return true;
}
const objectValues = Object.values;
function primitiveEq(type, a, b) {
    if (a === b)
        return true;
    if (type !== ScalarType.BYTES)
        return false;
    let ba = a;
    let bb = b;
    if (ba.length !== bb.length)
        return false;
    for (let i = 0; i < ba.length; i++)
        if (ba[i] != bb[i])
            return false;
    return true;
}
function repeatedPrimitiveEq(type, a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; i++)
        if (!primitiveEq(type, a[i], b[i]))
            return false;
    return true;
}
function repeatedMsgEq(type, a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; i++)
        if (!type.equals(a[i], b[i]))
            return false;
    return true;
}

const baseDescriptors = Object.getOwnPropertyDescriptors(Object.getPrototypeOf({}));
const messageTypeDescriptor = baseDescriptors[MESSAGE_TYPE] = {};
/**
 * This standard message type provides reflection-based
 * operations to work with a message.
 */
class MessageType {
    constructor(name, fields, options) {
        this.defaultCheckDepth = 16;
        this.typeName = name;
        this.fields = fields.map(normalizeFieldInfo);
        this.options = options !== null && options !== void 0 ? options : {};
        messageTypeDescriptor.value = this;
        this.messagePrototype = Object.create(null, baseDescriptors);
        this.refTypeCheck = new ReflectionTypeCheck(this);
        this.refJsonReader = new ReflectionJsonReader(this);
        this.refJsonWriter = new ReflectionJsonWriter(this);
        this.refBinReader = new ReflectionBinaryReader(this);
        this.refBinWriter = new ReflectionBinaryWriter(this);
    }
    create(value) {
        let message = reflectionCreate(this);
        if (value !== undefined) {
            reflectionMergePartial(this, message, value);
        }
        return message;
    }
    /**
     * Clone the message.
     *
     * Unknown fields are discarded.
     */
    clone(message) {
        let copy = this.create();
        reflectionMergePartial(this, copy, message);
        return copy;
    }
    /**
     * Determines whether two message of the same type have the same field values.
     * Checks for deep equality, traversing repeated fields, oneof groups, maps
     * and messages recursively.
     * Will also return true if both messages are `undefined`.
     */
    equals(a, b) {
        return reflectionEquals(this, a, b);
    }
    /**
     * Is the given value assignable to our message type
     * and contains no [excess properties](https://www.typescriptlang.org/docs/handbook/interfaces.html#excess-property-checks)?
     */
    is(arg, depth = this.defaultCheckDepth) {
        return this.refTypeCheck.is(arg, depth, false);
    }
    /**
     * Is the given value assignable to our message type,
     * regardless of [excess properties](https://www.typescriptlang.org/docs/handbook/interfaces.html#excess-property-checks)?
     */
    isAssignable(arg, depth = this.defaultCheckDepth) {
        return this.refTypeCheck.is(arg, depth, true);
    }
    /**
     * Copy partial data into the target message.
     */
    mergePartial(target, source) {
        reflectionMergePartial(this, target, source);
    }
    /**
     * Create a new message from binary format.
     */
    fromBinary(data, options) {
        let opt = binaryReadOptions(options);
        return this.internalBinaryRead(opt.readerFactory(data), data.byteLength, opt);
    }
    /**
     * Read a new message from a JSON value.
     */
    fromJson(json, options) {
        return this.internalJsonRead(json, jsonReadOptions(options));
    }
    /**
     * Read a new message from a JSON string.
     * This is equivalent to `T.fromJson(JSON.parse(json))`.
     */
    fromJsonString(json, options) {
        let value = JSON.parse(json);
        return this.fromJson(value, options);
    }
    /**
     * Write the message to canonical JSON value.
     */
    toJson(message, options) {
        return this.internalJsonWrite(message, jsonWriteOptions(options));
    }
    /**
     * Convert the message to canonical JSON string.
     * This is equivalent to `JSON.stringify(T.toJson(t))`
     */
    toJsonString(message, options) {
        var _a;
        let value = this.toJson(message, options);
        return JSON.stringify(value, null, (_a = options === null || options === void 0 ? void 0 : options.prettySpaces) !== null && _a !== void 0 ? _a : 0);
    }
    /**
     * Write the message to binary format.
     */
    toBinary(message, options) {
        let opt = binaryWriteOptions(options);
        return this.internalBinaryWrite(message, opt.writerFactory(), opt).finish();
    }
    /**
     * This is an internal method. If you just want to read a message from
     * JSON, use `fromJson()` or `fromJsonString()`.
     *
     * Reads JSON value and merges the fields into the target
     * according to protobuf rules. If the target is omitted,
     * a new instance is created first.
     */
    internalJsonRead(json, options, target) {
        if (json !== null && typeof json == "object" && !Array.isArray(json)) {
            let message = target !== null && target !== void 0 ? target : this.create();
            this.refJsonReader.read(json, message, options);
            return message;
        }
        throw new Error(`Unable to parse message ${this.typeName} from JSON ${typeofJsonValue(json)}.`);
    }
    /**
     * This is an internal method. If you just want to write a message
     * to JSON, use `toJson()` or `toJsonString().
     *
     * Writes JSON value and returns it.
     */
    internalJsonWrite(message, options) {
        return this.refJsonWriter.write(message, options);
    }
    /**
     * This is an internal method. If you just want to write a message
     * in binary format, use `toBinary()`.
     *
     * Serializes the message in binary format and appends it to the given
     * writer. Returns passed writer.
     */
    internalBinaryWrite(message, writer, options) {
        this.refBinWriter.write(message, writer, options);
        return writer;
    }
    /**
     * This is an internal method. If you just want to read a message from
     * binary data, use `fromBinary()`.
     *
     * Reads data from binary format and merges the fields into
     * the target according to protobuf rules. If the target is
     * omitted, a new instance is created first.
     */
    internalBinaryRead(reader, length, options, target) {
        let message = target !== null && target !== void 0 ? target : this.create();
        this.refBinReader.read(reader, message, options, length);
        return message;
    }
}

function ProtoField(no, type, optional, repeat) {
  if (typeof type === "function") {
    return { kind: "message", no, type, optional: optional ?? false, repeat: repeat ?? false };
  } else {
    return { kind: "scalar", no, type, optional: optional ?? false, repeat: repeat ?? false };
  }
}
class NapProtoRealMsg {
  _field;
  _proto_msg;
  static cache = /* @__PURE__ */ new WeakMap();
  constructor(fields) {
    this._field = Object.keys(fields).map((key) => {
      const field = fields[key];
      if (field.kind === "scalar") {
        const repeatType = field.repeat ? [ScalarType.STRING, ScalarType.BYTES].includes(field.type) ? RepeatType.UNPACKED : RepeatType.PACKED : RepeatType.NO;
        return {
          no: field.no,
          name: key,
          kind: "scalar",
          T: field.type,
          opt: field.optional,
          repeat: repeatType
        };
      } else if (field.kind === "message") {
        return {
          no: field.no,
          name: key,
          kind: "message",
          repeat: field.repeat ? RepeatType.PACKED : RepeatType.NO,
          T: () => NapProtoRealMsg.getInstance(field.type())._proto_msg
        };
      } else {
        throw new Error(`Unknown field kind: ${field.kind}`);
      }
    });
    this._proto_msg = new MessageType("nya", this._field);
  }
  static getInstance(fields) {
    let instance = this.cache.get(fields);
    if (!instance) {
      instance = new NapProtoRealMsg(fields);
      this.cache.set(fields, instance);
    }
    return instance;
  }
  encode(data) {
    return this._proto_msg.toBinary(this._proto_msg.create(data));
  }
  decode(data) {
    return this._proto_msg.fromBinary(data);
  }
}
class NapProtoMsg {
  realMsg;
  constructor(fields) {
    this.realMsg = NapProtoRealMsg.getInstance(fields);
  }
  encode(data) {
    return this.realMsg.encode(data);
  }
  decode(data) {
    return this.realMsg.decode(data);
  }
}

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (Object.prototype.hasOwnProperty.call(n, '__esModule')) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
        return Reflect.construct(f, arguments, this.constructor);
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var _Reflect = {};

/*! *****************************************************************************
Copyright (C) Microsoft. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

var hasRequired_Reflect;

function require_Reflect () {
	if (hasRequired_Reflect) return _Reflect;
	hasRequired_Reflect = 1;
	var Reflect;
	(function (Reflect) {
	    // Metadata Proposal
	    // https://rbuckton.github.io/reflect-metadata/
	    (function (factory) {
	        var root = typeof globalThis === "object" ? globalThis :
	            typeof commonjsGlobal === "object" ? commonjsGlobal :
	                typeof self === "object" ? self :
	                    typeof this === "object" ? this :
	                        sloppyModeThis();
	        var exporter = makeExporter(Reflect);
	        if (typeof root.Reflect !== "undefined") {
	            exporter = makeExporter(root.Reflect, exporter);
	        }
	        factory(exporter, root);
	        if (typeof root.Reflect === "undefined") {
	            root.Reflect = Reflect;
	        }
	        function makeExporter(target, previous) {
	            return function (key, value) {
	                Object.defineProperty(target, key, { configurable: true, writable: true, value: value });
	                if (previous)
	                    previous(key, value);
	            };
	        }
	        function functionThis() {
	            try {
	                return Function("return this;")();
	            }
	            catch (_) { }
	        }
	        function indirectEvalThis() {
	            try {
	                return (void 0, eval)("(function() { return this; })()");
	            }
	            catch (_) { }
	        }
	        function sloppyModeThis() {
	            return functionThis() || indirectEvalThis();
	        }
	    })(function (exporter, root) {
	        var hasOwn = Object.prototype.hasOwnProperty;
	        // feature test for Symbol support
	        var supportsSymbol = typeof Symbol === "function";
	        var toPrimitiveSymbol = supportsSymbol && typeof Symbol.toPrimitive !== "undefined" ? Symbol.toPrimitive : "@@toPrimitive";
	        var iteratorSymbol = supportsSymbol && typeof Symbol.iterator !== "undefined" ? Symbol.iterator : "@@iterator";
	        var supportsCreate = typeof Object.create === "function"; // feature test for Object.create support
	        var supportsProto = { __proto__: [] } instanceof Array; // feature test for __proto__ support
	        var downLevel = !supportsCreate && !supportsProto;
	        var HashMap = {
	            // create an object in dictionary mode (a.k.a. "slow" mode in v8)
	            create: supportsCreate
	                ? function () { return MakeDictionary(Object.create(null)); }
	                : supportsProto
	                    ? function () { return MakeDictionary({ __proto__: null }); }
	                    : function () { return MakeDictionary({}); },
	            has: downLevel
	                ? function (map, key) { return hasOwn.call(map, key); }
	                : function (map, key) { return key in map; },
	            get: downLevel
	                ? function (map, key) { return hasOwn.call(map, key) ? map[key] : undefined; }
	                : function (map, key) { return map[key]; },
	        };
	        // Load global or shim versions of Map, Set, and WeakMap
	        var functionPrototype = Object.getPrototypeOf(Function);
	        var _Map = typeof Map === "function" && typeof Map.prototype.entries === "function" ? Map : CreateMapPolyfill();
	        var _Set = typeof Set === "function" && typeof Set.prototype.entries === "function" ? Set : CreateSetPolyfill();
	        var _WeakMap = typeof WeakMap === "function" ? WeakMap : CreateWeakMapPolyfill();
	        var registrySymbol = supportsSymbol ? Symbol.for("@reflect-metadata:registry") : undefined;
	        var metadataRegistry = GetOrCreateMetadataRegistry();
	        var metadataProvider = CreateMetadataProvider(metadataRegistry);
	        /**
	         * Applies a set of decorators to a property of a target object.
	         * @param decorators An array of decorators.
	         * @param target The target object.
	         * @param propertyKey (Optional) The property key to decorate.
	         * @param attributes (Optional) The property descriptor for the target key.
	         * @remarks Decorators are applied in reverse order.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     Example = Reflect.decorate(decoratorsArray, Example);
	         *
	         *     // property (on constructor)
	         *     Reflect.decorate(decoratorsArray, Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     Reflect.decorate(decoratorsArray, Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     Object.defineProperty(Example, "staticMethod",
	         *         Reflect.decorate(decoratorsArray, Example, "staticMethod",
	         *             Object.getOwnPropertyDescriptor(Example, "staticMethod")));
	         *
	         *     // method (on prototype)
	         *     Object.defineProperty(Example.prototype, "method",
	         *         Reflect.decorate(decoratorsArray, Example.prototype, "method",
	         *             Object.getOwnPropertyDescriptor(Example.prototype, "method")));
	         *
	         */
	        function decorate(decorators, target, propertyKey, attributes) {
	            if (!IsUndefined(propertyKey)) {
	                if (!IsArray(decorators))
	                    throw new TypeError();
	                if (!IsObject(target))
	                    throw new TypeError();
	                if (!IsObject(attributes) && !IsUndefined(attributes) && !IsNull(attributes))
	                    throw new TypeError();
	                if (IsNull(attributes))
	                    attributes = undefined;
	                propertyKey = ToPropertyKey(propertyKey);
	                return DecorateProperty(decorators, target, propertyKey, attributes);
	            }
	            else {
	                if (!IsArray(decorators))
	                    throw new TypeError();
	                if (!IsConstructor(target))
	                    throw new TypeError();
	                return DecorateConstructor(decorators, target);
	            }
	        }
	        exporter("decorate", decorate);
	        // 4.1.2 Reflect.metadata(metadataKey, metadataValue)
	        // https://rbuckton.github.io/reflect-metadata/#reflect.metadata
	        /**
	         * A default metadata decorator factory that can be used on a class, class member, or parameter.
	         * @param metadataKey The key for the metadata entry.
	         * @param metadataValue The value for the metadata entry.
	         * @returns A decorator function.
	         * @remarks
	         * If `metadataKey` is already defined for the target and target key, the
	         * metadataValue for that key will be overwritten.
	         * @example
	         *
	         *     // constructor
	         *     @Reflect.metadata(key, value)
	         *     class Example {
	         *     }
	         *
	         *     // property (on constructor, TypeScript only)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         static staticProperty;
	         *     }
	         *
	         *     // property (on prototype, TypeScript only)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         property;
	         *     }
	         *
	         *     // method (on constructor)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         static staticMethod() { }
	         *     }
	         *
	         *     // method (on prototype)
	         *     class Example {
	         *         @Reflect.metadata(key, value)
	         *         method() { }
	         *     }
	         *
	         */
	        function metadata(metadataKey, metadataValue) {
	            function decorator(target, propertyKey) {
	                if (!IsObject(target))
	                    throw new TypeError();
	                if (!IsUndefined(propertyKey) && !IsPropertyKey(propertyKey))
	                    throw new TypeError();
	                OrdinaryDefineOwnMetadata(metadataKey, metadataValue, target, propertyKey);
	            }
	            return decorator;
	        }
	        exporter("metadata", metadata);
	        /**
	         * Define a unique metadata entry on the target.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param metadataValue A value that contains attached metadata.
	         * @param target The target object on which to define metadata.
	         * @param propertyKey (Optional) The property key for the target.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     Reflect.defineMetadata("custom:annotation", options, Example);
	         *
	         *     // property (on constructor)
	         *     Reflect.defineMetadata("custom:annotation", options, Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     Reflect.defineMetadata("custom:annotation", options, Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     Reflect.defineMetadata("custom:annotation", options, Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     Reflect.defineMetadata("custom:annotation", options, Example.prototype, "method");
	         *
	         *     // decorator factory as metadata-producing annotation.
	         *     function MyAnnotation(options): Decorator {
	         *         return (target, key?) => Reflect.defineMetadata("custom:annotation", options, target, key);
	         *     }
	         *
	         */
	        function defineMetadata(metadataKey, metadataValue, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryDefineOwnMetadata(metadataKey, metadataValue, target, propertyKey);
	        }
	        exporter("defineMetadata", defineMetadata);
	        /**
	         * Gets a value indicating whether the target object or its prototype chain has the provided metadata key defined.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns `true` if the metadata key was defined on the target object or its prototype chain; otherwise, `false`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.hasMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.hasMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.hasMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.hasMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.hasMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function hasMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryHasMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("hasMetadata", hasMetadata);
	        /**
	         * Gets a value indicating whether the target object has the provided metadata key defined.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns `true` if the metadata key was defined on the target object; otherwise, `false`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.hasOwnMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function hasOwnMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryHasOwnMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("hasOwnMetadata", hasOwnMetadata);
	        /**
	         * Gets the metadata value for the provided metadata key on the target object or its prototype chain.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns The metadata value for the metadata key if found; otherwise, `undefined`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function getMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryGetMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("getMetadata", getMetadata);
	        /**
	         * Gets the metadata value for the provided metadata key on the target object.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns The metadata value for the metadata key if found; otherwise, `undefined`.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getOwnMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function getOwnMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryGetOwnMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("getOwnMetadata", getOwnMetadata);
	        /**
	         * Gets the metadata keys defined on the target object or its prototype chain.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns An array of unique metadata keys.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getMetadataKeys(Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getMetadataKeys(Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getMetadataKeys(Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getMetadataKeys(Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getMetadataKeys(Example.prototype, "method");
	         *
	         */
	        function getMetadataKeys(target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryMetadataKeys(target, propertyKey);
	        }
	        exporter("getMetadataKeys", getMetadataKeys);
	        /**
	         * Gets the unique metadata keys defined on the target object.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns An array of unique metadata keys.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.getOwnMetadataKeys(Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.getOwnMetadataKeys(Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.getOwnMetadataKeys(Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.getOwnMetadataKeys(Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.getOwnMetadataKeys(Example.prototype, "method");
	         *
	         */
	        function getOwnMetadataKeys(target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            return OrdinaryOwnMetadataKeys(target, propertyKey);
	        }
	        exporter("getOwnMetadataKeys", getOwnMetadataKeys);
	        /**
	         * Deletes the metadata entry from the target object with the provided key.
	         * @param metadataKey A key used to store and retrieve metadata.
	         * @param target The target object on which the metadata is defined.
	         * @param propertyKey (Optional) The property key for the target.
	         * @returns `true` if the metadata entry was found and deleted; otherwise, false.
	         * @example
	         *
	         *     class Example {
	         *         // property declarations are not part of ES6, though they are valid in TypeScript:
	         *         // static staticProperty;
	         *         // property;
	         *
	         *         constructor(p) { }
	         *         static staticMethod(p) { }
	         *         method(p) { }
	         *     }
	         *
	         *     // constructor
	         *     result = Reflect.deleteMetadata("custom:annotation", Example);
	         *
	         *     // property (on constructor)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example, "staticProperty");
	         *
	         *     // property (on prototype)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example.prototype, "property");
	         *
	         *     // method (on constructor)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example, "staticMethod");
	         *
	         *     // method (on prototype)
	         *     result = Reflect.deleteMetadata("custom:annotation", Example.prototype, "method");
	         *
	         */
	        function deleteMetadata(metadataKey, target, propertyKey) {
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            if (!IsObject(target))
	                throw new TypeError();
	            if (!IsUndefined(propertyKey))
	                propertyKey = ToPropertyKey(propertyKey);
	            var provider = GetMetadataProvider(target, propertyKey, /*Create*/ false);
	            if (IsUndefined(provider))
	                return false;
	            return provider.OrdinaryDeleteMetadata(metadataKey, target, propertyKey);
	        }
	        exporter("deleteMetadata", deleteMetadata);
	        function DecorateConstructor(decorators, target) {
	            for (var i = decorators.length - 1; i >= 0; --i) {
	                var decorator = decorators[i];
	                var decorated = decorator(target);
	                if (!IsUndefined(decorated) && !IsNull(decorated)) {
	                    if (!IsConstructor(decorated))
	                        throw new TypeError();
	                    target = decorated;
	                }
	            }
	            return target;
	        }
	        function DecorateProperty(decorators, target, propertyKey, descriptor) {
	            for (var i = decorators.length - 1; i >= 0; --i) {
	                var decorator = decorators[i];
	                var decorated = decorator(target, propertyKey, descriptor);
	                if (!IsUndefined(decorated) && !IsNull(decorated)) {
	                    if (!IsObject(decorated))
	                        throw new TypeError();
	                    descriptor = decorated;
	                }
	            }
	            return descriptor;
	        }
	        // 3.1.1.1 OrdinaryHasMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinaryhasmetadata
	        function OrdinaryHasMetadata(MetadataKey, O, P) {
	            var hasOwn = OrdinaryHasOwnMetadata(MetadataKey, O, P);
	            if (hasOwn)
	                return true;
	            var parent = OrdinaryGetPrototypeOf(O);
	            if (!IsNull(parent))
	                return OrdinaryHasMetadata(MetadataKey, parent, P);
	            return false;
	        }
	        // 3.1.2.1 OrdinaryHasOwnMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinaryhasownmetadata
	        function OrdinaryHasOwnMetadata(MetadataKey, O, P) {
	            var provider = GetMetadataProvider(O, P, /*Create*/ false);
	            if (IsUndefined(provider))
	                return false;
	            return ToBoolean(provider.OrdinaryHasOwnMetadata(MetadataKey, O, P));
	        }
	        // 3.1.3.1 OrdinaryGetMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarygetmetadata
	        function OrdinaryGetMetadata(MetadataKey, O, P) {
	            var hasOwn = OrdinaryHasOwnMetadata(MetadataKey, O, P);
	            if (hasOwn)
	                return OrdinaryGetOwnMetadata(MetadataKey, O, P);
	            var parent = OrdinaryGetPrototypeOf(O);
	            if (!IsNull(parent))
	                return OrdinaryGetMetadata(MetadataKey, parent, P);
	            return undefined;
	        }
	        // 3.1.4.1 OrdinaryGetOwnMetadata(MetadataKey, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarygetownmetadata
	        function OrdinaryGetOwnMetadata(MetadataKey, O, P) {
	            var provider = GetMetadataProvider(O, P, /*Create*/ false);
	            if (IsUndefined(provider))
	                return;
	            return provider.OrdinaryGetOwnMetadata(MetadataKey, O, P);
	        }
	        // 3.1.5.1 OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarydefineownmetadata
	        function OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P) {
	            var provider = GetMetadataProvider(O, P, /*Create*/ true);
	            provider.OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P);
	        }
	        // 3.1.6.1 OrdinaryMetadataKeys(O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinarymetadatakeys
	        function OrdinaryMetadataKeys(O, P) {
	            var ownKeys = OrdinaryOwnMetadataKeys(O, P);
	            var parent = OrdinaryGetPrototypeOf(O);
	            if (parent === null)
	                return ownKeys;
	            var parentKeys = OrdinaryMetadataKeys(parent, P);
	            if (parentKeys.length <= 0)
	                return ownKeys;
	            if (ownKeys.length <= 0)
	                return parentKeys;
	            var set = new _Set();
	            var keys = [];
	            for (var _i = 0, ownKeys_1 = ownKeys; _i < ownKeys_1.length; _i++) {
	                var key = ownKeys_1[_i];
	                var hasKey = set.has(key);
	                if (!hasKey) {
	                    set.add(key);
	                    keys.push(key);
	                }
	            }
	            for (var _a = 0, parentKeys_1 = parentKeys; _a < parentKeys_1.length; _a++) {
	                var key = parentKeys_1[_a];
	                var hasKey = set.has(key);
	                if (!hasKey) {
	                    set.add(key);
	                    keys.push(key);
	                }
	            }
	            return keys;
	        }
	        // 3.1.7.1 OrdinaryOwnMetadataKeys(O, P)
	        // https://rbuckton.github.io/reflect-metadata/#ordinaryownmetadatakeys
	        function OrdinaryOwnMetadataKeys(O, P) {
	            var provider = GetMetadataProvider(O, P, /*create*/ false);
	            if (!provider) {
	                return [];
	            }
	            return provider.OrdinaryOwnMetadataKeys(O, P);
	        }
	        // 6 ECMAScript Data Types and Values
	        // https://tc39.github.io/ecma262/#sec-ecmascript-data-types-and-values
	        function Type(x) {
	            if (x === null)
	                return 1 /* Null */;
	            switch (typeof x) {
	                case "undefined": return 0 /* Undefined */;
	                case "boolean": return 2 /* Boolean */;
	                case "string": return 3 /* String */;
	                case "symbol": return 4 /* Symbol */;
	                case "number": return 5 /* Number */;
	                case "object": return x === null ? 1 /* Null */ : 6 /* Object */;
	                default: return 6 /* Object */;
	            }
	        }
	        // 6.1.1 The Undefined Type
	        // https://tc39.github.io/ecma262/#sec-ecmascript-language-types-undefined-type
	        function IsUndefined(x) {
	            return x === undefined;
	        }
	        // 6.1.2 The Null Type
	        // https://tc39.github.io/ecma262/#sec-ecmascript-language-types-null-type
	        function IsNull(x) {
	            return x === null;
	        }
	        // 6.1.5 The Symbol Type
	        // https://tc39.github.io/ecma262/#sec-ecmascript-language-types-symbol-type
	        function IsSymbol(x) {
	            return typeof x === "symbol";
	        }
	        // 6.1.7 The Object Type
	        // https://tc39.github.io/ecma262/#sec-object-type
	        function IsObject(x) {
	            return typeof x === "object" ? x !== null : typeof x === "function";
	        }
	        // 7.1 Type Conversion
	        // https://tc39.github.io/ecma262/#sec-type-conversion
	        // 7.1.1 ToPrimitive(input [, PreferredType])
	        // https://tc39.github.io/ecma262/#sec-toprimitive
	        function ToPrimitive(input, PreferredType) {
	            switch (Type(input)) {
	                case 0 /* Undefined */: return input;
	                case 1 /* Null */: return input;
	                case 2 /* Boolean */: return input;
	                case 3 /* String */: return input;
	                case 4 /* Symbol */: return input;
	                case 5 /* Number */: return input;
	            }
	            var hint = "string" ;
	            var exoticToPrim = GetMethod(input, toPrimitiveSymbol);
	            if (exoticToPrim !== undefined) {
	                var result = exoticToPrim.call(input, hint);
	                if (IsObject(result))
	                    throw new TypeError();
	                return result;
	            }
	            return OrdinaryToPrimitive(input);
	        }
	        // 7.1.1.1 OrdinaryToPrimitive(O, hint)
	        // https://tc39.github.io/ecma262/#sec-ordinarytoprimitive
	        function OrdinaryToPrimitive(O, hint) {
	            var valueOf, result, toString_2; {
	                var toString_1 = O.toString;
	                if (IsCallable(toString_1)) {
	                    var result = toString_1.call(O);
	                    if (!IsObject(result))
	                        return result;
	                }
	                var valueOf = O.valueOf;
	                if (IsCallable(valueOf)) {
	                    var result = valueOf.call(O);
	                    if (!IsObject(result))
	                        return result;
	                }
	            }
	            throw new TypeError();
	        }
	        // 7.1.2 ToBoolean(argument)
	        // https://tc39.github.io/ecma262/2016/#sec-toboolean
	        function ToBoolean(argument) {
	            return !!argument;
	        }
	        // 7.1.12 ToString(argument)
	        // https://tc39.github.io/ecma262/#sec-tostring
	        function ToString(argument) {
	            return "" + argument;
	        }
	        // 7.1.14 ToPropertyKey(argument)
	        // https://tc39.github.io/ecma262/#sec-topropertykey
	        function ToPropertyKey(argument) {
	            var key = ToPrimitive(argument);
	            if (IsSymbol(key))
	                return key;
	            return ToString(key);
	        }
	        // 7.2 Testing and Comparison Operations
	        // https://tc39.github.io/ecma262/#sec-testing-and-comparison-operations
	        // 7.2.2 IsArray(argument)
	        // https://tc39.github.io/ecma262/#sec-isarray
	        function IsArray(argument) {
	            return Array.isArray
	                ? Array.isArray(argument)
	                : argument instanceof Object
	                    ? argument instanceof Array
	                    : Object.prototype.toString.call(argument) === "[object Array]";
	        }
	        // 7.2.3 IsCallable(argument)
	        // https://tc39.github.io/ecma262/#sec-iscallable
	        function IsCallable(argument) {
	            // NOTE: This is an approximation as we cannot check for [[Call]] internal method.
	            return typeof argument === "function";
	        }
	        // 7.2.4 IsConstructor(argument)
	        // https://tc39.github.io/ecma262/#sec-isconstructor
	        function IsConstructor(argument) {
	            // NOTE: This is an approximation as we cannot check for [[Construct]] internal method.
	            return typeof argument === "function";
	        }
	        // 7.2.7 IsPropertyKey(argument)
	        // https://tc39.github.io/ecma262/#sec-ispropertykey
	        function IsPropertyKey(argument) {
	            switch (Type(argument)) {
	                case 3 /* String */: return true;
	                case 4 /* Symbol */: return true;
	                default: return false;
	            }
	        }
	        function SameValueZero(x, y) {
	            return x === y || x !== x && y !== y;
	        }
	        // 7.3 Operations on Objects
	        // https://tc39.github.io/ecma262/#sec-operations-on-objects
	        // 7.3.9 GetMethod(V, P)
	        // https://tc39.github.io/ecma262/#sec-getmethod
	        function GetMethod(V, P) {
	            var func = V[P];
	            if (func === undefined || func === null)
	                return undefined;
	            if (!IsCallable(func))
	                throw new TypeError();
	            return func;
	        }
	        // 7.4 Operations on Iterator Objects
	        // https://tc39.github.io/ecma262/#sec-operations-on-iterator-objects
	        function GetIterator(obj) {
	            var method = GetMethod(obj, iteratorSymbol);
	            if (!IsCallable(method))
	                throw new TypeError(); // from Call
	            var iterator = method.call(obj);
	            if (!IsObject(iterator))
	                throw new TypeError();
	            return iterator;
	        }
	        // 7.4.4 IteratorValue(iterResult)
	        // https://tc39.github.io/ecma262/2016/#sec-iteratorvalue
	        function IteratorValue(iterResult) {
	            return iterResult.value;
	        }
	        // 7.4.5 IteratorStep(iterator)
	        // https://tc39.github.io/ecma262/#sec-iteratorstep
	        function IteratorStep(iterator) {
	            var result = iterator.next();
	            return result.done ? false : result;
	        }
	        // 7.4.6 IteratorClose(iterator, completion)
	        // https://tc39.github.io/ecma262/#sec-iteratorclose
	        function IteratorClose(iterator) {
	            var f = iterator["return"];
	            if (f)
	                f.call(iterator);
	        }
	        // 9.1 Ordinary Object Internal Methods and Internal Slots
	        // https://tc39.github.io/ecma262/#sec-ordinary-object-internal-methods-and-internal-slots
	        // 9.1.1.1 OrdinaryGetPrototypeOf(O)
	        // https://tc39.github.io/ecma262/#sec-ordinarygetprototypeof
	        function OrdinaryGetPrototypeOf(O) {
	            var proto = Object.getPrototypeOf(O);
	            if (typeof O !== "function" || O === functionPrototype)
	                return proto;
	            // TypeScript doesn't set __proto__ in ES5, as it's non-standard.
	            // Try to determine the superclass constructor. Compatible implementations
	            // must either set __proto__ on a subclass constructor to the superclass constructor,
	            // or ensure each class has a valid `constructor` property on its prototype that
	            // points back to the constructor.
	            // If this is not the same as Function.[[Prototype]], then this is definately inherited.
	            // This is the case when in ES6 or when using __proto__ in a compatible browser.
	            if (proto !== functionPrototype)
	                return proto;
	            // If the super prototype is Object.prototype, null, or undefined, then we cannot determine the heritage.
	            var prototype = O.prototype;
	            var prototypeProto = prototype && Object.getPrototypeOf(prototype);
	            if (prototypeProto == null || prototypeProto === Object.prototype)
	                return proto;
	            // If the constructor was not a function, then we cannot determine the heritage.
	            var constructor = prototypeProto.constructor;
	            if (typeof constructor !== "function")
	                return proto;
	            // If we have some kind of self-reference, then we cannot determine the heritage.
	            if (constructor === O)
	                return proto;
	            // we have a pretty good guess at the heritage.
	            return constructor;
	        }
	        // Global metadata registry
	        // - Allows `import "reflect-metadata"` and `import "reflect-metadata/no-conflict"` to interoperate.
	        // - Uses isolated metadata if `Reflect` is frozen before the registry can be installed.
	        /**
	         * Creates a registry used to allow multiple `reflect-metadata` providers.
	         */
	        function CreateMetadataRegistry() {
	            var fallback;
	            if (!IsUndefined(registrySymbol) &&
	                typeof root.Reflect !== "undefined" &&
	                !(registrySymbol in root.Reflect) &&
	                typeof root.Reflect.defineMetadata === "function") {
	                // interoperate with older version of `reflect-metadata` that did not support a registry.
	                fallback = CreateFallbackProvider(root.Reflect);
	            }
	            var first;
	            var second;
	            var rest;
	            var targetProviderMap = new _WeakMap();
	            var registry = {
	                registerProvider: registerProvider,
	                getProvider: getProvider,
	                setProvider: setProvider,
	            };
	            return registry;
	            function registerProvider(provider) {
	                if (!Object.isExtensible(registry)) {
	                    throw new Error("Cannot add provider to a frozen registry.");
	                }
	                switch (true) {
	                    case fallback === provider: break;
	                    case IsUndefined(first):
	                        first = provider;
	                        break;
	                    case first === provider: break;
	                    case IsUndefined(second):
	                        second = provider;
	                        break;
	                    case second === provider: break;
	                    default:
	                        if (rest === undefined)
	                            rest = new _Set();
	                        rest.add(provider);
	                        break;
	                }
	            }
	            function getProviderNoCache(O, P) {
	                if (!IsUndefined(first)) {
	                    if (first.isProviderFor(O, P))
	                        return first;
	                    if (!IsUndefined(second)) {
	                        if (second.isProviderFor(O, P))
	                            return first;
	                        if (!IsUndefined(rest)) {
	                            var iterator = GetIterator(rest);
	                            while (true) {
	                                var next = IteratorStep(iterator);
	                                if (!next) {
	                                    return undefined;
	                                }
	                                var provider = IteratorValue(next);
	                                if (provider.isProviderFor(O, P)) {
	                                    IteratorClose(iterator);
	                                    return provider;
	                                }
	                            }
	                        }
	                    }
	                }
	                if (!IsUndefined(fallback) && fallback.isProviderFor(O, P)) {
	                    return fallback;
	                }
	                return undefined;
	            }
	            function getProvider(O, P) {
	                var providerMap = targetProviderMap.get(O);
	                var provider;
	                if (!IsUndefined(providerMap)) {
	                    provider = providerMap.get(P);
	                }
	                if (!IsUndefined(provider)) {
	                    return provider;
	                }
	                provider = getProviderNoCache(O, P);
	                if (!IsUndefined(provider)) {
	                    if (IsUndefined(providerMap)) {
	                        providerMap = new _Map();
	                        targetProviderMap.set(O, providerMap);
	                    }
	                    providerMap.set(P, provider);
	                }
	                return provider;
	            }
	            function hasProvider(provider) {
	                if (IsUndefined(provider))
	                    throw new TypeError();
	                return first === provider || second === provider || !IsUndefined(rest) && rest.has(provider);
	            }
	            function setProvider(O, P, provider) {
	                if (!hasProvider(provider)) {
	                    throw new Error("Metadata provider not registered.");
	                }
	                var existingProvider = getProvider(O, P);
	                if (existingProvider !== provider) {
	                    if (!IsUndefined(existingProvider)) {
	                        return false;
	                    }
	                    var providerMap = targetProviderMap.get(O);
	                    if (IsUndefined(providerMap)) {
	                        providerMap = new _Map();
	                        targetProviderMap.set(O, providerMap);
	                    }
	                    providerMap.set(P, provider);
	                }
	                return true;
	            }
	        }
	        /**
	         * Gets or creates the shared registry of metadata providers.
	         */
	        function GetOrCreateMetadataRegistry() {
	            var metadataRegistry;
	            if (!IsUndefined(registrySymbol) && IsObject(root.Reflect) && Object.isExtensible(root.Reflect)) {
	                metadataRegistry = root.Reflect[registrySymbol];
	            }
	            if (IsUndefined(metadataRegistry)) {
	                metadataRegistry = CreateMetadataRegistry();
	            }
	            if (!IsUndefined(registrySymbol) && IsObject(root.Reflect) && Object.isExtensible(root.Reflect)) {
	                Object.defineProperty(root.Reflect, registrySymbol, {
	                    enumerable: false,
	                    configurable: false,
	                    writable: false,
	                    value: metadataRegistry
	                });
	            }
	            return metadataRegistry;
	        }
	        function CreateMetadataProvider(registry) {
	            // [[Metadata]] internal slot
	            // https://rbuckton.github.io/reflect-metadata/#ordinary-object-internal-methods-and-internal-slots
	            var metadata = new _WeakMap();
	            var provider = {
	                isProviderFor: function (O, P) {
	                    var targetMetadata = metadata.get(O);
	                    if (IsUndefined(targetMetadata))
	                        return false;
	                    return targetMetadata.has(P);
	                },
	                OrdinaryDefineOwnMetadata: OrdinaryDefineOwnMetadata,
	                OrdinaryHasOwnMetadata: OrdinaryHasOwnMetadata,
	                OrdinaryGetOwnMetadata: OrdinaryGetOwnMetadata,
	                OrdinaryOwnMetadataKeys: OrdinaryOwnMetadataKeys,
	                OrdinaryDeleteMetadata: OrdinaryDeleteMetadata,
	            };
	            metadataRegistry.registerProvider(provider);
	            return provider;
	            function GetOrCreateMetadataMap(O, P, Create) {
	                var targetMetadata = metadata.get(O);
	                var createdTargetMetadata = false;
	                if (IsUndefined(targetMetadata)) {
	                    if (!Create)
	                        return undefined;
	                    targetMetadata = new _Map();
	                    metadata.set(O, targetMetadata);
	                    createdTargetMetadata = true;
	                }
	                var metadataMap = targetMetadata.get(P);
	                if (IsUndefined(metadataMap)) {
	                    if (!Create)
	                        return undefined;
	                    metadataMap = new _Map();
	                    targetMetadata.set(P, metadataMap);
	                    if (!registry.setProvider(O, P, provider)) {
	                        targetMetadata.delete(P);
	                        if (createdTargetMetadata) {
	                            metadata.delete(O);
	                        }
	                        throw new Error("Wrong provider for target.");
	                    }
	                }
	                return metadataMap;
	            }
	            // 3.1.2.1 OrdinaryHasOwnMetadata(MetadataKey, O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinaryhasownmetadata
	            function OrdinaryHasOwnMetadata(MetadataKey, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return false;
	                return ToBoolean(metadataMap.has(MetadataKey));
	            }
	            // 3.1.4.1 OrdinaryGetOwnMetadata(MetadataKey, O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinarygetownmetadata
	            function OrdinaryGetOwnMetadata(MetadataKey, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return undefined;
	                return metadataMap.get(MetadataKey);
	            }
	            // 3.1.5.1 OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinarydefineownmetadata
	            function OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ true);
	                metadataMap.set(MetadataKey, MetadataValue);
	            }
	            // 3.1.7.1 OrdinaryOwnMetadataKeys(O, P)
	            // https://rbuckton.github.io/reflect-metadata/#ordinaryownmetadatakeys
	            function OrdinaryOwnMetadataKeys(O, P) {
	                var keys = [];
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return keys;
	                var keysObj = metadataMap.keys();
	                var iterator = GetIterator(keysObj);
	                var k = 0;
	                while (true) {
	                    var next = IteratorStep(iterator);
	                    if (!next) {
	                        keys.length = k;
	                        return keys;
	                    }
	                    var nextValue = IteratorValue(next);
	                    try {
	                        keys[k] = nextValue;
	                    }
	                    catch (e) {
	                        try {
	                            IteratorClose(iterator);
	                        }
	                        finally {
	                            throw e;
	                        }
	                    }
	                    k++;
	                }
	            }
	            function OrdinaryDeleteMetadata(MetadataKey, O, P) {
	                var metadataMap = GetOrCreateMetadataMap(O, P, /*Create*/ false);
	                if (IsUndefined(metadataMap))
	                    return false;
	                if (!metadataMap.delete(MetadataKey))
	                    return false;
	                if (metadataMap.size === 0) {
	                    var targetMetadata = metadata.get(O);
	                    if (!IsUndefined(targetMetadata)) {
	                        targetMetadata.delete(P);
	                        if (targetMetadata.size === 0) {
	                            metadata.delete(targetMetadata);
	                        }
	                    }
	                }
	                return true;
	            }
	        }
	        function CreateFallbackProvider(reflect) {
	            var defineMetadata = reflect.defineMetadata, hasOwnMetadata = reflect.hasOwnMetadata, getOwnMetadata = reflect.getOwnMetadata, getOwnMetadataKeys = reflect.getOwnMetadataKeys, deleteMetadata = reflect.deleteMetadata;
	            var metadataOwner = new _WeakMap();
	            var provider = {
	                isProviderFor: function (O, P) {
	                    var metadataPropertySet = metadataOwner.get(O);
	                    if (!IsUndefined(metadataPropertySet) && metadataPropertySet.has(P)) {
	                        return true;
	                    }
	                    if (getOwnMetadataKeys(O, P).length) {
	                        if (IsUndefined(metadataPropertySet)) {
	                            metadataPropertySet = new _Set();
	                            metadataOwner.set(O, metadataPropertySet);
	                        }
	                        metadataPropertySet.add(P);
	                        return true;
	                    }
	                    return false;
	                },
	                OrdinaryDefineOwnMetadata: defineMetadata,
	                OrdinaryHasOwnMetadata: hasOwnMetadata,
	                OrdinaryGetOwnMetadata: getOwnMetadata,
	                OrdinaryOwnMetadataKeys: getOwnMetadataKeys,
	                OrdinaryDeleteMetadata: deleteMetadata,
	            };
	            return provider;
	        }
	        /**
	         * Gets the metadata provider for an object. If the object has no metadata provider and this is for a create operation,
	         * then this module's metadata provider is assigned to the object.
	         */
	        function GetMetadataProvider(O, P, Create) {
	            var registeredProvider = metadataRegistry.getProvider(O, P);
	            if (!IsUndefined(registeredProvider)) {
	                return registeredProvider;
	            }
	            if (Create) {
	                if (metadataRegistry.setProvider(O, P, metadataProvider)) {
	                    return metadataProvider;
	                }
	                throw new Error("Illegal state.");
	            }
	            return undefined;
	        }
	        // naive Map shim
	        function CreateMapPolyfill() {
	            var cacheSentinel = {};
	            var arraySentinel = [];
	            var MapIterator = /** @class */ (function () {
	                function MapIterator(keys, values, selector) {
	                    this._index = 0;
	                    this._keys = keys;
	                    this._values = values;
	                    this._selector = selector;
	                }
	                MapIterator.prototype["@@iterator"] = function () { return this; };
	                MapIterator.prototype[iteratorSymbol] = function () { return this; };
	                MapIterator.prototype.next = function () {
	                    var index = this._index;
	                    if (index >= 0 && index < this._keys.length) {
	                        var result = this._selector(this._keys[index], this._values[index]);
	                        if (index + 1 >= this._keys.length) {
	                            this._index = -1;
	                            this._keys = arraySentinel;
	                            this._values = arraySentinel;
	                        }
	                        else {
	                            this._index++;
	                        }
	                        return { value: result, done: false };
	                    }
	                    return { value: undefined, done: true };
	                };
	                MapIterator.prototype.throw = function (error) {
	                    if (this._index >= 0) {
	                        this._index = -1;
	                        this._keys = arraySentinel;
	                        this._values = arraySentinel;
	                    }
	                    throw error;
	                };
	                MapIterator.prototype.return = function (value) {
	                    if (this._index >= 0) {
	                        this._index = -1;
	                        this._keys = arraySentinel;
	                        this._values = arraySentinel;
	                    }
	                    return { value: value, done: true };
	                };
	                return MapIterator;
	            }());
	            var Map = /** @class */ (function () {
	                function Map() {
	                    this._keys = [];
	                    this._values = [];
	                    this._cacheKey = cacheSentinel;
	                    this._cacheIndex = -2;
	                }
	                Object.defineProperty(Map.prototype, "size", {
	                    get: function () { return this._keys.length; },
	                    enumerable: true,
	                    configurable: true
	                });
	                Map.prototype.has = function (key) { return this._find(key, /*insert*/ false) >= 0; };
	                Map.prototype.get = function (key) {
	                    var index = this._find(key, /*insert*/ false);
	                    return index >= 0 ? this._values[index] : undefined;
	                };
	                Map.prototype.set = function (key, value) {
	                    var index = this._find(key, /*insert*/ true);
	                    this._values[index] = value;
	                    return this;
	                };
	                Map.prototype.delete = function (key) {
	                    var index = this._find(key, /*insert*/ false);
	                    if (index >= 0) {
	                        var size = this._keys.length;
	                        for (var i = index + 1; i < size; i++) {
	                            this._keys[i - 1] = this._keys[i];
	                            this._values[i - 1] = this._values[i];
	                        }
	                        this._keys.length--;
	                        this._values.length--;
	                        if (SameValueZero(key, this._cacheKey)) {
	                            this._cacheKey = cacheSentinel;
	                            this._cacheIndex = -2;
	                        }
	                        return true;
	                    }
	                    return false;
	                };
	                Map.prototype.clear = function () {
	                    this._keys.length = 0;
	                    this._values.length = 0;
	                    this._cacheKey = cacheSentinel;
	                    this._cacheIndex = -2;
	                };
	                Map.prototype.keys = function () { return new MapIterator(this._keys, this._values, getKey); };
	                Map.prototype.values = function () { return new MapIterator(this._keys, this._values, getValue); };
	                Map.prototype.entries = function () { return new MapIterator(this._keys, this._values, getEntry); };
	                Map.prototype["@@iterator"] = function () { return this.entries(); };
	                Map.prototype[iteratorSymbol] = function () { return this.entries(); };
	                Map.prototype._find = function (key, insert) {
	                    if (!SameValueZero(this._cacheKey, key)) {
	                        this._cacheIndex = -1;
	                        for (var i = 0; i < this._keys.length; i++) {
	                            if (SameValueZero(this._keys[i], key)) {
	                                this._cacheIndex = i;
	                                break;
	                            }
	                        }
	                    }
	                    if (this._cacheIndex < 0 && insert) {
	                        this._cacheIndex = this._keys.length;
	                        this._keys.push(key);
	                        this._values.push(undefined);
	                    }
	                    return this._cacheIndex;
	                };
	                return Map;
	            }());
	            return Map;
	            function getKey(key, _) {
	                return key;
	            }
	            function getValue(_, value) {
	                return value;
	            }
	            function getEntry(key, value) {
	                return [key, value];
	            }
	        }
	        // naive Set shim
	        function CreateSetPolyfill() {
	            var Set = /** @class */ (function () {
	                function Set() {
	                    this._map = new _Map();
	                }
	                Object.defineProperty(Set.prototype, "size", {
	                    get: function () { return this._map.size; },
	                    enumerable: true,
	                    configurable: true
	                });
	                Set.prototype.has = function (value) { return this._map.has(value); };
	                Set.prototype.add = function (value) { return this._map.set(value, value), this; };
	                Set.prototype.delete = function (value) { return this._map.delete(value); };
	                Set.prototype.clear = function () { this._map.clear(); };
	                Set.prototype.keys = function () { return this._map.keys(); };
	                Set.prototype.values = function () { return this._map.keys(); };
	                Set.prototype.entries = function () { return this._map.entries(); };
	                Set.prototype["@@iterator"] = function () { return this.keys(); };
	                Set.prototype[iteratorSymbol] = function () { return this.keys(); };
	                return Set;
	            }());
	            return Set;
	        }
	        // naive WeakMap shim
	        function CreateWeakMapPolyfill() {
	            var UUID_SIZE = 16;
	            var keys = HashMap.create();
	            var rootKey = CreateUniqueKey();
	            return /** @class */ (function () {
	                function WeakMap() {
	                    this._key = CreateUniqueKey();
	                }
	                WeakMap.prototype.has = function (target) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ false);
	                    return table !== undefined ? HashMap.has(table, this._key) : false;
	                };
	                WeakMap.prototype.get = function (target) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ false);
	                    return table !== undefined ? HashMap.get(table, this._key) : undefined;
	                };
	                WeakMap.prototype.set = function (target, value) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ true);
	                    table[this._key] = value;
	                    return this;
	                };
	                WeakMap.prototype.delete = function (target) {
	                    var table = GetOrCreateWeakMapTable(target, /*create*/ false);
	                    return table !== undefined ? delete table[this._key] : false;
	                };
	                WeakMap.prototype.clear = function () {
	                    // NOTE: not a real clear, just makes the previous data unreachable
	                    this._key = CreateUniqueKey();
	                };
	                return WeakMap;
	            }());
	            function CreateUniqueKey() {
	                var key;
	                do
	                    key = "@@WeakMap@@" + CreateUUID();
	                while (HashMap.has(keys, key));
	                keys[key] = true;
	                return key;
	            }
	            function GetOrCreateWeakMapTable(target, create) {
	                if (!hasOwn.call(target, rootKey)) {
	                    if (!create)
	                        return undefined;
	                    Object.defineProperty(target, rootKey, { value: HashMap.create() });
	                }
	                return target[rootKey];
	            }
	            function FillRandomBytes(buffer, size) {
	                for (var i = 0; i < size; ++i)
	                    buffer[i] = Math.random() * 0xff | 0;
	                return buffer;
	            }
	            function GenRandomBytes(size) {
	                if (typeof Uint8Array === "function") {
	                    var array = new Uint8Array(size);
	                    if (typeof crypto !== "undefined") {
	                        crypto.getRandomValues(array);
	                    }
	                    else if (typeof msCrypto !== "undefined") {
	                        msCrypto.getRandomValues(array);
	                    }
	                    else {
	                        FillRandomBytes(array, size);
	                    }
	                    return array;
	                }
	                return FillRandomBytes(new Array(size), size);
	            }
	            function CreateUUID() {
	                var data = GenRandomBytes(UUID_SIZE);
	                // mark as random - RFC 4122 § 4.4
	                data[6] = data[6] & 0x4f | 0x40;
	                data[8] = data[8] & 0xbf | 0x80;
	                var result = "";
	                for (var offset = 0; offset < UUID_SIZE; ++offset) {
	                    var byte = data[offset];
	                    if (offset === 4 || offset === 6 || offset === 8)
	                        result += "-";
	                    if (byte < 16)
	                        result += "0";
	                    result += byte.toString(16).toLowerCase();
	                }
	                return result;
	            }
	        }
	        // uses a heuristic used by v8 and chakra to force an object into dictionary mode.
	        function MakeDictionary(obj) {
	            obj.__ = undefined;
	            delete obj.__;
	            return obj;
	        }
	    });
	})(Reflect || (Reflect = {}));
	return _Reflect;
}

require_Reflect();

function e(e){return ("object"==typeof e&&null!==e||"function"==typeof e)&&"function"==typeof e.then}function t$1(e){switch(typeof e){case "string":case "symbol":return e.toString();case "function":return e.name;default:throw new Error(`Unexpected ${typeof e} service id type`)}}const n$1=Symbol.for("@inversifyjs/common/islazyServiceIdentifier");class r{[n$1];#e;constructor(e){this.#e=e,this[n$1]=true;}static is(e){return "object"==typeof e&&null!==e&&true===e[n$1]}unwrap(){return this.#e()}}

function c$2(t,n,e){return Reflect.getOwnMetadata(n,t,e)}function a$1(t,n,e,u){Reflect.defineMetadata(n,e,t,u);}function i$1(t,n,e,u,f){const r=u(c$2(t,n,f)??e());Reflect.defineMetadata(n,r,t,f);}

const a="@inversifyjs/container/bindingId";function c$1(){const i=c$2(Object,a)??0;return i===Number.MAX_SAFE_INTEGER?a$1(Object,a,Number.MIN_SAFE_INTEGER):i$1(Object,a,()=>i,e=>e+1),i}const d={Request:"Request",Singleton:"Singleton",Transient:"Transient"},u={ConstantValue:"ConstantValue",DynamicValue:"DynamicValue",Factory:"Factory",Instance:"Instance",Provider:"Provider",ResolvedValue:"ResolvedValue",ServiceRedirection:"ServiceRedirection"};function*l$1(...e){for(const t of e)yield*t;}class p{#e;#t;#n;constructor(e){this.#e=new Map,this.#t={};for(const t of Reflect.ownKeys(e))this.#t[t]=new Map;this.#n=e;}add(e,t){this.#i(e).push(t);for(const n of Reflect.ownKeys(t))this.#o(n,t[n]).push(e);}clone(){const e=this.#r(),t=this.#s(),n=Reflect.ownKeys(this.#n),i=this._buildNewInstance(this.#n);this.#a(this.#e,i.#e,e,t);for(const t of n)this.#c(this.#t[t],i.#t[t],e);return i}get(e,t){return this.#t[e].get(t)}getAllKeys(e){return this.#t[e].keys()}removeByRelation(e,t){const n=this.get(e,t);if(void 0===n)return;const i=new Set(n);for(const n of i){const i=this.#e.get(n);if(void 0===i)throw new Error("Expecting model relation, none found");for(const o of i)o[e]===t&&this.#d(n,o);this.#e.delete(n);}}_buildNewInstance(e){return new p(e)}_cloneModel(e){return e}_cloneRelation(e){return e}#r(){const e=new Map;for(const t of this.#e.keys()){const n=this._cloneModel(t);e.set(t,n);}return e}#s(){const e=new Map;for(const t of this.#e.values())for(const n of t){const t=this._cloneRelation(n);e.set(n,t);}return e}#i(e){let t=this.#e.get(e);return void 0===t&&(t=[],this.#e.set(e,t)),t}#o(e,t){let n=this.#t[e].get(t);return void 0===n&&(n=[],this.#t[e].set(t,n)),n}#u(e,t){const n=t.get(e);if(void 0===n)throw new Error("Expecting model to be cloned, none found");return n}#l(e,t){const n=t.get(e);if(void 0===n)throw new Error("Expecting relation to be cloned, none found");return n}#c(e,t,n){for(const[i,o]of e){const e=new Array;for(const t of o)e.push(this.#u(t,n));t.set(i,e);}}#a(e,t,n,i){for(const[o,r]of e){const e=new Array;for(const t of r)e.push(this.#l(t,i));t.set(this.#u(o,n),e);}}#d(e,t){for(const n of Reflect.ownKeys(t))this.#p(e,n,t[n]);}#p(e,t,n){const i=this.#t[t].get(n);if(void 0!==i){const o=i.indexOf(e);-1!==o&&i.splice(o,1),0===i.length&&this.#t[t].delete(n);}}}var f;!function(e){e.moduleId="moduleId",e.serviceId="serviceId";}(f||(f={}));class v{#f;#v;constructor(e,t){this.#f=t??new p({moduleId:{isOptional:true},serviceId:{isOptional:false}}),this.#v=e;}static build(e){return new v(e)}add(e,t){this.#f.add(e,t);}clone(){return new v(this.#v,this.#f.clone())}get(e){const t=[],n=this.#f.get(f.serviceId,e);void 0!==n&&t.push(n);const i=this.#v()?.get(e);if(void 0!==i&&t.push(i),0!==t.length)return l$1(...t)}removeAllByModuleId(e){this.#f.removeByRelation(f.moduleId,e);}removeAllByServiceId(e){this.#f.removeByRelation(f.serviceId,e);}}const h="@inversifyjs/core/classMetadataReflectKey";function g$1(){return {constructorArguments:[],lifecycle:{postConstructMethodNames:new Set,preDestroyMethodNames:new Set},properties:new Map,scope:void 0}}const m="@inversifyjs/core/pendingClassMetadataCountReflectKey";const y=Symbol.for("@inversifyjs/core/InversifyCoreError");let M$1 = class M extends Error{[y];kind;constructor(e,t,n){super(t,n),this[y]=true,this.kind=e;}static is(e){return "object"==typeof e&&null!==e&&true===e[y]}static isErrorOfKind(e,t){return M.is(e)&&e.kind===t}};var I$1,b,w,C$1,S$1;function N$1(t){const n=c$2(t,h)??g$1();if(!function(t){const n=c$2(t,m);return void 0!==n&&0!==n}(t))return function(e,t){const n=[];if(t.length<e.length)throw new M$1(I$1.missingInjectionDecorator,`Found unexpected missing metadata on type "${e.name}". "${e.name}" constructor requires at least ${e.length.toString()} arguments, found ${t.length.toString()} instead.\nAre you using @inject, @multiInject or @unmanaged decorators in every non optional constructor argument?\n\nIf you're using typescript and want to rely on auto injection, set "emitDecoratorMetadata" compiler option to true`);for(let e=0;e<t.length;++e) void 0===t[e]&&n.push(e);if(n.length>0)throw new M$1(I$1.missingInjectionDecorator,`Found unexpected missing metadata on type "${e.name}" at constructor indexes "${n.join('", "')}".\n\nAre you using @inject, @multiInject or @unmanaged decorators at those indexes?\n\nIf you're using typescript and want to rely on auto injection, set "emitDecoratorMetadata" compiler option to true`)}(t,n.constructorArguments),n;!function(e,t){const n=[];for(let i=0;i<t.constructorArguments.length;++i){const o=t.constructorArguments[i];void 0!==o&&o.kind!==b.unknown||n.push(`  - Missing or incomplete metadata for type "${e.name}" at constructor argument with index ${i.toString()}.\nEvery constructor parameter must be decorated either with @inject, @multiInject or @unmanaged decorator.`);}for(const[i,o]of t.properties)o.kind===b.unknown&&n.push(`  - Missing or incomplete metadata for type "${e.name}" at property "${i.toString()}".\nThis property must be decorated either with @inject or @multiInject decorator.`);if(0===n.length)throw new M$1(I$1.unknown,`Unexpected class metadata for type "${e.name}" with uncompletion traces.\nThis might be caused by one of the following reasons:\n\n1. A third party library is targeting inversify reflection metadata.\n2. A bug is causing the issue. Consider submiting an issue to fix it.`);throw new M$1(I$1.missingInjectionDecorator,`Invalid class metadata at type ${e.name}:\n\n${n.join("\n\n")}`)}(t,n);}function P$1(e,t){const n=N$1(t).scope??e.scope;return {cache:{isRight:false,value:void 0},id:c$1(),implementationType:t,isSatisfiedBy:()=>true,moduleId:void 0,onActivation:void 0,onDeactivation:void 0,scope:n,serviceIdentifier:t,type:u.Instance}}function A$2(e){return e.isRight?{isRight:true,value:e.value}:e}function R(e){switch(e.type){case u.ConstantValue:case u.DynamicValue:return function(e){return {cache:A$2(e.cache),id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type,value:e.value}}(e);case u.Factory:return function(e){return {cache:A$2(e.cache),factory:e.factory,id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.Instance:return function(e){return {cache:A$2(e.cache),id:e.id,implementationType:e.implementationType,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.Provider:return function(e){return {cache:A$2(e.cache),id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,provider:e.provider,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.ResolvedValue:return function(e){return {cache:A$2(e.cache),factory:e.factory,id:e.id,isSatisfiedBy:e.isSatisfiedBy,metadata:e.metadata,moduleId:e.moduleId,onActivation:e.onActivation,onDeactivation:e.onDeactivation,scope:e.scope,serviceIdentifier:e.serviceIdentifier,type:e.type}}(e);case u.ServiceRedirection:return function(e){return {id:e.id,isSatisfiedBy:e.isSatisfiedBy,moduleId:e.moduleId,serviceIdentifier:e.serviceIdentifier,targetServiceIdentifier:e.targetServiceIdentifier,type:e.type}}(e)}}!function(e){e[e.injectionDecoratorConflict=0]="injectionDecoratorConflict",e[e.missingInjectionDecorator=1]="missingInjectionDecorator",e[e.planning=2]="planning",e[e.resolution=3]="resolution",e[e.unknown=4]="unknown";}(I$1||(I$1={})),function(e){e[e.unknown=32]="unknown";}(b||(b={})),function(e){e.id="id",e.moduleId="moduleId",e.serviceId="serviceId";}(w||(w={}));let x$3 = class x extends p{_buildNewInstance(e){return new x(e)}_cloneModel(e){return R(e)}};let T$2 = class T{#h;#g;#v;constructor(e,t,n){this.#g=n??new x$3({id:{isOptional:false},moduleId:{isOptional:true},serviceId:{isOptional:false}}),this.#v=e,this.#h=t;}static build(e,t){return new T(e,t)}clone(){return new T(this.#v,this.#h,this.#g.clone())}get(e){const t=this.getNonParentBindings(e)??this.#v()?.get(e);if(void 0!==t)return t;const n=this.#m(e);return void 0===n?n:[n]}*getChained(e){const t=this.getNonParentBindings(e);void 0!==t&&(yield*t);const n=this.#v();if(void 0===n){if(void 0===t){const t=this.#m(e);void 0!==t&&(yield t);}}else yield*n.getChained(e);}getBoundServices(){const e=new Set(this.#g.getAllKeys(w.serviceId)),t=this.#v();if(void 0!==t)for(const n of t.getBoundServices())e.add(n);return e}getById(e){return this.#g.get(w.id,e)??this.#v()?.getById(e)}getByModuleId(e){return this.#g.get(w.moduleId,e)??this.#v()?.getByModuleId(e)}getNonParentBindings(e){return this.#g.get(w.serviceId,e)}getNonParentBoundServices(){return this.#g.getAllKeys(w.serviceId)}removeById(e){this.#g.removeByRelation(w.id,e);}removeAllByModuleId(e){this.#g.removeByRelation(w.moduleId,e);}removeAllByServiceId(e){this.#g.removeByRelation(w.serviceId,e);}set(e){const t={[w.id]:e.id,[w.serviceId]:e.serviceIdentifier};void 0!==e.moduleId&&(t[w.moduleId]=e.moduleId),this.#g.add(e,t);}#m(e){if(void 0===this.#h||"function"!=typeof e)return;const t=P$1(this.#h,e);return this.set(t),t}};!function(e){e.moduleId="moduleId",e.serviceId="serviceId";}(C$1||(C$1={}));let j$2 = class j{#y;#v;constructor(e,t){this.#y=t??new p({moduleId:{isOptional:true},serviceId:{isOptional:false}}),this.#v=e;}static build(e){return new j(e)}add(e,t){this.#y.add(e,t);}clone(){return new j(this.#v,this.#y.clone())}get(e){const t=[],n=this.#y.get(C$1.serviceId,e);void 0!==n&&t.push(n);const i=this.#v()?.get(e);if(void 0!==i&&t.push(i),0!==t.length)return l$1(...t)}removeAllByModuleId(e){this.#y.removeByRelation(C$1.moduleId,e);}removeAllByServiceId(e){this.#y.removeByRelation(C$1.serviceId,e);}};!function(e){e[e.multipleInjection=0]="multipleInjection",e[e.singleInjection=1]="singleInjection",e[e.unmanaged=2]="unmanaged";}(S$1||(S$1={}));var E$1;!function(e){e[e.method=0]="method",e[e.parameter=1]="parameter",e[e.property=2]="property";}(E$1||(E$1={}));const K$1="@inversifyjs/core/classIsInjectableFlagReflectKey";const q$1=[Array,BigInt,Boolean,Function,Number,Object,String];function G$1(t){const i=c$2(t,"design:paramtypes");void 0!==i&&i$1(t,h,g$1,function(e){return t=>(e.forEach((e,n)=>{var i;void 0!==t.constructorArguments[n]||(i=e,q$1.includes(i))||(t.constructorArguments[n]=function(e){return {isFromTypescriptParamType:true,kind:S$1.singleInjection,name:void 0,optional:false,tags:new Map,value:e}}(e));}),t)}(i));}function W$2(i){return o=>{!function(n){if(void 0!==c$2(n,K$1))throw new M$1(I$1.injectionDecoratorConflict,`Cannot apply @injectable decorator multiple times at class "${n.name}"`);a$1(n,K$1,true);}(o),G$1(o);}}var fe;function ve(e){if(!(e instanceof Error))return  false;return e instanceof RangeError&&/stack space|call stack|too much recursion/i.test(e.message)||"InternalError"===e.name&&/too much recursion/.test(e.message)}function he(e,t){if(ve(t)){const n=function(e){const t=[...e];if(0===t.length)return "(No dependency trace)";return t.map(t$1).join(" -> ")}(function(e){const t=new Set;for(const n of e.servicesBranch){if(t.has(n))return [...t,n];t.add(n);}return [...t]}(e));throw new M$1(I$1.planning,`Circular dependency found: ${n}`,{cause:t})}throw t}!function(e){e[e.multipleInjection=0]="multipleInjection",e[e.singleInjection=1]="singleInjection";}(fe||(fe={}));const ge=Symbol.for("@inversifyjs/core/LazyPlanServiceNode");class me{[ge];_serviceIdentifier;_serviceNode;constructor(e,t){this[ge]=true,this._serviceNode=e,this._serviceIdentifier=t;}get bindings(){return this._getNode().bindings}get isContextFree(){return this._getNode().isContextFree}get serviceIdentifier(){return this._serviceIdentifier}set bindings(e){this._getNode().bindings=e;}set isContextFree(e){this._getNode().isContextFree=e;}static is(e){return "object"==typeof e&&null!==e&&true===e[ge]}invalidate(){this._serviceNode=void 0;}isExpanded(){return void 0!==this._serviceNode}_getNode(){return void 0===this._serviceNode&&(this._serviceNode=this._buildPlanServiceNode()),this._serviceNode}}class ye{#M;constructor(e){this.#M=e;}get name(){return this.#M.elem.name}get serviceIdentifier(){return this.#M.elem.serviceIdentifier}get tags(){return this.#M.elem.tags}getAncestor(){if(this.#M.elem.getAncestorsCalled=true,void 0!==this.#M.previous)return new ye(this.#M.previous)}}function Me(e,t,n){const i=n?.customServiceIdentifier??t.serviceIdentifier,o=(true===n?.chained?[...e.operations.getBindingsChained(i)]:[...e.operations.getBindings(i)??[]]).filter(e=>e.isSatisfiedBy(t));if(0===o.length&&void 0!==e.autobindOptions&&"function"==typeof i){const n=P$1(e.autobindOptions,i);e.operations.setBinding(n),n.isSatisfiedBy(t)&&o.push(n);}return o}class Ie{last;constructor(e){this.last=e;}concat(e){return new Ie({elem:e,previous:this.last})}[Symbol.iterator](){let e=this.last;return {next:()=>{if(void 0===e)return {done:true,value:void 0};const t=e.elem;return e=e.previous,{done:false,value:t}}}}}function be(e){const t=new Map;return void 0!==e.rootConstraints.tag&&t.set(e.rootConstraints.tag.key,e.rootConstraints.tag.value),new Ie({elem:{getAncestorsCalled:false,name:e.rootConstraints.name,serviceIdentifier:e.rootConstraints.serviceIdentifier,tags:t},previous:void 0})}function we(e){return void 0!==e.redirections}function Ce(e,t,n,i){const r=n.elem.serviceIdentifier,s=n.previous?.elem.serviceIdentifier;Array.isArray(e)?function(e,t,n,i,r,s){if(0!==e.length){const t=s[s.length-1]??n,a=`Ambiguous bindings found for service: "${t$1(t)}".${Ae(s)}\n\nRegistered bindings:\n\n${e.map(e=>function(e){switch(e.type){case u.Instance:return `[ type: "${e.type}", serviceIdentifier: "${t$1(e.serviceIdentifier)}", scope: "${e.scope}", implementationType: "${e.implementationType.name}" ]`;case u.ServiceRedirection:return `[ type: "${e.type}", serviceIdentifier: "${t$1(e.serviceIdentifier)}", redirection: "${t$1(e.targetServiceIdentifier)}" ]`;default:return `[ type: "${e.type}", serviceIdentifier: "${t$1(e.serviceIdentifier)}", scope: "${e.scope}" ]`}}(e.binding)).join("\n")}\n\nTrying to resolve bindings for "${Ne(n,i)}".${Pe(r)}`;throw new M$1(I$1.planning,a)}t||Se(n,i,r,s);}(e,t,r,s,n.elem,i):function(e,t,n,i,o,r){ void 0!==e||t||Se(n,i,o,r);}(e,t,r,s,n.elem,i);}function Se(e,t,n,i){const r=i[i.length-1]??e,s=`No bindings found for service: "${t$1(r)}".\n\nTrying to resolve bindings for "${Ne(e,t)}".${Ae(i)}${Pe(n)}`;throw new M$1(I$1.planning,s)}function Ne(e,t){return void 0===t?`${t$1(e)} (Root service)`:t$1(t)}function Pe(e){const t=0===e.tags.size?"":`\n- tags:\n  - ${[...e.tags.keys()].map(e=>e.toString()).join("\n  - ")}`;return `\n\nBinding constraints:\n- service identifier: ${t$1(e.serviceIdentifier)}\n- name: ${e.name?.toString()??"-"}${t}`}function Ae(e){return 0===e.length?"":`\n\n- service redirections:\n  - ${e.map(e=>t$1(e)).join("\n  - ")}`}function Re(e,t,n,i){if(1===e.redirections.length){const[o]=e.redirections;return void(we(o)&&Re(o,t,n,[...i,o.binding.targetServiceIdentifier]))}Ce(e.redirections,t,n,i);}function xe(e,t,n){if(Array.isArray(e.bindings)&&1===e.bindings.length){const[i]=e.bindings;return void(we(i)&&Re(i,t,n,[i.binding.targetServiceIdentifier]))}Ce(e.bindings,t,n,[]);}function Te(e){return r.is(e)?e.unwrap():e}function je(e){return (t,n,i)=>{const o=Te(i.value),r=n.concat({getAncestorsCalled:false,name:i.name,serviceIdentifier:o,tags:i.tags}),s=new ye(r.last),a=i.kind===S$1.multipleInjection&&i.chained,c=Me(t,s,{chained:a}),d=[],u={bindings:d,isContextFree:true,serviceIdentifier:o};if(d.push(...e(t,r,c,u,a)),u.isContextFree=!r.last.elem.getAncestorsCalled,i.kind===S$1.singleInjection){xe(u,i.optional,r.last);const[e]=d;u.bindings=e;}return u}}function Be(e){return (t,n,i)=>{const o=Te(i.value),r=n.concat({getAncestorsCalled:false,name:i.name,serviceIdentifier:o,tags:i.tags}),s=new ye(r.last),a=i.kind===fe.multipleInjection&&i.chained,c=Me(t,s,{chained:a}),d=[],u={bindings:d,isContextFree:true,serviceIdentifier:o};if(d.push(...e(t,r,c,u,a)),u.isContextFree=!r.last.elem.getAncestorsCalled,i.kind===fe.singleInjection){xe(u,i.optional,r.last);const[e]=d;u.bindings=e;}return u}}function Fe(e){const t=function(e){return (t,n,i)=>{const o={binding:n,classMetadata:t.operations.getClassMetadata(n.implementationType),constructorParams:[],propertyParams:new Map},r={autobindOptions:t.autobindOptions,node:o,operations:t.operations,servicesBranch:t.servicesBranch};return e(r,i)}}(e),n=function(e){return (t,n,i)=>{const o={binding:n,params:[]},r={autobindOptions:t.autobindOptions,node:o,operations:t.operations,servicesBranch:t.servicesBranch};return e(r,i)}}(e),i=(e,i,r,s,a)=>{const c=we(s)?s.binding.targetServiceIdentifier:s.serviceIdentifier;e.servicesBranch.push(c);const d=[];for(const s of r)switch(s.type){case u.Instance:d.push(t(e,s,i));break;case u.ResolvedValue:d.push(n(e,s,i));break;case u.ServiceRedirection:{const t=o(e,i,s,a);d.push(t);break}default:d.push({binding:s});}return e.servicesBranch.pop(),d},o=function(e){return (t,n,i,o)=>{const r={binding:i,redirections:[]},s=Me(t,new ye(n.last),{chained:o,customServiceIdentifier:i.targetServiceIdentifier});return r.redirections.push(...e(t,n,s,r,o)),r}}(i);return i}function ke(e,t,n,i){if(void 0!==e&&(me.is(n)&&!n.isExpanded()||n.isContextFree)){const i={tree:{root:n}};t.setPlan(e,i);}else t.setNonCachedServiceNode(n,i);}class $e extends me{#I;#b;#w;#C;constructor(e,t,n,i,o){super(o,Te(i.value)),this.#b=t,this.#I=e,this.#w=n,this.#C=i;}_buildPlanServiceNode(){return this.#b(this.#I,this.#w,this.#C)}}class De extends me{#I;#S;#w;#N;constructor(e,t,n,i,o){super(o,Te(i.value)),this.#I=e,this.#S=t,this.#w=n,this.#N=i;}_buildPlanServiceNode(){return this.#S(this.#I,this.#w,this.#N)}}function Ve(e,t,n,i){const o=function(e,t){const n=function(e,t){return (n,i,o)=>{if(o.kind===S$1.unmanaged)return;const s=function(e){let t;if(0===e.tags.size)t=void 0;else {if(1!==e.tags.size)return;{const[n,i]=e.tags.entries().next().value;t={key:n,value:i};}}const n=r.is(e.value)?e.value.unwrap():e.value;return e.kind===S$1.multipleInjection?{chained:e.chained,isMultiple:true,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}:{isMultiple:false,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}}(o);if(void 0!==s){const e=n.operations.getPlan(s);if(void 0!==e&&e.tree.root.isContextFree)return e.tree.root}const a=t(n,i,o),c=new $e(n,e,i,o,a);return ke(s,n.operations,c,{bindingConstraintsList:i,chainedBindings:o.kind===S$1.multipleInjection&&o.chained,optionalBindings:o.optional}),c}}(e,t);return (e,t,i)=>{const o=t.classMetadata;for(const[r,s]of o.constructorArguments.entries())t.constructorParams[r]=n(e,i,s);for(const[r,s]of o.properties){const o=n(e,i,s);void 0!==o&&t.propertyParams.set(r,o);}return e.node}}(e,n),s=function(e,t){const n=function(e,t){return (n,i,o)=>{const s=function(e){let t;if(0===e.tags.size)t=void 0;else {if(1!==e.tags.size)return;{const[n,i]=e.tags.entries().next().value;t={key:n,value:i};}}const n=r.is(e.value)?e.value.unwrap():e.value;return e.kind===fe.multipleInjection?{chained:e.chained,isMultiple:true,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}:{isMultiple:false,name:e.name,optional:e.optional,serviceIdentifier:n,tag:t}}(o);if(void 0!==s){const e=n.operations.getPlan(s);if(void 0!==e&&e.tree.root.isContextFree)return e.tree.root}const a=t(n,i,o),c=new De(n,e,i,o,a);return ke(s,n.operations,c,{bindingConstraintsList:i,chainedBindings:o.kind===fe.multipleInjection&&o.chained,optionalBindings:o.optional}),c}}(e,t);return (e,t,i)=>{const o=t.binding.metadata;for(const[r,s]of o.arguments.entries())t.params[r]=n(e,i,s);return e.node}}(t,i);return (e,t)=>e.node.binding.type===u.Instance?o(e,e.node,t):s(e,e.node,t)}class Oe extends me{#I;constructor(e,t){super(t,t.serviceIdentifier),this.#I=e;}_buildPlanServiceNode(){return Ue(this.#I)}}const Ee=je(Le),_e=Be(Le),ze=Fe(Ve(Ee,_e,Ee,_e));function Le(e,t,n,i,o){return ze(e,t,n,i,o)}const Ue=function(e){return t=>{const n=be(t),i=new ye(n.last),o=t.rootConstraints.isMultiple&&t.rootConstraints.chained,r=Me(t,i,{chained:o}),s=[],a={bindings:s,isContextFree:true,serviceIdentifier:t.rootConstraints.serviceIdentifier};if(s.push(...e(t,n,r,a,o)),a.isContextFree=!n.last.elem.getAncestorsCalled,!t.rootConstraints.isMultiple){xe(a,t.rootConstraints.isOptional??false,n.last);const[e]=s;a.bindings=e;}return a}}(ze);function Ke(e){try{const t=function(e){return e.rootConstraints.isMultiple?{chained:e.rootConstraints.chained,isMultiple:!0,name:e.rootConstraints.name,optional:e.rootConstraints.isOptional??!1,serviceIdentifier:e.rootConstraints.serviceIdentifier,tag:e.rootConstraints.tag}:{isMultiple:!1,name:e.rootConstraints.name,optional:e.rootConstraints.isOptional??!1,serviceIdentifier:e.rootConstraints.serviceIdentifier,tag:e.rootConstraints.tag}}(e),n=e.operations.getPlan(t);if(void 0!==n)return n;const i=Ue(e),o={tree:{root:new Oe(e,i)}};return e.operations.setPlan(t,o),o}catch(t){he(e,t);}}var qe;!function(e){e.bindingAdded="bindingAdded",e.bindingRemoved="bindingRemoved";}(qe||(qe={}));class Ge{#P;#A;#R;constructor(){this.#P=[],this.#A=8,this.#R=1024;}*[Symbol.iterator](){let e=0;for(const t of this.#P){const n=t.deref();void 0===n?++e:yield n;}this.#P.length>=this.#A&&this.#x(e)&&this.#T(e);}push(e){const t=new WeakRef(e);if(this.#P.push(t),this.#P.length>=this.#A&&this.#P.length%this.#R===0){let e=0;for(const t of this.#P) void 0===t.deref()&&++e;this.#x(e)&&this.#T(e);}}#T(e){const t=new Array(this.#P.length-e);let n=0;for(const e of this.#P)e.deref()&&(t[n++]=e);this.#P=t;}#x(e){return e>=.5*this.#P.length}}const We=Fe(Ve(Ee,_e,function(e,t,n){return Xe(e,t,n)},function(e,t,n){return He(e,t,n)})),Xe=function(e){const t=je(e);return (e,n,i)=>{try{return t(e,n,i)}catch(e){if(M$1.isErrorOfKind(e,I$1.planning))return;throw e}}}(We),He=function(e){const t=Be(e);return (e,n,i)=>{try{return t(e,n,i)}catch(e){if(M$1.isErrorOfKind(e,I$1.planning))return;throw e}}}(We);function Je(e,t,n,i,o){if(me.is(t)&&!t.isExpanded())return {isContextFreeBinding:true,shouldInvalidateServiceNode:false};const r=new ye(i.last);return !n.isSatisfiedBy(r)||i.last.elem.getAncestorsCalled?{isContextFreeBinding:!i.last.elem.getAncestorsCalled,shouldInvalidateServiceNode:false}:function(e,t,n,i,o){let r;try{[r]=We(e,i,[n],t,o);}catch(e){if(ve(e))return {isContextFreeBinding:false,shouldInvalidateServiceNode:true};throw e}return function(e,t){if(Array.isArray(e.bindings))e.bindings.push(t);else {if(void 0!==e.bindings){if(!me.is(e))throw new M$1(I$1.planning,"Unexpected non-lazy plan service node. This is likely a bug in the planning logic. Please, report this issue");return {isContextFreeBinding:true,shouldInvalidateServiceNode:true}}e.bindings=t;}return {isContextFreeBinding:true,shouldInvalidateServiceNode:false}}(t,r)}(e,t,n,i,o)}function Qe(e,t,n,i){if(me.is(e)&&!e.isExpanded())return {bindingNodeRemoved:void 0,isContextFreeBinding:true};const o=new ye(n.last);if(!t.isSatisfiedBy(o)||n.last.elem.getAncestorsCalled)return {bindingNodeRemoved:void 0,isContextFreeBinding:!n.last.elem.getAncestorsCalled};let r;if(Array.isArray(e.bindings))e.bindings=e.bindings.filter(e=>e.binding!==t||(r=e,false));else if(e.bindings?.binding===t)if(r=e.bindings,i)e.bindings=void 0;else {if(!me.is(e))throw new M$1(I$1.planning,"Unexpected non-lazy plan service node. This is likely a bug in the planning logic. Please, report this issue");e.invalidate();}return {bindingNodeRemoved:r,isContextFreeBinding:true}}class Ye{#j;#B;#F;#k;#$;#D;constructor(){this.#j=new Map,this.#B=this.#V(),this.#F=this.#V(),this.#k=this.#V(),this.#$=this.#V(),this.#D=new Ge;}clearCache(){for(const e of this.#O())e.clear();for(const e of this.#D)e.clearCache();}get(e){return void 0===e.name?void 0===e.tag?this.#E(this.#B,e).get(e.serviceIdentifier):this.#E(this.#$,e).get(e.serviceIdentifier)?.get(e.tag.key)?.get(e.tag.value):void 0===e.tag?this.#E(this.#F,e).get(e.serviceIdentifier)?.get(e.name):this.#E(this.#k,e).get(e.serviceIdentifier)?.get(e.name)?.get(e.tag.key)?.get(e.tag.value)}invalidateServiceBinding(e){this.#_(e),this.#z(e),this.#L(e),this.#U(e),this.#K(e);for(const t of this.#D)t.invalidateServiceBinding(e);}set(e,t){ void 0===e.name?void 0===e.tag?this.#E(this.#B,e).set(e.serviceIdentifier,t):this.#q(this.#q(this.#E(this.#$,e),e.serviceIdentifier),e.tag.key).set(e.tag.value,t):void 0===e.tag?this.#q(this.#E(this.#F,e),e.serviceIdentifier).set(e.name,t):this.#q(this.#q(this.#q(this.#E(this.#k,e),e.serviceIdentifier),e.name),e.tag.key).set(e.tag.value,t);}setNonCachedServiceNode(e,t){let n=this.#j.get(e.serviceIdentifier);void 0===n&&(n=new Map,this.#j.set(e.serviceIdentifier,n)),n.set(e,t);}subscribe(e){this.#D.push(e);}#V(){const e=new Array(8);for(let t=0;t<e.length;++t)e[t]=new Map;return e}#G(e,t,n,i){const o=!!(2&t);let r;if(o){r={chained:!!(0&t),isMultiple:o,serviceIdentifier:e.binding.serviceIdentifier};}else r={isMultiple:o,serviceIdentifier:e.binding.serviceIdentifier};return !!(1&t)&&(r.isOptional=true),void 0!==n&&(r.name=n),void 0!==i&&(r.tag=i),{autobindOptions:void 0,operations:e.operations,rootConstraints:r,servicesBranch:[]}}#q(e,t){let n=e.get(t);return void 0===n&&(n=new Map,e.set(t,n)),n}#E(e,t){return e[this.#W(t)]}#O(){return [this.#j,...this.#B,...this.#F,...this.#k,...this.#$]}#W(e){return e.isMultiple?(e.chained?4:0)|(e.optional?1:0)|2:e.optional?1:0}#z(e){for(const[t,n]of this.#F.entries()){const i=n.get(e.binding.serviceIdentifier);if(void 0!==i)for(const[n,o]of i.entries())this.#X(e,o,t,n,void 0);}}#L(e){for(const[t,n]of this.#k.entries()){const i=n.get(e.binding.serviceIdentifier);if(void 0!==i)for(const[n,o]of i.entries())for(const[i,r]of o.entries())for(const[o,s]of r.entries())this.#X(e,s,t,n,{key:i,value:o});}}#H(e){switch(e.binding.type){case u.ServiceRedirection:for(const t of e.redirections)this.#H(t);break;case u.Instance:for(const t of e.constructorParams) void 0!==t&&this.#J(t);for(const t of e.propertyParams.values())this.#J(t);break;case u.ResolvedValue:for(const t of e.params)this.#J(t);}}#J(e){const t=this.#j.get(e.serviceIdentifier);void 0!==t&&t.has(e)&&(t.delete(e),this.#Q(e));}#Q(e){if((!me.is(e)||e.isExpanded())&&void 0!==e.bindings)if(Array.isArray(e.bindings))for(const t of e.bindings)this.#H(t);else this.#H(e.bindings);}#K(e){const t=this.#j.get(e.binding.serviceIdentifier);if(void 0!==t)switch(e.kind){case qe.bindingAdded:for(const[n,i]of t){const t=Je({autobindOptions:void 0,operations:e.operations,servicesBranch:[]},n,e.binding,i.bindingConstraintsList,i.chainedBindings);t.isContextFreeBinding?t.shouldInvalidateServiceNode&&me.is(n)&&(this.#Q(n),n.invalidate()):this.clearCache();}break;case qe.bindingRemoved:for(const[n,i]of t){const t=Qe(n,e.binding,i.bindingConstraintsList,i.optionalBindings);t.isContextFreeBinding?void 0!==t.bindingNodeRemoved&&this.#H(t.bindingNodeRemoved):this.clearCache();}}}#_(e){for(const[t,n]of this.#B.entries()){const i=n.get(e.binding.serviceIdentifier);this.#X(e,i,t,void 0,void 0);}}#U(e){for(const[t,n]of this.#$.entries()){const i=n.get(e.binding.serviceIdentifier);if(void 0!==i)for(const[n,o]of i.entries())for(const[i,r]of o.entries())this.#X(e,r,t,void 0,{key:n,value:i});}}#X(e,t,n,i,o){if(void 0!==t&&me.is(t.tree.root)){const c=this.#G(e,n,i,o);switch(e.kind){case qe.bindingAdded:{const n=(r=c,s=t.tree.root,a=e.binding,me.is(s)&&!s.isExpanded()?{isContextFreeBinding:true,shouldInvalidateServiceNode:false}:Je(r,s,a,be(r),r.rootConstraints.isMultiple&&r.rootConstraints.chained));n.isContextFreeBinding?n.shouldInvalidateServiceNode&&(this.#Q(t.tree.root),t.tree.root.invalidate()):this.clearCache();}break;case qe.bindingRemoved:{const n=function(e,t,n){return me.is(t)&&!t.isExpanded()?{bindingNodeRemoved:void 0,isContextFreeBinding:true}:Qe(t,n,be(e),e.rootConstraints.isOptional??false)}(c,t.tree.root,e.binding);n.isContextFreeBinding?void 0!==n.bindingNodeRemoved&&this.#H(n.bindingNodeRemoved):this.clearCache();}}}var r,s,a;}}function Ze(e,t){if(ve(t)){const n=function(e){const t=[...e];if(0===t.length)return "(No dependency trace)";return t.map(t$1).join(" -> ")}(function(e){const t=e.planResult.tree.root,n=[];function i(e){const t=n.indexOf(e);if(-1!==t){return [...n.slice(t),e].map(e=>e.serviceIdentifier)}n.push(e);try{for(const t of function(e){const t=[],n=e.bindings;if(void 0===n)return t;const i=e=>{if(we(e))for(const t of e.redirections)i(t);else switch(e.binding.type){case u.Instance:{const n=e;for(const e of n.constructorParams)void 0!==e&&t.push(e);for(const e of n.propertyParams.values())t.push(e);break}case u.ResolvedValue:{const n=e;for(const e of n.params)t.push(e);break}}};if(Array.isArray(n))for(const e of n)i(e);else i(n);return t}(e)){const e=i(t);if(void 0!==e)return e}}finally{n.pop();}}return i(t)??[]}(e));throw new M$1(I$1.planning,`Circular dependency found: ${n}`,{cause:t})}throw t}function et$1(e$1,t){return e(t)?(e$1.cache={isRight:true,value:t},t.then(t=>tt(e$1,t))):tt(e$1,t)}function tt(e,t){return e.cache={isRight:true,value:t},t}function nt(e$1,t,n){const i=e$1.getActivations(t);return void 0===i?n:e(n)?it(e$1,n,i[Symbol.iterator]()):function(e$1,t,n){let i=t,o=n.next();for(;true!==o.done;){const t=o.value(e$1.context,i);if(e(t))return it(e$1,t,n);i=t,o=n.next();}return i}(e$1,n,i[Symbol.iterator]())}async function it(e,t,n){let i=await t,o=n.next();for(;true!==o.done;)i=await o.value(e.context,i),o=n.next();return i}function ot(e$1,t,n){let i=n;if(void 0!==t.onActivation){const n=t.onActivation;i=e(i)?i.then(t=>n(e$1.context,t)):n(e$1.context,i);}return nt(e$1,t.serviceIdentifier,i)}function rt(e){return (t,n)=>{if(n.cache.isRight)return n.cache.value;return et$1(n,ot(t,n,e(t,n)))}}const st=rt(function(e,t){return t.value});function at(e){return e}function ct(e,t){return (n,i)=>{const o=e(i);switch(o.scope){case d.Singleton:if(o.cache.isRight)return o.cache.value;return et$1(o,ot(n,o,t(n,i)));case d.Request:{if(n.requestScopeCache.has(o.id))return n.requestScopeCache.get(o.id);const e=ot(n,o,t(n,i));return n.requestScopeCache.set(o.id,e),e}case d.Transient:return ot(n,o,t(n,i))}}}const dt=(e=>ct(at,e))(function(e,t){return t.value(e.context)});const ut=rt(function(e,t){return t.factory(e.context)});function lt(e$1,t,n){const i=function(e$1,t,n){if(!(n in e$1))throw new M$1(I$1.resolution,`Expecting a "${n.toString()}" property when resolving "${t.implementationType.name}" class @postConstruct decorated method, none found.`);if("function"!=typeof e$1[n])throw new M$1(I$1.resolution,`Expecting a "${n.toString()}" method when resolving "${t.implementationType.name}" class @postConstruct decorated method, a non function property was found instead.`);{let i;try{i=e$1[n]();}catch(e){throw new M$1(I$1.resolution,`Unexpected error found when calling "${n.toString()}" @postConstruct decorated method on class "${t.implementationType.name}"`,{cause:e})}if(e(i))return async function(e,t,n){try{await n;}catch(n){throw new M$1(I$1.resolution,`Unexpected error found when calling "${t.toString()}" @postConstruct decorated method on class "${e.implementationType.name}"`,{cause:n})}}(t,n,i)}}(e$1,t,n);return e(i)?i.then(()=>e$1):e$1}function pt(e$1,t,n){if(0===n.size)return e$1;let i=e$1;for(const e$1 of n)i=e(i)?i.then(n=>lt(n,t,e$1)):lt(i,t,e$1);return i}function ft(e$1){return (t,n,i)=>{const o=new i.binding.implementationType(...t),r=e$1(n,o,i);return e(r)?r.then(()=>pt(o,i.binding,i.classMetadata.lifecycle.postConstructMethodNames)):pt(o,i.binding,i.classMetadata.lifecycle.postConstructMethodNames)}}const vt=rt(function(e,t){return t.provider(e.context)});function ht(e){return e.binding}function gt(e){return e.binding}const mt=function(e$1){return (t,n,i)=>{const o=[];for(const[r,a]of i.propertyParams){const c=i.classMetadata.properties.get(r);if(void 0===c)throw new M$1(I$1.resolution,`Expecting metadata at property "${r.toString()}", none found`);c.kind!==S$1.unmanaged&&void 0!==a.bindings&&(n[r]=e$1(t,a),e(n[r])&&o.push((async()=>{n[r]=await n[r];})()));}if(o.length>0)return Promise.all(o).then(()=>{})}}(Nt),yt=function(e){return function t(n,i){const o=[];for(const r of i.redirections)we(r)?o.push(...t(n,r)):o.push(e(n,r));return o}}(St),Mt=function(e$1,t,n){return (i,o)=>{const r=e$1(i,o);return e(r)?t(r,i,o):n(r,i,o)}}(function(e$1){return (t,n)=>{const i=[];for(const o of n.constructorParams) void 0===o?i.push(void 0):i.push(e$1(t,o));return i.some(e)?Promise.all(i):i}}(Nt),function(e){return async(t,n,i)=>{const o=await t;return e(o,n,i)}}(ft(mt)),ft(mt)),It=function(e$1){return (t,n)=>{const i=e$1(t,n);return e(i)?i.then(e=>n.binding.factory(...e)):n.binding.factory(...i)}}(function(e$1){return (t,n)=>{const i=[];for(const o of n.params)i.push(e$1(t,o));return i.some(e)?Promise.all(i):i}}(Nt)),bt=(e=>ct(ht,e))(Mt),wt=(e=>ct(gt,e))(It);function Ct(e){try{return Nt(e,e.planResult.tree.root)}catch(t){Ze(e,t);}}function St(e,t){switch(t.binding.type){case u.ConstantValue:return st(e,t.binding);case u.DynamicValue:return dt(e,t.binding);case u.Factory:return ut(e,t.binding);case u.Instance:return bt(e,t);case u.Provider:return vt(e,t.binding);case u.ResolvedValue:return wt(e,t)}}function Nt(e$1,t){if(void 0!==t.bindings)return Array.isArray(t.bindings)?function(e$1,t){const n=[];for(const i of t)we(i)?n.push(...yt(e$1,i)):n.push(St(e$1,i));if(n.some(e))return Promise.all(n);return n}(e$1,t.bindings):function(e,t){if(we(t)){const n=yt(e,t);if(1===n.length)return n[0];throw new M$1(I$1.resolution,"Unexpected multiple resolved values on single injection")}return St(e,t)}(e$1,t.bindings)}function Pt(e){return void 0!==e.scope}function At(e,t){if("function"==typeof e[t]){return e[t]()}}function Rt(e,t){const n=e.lifecycle.preDestroyMethodNames;if(0===n.size)return;let i;for(const e of n)i=void 0===i?At(t,e):i.then(()=>At(t,e));return i}function xt(e$1,t,n){const i=e$1.getDeactivations(t);if(void 0!==i)return e(n)?Tt(n,i[Symbol.iterator]()):function(e$1,t){let n=t.next();for(;true!==n.done;){const i=n.value(e$1);if(e(i))return Tt(e$1,t);n=t.next();}}(n,i[Symbol.iterator]())}async function Tt(e,t){const n=await e;let i=t.next();for(;true!==i.done;)await i.value(n),i=t.next();}function jt(e$1,t){const n=function(e$1,t){if(t.type===u.Instance){const n=e$1.getClassMetadata(t.implementationType),i=t.cache.value;return e(i)?i.then(e=>Rt(n,e)):Rt(n,i)}}(e$1,t);return void 0===n?Bt(e$1,t):n.then(()=>Bt(e$1,t))}function Bt(e$1,t){const n=t.cache;return e(n.value)?n.value.then(n=>Ft(e$1,t,n)):Ft(e$1,t,n.value)}function Ft(e,t,n){let i;if(void 0!==t.onDeactivation){i=(0, t.onDeactivation)(n);}return void 0===i?xt(e,t.serviceIdentifier,n):i.then(()=>xt(e,t.serviceIdentifier,n))}function kt(e,t){if(void 0===t)return;const n=function(e){const t=[];for(const n of e)Pt(n)&&n.scope===d.Singleton&&n.cache.isRight&&t.push(n);return t}(t),i=[];for(const t of n){const n=jt(e,t);void 0!==n&&i.push(n);}return i.length>0?Promise.all(i).then(()=>{}):void 0}function $t(e,t){const n=e.getBindingsFromModule(t);return kt(e,n)}function Dt(e,t){const n=e.getBindings(t);return kt(e,n)}

const t=Symbol.for("@inversifyjs/plugin/isPlugin");

const I=Symbol.for("@inversifyjs/container/bindingIdentifier");function A$1(e){return "object"==typeof e&&null!==e&&true===e[I]}class P{static always=e=>true}const C=Symbol.for("@inversifyjs/container/InversifyContainerError");class B extends Error{[C];kind;constructor(e,n,i){super(n,i),this[C]=true,this.kind=e;}static is(e){return "object"==typeof e&&null!==e&&true===e[C]}static isErrorOfKind(e,n){return B.is(e)&&e.kind===n}}var O;function x$2(e){return {[I]:true,id:e.id}}function k(e){return n=>{for(let i=n.getAncestor();void 0!==i;i=i.getAncestor())if(e(i))return  true;return  false}}function N(e){return n=>n.name===e}function F(e){return n=>n.serviceIdentifier===e}function U(e,n){return i=>i.tags.has(e)&&i.tags.get(e)===n}function D(e){return void 0===e.name&&0===e.tags.size}function j$1(e){const n=k(e);return e=>!n(e)}function T$1(e){return n=>{const i=n.getAncestor();return void 0===i||!e(i)}}function V(e){return n=>{const i=n.getAncestor();return void 0!==i&&e(i)}}!function(e){e[e.invalidOperation=0]="invalidOperation";}(O||(O={}));class E{#i;constructor(e){this.#i=e;}getIdentifier(){return x$2(this.#i)}inRequestScope(){return this.#i.scope=d.Request,new G(this.#i)}inSingletonScope(){return this.#i.scope=d.Singleton,new G(this.#i)}inTransientScope(){return this.#i.scope=d.Transient,new G(this.#i)}}let L$1 = class L{#t;#r;#a;#s;constructor(e,n,i,t){this.#t=e,this.#r=n,this.#a=i,this.#s=t;}to(e){const n=N$1(e),i={cache:{isRight:false,value:void 0},id:c$1(),implementationType:e,isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:n.scope??this.#a,serviceIdentifier:this.#s,type:u.Instance};return this.#t(i),new H(i)}toSelf(){if("function"!=typeof this.#s)throw new Error('"toSelf" function can only be applied when a newable function is used as service identifier');return this.to(this.#s)}toConstantValue(e){const n={cache:{isRight:false,value:void 0},id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:d.Singleton,serviceIdentifier:this.#s,type:u.ConstantValue,value:e};return this.#t(n),new G(n)}toDynamicValue(e){const n={cache:{isRight:false,value:void 0},id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:this.#a,serviceIdentifier:this.#s,type:u.DynamicValue,value:e};return this.#t(n),new H(n)}toResolvedValue(e,n){const i={cache:{isRight:false,value:void 0},factory:e,id:c$1(),isSatisfiedBy:P.always,metadata:this.#o(n),moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:this.#a,serviceIdentifier:this.#s,type:u.ResolvedValue};return this.#t(i),new H(i)}toFactory(e){const n={cache:{isRight:false,value:void 0},factory:e,id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,scope:d.Singleton,serviceIdentifier:this.#s,type:u.Factory};return this.#t(n),new G(n)}toProvider(e){const n={cache:{isRight:false,value:void 0},id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,onActivation:void 0,onDeactivation:void 0,provider:e,scope:d.Singleton,serviceIdentifier:this.#s,type:u.Provider};return this.#t(n),new G(n)}toService(e){const n={id:c$1(),isSatisfiedBy:P.always,moduleId:this.#r,serviceIdentifier:this.#s,targetServiceIdentifier:e,type:u.ServiceRedirection};this.#t(n);}#o(e){return {arguments:(e??[]).map(e=>function(e){return "object"==typeof e&&!r.is(e)}(e)?function(e){return  true===e.isMultiple}(e)?{chained:e.chained??false,kind:fe.multipleInjection,name:e.name,optional:e.optional??false,tags:new Map((e.tags??[]).map(e=>[e.key,e.value])),value:e.serviceIdentifier}:{kind:fe.singleInjection,name:e.name,optional:e.optional??false,tags:new Map((e.tags??[]).map(e=>[e.key,e.value])),value:e.serviceIdentifier}:{kind:fe.singleInjection,name:void 0,optional:false,tags:new Map,value:e})}}};class ${#i;constructor(e){this.#i=e;}getIdentifier(){return x$2(this.#i)}onActivation(e){return this.#i.onActivation=e,new q(this.#i)}onDeactivation(e){if(this.#i.onDeactivation=e,this.#i.scope!==d.Singleton)throw new B(O.invalidOperation,`Binding for service "${t$1(this.#i.serviceIdentifier)}" has a deactivation function, but its scope is not singleton. Deactivation functions can only be used with singleton bindings.`);return new q(this.#i)}}class q{#i;constructor(e){this.#i=e;}getIdentifier(){return x$2(this.#i)}when(e){return this.#i.isSatisfiedBy=e,new $(this.#i)}whenAnyAncestor(e){return this.when(k(e))}whenAnyAncestorIs(e){return this.when(k(F(e)))}whenAnyAncestorNamed(e){return this.when(function(e){return k(N(e))}(e))}whenAnyAncestorTagged(e,n){return this.when(function(e,n){return k(U(e,n))}(e,n))}whenDefault(){return this.when(D)}whenNamed(e){return this.when(N(e))}whenNoParent(e){return this.when(T$1(e))}whenNoParentIs(e){return this.when(T$1(F(e)))}whenNoParentNamed(e){return this.when(function(e){return T$1(N(e))}(e))}whenNoParentTagged(e,n){return this.when(function(e,n){return T$1(U(e,n))}(e,n))}whenParent(e){return this.when(V(e))}whenParentIs(e){return this.when(V(F(e)))}whenParentNamed(e){return this.when(function(e){return V(N(e))}(e))}whenParentTagged(e,n){return this.when(function(e,n){return V(U(e,n))}(e,n))}whenTagged(e,n){return this.when(U(e,n))}whenNoAncestor(e){return this.when(j$1(e))}whenNoAncestorIs(e){return this.when(j$1(F(e)))}whenNoAncestorNamed(e){return this.when(function(e){return j$1(N(e))}(e))}whenNoAncestorTagged(e,n){return this.when(function(e,n){return j$1(U(e,n))}(e,n))}}class G extends q{#c;constructor(e){super(e),this.#c=new $(e);}onActivation(e){return this.#c.onActivation(e)}onDeactivation(e){return this.#c.onDeactivation(e)}}class H extends G{#d;constructor(e){super(e),this.#d=new E(e);}inRequestScope(){return this.#d.inRequestScope()}inSingletonScope(){return this.#d.inSingletonScope()}inTransientScope(){return this.#d.inTransientScope()}}class _{#l;#a;#u;#h;constructor(e,n,i,t){this.#l=e,this.#a=n,this.#u=i,this.#h=t;}bind(e){return new L$1(e=>{this.#v(e);},void 0,this.#a,e)}isBound(e,n){const i=this.#h.bindingService.get(e);return this.#g(e,i,n)}isCurrentBound(e,n){const i=this.#h.bindingService.getNonParentBindings(e);return this.#g(e,i,n)}async rebind(e){return await this.unbind(e),this.bind(e)}rebindSync(e){return this.unbindSync(e),this.bind(e)}async unbind(e){await this.#f(e);}async unbindAll(){const e=[...this.#h.bindingService.getNonParentBoundServices()];await Promise.all(e.map(async e=>Dt(this.#l,e)));for(const n of e)this.#h.activationService.removeAllByServiceId(n),this.#h.bindingService.removeAllByServiceId(n),this.#h.deactivationService.removeAllByServiceId(n);this.#h.planResultCacheService.clearCache();}unbindSync(e){ void 0!==this.#f(e)&&this.#b(e);}#v(e){this.#h.bindingService.set(e),this.#u.invalidateService({binding:e,kind:qe.bindingAdded});}#b(e){let n;if(A$1(e)){const t=this.#h.bindingService.getById(e.id),r=(i=t,function(e){if(void 0===e)return;const n=e.next();return  true!==n.done?n.value:void 0}(i?.[Symbol.iterator]()))?.serviceIdentifier;n=void 0===r?"Unexpected asynchronous deactivation when unbinding binding identifier. Consider using Container.unbind() instead.":`Unexpected asynchronous deactivation when unbinding "${t$1(r)}" binding. Consider using Container.unbind() instead.`;}else n=`Unexpected asynchronous deactivation when unbinding "${t$1(e)}" service. Consider using Container.unbind() instead.`;var i;throw new B(O.invalidOperation,n)}#f(e){return A$1(e)?this.#p(e):this.#S(e)}#p(e){const n=this.#h.bindingService.getById(e.id),i=void 0===n?void 0:[...n],t=kt(this.#l,n);if(void 0!==t)return t.then(()=>{this.#M(i,e);});this.#M(i,e);}#M(e,n){if(this.#h.bindingService.removeById(n.id),void 0!==e)for(const n of e)this.#u.invalidateService({binding:n,kind:qe.bindingRemoved});}#S(e){const n=this.#h.bindingService.get(e),i=void 0===n?void 0:[...n],t=kt(this.#l,n);if(void 0!==t)return t.then(()=>{this.#R(e,i);});this.#R(e,i);}#R(e,n){if(this.#h.activationService.removeAllByServiceId(e),this.#h.bindingService.removeAllByServiceId(e),this.#h.deactivationService.removeAllByServiceId(e),void 0!==n)for(const e of n)this.#u.invalidateService({binding:e,kind:qe.bindingRemoved});}#g(e,n,i){if(void 0===n)return  false;const t={getAncestor:()=>{},name:i?.name,serviceIdentifier:e,tags:new Map};void 0!==i?.tag&&t.tags.set(i.tag.key,i.tag.value);for(const e of n)if(e.isSatisfiedBy(t))return  true;return  false}}class z{#y;#l;#a;#u;#h;constructor(e,n,i,t,r){this.#y=e,this.#l=n,this.#a=i,this.#u=t,this.#h=r;}async load(...e){await Promise.all(this.#n(...e));}loadSync(...e){const n=this.#n(...e);for(const e of n)if(void 0!==e)throw new B(O.invalidOperation,"Unexpected asynchronous module load. Consider using Container.load() instead.")}async unload(...e){await Promise.all(this.#m(...e)),this.#w(e);}unloadSync(...e){const n=this.#m(...e);for(const e of n)if(void 0!==e)throw new B(O.invalidOperation,"Unexpected asynchronous module unload. Consider using Container.unload() instead.");this.#w(e);}#I(e){return {bind:n=>new L$1(e=>{this.#v(e);},e,this.#a,n),isBound:this.#y.isBound.bind(this.#y),onActivation:(n,i)=>{this.#h.activationService.add(i,{moduleId:e,serviceId:n});},onDeactivation:(n,i)=>{this.#h.deactivationService.add(i,{moduleId:e,serviceId:n});},rebind:this.#y.rebind.bind(this.#y),rebindSync:this.#y.rebindSync.bind(this.#y),unbind:this.#y.unbind.bind(this.#y),unbindSync:this.#y.unbindSync.bind(this.#y)}}#w(e){for(const n of e)this.#h.activationService.removeAllByModuleId(n.id),this.#h.bindingService.removeAllByModuleId(n.id),this.#h.deactivationService.removeAllByModuleId(n.id);this.#h.planResultCacheService.clearCache();}#n(...e){return e.map(e=>e.load(this.#I(e.id)))}#v(e){this.#h.bindingService.set(e),this.#u.invalidateService({binding:e,kind:qe.bindingAdded});}#m(...e){return e.map(e=>$t(this.#l,e.id))}}class K{deactivationParams;constructor(e){this.deactivationParams=function(e){return {getBindings:e.bindingService.get.bind(e.bindingService),getBindingsFromModule:e.bindingService.getByModuleId.bind(e.bindingService),getClassMetadata:N$1,getDeactivations:e.deactivationService.get.bind(e.deactivationService)}}(e),e.onReset(()=>{!function(e,n){n.getBindings=e.bindingService.get.bind(e.bindingService),n.getBindingsFromModule=e.bindingService.getByModuleId.bind(e.bindingService),n.getDeactivations=e.deactivationService.get.bind(e.deactivationService);}(e,this.deactivationParams);});}}let X$1 = class X{planParamsOperations;#h;constructor(e){this.#h=e,this.planParamsOperations={getBindings:this.#h.bindingService.get.bind(this.#h.bindingService),getBindingsChained:this.#h.bindingService.getChained.bind(this.#h.bindingService),getClassMetadata:N$1,getPlan:this.#h.planResultCacheService.get.bind(this.#h.planResultCacheService),setBinding:this.#v.bind(this),setNonCachedServiceNode:this.#h.planResultCacheService.setNonCachedServiceNode.bind(this.#h.planResultCacheService),setPlan:this.#h.planResultCacheService.set.bind(this.#h.planResultCacheService)},this.#h.onReset(()=>{this.#A();});}#A(){this.planParamsOperations.getBindings=this.#h.bindingService.get.bind(this.#h.bindingService),this.planParamsOperations.getBindingsChained=this.#h.bindingService.getChained.bind(this.#h.bindingService),this.planParamsOperations.setBinding=this.#v.bind(this);}#v(e){this.#h.bindingService.set(e),this.#h.planResultCacheService.invalidateServiceBinding({binding:e,kind:qe.bindingAdded,operations:this.planParamsOperations});}};class J{#P;#h;constructor(e,n){this.#P=e,this.#h=n;}invalidateService(e){this.#h.planResultCacheService.invalidateServiceBinding({...e,operations:this.#P.planParamsOperations});}}class Q{#C;#B;#O;#h;constructor(e,n,i){this.#h=n,this.#O=i,this.#C=this.#x(e),this.#B=this.#k();}register(e,n){const i=new n(e,this.#B);if(true!==i[t])throw new B(O.invalidOperation,"Invalid plugin. The plugin must extend the Plugin class");i.load(this.#C);}#x(e){return {define:(n,i)=>{if(Object.prototype.hasOwnProperty.call(e,n))throw new B(O.invalidOperation,`Container already has a method named "${String(n)}"`);e[n]=i;},onPlan:this.#O.onPlan.bind(this.#O)}}#k(){const e=this.#h;return {get activationService(){return e.activationService},get bindingService(){return e.bindingService},get deactivationService(){return e.deactivationService},get planResultCacheService(){return e.planResultCacheService}}}}let W$1 = class W{activationService;bindingService;deactivationService;planResultCacheService;#N;constructor(e,n,i,t){this.activationService=e,this.bindingService=n,this.deactivationService=i,this.planResultCacheService=t,this.#N=[];}reset(e,n,i){this.activationService=e,this.bindingService=n,this.deactivationService=i,this.planResultCacheService.clearCache();for(const e of this.#N)e();}onReset(e){this.#N.push(e);}};class Y{#F;#a;#U;#D;#j;#P;#h;constructor(e,n,i,t){this.#P=e,this.#h=n,this.#D=this.#T(),this.#F=i,this.#a=t,this.#U=e=>this.#h.activationService.get(e),this.#j=[],this.#h.onReset(()=>{this.#A();});}get(e$1,n){const i=this.#V(false,e$1,n),t=this.#E(i);if(e(t))throw new B(O.invalidOperation,`Unexpected asynchronous service when resolving service "${t$1(e$1)}"`);return t}getAll(e$1,n){const i=this.#V(true,e$1,n),t=this.#E(i);if(e(t))throw new B(O.invalidOperation,`Unexpected asynchronous service when resolving service "${t$1(e$1)}"`);return t}async getAllAsync(e,n){const i=this.#V(true,e,n);return this.#E(i)}async getAsync(e,n){const i=this.#V(false,e,n);return this.#E(i)}onPlan(e){this.#j.push(e);}#A(){this.#D=this.#T();}#L(e,n,i){const t=i?.name,r=i?.optional??false,a=i?.tag;return e?{chained:i?.chained??false,isMultiple:e,name:t,optional:r,serviceIdentifier:n,tag:a}:{isMultiple:e,name:t,optional:r,serviceIdentifier:n,tag:a}}#$(e,n,i){const t={autobindOptions:i?.autobind??this.#F?{scope:this.#a}:void 0,operations:this.#P.planParamsOperations,rootConstraints:this.#q(e,n,i),servicesBranch:[]};return this.#G(t,i),t}#q(e,n,i){return n?{chained:i?.chained??false,isMultiple:n,serviceIdentifier:e}:{isMultiple:n,serviceIdentifier:e}}#V(e,n,i){const t=this.#L(e,n,i),r=this.#h.planResultCacheService.get(t);if(void 0!==r)return r;const a=Ke(this.#$(n,e,i));for(const e of this.#j)e(t,a);return a}#T(){return {get:this.get.bind(this),getAll:this.getAll.bind(this),getAllAsync:this.getAllAsync.bind(this),getAsync:this.getAsync.bind(this)}}#E(e){return Ct({context:this.#D,getActivations:this.#U,planResult:e,requestScopeCache:new Map})}#G(e,n){ void 0!==n&&(void 0!==n.name&&(e.rootConstraints.name=n.name),true===n.optional&&(e.rootConstraints.isOptional=true),void 0!==n.tag&&(e.rootConstraints.tag={key:n.tag.key,value:n.tag.value}),e.rootConstraints.isMultiple&&(e.rootConstraints.chained=n?.chained??false));}}let Z$1 = class Z{#h;#H;constructor(e){this.#h=e,this.#H=[];}restore(){const e=this.#H.pop();if(void 0===e)throw new B(O.invalidOperation,"No snapshot available to restore");this.#h.reset(e.activationService,e.bindingService,e.deactivationService);}snapshot(){this.#H.push({activationService:this.#h.activationService.clone(),bindingService:this.#h.bindingService.clone(),deactivationService:this.#h.deactivationService.clone()});}};const ee$1=d.Transient;class ne{#y;#_;#z;#h;#O;#K;constructor(e){const n=e?.autobind??false,i=e?.defaultScope??ee$1;this.#h=this.#X(e,n,i);const t=new X$1(this.#h),r=new J(t,this.#h),a=new K(this.#h);this.#y=new _(a.deactivationParams,i,r,this.#h),this.#_=new z(this.#y,a.deactivationParams,i,r,this.#h),this.#O=new Y(t,this.#h,n,i),this.#z=new Q(this,this.#h,this.#O),this.#K=new Z$1(this.#h);}bind(e){return this.#y.bind(e)}get(e,n){return this.#O.get(e,n)}getAll(e,n){return this.#O.getAll(e,n)}async getAllAsync(e,n){return this.#O.getAllAsync(e,n)}async getAsync(e,n){return this.#O.getAsync(e,n)}isBound(e,n){return this.#y.isBound(e,n)}isCurrentBound(e,n){return this.#y.isCurrentBound(e,n)}async load(...e){return this.#_.load(...e)}loadSync(...e){this.#_.loadSync(...e);}onActivation(e,n){this.#h.activationService.add(n,{serviceId:e});}onDeactivation(e,n){this.#h.deactivationService.add(n,{serviceId:e});}register(e){this.#z.register(this,e);}restore(){this.#K.restore();}async rebind(e){return this.#y.rebind(e)}rebindSync(e){return this.#y.rebindSync(e)}snapshot(){this.#K.snapshot();}async unbind(e){await this.#y.unbind(e);}async unbindAll(){return this.#y.unbindAll()}unbindSync(e){this.#y.unbindSync(e);}async unload(...e){return this.#_.unload(...e)}unloadSync(...e){this.#_.unloadSync(...e);}#J(e,n){if(e)return {scope:n}}#X(e,n,i){const t=this.#J(n,i);if(void 0===e?.parent)return new W$1(v.build(()=>{}),T$2.build(()=>{},t),j$2.build(()=>{}),new Ye);const r=new Ye,a=e.parent;return a.#h.planResultCacheService.subscribe(r),new W$1(v.build(()=>a.#h.activationService),T$2.build(()=>a.#h.bindingService,t),j$2.build(()=>a.#h.deactivationService),r)}}

var NTSex = /* @__PURE__ */ ((NTSex2) => {
  NTSex2[NTSex2["GENDER_UNKOWN"] = 0] = "GENDER_UNKOWN";
  NTSex2[NTSex2["GENDER_MALE"] = 1] = "GENDER_MALE";
  NTSex2[NTSex2["GENDER_FEMALE"] = 2] = "GENDER_FEMALE";
  NTSex2[NTSex2["GENDER_PRIVACY"] = 255] = "GENDER_PRIVACY";
  return NTSex2;
})(NTSex || {});
var BuddyListReqType = /* @__PURE__ */ ((BuddyListReqType2) => {
  BuddyListReqType2[BuddyListReqType2["KNOMAL"] = 0] = "KNOMAL";
  BuddyListReqType2[BuddyListReqType2["KLETTER"] = 1] = "KLETTER";
  return BuddyListReqType2;
})(BuddyListReqType || {});
var UserDetailSource = /* @__PURE__ */ ((UserDetailSource2) => {
  UserDetailSource2[UserDetailSource2["KDB"] = 0] = "KDB";
  UserDetailSource2[UserDetailSource2["KSERVER"] = 1] = "KSERVER";
  return UserDetailSource2;
})(UserDetailSource || {});
var ProfileBizType = /* @__PURE__ */ ((ProfileBizType2) => {
  ProfileBizType2[ProfileBizType2["KALL"] = 0] = "KALL";
  ProfileBizType2[ProfileBizType2["KBASEEXTEND"] = 1] = "KBASEEXTEND";
  ProfileBizType2[ProfileBizType2["KVAS"] = 2] = "KVAS";
  ProfileBizType2[ProfileBizType2["KQZONE"] = 3] = "KQZONE";
  ProfileBizType2[ProfileBizType2["KOTHER"] = 4] = "KOTHER";
  return ProfileBizType2;
})(ProfileBizType || {});

var GroupInfoSource = /* @__PURE__ */ ((GroupInfoSource2) => {
  GroupInfoSource2[GroupInfoSource2["KUNSPECIFIED"] = 0] = "KUNSPECIFIED";
  GroupInfoSource2[GroupInfoSource2["KBIGDATACARD"] = 1] = "KBIGDATACARD";
  GroupInfoSource2[GroupInfoSource2["KDATACARD"] = 2] = "KDATACARD";
  GroupInfoSource2[GroupInfoSource2["KNOTICE"] = 3] = "KNOTICE";
  GroupInfoSource2[GroupInfoSource2["KAIO"] = 4] = "KAIO";
  GroupInfoSource2[GroupInfoSource2["KRECENTCONTACT"] = 5] = "KRECENTCONTACT";
  GroupInfoSource2[GroupInfoSource2["KMOREPANEL"] = 6] = "KMOREPANEL";
  return GroupInfoSource2;
})(GroupInfoSource || {});
var NTGroupMemberRole = /* @__PURE__ */ ((NTGroupMemberRole2) => {
  NTGroupMemberRole2[NTGroupMemberRole2["KUNSPECIFIED"] = 0] = "KUNSPECIFIED";
  NTGroupMemberRole2[NTGroupMemberRole2["KSTRANGER"] = 1] = "KSTRANGER";
  NTGroupMemberRole2[NTGroupMemberRole2["KMEMBER"] = 2] = "KMEMBER";
  NTGroupMemberRole2[NTGroupMemberRole2["KADMIN"] = 3] = "KADMIN";
  NTGroupMemberRole2[NTGroupMemberRole2["KOWNER"] = 4] = "KOWNER";
  return NTGroupMemberRole2;
})(NTGroupMemberRole || {});

var ElementType = /* @__PURE__ */ ((ElementType2) => {
  ElementType2[ElementType2["UNKNOWN"] = 0] = "UNKNOWN";
  ElementType2[ElementType2["TEXT"] = 1] = "TEXT";
  ElementType2[ElementType2["PIC"] = 2] = "PIC";
  ElementType2[ElementType2["FILE"] = 3] = "FILE";
  ElementType2[ElementType2["PTT"] = 4] = "PTT";
  ElementType2[ElementType2["VIDEO"] = 5] = "VIDEO";
  ElementType2[ElementType2["FACE"] = 6] = "FACE";
  ElementType2[ElementType2["REPLY"] = 7] = "REPLY";
  ElementType2[ElementType2["GreyTip"] = 8] = "GreyTip";
  ElementType2[ElementType2["WALLET"] = 9] = "WALLET";
  ElementType2[ElementType2["ARK"] = 10] = "ARK";
  ElementType2[ElementType2["MFACE"] = 11] = "MFACE";
  ElementType2[ElementType2["LIVEGIFT"] = 12] = "LIVEGIFT";
  ElementType2[ElementType2["STRUCTLONGMSG"] = 13] = "STRUCTLONGMSG";
  ElementType2[ElementType2["MARKDOWN"] = 14] = "MARKDOWN";
  ElementType2[ElementType2["GIPHY"] = 15] = "GIPHY";
  ElementType2[ElementType2["MULTIFORWARD"] = 16] = "MULTIFORWARD";
  ElementType2[ElementType2["INLINEKEYBOARD"] = 17] = "INLINEKEYBOARD";
  ElementType2[ElementType2["INTEXTGIFT"] = 18] = "INTEXTGIFT";
  ElementType2[ElementType2["CALENDAR"] = 19] = "CALENDAR";
  ElementType2[ElementType2["YOLOGAMERESULT"] = 20] = "YOLOGAMERESULT";
  ElementType2[ElementType2["AVRECORD"] = 21] = "AVRECORD";
  ElementType2[ElementType2["FEED"] = 22] = "FEED";
  ElementType2[ElementType2["TOFURECORD"] = 23] = "TOFURECORD";
  ElementType2[ElementType2["ACEBUBBLE"] = 24] = "ACEBUBBLE";
  ElementType2[ElementType2["ACTIVITY"] = 25] = "ACTIVITY";
  ElementType2[ElementType2["TOFU"] = 26] = "TOFU";
  ElementType2[ElementType2["FACEBUBBLE"] = 27] = "FACEBUBBLE";
  ElementType2[ElementType2["SHARELOCATION"] = 28] = "SHARELOCATION";
  ElementType2[ElementType2["TASKTOPMSG"] = 29] = "TASKTOPMSG";
  ElementType2[ElementType2["RECOMMENDEDMSG"] = 43] = "RECOMMENDEDMSG";
  ElementType2[ElementType2["ACTIONBAR"] = 44] = "ACTIONBAR";
  return ElementType2;
})(ElementType || {});
var NTMsgType = /* @__PURE__ */ ((NTMsgType2) => {
  NTMsgType2[NTMsgType2["KMSGTYPEARKSTRUCT"] = 11] = "KMSGTYPEARKSTRUCT";
  NTMsgType2[NTMsgType2["KMSGTYPEFACEBUBBLE"] = 24] = "KMSGTYPEFACEBUBBLE";
  NTMsgType2[NTMsgType2["KMSGTYPEFILE"] = 3] = "KMSGTYPEFILE";
  NTMsgType2[NTMsgType2["KMSGTYPEGIFT"] = 14] = "KMSGTYPEGIFT";
  NTMsgType2[NTMsgType2["KMSGTYPEGIPHY"] = 13] = "KMSGTYPEGIPHY";
  NTMsgType2[NTMsgType2["KMSGTYPEGRAYTIPS"] = 5] = "KMSGTYPEGRAYTIPS";
  NTMsgType2[NTMsgType2["KMSGTYPEMIX"] = 2] = "KMSGTYPEMIX";
  NTMsgType2[NTMsgType2["KMSGTYPEMULTIMSGFORWARD"] = 8] = "KMSGTYPEMULTIMSGFORWARD";
  NTMsgType2[NTMsgType2["KMSGTYPENULL"] = 1] = "KMSGTYPENULL";
  NTMsgType2[NTMsgType2["KMSGTYPEONLINEFILE"] = 21] = "KMSGTYPEONLINEFILE";
  NTMsgType2[NTMsgType2["KMSGTYPEONLINEFOLDER"] = 27] = "KMSGTYPEONLINEFOLDER";
  NTMsgType2[NTMsgType2["KMSGTYPEPROLOGUE"] = 29] = "KMSGTYPEPROLOGUE";
  NTMsgType2[NTMsgType2["KMSGTYPEPTT"] = 6] = "KMSGTYPEPTT";
  NTMsgType2[NTMsgType2["KMSGTYPEREPLY"] = 9] = "KMSGTYPEREPLY";
  NTMsgType2[NTMsgType2["KMSGTYPESHARELOCATION"] = 25] = "KMSGTYPESHARELOCATION";
  NTMsgType2[NTMsgType2["KMSGTYPESTRUCT"] = 4] = "KMSGTYPESTRUCT";
  NTMsgType2[NTMsgType2["KMSGTYPESTRUCTLONGMSG"] = 12] = "KMSGTYPESTRUCTLONGMSG";
  NTMsgType2[NTMsgType2["KMSGTYPETEXTGIFT"] = 15] = "KMSGTYPETEXTGIFT";
  NTMsgType2[NTMsgType2["KMSGTYPEUNKNOWN"] = 0] = "KMSGTYPEUNKNOWN";
  NTMsgType2[NTMsgType2["KMSGTYPEVIDEO"] = 7] = "KMSGTYPEVIDEO";
  NTMsgType2[NTMsgType2["KMSGTYPEWALLET"] = 10] = "KMSGTYPEWALLET";
  return NTMsgType2;
})(NTMsgType || {});
var PicType = /* @__PURE__ */ ((PicType2) => {
  PicType2[PicType2["NEWPIC_APNG"] = 2001] = "NEWPIC_APNG";
  PicType2[PicType2["NEWPIC_BMP"] = 1005] = "NEWPIC_BMP";
  PicType2[PicType2["NEWPIC_GIF"] = 2e3] = "NEWPIC_GIF";
  PicType2[PicType2["NEWPIC_JPEG"] = 1e3] = "NEWPIC_JPEG";
  PicType2[PicType2["NEWPIC_PNG"] = 1001] = "NEWPIC_PNG";
  PicType2[PicType2["NEWPIC_PROGERSSIV_JPEG"] = 1003] = "NEWPIC_PROGERSSIV_JPEG";
  PicType2[PicType2["NEWPIC_SHARPP"] = 1004] = "NEWPIC_SHARPP";
  PicType2[PicType2["NEWPIC_WEBP"] = 1002] = "NEWPIC_WEBP";
  return PicType2;
})(PicType || {});
var NTMsgAtType = /* @__PURE__ */ ((NTMsgAtType2) => {
  NTMsgAtType2[NTMsgAtType2["ATTYPEALL"] = 1] = "ATTYPEALL";
  NTMsgAtType2[NTMsgAtType2["ATTYPECATEGORY"] = 512] = "ATTYPECATEGORY";
  NTMsgAtType2[NTMsgAtType2["ATTYPECHANNEL"] = 16] = "ATTYPECHANNEL";
  NTMsgAtType2[NTMsgAtType2["ATTYPEME"] = 4] = "ATTYPEME";
  NTMsgAtType2[NTMsgAtType2["ATTYPEONE"] = 2] = "ATTYPEONE";
  NTMsgAtType2[NTMsgAtType2["ATTYPEONLINE"] = 64] = "ATTYPEONLINE";
  NTMsgAtType2[NTMsgAtType2["ATTYPEROLE"] = 8] = "ATTYPEROLE";
  NTMsgAtType2[NTMsgAtType2["ATTYPESUMMON"] = 32] = "ATTYPESUMMON";
  NTMsgAtType2[NTMsgAtType2["ATTYPESUMMONONLINE"] = 128] = "ATTYPESUMMONONLINE";
  NTMsgAtType2[NTMsgAtType2["ATTYPESUMMONROLE"] = 256] = "ATTYPESUMMONROLE";
  NTMsgAtType2[NTMsgAtType2["ATTYPEUNKNOWN"] = 0] = "ATTYPEUNKNOWN";
  return NTMsgAtType2;
})(NTMsgAtType || {});
var MsgSourceType = /* @__PURE__ */ ((MsgSourceType2) => {
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_AIOINNER"] = 1] = "K_DOWN_SOURCETYPE_AIOINNER";
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_BIGSCREEN"] = 2] = "K_DOWN_SOURCETYPE_BIGSCREEN";
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_HISTORY"] = 3] = "K_DOWN_SOURCETYPE_HISTORY";
  MsgSourceType2[MsgSourceType2["K_DOWN_SOURCETYPE_UNKNOWN"] = 0] = "K_DOWN_SOURCETYPE_UNKNOWN";
  return MsgSourceType2;
})(MsgSourceType || {});
var ChatType = /* @__PURE__ */ ((ChatType2) => {
  ChatType2[ChatType2["KCHATTYPEADELIE"] = 42] = "KCHATTYPEADELIE";
  ChatType2[ChatType2["KCHATTYPEBUDDYNOTIFY"] = 5] = "KCHATTYPEBUDDYNOTIFY";
  ChatType2[ChatType2["KCHATTYPEC2C"] = 1] = "KCHATTYPEC2C";
  ChatType2[ChatType2["KCHATTYPECIRCLE"] = 113] = "KCHATTYPECIRCLE";
  ChatType2[ChatType2["KCHATTYPEDATALINE"] = 8] = "KCHATTYPEDATALINE";
  ChatType2[ChatType2["KCHATTYPEDATALINEMQQ"] = 134] = "KCHATTYPEDATALINEMQQ";
  ChatType2[ChatType2["KCHATTYPEDISC"] = 3] = "KCHATTYPEDISC";
  ChatType2[ChatType2["KCHATTYPEFAV"] = 41] = "KCHATTYPEFAV";
  ChatType2[ChatType2["KCHATTYPEGAMEMESSAGE"] = 105] = "KCHATTYPEGAMEMESSAGE";
  ChatType2[ChatType2["KCHATTYPEGAMEMESSAGEFOLDER"] = 116] = "KCHATTYPEGAMEMESSAGEFOLDER";
  ChatType2[ChatType2["KCHATTYPEGROUP"] = 2] = "KCHATTYPEGROUP";
  ChatType2[ChatType2["KCHATTYPEGROUPBLESS"] = 133] = "KCHATTYPEGROUPBLESS";
  ChatType2[ChatType2["KCHATTYPEGROUPGUILD"] = 9] = "KCHATTYPEGROUPGUILD";
  ChatType2[ChatType2["KCHATTYPEGROUPHELPER"] = 7] = "KCHATTYPEGROUPHELPER";
  ChatType2[ChatType2["KCHATTYPEGROUPNOTIFY"] = 6] = "KCHATTYPEGROUPNOTIFY";
  ChatType2[ChatType2["KCHATTYPEGUILD"] = 4] = "KCHATTYPEGUILD";
  ChatType2[ChatType2["KCHATTYPEGUILDMETA"] = 16] = "KCHATTYPEGUILDMETA";
  ChatType2[ChatType2["KCHATTYPEMATCHFRIEND"] = 104] = "KCHATTYPEMATCHFRIEND";
  ChatType2[ChatType2["KCHATTYPEMATCHFRIENDFOLDER"] = 109] = "KCHATTYPEMATCHFRIENDFOLDER";
  ChatType2[ChatType2["KCHATTYPENEARBY"] = 106] = "KCHATTYPENEARBY";
  ChatType2[ChatType2["KCHATTYPENEARBYASSISTANT"] = 107] = "KCHATTYPENEARBYASSISTANT";
  ChatType2[ChatType2["KCHATTYPENEARBYFOLDER"] = 110] = "KCHATTYPENEARBYFOLDER";
  ChatType2[ChatType2["KCHATTYPENEARBYHELLOFOLDER"] = 112] = "KCHATTYPENEARBYHELLOFOLDER";
  ChatType2[ChatType2["KCHATTYPENEARBYINTERACT"] = 108] = "KCHATTYPENEARBYINTERACT";
  ChatType2[ChatType2["KCHATTYPEQQNOTIFY"] = 132] = "KCHATTYPEQQNOTIFY";
  ChatType2[ChatType2["KCHATTYPERELATEACCOUNT"] = 131] = "KCHATTYPERELATEACCOUNT";
  ChatType2[ChatType2["KCHATTYPESERVICEASSISTANT"] = 118] = "KCHATTYPESERVICEASSISTANT";
  ChatType2[ChatType2["KCHATTYPESERVICEASSISTANTSUB"] = 201] = "KCHATTYPESERVICEASSISTANTSUB";
  ChatType2[ChatType2["KCHATTYPESQUAREPUBLIC"] = 115] = "KCHATTYPESQUAREPUBLIC";
  ChatType2[ChatType2["KCHATTYPESUBSCRIBEFOLDER"] = 30] = "KCHATTYPESUBSCRIBEFOLDER";
  ChatType2[ChatType2["KCHATTYPETEMPADDRESSBOOK"] = 111] = "KCHATTYPETEMPADDRESSBOOK";
  ChatType2[ChatType2["KCHATTYPETEMPBUSSINESSCRM"] = 102] = "KCHATTYPETEMPBUSSINESSCRM";
  ChatType2[ChatType2["KCHATTYPETEMPC2CFROMGROUP"] = 100] = "KCHATTYPETEMPC2CFROMGROUP";
  ChatType2[ChatType2["KCHATTYPETEMPC2CFROMUNKNOWN"] = 99] = "KCHATTYPETEMPC2CFROMUNKNOWN";
  ChatType2[ChatType2["KCHATTYPETEMPFRIENDVERIFY"] = 101] = "KCHATTYPETEMPFRIENDVERIFY";
  ChatType2[ChatType2["KCHATTYPETEMPNEARBYPRO"] = 119] = "KCHATTYPETEMPNEARBYPRO";
  ChatType2[ChatType2["KCHATTYPETEMPPUBLICACCOUNT"] = 103] = "KCHATTYPETEMPPUBLICACCOUNT";
  ChatType2[ChatType2["KCHATTYPETEMPWPA"] = 117] = "KCHATTYPETEMPWPA";
  ChatType2[ChatType2["KCHATTYPEUNKNOWN"] = 0] = "KCHATTYPEUNKNOWN";
  ChatType2[ChatType2["KCHATTYPEWEIYUN"] = 40] = "KCHATTYPEWEIYUN";
  return ChatType2;
})(ChatType || {});
var NTGrayTipElementSubTypeV2 = /* @__PURE__ */ ((NTGrayTipElementSubTypeV22) => {
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_AIOOP"] = 15] = "GRAYTIP_ELEMENT_SUBTYPE_AIOOP";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_BLOCK"] = 14] = "GRAYTIP_ELEMENT_SUBTYPE_BLOCK";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_BUDDY"] = 5] = "GRAYTIP_ELEMENT_SUBTYPE_BUDDY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_BUDDYNOTIFY"] = 9] = "GRAYTIP_ELEMENT_SUBTYPE_BUDDYNOTIFY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_EMOJIREPLY"] = 3] = "GRAYTIP_ELEMENT_SUBTYPE_EMOJIREPLY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_ESSENCE"] = 7] = "GRAYTIP_ELEMENT_SUBTYPE_ESSENCE";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_FEED"] = 6] = "GRAYTIP_ELEMENT_SUBTYPE_FEED";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_FEEDCHANNELMSG"] = 11] = "GRAYTIP_ELEMENT_SUBTYPE_FEEDCHANNELMSG";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_FILE"] = 10] = "GRAYTIP_ELEMENT_SUBTYPE_FILE";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_GROUP"] = 4] = "GRAYTIP_ELEMENT_SUBTYPE_GROUP";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_GROUPNOTIFY"] = 8] = "GRAYTIP_ELEMENT_SUBTYPE_GROUPNOTIFY";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_JSON"] = 17] = "GRAYTIP_ELEMENT_SUBTYPE_JSON";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_LOCALMSG"] = 13] = "GRAYTIP_ELEMENT_SUBTYPE_LOCALMSG";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_PROCLAMATION"] = 2] = "GRAYTIP_ELEMENT_SUBTYPE_PROCLAMATION";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_REVOKE"] = 1] = "GRAYTIP_ELEMENT_SUBTYPE_REVOKE";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_UNKNOWN"] = 0] = "GRAYTIP_ELEMENT_SUBTYPE_UNKNOWN";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_WALLET"] = 16] = "GRAYTIP_ELEMENT_SUBTYPE_WALLET";
  NTGrayTipElementSubTypeV22[NTGrayTipElementSubTypeV22["GRAYTIP_ELEMENT_SUBTYPE_XMLMSG"] = 12] = "GRAYTIP_ELEMENT_SUBTYPE_XMLMSG";
  return NTGrayTipElementSubTypeV22;
})(NTGrayTipElementSubTypeV2 || {});
var FaceIndex = /* @__PURE__ */ ((FaceIndex2) => {
  FaceIndex2[FaceIndex2["DICE"] = 358] = "DICE";
  FaceIndex2[FaceIndex2["RPS"] = 359] = "RPS";
  return FaceIndex2;
})(FaceIndex || {});
var TipGroupElementType = /* @__PURE__ */ ((TipGroupElementType2) => {
  TipGroupElementType2[TipGroupElementType2["KUNKNOWN"] = 0] = "KUNKNOWN";
  TipGroupElementType2[TipGroupElementType2["KMEMBERADD"] = 1] = "KMEMBERADD";
  TipGroupElementType2[TipGroupElementType2["KDISBANDED"] = 2] = "KDISBANDED";
  TipGroupElementType2[TipGroupElementType2["KQUITTE"] = 3] = "KQUITTE";
  TipGroupElementType2[TipGroupElementType2["KCREATED"] = 4] = "KCREATED";
  TipGroupElementType2[TipGroupElementType2["KGROUPNAMEMODIFIED"] = 5] = "KGROUPNAMEMODIFIED";
  TipGroupElementType2[TipGroupElementType2["KBLOCK"] = 6] = "KBLOCK";
  TipGroupElementType2[TipGroupElementType2["KUNBLOCK"] = 7] = "KUNBLOCK";
  TipGroupElementType2[TipGroupElementType2["KSHUTUP"] = 8] = "KSHUTUP";
  TipGroupElementType2[TipGroupElementType2["KBERECYCLED"] = 9] = "KBERECYCLED";
  TipGroupElementType2[TipGroupElementType2["KDISBANDORBERECYCLED"] = 10] = "KDISBANDORBERECYCLED";
  return TipGroupElementType2;
})(TipGroupElementType || {});
var SendStatusType = /* @__PURE__ */ ((SendStatusType2) => {
  SendStatusType2[SendStatusType2["KSEND_STATUS_FAILED"] = 0] = "KSEND_STATUS_FAILED";
  SendStatusType2[SendStatusType2["KSEND_STATUS_SENDING"] = 1] = "KSEND_STATUS_SENDING";
  SendStatusType2[SendStatusType2["KSEND_STATUS_SUCCESS"] = 2] = "KSEND_STATUS_SUCCESS";
  SendStatusType2[SendStatusType2["KSEND_STATUS_SUCCESS_NOSEQ"] = 3] = "KSEND_STATUS_SUCCESS_NOSEQ";
  return SendStatusType2;
})(SendStatusType || {});
var FaceType = /* @__PURE__ */ ((FaceType2) => {
  FaceType2[FaceType2["Unknown"] = 0] = "Unknown";
  FaceType2[FaceType2["OldFace"] = 1] = "OldFace";
  FaceType2[FaceType2["Normal"] = 2] = "Normal";
  FaceType2[FaceType2["AniSticke"] = 3] = "AniSticke";
  FaceType2[FaceType2["Lottie"] = 4] = "Lottie";
  FaceType2[FaceType2["Poke"] = 5] = "Poke";
  return FaceType2;
})(FaceType || {});

var GroupNotifyMsgType = /* @__PURE__ */ ((GroupNotifyMsgType2) => {
  GroupNotifyMsgType2[GroupNotifyMsgType2["UN_SPECIFIED"] = 0] = "UN_SPECIFIED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["INVITED_BY_MEMBER"] = 1] = "INVITED_BY_MEMBER";
  GroupNotifyMsgType2[GroupNotifyMsgType2["REFUSE_INVITED"] = 2] = "REFUSE_INVITED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["REFUSED_BY_ADMINI_STRATOR"] = 3] = "REFUSED_BY_ADMINI_STRATOR";
  GroupNotifyMsgType2[GroupNotifyMsgType2["AGREED_TOJOIN_DIRECT"] = 4] = "AGREED_TOJOIN_DIRECT";
  GroupNotifyMsgType2[GroupNotifyMsgType2["INVITED_NEED_ADMINI_STRATOR_PASS"] = 5] = "INVITED_NEED_ADMINI_STRATOR_PASS";
  GroupNotifyMsgType2[GroupNotifyMsgType2["AGREED_TO_JOIN_BY_ADMINI_STRATOR"] = 6] = "AGREED_TO_JOIN_BY_ADMINI_STRATOR";
  GroupNotifyMsgType2[GroupNotifyMsgType2["REQUEST_JOIN_NEED_ADMINI_STRATOR_PASS"] = 7] = "REQUEST_JOIN_NEED_ADMINI_STRATOR_PASS";
  GroupNotifyMsgType2[GroupNotifyMsgType2["SET_ADMIN"] = 8] = "SET_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["KICK_MEMBER_NOTIFY_ADMIN"] = 9] = "KICK_MEMBER_NOTIFY_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["KICK_MEMBER_NOTIFY_KICKED"] = 10] = "KICK_MEMBER_NOTIFY_KICKED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["MEMBER_LEAVE_NOTIFY_ADMIN"] = 11] = "MEMBER_LEAVE_NOTIFY_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["CANCEL_ADMIN_NOTIFY_CANCELED"] = 12] = "CANCEL_ADMIN_NOTIFY_CANCELED";
  GroupNotifyMsgType2[GroupNotifyMsgType2["CANCEL_ADMIN_NOTIFY_ADMIN"] = 13] = "CANCEL_ADMIN_NOTIFY_ADMIN";
  GroupNotifyMsgType2[GroupNotifyMsgType2["TRANSFER_GROUP_NOTIFY_OLDOWNER"] = 14] = "TRANSFER_GROUP_NOTIFY_OLDOWNER";
  GroupNotifyMsgType2[GroupNotifyMsgType2["TRANSFER_GROUP_NOTIFY_ADMIN"] = 15] = "TRANSFER_GROUP_NOTIFY_ADMIN";
  return GroupNotifyMsgType2;
})(GroupNotifyMsgType || {});
var GroupNotifyMsgStatus = /* @__PURE__ */ ((GroupNotifyMsgStatus2) => {
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KINIT"] = 0] = "KINIT";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KUNHANDLE"] = 1] = "KUNHANDLE";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KAGREED"] = 2] = "KAGREED";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KREFUSED"] = 3] = "KREFUSED";
  GroupNotifyMsgStatus2[GroupNotifyMsgStatus2["KIGNORED"] = 4] = "KIGNORED";
  return GroupNotifyMsgStatus2;
})(GroupNotifyMsgStatus || {});
var NTGroupRequestOperateTypes = /* @__PURE__ */ ((NTGroupRequestOperateTypes2) => {
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KUNSPECIFIED"] = 0] = "KUNSPECIFIED";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KAGREE"] = 1] = "KAGREE";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KREFUSE"] = 2] = "KREFUSE";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KIGNORE"] = 3] = "KIGNORE";
  NTGroupRequestOperateTypes2[NTGroupRequestOperateTypes2["KDELETE"] = 4] = "KDELETE";
  return NTGroupRequestOperateTypes2;
})(NTGroupRequestOperateTypes || {});
var BuddyReqType = /* @__PURE__ */ ((BuddyReqType2) => {
  BuddyReqType2[BuddyReqType2["KMEINITIATOR"] = 0] = "KMEINITIATOR";
  BuddyReqType2[BuddyReqType2["KPEERINITIATOR"] = 1] = "KPEERINITIATOR";
  BuddyReqType2[BuddyReqType2["KMEAGREED"] = 2] = "KMEAGREED";
  BuddyReqType2[BuddyReqType2["KMEAGREEDANDADDED"] = 3] = "KMEAGREEDANDADDED";
  BuddyReqType2[BuddyReqType2["KPEERAGREED"] = 4] = "KPEERAGREED";
  BuddyReqType2[BuddyReqType2["KPEERAGREEDANDADDED"] = 5] = "KPEERAGREEDANDADDED";
  BuddyReqType2[BuddyReqType2["KPEERREFUSED"] = 6] = "KPEERREFUSED";
  BuddyReqType2[BuddyReqType2["KMEREFUSED"] = 7] = "KMEREFUSED";
  BuddyReqType2[BuddyReqType2["KMEIGNORED"] = 8] = "KMEIGNORED";
  BuddyReqType2[BuddyReqType2["KMEAGREEANYONE"] = 9] = "KMEAGREEANYONE";
  BuddyReqType2[BuddyReqType2["KMESETQUESTION"] = 10] = "KMESETQUESTION";
  BuddyReqType2[BuddyReqType2["KMEAGREEANDADDFAILED"] = 11] = "KMEAGREEANDADDFAILED";
  BuddyReqType2[BuddyReqType2["KMSGINFO"] = 12] = "KMSGINFO";
  BuddyReqType2[BuddyReqType2["KMEINITIATORWAITPEERCONFIRM"] = 13] = "KMEINITIATORWAITPEERCONFIRM";
  return BuddyReqType2;
})(BuddyReqType || {});
var MemberExtSourceType = /* @__PURE__ */ ((MemberExtSourceType2) => {
  MemberExtSourceType2[MemberExtSourceType2["DEFAULTTYPE"] = 0] = "DEFAULTTYPE";
  MemberExtSourceType2[MemberExtSourceType2["TITLETYPE"] = 1] = "TITLETYPE";
  MemberExtSourceType2[MemberExtSourceType2["NEWGROUPTYPE"] = 2] = "NEWGROUPTYPE";
  return MemberExtSourceType2;
})(MemberExtSourceType || {});

var WebHonorType = /* @__PURE__ */ ((WebHonorType2) => {
  WebHonorType2["ALL"] = "all";
  WebHonorType2["TALKATIVE"] = "talkative";
  WebHonorType2["PERFORMER"] = "performer";
  WebHonorType2["LEGEND"] = "legend";
  WebHonorType2["STRONG_NEWBIE"] = "strong_newbie";
  WebHonorType2["EMOTION"] = "emotion";
  return WebHonorType2;
})(WebHonorType || {});

const IMAGE_HTTP_HOST = "https://gchat.qpic.cn";
const IMAGE_HTTP_HOST_NT = "https://multimedia.nt.qq.com.cn";

var JsonGrayBusiId = /* @__PURE__ */ ((JsonGrayBusiId2) => {
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_AV_C2C_NOTICE"] = 2021] = "AIO_AV_C2C_NOTICE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_AV_GROUP_NOTICE"] = 2022] = "AIO_AV_GROUP_NOTICE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_C2C_DONT_DISTURB"] = 2100] = "AIO_C2C_DONT_DISTURB";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_CRM_FLAGS_TIPS"] = 2050] = "AIO_CRM_FLAGS_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_GROUP_ESSENCE_MSG_TIP"] = 2401] = "AIO_GROUP_ESSENCE_MSG_TIP";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_NUDGE_CUSTOM_GUIDE"] = 2041] = "AIO_NUDGE_CUSTOM_GUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_PUSH_GUIDE_GRAY_TIPS"] = 2701] = "AIO_PUSH_GUIDE_GRAY_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_RECALL_MSGCUSTOM_WORDINGGUIDE"] = 2e3] = "AIO_RECALL_MSGCUSTOM_WORDINGGUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ROBOT_SAFETY_TIP"] = 2201] = "AIO_ROBOT_SAFETY_TIP";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ZPLAN_EMOTICON_GUIDE"] = 2301] = "AIO_ZPLAN_EMOTICON_GUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ZPLAN_SCENE_LINKAGE"] = 2302] = "AIO_ZPLAN_SCENE_LINKAGE";
  JsonGrayBusiId2[JsonGrayBusiId2["AIO_ZPLAN_SEND_MEME"] = 2300] = "AIO_ZPLAN_SEND_MEME";
  JsonGrayBusiId2[JsonGrayBusiId2["DISBAND_DISCUSSION_GRAY_TIP_ID"] = 2603] = "DISBAND_DISCUSSION_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["FILE_SENDING_SIZE_4GB_LIMIT"] = 3003] = "FILE_SENDING_SIZE_4GB_LIMIT";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_CONFIGURABLE_GRAY_TIPS"] = 2407] = "GROUP_AIO_CONFIGURABLE_GRAY_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_HOME_SCHOOL_WELCOME_GRAY_TIP_ID"] = 2404] = "GROUP_AIO_HOME_SCHOOL_WELCOME_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_MSG_FREQUENCY_GRAY_TIP_ID"] = 2406] = "GROUP_AIO_MSG_FREQUENCY_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_SHUTUP_GRAY_TIP_ID"] = 2402] = "GROUP_AIO_SHUTUP_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_TEMPORARY_GRAY_TIP_ID"] = 2405] = "GROUP_AIO_TEMPORARY_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_UNREAD_MSG_AI_SUMMARY"] = 2408] = "GROUP_AIO_UNREAD_MSG_AI_SUMMARY";
  JsonGrayBusiId2[JsonGrayBusiId2["GROUP_AIO_UPLOAD_PERMISSIONS_GRAY_TIP_ID"] = 2403] = "GROUP_AIO_UPLOAD_PERMISSIONS_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["LITE_ACTION"] = 86] = "LITE_ACTION";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_CANCEL_RECV_ON_RECVING"] = 4] = "ONLINE_FILE_CANCEL_RECV_ON_RECVING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_GO_OFFLINE"] = 11] = "ONLINE_FILE_GO_OFFLINE";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_GO_OFFLINE_ALL"] = 12] = "ONLINE_FILE_GO_OFFLINE_ALL";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_RECV_BY_MOBILE"] = 13] = "ONLINE_FILE_RECV_BY_MOBILE";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_RECV_ERROR"] = 10] = "ONLINE_FILE_RECV_ERROR";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_REFUSE_ALL_RECV"] = 7] = "ONLINE_FILE_REFUSE_ALL_RECV";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_REFUSE_ALL_RECV_ON_RECVING"] = 8] = "ONLINE_FILE_REFUSE_ALL_RECV_ON_RECVING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_REFUSE_RECV"] = 3] = "ONLINE_FILE_REFUSE_RECV";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_SEND_ERROR"] = 9] = "ONLINE_FILE_SEND_ERROR";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_ALL_SEND"] = 5] = "ONLINE_FILE_STOP_ALL_SEND";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_ALL_SEND_ON_SENDING"] = 6] = "ONLINE_FILE_STOP_ALL_SEND_ON_SENDING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_SEND"] = 1] = "ONLINE_FILE_STOP_SEND";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_FILE_STOP_SEND_ON_SENDING"] = 2] = "ONLINE_FILE_STOP_SEND_ON_SENDING";
  JsonGrayBusiId2[JsonGrayBusiId2["ONLINE_GROUP_HOME_WORK"] = 51] = "ONLINE_GROUP_HOME_WORK";
  JsonGrayBusiId2[JsonGrayBusiId2["PTT_AUTO_CHANGE_GUIDE"] = 2060] = "PTT_AUTO_CHANGE_GUIDE";
  JsonGrayBusiId2[JsonGrayBusiId2["QCIRCLE_SHOW_FULE_TIPS"] = 2601] = "QCIRCLE_SHOW_FULE_TIPS";
  JsonGrayBusiId2[JsonGrayBusiId2["QWALLET_GRAY_TIP_ID"] = 2602] = "QWALLET_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RED_BAG"] = 81] = "RED_BAG";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_GROUP_AIO_SETUP_GROUP_AND_REMARK"] = 1005] = "RELATION_C2C_GROUP_AIO_SETUP_GROUP_AND_REMARK";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_LOVER_BONUS"] = 1003] = "RELATION_C2C_LOVER_BONUS";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_MEMBER_ADD"] = 1017] = "RELATION_C2C_MEMBER_ADD";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_REACTIVE_DEGRADE_MSG"] = 1019] = "RELATION_C2C_REACTIVE_DEGRADE_MSG";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_REACTIVE_UPGRADE_MSG"] = 1018] = "RELATION_C2C_REACTIVE_UPGRADE_MSG";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_C2C_SAY_HELLO"] = 1004] = "RELATION_C2C_SAY_HELLO";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_CHAIN_BLACKED"] = 1e3] = "RELATION_CHAIN_BLACKED";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_CHAIN_MATCH_FRIEND"] = 1007] = "RELATION_CHAIN_MATCH_FRIEND";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_CREATE_GROUP_GRAY_TIP_ID"] = 1009] = "RELATION_CREATE_GROUP_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_EMOJIEGG_SHOW"] = 1001] = "RELATION_EMOJIEGG_SHOW";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_EMOJIEGG_WILL_DEGRADE"] = 1002] = "RELATION_EMOJIEGG_WILL_DEGRADE";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_FRIEND_CLONE_INFO"] = 1006] = "RELATION_FRIEND_CLONE_INFO";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_BATCH_ADD_FRIEND"] = 1020] = "RELATION_GROUP_BATCH_ADD_FRIEND";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_ADD"] = 1022] = "RELATION_GROUP_MEMBER_ADD";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_ADD_WITH_MODIFY_NAME"] = 1015] = "RELATION_GROUP_MEMBER_ADD_WITH_MODIFY_NAME";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_ADD_WITH_WELCOME"] = 1016] = "RELATION_GROUP_MEMBER_ADD_WITH_WELCOME";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_MEMBER_RECOMMEND"] = 1021] = "RELATION_GROUP_MEMBER_RECOMMEND";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_GROUP_SHUT_UP"] = 1014] = "RELATION_GROUP_SHUT_UP";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_LIMIT_TMP_CONVERSATION_SET"] = 1011] = "RELATION_LIMIT_TMP_CONVERSATION_SET";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_NEARBY_GOTO_VERIFY"] = 1008] = "RELATION_NEARBY_GOTO_VERIFY";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_ONEWAY_FRIEND_GRAY_TIP_ID"] = 1012] = "RELATION_ONEWAY_FRIEND_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_ONEWAY_FRIEND_NEW_GRAY_TIP_ID"] = 1013] = "RELATION_ONEWAY_FRIEND_NEW_GRAY_TIP_ID";
  JsonGrayBusiId2[JsonGrayBusiId2["RELATION_YQT"] = 1010] = "RELATION_YQT";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_ACTIVE"] = 19264] = "TROOP_ADD_FRIEND_ACTIVE";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_HOT_CHAT"] = 19265] = "TROOP_ADD_FRIEND_HOT_CHAT";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_NEW_MEMBER"] = 19267] = "TROOP_ADD_FRIEND_NEW_MEMBER";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_ADD_FRIEND_REPLY_OR_AT"] = 19266] = "TROOP_ADD_FRIEND_REPLY_OR_AT";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_BREAK_ICE"] = 10405] = "TROOP_BREAK_ICE";
  JsonGrayBusiId2[JsonGrayBusiId2["TROOP_FLAME_IGNITED"] = 19273] = "TROOP_FLAME_IGNITED";
  JsonGrayBusiId2[JsonGrayBusiId2["UI_RESERVE_100000_110000"] = 1e5] = "UI_RESERVE_100000_110000";
  JsonGrayBusiId2[JsonGrayBusiId2["VAS_FILE_UPLOAD_OVER_1G"] = 3002] = "VAS_FILE_UPLOAD_OVER_1G";
  JsonGrayBusiId2[JsonGrayBusiId2["VAS_FILE_UPLOAD_OVER_LIMIT"] = 3001] = "VAS_FILE_UPLOAD_OVER_LIMIT";
  return JsonGrayBusiId2;
})(JsonGrayBusiId || {});

const defaultMessages = 'End-Of-Stream';
/**
 * Thrown on read operation of the end of file or stream has been reached
 */
class EndOfStreamError extends Error {
    constructor() {
        super(defaultMessages);
        this.name = "EndOfStreamError";
    }
}
class AbortError extends Error {
    constructor(message = "The operation was aborted") {
        super(message);
        this.name = "AbortError";
    }
}

class Deferred {
    constructor() {
        this.resolve = () => null;
        this.reject = () => null;
        this.promise = new Promise((resolve, reject) => {
            this.reject = reject;
            this.resolve = resolve;
        });
    }
}

class AbstractStreamReader {
    constructor() {
        this.endOfStream = false;
        this.interrupted = false;
        /**
         * Store peeked data
         * @type {Array}
         */
        this.peekQueue = [];
    }
    async peek(uint8Array, mayBeLess = false) {
        const bytesRead = await this.read(uint8Array, mayBeLess);
        this.peekQueue.push(uint8Array.subarray(0, bytesRead)); // Put read data back to peek buffer
        return bytesRead;
    }
    async read(buffer, mayBeLess = false) {
        if (buffer.length === 0) {
            return 0;
        }
        let bytesRead = this.readFromPeekBuffer(buffer);
        if (!this.endOfStream) {
            bytesRead += await this.readRemainderFromStream(buffer.subarray(bytesRead), mayBeLess);
        }
        if (bytesRead === 0 && !mayBeLess) {
            throw new EndOfStreamError();
        }
        return bytesRead;
    }
    /**
     * Read chunk from stream
     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
     * @returns Number of bytes read
     */
    readFromPeekBuffer(buffer) {
        let remaining = buffer.length;
        let bytesRead = 0;
        // consume peeked data first
        while (this.peekQueue.length > 0 && remaining > 0) {
            const peekData = this.peekQueue.pop(); // Front of queue
            if (!peekData)
                throw new Error('peekData should be defined');
            const lenCopy = Math.min(peekData.length, remaining);
            buffer.set(peekData.subarray(0, lenCopy), bytesRead);
            bytesRead += lenCopy;
            remaining -= lenCopy;
            if (lenCopy < peekData.length) {
                // remainder back to queue
                this.peekQueue.push(peekData.subarray(lenCopy));
            }
        }
        return bytesRead;
    }
    async readRemainderFromStream(buffer, mayBeLess) {
        let bytesRead = 0;
        // Continue reading from stream if required
        while (bytesRead < buffer.length && !this.endOfStream) {
            if (this.interrupted) {
                throw new AbortError();
            }
            const chunkLen = await this.readFromStream(buffer.subarray(bytesRead), mayBeLess);
            if (chunkLen === 0)
                break;
            bytesRead += chunkLen;
        }
        if (!mayBeLess && bytesRead < buffer.length) {
            throw new EndOfStreamError();
        }
        return bytesRead;
    }
}

/**
 * Node.js Readable Stream Reader
 * Ref: https://nodejs.org/api/stream.html#readable-streams
 */
class StreamReader extends AbstractStreamReader {
    constructor(s) {
        super();
        this.s = s;
        /**
         * Deferred used for postponed read request (as not data is yet available to read)
         */
        this.deferred = null;
        if (!s.read || !s.once) {
            throw new Error('Expected an instance of stream.Readable');
        }
        this.s.once('end', () => {
            this.endOfStream = true;
            if (this.deferred) {
                this.deferred.resolve(0);
            }
        });
        this.s.once('error', err => this.reject(err));
        this.s.once('close', () => this.abort());
    }
    /**
     * Read chunk from stream
     * @param buffer Target Uint8Array (or Buffer) to store data read from stream in
     * @param mayBeLess - If true, may fill the buffer partially
     * @returns Number of bytes read
     */
    async readFromStream(buffer, mayBeLess) {
        if (buffer.length === 0)
            return 0;
        const readBuffer = this.s.read(buffer.length);
        if (readBuffer) {
            buffer.set(readBuffer);
            return readBuffer.length;
        }
        const request = {
            buffer,
            mayBeLess,
            deferred: new Deferred()
        };
        this.deferred = request.deferred;
        this.s.once('readable', () => {
            this.readDeferred(request);
        });
        return request.deferred.promise;
    }
    /**
     * Process deferred read request
     * @param request Deferred read request
     */
    readDeferred(request) {
        const readBuffer = this.s.read(request.buffer.length);
        if (readBuffer) {
            request.buffer.set(readBuffer);
            request.deferred.resolve(readBuffer.length);
            this.deferred = null;
        }
        else {
            this.s.once('readable', () => {
                this.readDeferred(request);
            });
        }
    }
    reject(err) {
        this.interrupted = true;
        if (this.deferred) {
            this.deferred.reject(err);
            this.deferred = null;
        }
    }
    async abort() {
        this.reject(new AbortError());
    }
    async close() {
        return this.abort();
    }
}

class WebStreamReader extends AbstractStreamReader {
    constructor(reader) {
        super();
        this.reader = reader;
    }
    async abort() {
        return this.close();
    }
    async close() {
        this.reader.releaseLock();
    }
}

/**
 * Read from a WebStream using a BYOB reader
 * Reference: https://nodejs.org/api/webstreams.html#class-readablestreambyobreader
 */
class WebStreamByobReader extends WebStreamReader {
    /**
     * Read from stream
     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
     * @param mayBeLess - If true, may fill the buffer partially
     * @protected Bytes read
     */
    async readFromStream(buffer, mayBeLess) {
        if (buffer.length === 0)
            return 0;
        // @ts-ignore
        const result = await this.reader.read(new Uint8Array(buffer.length), { min: mayBeLess ? undefined : buffer.length });
        if (result.done) {
            this.endOfStream = result.done;
        }
        if (result.value) {
            buffer.set(result.value);
            return result.value.length;
        }
        return 0;
    }
}

class WebStreamDefaultReader extends AbstractStreamReader {
    constructor(reader) {
        super();
        this.reader = reader;
        this.buffer = null; // Internal buffer to store excess data
    }
    /**
     * Copy chunk to target, and store the remainder in this.buffer
     */
    writeChunk(target, chunk) {
        const written = Math.min(chunk.length, target.length);
        target.set(chunk.subarray(0, written));
        // Adjust the remainder of the buffer
        if (written < chunk.length) {
            this.buffer = chunk.subarray(written);
        }
        else {
            this.buffer = null;
        }
        return written;
    }
    /**
     * Read from stream
     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
     * @param mayBeLess - If true, may fill the buffer partially
     * @protected Bytes read
     */
    async readFromStream(buffer, mayBeLess) {
        if (buffer.length === 0)
            return 0;
        let totalBytesRead = 0;
        // Serve from the internal buffer first
        if (this.buffer) {
            totalBytesRead += this.writeChunk(buffer, this.buffer);
        }
        // Continue reading from the stream if more data is needed
        while (totalBytesRead < buffer.length && !this.endOfStream) {
            const result = await this.reader.read();
            if (result.done) {
                this.endOfStream = true;
                break;
            }
            if (result.value) {
                totalBytesRead += this.writeChunk(buffer.subarray(totalBytesRead), result.value);
            }
        }
        if (!mayBeLess && totalBytesRead === 0 && this.endOfStream) {
            throw new EndOfStreamError();
        }
        return totalBytesRead;
    }
    abort() {
        this.interrupted = true;
        return this.reader.cancel();
    }
    async close() {
        await this.abort();
        this.reader.releaseLock();
    }
}

function makeWebStreamReader(stream) {
    try {
        const reader = stream.getReader({ mode: "byob" });
        if (reader instanceof ReadableStreamDefaultReader) {
            // Fallback to default reader in case `mode: byob` is ignored
            return new WebStreamDefaultReader(reader);
        }
        return new WebStreamByobReader(reader);
    }
    catch (error) {
        if (error instanceof TypeError) {
            // Fallback to default reader in case `mode: byob` rejected by a `TypeError`
            return new WebStreamDefaultReader(stream.getReader());
        }
        throw error;
    }
}

/**
 * Core tokenizer
 */
class AbstractTokenizer {
    /**
     * Constructor
     * @param options Tokenizer options
     * @protected
     */
    constructor(options) {
        this.numBuffer = new Uint8Array(8);
        /**
         * Tokenizer-stream position
         */
        this.position = 0;
        this.onClose = options?.onClose;
        if (options?.abortSignal) {
            options.abortSignal.addEventListener('abort', () => {
                this.abort();
            });
        }
    }
    /**
     * Read a token from the tokenizer-stream
     * @param token - The token to read
     * @param position - If provided, the desired position in the tokenizer-stream
     * @returns Promise with token data
     */
    async readToken(token, position = this.position) {
        const uint8Array = new Uint8Array(token.len);
        const len = await this.readBuffer(uint8Array, { position });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(uint8Array, 0);
    }
    /**
     * Peek a token from the tokenizer-stream.
     * @param token - Token to peek from the tokenizer-stream.
     * @param position - Offset where to begin reading within the file. If position is null, data will be read from the current file position.
     * @returns Promise with token data
     */
    async peekToken(token, position = this.position) {
        const uint8Array = new Uint8Array(token.len);
        const len = await this.peekBuffer(uint8Array, { position });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(uint8Array, 0);
    }
    /**
     * Read a numeric token from the stream
     * @param token - Numeric token
     * @returns Promise with number
     */
    async readNumber(token) {
        const len = await this.readBuffer(this.numBuffer, { length: token.len });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(this.numBuffer, 0);
    }
    /**
     * Read a numeric token from the stream
     * @param token - Numeric token
     * @returns Promise with number
     */
    async peekNumber(token) {
        const len = await this.peekBuffer(this.numBuffer, { length: token.len });
        if (len < token.len)
            throw new EndOfStreamError();
        return token.get(this.numBuffer, 0);
    }
    /**
     * Ignore number of bytes, advances the pointer in under tokenizer-stream.
     * @param length - Number of bytes to ignore
     * @return resolves the number of bytes ignored, equals length if this available, otherwise the number of bytes available
     */
    async ignore(length) {
        if (this.fileInfo.size !== undefined) {
            const bytesLeft = this.fileInfo.size - this.position;
            if (length > bytesLeft) {
                this.position += bytesLeft;
                return bytesLeft;
            }
        }
        this.position += length;
        return length;
    }
    async close() {
        await this.abort();
        await this.onClose?.();
    }
    normalizeOptions(uint8Array, options) {
        if (!this.supportsRandomAccess() && options && options.position !== undefined && options.position < this.position) {
            throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
        }
        return {
            ...{
                mayBeLess: false,
                offset: 0,
                length: uint8Array.length,
                position: this.position
            }, ...options
        };
    }
    abort() {
        return Promise.resolve(); // Ignore abort signal
    }
}

const maxBufferSize = 256000;
class ReadStreamTokenizer extends AbstractTokenizer {
    /**
     * Constructor
     * @param streamReader stream-reader to read from
     * @param options Tokenizer options
     */
    constructor(streamReader, options) {
        super(options);
        this.streamReader = streamReader;
        this.fileInfo = options?.fileInfo ?? {};
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Target Uint8Array to fill with data read from the tokenizer-stream
     * @param options - Read behaviour options
     * @returns Promise with number of bytes read
     */
    async readBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const skipBytes = normOptions.position - this.position;
        if (skipBytes > 0) {
            await this.ignore(skipBytes);
            return this.readBuffer(uint8Array, options);
        }
        if (skipBytes < 0) {
            throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
        }
        if (normOptions.length === 0) {
            return 0;
        }
        const bytesRead = await this.streamReader.read(uint8Array.subarray(0, normOptions.length), normOptions.mayBeLess);
        this.position += bytesRead;
        if ((!options || !options.mayBeLess) && bytesRead < normOptions.length) {
            throw new EndOfStreamError();
        }
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param uint8Array - Uint8Array (or Buffer) to write data to
     * @param options - Read behaviour options
     * @returns Promise with number of bytes peeked
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        let bytesRead = 0;
        if (normOptions.position) {
            const skipBytes = normOptions.position - this.position;
            if (skipBytes > 0) {
                const skipBuffer = new Uint8Array(normOptions.length + skipBytes);
                bytesRead = await this.peekBuffer(skipBuffer, { mayBeLess: normOptions.mayBeLess });
                uint8Array.set(skipBuffer.subarray(skipBytes));
                return bytesRead - skipBytes;
            }
            if (skipBytes < 0) {
                throw new Error('Cannot peek from a negative offset in a stream');
            }
        }
        if (normOptions.length > 0) {
            try {
                bytesRead = await this.streamReader.peek(uint8Array.subarray(0, normOptions.length), normOptions.mayBeLess);
            }
            catch (err) {
                if (options?.mayBeLess && err instanceof EndOfStreamError) {
                    return 0;
                }
                throw err;
            }
            if ((!normOptions.mayBeLess) && bytesRead < normOptions.length) {
                throw new EndOfStreamError();
            }
        }
        return bytesRead;
    }
    async ignore(length) {
        // debug(`ignore ${this.position}...${this.position + length - 1}`);
        const bufSize = Math.min(maxBufferSize, length);
        const buf = new Uint8Array(bufSize);
        let totBytesRead = 0;
        while (totBytesRead < length) {
            const remaining = length - totBytesRead;
            const bytesRead = await this.readBuffer(buf, { length: Math.min(bufSize, remaining) });
            if (bytesRead < 0) {
                return bytesRead;
            }
            totBytesRead += bytesRead;
        }
        return totBytesRead;
    }
    abort() {
        return this.streamReader.abort();
    }
    async close() {
        return this.streamReader.close();
    }
    supportsRandomAccess() {
        return false;
    }
}

class BufferTokenizer extends AbstractTokenizer {
    /**
     * Construct BufferTokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options Tokenizer options
     */
    constructor(uint8Array, options) {
        super(options);
        this.uint8Array = uint8Array;
        this.fileInfo = { ...options?.fileInfo ?? {}, ...{ size: uint8Array.length } };
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async readBuffer(uint8Array, options) {
        if (options?.position) {
            this.position = options.position;
        }
        const bytesRead = await this.peekBuffer(uint8Array, options);
        this.position += bytesRead;
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param uint8Array
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const bytes2read = Math.min(this.uint8Array.length - normOptions.position, normOptions.length);
        if ((!normOptions.mayBeLess) && bytes2read < normOptions.length) {
            throw new EndOfStreamError();
        }
        uint8Array.set(this.uint8Array.subarray(normOptions.position, normOptions.position + bytes2read));
        return bytes2read;
    }
    close() {
        return super.close();
    }
    supportsRandomAccess() {
        return true;
    }
    setPosition(position) {
        this.position = position;
    }
}

class BlobTokenizer extends AbstractTokenizer {
    /**
     * Construct BufferTokenizer
     * @param blob - Uint8Array to tokenize
     * @param options Tokenizer options
     */
    constructor(blob, options) {
        super(options);
        this.blob = blob;
        this.fileInfo = { ...options?.fileInfo ?? {}, ...{ size: blob.size, mimeType: blob.type } };
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async readBuffer(uint8Array, options) {
        if (options?.position) {
            this.position = options.position;
        }
        const bytesRead = await this.peekBuffer(uint8Array, options);
        this.position += bytesRead;
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param buffer
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async peekBuffer(buffer, options) {
        const normOptions = this.normalizeOptions(buffer, options);
        const bytes2read = Math.min(this.blob.size - normOptions.position, normOptions.length);
        if ((!normOptions.mayBeLess) && bytes2read < normOptions.length) {
            throw new EndOfStreamError();
        }
        const arrayBuffer = await this.blob.slice(normOptions.position, normOptions.position + bytes2read).arrayBuffer();
        buffer.set(new Uint8Array(arrayBuffer));
        return bytes2read;
    }
    close() {
        return super.close();
    }
    supportsRandomAccess() {
        return true;
    }
    setPosition(position) {
        this.position = position;
    }
}

/**
 * Construct ReadStreamTokenizer from given Stream.
 * Will set fileSize, if provided given Stream has set the .path property/
 * @param stream - Read from Node.js Stream.Readable
 * @param options - Tokenizer options
 * @returns ReadStreamTokenizer
 */
function fromStream$1(stream, options) {
    const streamReader = new StreamReader(stream);
    const _options = options ?? {};
    const chainedClose = _options.onClose;
    _options.onClose = async () => {
        await streamReader.close();
        if (chainedClose) {
            return chainedClose();
        }
    };
    return new ReadStreamTokenizer(streamReader, _options);
}
/**
 * Construct ReadStreamTokenizer from given ReadableStream (WebStream API).
 * Will set fileSize, if provided given Stream has set the .path property/
 * @param webStream - Read from Node.js Stream.Readable (must be a byte stream)
 * @param options - Tokenizer options
 * @returns ReadStreamTokenizer
 */
function fromWebStream(webStream, options) {
    const webStreamReader = makeWebStreamReader(webStream);
    const _options = options ?? {};
    const chainedClose = _options.onClose;
    _options.onClose = async () => {
        await webStreamReader.close();
        if (chainedClose) {
            return chainedClose();
        }
    };
    return new ReadStreamTokenizer(webStreamReader, _options);
}
/**
 * Construct ReadStreamTokenizer from given Buffer.
 * @param uint8Array - Uint8Array to tokenize
 * @param options - Tokenizer options
 * @returns BufferTokenizer
 */
function fromBuffer$1(uint8Array, options) {
    return new BufferTokenizer(uint8Array, options);
}
/**
 * Construct ReadStreamTokenizer from given Blob.
 * @param blob - Uint8Array to tokenize
 * @param options - Tokenizer options
 * @returns BufferTokenizer
 */
function fromBlob(blob, options) {
    return new BlobTokenizer(blob, options);
}

class FileTokenizer extends AbstractTokenizer {
    /**
     * Create tokenizer from provided file path
     * @param sourceFilePath File path
     */
    static async fromFile(sourceFilePath) {
        const fileHandle = await open(sourceFilePath, 'r');
        const stat = await fileHandle.stat();
        return new FileTokenizer(fileHandle, { fileInfo: { path: sourceFilePath, size: stat.size } });
    }
    constructor(fileHandle, options) {
        super(options);
        this.fileHandle = fileHandle;
        this.fileInfo = options.fileInfo;
    }
    /**
     * Read buffer from file
     * @param uint8Array - Uint8Array to write result to
     * @param options - Read behaviour options
     * @returns Promise number of bytes read
     */
    async readBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        this.position = normOptions.position;
        if (normOptions.length === 0)
            return 0;
        const res = await this.fileHandle.read(uint8Array, 0, normOptions.length, normOptions.position);
        this.position += res.bytesRead;
        if (res.bytesRead < normOptions.length && (!options || !options.mayBeLess)) {
            throw new EndOfStreamError();
        }
        return res.bytesRead;
    }
    /**
     * Peek buffer from file
     * @param uint8Array - Uint8Array (or Buffer) to write data to
     * @param options - Read behaviour options
     * @returns Promise number of bytes read
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const res = await this.fileHandle.read(uint8Array, 0, normOptions.length, normOptions.position);
        if ((!normOptions.mayBeLess) && res.bytesRead < normOptions.length) {
            throw new EndOfStreamError();
        }
        return res.bytesRead;
    }
    async close() {
        await this.fileHandle.close();
        return super.close();
    }
    setPosition(position) {
        this.position = position;
    }
    supportsRandomAccess() {
        return true;
    }
}

/**
 * Construct ReadStreamTokenizer from given Stream.
 * Will set fileSize, if provided given Stream has set the .path property.
 * @param stream - Node.js Stream.Readable
 * @param options - Pass additional file information to the tokenizer
 * @returns Tokenizer
 */
async function fromStream(stream, options) {
    const rst = fromStream$1(stream, options);
    if (stream.path) {
        const stat$1 = await stat(stream.path);
        rst.fileInfo.path = stream.path;
        rst.fileInfo.size = stat$1.size;
    }
    return rst;
}
const fromFile = FileTokenizer.fromFile;

var ieee754 = {};

/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */

var hasRequiredIeee754;

function requireIeee754 () {
	if (hasRequiredIeee754) return ieee754;
	hasRequiredIeee754 = 1;
	ieee754.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = -7;
	  var i = isLE ? (nBytes - 1) : 0;
	  var d = isLE ? -1 : 1;
	  var s = buffer[offset + i];

	  i += d;

	  e = s & ((1 << (-nBits)) - 1);
	  s >>= (-nBits);
	  nBits += eLen;
	  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1);
	  e >>= (-nBits);
	  nBits += mLen;
	  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen);
	    e = e - eBias;
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	};

	ieee754.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
	  var i = isLE ? 0 : (nBytes - 1);
	  var d = isLE ? 1 : -1;
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

	  value = Math.abs(value);

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0;
	    e = eMax;
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2);
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * Math.pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }

	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = ((value * c) - 1) * Math.pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
	      e = 0;
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128;
	};
	return ieee754;
}

requireIeee754();

// text-polyfill.ts
// Minimal encode/decode for utf-8, utf-16le, ascii, latin1, windows-1252
const WINDOWS_1252_EXTRA = {
    0x80: "€", 0x82: "‚", 0x83: "ƒ", 0x84: "„", 0x85: "…", 0x86: "†",
    0x87: "‡", 0x88: "ˆ", 0x89: "‰", 0x8a: "Š", 0x8b: "‹", 0x8c: "Œ",
    0x8e: "Ž", 0x91: "‘", 0x92: "’", 0x93: "“", 0x94: "”", 0x95: "•",
    0x96: "–", 0x97: "—", 0x98: "˜", 0x99: "™", 0x9a: "š", 0x9b: "›",
    0x9c: "œ", 0x9e: "ž", 0x9f: "Ÿ",
};
for (const [code, char] of Object.entries(WINDOWS_1252_EXTRA)) {
}
/**
 * Decode text from binary data
 * @param bytes Binary data
 * @param encoding Encoding
 */
function textDecode(bytes, encoding = "utf-8") {
    switch (encoding.toLowerCase()) {
        case "utf-8":
        case "utf8":
            if (typeof globalThis.TextDecoder !== "undefined") {
                return new globalThis.TextDecoder("utf-8").decode(bytes);
            }
            return decodeUTF8(bytes);
        case "utf-16le":
            return decodeUTF16LE(bytes);
        case "ascii":
            return decodeASCII(bytes);
        case "latin1":
        case "iso-8859-1":
            return decodeLatin1(bytes);
        case "windows-1252":
            return decodeWindows1252(bytes);
        default:
            throw new RangeError(`Encoding '${encoding}' not supported`);
    }
}
// --- Internal helpers ---
function decodeUTF8(bytes) {
    let out = "";
    let i = 0;
    while (i < bytes.length) {
        const b1 = bytes[i++];
        if (b1 < 0x80) {
            out += String.fromCharCode(b1);
        }
        else if (b1 < 0xe0) {
            const b2 = bytes[i++] & 0x3f;
            out += String.fromCharCode(((b1 & 0x1f) << 6) | b2);
        }
        else if (b1 < 0xf0) {
            const b2 = bytes[i++] & 0x3f;
            const b3 = bytes[i++] & 0x3f;
            out += String.fromCharCode(((b1 & 0x0f) << 12) | (b2 << 6) | b3);
        }
        else {
            const b2 = bytes[i++] & 0x3f;
            const b3 = bytes[i++] & 0x3f;
            const b4 = bytes[i++] & 0x3f;
            let cp = ((b1 & 0x07) << 18) |
                (b2 << 12) |
                (b3 << 6) |
                b4;
            cp -= 0x10000;
            out += String.fromCharCode(0xd800 + ((cp >> 10) & 0x3ff), 0xdc00 + (cp & 0x3ff));
        }
    }
    return out;
}
function decodeUTF16LE(bytes) {
    let out = "";
    for (let i = 0; i < bytes.length; i += 2) {
        out += String.fromCharCode(bytes[i] | (bytes[i + 1] << 8));
    }
    return out;
}
function decodeASCII(bytes) {
    return String.fromCharCode(...bytes.map((b) => b & 0x7f));
}
function decodeLatin1(bytes) {
    return String.fromCharCode(...bytes);
}
function decodeWindows1252(bytes) {
    let out = "";
    for (const b of bytes) {
        if (b >= 0x80 && b <= 0x9f && WINDOWS_1252_EXTRA[b]) {
            out += WINDOWS_1252_EXTRA[b];
        }
        else {
            out += String.fromCharCode(b);
        }
    }
    return out;
}

// Primitive types
function dv(array) {
    return new DataView(array.buffer, array.byteOffset);
}
/*
 * 8-bit unsigned integer
 */
const UINT8 = {
    len: 1,
    get(array, offset) {
        return dv(array).getUint8(offset);
    },
    put(array, offset, value) {
        dv(array).setUint8(offset, value);
        return offset + 1;
    }
};
/**
 * 16-bit unsigned integer, Little Endian byte order
 */
const UINT16_LE = {
    len: 2,
    get(array, offset) {
        return dv(array).getUint16(offset, true);
    },
    put(array, offset, value) {
        dv(array).setUint16(offset, value, true);
        return offset + 2;
    }
};
/**
 * 16-bit unsigned integer, Big Endian byte order
 */
const UINT16_BE = {
    len: 2,
    get(array, offset) {
        return dv(array).getUint16(offset);
    },
    put(array, offset, value) {
        dv(array).setUint16(offset, value);
        return offset + 2;
    }
};
/**
 * 32-bit unsigned integer, Little Endian byte order
 */
const UINT32_LE = {
    len: 4,
    get(array, offset) {
        return dv(array).getUint32(offset, true);
    },
    put(array, offset, value) {
        dv(array).setUint32(offset, value, true);
        return offset + 4;
    }
};
/**
 * 32-bit unsigned integer, Big Endian byte order
 */
const UINT32_BE = {
    len: 4,
    get(array, offset) {
        return dv(array).getUint32(offset);
    },
    put(array, offset, value) {
        dv(array).setUint32(offset, value);
        return offset + 4;
    }
};
/**
 * 32-bit signed integer, Big Endian byte order
 */
const INT32_BE = {
    len: 4,
    get(array, offset) {
        return dv(array).getInt32(offset);
    },
    put(array, offset, value) {
        dv(array).setInt32(offset, value);
        return offset + 4;
    }
};
/**
 * 64-bit unsigned integer, Little Endian byte order
 */
const UINT64_LE = {
    len: 8,
    get(array, offset) {
        return dv(array).getBigUint64(offset, true);
    },
    put(array, offset, value) {
        dv(array).setBigUint64(offset, value, true);
        return offset + 8;
    }
};
/**
 * Consume a fixed number of bytes from the stream and return a string with a specified encoding.
 * Supports all encodings supported by TextDecoder, plus 'windows-1252'.
 */
class StringType {
    constructor(len, encoding) {
        this.len = len;
        this.encoding = encoding;
    }
    get(data, offset = 0) {
        const bytes = data.subarray(offset, offset + this.len);
        return textDecode(bytes, this.encoding);
    }
}

var require$1 = createRequire('/');
// DEFLATE is a complex format; to read this code, you should probably check the RFC first:
// https://tools.ietf.org/html/rfc1951
// You may also wish to take a look at the guide I made about this program:
// https://gist.github.com/101arrowz/253f31eb5abc3d9275ab943003ffecad
// Some of the following code is similar to that of UZIP.js:
// https://github.com/photopea/UZIP.js
// However, the vast majority of the codebase has diverged from UZIP.js to increase performance and reduce bundle size.
// Sometimes 0 will appear where -1 would be more appropriate. This is because using a uint
// is better for memory in most engines (I *think*).
// Mediocre shim
var Worker;
var workerAdd = ";var __w=require('worker_threads');__w.parentPort.on('message',function(m){onmessage({data:m})}),postMessage=function(m,t){__w.parentPort.postMessage(m,t)},close=process.exit;self=global";
try {
    Worker = require$1('worker_threads').Worker;
}
catch (e) {
}
var wk = Worker ? function (c, _, msg, transfer, cb) {
    var done = false;
    var w = new Worker(c + workerAdd, { eval: true })
        .on('error', function (e) { return cb(e, null); })
        .on('message', function (m) { return cb(null, m); })
        .on('exit', function (c) {
        if (c && !done)
            cb(new Error('exited with code ' + c), null);
    });
    w.postMessage(msg, transfer);
    w.terminate = function () {
        done = true;
        return Worker.prototype.terminate.call(w);
    };
    return w;
} : function (_, __, ___, ____, cb) {
    setImmediate(function () { return cb(new Error('async operations unsupported - update to Node 12+ (or Node 10-11 with the --experimental-worker CLI flag)'), null); });
    var NOP = function () { };
    return {
        terminate: NOP,
        postMessage: NOP
    };
};

// aliases for shorter compressed code (most minifers don't do this)
var u8 = Uint8Array, u16 = Uint16Array, i32 = Int32Array;
// fixed length extra bits
var fleb = new u8([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, /* unused */ 0, 0, /* impossible */ 0]);
// fixed distance extra bits
var fdeb = new u8([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, /* unused */ 0, 0]);
// code length index map
var clim = new u8([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
// get base, reverse index map from extra bits
var freb = function (eb, start) {
    var b = new u16(31);
    for (var i = 0; i < 31; ++i) {
        b[i] = start += 1 << eb[i - 1];
    }
    // numbers here are at max 18 bits
    var r = new i32(b[30]);
    for (var i = 1; i < 30; ++i) {
        for (var j = b[i]; j < b[i + 1]; ++j) {
            r[j] = ((j - b[i]) << 5) | i;
        }
    }
    return { b: b, r: r };
};
var _a$y = freb(fleb, 2), fl = _a$y.b, revfl = _a$y.r;
// we can ignore the fact that the other numbers are wrong; they never happen anyway
fl[28] = 258, revfl[258] = 28;
var _b = freb(fdeb, 0), fd = _b.b;
// map of value to reverse (assuming 16 bits)
var rev = new u16(32768);
for (var i = 0; i < 32768; ++i) {
    // reverse table algorithm from SO
    var x$1 = ((i & 0xAAAA) >> 1) | ((i & 0x5555) << 1);
    x$1 = ((x$1 & 0xCCCC) >> 2) | ((x$1 & 0x3333) << 2);
    x$1 = ((x$1 & 0xF0F0) >> 4) | ((x$1 & 0x0F0F) << 4);
    rev[i] = (((x$1 & 0xFF00) >> 8) | ((x$1 & 0x00FF) << 8)) >> 1;
}
// create huffman tree from u8 "map": index -> code length for code index
// mb (max bits) must be at most 15
// TODO: optimize/split up?
var hMap = (function (cd, mb, r) {
    var s = cd.length;
    // index
    var i = 0;
    // u16 "map": index -> # of codes with bit length = index
    var l = new u16(mb);
    // length of cd must be 288 (total # of codes)
    for (; i < s; ++i) {
        if (cd[i])
            ++l[cd[i] - 1];
    }
    // u16 "map": index -> minimum code for bit length = index
    var le = new u16(mb);
    for (i = 1; i < mb; ++i) {
        le[i] = (le[i - 1] + l[i - 1]) << 1;
    }
    var co;
    if (r) {
        // u16 "map": index -> number of actual bits, symbol for code
        co = new u16(1 << mb);
        // bits to remove for reverser
        var rvb = 15 - mb;
        for (i = 0; i < s; ++i) {
            // ignore 0 lengths
            if (cd[i]) {
                // num encoding both symbol and bits read
                var sv = (i << 4) | cd[i];
                // free bits
                var r_1 = mb - cd[i];
                // start value
                var v = le[cd[i] - 1]++ << r_1;
                // m is end value
                for (var m = v | ((1 << r_1) - 1); v <= m; ++v) {
                    // every 16 bit value starting with the code yields the same result
                    co[rev[v] >> rvb] = sv;
                }
            }
        }
    }
    else {
        co = new u16(s);
        for (i = 0; i < s; ++i) {
            if (cd[i]) {
                co[i] = rev[le[cd[i] - 1]++] >> (15 - cd[i]);
            }
        }
    }
    return co;
});
// fixed length tree
var flt = new u8(288);
for (var i = 0; i < 144; ++i)
    flt[i] = 8;
for (var i = 144; i < 256; ++i)
    flt[i] = 9;
for (var i = 256; i < 280; ++i)
    flt[i] = 7;
for (var i = 280; i < 288; ++i)
    flt[i] = 8;
// fixed distance tree
var fdt = new u8(32);
for (var i = 0; i < 32; ++i)
    fdt[i] = 5;
// fixed length map
var flrm = /*#__PURE__*/ hMap(flt, 9, 1);
// fixed distance map
var fdrm = /*#__PURE__*/ hMap(fdt, 5, 1);
// find max of array
var max$1 = function (a) {
    var m = a[0];
    for (var i = 1; i < a.length; ++i) {
        if (a[i] > m)
            m = a[i];
    }
    return m;
};
// read d, starting at bit p and mask with m
var bits = function (d, p, m) {
    var o = (p / 8) | 0;
    return ((d[o] | (d[o + 1] << 8)) >> (p & 7)) & m;
};
// read d, starting at bit p continuing for at least 16 bits
var bits16 = function (d, p) {
    var o = (p / 8) | 0;
    return ((d[o] | (d[o + 1] << 8) | (d[o + 2] << 16)) >> (p & 7));
};
// get end of byte
var shft = function (p) { return ((p + 7) / 8) | 0; };
// typed array slice - allows garbage collector to free original reference,
// while being more compatible than .slice
var slc = function (v, s, e) {
    if (s == null || s < 0)
        s = 0;
    if (e == null || e > v.length)
        e = v.length;
    // can't use .constructor in case user-supplied
    return new u8(v.subarray(s, e));
};
// error codes
var ec = [
    'unexpected EOF',
    'invalid block type',
    'invalid length/literal',
    'invalid distance',
    'stream finished',
    'no stream handler',
    ,
    'no callback',
    'invalid UTF-8 data',
    'extra field too long',
    'date not in range 1980-2099',
    'filename too long',
    'stream finishing',
    'invalid zip data'
    // determined by unknown compression method
];
var err = function (ind, msg, nt) {
    var e = new Error(msg || ec[ind]);
    e.code = ind;
    if (Error.captureStackTrace)
        Error.captureStackTrace(e, err);
    if (!nt)
        throw e;
    return e;
};
// expands raw DEFLATE data
var inflt = function (dat, st, buf, dict) {
    // source length       dict length
    var sl = dat.length, dl = dict ? dict.length : 0;
    if (!sl || st.f && !st.l)
        return buf || new u8(0);
    var noBuf = !buf;
    // have to estimate size
    var resize = noBuf || st.i != 2;
    // no state
    var noSt = st.i;
    // Assumes roughly 33% compression ratio average
    if (noBuf)
        buf = new u8(sl * 3);
    // ensure buffer can fit at least l elements
    var cbuf = function (l) {
        var bl = buf.length;
        // need to increase size to fit
        if (l > bl) {
            // Double or set to necessary, whichever is greater
            var nbuf = new u8(Math.max(bl * 2, l));
            nbuf.set(buf);
            buf = nbuf;
        }
    };
    //  last chunk         bitpos           bytes
    var final = st.f || 0, pos = st.p || 0, bt = st.b || 0, lm = st.l, dm = st.d, lbt = st.m, dbt = st.n;
    // total bits
    var tbts = sl * 8;
    do {
        if (!lm) {
            // BFINAL - this is only 1 when last chunk is next
            final = bits(dat, pos, 1);
            // type: 0 = no compression, 1 = fixed huffman, 2 = dynamic huffman
            var type = bits(dat, pos + 1, 3);
            pos += 3;
            if (!type) {
                // go to end of byte boundary
                var s = shft(pos) + 4, l = dat[s - 4] | (dat[s - 3] << 8), t = s + l;
                if (t > sl) {
                    if (noSt)
                        err(0);
                    break;
                }
                // ensure size
                if (resize)
                    cbuf(bt + l);
                // Copy over uncompressed data
                buf.set(dat.subarray(s, t), bt);
                // Get new bitpos, update byte count
                st.b = bt += l, st.p = pos = t * 8, st.f = final;
                continue;
            }
            else if (type == 1)
                lm = flrm, dm = fdrm, lbt = 9, dbt = 5;
            else if (type == 2) {
                //  literal                            lengths
                var hLit = bits(dat, pos, 31) + 257, hcLen = bits(dat, pos + 10, 15) + 4;
                var tl = hLit + bits(dat, pos + 5, 31) + 1;
                pos += 14;
                // length+distance tree
                var ldt = new u8(tl);
                // code length tree
                var clt = new u8(19);
                for (var i = 0; i < hcLen; ++i) {
                    // use index map to get real code
                    clt[clim[i]] = bits(dat, pos + i * 3, 7);
                }
                pos += hcLen * 3;
                // code lengths bits
                var clb = max$1(clt), clbmsk = (1 << clb) - 1;
                // code lengths map
                var clm = hMap(clt, clb, 1);
                for (var i = 0; i < tl;) {
                    var r = clm[bits(dat, pos, clbmsk)];
                    // bits read
                    pos += r & 15;
                    // symbol
                    var s = r >> 4;
                    // code length to copy
                    if (s < 16) {
                        ldt[i++] = s;
                    }
                    else {
                        //  copy   count
                        var c = 0, n = 0;
                        if (s == 16)
                            n = 3 + bits(dat, pos, 3), pos += 2, c = ldt[i - 1];
                        else if (s == 17)
                            n = 3 + bits(dat, pos, 7), pos += 3;
                        else if (s == 18)
                            n = 11 + bits(dat, pos, 127), pos += 7;
                        while (n--)
                            ldt[i++] = c;
                    }
                }
                //    length tree                 distance tree
                var lt = ldt.subarray(0, hLit), dt = ldt.subarray(hLit);
                // max length bits
                lbt = max$1(lt);
                // max dist bits
                dbt = max$1(dt);
                lm = hMap(lt, lbt, 1);
                dm = hMap(dt, dbt, 1);
            }
            else
                err(1);
            if (pos > tbts) {
                if (noSt)
                    err(0);
                break;
            }
        }
        // Make sure the buffer can hold this + the largest possible addition
        // Maximum chunk size (practically, theoretically infinite) is 2^17
        if (resize)
            cbuf(bt + 131072);
        var lms = (1 << lbt) - 1, dms = (1 << dbt) - 1;
        var lpos = pos;
        for (;; lpos = pos) {
            // bits read, code
            var c = lm[bits16(dat, pos) & lms], sym = c >> 4;
            pos += c & 15;
            if (pos > tbts) {
                if (noSt)
                    err(0);
                break;
            }
            if (!c)
                err(2);
            if (sym < 256)
                buf[bt++] = sym;
            else if (sym == 256) {
                lpos = pos, lm = null;
                break;
            }
            else {
                var add = sym - 254;
                // no extra bits needed if less
                if (sym > 264) {
                    // index
                    var i = sym - 257, b = fleb[i];
                    add = bits(dat, pos, (1 << b) - 1) + fl[i];
                    pos += b;
                }
                // dist
                var d = dm[bits16(dat, pos) & dms], dsym = d >> 4;
                if (!d)
                    err(3);
                pos += d & 15;
                var dt = fd[dsym];
                if (dsym > 3) {
                    var b = fdeb[dsym];
                    dt += bits16(dat, pos) & (1 << b) - 1, pos += b;
                }
                if (pos > tbts) {
                    if (noSt)
                        err(0);
                    break;
                }
                if (resize)
                    cbuf(bt + 131072);
                var end = bt + add;
                if (bt < dt) {
                    var shift = dl - dt, dend = Math.min(dt, end);
                    if (shift + bt < 0)
                        err(3);
                    for (; bt < dend; ++bt)
                        buf[bt] = dict[shift + bt];
                }
                for (; bt < end; ++bt)
                    buf[bt] = buf[bt - dt];
            }
        }
        st.l = lm, st.p = lpos, st.b = bt, st.f = final;
        if (lm)
            final = 1, st.m = lbt, st.d = dm, st.n = dbt;
    } while (!final);
    // don't reallocate for streams or user buffers
    return bt != buf.length && noBuf ? slc(buf, 0, bt) : buf.subarray(0, bt);
};
// empty
var et = /*#__PURE__*/ new u8(0);
// Walmart object spread
var mrg = function (a, b) {
    var o = {};
    for (var k in a)
        o[k] = a[k];
    for (var k in b)
        o[k] = b[k];
    return o;
};
// worker clone
// This is possibly the craziest part of the entire codebase, despite how simple it may seem.
// The only parameter to this function is a closure that returns an array of variables outside of the function scope.
// We're going to try to figure out the variable names used in the closure as strings because that is crucial for workerization.
// We will return an object mapping of true variable name to value (basically, the current scope as a JS object).
// The reason we can't just use the original variable names is minifiers mangling the toplevel scope.
// This took me three weeks to figure out how to do.
var wcln = function (fn, fnStr, td) {
    var dt = fn();
    var st = fn.toString();
    var ks = st.slice(st.indexOf('[') + 1, st.lastIndexOf(']')).replace(/\s+/g, '').split(',');
    for (var i = 0; i < dt.length; ++i) {
        var v = dt[i], k = ks[i];
        if (typeof v == 'function') {
            fnStr += ';' + k + '=';
            var st_1 = v.toString();
            if (v.prototype) {
                // for global objects
                if (st_1.indexOf('[native code]') != -1) {
                    var spInd = st_1.indexOf(' ', 8) + 1;
                    fnStr += st_1.slice(spInd, st_1.indexOf('(', spInd));
                }
                else {
                    fnStr += st_1;
                    for (var t in v.prototype)
                        fnStr += ';' + k + '.prototype.' + t + '=' + v.prototype[t].toString();
                }
            }
            else
                fnStr += st_1;
        }
        else
            td[k] = v;
    }
    return fnStr;
};
var ch = [];
// clone bufs
var cbfs = function (v) {
    var tl = [];
    for (var k in v) {
        if (v[k].buffer) {
            tl.push((v[k] = new v[k].constructor(v[k])).buffer);
        }
    }
    return tl;
};
// use a worker to execute code
var wrkr = function (fns, init, id, cb) {
    if (!ch[id]) {
        var fnStr = '', td_1 = {}, m = fns.length - 1;
        for (var i = 0; i < m; ++i)
            fnStr = wcln(fns[i], fnStr, td_1);
        ch[id] = { c: wcln(fns[m], fnStr, td_1), e: td_1 };
    }
    var td = mrg({}, ch[id].e);
    return wk(ch[id].c + ';onmessage=function(e){for(var k in e.data)self[k]=e.data[k];onmessage=' + init.toString() + '}', id, td, cbfs(td), cb);
};
// base async inflate fn
var bInflt = function () { return [u8, u16, i32, fleb, fdeb, clim, fl, fd, flrm, fdrm, rev, ec, hMap, max$1, bits, bits16, shft, slc, err, inflt, inflateSync, pbf, gopt]; };
// gunzip extra
var guze = function () { return [gzs, gzl]; };
// post buf
var pbf = function (msg) { return postMessage(msg, [msg.buffer]); };
// get opts
var gopt = function (o) { return o && {
    out: o.size && new u8(o.size),
    dictionary: o.dictionary
}; };
// auto stream
var astrm = function (strm) {
    strm.ondata = function (dat, final) { return postMessage([dat, final], [dat.buffer]); };
    return function (ev) {
        if (ev.data.length) {
            strm.push(ev.data[0], ev.data[1]);
            postMessage([ev.data[0].length]);
        }
        else
            strm.flush();
    };
};
// async stream attach
var astrmify = function (fns, strm, opts, init, id, flush, ext) {
    var t;
    var w = wrkr(fns, init, id, function (err, dat) {
        if (err)
            w.terminate(), strm.ondata.call(strm, err);
        else if (!Array.isArray(dat))
            ext(dat);
        else if (dat.length == 1) {
            strm.queuedSize -= dat[0];
            if (strm.ondrain)
                strm.ondrain(dat[0]);
        }
        else {
            if (dat[1])
                w.terminate();
            strm.ondata.call(strm, err, dat[0], dat[1]);
        }
    });
    w.postMessage(opts);
    strm.queuedSize = 0;
    strm.push = function (d, f) {
        if (!strm.ondata)
            err(5);
        if (t)
            strm.ondata(err(4, 0, 1), null, !!f);
        strm.queuedSize += d.length;
        w.postMessage([d, t = f], [d.buffer]);
    };
    strm.terminate = function () { w.terminate(); };
};
// gzip footer: -8 to -4 = CRC, -4 to -0 is length
// gzip start
var gzs = function (d) {
    if (d[0] != 31 || d[1] != 139 || d[2] != 8)
        err(6, 'invalid gzip data');
    var flg = d[3];
    var st = 10;
    if (flg & 4)
        st += (d[10] | d[11] << 8) + 2;
    for (var zs = (flg >> 3 & 1) + (flg >> 4 & 1); zs > 0; zs -= !d[st++])
        ;
    return st + (flg & 2);
};
// gzip length
var gzl = function (d) {
    var l = d.length;
    return (d[l - 4] | d[l - 3] << 8 | d[l - 2] << 16 | d[l - 1] << 24) >>> 0;
};
// zlib start
var zls = function (d, dict) {
    if ((d[0] & 15) != 8 || (d[0] >> 4) > 7 || ((d[0] << 8 | d[1]) % 31))
        err(6, 'invalid zlib data');
    if ((d[1] >> 5 & 1) == 1)
        err(6, 'invalid zlib data: ' + (d[1] & 32 ? 'need' : 'unexpected') + ' dictionary');
    return (d[1] >> 3 & 4) + 2;
};
function StrmOpt(opts, cb) {
    if (typeof opts == 'function')
        cb = opts, opts = {};
    this.ondata = cb;
    return opts;
}
/**
 * Streaming DEFLATE decompression
 */
var Inflate = /*#__PURE__*/ (function () {
    function Inflate(opts, cb) {
        // no StrmOpt here to avoid adding to workerizer
        if (typeof opts == 'function')
            cb = opts, opts = {};
        this.ondata = cb;
        var dict = opts && opts.dictionary && opts.dictionary.subarray(-32768);
        this.s = { i: 0, b: dict ? dict.length : 0 };
        this.o = new u8(32768);
        this.p = new u8(0);
        if (dict)
            this.o.set(dict);
    }
    Inflate.prototype.e = function (c) {
        if (!this.ondata)
            err(5);
        if (this.d)
            err(4);
        if (!this.p.length)
            this.p = c;
        else if (c.length) {
            var n = new u8(this.p.length + c.length);
            n.set(this.p), n.set(c, this.p.length), this.p = n;
        }
    };
    Inflate.prototype.c = function (final) {
        this.s.i = +(this.d = final || false);
        var bts = this.s.b;
        var dt = inflt(this.p, this.s, this.o);
        this.ondata(slc(dt, bts, this.s.b), this.d);
        this.o = slc(dt, this.s.b - 32768), this.s.b = this.o.length;
        this.p = slc(this.p, (this.s.p / 8) | 0), this.s.p &= 7;
    };
    /**
     * Pushes a chunk to be inflated
     * @param chunk The chunk to push
     * @param final Whether this is the final chunk
     */
    Inflate.prototype.push = function (chunk, final) {
        this.e(chunk), this.c(final);
    };
    return Inflate;
}());
/**
 * Expands DEFLATE data with no wrapper
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function inflateSync(data, opts) {
    return inflt(data, { i: 2 }, opts && opts.out, opts && opts.dictionary);
}
/**
 * Streaming single or multi-member GZIP decompression
 */
var Gunzip = /*#__PURE__*/ (function () {
    function Gunzip(opts, cb) {
        this.v = 1;
        this.r = 0;
        Inflate.call(this, opts, cb);
    }
    /**
     * Pushes a chunk to be GUNZIPped
     * @param chunk The chunk to push
     * @param final Whether this is the last chunk
     */
    Gunzip.prototype.push = function (chunk, final) {
        Inflate.prototype.e.call(this, chunk);
        this.r += chunk.length;
        if (this.v) {
            var p = this.p.subarray(this.v - 1);
            var s = p.length > 3 ? gzs(p) : 4;
            if (s > p.length) {
                if (!final)
                    return;
            }
            else if (this.v > 1 && this.onmember) {
                this.onmember(this.r - p.length);
            }
            this.p = p.subarray(s), this.v = 0;
        }
        // necessary to prevent TS from using the closure value
        // This allows for workerization to function correctly
        Inflate.prototype.c.call(this, final);
        // process concatenated GZIP
        if (this.s.f && !this.s.l && !final) {
            this.v = shft(this.s.p) + 9;
            this.s = { i: 0 };
            this.o = new u8(0);
            this.push(new u8(0), final);
        }
    };
    return Gunzip;
}());
/**
 * Asynchronous streaming single or multi-member GZIP decompression
 */
var AsyncGunzip = /*#__PURE__*/ (function () {
    function AsyncGunzip(opts, cb) {
        var _this = this;
        astrmify([
            bInflt,
            guze,
            function () { return [astrm, Inflate, Gunzip]; }
        ], this, StrmOpt.call(this, opts, cb), function (ev) {
            var strm = new Gunzip(ev.data);
            strm.onmember = function (offset) { return postMessage(offset); };
            onmessage = astrm(strm);
        }, 9, 0, function (offset) { return _this.onmember && _this.onmember(offset); });
    }
    return AsyncGunzip;
}());
/**
 * Expands GZIP data
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function gunzipSync(data, opts) {
    var st = gzs(data);
    if (st + 8 > data.length)
        err(6, 'invalid gzip data');
    return inflt(data.subarray(st, -8), { i: 2 }, new u8(gzl(data)), opts);
}
/**
 * Expands Zlib data
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function unzlibSync(data, opts) {
    return inflt(data.subarray(zls(data), -4), { i: 2 }, opts, opts);
}
/**
 * Expands compressed GZIP, Zlib, or raw DEFLATE data, automatically detecting the format
 * @param data The data to decompress
 * @param opts The decompression options
 * @returns The decompressed version of the data
 */
function decompressSync(data, opts) {
    return (data[0] == 31 && data[1] == 139 && data[2] == 8)
        ? gunzipSync(data, opts)
        : ((data[0] & 15) != 8 || (data[0] >> 4) > 7 || ((data[0] << 8 | data[1]) % 31))
            ? inflateSync(data, opts)
            : unzlibSync(data, opts);
}
// text decoder
var td = typeof TextDecoder != 'undefined' && /*#__PURE__*/ new TextDecoder();
// text decoder stream
var tds = 0;
try {
    td.decode(et, { stream: true });
    tds = 1;
}
catch (e) { }

var browser$5 = {exports: {}};

/**
 * Helpers.
 */

var ms$1;
var hasRequiredMs$2;

function requireMs$2 () {
	if (hasRequiredMs$2) return ms$1;
	hasRequiredMs$2 = 1;
	var s = 1000;
	var m = s * 60;
	var h = m * 60;
	var d = h * 24;
	var w = d * 7;
	var y = d * 365.25;

	/**
	 * Parse or format the given `val`.
	 *
	 * Options:
	 *
	 *  - `long` verbose formatting [false]
	 *
	 * @param {String|Number} val
	 * @param {Object} [options]
	 * @throws {Error} throw an error if val is not a non-empty string or a number
	 * @return {String|Number}
	 * @api public
	 */

	ms$1 = function (val, options) {
	  options = options || {};
	  var type = typeof val;
	  if (type === 'string' && val.length > 0) {
	    return parse(val);
	  } else if (type === 'number' && isFinite(val)) {
	    return options.long ? fmtLong(val) : fmtShort(val);
	  }
	  throw new Error(
	    'val is not a non-empty string or a valid number. val=' +
	      JSON.stringify(val)
	  );
	};

	/**
	 * Parse the given `str` and return milliseconds.
	 *
	 * @param {String} str
	 * @return {Number}
	 * @api private
	 */

	function parse(str) {
	  str = String(str);
	  if (str.length > 100) {
	    return;
	  }
	  var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
	    str
	  );
	  if (!match) {
	    return;
	  }
	  var n = parseFloat(match[1]);
	  var type = (match[2] || 'ms').toLowerCase();
	  switch (type) {
	    case 'years':
	    case 'year':
	    case 'yrs':
	    case 'yr':
	    case 'y':
	      return n * y;
	    case 'weeks':
	    case 'week':
	    case 'w':
	      return n * w;
	    case 'days':
	    case 'day':
	    case 'd':
	      return n * d;
	    case 'hours':
	    case 'hour':
	    case 'hrs':
	    case 'hr':
	    case 'h':
	      return n * h;
	    case 'minutes':
	    case 'minute':
	    case 'mins':
	    case 'min':
	    case 'm':
	      return n * m;
	    case 'seconds':
	    case 'second':
	    case 'secs':
	    case 'sec':
	    case 's':
	      return n * s;
	    case 'milliseconds':
	    case 'millisecond':
	    case 'msecs':
	    case 'msec':
	    case 'ms':
	      return n;
	    default:
	      return undefined;
	  }
	}

	/**
	 * Short format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtShort(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return Math.round(ms / d) + 'd';
	  }
	  if (msAbs >= h) {
	    return Math.round(ms / h) + 'h';
	  }
	  if (msAbs >= m) {
	    return Math.round(ms / m) + 'm';
	  }
	  if (msAbs >= s) {
	    return Math.round(ms / s) + 's';
	  }
	  return ms + 'ms';
	}

	/**
	 * Long format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtLong(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return plural(ms, msAbs, d, 'day');
	  }
	  if (msAbs >= h) {
	    return plural(ms, msAbs, h, 'hour');
	  }
	  if (msAbs >= m) {
	    return plural(ms, msAbs, m, 'minute');
	  }
	  if (msAbs >= s) {
	    return plural(ms, msAbs, s, 'second');
	  }
	  return ms + ' ms';
	}

	/**
	 * Pluralization helper.
	 */

	function plural(ms, msAbs, n, name) {
	  var isPlural = msAbs >= n * 1.5;
	  return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
	}
	return ms$1;
}

var common$1;
var hasRequiredCommon$1;

function requireCommon$1 () {
	if (hasRequiredCommon$1) return common$1;
	hasRequiredCommon$1 = 1;
	/**
	 * This is the common logic for both the Node.js and web browser
	 * implementations of `debug()`.
	 */

	function setup(env) {
		createDebug.debug = createDebug;
		createDebug.default = createDebug;
		createDebug.coerce = coerce;
		createDebug.disable = disable;
		createDebug.enable = enable;
		createDebug.enabled = enabled;
		createDebug.humanize = requireMs$2();
		createDebug.destroy = destroy;

		Object.keys(env).forEach(key => {
			createDebug[key] = env[key];
		});

		/**
		* The currently active debug mode names, and names to skip.
		*/

		createDebug.names = [];
		createDebug.skips = [];

		/**
		* Map of special "%n" handling functions, for the debug "format" argument.
		*
		* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
		*/
		createDebug.formatters = {};

		/**
		* Selects a color for a debug namespace
		* @param {String} namespace The namespace string for the debug instance to be colored
		* @return {Number|String} An ANSI color code for the given namespace
		* @api private
		*/
		function selectColor(namespace) {
			let hash = 0;

			for (let i = 0; i < namespace.length; i++) {
				hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
				hash |= 0; // Convert to 32bit integer
			}

			return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
		}
		createDebug.selectColor = selectColor;

		/**
		* Create a debugger with the given `namespace`.
		*
		* @param {String} namespace
		* @return {Function}
		* @api public
		*/
		function createDebug(namespace) {
			let prevTime;
			let enableOverride = null;
			let namespacesCache;
			let enabledCache;

			function debug(...args) {
				// Disabled?
				if (!debug.enabled) {
					return;
				}

				const self = debug;

				// Set `diff` timestamp
				const curr = Number(new Date());
				const ms = curr - (prevTime || curr);
				self.diff = ms;
				self.prev = prevTime;
				self.curr = curr;
				prevTime = curr;

				args[0] = createDebug.coerce(args[0]);

				if (typeof args[0] !== 'string') {
					// Anything else let's inspect with %O
					args.unshift('%O');
				}

				// Apply any `formatters` transformations
				let index = 0;
				args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
					// If we encounter an escaped % then don't increase the array index
					if (match === '%%') {
						return '%';
					}
					index++;
					const formatter = createDebug.formatters[format];
					if (typeof formatter === 'function') {
						const val = args[index];
						match = formatter.call(self, val);

						// Now we need to remove `args[index]` since it's inlined in the `format`
						args.splice(index, 1);
						index--;
					}
					return match;
				});

				// Apply env-specific formatting (colors, etc.)
				createDebug.formatArgs.call(self, args);

				const logFn = self.log || createDebug.log;
				logFn.apply(self, args);
			}

			debug.namespace = namespace;
			debug.useColors = createDebug.useColors();
			debug.color = createDebug.selectColor(namespace);
			debug.extend = extend;
			debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

			Object.defineProperty(debug, 'enabled', {
				enumerable: true,
				configurable: false,
				get: () => {
					if (enableOverride !== null) {
						return enableOverride;
					}
					if (namespacesCache !== createDebug.namespaces) {
						namespacesCache = createDebug.namespaces;
						enabledCache = createDebug.enabled(namespace);
					}

					return enabledCache;
				},
				set: v => {
					enableOverride = v;
				}
			});

			// Env-specific initialization logic for debug instances
			if (typeof createDebug.init === 'function') {
				createDebug.init(debug);
			}

			return debug;
		}

		function extend(namespace, delimiter) {
			const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
			newDebug.log = this.log;
			return newDebug;
		}

		/**
		* Enables a debug mode by namespaces. This can include modes
		* separated by a colon and wildcards.
		*
		* @param {String} namespaces
		* @api public
		*/
		function enable(namespaces) {
			createDebug.save(namespaces);
			createDebug.namespaces = namespaces;

			createDebug.names = [];
			createDebug.skips = [];

			const split = (typeof namespaces === 'string' ? namespaces : '')
				.trim()
				.replace(/\s+/g, ',')
				.split(',')
				.filter(Boolean);

			for (const ns of split) {
				if (ns[0] === '-') {
					createDebug.skips.push(ns.slice(1));
				} else {
					createDebug.names.push(ns);
				}
			}
		}

		/**
		 * Checks if the given string matches a namespace template, honoring
		 * asterisks as wildcards.
		 *
		 * @param {String} search
		 * @param {String} template
		 * @return {Boolean}
		 */
		function matchesTemplate(search, template) {
			let searchIndex = 0;
			let templateIndex = 0;
			let starIndex = -1;
			let matchIndex = 0;

			while (searchIndex < search.length) {
				if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === '*')) {
					// Match character or proceed with wildcard
					if (template[templateIndex] === '*') {
						starIndex = templateIndex;
						matchIndex = searchIndex;
						templateIndex++; // Skip the '*'
					} else {
						searchIndex++;
						templateIndex++;
					}
				} else if (starIndex !== -1) { // eslint-disable-line no-negated-condition
					// Backtrack to the last '*' and try to match more characters
					templateIndex = starIndex + 1;
					matchIndex++;
					searchIndex = matchIndex;
				} else {
					return false; // No match
				}
			}

			// Handle trailing '*' in template
			while (templateIndex < template.length && template[templateIndex] === '*') {
				templateIndex++;
			}

			return templateIndex === template.length;
		}

		/**
		* Disable debug output.
		*
		* @return {String} namespaces
		* @api public
		*/
		function disable() {
			const namespaces = [
				...createDebug.names,
				...createDebug.skips.map(namespace => '-' + namespace)
			].join(',');
			createDebug.enable('');
			return namespaces;
		}

		/**
		* Returns true if the given mode name is enabled, false otherwise.
		*
		* @param {String} name
		* @return {Boolean}
		* @api public
		*/
		function enabled(name) {
			for (const skip of createDebug.skips) {
				if (matchesTemplate(name, skip)) {
					return false;
				}
			}

			for (const ns of createDebug.names) {
				if (matchesTemplate(name, ns)) {
					return true;
				}
			}

			return false;
		}

		/**
		* Coerce `val`.
		*
		* @param {Mixed} val
		* @return {Mixed}
		* @api private
		*/
		function coerce(val) {
			if (val instanceof Error) {
				return val.stack || val.message;
			}
			return val;
		}

		/**
		* XXX DO NOT USE. This is a temporary stub function.
		* XXX It WILL be removed in the next major release.
		*/
		function destroy() {
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}

		createDebug.enable(createDebug.load());

		return createDebug;
	}

	common$1 = setup;
	return common$1;
}

/* eslint-env browser */

var hasRequiredBrowser$5;

function requireBrowser$5 () {
	if (hasRequiredBrowser$5) return browser$5.exports;
	hasRequiredBrowser$5 = 1;
	(function (module, exports$1) {
		/**
		 * This is the web browser implementation of `debug()`.
		 */

		exports$1.formatArgs = formatArgs;
		exports$1.save = save;
		exports$1.load = load;
		exports$1.useColors = useColors;
		exports$1.storage = localstorage();
		exports$1.destroy = (() => {
			let warned = false;

			return () => {
				if (!warned) {
					warned = true;
					console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
				}
			};
		})();

		/**
		 * Colors.
		 */

		exports$1.colors = [
			'#0000CC',
			'#0000FF',
			'#0033CC',
			'#0033FF',
			'#0066CC',
			'#0066FF',
			'#0099CC',
			'#0099FF',
			'#00CC00',
			'#00CC33',
			'#00CC66',
			'#00CC99',
			'#00CCCC',
			'#00CCFF',
			'#3300CC',
			'#3300FF',
			'#3333CC',
			'#3333FF',
			'#3366CC',
			'#3366FF',
			'#3399CC',
			'#3399FF',
			'#33CC00',
			'#33CC33',
			'#33CC66',
			'#33CC99',
			'#33CCCC',
			'#33CCFF',
			'#6600CC',
			'#6600FF',
			'#6633CC',
			'#6633FF',
			'#66CC00',
			'#66CC33',
			'#9900CC',
			'#9900FF',
			'#9933CC',
			'#9933FF',
			'#99CC00',
			'#99CC33',
			'#CC0000',
			'#CC0033',
			'#CC0066',
			'#CC0099',
			'#CC00CC',
			'#CC00FF',
			'#CC3300',
			'#CC3333',
			'#CC3366',
			'#CC3399',
			'#CC33CC',
			'#CC33FF',
			'#CC6600',
			'#CC6633',
			'#CC9900',
			'#CC9933',
			'#CCCC00',
			'#CCCC33',
			'#FF0000',
			'#FF0033',
			'#FF0066',
			'#FF0099',
			'#FF00CC',
			'#FF00FF',
			'#FF3300',
			'#FF3333',
			'#FF3366',
			'#FF3399',
			'#FF33CC',
			'#FF33FF',
			'#FF6600',
			'#FF6633',
			'#FF9900',
			'#FF9933',
			'#FFCC00',
			'#FFCC33'
		];

		/**
		 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
		 * and the Firebug extension (any Firefox version) are known
		 * to support "%c" CSS customizations.
		 *
		 * TODO: add a `localStorage` variable to explicitly enable/disable colors
		 */

		// eslint-disable-next-line complexity
		function useColors() {
			// NB: In an Electron preload script, document will be defined but not fully
			// initialized. Since we know we're in Chrome, we'll just detect this case
			// explicitly
			if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
				return true;
			}

			// Internet Explorer and Edge do not support colors.
			if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
				return false;
			}

			let m;

			// Is webkit? http://stackoverflow.com/a/16459606/376773
			// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
			// eslint-disable-next-line no-return-assign
			return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
				// Is firebug? http://stackoverflow.com/a/398120/376773
				(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
				// Is firefox >= v31?
				// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
				(typeof navigator !== 'undefined' && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31) ||
				// Double check webkit in userAgent just in case we are in a worker
				(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
		}

		/**
		 * Colorize log arguments if enabled.
		 *
		 * @api public
		 */

		function formatArgs(args) {
			args[0] = (this.useColors ? '%c' : '') +
				this.namespace +
				(this.useColors ? ' %c' : ' ') +
				args[0] +
				(this.useColors ? '%c ' : ' ') +
				'+' + module.exports.humanize(this.diff);

			if (!this.useColors) {
				return;
			}

			const c = 'color: ' + this.color;
			args.splice(1, 0, c, 'color: inherit');

			// The final "%c" is somewhat tricky, because there could be other
			// arguments passed either before or after the %c, so we need to
			// figure out the correct index to insert the CSS into
			let index = 0;
			let lastC = 0;
			args[0].replace(/%[a-zA-Z%]/g, match => {
				if (match === '%%') {
					return;
				}
				index++;
				if (match === '%c') {
					// We only are interested in the *last* %c
					// (the user may have provided their own)
					lastC = index;
				}
			});

			args.splice(lastC, 0, c);
		}

		/**
		 * Invokes `console.debug()` when available.
		 * No-op when `console.debug` is not a "function".
		 * If `console.debug` is not available, falls back
		 * to `console.log`.
		 *
		 * @api public
		 */
		exports$1.log = console.debug || console.log || (() => {});

		/**
		 * Save `namespaces`.
		 *
		 * @param {String} namespaces
		 * @api private
		 */
		function save(namespaces) {
			try {
				if (namespaces) {
					exports$1.storage.setItem('debug', namespaces);
				} else {
					exports$1.storage.removeItem('debug');
				}
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}
		}

		/**
		 * Load `namespaces`.
		 *
		 * @return {String} returns the previously persisted debug modes
		 * @api private
		 */
		function load() {
			let r;
			try {
				r = exports$1.storage.getItem('debug') || exports$1.storage.getItem('DEBUG') ;
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}

			// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
			if (!r && typeof process !== 'undefined' && 'env' in process) {
				r = process.env.DEBUG;
			}

			return r;
		}

		/**
		 * Localstorage attempts to return the localstorage.
		 *
		 * This is necessary because safari throws
		 * when a user disables cookies/localstorage
		 * and you attempt to access it.
		 *
		 * @return {LocalStorage}
		 * @api private
		 */

		function localstorage() {
			try {
				// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
				// The Browser also has localStorage in the global context.
				return localStorage;
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}
		}

		module.exports = requireCommon$1()(exports$1);

		const {formatters} = module.exports;

		/**
		 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
		 */

		formatters.j = function (v) {
			try {
				return JSON.stringify(v);
			} catch (error) {
				return '[UnexpectedJSONParseError]: ' + error.message;
			}
		}; 
	} (browser$5, browser$5.exports));
	return browser$5.exports;
}

var browserExports = requireBrowser$5();
const initDebug = /*@__PURE__*/getDefaultExportFromCjs(browserExports);

/**
 * Ref https://pkware.cachefly.net/webdocs/casestudies/APPNOTE.TXT
 */
const Signature = {
    LocalFileHeader: 0x04034b50,
    DataDescriptor: 0x08074b50,
    CentralFileHeader: 0x02014b50,
    EndOfCentralDirectory: 0x06054b50
};
const DataDescriptor = {
    get(array) {
        return {
            signature: UINT32_LE.get(array, 0),
            compressedSize: UINT32_LE.get(array, 8),
            uncompressedSize: UINT32_LE.get(array, 12),
        };
    }, len: 16
};
/**
 * First part of the ZIP Local File Header
 * Offset | Bytes| Description
 * -------|------+-------------------------------------------------------------------
 *      0 |    4 | Signature (0x04034b50)
 *      4 |    2 | Minimum version needed to extract
 *      6 |    2 | Bit flag
 *      8 |    2 | Compression method
 *     10 |    2 | File last modification time (MS-DOS format)
 *     12 |    2 | File last modification date (MS-DOS format)
 *     14 |    4 | CRC-32 of uncompressed data
 *     18 |    4 | Compressed size
 *     22 |    4 | Uncompressed size
 *     26 |    2 | File name length (n)
 *     28 |    2 | Extra field length (m)
 *     30 |    n | File name
 * 30 + n |    m | Extra field
 */
const LocalFileHeaderToken = {
    get(array) {
        const flags = UINT16_LE.get(array, 6);
        return {
            signature: UINT32_LE.get(array, 0),
            minVersion: UINT16_LE.get(array, 4),
            dataDescriptor: !!(flags & 0x0008),
            compressedMethod: UINT16_LE.get(array, 8),
            compressedSize: UINT32_LE.get(array, 18),
            uncompressedSize: UINT32_LE.get(array, 22),
            filenameLength: UINT16_LE.get(array, 26),
            extraFieldLength: UINT16_LE.get(array, 28),
            filename: null
        };
    }, len: 30
};
/**
 * 4.3.16  End of central directory record:
 *  end of central dir signature (0x06064b50)                                      4 bytes
 *  number of this disk                                                            2 bytes
 *  number of the disk with the start of the central directory                     2 bytes
 *  total number of entries in the central directory on this disk                  2 bytes
 *  total number of entries in the size of the central directory                   2 bytes
 *  sizeOfTheCentralDirectory                                                      4 bytes
 *  offset of start of central directory with respect to the starting disk number  4 bytes
 *  .ZIP file comment length                                                       2 bytes
 *  .ZIP file comment       (variable size)
 */
const EndOfCentralDirectoryRecordToken = {
    get(array) {
        return {
            signature: UINT32_LE.get(array, 0),
            nrOfThisDisk: UINT16_LE.get(array, 4),
            nrOfThisDiskWithTheStart: UINT16_LE.get(array, 6),
            nrOfEntriesOnThisDisk: UINT16_LE.get(array, 8),
            nrOfEntriesOfSize: UINT16_LE.get(array, 10),
            sizeOfCd: UINT32_LE.get(array, 12),
            offsetOfStartOfCd: UINT32_LE.get(array, 16),
            zipFileCommentLength: UINT16_LE.get(array, 20),
        };
    }, len: 22
};
/**
 * File header:
 *    central file header signature   4 bytes   0 (0x02014b50)
 *    version made by                 2 bytes   4
 *    version needed to extract       2 bytes   6
 *    general purpose bit flag        2 bytes   8
 *    compression method              2 bytes  10
 *    last mod file time              2 bytes  12
 *    last mod file date              2 bytes  14
 *    crc-32                          4 bytes  16
 *    compressed size                 4 bytes  20
 *    uncompressed size               4 bytes  24
 *    file name length                2 bytes  28
 *    extra field length              2 bytes  30
 *    file comment length             2 bytes  32
 *    disk number start               2 bytes  34
 *    internal file attributes        2 bytes  36
 *    external file attributes        4 bytes  38
 *    relative offset of local header 4 bytes  42
 */
const FileHeader = {
    get(array) {
        const flags = UINT16_LE.get(array, 8);
        return {
            signature: UINT32_LE.get(array, 0),
            minVersion: UINT16_LE.get(array, 6),
            dataDescriptor: !!(flags & 0x0008),
            compressedMethod: UINT16_LE.get(array, 10),
            compressedSize: UINT32_LE.get(array, 20),
            uncompressedSize: UINT32_LE.get(array, 24),
            filenameLength: UINT16_LE.get(array, 28),
            extraFieldLength: UINT16_LE.get(array, 30),
            fileCommentLength: UINT16_LE.get(array, 32),
            relativeOffsetOfLocalHeader: UINT32_LE.get(array, 42),
            filename: null
        };
    }, len: 46
};

function signatureToArray(signature) {
    const signatureBytes = new Uint8Array(UINT32_LE.len);
    UINT32_LE.put(signatureBytes, 0, signature);
    return signatureBytes;
}
const debug$1 = initDebug('tokenizer:inflate');
const syncBufferSize = 256 * 1024;
const ddSignatureArray = signatureToArray(Signature.DataDescriptor);
const eocdSignatureBytes = signatureToArray(Signature.EndOfCentralDirectory);
class ZipHandler {
    constructor(tokenizer) {
        this.tokenizer = tokenizer;
        this.syncBuffer = new Uint8Array(syncBufferSize);
    }
    async isZip() {
        return await this.peekSignature() === Signature.LocalFileHeader;
    }
    peekSignature() {
        return this.tokenizer.peekToken(UINT32_LE);
    }
    async findEndOfCentralDirectoryLocator() {
        const randomReadTokenizer = this.tokenizer;
        const chunkLength = Math.min(16 * 1024, randomReadTokenizer.fileInfo.size);
        const buffer = this.syncBuffer.subarray(0, chunkLength);
        await this.tokenizer.readBuffer(buffer, { position: randomReadTokenizer.fileInfo.size - chunkLength });
        // Search the buffer from end to beginning for EOCD signature
        // const signature = 0x06054b50;
        for (let i = buffer.length - 4; i >= 0; i--) {
            // Compare 4 bytes directly without calling readUInt32LE
            if (buffer[i] === eocdSignatureBytes[0] &&
                buffer[i + 1] === eocdSignatureBytes[1] &&
                buffer[i + 2] === eocdSignatureBytes[2] &&
                buffer[i + 3] === eocdSignatureBytes[3]) {
                return randomReadTokenizer.fileInfo.size - chunkLength + i;
            }
        }
        return -1;
    }
    async readCentralDirectory() {
        if (!this.tokenizer.supportsRandomAccess()) {
            debug$1('Cannot reading central-directory without random-read support');
            return;
        }
        debug$1('Reading central-directory...');
        const pos = this.tokenizer.position;
        const offset = await this.findEndOfCentralDirectoryLocator();
        if (offset > 0) {
            debug$1('Central-directory 32-bit signature found');
            const eocdHeader = await this.tokenizer.readToken(EndOfCentralDirectoryRecordToken, offset);
            const files = [];
            this.tokenizer.setPosition(eocdHeader.offsetOfStartOfCd);
            for (let n = 0; n < eocdHeader.nrOfEntriesOfSize; ++n) {
                const entry = await this.tokenizer.readToken(FileHeader);
                if (entry.signature !== Signature.CentralFileHeader) {
                    throw new Error('Expected Central-File-Header signature');
                }
                entry.filename = await this.tokenizer.readToken(new StringType(entry.filenameLength, 'utf-8'));
                await this.tokenizer.ignore(entry.extraFieldLength);
                await this.tokenizer.ignore(entry.fileCommentLength);
                files.push(entry);
                debug$1(`Add central-directory file-entry: n=${n + 1}/${files.length}: filename=${files[n].filename}`);
            }
            this.tokenizer.setPosition(pos);
            return files;
        }
        this.tokenizer.setPosition(pos);
    }
    async unzip(fileCb) {
        const entries = await this.readCentralDirectory();
        if (entries) {
            // Use Central Directory to iterate over files
            return this.iterateOverCentralDirectory(entries, fileCb);
        }
        // Scan Zip files for local-file-header
        let stop = false;
        do {
            const zipHeader = await this.readLocalFileHeader();
            if (!zipHeader)
                break;
            const next = fileCb(zipHeader);
            stop = !!next.stop;
            let fileData = undefined;
            await this.tokenizer.ignore(zipHeader.extraFieldLength);
            if (zipHeader.dataDescriptor && zipHeader.compressedSize === 0) {
                const chunks = [];
                let len = syncBufferSize;
                debug$1('Compressed-file-size unknown, scanning for next data-descriptor-signature....');
                let nextHeaderIndex = -1;
                while (nextHeaderIndex < 0 && len === syncBufferSize) {
                    len = await this.tokenizer.peekBuffer(this.syncBuffer, { mayBeLess: true });
                    nextHeaderIndex = indexOf(this.syncBuffer.subarray(0, len), ddSignatureArray);
                    const size = nextHeaderIndex >= 0 ? nextHeaderIndex : len;
                    if (next.handler) {
                        const data = new Uint8Array(size);
                        await this.tokenizer.readBuffer(data);
                        chunks.push(data);
                    }
                    else {
                        // Move position to the next header if found, skip the whole buffer otherwise
                        await this.tokenizer.ignore(size);
                    }
                }
                debug$1(`Found data-descriptor-signature at pos=${this.tokenizer.position}`);
                if (next.handler) {
                    await this.inflate(zipHeader, mergeArrays(chunks), next.handler);
                }
            }
            else {
                if (next.handler) {
                    debug$1(`Reading compressed-file-data: ${zipHeader.compressedSize} bytes`);
                    fileData = new Uint8Array(zipHeader.compressedSize);
                    await this.tokenizer.readBuffer(fileData);
                    await this.inflate(zipHeader, fileData, next.handler);
                }
                else {
                    debug$1(`Ignoring compressed-file-data: ${zipHeader.compressedSize} bytes`);
                    await this.tokenizer.ignore(zipHeader.compressedSize);
                }
            }
            debug$1(`Reading data-descriptor at pos=${this.tokenizer.position}`);
            if (zipHeader.dataDescriptor) {
                // await this.tokenizer.ignore(DataDescriptor.len);
                const dataDescriptor = await this.tokenizer.readToken(DataDescriptor);
                if (dataDescriptor.signature !== 0x08074b50) {
                    throw new Error(`Expected data-descriptor-signature at position ${this.tokenizer.position - DataDescriptor.len}`);
                }
            }
        } while (!stop);
    }
    async iterateOverCentralDirectory(entries, fileCb) {
        for (const fileHeader of entries) {
            const next = fileCb(fileHeader);
            if (next.handler) {
                this.tokenizer.setPosition(fileHeader.relativeOffsetOfLocalHeader);
                const zipHeader = await this.readLocalFileHeader();
                if (zipHeader) {
                    await this.tokenizer.ignore(zipHeader.extraFieldLength);
                    const fileData = new Uint8Array(fileHeader.compressedSize);
                    await this.tokenizer.readBuffer(fileData);
                    await this.inflate(zipHeader, fileData, next.handler);
                }
            }
            if (next.stop)
                break;
        }
    }
    inflate(zipHeader, fileData, cb) {
        if (zipHeader.compressedMethod === 0) {
            return cb(fileData);
        }
        debug$1(`Decompress filename=${zipHeader.filename}, compressed-size=${fileData.length}`);
        const uncompressedData = decompressSync(fileData);
        return cb(uncompressedData);
    }
    async readLocalFileHeader() {
        const signature = await this.tokenizer.peekToken(UINT32_LE);
        if (signature === Signature.LocalFileHeader) {
            const header = await this.tokenizer.readToken(LocalFileHeaderToken);
            header.filename = await this.tokenizer.readToken(new StringType(header.filenameLength, 'utf-8'));
            return header;
        }
        if (signature === Signature.CentralFileHeader) {
            return false;
        }
        if (signature === 0xE011CFD0) {
            throw new Error('Encrypted ZIP');
        }
        throw new Error('Unexpected signature');
    }
}
function indexOf(buffer, portion) {
    const bufferLength = buffer.length;
    const portionLength = portion.length;
    // Return -1 if the portion is longer than the buffer
    if (portionLength > bufferLength)
        return -1;
    // Search for the portion in the buffer
    for (let i = 0; i <= bufferLength - portionLength; i++) {
        let found = true;
        for (let j = 0; j < portionLength; j++) {
            if (buffer[i + j] !== portion[j]) {
                found = false;
                break;
            }
        }
        if (found) {
            return i; // Return the starting offset
        }
    }
    return -1; // Not found
}
function mergeArrays(chunks) {
    // Concatenate chunks into a single Uint8Array
    const totalLength = chunks.reduce((acc, curr) => acc + curr.length, 0);
    const mergedArray = new Uint8Array(totalLength);
    let offset = 0;
    for (const chunk of chunks) {
        mergedArray.set(chunk, offset);
        offset += chunk.length;
    }
    return mergedArray;
}

class GzipHandler {
    constructor(tokenizer) {
        this.gunzip = undefined;
        this.tokenizer = tokenizer;
    }
    inflate() {
        let done = false;
        let cancelled = false;
        const parent = this;
        return new ReadableStream({
            start: controller => {
                parent.gunzip = new AsyncGunzip((err, chunk, final) => {
                    if (err) {
                        controller.error(err);
                        return;
                    }
                    if (chunk && !cancelled) {
                        controller.enqueue(chunk);
                    }
                    if (final && !cancelled) {
                        controller.close();
                        parent.gunzip.terminate();
                    }
                });
            },
            async pull(controller) {
                const chunkSize = 1024;
                try {
                    const buffer = new Uint8Array(chunkSize);
                    const size = await parent.tokenizer.readBuffer(buffer, { mayBeLess: true });
                    if (size === 0) {
                        if (!done) {
                            done = true;
                            if (!cancelled) {
                                parent.gunzip.push(new Uint8Array(0), true);
                            }
                        }
                        return;
                    }
                    parent.gunzip.push(buffer.subarray(0, size), false);
                }
                catch (err) {
                    controller.error(err);
                }
            },
            cancel: () => {
                parent.gunzip.terminate();
                cancelled = true;
            }
        });
    }
}

({
	utf8: new globalThis.TextDecoder('utf8'),
});

new globalThis.TextEncoder();

Array.from({length: 256}, (_, index) => index.toString(16).padStart(2, '0'));

/**
@param {DataView} view
@returns {number}
*/
function getUintBE(view) {
	const {byteLength} = view;

	if (byteLength === 6) {
		return (view.getUint16(0) * (2 ** 32)) + view.getUint32(2);
	}

	if (byteLength === 5) {
		return (view.getUint8(0) * (2 ** 32)) + view.getUint32(1);
	}

	if (byteLength === 4) {
		return view.getUint32(0);
	}

	if (byteLength === 3) {
		return (view.getUint8(0) * (2 ** 16)) + view.getUint16(1);
	}

	if (byteLength === 2) {
		return view.getUint16(0);
	}

	if (byteLength === 1) {
		return view.getUint8(0);
	}
}

function stringToBytes(string, encoding) {
	if (encoding === 'utf-16le') {
		const bytes = [];
		for (let index = 0; index < string.length; index++) {
			const code = string.charCodeAt(index); // eslint-disable-line unicorn/prefer-code-point
			bytes.push(code & 0xFF, (code >> 8) & 0xFF); // High byte
		}

		return bytes;
	}

	if (encoding === 'utf-16be') {
		const bytes = [];
		for (let index = 0; index < string.length; index++) {
			const code = string.charCodeAt(index); // eslint-disable-line unicorn/prefer-code-point
			bytes.push((code >> 8) & 0xFF, code & 0xFF); // Low byte
		}

		return bytes;
	}

	return [...string].map(character => character.charCodeAt(0)); // eslint-disable-line unicorn/prefer-code-point
}

/**
Checks whether the TAR checksum is valid.

@param {Uint8Array} arrayBuffer - The TAR header `[offset ... offset + 512]`.
@param {number} offset - TAR header offset.
@returns {boolean} `true` if the TAR checksum is valid, otherwise `false`.
*/
function tarHeaderChecksumMatches(arrayBuffer, offset = 0) {
	const readSum = Number.parseInt(new StringType(6).get(arrayBuffer, 148).replace(/\0.*$/, '').trim(), 8); // Read sum in header
	if (Number.isNaN(readSum)) {
		return false;
	}

	let sum = 8 * 0x20; // Initialize signed bit sum

	for (let index = offset; index < offset + 148; index++) {
		sum += arrayBuffer[index];
	}

	for (let index = offset + 156; index < offset + 512; index++) {
		sum += arrayBuffer[index];
	}

	return readSum === sum;
}

/**
ID3 UINT32 sync-safe tokenizer token.
28 bits (representing up to 256MB) integer, the msb is 0 to avoid "false syncsignals".
*/
const uint32SyncSafeToken = {
	get: (buffer, offset) => (buffer[offset + 3] & 0x7F) | ((buffer[offset + 2]) << 7) | ((buffer[offset + 1]) << 14) | ((buffer[offset]) << 21),
	len: 4,
};

const extensions = [
	'jpg',
	'png',
	'apng',
	'gif',
	'webp',
	'flif',
	'xcf',
	'cr2',
	'cr3',
	'orf',
	'arw',
	'dng',
	'nef',
	'rw2',
	'raf',
	'tif',
	'bmp',
	'icns',
	'jxr',
	'psd',
	'indd',
	'zip',
	'tar',
	'rar',
	'gz',
	'bz2',
	'7z',
	'dmg',
	'mp4',
	'mid',
	'mkv',
	'webm',
	'mov',
	'avi',
	'mpg',
	'mp2',
	'mp3',
	'm4a',
	'oga',
	'ogg',
	'ogv',
	'opus',
	'flac',
	'wav',
	'spx',
	'amr',
	'pdf',
	'epub',
	'elf',
	'macho',
	'exe',
	'swf',
	'rtf',
	'wasm',
	'woff',
	'woff2',
	'eot',
	'ttf',
	'otf',
	'ttc',
	'ico',
	'flv',
	'ps',
	'xz',
	'sqlite',
	'nes',
	'crx',
	'xpi',
	'cab',
	'deb',
	'ar',
	'rpm',
	'Z',
	'lz',
	'cfb',
	'mxf',
	'mts',
	'blend',
	'bpg',
	'docx',
	'pptx',
	'xlsx',
	'3gp',
	'3g2',
	'j2c',
	'jp2',
	'jpm',
	'jpx',
	'mj2',
	'aif',
	'qcp',
	'odt',
	'ods',
	'odp',
	'xml',
	'mobi',
	'heic',
	'cur',
	'ktx',
	'ape',
	'wv',
	'dcm',
	'ics',
	'glb',
	'pcap',
	'dsf',
	'lnk',
	'alias',
	'voc',
	'ac3',
	'm4v',
	'm4p',
	'm4b',
	'f4v',
	'f4p',
	'f4b',
	'f4a',
	'mie',
	'asf',
	'ogm',
	'ogx',
	'mpc',
	'arrow',
	'shp',
	'aac',
	'mp1',
	'it',
	's3m',
	'xm',
	'skp',
	'avif',
	'eps',
	'lzh',
	'pgp',
	'asar',
	'stl',
	'chm',
	'3mf',
	'zst',
	'jxl',
	'vcf',
	'jls',
	'pst',
	'dwg',
	'parquet',
	'class',
	'arj',
	'cpio',
	'ace',
	'avro',
	'icc',
	'fbx',
	'vsdx',
	'vtt',
	'apk',
	'drc',
	'lz4',
	'potx',
	'xltx',
	'dotx',
	'xltm',
	'ott',
	'ots',
	'otp',
	'odg',
	'otg',
	'xlsm',
	'docm',
	'dotm',
	'potm',
	'pptm',
	'jar',
	'rm',
	'ppsm',
	'ppsx',
	'tar.gz',
	'reg',
	'dat',
];

const mimeTypes$1 = [
	'image/jpeg',
	'image/png',
	'image/gif',
	'image/webp',
	'image/flif',
	'image/x-xcf',
	'image/x-canon-cr2',
	'image/x-canon-cr3',
	'image/tiff',
	'image/bmp',
	'image/vnd.ms-photo',
	'image/vnd.adobe.photoshop',
	'application/x-indesign',
	'application/epub+zip',
	'application/x-xpinstall',
	'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
	'application/vnd.oasis.opendocument.text',
	'application/vnd.oasis.opendocument.spreadsheet',
	'application/vnd.oasis.opendocument.presentation',
	'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'application/vnd.openxmlformats-officedocument.presentationml.presentation',
	'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
	'application/zip',
	'application/x-tar',
	'application/x-rar-compressed',
	'application/gzip',
	'application/x-bzip2',
	'application/x-7z-compressed',
	'application/x-apple-diskimage',
	'application/vnd.apache.arrow.file',
	'video/mp4',
	'audio/midi',
	'video/matroska',
	'video/webm',
	'video/quicktime',
	'video/vnd.avi',
	'audio/wav',
	'audio/qcelp',
	'audio/x-ms-asf',
	'video/x-ms-asf',
	'application/vnd.ms-asf',
	'video/mpeg',
	'video/3gpp',
	'audio/mpeg',
	'audio/mp4', // RFC 4337
	'video/ogg',
	'audio/ogg',
	'audio/ogg; codecs=opus',
	'application/ogg',
	'audio/flac',
	'audio/ape',
	'audio/wavpack',
	'audio/amr',
	'application/pdf',
	'application/x-elf',
	'application/x-mach-binary',
	'application/x-msdownload',
	'application/x-shockwave-flash',
	'application/rtf',
	'application/wasm',
	'font/woff',
	'font/woff2',
	'application/vnd.ms-fontobject',
	'font/ttf',
	'font/otf',
	'font/collection',
	'image/x-icon',
	'video/x-flv',
	'application/postscript',
	'application/eps',
	'application/x-xz',
	'application/x-sqlite3',
	'application/x-nintendo-nes-rom',
	'application/x-google-chrome-extension',
	'application/vnd.ms-cab-compressed',
	'application/x-deb',
	'application/x-unix-archive',
	'application/x-rpm',
	'application/x-compress',
	'application/x-lzip',
	'application/x-cfb',
	'application/x-mie',
	'application/mxf',
	'video/mp2t',
	'application/x-blender',
	'image/bpg',
	'image/j2c',
	'image/jp2',
	'image/jpx',
	'image/jpm',
	'image/mj2',
	'audio/aiff',
	'application/xml',
	'application/x-mobipocket-ebook',
	'image/heif',
	'image/heif-sequence',
	'image/heic',
	'image/heic-sequence',
	'image/icns',
	'image/ktx',
	'application/dicom',
	'audio/x-musepack',
	'text/calendar',
	'text/vcard',
	'text/vtt',
	'model/gltf-binary',
	'application/vnd.tcpdump.pcap',
	'audio/x-dsf', // Non-standard
	'application/x.ms.shortcut', // Invented by us
	'application/x.apple.alias', // Invented by us
	'audio/x-voc',
	'audio/vnd.dolby.dd-raw',
	'audio/x-m4a',
	'image/apng',
	'image/x-olympus-orf',
	'image/x-sony-arw',
	'image/x-adobe-dng',
	'image/x-nikon-nef',
	'image/x-panasonic-rw2',
	'image/x-fujifilm-raf',
	'video/x-m4v',
	'video/3gpp2',
	'application/x-esri-shape',
	'audio/aac',
	'audio/x-it',
	'audio/x-s3m',
	'audio/x-xm',
	'video/MP1S',
	'video/MP2P',
	'application/vnd.sketchup.skp',
	'image/avif',
	'application/x-lzh-compressed',
	'application/pgp-encrypted',
	'application/x-asar',
	'model/stl',
	'application/vnd.ms-htmlhelp',
	'model/3mf',
	'image/jxl',
	'application/zstd',
	'image/jls',
	'application/vnd.ms-outlook',
	'image/vnd.dwg',
	'application/vnd.apache.parquet',
	'application/java-vm',
	'application/x-arj',
	'application/x-cpio',
	'application/x-ace-compressed',
	'application/avro',
	'application/vnd.iccprofile',
	'application/x.autodesk.fbx', // Invented by us
	'application/vnd.visio',
	'application/vnd.android.package-archive',
	'application/vnd.google.draco', // Invented by us
	'application/x-lz4', // Invented by us
	'application/vnd.openxmlformats-officedocument.presentationml.template',
	'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
	'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'application/vnd.ms-excel.template.macroenabled.12',
	'application/vnd.oasis.opendocument.text-template',
	'application/vnd.oasis.opendocument.spreadsheet-template',
	'application/vnd.oasis.opendocument.presentation-template',
	'application/vnd.oasis.opendocument.graphics',
	'application/vnd.oasis.opendocument.graphics-template',
	'application/vnd.ms-excel.sheet.macroenabled.12',
	'application/vnd.ms-word.document.macroenabled.12',
	'application/vnd.ms-word.template.macroenabled.12',
	'application/vnd.ms-powerpoint.template.macroenabled.12',
	'application/vnd.ms-powerpoint.presentation.macroenabled.12',
	'application/java-archive',
	'application/vnd.rn-realmedia',
	'application/x-ms-regedit',
	'application/x-ft-windows-registry-hive',
];

/**
Primary entry point, Node.js specific entry point is index.js
*/


const reasonableDetectionSizeInBytes = 4100; // A fair amount of file-types are detectable within this range.

function getFileTypeFromMimeType(mimeType) {
	mimeType = mimeType.toLowerCase();
	switch (mimeType) {
		case 'application/epub+zip':
			return {
				ext: 'epub',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.text':
			return {
				ext: 'odt',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.text-template':
			return {
				ext: 'ott',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.spreadsheet':
			return {
				ext: 'ods',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.spreadsheet-template':
			return {
				ext: 'ots',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.presentation':
			return {
				ext: 'odp',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.presentation-template':
			return {
				ext: 'otp',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.graphics':
			return {
				ext: 'odg',
				mime: mimeType,
			};
		case 'application/vnd.oasis.opendocument.graphics-template':
			return {
				ext: 'otg',
				mime: mimeType,
			};
		case 'application/vnd.openxmlformats-officedocument.presentationml.slideshow':
			return {
				ext: 'ppsx',
				mime: mimeType,
			};
		case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
			return {
				ext: 'xlsx',
				mime: mimeType,
			};
		case 'application/vnd.ms-excel.sheet.macroenabled':
			return {
				ext: 'xlsm',
				mime: 'application/vnd.ms-excel.sheet.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.spreadsheetml.template':
			return {
				ext: 'xltx',
				mime: mimeType,
			};
		case 'application/vnd.ms-excel.template.macroenabled':
			return {
				ext: 'xltm',
				mime: 'application/vnd.ms-excel.template.macroenabled.12',
			};
		case 'application/vnd.ms-powerpoint.slideshow.macroenabled':
			return {
				ext: 'ppsm',
				mime: 'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
			return {
				ext: 'docx',
				mime: mimeType,
			};
		case 'application/vnd.ms-word.document.macroenabled':
			return {
				ext: 'docm',
				mime: 'application/vnd.ms-word.document.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.wordprocessingml.template':
			return {
				ext: 'dotx',
				mime: mimeType,
			};
		case 'application/vnd.ms-word.template.macroenabledtemplate':
			return {
				ext: 'dotm',
				mime: 'application/vnd.ms-word.template.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.presentationml.template':
			return {
				ext: 'potx',
				mime: mimeType,
			};
		case 'application/vnd.ms-powerpoint.template.macroenabled':
			return {
				ext: 'potm',
				mime: 'application/vnd.ms-powerpoint.template.macroenabled.12',
			};
		case 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
			return {
				ext: 'pptx',
				mime: mimeType,
			};
		case 'application/vnd.ms-powerpoint.presentation.macroenabled':
			return {
				ext: 'pptm',
				mime: 'application/vnd.ms-powerpoint.presentation.macroenabled.12',
			};
		case 'application/vnd.ms-visio.drawing':
			return {
				ext: 'vsdx',
				mime: 'application/vnd.visio',
			};
		case 'application/vnd.ms-package.3dmanufacturing-3dmodel+xml':
			return {
				ext: '3mf',
				mime: 'model/3mf',
			};
	}
}

function _check(buffer, headers, options) {
	options = {
		offset: 0,
		...options,
	};

	for (const [index, header] of headers.entries()) {
		// If a bitmask is set
		if (options.mask) {
			// If header doesn't equal `buf` with bits masked off
			if (header !== (options.mask[index] & buffer[index + options.offset])) {
				return false;
			}
		} else if (header !== buffer[index + options.offset]) {
			return false;
		}
	}

	return true;
}

let FileTypeParser$1 = class FileTypeParser {
	constructor(options) {
		this.options = {
			mpegOffsetTolerance: 0,
			...options,
		};

		this.detectors = [...(options?.customDetectors ?? []),
			{id: 'core', detect: this.detectConfident},
			{id: 'core.imprecise', detect: this.detectImprecise}];
		this.tokenizerOptions = {
			abortSignal: options?.signal,
		};
	}

	async fromTokenizer(tokenizer) {
		const initialPosition = tokenizer.position;

		// Iterate through all file-type detectors
		for (const detector of this.detectors) {
			const fileType = await detector.detect(tokenizer);
			if (fileType) {
				return fileType;
			}

			if (initialPosition !== tokenizer.position) {
				return undefined; // Cannot proceed scanning of the tokenizer is at an arbitrary position
			}
		}
	}

	async fromBuffer(input) {
		if (!(input instanceof Uint8Array || input instanceof ArrayBuffer)) {
			throw new TypeError(`Expected the \`input\` argument to be of type \`Uint8Array\` or \`ArrayBuffer\`, got \`${typeof input}\``);
		}

		const buffer = input instanceof Uint8Array ? input : new Uint8Array(input);

		if (!(buffer?.length > 1)) {
			return;
		}

		return this.fromTokenizer(fromBuffer$1(buffer, this.tokenizerOptions));
	}

	async fromBlob(blob) {
		const tokenizer = fromBlob(blob, this.tokenizerOptions);
		try {
			return await this.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async fromStream(stream) {
		const tokenizer = fromWebStream(stream, this.tokenizerOptions);
		try {
			return await this.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async toDetectionStream(stream, options) {
		const {sampleSize = reasonableDetectionSizeInBytes} = options;
		let detectedFileType;
		let firstChunk;

		const reader = stream.getReader({mode: 'byob'});
		try {
			// Read the first chunk from the stream
			const {value: chunk, done} = await reader.read(new Uint8Array(sampleSize));
			firstChunk = chunk;
			if (!done && chunk) {
				try {
					// Attempt to detect the file type from the chunk
					detectedFileType = await this.fromBuffer(chunk.subarray(0, sampleSize));
				} catch (error) {
					if (!(error instanceof EndOfStreamError)) {
						throw error; // Re-throw non-EndOfStreamError
					}

					detectedFileType = undefined;
				}
			}

			firstChunk = chunk;
		} finally {
			reader.releaseLock(); // Ensure the reader is released
		}

		// Create a new ReadableStream to manage locking issues
		const transformStream = new TransformStream({
			async start(controller) {
				controller.enqueue(firstChunk); // Enqueue the initial chunk
			},
			transform(chunk, controller) {
				// Pass through the chunks without modification
				controller.enqueue(chunk);
			},
		});

		const newStream = stream.pipeThrough(transformStream);
		newStream.fileType = detectedFileType;

		return newStream;
	}

	check(header, options) {
		return _check(this.buffer, header, options);
	}

	checkString(header, options) {
		return this.check(stringToBytes(header, options?.encoding), options);
	}

	// Detections with a high degree of certainty in identifying the correct file type
	detectConfident = async tokenizer => {
		this.buffer = new Uint8Array(reasonableDetectionSizeInBytes);

		// Keep reading until EOF if the file size is unknown.
		if (tokenizer.fileInfo.size === undefined) {
			tokenizer.fileInfo.size = Number.MAX_SAFE_INTEGER;
		}

		this.tokenizer = tokenizer;

		await tokenizer.peekBuffer(this.buffer, {length: 32, mayBeLess: true});

		// -- 2-byte signatures --

		if (this.check([0x42, 0x4D])) {
			return {
				ext: 'bmp',
				mime: 'image/bmp',
			};
		}

		if (this.check([0x0B, 0x77])) {
			return {
				ext: 'ac3',
				mime: 'audio/vnd.dolby.dd-raw',
			};
		}

		if (this.check([0x78, 0x01])) {
			return {
				ext: 'dmg',
				mime: 'application/x-apple-diskimage',
			};
		}

		if (this.check([0x4D, 0x5A])) {
			return {
				ext: 'exe',
				mime: 'application/x-msdownload',
			};
		}

		if (this.check([0x25, 0x21])) {
			await tokenizer.peekBuffer(this.buffer, {length: 24, mayBeLess: true});

			if (
				this.checkString('PS-Adobe-', {offset: 2})
				&& this.checkString(' EPSF-', {offset: 14})
			) {
				return {
					ext: 'eps',
					mime: 'application/eps',
				};
			}

			return {
				ext: 'ps',
				mime: 'application/postscript',
			};
		}

		if (
			this.check([0x1F, 0xA0])
			|| this.check([0x1F, 0x9D])
		) {
			return {
				ext: 'Z',
				mime: 'application/x-compress',
			};
		}

		if (this.check([0xC7, 0x71])) {
			return {
				ext: 'cpio',
				mime: 'application/x-cpio',
			};
		}

		if (this.check([0x60, 0xEA])) {
			return {
				ext: 'arj',
				mime: 'application/x-arj',
			};
		}

		// -- 3-byte signatures --

		if (this.check([0xEF, 0xBB, 0xBF])) { // UTF-8-BOM
			// Strip off UTF-8-BOM
			this.tokenizer.ignore(3);
			return this.detectConfident(tokenizer);
		}

		if (this.check([0x47, 0x49, 0x46])) {
			return {
				ext: 'gif',
				mime: 'image/gif',
			};
		}

		if (this.check([0x49, 0x49, 0xBC])) {
			return {
				ext: 'jxr',
				mime: 'image/vnd.ms-photo',
			};
		}

		if (this.check([0x1F, 0x8B, 0x8])) {
			const gzipHandler = new GzipHandler(tokenizer);

			const stream = gzipHandler.inflate();
			try {
				const compressedFileType = await this.fromStream(stream);
				if (compressedFileType && compressedFileType.ext === 'tar') {
					return {
						ext: 'tar.gz',
						mime: 'application/gzip',
					};
				}
			} finally {
				await stream.cancel();
			}

			return {
				ext: 'gz',
				mime: 'application/gzip',
			};
		}

		if (this.check([0x42, 0x5A, 0x68])) {
			return {
				ext: 'bz2',
				mime: 'application/x-bzip2',
			};
		}

		if (this.checkString('ID3')) {
			await tokenizer.ignore(6); // Skip ID3 header until the header size
			const id3HeaderLength = await tokenizer.readToken(uint32SyncSafeToken);
			if (tokenizer.position + id3HeaderLength > tokenizer.fileInfo.size) {
				// Guess file type based on ID3 header for backward compatibility
				return {
					ext: 'mp3',
					mime: 'audio/mpeg',
				};
			}

			await tokenizer.ignore(id3HeaderLength);
			return this.fromTokenizer(tokenizer); // Skip ID3 header, recursion
		}

		// Musepack, SV7
		if (this.checkString('MP+')) {
			return {
				ext: 'mpc',
				mime: 'audio/x-musepack',
			};
		}

		if (
			(this.buffer[0] === 0x43 || this.buffer[0] === 0x46)
			&& this.check([0x57, 0x53], {offset: 1})
		) {
			return {
				ext: 'swf',
				mime: 'application/x-shockwave-flash',
			};
		}

		// -- 4-byte signatures --

		// Requires a sample size of 4 bytes
		if (this.check([0xFF, 0xD8, 0xFF])) {
			if (this.check([0xF7], {offset: 3})) { // JPG7/SOF55, indicating a ISO/IEC 14495 / JPEG-LS file
				return {
					ext: 'jls',
					mime: 'image/jls',
				};
			}

			return {
				ext: 'jpg',
				mime: 'image/jpeg',
			};
		}

		if (this.check([0x4F, 0x62, 0x6A, 0x01])) {
			return {
				ext: 'avro',
				mime: 'application/avro',
			};
		}

		if (this.checkString('FLIF')) {
			return {
				ext: 'flif',
				mime: 'image/flif',
			};
		}

		if (this.checkString('8BPS')) {
			return {
				ext: 'psd',
				mime: 'image/vnd.adobe.photoshop',
			};
		}

		// Musepack, SV8
		if (this.checkString('MPCK')) {
			return {
				ext: 'mpc',
				mime: 'audio/x-musepack',
			};
		}

		if (this.checkString('FORM')) {
			return {
				ext: 'aif',
				mime: 'audio/aiff',
			};
		}

		if (this.checkString('icns', {offset: 0})) {
			return {
				ext: 'icns',
				mime: 'image/icns',
			};
		}

		// Zip-based file formats
		// Need to be before the `zip` check
		if (this.check([0x50, 0x4B, 0x3, 0x4])) { // Local file header signature
			let fileType;
			await new ZipHandler(tokenizer).unzip(zipHeader => {
				switch (zipHeader.filename) {
					case 'META-INF/mozilla.rsa':
						fileType = {
							ext: 'xpi',
							mime: 'application/x-xpinstall',
						};
						return {
							stop: true,
						};
					case 'META-INF/MANIFEST.MF':
						fileType = {
							ext: 'jar',
							mime: 'application/java-archive',
						};
						return {
							stop: true,
						};
					case 'mimetype':
						return {
							async handler(fileData) {
								// Use TextDecoder to decode the UTF-8 encoded data
								const mimeType = new TextDecoder('utf-8').decode(fileData).trim();
								fileType = getFileTypeFromMimeType(mimeType);
							},
							stop: true,
						};

					case '[Content_Types].xml':
						return {
							async handler(fileData) {
								// Use TextDecoder to decode the UTF-8 encoded data
								let xmlContent = new TextDecoder('utf-8').decode(fileData);
								const endPos = xmlContent.indexOf('.main+xml"');
								if (endPos === -1) {
									const mimeType = 'application/vnd.ms-package.3dmanufacturing-3dmodel+xml';
									if (xmlContent.includes(`ContentType="${mimeType}"`)) {
										fileType = getFileTypeFromMimeType(mimeType);
									}
								} else {
									xmlContent = xmlContent.slice(0, Math.max(0, endPos));
									const firstPos = xmlContent.lastIndexOf('"');
									const mimeType = xmlContent.slice(Math.max(0, firstPos + 1));
									fileType = getFileTypeFromMimeType(mimeType);
								}
							},
							stop: true,
						};
					default:
						if (/classes\d*\.dex/.test(zipHeader.filename)) {
							fileType = {
								ext: 'apk',
								mime: 'application/vnd.android.package-archive',
							};
							return {stop: true};
						}

						return {};
				}
			}).catch(error => {
				if (!(error instanceof EndOfStreamError)) {
					throw error; // Re-throw non-EndOfStreamError
				}
			});

			return fileType ?? {
				ext: 'zip',
				mime: 'application/zip',
			};
		}

		if (this.checkString('OggS')) {
			// This is an OGG container
			await tokenizer.ignore(28);
			const type = new Uint8Array(8);
			await tokenizer.readBuffer(type);

			// Needs to be before `ogg` check
			if (_check(type, [0x4F, 0x70, 0x75, 0x73, 0x48, 0x65, 0x61, 0x64])) {
				return {
					ext: 'opus',
					mime: 'audio/ogg; codecs=opus',
				};
			}

			// If ' theora' in header.
			if (_check(type, [0x80, 0x74, 0x68, 0x65, 0x6F, 0x72, 0x61])) {
				return {
					ext: 'ogv',
					mime: 'video/ogg',
				};
			}

			// If '\x01video' in header.
			if (_check(type, [0x01, 0x76, 0x69, 0x64, 0x65, 0x6F, 0x00])) {
				return {
					ext: 'ogm',
					mime: 'video/ogg',
				};
			}

			// If ' FLAC' in header  https://xiph.org/flac/faq.html
			if (_check(type, [0x7F, 0x46, 0x4C, 0x41, 0x43])) {
				return {
					ext: 'oga',
					mime: 'audio/ogg',
				};
			}

			// 'Speex  ' in header https://en.wikipedia.org/wiki/Speex
			if (_check(type, [0x53, 0x70, 0x65, 0x65, 0x78, 0x20, 0x20])) {
				return {
					ext: 'spx',
					mime: 'audio/ogg',
				};
			}

			// If '\x01vorbis' in header
			if (_check(type, [0x01, 0x76, 0x6F, 0x72, 0x62, 0x69, 0x73])) {
				return {
					ext: 'ogg',
					mime: 'audio/ogg',
				};
			}

			// Default OGG container https://www.iana.org/assignments/media-types/application/ogg
			return {
				ext: 'ogx',
				mime: 'application/ogg',
			};
		}

		if (
			this.check([0x50, 0x4B])
			&& (this.buffer[2] === 0x3 || this.buffer[2] === 0x5 || this.buffer[2] === 0x7)
			&& (this.buffer[3] === 0x4 || this.buffer[3] === 0x6 || this.buffer[3] === 0x8)
		) {
			return {
				ext: 'zip',
				mime: 'application/zip',
			};
		}

		if (this.checkString('MThd')) {
			return {
				ext: 'mid',
				mime: 'audio/midi',
			};
		}

		if (
			this.checkString('wOFF')
			&& (
				this.check([0x00, 0x01, 0x00, 0x00], {offset: 4})
				|| this.checkString('OTTO', {offset: 4})
			)
		) {
			return {
				ext: 'woff',
				mime: 'font/woff',
			};
		}

		if (
			this.checkString('wOF2')
			&& (
				this.check([0x00, 0x01, 0x00, 0x00], {offset: 4})
				|| this.checkString('OTTO', {offset: 4})
			)
		) {
			return {
				ext: 'woff2',
				mime: 'font/woff2',
			};
		}

		if (this.check([0xD4, 0xC3, 0xB2, 0xA1]) || this.check([0xA1, 0xB2, 0xC3, 0xD4])) {
			return {
				ext: 'pcap',
				mime: 'application/vnd.tcpdump.pcap',
			};
		}

		// Sony DSD Stream File (DSF)
		if (this.checkString('DSD ')) {
			return {
				ext: 'dsf',
				mime: 'audio/x-dsf', // Non-standard
			};
		}

		if (this.checkString('LZIP')) {
			return {
				ext: 'lz',
				mime: 'application/x-lzip',
			};
		}

		if (this.checkString('fLaC')) {
			return {
				ext: 'flac',
				mime: 'audio/flac',
			};
		}

		if (this.check([0x42, 0x50, 0x47, 0xFB])) {
			return {
				ext: 'bpg',
				mime: 'image/bpg',
			};
		}

		if (this.checkString('wvpk')) {
			return {
				ext: 'wv',
				mime: 'audio/wavpack',
			};
		}

		if (this.checkString('%PDF')) {
			// Assume this is just a normal PDF
			return {
				ext: 'pdf',
				mime: 'application/pdf',
			};
		}

		if (this.check([0x00, 0x61, 0x73, 0x6D])) {
			return {
				ext: 'wasm',
				mime: 'application/wasm',
			};
		}

		// TIFF, little-endian type
		if (this.check([0x49, 0x49])) {
			const fileType = await this.readTiffHeader(false);
			if (fileType) {
				return fileType;
			}
		}

		// TIFF, big-endian type
		if (this.check([0x4D, 0x4D])) {
			const fileType = await this.readTiffHeader(true);
			if (fileType) {
				return fileType;
			}
		}

		if (this.checkString('MAC ')) {
			return {
				ext: 'ape',
				mime: 'audio/ape',
			};
		}

		// https://github.com/file/file/blob/master/magic/Magdir/matroska
		if (this.check([0x1A, 0x45, 0xDF, 0xA3])) { // Root element: EBML
			async function readField() {
				const msb = await tokenizer.peekNumber(UINT8);
				let mask = 0x80;
				let ic = 0; // 0 = A, 1 = B, 2 = C, 3 = D

				while ((msb & mask) === 0 && mask !== 0) {
					++ic;
					mask >>= 1;
				}

				const id = new Uint8Array(ic + 1);
				await tokenizer.readBuffer(id);
				return id;
			}

			async function readElement() {
				const idField = await readField();
				const lengthField = await readField();

				lengthField[0] ^= 0x80 >> (lengthField.length - 1);
				const nrLength = Math.min(6, lengthField.length); // JavaScript can max read 6 bytes integer

				const idView = new DataView(idField.buffer);
				const lengthView = new DataView(lengthField.buffer, lengthField.length - nrLength, nrLength);

				return {
					id: getUintBE(idView),
					len: getUintBE(lengthView),
				};
			}

			async function readChildren(children) {
				while (children > 0) {
					const element = await readElement();
					if (element.id === 0x42_82) {
						const rawValue = await tokenizer.readToken(new StringType(element.len));
						return rawValue.replaceAll(/\00.*$/g, ''); // Return DocType
					}

					await tokenizer.ignore(element.len); // ignore payload
					--children;
				}
			}

			const re = await readElement();
			const documentType = await readChildren(re.len);

			switch (documentType) {
				case 'webm':
					return {
						ext: 'webm',
						mime: 'video/webm',
					};

				case 'matroska':
					return {
						ext: 'mkv',
						mime: 'video/matroska',
					};

				default:
					return;
			}
		}

		if (this.checkString('SQLi')) {
			return {
				ext: 'sqlite',
				mime: 'application/x-sqlite3',
			};
		}

		if (this.check([0x4E, 0x45, 0x53, 0x1A])) {
			return {
				ext: 'nes',
				mime: 'application/x-nintendo-nes-rom',
			};
		}

		if (this.checkString('Cr24')) {
			return {
				ext: 'crx',
				mime: 'application/x-google-chrome-extension',
			};
		}

		if (
			this.checkString('MSCF')
			|| this.checkString('ISc(')
		) {
			return {
				ext: 'cab',
				mime: 'application/vnd.ms-cab-compressed',
			};
		}

		if (this.check([0xED, 0xAB, 0xEE, 0xDB])) {
			return {
				ext: 'rpm',
				mime: 'application/x-rpm',
			};
		}

		if (this.check([0xC5, 0xD0, 0xD3, 0xC6])) {
			return {
				ext: 'eps',
				mime: 'application/eps',
			};
		}

		if (this.check([0x28, 0xB5, 0x2F, 0xFD])) {
			return {
				ext: 'zst',
				mime: 'application/zstd',
			};
		}

		if (this.check([0x7F, 0x45, 0x4C, 0x46])) {
			return {
				ext: 'elf',
				mime: 'application/x-elf',
			};
		}

		if (this.check([0x21, 0x42, 0x44, 0x4E])) {
			return {
				ext: 'pst',
				mime: 'application/vnd.ms-outlook',
			};
		}

		if (this.checkString('PAR1') || this.checkString('PARE')) {
			return {
				ext: 'parquet',
				mime: 'application/vnd.apache.parquet',
			};
		}

		if (this.checkString('ttcf')) {
			return {
				ext: 'ttc',
				mime: 'font/collection',
			};
		}

		if (this.check([0xCF, 0xFA, 0xED, 0xFE])) {
			return {
				ext: 'macho',
				mime: 'application/x-mach-binary',
			};
		}

		if (this.check([0x04, 0x22, 0x4D, 0x18])) {
			return {
				ext: 'lz4',
				mime: 'application/x-lz4', // Invented by us
			};
		}

		if (this.checkString('regf')) {
			return {
				ext: 'dat',
				mime: 'application/x-ft-windows-registry-hive',
			};
		}

		// -- 5-byte signatures --

		if (this.check([0x4F, 0x54, 0x54, 0x4F, 0x00])) {
			return {
				ext: 'otf',
				mime: 'font/otf',
			};
		}

		if (this.checkString('#!AMR')) {
			return {
				ext: 'amr',
				mime: 'audio/amr',
			};
		}

		if (this.checkString('{\\rtf')) {
			return {
				ext: 'rtf',
				mime: 'application/rtf',
			};
		}

		if (this.check([0x46, 0x4C, 0x56, 0x01])) {
			return {
				ext: 'flv',
				mime: 'video/x-flv',
			};
		}

		if (this.checkString('IMPM')) {
			return {
				ext: 'it',
				mime: 'audio/x-it',
			};
		}

		if (
			this.checkString('-lh0-', {offset: 2})
			|| this.checkString('-lh1-', {offset: 2})
			|| this.checkString('-lh2-', {offset: 2})
			|| this.checkString('-lh3-', {offset: 2})
			|| this.checkString('-lh4-', {offset: 2})
			|| this.checkString('-lh5-', {offset: 2})
			|| this.checkString('-lh6-', {offset: 2})
			|| this.checkString('-lh7-', {offset: 2})
			|| this.checkString('-lzs-', {offset: 2})
			|| this.checkString('-lz4-', {offset: 2})
			|| this.checkString('-lz5-', {offset: 2})
			|| this.checkString('-lhd-', {offset: 2})
		) {
			return {
				ext: 'lzh',
				mime: 'application/x-lzh-compressed',
			};
		}

		// MPEG program stream (PS or MPEG-PS)
		if (this.check([0x00, 0x00, 0x01, 0xBA])) {
			//  MPEG-PS, MPEG-1 Part 1
			if (this.check([0x21], {offset: 4, mask: [0xF1]})) {
				return {
					ext: 'mpg', // May also be .ps, .mpeg
					mime: 'video/MP1S',
				};
			}

			// MPEG-PS, MPEG-2 Part 1
			if (this.check([0x44], {offset: 4, mask: [0xC4]})) {
				return {
					ext: 'mpg', // May also be .mpg, .m2p, .vob or .sub
					mime: 'video/MP2P',
				};
			}
		}

		if (this.checkString('ITSF')) {
			return {
				ext: 'chm',
				mime: 'application/vnd.ms-htmlhelp',
			};
		}

		if (this.check([0xCA, 0xFE, 0xBA, 0xBE])) {
			return {
				ext: 'class',
				mime: 'application/java-vm',
			};
		}

		if (this.checkString('.RMF')) {
			return {
				ext: 'rm',
				mime: 'application/vnd.rn-realmedia',
			};
		}

		// -- 5-byte signatures --

		if (this.checkString('DRACO')) {
			return {
				ext: 'drc',
				mime: 'application/vnd.google.draco', // Invented by us
			};
		}

		// -- 6-byte signatures --

		if (this.check([0xFD, 0x37, 0x7A, 0x58, 0x5A, 0x00])) {
			return {
				ext: 'xz',
				mime: 'application/x-xz',
			};
		}

		if (this.checkString('<?xml ')) {
			return {
				ext: 'xml',
				mime: 'application/xml',
			};
		}

		if (this.check([0x37, 0x7A, 0xBC, 0xAF, 0x27, 0x1C])) {
			return {
				ext: '7z',
				mime: 'application/x-7z-compressed',
			};
		}

		if (
			this.check([0x52, 0x61, 0x72, 0x21, 0x1A, 0x7])
			&& (this.buffer[6] === 0x0 || this.buffer[6] === 0x1)
		) {
			return {
				ext: 'rar',
				mime: 'application/x-rar-compressed',
			};
		}

		if (this.checkString('solid ')) {
			return {
				ext: 'stl',
				mime: 'model/stl',
			};
		}

		if (this.checkString('AC')) {
			const version = new StringType(4, 'latin1').get(this.buffer, 2);
			if (version.match('^d*') && version >= 1000 && version <= 1050) {
				return {
					ext: 'dwg',
					mime: 'image/vnd.dwg',
				};
			}
		}

		if (this.checkString('070707')) {
			return {
				ext: 'cpio',
				mime: 'application/x-cpio',
			};
		}

		// -- 7-byte signatures --

		if (this.checkString('BLENDER')) {
			return {
				ext: 'blend',
				mime: 'application/x-blender',
			};
		}

		if (this.checkString('!<arch>')) {
			await tokenizer.ignore(8);
			const string = await tokenizer.readToken(new StringType(13, 'ascii'));
			if (string === 'debian-binary') {
				return {
					ext: 'deb',
					mime: 'application/x-deb',
				};
			}

			return {
				ext: 'ar',
				mime: 'application/x-unix-archive',
			};
		}

		if (
			this.checkString('WEBVTT')
			&&	(
				// One of LF, CR, tab, space, or end of file must follow "WEBVTT" per the spec (see `fixture/fixture-vtt-*.vtt` for examples). Note that `\0` is technically the null character (there is no such thing as an EOF character). However, checking for `\0` gives us the same result as checking for the end of the stream.
				(['\n', '\r', '\t', ' ', '\0'].some(char7 => this.checkString(char7, {offset: 6}))))
		) {
			return {
				ext: 'vtt',
				mime: 'text/vtt',
			};
		}

		// -- 8-byte signatures --

		if (this.check([0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A])) {
			// APNG format (https://wiki.mozilla.org/APNG_Specification)
			// 1. Find the first IDAT (image data) chunk (49 44 41 54)
			// 2. Check if there is an "acTL" chunk before the IDAT one (61 63 54 4C)

			// Offset calculated as follows:
			// - 8 bytes: PNG signature
			// - 4 (length) + 4 (chunk type) + 13 (chunk data) + 4 (CRC): IHDR chunk

			await tokenizer.ignore(8); // ignore PNG signature

			async function readChunkHeader() {
				return {
					length: await tokenizer.readToken(INT32_BE),
					type: await tokenizer.readToken(new StringType(4, 'latin1')),
				};
			}

			do {
				const chunk = await readChunkHeader();
				if (chunk.length < 0) {
					return; // Invalid chunk length
				}

				switch (chunk.type) {
					case 'IDAT':
						return {
							ext: 'png',
							mime: 'image/png',
						};
					case 'acTL':
						return {
							ext: 'apng',
							mime: 'image/apng',
						};
					default:
						await tokenizer.ignore(chunk.length + 4); // Ignore chunk-data + CRC
				}
			} while (tokenizer.position + 8 < tokenizer.fileInfo.size);

			return {
				ext: 'png',
				mime: 'image/png',
			};
		}

		if (this.check([0x41, 0x52, 0x52, 0x4F, 0x57, 0x31, 0x00, 0x00])) {
			return {
				ext: 'arrow',
				mime: 'application/vnd.apache.arrow.file',
			};
		}

		if (this.check([0x67, 0x6C, 0x54, 0x46, 0x02, 0x00, 0x00, 0x00])) {
			return {
				ext: 'glb',
				mime: 'model/gltf-binary',
			};
		}

		// `mov` format variants
		if (
			this.check([0x66, 0x72, 0x65, 0x65], {offset: 4}) // `free`
			|| this.check([0x6D, 0x64, 0x61, 0x74], {offset: 4}) // `mdat` MJPEG
			|| this.check([0x6D, 0x6F, 0x6F, 0x76], {offset: 4}) // `moov`
			|| this.check([0x77, 0x69, 0x64, 0x65], {offset: 4}) // `wide`
		) {
			return {
				ext: 'mov',
				mime: 'video/quicktime',
			};
		}

		// -- 9-byte signatures --

		if (this.check([0x49, 0x49, 0x52, 0x4F, 0x08, 0x00, 0x00, 0x00, 0x18])) {
			return {
				ext: 'orf',
				mime: 'image/x-olympus-orf',
			};
		}

		if (this.checkString('gimp xcf ')) {
			return {
				ext: 'xcf',
				mime: 'image/x-xcf',
			};
		}

		// File Type Box (https://en.wikipedia.org/wiki/ISO_base_media_file_format)
		// It's not required to be first, but it's recommended to be. Almost all ISO base media files start with `ftyp` box.
		// `ftyp` box must contain a brand major identifier, which must consist of ISO 8859-1 printable characters.
		// Here we check for 8859-1 printable characters (for simplicity, it's a mask which also catches one non-printable character).
		if (
			this.checkString('ftyp', {offset: 4})
			&& (this.buffer[8] & 0x60) !== 0x00 // Brand major, first character ASCII?
		) {
			// They all can have MIME `video/mp4` except `application/mp4` special-case which is hard to detect.
			// For some cases, we're specific, everything else falls to `video/mp4` with `mp4` extension.
			const brandMajor = new StringType(4, 'latin1').get(this.buffer, 8).replace('\0', ' ').trim();
			switch (brandMajor) {
				case 'avif':
				case 'avis':
					return {ext: 'avif', mime: 'image/avif'};
				case 'mif1':
					return {ext: 'heic', mime: 'image/heif'};
				case 'msf1':
					return {ext: 'heic', mime: 'image/heif-sequence'};
				case 'heic':
				case 'heix':
					return {ext: 'heic', mime: 'image/heic'};
				case 'hevc':
				case 'hevx':
					return {ext: 'heic', mime: 'image/heic-sequence'};
				case 'qt':
					return {ext: 'mov', mime: 'video/quicktime'};
				case 'M4V':
				case 'M4VH':
				case 'M4VP':
					return {ext: 'm4v', mime: 'video/x-m4v'};
				case 'M4P':
					return {ext: 'm4p', mime: 'video/mp4'};
				case 'M4B':
					return {ext: 'm4b', mime: 'audio/mp4'};
				case 'M4A':
					return {ext: 'm4a', mime: 'audio/x-m4a'};
				case 'F4V':
					return {ext: 'f4v', mime: 'video/mp4'};
				case 'F4P':
					return {ext: 'f4p', mime: 'video/mp4'};
				case 'F4A':
					return {ext: 'f4a', mime: 'audio/mp4'};
				case 'F4B':
					return {ext: 'f4b', mime: 'audio/mp4'};
				case 'crx':
					return {ext: 'cr3', mime: 'image/x-canon-cr3'};
				default:
					if (brandMajor.startsWith('3g')) {
						if (brandMajor.startsWith('3g2')) {
							return {ext: '3g2', mime: 'video/3gpp2'};
						}

						return {ext: '3gp', mime: 'video/3gpp'};
					}

					return {ext: 'mp4', mime: 'video/mp4'};
			}
		}

		// -- 10-byte signatures --

		if (this.checkString('REGEDIT4\r\n')) {
			return {
				ext: 'reg',
				mime: 'application/x-ms-regedit',
			};
		}

		// -- 12-byte signatures --

		// RIFF file format which might be AVI, WAV, QCP, etc
		if (this.check([0x52, 0x49, 0x46, 0x46])) {
			if (this.checkString('WEBP', {offset: 8})) {
				return {
					ext: 'webp',
					mime: 'image/webp',
				};
			}

			if (this.check([0x41, 0x56, 0x49], {offset: 8})) {
				return {
					ext: 'avi',
					mime: 'video/vnd.avi',
				};
			}

			if (this.check([0x57, 0x41, 0x56, 0x45], {offset: 8})) {
				return {
					ext: 'wav',
					mime: 'audio/wav',
				};
			}

			// QLCM, QCP file
			if (this.check([0x51, 0x4C, 0x43, 0x4D], {offset: 8})) {
				return {
					ext: 'qcp',
					mime: 'audio/qcelp',
				};
			}
		}

		if (this.check([0x49, 0x49, 0x55, 0x00, 0x18, 0x00, 0x00, 0x00, 0x88, 0xE7, 0x74, 0xD8])) {
			return {
				ext: 'rw2',
				mime: 'image/x-panasonic-rw2',
			};
		}

		// ASF_Header_Object first 80 bytes
		if (this.check([0x30, 0x26, 0xB2, 0x75, 0x8E, 0x66, 0xCF, 0x11, 0xA6, 0xD9])) {
			async function readHeader() {
				const guid = new Uint8Array(16);
				await tokenizer.readBuffer(guid);
				return {
					id: guid,
					size: Number(await tokenizer.readToken(UINT64_LE)),
				};
			}

			await tokenizer.ignore(30);
			// Search for header should be in first 1KB of file.
			while (tokenizer.position + 24 < tokenizer.fileInfo.size) {
				const header = await readHeader();
				let payload = header.size - 24;
				if (_check(header.id, [0x91, 0x07, 0xDC, 0xB7, 0xB7, 0xA9, 0xCF, 0x11, 0x8E, 0xE6, 0x00, 0xC0, 0x0C, 0x20, 0x53, 0x65])) {
					// Sync on Stream-Properties-Object (B7DC0791-A9B7-11CF-8EE6-00C00C205365)
					const typeId = new Uint8Array(16);
					payload -= await tokenizer.readBuffer(typeId);

					if (_check(typeId, [0x40, 0x9E, 0x69, 0xF8, 0x4D, 0x5B, 0xCF, 0x11, 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B])) {
						// Found audio:
						return {
							ext: 'asf',
							mime: 'audio/x-ms-asf',
						};
					}

					if (_check(typeId, [0xC0, 0xEF, 0x19, 0xBC, 0x4D, 0x5B, 0xCF, 0x11, 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B])) {
						// Found video:
						return {
							ext: 'asf',
							mime: 'video/x-ms-asf',
						};
					}

					break;
				}

				await tokenizer.ignore(payload);
			}

			// Default to ASF generic extension
			return {
				ext: 'asf',
				mime: 'application/vnd.ms-asf',
			};
		}

		if (this.check([0xAB, 0x4B, 0x54, 0x58, 0x20, 0x31, 0x31, 0xBB, 0x0D, 0x0A, 0x1A, 0x0A])) {
			return {
				ext: 'ktx',
				mime: 'image/ktx',
			};
		}

		if ((this.check([0x7E, 0x10, 0x04]) || this.check([0x7E, 0x18, 0x04])) && this.check([0x30, 0x4D, 0x49, 0x45], {offset: 4})) {
			return {
				ext: 'mie',
				mime: 'application/x-mie',
			};
		}

		if (this.check([0x27, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], {offset: 2})) {
			return {
				ext: 'shp',
				mime: 'application/x-esri-shape',
			};
		}

		if (this.check([0xFF, 0x4F, 0xFF, 0x51])) {
			return {
				ext: 'j2c',
				mime: 'image/j2c',
			};
		}

		if (this.check([0x00, 0x00, 0x00, 0x0C, 0x6A, 0x50, 0x20, 0x20, 0x0D, 0x0A, 0x87, 0x0A])) {
			// JPEG-2000 family

			await tokenizer.ignore(20);
			const type = await tokenizer.readToken(new StringType(4, 'ascii'));
			switch (type) {
				case 'jp2 ':
					return {
						ext: 'jp2',
						mime: 'image/jp2',
					};
				case 'jpx ':
					return {
						ext: 'jpx',
						mime: 'image/jpx',
					};
				case 'jpm ':
					return {
						ext: 'jpm',
						mime: 'image/jpm',
					};
				case 'mjp2':
					return {
						ext: 'mj2',
						mime: 'image/mj2',
					};
				default:
					return;
			}
		}

		if (
			this.check([0xFF, 0x0A])
			|| this.check([0x00, 0x00, 0x00, 0x0C, 0x4A, 0x58, 0x4C, 0x20, 0x0D, 0x0A, 0x87, 0x0A])
		) {
			return {
				ext: 'jxl',
				mime: 'image/jxl',
			};
		}

		if (this.check([0xFE, 0xFF])) { // UTF-16-BOM-BE
			if (this.checkString('<?xml ', {offset: 2, encoding: 'utf-16be'})) {
				return {
					ext: 'xml',
					mime: 'application/xml',
				};
			}

			return undefined; // Some unknown text based format
		}

		if (this.check([0xD0, 0xCF, 0x11, 0xE0, 0xA1, 0xB1, 0x1A, 0xE1])) {
			// Detected Microsoft Compound File Binary File (MS-CFB) Format.
			return {
				ext: 'cfb',
				mime: 'application/x-cfb',
			};
		}

		// Increase sample size from 32 to 256.
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(256, tokenizer.fileInfo.size), mayBeLess: true});

		if (this.check([0x61, 0x63, 0x73, 0x70], {offset: 36})) {
			return {
				ext: 'icc',
				mime: 'application/vnd.iccprofile',
			};
		}

		// ACE: requires 14 bytes in the buffer
		if (this.checkString('**ACE', {offset: 7}) && this.checkString('**', {offset: 12})) {
			return {
				ext: 'ace',
				mime: 'application/x-ace-compressed',
			};
		}

		// -- 15-byte signatures --

		if (this.checkString('BEGIN:')) {
			if (this.checkString('VCARD', {offset: 6})) {
				return {
					ext: 'vcf',
					mime: 'text/vcard',
				};
			}

			if (this.checkString('VCALENDAR', {offset: 6})) {
				return {
					ext: 'ics',
					mime: 'text/calendar',
				};
			}
		}

		// `raf` is here just to keep all the raw image detectors together.
		if (this.checkString('FUJIFILMCCD-RAW')) {
			return {
				ext: 'raf',
				mime: 'image/x-fujifilm-raf',
			};
		}

		if (this.checkString('Extended Module:')) {
			return {
				ext: 'xm',
				mime: 'audio/x-xm',
			};
		}

		if (this.checkString('Creative Voice File')) {
			return {
				ext: 'voc',
				mime: 'audio/x-voc',
			};
		}

		if (this.check([0x04, 0x00, 0x00, 0x00]) && this.buffer.length >= 16) { // Rough & quick check Pickle/ASAR
			const jsonSize = new DataView(this.buffer.buffer).getUint32(12, true);

			if (jsonSize > 12 && this.buffer.length >= jsonSize + 16) {
				try {
					const header = new TextDecoder().decode(this.buffer.subarray(16, jsonSize + 16));
					const json = JSON.parse(header);
					// Check if Pickle is ASAR
					if (json.files) { // Final check, assuring Pickle/ASAR format
						return {
							ext: 'asar',
							mime: 'application/x-asar',
						};
					}
				} catch {}
			}
		}

		if (this.check([0x06, 0x0E, 0x2B, 0x34, 0x02, 0x05, 0x01, 0x01, 0x0D, 0x01, 0x02, 0x01, 0x01, 0x02])) {
			return {
				ext: 'mxf',
				mime: 'application/mxf',
			};
		}

		if (this.checkString('SCRM', {offset: 44})) {
			return {
				ext: 's3m',
				mime: 'audio/x-s3m',
			};
		}

		// Raw MPEG-2 transport stream (188-byte packets)
		if (this.check([0x47]) && this.check([0x47], {offset: 188})) {
			return {
				ext: 'mts',
				mime: 'video/mp2t',
			};
		}

		// Blu-ray Disc Audio-Video (BDAV) MPEG-2 transport stream has 4-byte TP_extra_header before each 188-byte packet
		if (this.check([0x47], {offset: 4}) && this.check([0x47], {offset: 196})) {
			return {
				ext: 'mts',
				mime: 'video/mp2t',
			};
		}

		if (this.check([0x42, 0x4F, 0x4F, 0x4B, 0x4D, 0x4F, 0x42, 0x49], {offset: 60})) {
			return {
				ext: 'mobi',
				mime: 'application/x-mobipocket-ebook',
			};
		}

		if (this.check([0x44, 0x49, 0x43, 0x4D], {offset: 128})) {
			return {
				ext: 'dcm',
				mime: 'application/dicom',
			};
		}

		if (this.check([0x4C, 0x00, 0x00, 0x00, 0x01, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46])) {
			return {
				ext: 'lnk',
				mime: 'application/x.ms.shortcut', // Invented by us
			};
		}

		if (this.check([0x62, 0x6F, 0x6F, 0x6B, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x61, 0x72, 0x6B, 0x00, 0x00, 0x00, 0x00])) {
			return {
				ext: 'alias',
				mime: 'application/x.apple.alias', // Invented by us
			};
		}

		if (this.checkString('Kaydara FBX Binary  \u0000')) {
			return {
				ext: 'fbx',
				mime: 'application/x.autodesk.fbx', // Invented by us
			};
		}

		if (
			this.check([0x4C, 0x50], {offset: 34})
			&& (
				this.check([0x00, 0x00, 0x01], {offset: 8})
				|| this.check([0x01, 0x00, 0x02], {offset: 8})
				|| this.check([0x02, 0x00, 0x02], {offset: 8})
			)
		) {
			return {
				ext: 'eot',
				mime: 'application/vnd.ms-fontobject',
			};
		}

		if (this.check([0x06, 0x06, 0xED, 0xF5, 0xD8, 0x1D, 0x46, 0xE5, 0xBD, 0x31, 0xEF, 0xE7, 0xFE, 0x74, 0xB7, 0x1D])) {
			return {
				ext: 'indd',
				mime: 'application/x-indesign',
			};
		}

		// Increase sample size from 256 to 512
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(512, tokenizer.fileInfo.size), mayBeLess: true});

		// Requires a buffer size of 512 bytes
		if ((this.checkString('ustar', {offset: 257}) && (this.checkString('\0', {offset: 262}) || this.checkString(' ', {offset: 262})))
			|| (this.check([0, 0, 0, 0, 0, 0], {offset: 257}) && tarHeaderChecksumMatches(this.buffer))) {
			return {
				ext: 'tar',
				mime: 'application/x-tar',
			};
		}

		if (this.check([0xFF, 0xFE])) { // UTF-16-BOM-LE
			const encoding = 'utf-16le';
			if (this.checkString('<?xml ', {offset: 2, encoding})) {
				return {
					ext: 'xml',
					mime: 'application/xml',
				};
			}

			if (this.check([0xFF, 0x0E], {offset: 2}) && this.checkString('SketchUp Model', {offset: 4, encoding})) {
				return {
					ext: 'skp',
					mime: 'application/vnd.sketchup.skp',
				};
			}

			if (this.checkString('Windows Registry Editor Version 5.00\r\n', {offset: 2, encoding})) {
				return {
					ext: 'reg',
					mime: 'application/x-ms-regedit',
				};
			}

			return undefined; // Some text based format
		}

		if (this.checkString('-----BEGIN PGP MESSAGE-----')) {
			return {
				ext: 'pgp',
				mime: 'application/pgp-encrypted',
			};
		}
	};
	// Detections with limited supporting data, resulting in a higher likelihood of false positives
	detectImprecise = async tokenizer => {
		this.buffer = new Uint8Array(reasonableDetectionSizeInBytes);

		// Read initial sample size of 8 bytes
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(8, tokenizer.fileInfo.size), mayBeLess: true});

		if (
			this.check([0x0, 0x0, 0x1, 0xBA])
			|| this.check([0x0, 0x0, 0x1, 0xB3])
		) {
			return {
				ext: 'mpg',
				mime: 'video/mpeg',
			};
		}

		if (this.check([0x00, 0x01, 0x00, 0x00, 0x00])) {
			return {
				ext: 'ttf',
				mime: 'font/ttf',
			};
		}

		if (this.check([0x00, 0x00, 0x01, 0x00])) {
			return {
				ext: 'ico',
				mime: 'image/x-icon',
			};
		}

		if (this.check([0x00, 0x00, 0x02, 0x00])) {
			return {
				ext: 'cur',
				mime: 'image/x-icon',
			};
		}

		// Adjust buffer to `mpegOffsetTolerance`
		await tokenizer.peekBuffer(this.buffer, {length: Math.min(2 + this.options.mpegOffsetTolerance, tokenizer.fileInfo.size), mayBeLess: true});

		// Check MPEG 1 or 2 Layer 3 header, or 'layer 0' for ADTS (MPEG sync-word 0xFFE)
		if (this.buffer.length >= (2 + this.options.mpegOffsetTolerance)) {
			for (let depth = 0; depth <= this.options.mpegOffsetTolerance; ++depth) {
				const type = this.scanMpeg(depth);
				if (type) {
					return type;
				}
			}
		}
	};

	async readTiffTag(bigEndian) {
		const tagId = await this.tokenizer.readToken(bigEndian ? UINT16_BE : UINT16_LE);
		this.tokenizer.ignore(10);
		switch (tagId) {
			case 50_341:
				return {
					ext: 'arw',
					mime: 'image/x-sony-arw',
				};
			case 50_706:
				return {
					ext: 'dng',
					mime: 'image/x-adobe-dng',
				};
		}
	}

	async readTiffIFD(bigEndian) {
		const numberOfTags = await this.tokenizer.readToken(bigEndian ? UINT16_BE : UINT16_LE);
		for (let n = 0; n < numberOfTags; ++n) {
			const fileType = await this.readTiffTag(bigEndian);
			if (fileType) {
				return fileType;
			}
		}
	}

	async readTiffHeader(bigEndian) {
		const version = (bigEndian ? UINT16_BE : UINT16_LE).get(this.buffer, 2);
		const ifdOffset = (bigEndian ? UINT32_BE : UINT32_LE).get(this.buffer, 4);

		if (version === 42) {
			// TIFF file header
			if (ifdOffset >= 6) {
				if (this.checkString('CR', {offset: 8})) {
					return {
						ext: 'cr2',
						mime: 'image/x-canon-cr2',
					};
				}

				if (ifdOffset >= 8) {
					const someId1 = (bigEndian ? UINT16_BE : UINT16_LE).get(this.buffer, 8);
					const someId2 = (bigEndian ? UINT16_BE : UINT16_LE).get(this.buffer, 10);

					if (
						(someId1 === 0x1C && someId2 === 0xFE)
						|| (someId1 === 0x1F && someId2 === 0x0B)) {
						return {
							ext: 'nef',
							mime: 'image/x-nikon-nef',
						};
					}
				}
			}

			await this.tokenizer.ignore(ifdOffset);
			const fileType = await this.readTiffIFD(bigEndian);
			return fileType ?? {
				ext: 'tif',
				mime: 'image/tiff',
			};
		}

		if (version === 43) {	// Big TIFF file header
			return {
				ext: 'tif',
				mime: 'image/tiff',
			};
		}
	}

	/**
	Scan check MPEG 1 or 2 Layer 3 header, or 'layer 0' for ADTS (MPEG sync-word 0xFFE).

	@param offset - Offset to scan for sync-preamble.
	@returns {{ext: string, mime: string}}
	*/
	scanMpeg(offset) {
		if (this.check([0xFF, 0xE0], {offset, mask: [0xFF, 0xE0]})) {
			if (this.check([0x10], {offset: offset + 1, mask: [0x16]})) {
				// Check for (ADTS) MPEG-2
				if (this.check([0x08], {offset: offset + 1, mask: [0x08]})) {
					return {
						ext: 'aac',
						mime: 'audio/aac',
					};
				}

				// Must be (ADTS) MPEG-4
				return {
					ext: 'aac',
					mime: 'audio/aac',
				};
			}

			// MPEG 1 or 2 Layer 3 header
			// Check for MPEG layer 3
			if (this.check([0x02], {offset: offset + 1, mask: [0x06]})) {
				return {
					ext: 'mp3',
					mime: 'audio/mpeg',
				};
			}

			// Check for MPEG layer 2
			if (this.check([0x04], {offset: offset + 1, mask: [0x06]})) {
				return {
					ext: 'mp2',
					mime: 'audio/mpeg',
				};
			}

			// Check for MPEG layer 1
			if (this.check([0x06], {offset: offset + 1, mask: [0x06]})) {
				return {
					ext: 'mp1',
					mime: 'audio/mpeg',
				};
			}
		}
	}
};

new Set(extensions);
new Set(mimeTypes$1);

/**
Node.js specific entry point.
*/


class FileTypeParser extends FileTypeParser$1 {
	async fromStream(stream) {
		const tokenizer = await (stream instanceof ReadableStream$1 ? fromWebStream(stream, this.tokenizerOptions) : fromStream(stream, this.tokenizerOptions));
		try {
			return await super.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async fromFile(path) {
		const tokenizer = await fromFile(path);
		try {
			return await super.fromTokenizer(tokenizer);
		} finally {
			await tokenizer.close();
		}
	}

	async toDetectionStream(readableStream, options = {}) {
		if (!(readableStream instanceof Readable)) {
			return super.toDetectionStream(readableStream, options);
		}

		const {sampleSize = reasonableDetectionSizeInBytes} = options;

		return new Promise((resolve, reject) => {
			readableStream.on('error', reject);

			readableStream.once('readable', () => {
				(async () => {
					try {
						// Set up output stream
						const pass = new PassThrough();
						const outputStream = pipeline ? pipeline(readableStream, pass, () => {}) : readableStream.pipe(pass);

						// Read the input stream and detect the filetype
						const chunk = readableStream.read(sampleSize) ?? readableStream.read() ?? new Uint8Array(0);
						try {
							pass.fileType = await this.fromBuffer(chunk);
						} catch (error) {
							if (error instanceof EndOfStreamError) {
								pass.fileType = undefined;
							} else {
								reject(error);
							}
						}

						resolve(outputStream);
					} catch (error) {
						reject(error);
					}
				})();
			});
		});
	}
}

async function fileTypeFromFile(path, options) {
	return (new FileTypeParser(options)).fromFile(path, options);
}

class RequestUtil {
  // 适用于获取服务器下发cookies时获取，仅GET
  static async HttpsGetCookies(url) {
    const client = url.startsWith("https") ? https$1 : http;
    return new Promise((resolve, reject) => {
      const req = client.get(url, (res) => {
        const cookies = {};
        res.on("data", () => {
        });
        res.on("end", () => {
          this.handleRedirect(res, url, cookies).then(resolve).catch(reject);
        });
        if (res.headers["set-cookie"]) {
          this.extractCookies(res.headers["set-cookie"], cookies);
        }
      });
      req.on("error", (error) => {
        reject(error);
      });
    });
  }
  static async handleRedirect(res, url, cookies) {
    if (res.statusCode === 301 || res.statusCode === 302) {
      if (res.headers.location) {
        const redirectUrl = new URL(res.headers.location, url);
        const redirectCookies = await this.HttpsGetCookies(redirectUrl.href);
        return { ...cookies, ...redirectCookies };
      }
    }
    return cookies;
  }
  static extractCookies(setCookieHeaders, cookies) {
    setCookieHeaders.forEach((cookie) => {
      const parts = cookie.split(";")[0]?.split("=");
      if (parts) {
        const key = parts[0];
        const value = parts[1];
        if (key && value && key.length > 0 && value.length > 0) {
          cookies[key] = value;
        }
      }
    });
  }
  // 请求和回复都是JSON data传原始内容 自动编码json
  static async HttpGetJson(url, method = "GET", data, headers = {}, isJsonRet = true, isArgJson = true) {
    const option = new URL(url);
    const protocol = url.startsWith("https://") ? https$1 : http;
    const options = {
      hostname: option.hostname,
      port: option.port,
      path: option.pathname + option.search,
      method,
      headers
    };
    return new Promise((resolve, reject) => {
      const req = protocol.request(options, (res) => {
        let responseBody = "";
        res.on("data", (chunk) => {
          responseBody += chunk.toString();
        });
        res.on("end", () => {
          try {
            if (res.statusCode && res.statusCode >= 200 && res.statusCode < 300) {
              if (isJsonRet) {
                const responseJson = JSON.parse(responseBody);
                resolve(responseJson);
              } else {
                resolve(responseBody);
              }
            } else {
              reject(new Error(`Unexpected status code: ${res.statusCode}`));
            }
          } catch (parseError) {
            reject(new Error(parseError.message));
          }
        });
      });
      req.on("error", (error) => {
        reject(error);
      });
      if (method === "POST" || method === "PUT" || method === "PATCH") {
        if (isArgJson) {
          req.write(JSON.stringify(data));
        } else {
          req.write(data);
        }
      }
      req.end();
    });
  }
  // 请求返回都是原始内容
  static async HttpGetText(url, method = "GET", data, headers = {}) {
    return this.HttpGetJson(url, method, data, headers, false, false);
  }
}

class RkeyManager {
  serverUrl = [];
  logger;
  rkeyData = {
    group_rkey: "",
    private_rkey: "",
    expired_time: 0
  };
  urlFailures = /* @__PURE__ */ new Map();
  FAILURE_LIMIT = 4;
  ONE_DAY = 24 * 60 * 60 * 1e3;
  constructor(serverUrl, logger) {
    this.logger = logger;
    this.serverUrl = serverUrl;
  }
  async getRkey() {
    const availableUrls = this.getAvailableUrls();
    if (availableUrls.length === 0) {
      this.logger.logError("[Rkey] 所有服务均已禁用, 图片使用FallBack机制");
      throw new Error("获取rkey失败：所有服务URL均已被禁用");
    }
    if (this.isExpired()) {
      try {
        await this.refreshRkey();
      } catch (e) {
        throw new Error(`${e}`);
      }
    }
    return this.rkeyData;
  }
  getAvailableUrls() {
    return this.serverUrl.filter((url) => !this.isUrlDisabled(url));
  }
  isUrlDisabled(url) {
    const failureInfo = this.urlFailures.get(url);
    if (!failureInfo) return false;
    const now = (/* @__PURE__ */ new Date()).getTime();
    if (now - failureInfo.lastTimestamp > this.ONE_DAY) {
      failureInfo.count = 0;
      this.urlFailures.set(url, failureInfo);
      return false;
    }
    return failureInfo.count >= this.FAILURE_LIMIT;
  }
  updateUrlFailure(url) {
    const now = (/* @__PURE__ */ new Date()).getTime();
    const failureInfo = this.urlFailures.get(url) || { count: 0, lastTimestamp: 0 };
    if (now - failureInfo.lastTimestamp > this.ONE_DAY) {
      failureInfo.count = 1;
    } else {
      failureInfo.count++;
    }
    failureInfo.lastTimestamp = now;
    this.urlFailures.set(url, failureInfo);
    if (failureInfo.count >= this.FAILURE_LIMIT) {
      this.logger.logError(`[Rkey] URL ${url} 已被禁用，失败次数达到 ${this.FAILURE_LIMIT} 次`);
    }
  }
  isExpired() {
    const now = (/* @__PURE__ */ new Date()).getTime() / 1e3;
    return now > this.rkeyData.expired_time;
  }
  async refreshRkey() {
    const availableUrls = this.getAvailableUrls();
    if (availableUrls.length === 0) {
      this.logger.logError("[Rkey] 所有服务均已禁用");
      throw new Error("获取rkey失败：所有服务URL均已被禁用");
    }
    for (const url of availableUrls) {
      try {
        let temp = await RequestUtil.HttpGetJson(url, "GET");
        if ("retcode" in temp) {
          temp = temp.data;
        }
        this.rkeyData = {
          group_rkey: temp.group_rkey.slice(6),
          private_rkey: temp.private_rkey.slice(6),
          expired_time: temp.expired_time
        };
        return;
      } catch (e) {
        this.logger.logError(`[Rkey] 异常服务 ${url} 异常 / `, e);
        this.updateUrlFailure(url);
        if (url === availableUrls[availableUrls.length - 1]) {
          throw new Error(`获取rkey失败: ${e}`);
        }
      }
    }
  }
}

async function solveProblem(func, ...args) {
  return new Promise((resolve) => {
    try {
      const result = func(...args);
      resolve(result);
    } catch {
      resolve(void 0);
    }
  });
}
async function solveAsyncProblem(func, ...args) {
  return new Promise((resolve) => {
    func(...args).then((result) => {
      resolve(result);
    }).catch(() => {
      resolve(void 0);
    });
  });
}
function sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
function PromiseTimer(promise, ms) {
  const timeoutPromise = new Promise(
    (_resolve, reject) => setTimeout(() => reject(new Error("PromiseTimer: Operation timed out")), ms)
  );
  return Promise.race([promise, timeoutPromise]);
}
function isNull(value) {
  return value === void 0 || value === null;
}
function isNumeric(str) {
  return /^\d+$/.test(str);
}
function truncateString(obj, maxLength = 500) {
  if (obj !== null && typeof obj === "object") {
    Object.keys(obj).forEach((key) => {
      if (typeof obj[key] === "string") {
        if (obj[key].length > maxLength) {
          obj[key] = obj[key].substring(0, maxLength) + "...";
        }
      } else if (typeof obj[key] === "object") {
        truncateString(obj[key], maxLength);
      }
    });
  }
  return obj;
}
function getDefaultQQVersionConfigInfo() {
  if (os$1.platform() === "linux") {
    return {
      baseVersion: "3.2.12.28060",
      curVersion: "3.2.12.28060",
      prevVersion: "",
      onErrorVersions: [],
      buildId: "27254"
    };
  }
  if (os$1.platform() === "darwin") {
    return {
      baseVersion: "6.9.53.28060",
      curVersion: "6.9.53.28060",
      prevVersion: "",
      onErrorVersions: [],
      buildId: "28060"
    };
  }
  return {
    baseVersion: "9.9.15-28131",
    curVersion: "9.9.15-28131",
    prevVersion: "",
    onErrorVersions: [],
    buildId: "28131"
  };
}
function getQQPackageInfoPath(exePath = "", version) {
  if (process.env["NAPCAT_QQ_PACKAGE_INFO_PATH"]) {
    return process.env["NAPCAT_QQ_PACKAGE_INFO_PATH"];
  }
  let packagePath;
  if (os$1.platform() === "darwin") {
    packagePath = path$1.join(path$1.dirname(exePath), "..", "Resources", "app", "package.json");
  } else if (os$1.platform() === "linux") {
    packagePath = path$1.join(path$1.dirname(exePath), "./resources/app/package.json");
  } else {
    packagePath = path$1.join(path$1.dirname(exePath), "./versions/" + version + "/resources/app/package.json");
  }
  if (!fs__default.existsSync(packagePath)) {
    packagePath = path$1.join(path$1.dirname(exePath), "./resources/app/versions/" + version + "/package.json");
  }
  return packagePath;
}
function getQQVersionConfigPath(exePath = "") {
  if (process.env["NAPCAT_QQ_VERSION_CONFIG_PATH"]) {
    return process.env["NAPCAT_QQ_VERSION_CONFIG_PATH"];
  }
  let configVersionInfoPath;
  if (os$1.platform() === "win32") {
    configVersionInfoPath = path$1.join(path$1.dirname(exePath), "versions", "config.json");
  } else if (os$1.platform() === "darwin") {
    const userPath = os$1.homedir();
    const appDataPath = path$1.resolve(userPath, "./Library/Application Support/QQ");
    configVersionInfoPath = path$1.resolve(appDataPath, "./versions/config.json");
  } else {
    const userPath = os$1.homedir();
    const appDataPath = path$1.resolve(userPath, "./.config/QQ");
    configVersionInfoPath = path$1.resolve(appDataPath, "./versions/config.json");
  }
  if (typeof configVersionInfoPath !== "string") {
    return void 0;
  }
  if (!fs__default.existsSync(configVersionInfoPath)) {
    configVersionInfoPath = path$1.join(path$1.dirname(exePath), "./resources/app/versions/config.json");
  }
  if (!fs__default.existsSync(configVersionInfoPath)) {
    return void 0;
  }
  return configVersionInfoPath;
}
function calcQQLevel(level) {
  if (!level) return 0;
  const { crownNum, sunNum, moonNum, starNum } = level;
  return crownNum * 64 + sunNum * 16 + moonNum * 4 + starNum;
}
function stringifyWithBigInt(obj) {
  return JSON.stringify(
    obj,
    (_key, value) => typeof value === "bigint" ? value.toString() : value
  );
}
function parseAppidFromMajor(nodeMajor) {
  const hexSequence = "A4 09 00 00 00 35";
  const sequenceBytes = Buffer.from(hexSequence.replace(/ /g, ""), "hex");
  const filePath = path$1.resolve(nodeMajor);
  const fileContent = fs__default.readFileSync(filePath);
  let searchPosition = 0;
  while (true) {
    const index = fileContent.indexOf(sequenceBytes, searchPosition);
    if (index === -1) {
      break;
    }
    const start = index + sequenceBytes.length - 1;
    const end = fileContent.indexOf(0, start);
    if (end === -1) {
      break;
    }
    const content = fileContent.subarray(start, end);
    if (!content.every((byte) => byte === 0)) {
      try {
        return content.toString("utf-8");
      } catch {
        break;
      }
    }
    searchPosition = end + 1;
  }
  return void 0;
}
const baseUrl = "https://github.com/NapNeko/NapCatQQ.git/info/refs?service=git-upload-pack";
const urls$1 = [
  "https://j.1win.ggff.net/" + baseUrl,
  "https://git.yylx.win/" + baseUrl,
  "https://ghfile.geekertao.top/" + baseUrl,
  "https://gh-proxy.net/" + baseUrl,
  "https://ghm.078465.xyz/" + baseUrl,
  "https://gitproxy.127731.xyz/" + baseUrl,
  "https://jiashu.1win.eu.org/" + baseUrl,
  baseUrl
];
async function testUrl$2(url) {
  try {
    await PromiseTimer(RequestUtil.HttpGetText(url), 5e3);
    return true;
  } catch {
    return false;
  }
}
async function findAvailableUrl$2() {
  for (const url of urls$1) {
    if (await testUrl$2(url)) {
      return url;
    }
  }
  return null;
}
async function getAllTags() {
  const availableUrl = await findAvailableUrl$2();
  if (!availableUrl) {
    throw new Error("No available URL for fetching tags");
  }
  const raw = await RequestUtil.HttpGetText(availableUrl);
  return raw.split("\n").map((line) => {
    const match = line.match(/refs\/tags\/(.+)$/);
    return match ? match[1] : null;
  }).filter((tag) => tag !== null && !tag.endsWith("^{}"));
}
async function getLatestTag() {
  const tags = await getAllTags();
  tags.sort((a, b) => compareVersion(a, b));
  const latest = tags.at(-1);
  if (!latest) {
    throw new Error("No tags found");
  }
  return latest.replace(/^v/, "");
}
function compareVersion(a, b) {
  const normalize = (v) => v.replace(/^v/, "").split(".").map((n) => parseInt(n) || 0);
  const pa = normalize(a);
  const pb = normalize(b);
  const len = Math.max(pa.length, pb.length);
  for (let i = 0; i < len; i++) {
    const na = pa[i] || 0;
    const nb = pb[i] || 0;
    if (na !== nb) return na - nb;
  }
  return 0;
}

function checkFileExist(path2, timeout = 3e3) {
  return new Promise((resolve, reject) => {
    const startTime = Date.now();
    function check() {
      if (fs__default.existsSync(path2)) {
        resolve();
      } else if (Date.now() - startTime > timeout) {
        reject(new Error(`文件不存在: ${path2}`));
      } else {
        setTimeout(check, 100);
      }
    }
    check();
  });
}
async function checkFileExistV2(path2, timeout = 3e3) {
  await Promise.race([
    checkFile(path2),
    timeoutPromise(timeout, `文件不存在: ${path2}`)
  ]);
}
function timeoutPromise(timeout, errorMsg) {
  return new Promise((_resolve, reject) => {
    setTimeout(() => {
      reject(new Error(errorMsg));
    }, timeout);
  });
}
async function checkFile(path2) {
  try {
    await stat$1(path2);
  } catch (error) {
    if (error.code === "ENOENT") {
      throw new Error(`文件不存在: ${path2}`);
    } else {
      throw error;
    }
  }
}
function calculateFileMD5(filePath) {
  return new Promise((resolve, reject) => {
    const stream = fs__default.createReadStream(filePath);
    const hash = crypto__default.createHash("md5");
    stream.on("data", (data) => {
      hash.update(data);
    });
    stream.on("end", () => {
      const md5 = hash.digest("hex");
      resolve(md5);
    });
    stream.on("error", (err) => {
      reject(err);
    });
  });
}
async function tryDownload(options, useReferer = false) {
  let url;
  let headers = {
    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.71 Safari/537.36"
  };
  if (typeof options === "string") {
    url = options;
    headers["Host"] = new URL(url).hostname;
  } else {
    url = options.url;
    if (options.headers) {
      if (typeof options.headers === "string") {
        headers = JSON.parse(options.headers);
      } else {
        headers = options.headers;
      }
    }
  }
  if (useReferer && !headers["Referer"]) {
    headers["Referer"] = url;
  }
  const fetchRes = await fetch(url, { headers, redirect: "follow" }).catch((err) => {
    if (err.cause) {
      throw err.cause;
    }
    throw err;
  });
  return fetchRes;
}
async function httpDownload(options) {
  const useReferer = typeof options === "string";
  let resp = await tryDownload(options);
  if (resp.status === 403 && useReferer) {
    resp = await tryDownload(options, true);
  }
  if (!resp.ok) throw new Error(`下载文件失败: ${resp.statusText}`);
  const blob = await resp.blob();
  const buffer = await blob.arrayBuffer();
  return Buffer.from(buffer);
}
async function checkUriType(Uri) {
  const LocalFileRet = await solveProblem((uri) => {
    if (fs__default.existsSync(path$1.normalize(uri))) {
      return { Uri: path$1.normalize(uri), Type: 1 /* Local */ };
    }
    return void 0;
  }, Uri);
  if (LocalFileRet) return LocalFileRet;
  const OtherFileRet = await solveProblem((uri) => {
    if (uri.startsWith("http:") || uri.startsWith("https:")) {
      return { Uri: uri, Type: 2 /* Remote */ };
    }
    if (uri.startsWith("base64:")) {
      return { Uri: uri, Type: 3 /* Base64 */ };
    }
    if (uri.startsWith("file:")) {
      const filePath = decodeURIComponent(uri.startsWith("file:///") && process.platform === "win32" ? uri.slice(8) : uri.slice(7));
      return { Uri: filePath, Type: 1 /* Local */ };
    }
    if (uri.startsWith("data:")) {
      const data = uri.split(",")[1];
      if (data) return { Uri: data, Type: 3 /* Base64 */ };
    }
    return void 0;
  }, Uri);
  if (OtherFileRet) return OtherFileRet;
  return { Uri, Type: 0 /* Unknown */ };
}
async function uriToLocalFile(dir, uri, filename = randomUUID(), headers) {
  const { Uri: HandledUri, Type: UriType } = await checkUriType(uri);
  const filePath = path$1.join(dir, filename);
  switch (UriType) {
    case 1 /* Local */: {
      const fileExt = path$1.extname(HandledUri);
      const localFileName = path$1.basename(HandledUri, fileExt) + fileExt;
      const tempFilePath = path$1.join(dir, filename + fileExt);
      fs__default.copyFileSync(HandledUri, tempFilePath);
      return { success: true, errMsg: "", fileName: localFileName, path: tempFilePath };
    }
    case 2 /* Remote */: {
      const buffer = await httpDownload({ url: HandledUri, headers: headers ?? {} });
      fs__default.writeFileSync(filePath, buffer);
      return { success: true, errMsg: "", fileName: filename, path: filePath };
    }
    case 3 /* Base64 */: {
      const base64 = HandledUri.replace(/^base64:\/\//, "");
      const base64Buffer = Buffer.from(base64, "base64");
      fs__default.writeFileSync(filePath, base64Buffer);
      return { success: true, errMsg: "", fileName: filename, path: filePath };
    }
    default:
      return { success: false, errMsg: `识别URL失败, uri= ${uri}`, fileName: "", path: "" };
  }
}

const FileId = {
  appid: ProtoField(4, ScalarType.UINT32, true),
  ttl: ProtoField(10, ScalarType.UINT32, true)
};

class NTQQFileApi {
  context;
  core;
  rkeyManager;
  packetRkey;
  fetchRkeyFailures = 0;
  MAX_RKEY_FAILURES = 8;
  constructor(context, core) {
    this.context = context;
    this.core = core;
    this.rkeyManager = new RkeyManager(
      [
        "http://ss.xingzhige.com/music_card/rkey",
        "https://secret-service.bietiaop.com/rkeys"
      ],
      this.context.logger
    );
  }
  async fetchRkeyWithRetry() {
    if (this.fetchRkeyFailures >= this.MAX_RKEY_FAILURES) {
      throw new Error("Native.FetchRkey 已被禁用");
    }
    try {
      const ret = await this.core.apis.PacketApi.pkt.operation.FetchRkey();
      this.fetchRkeyFailures = 0;
      return ret;
    } catch (error) {
      this.fetchRkeyFailures++;
      this.context.logger.logError("FetchRkey 失败", error.message);
      throw error;
    }
  }
  async getFileUrl(chatType, peer, fileUUID, file10MMd5, timeout = 5e3) {
    if (this.core.apis.PacketApi.packetStatus) {
      try {
        if (chatType === ChatType.KCHATTYPEGROUP && fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetGroupFileUrl(+peer, fileUUID, timeout);
        } else if (file10MMd5 && fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetPrivateFileUrl(peer, fileUUID, file10MMd5, timeout);
        }
      } catch (error) {
        this.context.logger.logError("获取文件URL失败", error.message);
      }
    }
    throw new Error("fileUUID or file10MMd5 is undefined");
  }
  async getPttUrl(peer, fileUUID, timeout = 5e3) {
    if (this.core.apis.PacketApi.packetStatus && fileUUID) {
      const appid = new NapProtoMsg(FileId).decode(Buffer.from(fileUUID.replaceAll("-", "+").replaceAll("_", "/"), "base64")).appid;
      try {
        if (appid && appid === 1403) {
          return this.core.apis.PacketApi.pkt.operation.GetGroupPttUrl(+peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        } else if (fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetPttUrl(peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        }
      } catch (error) {
        this.context.logger.logError("获取文件URL失败", error.message);
      }
    }
    throw new Error("packet cant get ptt url");
  }
  async getVideoUrlPacket(peer, fileUUID, timeout = 5e3) {
    if (this.core.apis.PacketApi.packetStatus && fileUUID) {
      const appid = new NapProtoMsg(FileId).decode(Buffer.from(fileUUID.replaceAll("-", "+").replaceAll("_", "/"), "base64")).appid;
      try {
        if (appid && appid === 1415) {
          return this.core.apis.PacketApi.pkt.operation.GetGroupVideoUrl(+peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        } else if (fileUUID) {
          return this.core.apis.PacketApi.pkt.operation.GetVideoUrl(peer, {
            fileUuid: fileUUID,
            storeId: 1,
            uploadTime: 0,
            ttl: 0,
            subType: 0
          }, timeout);
        }
      } catch (error) {
        this.context.logger.logError("获取文件URL失败", error.message);
      }
    }
    throw new Error("packet cant get video url");
  }
  async copyFile(filePath, destPath) {
    await this.core.util.copyFile(filePath, destPath);
  }
  async getFileSize(filePath) {
    return await this.core.util.getFileSize(filePath);
  }
  async getVideoUrl(peer, msgId, elementId) {
    return (await this.context.session.getRichMediaService().getVideoPlayUrlV2(peer, msgId, elementId, 0, {
      downSourceType: 1,
      triggerType: 1
    })).urlResult.domainUrl;
  }
  async uploadFile(filePath, elementType = ElementType.PIC, elementSubType = 0) {
    const fileMd5 = await calculateFileMD5(filePath);
    const extOrEmpty = await fileTypeFromFile(filePath).then((e) => e?.ext ?? "").catch(() => "");
    const ext = extOrEmpty ? `.${extOrEmpty}` : "";
    let fileName = `${path__default.basename(filePath)}`;
    if (fileName.indexOf(".") === -1) {
      fileName += ext;
    }
    const mediaPath = this.context.session.getMsgService().getRichMediaFilePathForGuild({
      md5HexStr: fileMd5,
      fileName,
      elementType,
      elementSubType,
      thumbSize: 0,
      needCreate: true,
      downloadType: 1,
      file_uuid: ""
    });
    await this.copyFile(filePath, mediaPath);
    const fileSize = await this.getFileSize(filePath);
    return {
      md5: fileMd5,
      fileName,
      path: mediaPath,
      fileSize,
      ext
    };
  }
  async downloadFileForModelId(peer, modelId, unknown, timeout = 1e3 * 60 * 2) {
    const [, fileTransNotifyInfo] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelRichMediaService/downloadFileForModelId",
      "NodeIKernelMsgListener/onRichMediaDownloadComplete",
      [peer, [modelId], unknown],
      () => true,
      (arg) => arg?.commonFileInfo?.fileModelId === modelId,
      1,
      timeout
    );
    return fileTransNotifyInfo.filePath;
  }
  async downloadRawMsgMedia(msg) {
    const res = await Promise.all(
      msg.map(
        (m) => Promise.all(
          m.elements.filter(
            (element) => element.elementType === ElementType.PIC || element.elementType === ElementType.VIDEO || element.elementType === ElementType.PTT || element.elementType === ElementType.FILE
          ).map(
            (element) => this.downloadMedia(m.msgId, m.chatType, m.peerUid, element.elementId, "", "", 1e3 * 60 * 2, true)
          )
        )
      )
    );
    msg.forEach((m, msgIndex) => {
      const elementResults = res[msgIndex];
      let elementIndex = 0;
      m.elements.forEach((element) => {
        if (element.elementType === ElementType.PIC || element.elementType === ElementType.VIDEO || element.elementType === ElementType.PTT || element.elementType === ElementType.FILE) {
          switch (element.elementType) {
            case ElementType.PIC:
              element.picElement.sourcePath = elementResults?.[elementIndex] ?? "";
              break;
            case ElementType.VIDEO:
              element.videoElement.filePath = elementResults?.[elementIndex] ?? "";
              break;
            case ElementType.PTT:
              element.pttElement.filePath = elementResults?.[elementIndex] ?? "";
              break;
            case ElementType.FILE:
              element.fileElement.filePath = elementResults?.[elementIndex] ?? "";
              break;
          }
          elementIndex++;
        }
      });
    });
    return res.flat();
  }
  async downloadMedia(msgId, chatType, peerUid, elementId, thumbPath, sourcePath, timeout = 1e3 * 60 * 2, force = false) {
    if (sourcePath && fs__default.existsSync(sourcePath)) {
      if (force) {
        try {
          await fsProm.unlink(sourcePath);
        } catch {
        }
      } else {
        return sourcePath;
      }
    }
    const [, completeRetData] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/downloadRichMedia",
      "NodeIKernelMsgListener/onRichMediaDownloadComplete",
      [{
        fileModelId: "0",
        downSourceType: 0,
        downloadSourceType: 0,
        triggerType: 1,
        msgId,
        chatType,
        peerUid,
        elementId,
        thumbSize: 0,
        downloadType: 1,
        filePath: thumbPath
      }],
      () => true,
      (arg) => arg.msgElementId === elementId && arg.msgId === msgId,
      1,
      timeout
    );
    return completeRetData.filePath;
  }
  async searchForFile(keys) {
    const randomResultId = 1e5 + Math.floor(Math.random() * 1e4);
    let searchId = 0;
    const [, searchResult] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelFileAssistantService/searchFile",
      "NodeIKernelFileAssistantListener/onFileSearch",
      [
        keys,
        { resultType: 2, pageLimit: 1 },
        randomResultId
      ],
      (ret) => {
        searchId = ret;
        return true;
      },
      (result) => result.searchId === searchId && result.resultId === randomResultId
    );
    return searchResult.resultItems[0];
  }
  async downloadFileById(fileId, fileSize = 1024576, estimatedTime = fileSize * 1e3 / 1024576 + 5e3) {
    const [, fileData] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelFileAssistantService/downloadFile",
      "NodeIKernelFileAssistantListener/onFileStatusChanged",
      [[fileId]],
      (ret) => ret.result === 0,
      (status) => status.fileStatus === 2 && status.fileProgress === "0",
      1,
      estimatedTime
      // estimate 1MB/s
    );
    return fileData.filePath;
  }
  async getImageUrl(element) {
    if (!element) {
      return "";
    }
    const url = element.originImageUrl ?? "";
    const md5HexStr = element.md5HexStr;
    const fileMd5 = element.md5HexStr;
    const parsedUrl = new URL(IMAGE_HTTP_HOST + url);
    const imageAppid = parsedUrl.searchParams.get("appid");
    const isNTV2 = imageAppid && ["1406", "1407"].includes(imageAppid);
    const imageFileId = parsedUrl.searchParams.get("fileid");
    if (url && isNTV2 && imageFileId) {
      const rkeyData = await this.getRkeyData();
      return this.getImageUrlFromParsedUrl(imageFileId, imageAppid, rkeyData);
    }
    return this.getImageUrlFromMd5(fileMd5, md5HexStr);
  }
  async getRkeyData() {
    const rkeyData = {
      private_rkey: "CAQSKAB6JWENi5LM_xp9vumLbuThJSaYf-yzMrbZsuq7Uz2qEc3Rbib9LP4",
      group_rkey: "CAQSKAB6JWENi5LM_xp9vumLbuThJSaYf-yzMrbZsuq7Uz2qffcqm614gds",
      online_rkey: false
    };
    try {
      if (this.core.apis.PacketApi.packetStatus) {
        const rkey_expired_private = !this.packetRkey || this.packetRkey[0] && this.packetRkey[0].time + Number(this.packetRkey[0].ttl) < Date.now() / 1e3;
        const rkey_expired_group = !this.packetRkey || this.packetRkey[0] && this.packetRkey[0].time + Number(this.packetRkey[0].ttl) < Date.now() / 1e3;
        if (rkey_expired_private || rkey_expired_group) {
          this.packetRkey = await this.fetchRkeyWithRetry();
        }
        if (this.packetRkey && this.packetRkey.length > 0) {
          rkeyData.group_rkey = this.packetRkey[1]?.rkey.slice(6) ?? "";
          rkeyData.private_rkey = this.packetRkey[0]?.rkey.slice(6) ?? "";
          rkeyData.online_rkey = true;
        }
      }
    } catch (error) {
      this.context.logger.logDebug("获取native.rkey失败", error.message);
    }
    if (!rkeyData.online_rkey) {
      try {
        const tempRkeyData = await this.rkeyManager.getRkey();
        rkeyData.group_rkey = tempRkeyData.group_rkey;
        rkeyData.private_rkey = tempRkeyData.private_rkey;
        rkeyData.online_rkey = tempRkeyData.expired_time > Date.now() / 1e3;
      } catch (error) {
        this.context.logger.logDebug("获取remote.rkey失败", error.message);
      }
    }
    return rkeyData;
  }
  getImageUrlFromParsedUrl(imageFileId, appid, rkeyData) {
    const rkey = appid === "1406" ? rkeyData.private_rkey : rkeyData.group_rkey;
    if (rkeyData.online_rkey) {
      return IMAGE_HTTP_HOST_NT + `/download?appid=${appid}&fileid=${imageFileId}&rkey=${rkey}`;
    }
    return IMAGE_HTTP_HOST + `/download?appid=${appid}&fileid=${imageFileId}&rkey=${rkey}&spec=0`;
  }
  getImageUrlFromMd5(fileMd5, md5HexStr) {
    if (fileMd5 || md5HexStr) {
      return `${IMAGE_HTTP_HOST}/gchatpic_new/0/0-0-${(fileMd5 ?? md5HexStr ?? "").toUpperCase()}/0`;
    }
    this.context.logger.logDebug("图片url获取失败", { fileMd5, md5HexStr });
    return "";
  }
}

class LimitedHashTable {
  keyToValue = /* @__PURE__ */ new Map();
  valueToKey = /* @__PURE__ */ new Map();
  maxSize;
  constructor(maxSize) {
    this.maxSize = maxSize;
  }
  resize(count) {
    this.maxSize = count;
  }
  set(key, value) {
    this.keyToValue.set(key, value);
    this.valueToKey.set(value, key);
    while (this.keyToValue.size !== this.valueToKey.size) {
      this.keyToValue.clear();
      this.valueToKey.clear();
    }
    while (this.keyToValue.size > this.maxSize || this.valueToKey.size > this.maxSize) {
      const oldestKey = this.keyToValue.keys().next().value;
      if (oldestKey !== void 0) {
        this.valueToKey.delete(this.keyToValue.get(oldestKey));
        this.keyToValue.delete(oldestKey);
      }
    }
  }
  getValue(key) {
    return this.keyToValue.get(key);
  }
  getKey(value) {
    return this.valueToKey.get(value);
  }
  deleteByValue(value) {
    const key = this.valueToKey.get(value);
    if (key !== void 0) {
      this.keyToValue.delete(key);
      this.valueToKey.delete(value);
    }
  }
  deleteByKey(key) {
    const value = this.keyToValue.get(key);
    if (value !== void 0) {
      this.keyToValue.delete(key);
      this.valueToKey.delete(value);
    }
  }
  getKeyList() {
    return Array.from(this.keyToValue.keys());
  }
  // 获取最近刚写入的几个值
  getHeads(size) {
    const keyList = this.getKeyList();
    if (keyList.length === 0) {
      return void 0;
    }
    const result = [];
    const listSize = Math.min(size, keyList.length);
    for (let i = 0; i < listSize; i++) {
      const key = keyList[listSize - i];
      if (key !== void 0) {
        result.push({ key, value: this.keyToValue.get(key) });
      }
    }
    return result;
  }
}
class MessageUniqueWrapper {
  msgDataMap;
  msgIdMap;
  constructor(maxMap = 5e3) {
    this.msgIdMap = new LimitedHashTable(maxMap);
    this.msgDataMap = new LimitedHashTable(maxMap);
  }
  getRecentMsgIds(Peer2, size) {
    const heads = this.msgIdMap.getHeads(size);
    if (!heads) {
      return [];
    }
    const data = heads.map((t) => MessageUnique.getMsgIdAndPeerByShortId(t.value));
    const ret = data.filter((t) => t?.Peer.chatType === Peer2.chatType && t?.Peer.peerUid === Peer2.peerUid);
    return ret.map((t) => t?.MsgId).filter((t) => t !== void 0);
  }
  createUniqueMsgId(peer, msgId) {
    const key = `${msgId}|${peer.chatType}|${peer.peerUid}`;
    const hash = crypto__default.createHash("md5").update(key).digest();
    if (hash[0]) {
      hash[0] &= 127;
    }
    const shortId = hash.readInt32BE(0);
    this.msgIdMap.set(msgId, shortId);
    this.msgDataMap.set(key, shortId);
    return shortId;
  }
  getMsgIdAndPeerByShortId(shortId) {
    const data = this.msgDataMap.getKey(shortId);
    if (data) {
      const [msgId, chatTypeStr, peerUid] = data.split("|");
      const peer = {
        chatType: parseInt(chatTypeStr ?? "0"),
        peerUid: peerUid ?? "",
        guildId: ""
      };
      return { MsgId: msgId ?? "0", Peer: peer };
    }
    return void 0;
  }
  getShortIdByMsgId(msgId) {
    return this.msgIdMap.getValue(msgId);
  }
  getPeerByMsgId(msgId) {
    const shortId = this.msgIdMap.getValue(msgId);
    if (!shortId) return void 0;
    return this.getMsgIdAndPeerByShortId(shortId);
  }
  resize(maxSize) {
    this.msgIdMap.resize(maxSize);
    this.msgDataMap.resize(maxSize);
  }
}
const MessageUnique = new MessageUniqueWrapper();

class NTQQFriendApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async setBuddyRemark(uid, remark) {
    return this.context.session.getBuddyService().setBuddyRemark({ uid, remark });
  }
  async getBuddyV2SimpleInfoMap() {
    const buddyService = this.context.session.getBuddyService();
    let uids = [];
    if (this.core.context.basicInfoWrapper.requireMinNTQQBuild("41679")) {
      const buddyListV2NT = await buddyService.getBuddyListV2("0", true, BuddyListReqType.KNOMAL);
      uids = buddyListV2NT.data.flatMap((item) => item.buddyUids);
    } else {
      const buddyListV2 = await buddyService.getBuddyListV2("0", BuddyListReqType.KNOMAL);
      uids = buddyListV2.data.flatMap((item) => item.buddyUids);
    }
    return await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getCoreAndBaseInfo",
      "nodeStore",
      uids
    );
  }
  async getBuddy() {
    return Array.from((await this.getBuddyV2SimpleInfoMap()).values());
  }
  async getBuddyIdMap() {
    const retMap = new LimitedHashTable(5e3);
    const data = await this.getBuddyV2SimpleInfoMap();
    data.forEach((value) => retMap.set(value.uin, value.uid));
    return retMap;
  }
  async delBuudy(uid, tempBlock = false, tempBothDel = false) {
    return this.context.session.getBuddyService().delBuddy({
      friendUid: uid,
      tempBlock,
      tempBothDel
    });
  }
  async getBuddyV2ExWithCate() {
    const buddyService = this.context.session.getBuddyService();
    let uids = [];
    let buddyListV2;
    if (this.core.context.basicInfoWrapper.requireMinNTQQBuild("41679")) {
      buddyListV2 = (await buddyService.getBuddyListV2("0", true, BuddyListReqType.KNOMAL)).data;
      uids = buddyListV2.flatMap((item) => item.buddyUids);
    } else {
      buddyListV2 = (await buddyService.getBuddyListV2("0", BuddyListReqType.KNOMAL)).data;
      uids = buddyListV2.flatMap((item) => item.buddyUids);
    }
    const data = await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getCoreAndBaseInfo",
      "nodeStore",
      uids
    );
    return buddyListV2.map((category) => ({
      categoryId: category.categoryId,
      categorySortId: category.categorySortId,
      categoryName: category.categroyName,
      categoryMbCount: category.categroyMbCount,
      onlineCount: category.onlineCount,
      buddyList: category.buddyUids.map((uid) => data.get(uid)).filter((value) => !!value)
    }));
  }
  async isBuddy(uid) {
    return this.context.session.getBuddyService().isBuddy(uid);
  }
  async clearBuddyReqUnreadCnt() {
    return this.context.session.getBuddyService().clearBuddyReqUnreadCnt();
  }
  async getBuddyReq() {
    const [, ret] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelBuddyService/getBuddyReq",
      "NodeIKernelBuddyListener/onBuddyReqChange",
      []
    );
    return ret;
  }
  async handleFriendRequest(notify, accept) {
    this.context.session.getBuddyService()?.approvalFriendRequest({
      friendUid: notify.friendUid,
      reqTime: notify.reqTime,
      accept
    });
  }
  async handleDoubtFriendRequest(friendUid, str1 = "", str2 = "") {
    this.context.session.getBuddyService().approvalDoubtBuddyReq(friendUid, str1, str2);
  }
  async getDoubtFriendRequest(count) {
    const date = Date.now().toString();
    const [, ret] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelBuddyService/getDoubtBuddyReq",
      "NodeIKernelBuddyListener/onDoubtBuddyReqChange",
      [date, count, ""],
      () => true,
      (data) => data.reqId === date
    );
    const requests = Promise.all(ret.doubtList.map(async (item) => {
      return {
        flag: item.uid,
        // 注意强制String 非isNumeric 不遵守则不符合设计
        uin: await this.core.apis.UserApi.getUinByUidV2(item.uid) ?? 0,
        // 信息字段
        nick: item.nick,
        // 信息字段 这个不是nickname 可能是来源的群内的昵称
        source: item.source,
        // 信息字段
        reason: item.reason,
        // 信息字段
        msg: item.msg,
        // 信息字段
        group_code: item.groupCode,
        // 信息字段
        time: item.reqTime,
        // 信息字段
        type: "doubt"
        // 保留字段
      };
    }));
    return requests;
  }
}

class CancelableTask {
  promise;
  cancelCallback = null;
  isCanceled = false;
  cancelListeners = [];
  constructor(executor) {
    this.promise = new Promise((resolve, reject) => {
      const onCancel = (callback) => {
        this.cancelCallback = callback;
      };
      const execute = async () => {
        try {
          await executor(
            (value) => {
              if (!this.isCanceled) {
                resolve(value);
              }
            },
            (reason) => {
              if (!this.isCanceled) {
                reject(reason);
              }
            },
            onCancel
          );
        } catch (error) {
          if (!this.isCanceled) {
            reject(error);
          }
        }
      };
      execute();
    });
  }
  cancel() {
    if (this.cancelCallback) {
      this.cancelCallback();
    }
    this.isCanceled = true;
    this.cancelListeners.forEach((listener) => listener());
  }
  isTaskCanceled() {
    return this.isCanceled;
  }
  onCancel(listener) {
    this.cancelListeners.push(listener);
  }
  then(onfulfilled, onrejected) {
    return this.promise.then(onfulfilled, onrejected);
  }
  catch(onrejected) {
    return this.promise.catch(onrejected);
  }
  finally(onfinally) {
    return this.promise.finally(onfinally);
  }
  [Symbol.asyncIterator]() {
    return {
      next: () => this.promise.then((value) => ({ value, done: true }))
    };
  }
}

function createGroupDetailInfoV2Param(group_code) {
  return {
    groupCode: group_code,
    filter: {
      noCodeFingerOpenFlag: 0,
      noFingerOpenFlag: 0,
      groupName: 0,
      classExt: 0,
      classText: 0,
      fingerMemo: 0,
      richFingerMemo: 0,
      tagRecord: 0,
      groupGeoInfo: {
        ownerUid: 0,
        setTime: 0,
        cityId: 0,
        longitude: 0,
        latitude: 0,
        geoContent: 0,
        poiId: 0
      },
      groupExtAdminNum: 0,
      flag: 0,
      groupMemo: 0,
      groupAioSkinUrl: 0,
      groupBoardSkinUrl: 0,
      groupCoverSkinUrl: 0,
      groupGrade: 0,
      activeMemberNum: 0,
      certificationType: 0,
      certificationText: 0,
      groupNewGuideLines: {
        enabled: 0,
        content: 0
      },
      groupFace: 0,
      addOption: 0,
      shutUpTime: 0,
      groupTypeFlag: 0,
      appPrivilegeFlag: 0,
      appPrivilegeMask: 0,
      groupExtOnly: {
        tribeId: 0,
        moneyForAddGroup: 0
      },
      groupSecLevel: 0,
      groupSecLevelInfo: 0,
      subscriptionUin: 0,
      subscriptionUid: "",
      allowMemberInvite: 0,
      groupQuestion: 0,
      groupAnswer: 0,
      groupFlagExt3: 0,
      groupFlagExt3Mask: 0,
      groupOpenAppid: 0,
      rootId: 0,
      msgLimitFrequency: 0,
      hlGuildAppid: 0,
      hlGuildSubType: 0,
      hlGuildOrgId: 0,
      groupFlagExt4: 0,
      groupFlagExt4Mask: 0,
      groupSchoolInfo: {
        location: 0,
        grade: 0,
        school: 0
      },
      groupCardPrefix: {
        introduction: 0,
        rptPrefix: 0
      },
      allianceId: 0,
      groupFlagPro1: 0,
      groupFlagPro1Mask: 0
    },
    modifyInfo: {
      noCodeFingerOpenFlag: 0,
      noFingerOpenFlag: 0,
      groupName: "",
      classExt: 0,
      classText: "",
      fingerMemo: "",
      richFingerMemo: "",
      tagRecord: [],
      groupGeoInfo: {
        ownerUid: "",
        SetTime: 0,
        CityId: 0,
        Longitude: "",
        Latitude: "",
        GeoContent: "",
        poiId: ""
      },
      groupExtAdminNum: 0,
      flag: 0,
      groupMemo: "",
      groupAioSkinUrl: "",
      groupBoardSkinUrl: "",
      groupCoverSkinUrl: "",
      groupGrade: 0,
      activeMemberNum: 0,
      certificationType: 0,
      certificationText: "",
      groupNewGuideLines: {
        enabled: false,
        content: ""
      },
      groupFace: 0,
      addOption: 0,
      shutUpTime: 0,
      groupTypeFlag: 0,
      appPrivilegeFlag: 0,
      appPrivilegeMask: 0,
      groupExtOnly: {
        tribeId: 0,
        moneyForAddGroup: 0
      },
      groupSecLevel: 0,
      groupSecLevelInfo: 0,
      subscriptionUin: "",
      subscriptionUid: "",
      allowMemberInvite: 0,
      groupQuestion: "",
      groupAnswer: "",
      groupFlagExt3: 0,
      groupFlagExt3Mask: 0,
      groupOpenAppid: 0,
      rootId: "",
      msgLimitFrequency: 0,
      hlGuildAppid: 0,
      hlGuildSubType: 0,
      hlGuildOrgId: 0,
      groupFlagExt4: 0,
      groupFlagExt4Mask: 0,
      groupSchoolInfo: {
        location: "",
        grade: 0,
        school: ""
      },
      groupCardPrefix: {
        introduction: "",
        rptPrefix: []
      },
      allianceId: "",
      groupFlagPro1: 0,
      groupFlagPro1Mask: 0
    }
  };
}
function createGroupExtInfo(group_code) {
  return {
    groupCode: group_code,
    resultCode: 0,
    extInfo: {
      groupInfoExtSeq: 0,
      reserve: 0,
      luckyWordId: "",
      lightCharNum: 0,
      luckyWord: "",
      starId: 0,
      essentialMsgSwitch: 0,
      todoSeq: 0,
      blacklistExpireTime: 0,
      isLimitGroupRtc: 0,
      companyId: 0,
      hasGroupCustomPortrait: 0,
      bindGuildId: "",
      groupOwnerId: {
        memberUin: "",
        memberUid: "",
        memberQid: ""
      },
      essentialMsgPrivilege: 0,
      msgEventSeq: "",
      inviteRobotSwitch: 0,
      gangUpId: "",
      qqMusicMedalSwitch: 0,
      showPlayTogetherSwitch: 0,
      groupFlagPro1: "",
      groupBindGuildIds: {
        guildIds: []
      },
      viewedMsgDisappearTime: "",
      groupExtFlameData: {
        switchState: 0,
        state: 0,
        dayNums: [],
        version: 0,
        updateTime: "",
        isDisplayDayNum: false
      },
      groupBindGuildSwitch: 0,
      groupAioBindGuildId: "",
      groupExcludeGuildIds: {
        guildIds: []
      },
      fullGroupExpansionSwitch: 0,
      fullGroupExpansionSeq: "",
      inviteRobotMemberSwitch: 0,
      inviteRobotMemberExamine: 0,
      groupSquareSwitch: 0
    }
  };
}
function createGroupExtFilter() {
  return {
    groupInfoExtSeq: 0,
    reserve: 0,
    luckyWordId: 0,
    lightCharNum: 0,
    luckyWord: 0,
    starId: 0,
    essentialMsgSwitch: 0,
    todoSeq: 0,
    blacklistExpireTime: 0,
    isLimitGroupRtc: 0,
    companyId: 0,
    hasGroupCustomPortrait: 0,
    bindGuildId: 0,
    groupOwnerId: 0,
    essentialMsgPrivilege: 0,
    msgEventSeq: 0,
    inviteRobotSwitch: 0,
    gangUpId: 0,
    qqMusicMedalSwitch: 0,
    showPlayTogetherSwitch: 0,
    groupFlagPro1: 0,
    groupBindGuildIds: 0,
    viewedMsgDisappearTime: 0,
    groupExtFlameData: 0,
    groupBindGuildSwitch: 0,
    groupAioBindGuildId: 0,
    groupExcludeGuildIds: 0,
    fullGroupExpansionSwitch: 0,
    fullGroupExpansionSeq: 0,
    inviteRobotMemberSwitch: 0,
    inviteRobotMemberExamine: 0,
    groupSquareSwitch: 0
  };
}

class NTQQGroupApi {
  context;
  core;
  groupMemberCache = /* @__PURE__ */ new Map();
  essenceLRU = new LimitedHashTable(1e3);
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async setGroupRemark(groupCode, remark) {
    return this.context.session.getGroupService().modifyGroupRemark(groupCode, remark);
  }
  async fetchGroupDetail(groupCode) {
    const [, detailInfo] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelGroupService/getGroupDetailInfo",
      "NodeIKernelGroupListener/onGroupDetailInfoChange",
      [groupCode, GroupInfoSource.KDATACARD],
      (ret) => ret.result === 0,
      (detailInfo2) => detailInfo2.groupCode === groupCode,
      1,
      5e3
    );
    return detailInfo;
  }
  async initApi() {
    this.initCache().then().catch((e) => this.context.logger.logError(e));
  }
  async createGrayTip(groupCode, tip) {
    return this.context.session.getMsgService().addLocalJsonGrayTipMsg(
      {
        chatType: ChatType.KCHATTYPEGROUP,
        peerUid: groupCode
      },
      {
        busiId: 2201,
        jsonStr: JSON.stringify({ align: "center", items: [{ txt: tip, type: "nor" }] }),
        recentAbstract: tip,
        isServer: false
      },
      true,
      true
    );
  }
  async initCache() {
    for (const group of await this.getGroups(true)) {
      this.refreshGroupMemberCache(group.groupCode, false).then().catch((e) => this.context.logger.logError(e));
    }
  }
  async fetchGroupEssenceList(groupCode) {
    const pskey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    return this.context.session.getGroupService().fetchGroupEssenceList({
      groupCode,
      pageStart: 0,
      pageLimit: 300
    }, pskey);
  }
  async getGroupShutUpMemberList(groupCode) {
    const executor = async (resolve, reject, onCancel) => {
      this.core.eventWrapper.registerListen(
        "NodeIKernelGroupListener/onShutUpMemberListChanged",
        (group_id) => group_id === groupCode,
        1,
        1e3
      ).then((data) => {
        resolve(data[1]);
      }).catch(reject);
      onCancel(() => {
        reject(new Error("Task was canceled"));
      });
    };
    const task = new CancelableTask(executor);
    this.context.session.getGroupService().getGroupShutUpMemberList(groupCode).then((e) => {
      if (e.result !== 0) {
        task.cancel();
      }
    });
    return await task.catch(() => []);
  }
  async clearGroupNotifiesUnreadCount(doubt) {
    return this.context.session.getGroupService().clearGroupNotifiesUnreadCount(doubt);
  }
  async setGroupAvatar(groupCode, filePath) {
    return this.context.session.getGroupService().setHeader(groupCode, filePath);
  }
  // 0 0 无需管理员审核
  // 0 2 需要管理员审核
  // 1 2 禁止Bot入群( 最好只传一个1 ？)
  async setGroupRobotAddOption(groupCode, robotMemberSwitch, robotMemberExamine) {
    const extInfo = createGroupExtInfo(groupCode);
    const groupExtFilter = createGroupExtFilter();
    if (robotMemberSwitch !== void 0) {
      extInfo.extInfo.inviteRobotMemberSwitch = robotMemberSwitch;
      groupExtFilter.inviteRobotMemberSwitch = 1;
    }
    if (robotMemberExamine !== void 0) {
      extInfo.extInfo.inviteRobotMemberExamine = robotMemberExamine;
      groupExtFilter.inviteRobotMemberExamine = 1;
    }
    return this.context.session.getGroupService().modifyGroupExtInfoV2(extInfo, groupExtFilter);
  }
  async setGroupAddOption(groupCode, option) {
    const param = createGroupDetailInfoV2Param(groupCode);
    param.filter.addOption = 1;
    if (option.addOption === 4 || option.addOption === 5) {
      param.filter.groupQuestion = 1;
      param.filter.groupAnswer = option.addOption === 4 ? 1 : 0;
      param.modifyInfo.groupQuestion = option.groupQuestion || "";
      param.modifyInfo.groupAnswer = option.addOption === 4 ? option.groupAnswer || "" : "";
    }
    param.modifyInfo.addOption = option.addOption;
    return this.context.session.getGroupService().modifyGroupDetailInfoV2(param, 0);
  }
  async setGroupSearch(groupCode, option) {
    const param = createGroupDetailInfoV2Param(groupCode);
    if (option.noCodeFingerOpenFlag) {
      param.filter.noCodeFingerOpenFlag = 1;
      param.modifyInfo.noCodeFingerOpenFlag = option.noCodeFingerOpenFlag;
    }
    if (option.noFingerOpenFlag) {
      param.filter.noFingerOpenFlag = 1;
      param.modifyInfo.noFingerOpenFlag = option.noFingerOpenFlag;
    }
    return this.context.session.getGroupService().modifyGroupDetailInfoV2(param, 0);
  }
  async getGroups(forced = false) {
    const [, , groupList] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelGroupService/getGroupList",
      "NodeIKernelGroupListener/onGroupListUpdate",
      [forced]
    );
    return groupList;
  }
  async getGroupExtFE0Info(groupCodes, forced = true) {
    return this.context.session.getGroupService().getGroupExt0xEF0Info(
      groupCodes,
      [],
      {
        bindGuildId: 1,
        blacklistExpireTime: 1,
        companyId: 1,
        essentialMsgPrivilege: 1,
        essentialMsgSwitch: 1,
        fullGroupExpansionSeq: 1,
        fullGroupExpansionSwitch: 1,
        gangUpId: 1,
        groupAioBindGuildId: 1,
        groupBindGuildIds: 1,
        groupBindGuildSwitch: 1,
        groupExcludeGuildIds: 1,
        groupExtFlameData: 1,
        groupFlagPro1: 1,
        groupInfoExtSeq: 1,
        groupOwnerId: 1,
        groupSquareSwitch: 1,
        hasGroupCustomPortrait: 1,
        inviteRobotMemberExamine: 1,
        inviteRobotMemberSwitch: 1,
        inviteRobotSwitch: 1,
        isLimitGroupRtc: 1,
        lightCharNum: 1,
        luckyWord: 1,
        luckyWordId: 1,
        msgEventSeq: 1,
        qqMusicMedalSwitch: 1,
        reserve: 1,
        showPlayTogetherSwitch: 1,
        starId: 1,
        todoSeq: 1,
        viewedMsgDisappearTime: 1
      },
      forced
    );
  }
  async getGroupMemberAll(groupCode, forced = false) {
    return this.context.session.getGroupService().getAllMemberList(groupCode, forced);
  }
  async refreshGroupMemberCache(groupCode, isWait = true) {
    const updateCache = async () => {
      try {
        const members = await this.getGroupMemberAll(groupCode, true);
        this.groupMemberCache.set(groupCode, members.result.infos);
      } catch (e) {
        this.context.logger.logError(`刷新群成员缓存失败, 群号: ${groupCode}, 错误: ${e}`);
      }
    };
    if (isWait) {
      await updateCache();
    } else {
      updateCache();
    }
    return this.groupMemberCache.get(groupCode);
  }
  async refreshGroupMemberCachePartial(groupCode, uid) {
    const member = await this.getGroupMemberEx(groupCode, uid, true);
    if (member) {
      this.groupMemberCache.get(groupCode)?.set(uid, member);
    }
    return member;
  }
  async getGroupMember(groupCode, memberUinOrUid) {
    const groupCodeStr = groupCode.toString();
    const memberUinOrUidStr = memberUinOrUid.toString();
    let members = this.groupMemberCache.get(groupCodeStr);
    if (!members) {
      members = await this.refreshGroupMemberCache(groupCodeStr, true);
    }
    const getMember = () => {
      if (isNumeric(memberUinOrUidStr)) {
        return Array.from(members.values()).find((member2) => member2.uin === memberUinOrUidStr);
      } else {
        return members.get(memberUinOrUidStr);
      }
    };
    let member = getMember();
    if (!member) {
      members = await this.refreshGroupMemberCache(groupCodeStr, true);
      member = getMember();
    }
    return member;
  }
  async getGroupRecommendContactArkJson(groupCode) {
    return this.context.session.getGroupService().getGroupRecommendContactArkJson(groupCode);
  }
  async creatGroupFileFolder(groupCode, folderName) {
    return this.context.session.getRichMediaService().createGroupFolder(groupCode, folderName);
  }
  async delGroupFile(groupCode, files) {
    return this.context.session.getRichMediaService().deleteGroupFile(groupCode, [102], files);
  }
  async delGroupFileFolder(groupCode, folderId) {
    return this.context.session.getRichMediaService().deleteGroupFolder(groupCode, folderId);
  }
  async transGroupFile(groupCode, fileId) {
    return this.context.session.getRichMediaService().transGroupFile(groupCode, fileId);
  }
  async addGroupEssence(groupCode, msgId) {
    const MsgData = await this.context.session.getMsgService().getMsgsIncludeSelf({
      chatType: 2,
      guildId: "",
      peerUid: groupCode
    }, msgId, 1, false);
    if (!MsgData.msgList[0]) {
      throw new Error("消息不存在");
    }
    const param = {
      groupCode,
      msgRandom: parseInt(MsgData.msgList[0].msgRandom),
      msgSeq: parseInt(MsgData.msgList[0].msgSeq)
    };
    return this.context.session.getGroupService().addGroupEssence(param);
  }
  async kickMemberV2Inner(param) {
    return this.context.session.getGroupService().kickMemberV2(param);
  }
  async deleteGroupBulletin(groupCode, noticeId) {
    const psKey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    return this.context.session.getGroupService().deleteGroupBulletin(groupCode, psKey, noticeId);
  }
  async quitGroupV2(GroupCode, needDeleteLocalMsg) {
    const param = {
      groupCode: GroupCode,
      needDeleteLocalMsg
    };
    return this.context.session.getGroupService().quitGroupV2(param);
  }
  async removeGroupEssenceBySeq(groupCode, msgRandom, msgSeq) {
    const param = {
      groupCode,
      msgRandom: parseInt(msgRandom),
      msgSeq: parseInt(msgSeq)
    };
    return this.context.session.getGroupService().removeGroupEssence(param);
  }
  async removeGroupEssence(groupCode, msgId) {
    const MsgData = await this.context.session.getMsgService().getMsgsIncludeSelf({
      chatType: 2,
      guildId: "",
      peerUid: groupCode
    }, msgId, 1, false);
    if (!MsgData.msgList[0]) {
      throw new Error("消息不存在");
    }
    const param = {
      groupCode,
      msgRandom: parseInt(MsgData.msgList[0].msgRandom),
      msgSeq: parseInt(MsgData.msgList[0].msgSeq)
    };
    return this.context.session.getGroupService().removeGroupEssence(param);
  }
  async getSingleScreenNotifies(doubt, count) {
    const [, , , notifies] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelGroupService/getSingleScreenNotifies",
      "NodeIKernelGroupListener/onGroupSingleScreenNotifies",
      [
        doubt,
        "",
        count
      ]
    );
    return notifies;
  }
  async searchGroup(groupCode) {
    const [, ret] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelSearchService/searchGroup",
      "NodeIKernelSearchListener/onSearchGroupResult",
      [{
        keyWords: groupCode,
        groupNum: 25,
        exactSearch: false,
        penetrate: ""
      }],
      (ret2) => ret2.result === 0,
      (params) => !!params.groupInfos.find((g) => g.groupCode === groupCode),
      1,
      5e3
    );
    return ret.groupInfos.find((g) => g.groupCode === groupCode);
  }
  async getGroupMemberEx(groupCode, uid, forced = false, retry = 2) {
    const data = await solveAsyncProblem((eventWrapper, GroupCode, uid2, forced2 = false) => {
      return eventWrapper.callNormalEventV2(
        "NodeIKernelGroupService/getMemberInfo",
        "NodeIKernelGroupListener/onMemberInfoChange",
        [groupCode, [uid2], forced2],
        (ret) => ret.result === 0,
        (params, _, members) => params === GroupCode && members.size > 0 && members.has(uid2),
        1,
        forced2 ? 2500 : 250
      );
    }, this.core.eventWrapper, groupCode, uid, forced);
    if (data && data[3] instanceof Map && data[3].has(uid)) {
      return data[3].get(uid);
    }
    if (retry > 0) {
      const trydata = await this.getGroupMemberEx(groupCode, uid, true, retry - 1);
      if (trydata) return trydata;
    }
    return void 0;
  }
  async getGroupFileCount(groupCodes) {
    return this.context.session.getRichMediaService().batchGetGroupFileCount(groupCodes);
  }
  async getArkJsonGroupShare(groupCode) {
    const ret = await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelGroupService/getGroupRecommendContactArkJson",
      groupCode
    );
    return ret.arkJson;
  }
  async uploadGroupBulletinPic(groupCode, imageurl) {
    const _Pskey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    return this.context.session.getGroupService().uploadGroupBulletinPic(groupCode, _Pskey, imageurl);
  }
  async handleGroupRequest(doubt, notify, operateType, reason) {
    return this.context.session.getGroupService().operateSysNotify(
      doubt,
      {
        operateType,
        targetMsg: {
          seq: notify.seq,
          // 通知序列号
          type: notify.type,
          groupCode: notify.group.groupCode,
          postscript: reason ?? " "
          // 仅传空值可能导致处理失败，故默认给个空格
        }
      }
    );
  }
  async quitGroup(groupCode) {
    return this.context.session.getGroupService().quitGroup(groupCode);
  }
  async kickMember(groupCode, kickUids, refuseForever = false, kickReason = "") {
    return this.context.session.getGroupService().kickMember(groupCode, kickUids, refuseForever, kickReason);
  }
  async banMember(groupCode, memList) {
    return this.context.session.getGroupService().setMemberShutUp(groupCode, memList);
  }
  async banGroup(groupCode, shutUp) {
    return this.context.session.getGroupService().setGroupShutUp(groupCode, shutUp);
  }
  async setMemberCard(groupCode, memberUid, cardName) {
    return this.context.session.getGroupService().modifyMemberCardName(groupCode, memberUid, cardName);
  }
  async setMemberRole(groupCode, memberUid, role) {
    return this.context.session.getGroupService().modifyMemberRole(groupCode, memberUid, role);
  }
  async setGroupName(groupCode, groupName) {
    return this.context.session.getGroupService().modifyGroupName(groupCode, groupName, false);
  }
  async publishGroupBulletin(groupCode, content, picInfo = void 0, pinned = 0, confirmRequired = 0) {
    const psKey = (await this.core.apis.UserApi.getPSkey(["qun.qq.com"])).domainPskeyMap.get("qun.qq.com");
    const data = {
      text: encodeURI(content),
      picInfo,
      oldFeedsId: "",
      pinned,
      confirmRequired
    };
    return this.context.session.getGroupService().publishGroupBulletin(groupCode, psKey, data);
  }
  async getGroupRemainAtTimes(groupCode) {
    return this.context.session.getGroupService().getGroupRemainAtTimes(groupCode);
  }
  async getMemberExtInfo(groupCode, uin) {
    return this.context.session.getGroupService().getMemberExtInfo(
      {
        groupCode,
        sourceType: MemberExtSourceType.TITLETYPE,
        beginUin: "0",
        dataTime: "0",
        uinList: [uin],
        uinNum: "",
        seq: "",
        groupType: "",
        richCardNameVer: "",
        memberExtFilter: {
          memberLevelInfoUin: 1,
          memberLevelInfoPoint: 1,
          memberLevelInfoActiveDay: 1,
          memberLevelInfoLevel: 1,
          memberLevelInfoName: 1,
          levelName: 1,
          dataTime: 1,
          userShowFlag: 1,
          sysShowFlag: 1,
          timeToUpdate: 1,
          nickName: 1,
          specialTitle: 1,
          levelNameNew: 1,
          userShowFlagNew: 1,
          msgNeedField: 1,
          cmdUinFlagExt3Grocery: 1,
          memberIcon: 1,
          memberInfoSeq: 1
        }
      }
    );
  }
}

class NTQQMsgApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async clickInlineKeyboardButton(...params) {
    return this.context.session.getMsgService().clickInlineKeyboardButton(...params);
  }
  getMsgByClientSeqAndTime(peer, replyMsgClientSeq, replyMsgTime) {
    return this.context.session.getMsgService().getMsgByClientSeqAndTime(peer, replyMsgClientSeq, replyMsgTime);
  }
  async getAioFirstViewLatestMsgs(peer, MsgCount) {
    return this.context.session.getMsgService().getAioFirstViewLatestMsgs(peer, MsgCount);
  }
  async sendShowInputStatusReq(peer, eventType) {
    return this.context.session.getMsgService().sendShowInputStatusReq(peer.chatType, eventType, peer.peerUid);
  }
  async getSourceOfReplyMsgV2(peer, clientSeq, time) {
    return this.context.session.getMsgService().getSourceOfReplyMsgV2(peer, clientSeq, time);
  }
  async getMsgEmojiLikesList(peer, msgSeq, emojiId, emojiType, count = 20) {
    return this.context.session.getMsgService().getMsgEmojiLikesList(peer, msgSeq, emojiId, emojiType, "", false, count);
  }
  async setEmojiLike(peer, msgSeq, emojiId, set = true) {
    emojiId = emojiId.toString();
    return this.context.session.getMsgService().setMsgEmojiLikes(peer, msgSeq, emojiId, emojiId.length > 3 ? "2" : "1", set);
  }
  async getMultiMsg(peer, rootMsgId, parentMsgId) {
    return this.context.session.getMsgService().getMultiMsg(peer, rootMsgId, parentMsgId);
  }
  async ForwardMsg(peer, msgIds) {
    return this.context.session.getMsgService().forwardMsg(msgIds, peer, [peer], /* @__PURE__ */ new Map());
  }
  async getMsgsByMsgId(peer, msgIds) {
    if (!peer) throw new Error("peer is not allowed");
    if (!msgIds) throw new Error("msgIds is not allowed");
    return await this.context.session.getMsgService().getMsgsByMsgId(peer, msgIds);
  }
  async getSingleMsg(peer, seq) {
    return await this.context.session.getMsgService().getSingleMsg(peer, seq);
  }
  async fetchFavEmojiList(num) {
    return this.context.session.getMsgService().fetchFavEmojiList("", num, true, true);
  }
  async queryMsgsWithFilterExWithSeq(peer, msgSeq) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      // searchFields: 3,
      filterMsgType: [],
      filterSendersUid: [],
      filterMsgToTime: "0",
      filterMsgFromTime: "0",
      isReverseOrder: false,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  async queryMsgsWithFilterExWithSeqV2(peer, msgSeq, MsgTime, SendersUid) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      filterMsgType: [],
      // searchFields: 3,
      filterSendersUid: SendersUid,
      filterMsgToTime: MsgTime,
      filterMsgFromTime: MsgTime,
      isReverseOrder: false,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  async queryMsgsWithFilterExWithSeqV3(peer, msgSeq, SendersUid) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      filterMsgType: [],
      filterSendersUid: SendersUid,
      filterMsgToTime: "0",
      filterMsgFromTime: "0",
      isReverseOrder: false,
      // searchFields: 3,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  async queryFirstMsgBySeq(peer, msgSeq) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      filterMsgType: [],
      filterSendersUid: [],
      filterMsgToTime: "0",
      // searchFields: 3,
      filterMsgFromTime: "0",
      isReverseOrder: true,
      isIncludeCurrent: true,
      pageLimit: 1
    });
  }
  // 客户端还在用别慌
  async getMsgsBySeqAndCount(peer, seq, count, desc, isReverseOrder) {
    return await this.context.session.getMsgService().getMsgsBySeqAndCount(peer, seq, count, desc, isReverseOrder);
  }
  async getMsgExBySeq(peer, msgSeq) {
    const DateNow = Math.floor(Date.now() / 1e3);
    const filterMsgFromTime = (DateNow - 300).toString();
    const filterMsgToTime = DateNow.toString();
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", msgSeq, {
      chatInfo: peer,
      // 此处为Peer 为关键查询参数 没有啥也没有 by mlik iowa
      filterMsgType: [],
      filterSendersUid: [],
      // searchFields: 3,
      filterMsgToTime,
      filterMsgFromTime,
      isReverseOrder: false,
      isIncludeCurrent: true,
      pageLimit: 100
    });
  }
  async queryFirstMsgBySender(peer, SendersUid) {
    return await this.context.session.getMsgService().queryMsgsWithFilterEx("0", "0", "0", {
      chatInfo: peer,
      filterMsgType: [],
      filterSendersUid: SendersUid,
      // searchFields: 3,
      filterMsgToTime: "0",
      filterMsgFromTime: "0",
      isReverseOrder: true,
      isIncludeCurrent: true,
      pageLimit: 2e4
    });
  }
  async setMsgRead(peer) {
    return this.context.session.getMsgService().setMsgRead(peer);
  }
  async getGroupFileList(GroupCode, params) {
    const item = [];
    let index = params.startIndex;
    while (true) {
      params.startIndex = index;
      const [, groupFileListResult] = await this.core.eventWrapper.callNormalEventV2(
        "NodeIKernelRichMediaService/getGroupFileList",
        "NodeIKernelMsgListener/onGroupFileInfoUpdate",
        [
          GroupCode,
          params
        ],
        () => true,
        () => true,
        // 应当通过 groupFileListResult 判断
        1,
        5e3
      );
      if (!groupFileListResult?.item?.length) break;
      item.push(...groupFileListResult.item);
      if (groupFileListResult.isEnd) break;
      if (item.length === params.fileCount) break;
      index = groupFileListResult.nextIndex;
    }
    return item;
  }
  async getMsgHistory(peer, msgId, count, isReverseOrder = false) {
    return this.context.session.getMsgService().getMsgsIncludeSelf(peer, msgId, count, isReverseOrder);
  }
  async recallMsg(peer, msgId) {
    return await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/recallMsg",
      "NodeIKernelMsgListener/onMsgInfoListUpdate",
      [peer, [msgId]],
      () => true,
      (updatedList) => updatedList.find((m) => m.msgId === msgId && m.recallTime !== "0") !== void 0,
      1,
      1e3
    );
  }
  async PrepareTempChat(toUserUid, GroupCode, nickname) {
    return this.context.session.getMsgService().prepareTempChat({
      chatType: ChatType.KCHATTYPETEMPC2CFROMGROUP,
      peerUid: toUserUid,
      peerNickname: nickname,
      fromGroupCode: GroupCode,
      sig: "",
      selfPhone: "",
      selfUid: this.core.selfInfo.uid,
      gameSession: {
        nickname: "",
        gameAppId: "",
        selfTinyId: "",
        peerRoleId: "",
        peerOpenId: ""
      }
    });
  }
  async getTempChatInfo(chatType, peerUid) {
    return this.context.session.getMsgService().getTempChatInfo(chatType, peerUid);
  }
  async sendMsg(peer, msgElements, timeout = 1e4) {
    if (peer.chatType === ChatType.KCHATTYPETEMPC2CFROMGROUP && peer.guildId && peer.guildId !== "") {
      const member = await this.core.apis.GroupApi.getGroupMember(peer.guildId, peer.peerUid);
      if (member) {
        await this.PrepareTempChat(peer.peerUid, peer.guildId, member.nick);
      }
    }
    const msgId = await this.generateMsgUniqueId(peer.chatType);
    peer.guildId = msgId;
    const [, msgList] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/sendMsg",
      "NodeIKernelMsgListener/onMsgInfoListUpdate",
      [
        "0",
        peer,
        msgElements,
        /* @__PURE__ */ new Map()
      ],
      (ret) => ret.result === 0,
      (msgRecords) => {
        for (const msgRecord of msgRecords) {
          if (msgRecord.guildId === msgId && msgRecord.sendStatus === SendStatusType.KSEND_STATUS_SUCCESS) {
            return true;
          }
        }
        return false;
      },
      1,
      timeout
    );
    return msgList.find((msgRecord) => msgRecord.guildId === msgId);
  }
  async generateMsgUniqueId(chatType) {
    return this.context.session.getMsgService().generateMsgUniqueId(chatType, this.context.session.getMSFService().getServerTime());
  }
  async forwardMsg(srcPeer, destPeer, msgIds) {
    return this.context.session.getMsgService().forwardMsg(msgIds, srcPeer, [destPeer], /* @__PURE__ */ new Map());
  }
  async multiForwardMsg(srcPeer, destPeer, msgIds) {
    const msgInfos = msgIds.map((id) => {
      return { msgId: id, senderShowName: this.core.selfInfo.nick };
    });
    const [, msgList] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelMsgService/multiForwardMsgWithComment",
      "NodeIKernelMsgListener/onMsgInfoListUpdate",
      [
        msgInfos,
        srcPeer,
        destPeer,
        [],
        /* @__PURE__ */ new Map()
      ],
      () => true,
      (msgRecords) => msgRecords.some(
        (msgRecord) => msgRecord.peerUid === destPeer.peerUid && msgRecord.senderUid === this.core.selfInfo.uid
      )
    );
    for (const msg of msgList) {
      const arkElement = msg.elements.find((ele) => ele.arkElement);
      if (!arkElement) {
        continue;
      }
      const forwardData = JSON.parse(arkElement.arkElement?.bytesData ?? "");
      if (forwardData.app !== "com.tencent.multimsg") {
        continue;
      }
      if (msg.peerUid === destPeer.peerUid && msg.senderUid === this.core.selfInfo.uid) {
        return msg;
      }
    }
    throw new Error("转发消息超时");
  }
  async markAllMsgAsRead() {
    return this.context.session.getMsgService().setAllC2CAndGroupMsgRead();
  }
}

class Fallback {
  handlers = [];
  checker;
  constructor(checker) {
    this.checker = checker || (async (result) => result);
  }
  add(handler) {
    this.handlers.push(handler);
    return this;
  }
  // 执行处理程序链
  async run() {
    const errors = [];
    for (const handler of this.handlers) {
      try {
        const result = await handler();
        const data = await this.checker(result);
        if (data) {
          return data;
        }
      } catch (error) {
        errors.push(error instanceof Error ? error : new Error(String(error)));
      }
    }
    throw new AggregateError(errors, "All handlers failed");
  }
}
class FallbackUtil {
  static boolchecker(value, condition) {
    if (condition) {
      return value;
    } else {
      throw new Error("Condition is false, throwing error");
    }
  }
}

class NTQQUserApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async getCoreAndBaseInfo(uids) {
    return await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getCoreAndBaseInfo",
      "nodeStore",
      uids
    );
  }
  // 默认获取自己的 type = 2 获取别人 type = 1
  async getProfileLike(uid, start, count, type = 2) {
    return this.context.session.getProfileLikeService().getBuddyProfileLike({
      friendUids: [uid],
      basic: 1,
      vote: 1,
      favorite: 0,
      userProfile: 1,
      type,
      start,
      limit: count
    });
  }
  async setLongNick(longNick) {
    return this.context.session.getProfileService().setLongNick(longNick);
  }
  async setSelfOnlineStatus(status, extStatus, batteryStatus) {
    return this.context.session.getMsgService().setStatus({
      status,
      extStatus,
      batteryStatus
    });
  }
  async setDiySelfOnlineStatus(faceId, wording, faceType) {
    return this.context.session.getMsgService().setStatus({
      status: 10,
      extStatus: 2e3,
      customStatus: { faceId, wording, faceType },
      batteryStatus: 0
    });
  }
  async getBuddyRecommendContactArkJson(uin, sencenID = "") {
    return this.context.session.getBuddyService().getBuddyRecommendContactArkJson(uin, sencenID);
  }
  async like(uid, count = 1) {
    return this.context.session.getProfileLikeService().setBuddyProfileLike({
      friendUid: uid,
      sourceId: 71,
      doLikeCount: count,
      doLikeTollCount: 0
    });
  }
  async setQQAvatar(filePath) {
    const ret = await this.context.session.getProfileService().setHeader(filePath);
    return { result: ret?.result, errMsg: ret?.errMsg };
  }
  async setGroupAvatar(gc, filePath) {
    return this.context.session.getGroupService().setHeader(gc, filePath);
  }
  async fetchUserDetailInfo(uid, mode = UserDetailSource.KDB) {
    const [, profile] = await this.core.eventWrapper.callNormalEventV2(
      "NodeIKernelProfileService/fetchUserDetailInfo",
      "NodeIKernelProfileListener/onUserDetailInfoChanged",
      [
        "BuddyProfileStore",
        [uid],
        mode,
        [ProfileBizType.KALL]
      ],
      () => true,
      (profile2) => profile2.uid === uid
    );
    return profile;
  }
  async getUserDetailInfo(uid, no_cache = false) {
    let profile = await solveAsyncProblem(async (uid2) => this.fetchUserDetailInfo(uid2, no_cache ? UserDetailSource.KSERVER : UserDetailSource.KDB), uid);
    if (profile && profile.uin !== "0" && profile.commonExt) {
      return {
        ...profile.simpleInfo.status,
        ...profile.simpleInfo.vasInfo,
        ...profile.commonExt,
        ...profile.simpleInfo.baseInfo,
        ...profile.simpleInfo.coreInfo,
        qqLevel: profile.commonExt?.qqLevel,
        age: profile.simpleInfo.baseInfo.age,
        pendantId: "",
        nick: profile.simpleInfo.coreInfo.nick || ""
      };
    }
    this.context.logger.logDebug("[NapCat] [Mark] getUserDetailInfo Mode1 Failed.");
    profile = await this.fetchUserDetailInfo(uid, UserDetailSource.KSERVER);
    if (profile && profile.uin === "0") {
      profile.uin = await this.core.apis.UserApi.getUidByUinV2(uid) ?? "0";
    }
    return {
      ...profile.simpleInfo.status,
      ...profile.simpleInfo.vasInfo,
      ...profile.commonExt,
      ...profile.simpleInfo.baseInfo,
      ...profile.simpleInfo.coreInfo,
      qqLevel: profile.commonExt?.qqLevel,
      age: profile.simpleInfo.baseInfo.age,
      pendantId: "",
      nick: profile.simpleInfo.coreInfo.nick || ""
    };
  }
  async modifySelfProfile(param) {
    return this.context.session.getProfileService().modifyDesktopMiniProfile(param);
  }
  async getCookies(domain) {
    const ClientKeyData = await this.forceFetchClientKey();
    const requestUrl = "https://ssl.ptlogin2.qq.com/jump?ptlang=1033&clientuin=" + this.core.selfInfo.uin + "&clientkey=" + ClientKeyData.clientKey + "&u1=https%3A%2F%2F" + domain + "%2F" + this.core.selfInfo.uin + "%2Finfocenter&keyindex=19%27";
    const data = await RequestUtil.HttpsGetCookies(requestUrl);
    if (!data["p_skey"] || data["p_skey"].length === 0) {
      try {
        const pskey = (await this.getPSkey([domain])).domainPskeyMap.get(domain);
        if (pskey) data["p_skey"] = pskey;
      } catch {
        return data;
      }
    }
    return data;
  }
  async getPSkey(domainList) {
    return await this.context.session.getTipOffService().getPskey(domainList, true);
  }
  async getRobotUinRange() {
    const robotUinRanges = await this.context.session.getRobotService().getRobotUinRange({
      justFetchMsgConfig: "1",
      type: 1,
      version: 0,
      aioKeywordVersion: 0
    });
    return robotUinRanges?.response?.robotUinRanges;
  }
  // 需要异常处理
  async getQzoneCookies() {
    const ClientKeyData = await this.forceFetchClientKey();
    const requestUrl = "https://ssl.ptlogin2.qq.com/jump?ptlang=1033&clientuin=" + this.core.selfInfo.uin + "&clientkey=" + ClientKeyData.clientKey + "&u1=https%3A%2F%2Fuser.qzone.qq.com%2F" + this.core.selfInfo.uin + "%2Finfocenter&keyindex=19%27";
    return await RequestUtil.HttpsGetCookies(requestUrl);
  }
  // 需要异常处理
  async getSKey() {
    const ClientKeyData = await this.forceFetchClientKey();
    if (ClientKeyData.result !== 0) {
      throw new Error("getClientKey Error");
    }
    const clientKey = ClientKeyData.clientKey;
    const requestUrl = "https://ssl.ptlogin2.qq.com/jump?ptlang=1033&clientuin=" + this.core.selfInfo.uin + "&clientkey=" + clientKey + "&u1=https%3A%2F%2Fh5.qzone.qq.com%2Fqqnt%2Fqzoneinpcqq%2Ffriend%3Frefresh%3D0%26clientuin%3D0%26darkMode%3D0&keyindex=19%27";
    const cookies = await RequestUtil.HttpsGetCookies(requestUrl);
    const skey = cookies["skey"];
    if (!skey) {
      throw new Error("SKey is Empty");
    }
    return skey;
  }
  async getUidByUinV2(uin) {
    if (!uin) {
      return "";
    }
    const fallback = new Fallback((uid2) => FallbackUtil.boolchecker(uid2, uid2 !== void 0 && uid2.indexOf("*") === -1 && uid2 !== "")).add(() => this.context.session.getUixConvertService().getUid([uin]).then((data) => data.uidInfo.get(uin))).add(() => this.context.session.getProfileService().getUidByUin("FriendsServiceImpl", [uin]).get(uin)).add(() => this.context.session.getGroupService().getUidByUins([uin]).then((data) => data.uids.get(uin))).add(() => this.getUserDetailInfoByUin(uin).then((data) => data.detail.uid));
    const uid = await fallback.run().catch(() => "");
    return uid ?? "";
  }
  async getUinByUidV2(uid) {
    if (!uid) {
      return "0";
    }
    const fallback = new Fallback((uin2) => FallbackUtil.boolchecker(uin2, uin2 !== void 0 && uin2 !== "0" && uin2 !== "")).add(() => this.context.session.getUixConvertService().getUin([uid]).then((data) => data.uinInfo.get(uid))).add(() => this.context.session.getProfileService().getUinByUid("FriendsServiceImpl", [uid]).get(uid)).add(() => this.context.session.getGroupService().getUinByUids([uid]).then((data) => data.uins.get(uid))).add(() => this.getUserDetailInfo(uid).then((data) => data.uin));
    const uin = await fallback.run().catch(() => "0");
    return uin ?? "0";
  }
  async getRecentContactListSnapShot(count) {
    return await this.context.session.getRecentContactService().getRecentContactListSnapShot(count);
  }
  async getRecentContactListSyncLimit(count) {
    return await this.context.session.getRecentContactService().getRecentContactListSyncLimit(count);
  }
  async getRecentContactListSync() {
    return await this.context.session.getRecentContactService().getRecentContactListSync();
  }
  async getRecentContactList() {
    return await this.context.session.getRecentContactService().getRecentContactList();
  }
  async getUserDetailInfoByUin(Uin) {
    return await this.core.eventWrapper.callNoListenerEvent(
      "NodeIKernelProfileService/getUserDetailInfoByUin",
      Uin
    );
  }
  async forceFetchClientKey() {
    return await this.context.session.getTicketService().forceFetchClientKey("");
  }
}

function qunAlbumControl({
  uin,
  group_id,
  pskey,
  pic_md5,
  img_size,
  img_name,
  sAlbumName,
  sAlbumID,
  photo_num = "1",
  video_num = "0",
  batch_num = "1"
}) {
  const timestamp = Math.floor(Date.now() / 1e3);
  return {
    control_req: [
      {
        uin,
        token: {
          type: 4,
          data: pskey,
          appid: 5
        },
        appid: "qun",
        checksum: pic_md5,
        check_type: 0,
        file_len: img_size,
        env: {
          refer: "qzone",
          deviceInfo: "h5"
        },
        model: 0,
        biz_req: {
          sPicTitle: img_name,
          sPicDesc: "",
          sAlbumName,
          sAlbumID,
          iAlbumTypeID: 0,
          iBitmap: 0,
          iUploadType: 0,
          iUpPicType: 0,
          iBatchID: timestamp,
          sPicPath: "",
          iPicWidth: 0,
          iPicHight: 0,
          iWaterType: 0,
          iDistinctUse: 0,
          iNeedFeeds: 1,
          iUploadTime: timestamp,
          mapExt: {
            appid: "qun",
            userid: group_id
          },
          stExtendInfo: {
            mapParams: {
              photo_num,
              video_num,
              batch_num
            }
          }
        },
        session: "",
        asy_upload: 0,
        cmd: "FileUpload"
      }
    ]
  };
}

function createAlbumMediaFeed(uin, albumId, lloc) {
  return {
    cell_common: {
      time: ""
    },
    cell_user_info: {
      user: {
        uin
      }
    },
    cell_media: {
      album_id: albumId,
      batch_id: "",
      media_items: [{
        image: {
          lloc
        }
      }]
    }
  };
}
function createAlbumCommentRequest(uin, content, client_key) {
  return {
    client_key,
    // 暂时只支持纯文本吧
    content: [{
      type: 0 /* KRICHMSGTYPEPLAINTEXT */,
      content,
      who: 0,
      uid: "",
      name: "",
      url: ""
    }],
    user: {
      uin
    }
  };
}
function createAlbumFeedPublish(qunId, uin, albumId, lloc, sloc) {
  return {
    cell_common: {
      time: Date.now(),
      feed_id: ""
    },
    cell_user_info: {
      user: {
        uin
      }
    },
    cell_media: {
      album_id: albumId,
      batch_id: 0,
      media_items: [{
        type: 0,
        image: {
          lloc,
          sloc: sloc || lloc
        }
      }]
    },
    cell_qun_info: {
      qun_id: qunId
    }
  };
}

class NTQQWebApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async shareDigest(groupCode, msgSeq, msgRandom, targetGroupCode) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const url = `https://qun.qq.com/cgi-bin/group_digest/share_digest?${new URLSearchParams({
      bkn: this.getBknFromCookie(cookieObject),
      group_code: groupCode,
      msg_seq: msgSeq,
      msg_random: msgRandom,
      target_group_code: targetGroupCode
    }).toString()}`;
    try {
      return RequestUtil.HttpGetText(url, "GET", "", { Cookie: this.cookieToString(cookieObject) });
    } catch {
      return void 0;
    }
  }
  async getGroupEssenceMsgAll(GroupCode) {
    const ret = [];
    for (let i = 0; i < 20; i++) {
      const data = await this.getGroupEssenceMsg(GroupCode, i, 50);
      if (!data) break;
      ret.push(data);
      if (data.data.is_end) break;
    }
    return ret;
  }
  async getGroupEssenceMsg(GroupCode, page_start = 0, page_limit = 50) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const url = `https://qun.qq.com/cgi-bin/group_digest/digest_list?${new URLSearchParams({
      bkn: this.getBknFromCookie(cookieObject),
      page_start: page_start.toString(),
      page_limit: page_limit.toString(),
      group_code: GroupCode
    }).toString()}`;
    try {
      const ret = await RequestUtil.HttpGetJson(
        url,
        "GET",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      return ret.retcode === 0 ? ret : void 0;
    } catch {
      return void 0;
    }
  }
  async getGroupMembers(GroupCode) {
    const memberData = new Array();
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const retList = [];
    const fastRet = await RequestUtil.HttpGetJson(
      `https://qun.qq.com/cgi-bin/qun_mgr/search_group_members?${new URLSearchParams({
        st: "0",
        end: "40",
        sort: "1",
        gc: GroupCode,
        bkn: this.getBknFromCookie(cookieObject)
      }).toString()}`,
      "POST",
      "",
      { Cookie: this.cookieToString(cookieObject) }
    );
    if (!fastRet?.count || fastRet?.errcode !== 0 || !fastRet?.mems) {
      return [];
    } else {
      for (const key in fastRet.mems) {
        if (fastRet.mems[key]) {
          memberData.push(fastRet.mems[key]);
        }
      }
    }
    const PageNum = Math.ceil(fastRet.count / 40);
    for (let i = 2; i <= PageNum; i++) {
      const ret = RequestUtil.HttpGetJson(
        `https://qun.qq.com/cgi-bin/qun_mgr/search_group_members?${new URLSearchParams({
          st: ((i - 1) * 40).toString(),
          end: (i * 40).toString(),
          sort: "1",
          gc: GroupCode,
          bkn: this.getBknFromCookie(cookieObject)
        }).toString()}`,
        "POST",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      retList.push(ret);
    }
    for (let i = 1; i <= PageNum; i++) {
      const ret = await retList[i];
      if (!ret?.count || ret?.errcode !== 0 || !ret?.mems) {
        continue;
      }
      for (const key in ret.mems) {
        if (ret.mems[key]) {
          memberData.push(ret.mems[key]);
        }
      }
    }
    return memberData;
  }
  // public  async addGroupDigest(groupCode: string, msgSeq: string) {
  //   const url = `https://qun.qq.com/cgi-bin/group_digest/cancel_digest?random=665&X-CROSS-ORIGIN=fetch&group_code=${groupCode}&msg_seq=${msgSeq}&msg_random=444021292`;
  //   const res = await this.request(url);
  //   return await res.json();
  // }
  // public async getGroupDigest(groupCode: string) {
  //   const url = `https://qun.qq.com/cgi-bin/group_digest/digest_list?random=665&X-CROSS-ORIGIN=fetch&group_code=${groupCode}&page_start=0&page_limit=20`;
  //   const res = await this.request(url);
  //   return await res.json();
  // }
  async setGroupNotice(GroupCode, Content, pinned = 0, type = 1, is_show_edit_card = 1, tip_window_type = 1, confirm_required = 1, picId = "", imgWidth = 540, imgHeight = 300) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    try {
      const settings = JSON.stringify({
        is_show_edit_card,
        tip_window_type,
        confirm_required
      });
      const externalParam = {
        pic: picId,
        imgWidth: imgWidth.toString(),
        imgHeight: imgHeight.toString()
      };
      const ret = await RequestUtil.HttpGetJson(
        `https://web.qun.qq.com/cgi-bin/announce/add_qun_notice?${new URLSearchParams({
          bkn: this.getBknFromCookie(cookieObject),
          qid: GroupCode,
          text: Content,
          pinned: pinned.toString(),
          type: type.toString(),
          settings,
          ...picId === "" ? {} : externalParam
        }).toString()}`,
        "POST",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      return ret;
    } catch {
      return void 0;
    }
  }
  async getGroupNotice(GroupCode) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    try {
      const ret = await RequestUtil.HttpGetJson(
        `https://web.qun.qq.com/cgi-bin/announce/get_t_list?${new URLSearchParams({
          bkn: this.getBknFromCookie(cookieObject),
          qid: GroupCode,
          ft: "23",
          ni: "1",
          n: "1",
          i: "1",
          log_read: "1",
          platform: "1",
          s: "-1"
        }).toString()}&n=20`,
        "GET",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      return ret?.ec === 0 ? ret : void 0;
    } catch {
      return void 0;
    }
  }
  async getDataInternal(cookieObject, groupCode, type) {
    let resJson;
    try {
      const res = await RequestUtil.HttpGetText(
        `https://qun.qq.com/interactive/honorlist?${new URLSearchParams({
          gc: groupCode,
          type: type.toString()
        }).toString()}`,
        "GET",
        "",
        { Cookie: this.cookieToString(cookieObject) }
      );
      const match = /window\.__INITIAL_STATE__=(.*?);/.exec(res);
      if (match?.[1]) {
        resJson = JSON.parse(match[1].trim());
      }
      return type === 1 ? resJson?.talkativeList : resJson?.actorList;
    } catch (e) {
      this.context.logger.logDebug("获取当前群荣耀失败", e);
      return void 0;
    }
  }
  async getHonorList(cookieObject, groupCode, type) {
    const data = await this.getDataInternal(cookieObject, groupCode, type);
    if (!data) {
      this.context.logger.logError(`获取类型 ${type} 的荣誉信息失败`);
      return [];
    }
    return data.map((item) => ({
      user_id: item?.uin,
      nickname: item?.name,
      avatar: item?.avatar,
      description: item?.desc
    }));
  }
  async getGroupHonorInfo(groupCode, getType) {
    const cookieObject = await this.core.apis.UserApi.getCookies("qun.qq.com");
    const HonorInfo = {
      group_id: Number(groupCode),
      current_talkative: {},
      talkative_list: [],
      performer_list: [],
      legend_list: [],
      emotion_list: [],
      strong_newbie_list: []
    };
    if (getType === WebHonorType.TALKATIVE || getType === WebHonorType.ALL) {
      const talkativeList = await this.getHonorList(cookieObject, groupCode, 1);
      if (talkativeList.length > 0) {
        HonorInfo.current_talkative = talkativeList[0];
        HonorInfo.talkative_list = talkativeList;
      }
    }
    if (getType === WebHonorType.PERFORMER || getType === WebHonorType.ALL) {
      HonorInfo.performer_list = await this.getHonorList(cookieObject, groupCode, 2);
    }
    if (getType === WebHonorType.LEGEND || getType === WebHonorType.ALL) {
      HonorInfo.legend_list = await this.getHonorList(cookieObject, groupCode, 3);
    }
    if (getType === WebHonorType.EMOTION || getType === WebHonorType.ALL) {
      HonorInfo.emotion_list = await this.getHonorList(cookieObject, groupCode, 6);
    }
    if (getType === WebHonorType.EMOTION || getType === WebHonorType.ALL) {
      HonorInfo.strong_newbie_list = [];
    }
    return HonorInfo;
  }
  cookieToString(cookieObject) {
    return Object.entries(cookieObject).map(([key, value]) => `${key}=${value}`).join("; ");
  }
  getBknFromCookie(cookieObject) {
    const sKey = cookieObject["skey"];
    let hash = 5381;
    for (let i = 0; i < sKey.length; i++) {
      const code = sKey.charCodeAt(i);
      hash = hash + (hash << 5) + code;
    }
    return (hash & 2147483647).toString();
  }
  getBknFromSKey(sKey) {
    let hash = 5381;
    for (let i = 0; i < sKey.length; i++) {
      const code = sKey.charCodeAt(i);
      hash = hash + (hash << 5) + code;
    }
    return (hash & 2147483647).toString();
  }
  async getAlbumListByNTQQ(gc) {
    return await this.context.session.getAlbumService().getAlbumList({
      qun_id: gc,
      attach_info: "",
      seq: 3331,
      request_time_line: {
        request_invoke_time: "0"
      }
    });
  }
  async getAlbumList(gc) {
    const skey = await this.core.apis.UserApi.getSKey() || "";
    const pskey = (await this.core.apis.UserApi.getPSkey(["qzone.qq.com"])).domainPskeyMap.get("qzone.qq.com") || "";
    const bkn = this.getBknFromSKey(skey);
    const uin = this.core.selfInfo.uin || "10001";
    const cookies = `p_uin=o${this.core.selfInfo.uin}; p_skey=${pskey}; skey=${skey}; uin=o${uin} `;
    const api = "https://h5.qzone.qq.com/proxy/domain/u.photo.qzone.qq.com/cgi-bin/upp/qun_list_album_v2?";
    const params = new URLSearchParams({
      random: "7570",
      g_tk: bkn,
      format: "json",
      inCharset: "utf-8",
      outCharset: "utf-8",
      qua: "V1_IPH_SQ_6.2.0_0_HDBM_T",
      cmd: "qunGetAlbumList",
      qunId: gc,
      qunid: gc,
      start: "0",
      num: "1000",
      uin,
      getMemberRole: "0"
    });
    const response = await RequestUtil.HttpGetJson(api + params.toString(), "GET", "", {
      Cookie: cookies
    });
    return response.data.album;
  }
  async createQunAlbumSession(gc, sAlbumID, sAlbumName, path, skey, pskey, img_md5, uin) {
    const img = readFileSync(path);
    const img_size = img.length;
    const img_name = basename(path);
    const GTK = this.getBknFromSKey(skey);
    const cookie = `p_uin=o${uin}; p_skey=${pskey}; skey=${skey}; uin=o${uin}`;
    const body = qunAlbumControl({
      uin,
      group_id: gc,
      pskey,
      pic_md5: img_md5,
      img_size,
      img_name,
      sAlbumName,
      sAlbumID
    });
    const api = `https://h5.qzone.qq.com/webapp/json/sliceUpload/FileBatchControl/${img_md5}?g_tk=${GTK}`;
    const post = await RequestUtil.HttpGetJson(api, "POST", body, {
      Cookie: cookie,
      "Content-Type": "application/json"
    });
    return post;
  }
  async uploadQunAlbumSlice(path, session, skey, pskey, uin, slice_size) {
    const img_size = statSync(path).size;
    let seq = 0;
    let offset = 0;
    const GTK = this.getBknFromSKey(skey);
    const cookie = `p_uin=o${uin}; p_skey=${pskey}; skey=${skey}; uin=o${uin}`;
    const stream = createReadStream(path, { highWaterMark: slice_size });
    for await (const chunk of stream) {
      const end = Math.min(offset + chunk.length, img_size);
      const form = new FormData();
      form.append("uin", uin);
      form.append("appid", "qun");
      form.append("session", session);
      form.append("offset", offset.toString());
      form.append("data", new Blob([chunk], { type: "application/octet-stream" }), "blob");
      form.append("checksum", "");
      form.append("check_type", "0");
      form.append("retry", "0");
      form.append("seq", seq.toString());
      form.append("end", end.toString());
      form.append("cmd", "FileUpload");
      form.append("slice_size", slice_size.toString());
      form.append("biz_req.iUploadType", "0");
      const api = `https://h5.qzone.qq.com/webapp/json/sliceUpload/FileUpload?seq=${seq}&retry=0&offset=${offset}&end=${end}&total=${img_size}&type=form&g_tk=${GTK}`;
      const response = await fetch(api, {
        method: "POST",
        headers: {
          Cookie: cookie
        },
        body: form
      });
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }
      const post = await response.json();
      if (post.ret !== 0) {
        throw new Error(`分片 ${seq} 上传失败: ${post.msg}`);
      }
      offset += chunk.length;
      seq++;
    }
    return { success: true, message: "上传完成" };
  }
  async uploadImageToQunAlbum(gc, sAlbumID, sAlbumName, path) {
    const skey = await this.core.apis.UserApi.getSKey() || "";
    const pskey = (await this.core.apis.UserApi.getPSkey(["qzone.qq.com"])).domainPskeyMap.get("qzone.qq.com") || "";
    const img_md5 = createHash("md5").update(readFileSync(path)).digest("hex");
    const uin = this.core.selfInfo.uin || "10001";
    const session = (await this.createQunAlbumSession(gc, sAlbumID, sAlbumName, path, skey, pskey, img_md5, uin)).data.session;
    if (!session) throw new Error("创建群相册会话失败");
    await this.uploadQunAlbumSlice(path, session, skey, pskey, uin, 16384);
  }
  async getAlbumMediaListByNTQQ(gc, albumId, attach_info = "") {
    return (await this.context.session.getAlbumService().getMediaList({
      qun_id: gc,
      attach_info,
      seq: 0,
      request_time_line: {
        request_invoke_time: "0"
      },
      album_id: albumId,
      lloc: "",
      batch_id: ""
    })).response;
  }
  async doAlbumMediaPlainCommentByNTQQ(qunId, albumId, lloc, content) {
    const random_seq = Math.floor(Math.random() * 9e3) + 1e3;
    const uin = this.core.selfInfo.uin || "10001";
    const client_key = Date.now() * 1e3;
    return await this.context.session.getAlbumService().doQunComment(
      random_seq,
      {
        map_info: [],
        map_bytes_info: [],
        map_user_account: []
      },
      qunId,
      2,
      createAlbumMediaFeed(uin, albumId, lloc),
      createAlbumCommentRequest(uin, content, client_key)
    );
  }
  async deleteAlbumMediaByNTQQ(qunId, albumId, lloc) {
    const random_seq = Math.floor(Math.random() * 9e3) + 1e3;
    return await this.context.session.getAlbumService().deleteMedias(
      random_seq,
      qunId,
      albumId,
      [lloc],
      []
    );
  }
  async doAlbumMediaLikeByNTQQ(qunId, albumId, lloc, id) {
    const random_seq = Math.floor(Math.random() * 9e3) + 1e3;
    const uin = this.core.selfInfo.uin || "10001";
    return await this.context.session.getAlbumService().doQunLike(
      random_seq,
      {
        map_info: [],
        map_bytes_info: [],
        map_user_account: []
      },
      {
        id,
        status: 1
      },
      createAlbumFeedPublish(qunId, uin, albumId, lloc)
    );
  }
}

class NTQQSystemApi {
  context;
  core;
  constructor(context, core) {
    this.context = context;
    this.core = core;
  }
  async hasOtherRunningQQProcess() {
    return this.core.util.hasOtherRunningQQProcess();
  }
  async ocrImage(filePath) {
    return this.context.session.getNodeMiscService().wantWinScreenOCR(filePath);
  }
  async translateEnWordToZn(words) {
    return this.context.session.getRichMediaService().translateEnWordToZn(words);
  }
  async getOnlineDev() {
    this.context.session.getMsgService().getOnLineDev();
  }
  async getArkJsonCollection() {
    return await this.core.eventWrapper.callNoListenerEvent("NodeIKernelCollectionService/collectionArkShare", "1717662698058");
  }
  async bootMiniApp(appFile, params) {
    await this.context.session.getNodeMiscService().setMiniAppVersion("2.16.4");
    return this.context.session.getNodeMiscService().startNewMiniApp(appFile, params);
  }
}

const offset$1 = {
  "9.9.22-40990-x64": {"send":"1B5699C","recv":"1D8CA9D"},
  "9.9.22-40824-x64": {"send":"1B5699C","recv":"1D8CA9D"},
  "9.9.22-40768-x64": {"send":"1B5699C","recv":"1D8CA9D"},
  "3.2.20-40768-x64": {"send":"2A1B840","recv":"2D28F20"},
  "3.2.20-40824-x64": {"send":"2A1B840","recv":"2D28F20"},
  "3.2.20-40990-x64": {"send":"2A1B840","recv":"2D28F20"},
  "3.2.20-40990-arm64": {"send":"157C0E8","recv":"1546658"},
  "3.2.20-40824-arm64": {"send":"157C0E8","recv":"1546658"},
  "3.2.20-40768-arm64": {"send":"157C0E8","recv":"1546658"},
  "9.9.23-41679-x64": {"send":"09FF0F4","recv":"1D1A039"},
  "6.9.82-40824-arm64": {"send":"05FA930","recv":"0B41B90"},
  "6.9.82-40768-arm64": {"send":"05FA930","recv":"0B41B90"},
  "6.9.82-40990-arm64": {"send":"05FA930","recv":"0B41B90"},
  "6.9.83-41679-arm64": {"send":"237D114","recv":"0957648"},
  "6.9.83-41785-arm64": {"send":"23B0BF0","recv":"095567C"},
  "9.9.23-41785-x64": {"send":"09FF0A4","recv":"1D19FF9"},
  "6.9.83-41857-arm64": {"send":"0815774","recv":"0958B3C"},
  "3.2.21-41857-x64": {"send":"5B44510","recv":"2FDB0B0"},
  "3.2.21-41857-arm64": {"send":"3D6EE6C","recv":"1479EDC"},
  "9.9.23-41857-x64": {"send":"0A01394","recv":"1D1C4F9"},
  "9.9.23-42086-x64": {"send":"0A01814","recv":"1D1C9B9"},
  "6.9.85-42086-arm64": {"send":"23B0330","recv":"0957648"},
  "3.2.21-42086-x64": {"send":"5B42CF0","recv":"2FDA6F0"},
  "9.9.23-42430-x64": {"send":"0A01A34","recv":"1D1CFF9"},
  "9.9.25-42744-x64": {"send":"0A0D104","recv":"1D3E7F9"},
  "6.9.85-42744-arm64": {"send":"23DFEF0","recv":"095FD80"},
  "9.9.25-42905-x64": {"send":"0A12E74","recv":"1D450FD"},
  "6.9.86-42905-arm64": {"send":"2342408","recv":"09639B8"},
  "3.2.22-42941-x64": {"send":"5BC1630","recv":"3011E00"},
  "3.2.22-42941-arm64": {"send":"3DC90AC","recv":"1497A70"},
  "9.9.25-42941-x64": {"send":"0A131D4","recv":"1D4547D"},
  "6.9.86-42941-arm64": {"send":"2346108","recv":"09675F0"},
};

class Frame {
  static pack(head, body) {
    const totalLength = 9 + head.length + body.length + 1;
    const buffer = Buffer.allocUnsafe(totalLength);
    buffer[0] = 40;
    buffer.writeUInt32BE(head.length, 1);
    buffer.writeUInt32BE(body.length, 5);
    head.copy(buffer, 9);
    body.copy(buffer, 9 + head.length);
    buffer[totalLength - 1] = 41;
    return buffer;
  }
  static unpack(frame) {
    assert$1(frame[0] === 40 && frame[frame.length - 1] === 41, "Invalid frame!");
    const headLen = frame.readUInt32BE(1);
    const bodyLen = frame.readUInt32BE(5);
    return [frame.subarray(9, 9 + headLen), frame.subarray(9 + headLen, 9 + headLen + bodyLen)];
  }
}

({
  selfUin: ProtoField(2, ScalarType.UINT32),
  subCmd: ProtoField(3, ScalarType.UINT32),
  field6: ProtoField(6, ScalarType.UINT32)
});
({
  imPlat: ProtoField(1, ScalarType.UINT32),
  osVersion: ProtoField(2, ScalarType.STRING, true),
  qVersion: ProtoField(3, ScalarType.STRING, true)
});
({
  retCode: ProtoField(1, ScalarType.UINT32),
  errMsg: ProtoField(2, ScalarType.STRING),
  subCmd: ProtoField(3, ScalarType.UINT32)});
({
  fileName: ProtoField(1, ScalarType.STRING, false, true),
  deleteFile: ProtoField(2, ScalarType.STRING, false, true),
  bid: ProtoField(3, ScalarType.STRING),
  maxRoamSize: ProtoField(4, ScalarType.UINT32),
  emojiType: ProtoField(5, ScalarType.UINT32, false, true)
});
({
  state: ProtoField(1, ScalarType.INT32),
  sizeCache: ProtoField(2, ScalarType.INT32),
  unknownFields: ProtoField(3, ScalarType.BYTES),
  msgSeq: ProtoField(7, ScalarType.INT32),
  msgRand: ProtoField(8, ScalarType.INT32),
  syncCookie: ProtoField(9, ScalarType.BYTES),
  msgVia: ProtoField(10, ScalarType.INT32),
  dataStatist: ProtoField(11, ScalarType.INT32),
  multiSendSeq: ProtoField(13, ScalarType.INT32)
});
({
  result: ProtoField(1, ScalarType.INT32),
  errMsg: ProtoField(2, ScalarType.STRING, true),
  timestamp1: ProtoField(3, ScalarType.UINT32),
  field10: ProtoField(10, ScalarType.UINT32),
  groupSequence: ProtoField(11, ScalarType.UINT32, true),
  timestamp2: ProtoField(12, ScalarType.UINT32),
  privateSequence: ProtoField(14, ScalarType.UINT32)
});
({
  status: ProtoField(1, ScalarType.UINT32),
  extStatus: ProtoField(2, ScalarType.UINT32),
  batteryStatus: ProtoField(3, ScalarType.UINT32)});
({
  faceId: ProtoField(1, ScalarType.UINT32),
  text: ProtoField(2, ScalarType.STRING, true),
  field3: ProtoField(3, ScalarType.UINT32)
});
({
  message: ProtoField(2, ScalarType.STRING)
});
const HttpConn = {
  field1: ProtoField(1, ScalarType.INT32),
  field2: ProtoField(2, ScalarType.INT32),
  field3: ProtoField(3, ScalarType.INT32),
  field4: ProtoField(4, ScalarType.INT32),
  tgt: ProtoField(5, ScalarType.STRING),
  field6: ProtoField(6, ScalarType.INT32),
  serviceTypes: ProtoField(7, ScalarType.INT32, false, true),
  field9: ProtoField(9, ScalarType.INT32),
  field10: ProtoField(10, ScalarType.INT32),
  field11: ProtoField(11, ScalarType.INT32),
  ver: ProtoField(15, ScalarType.STRING)
};
const HttpConn0x6ff_501 = {
  httpConn: ProtoField(1281, () => HttpConn)
};
const HttpConn0x6ff_501Response = {
  httpConn: ProtoField(1281, () => HttpConnResponse)
};
const HttpConnResponse = {
  sigSession: ProtoField(1, ScalarType.BYTES),
  sessionKey: ProtoField(2, ScalarType.BYTES),
  serverInfos: ProtoField(3, () => ServerInfo, false, true)
};
const ServerAddr = {
  type: ProtoField(1, ScalarType.UINT32),
  ip: ProtoField(2, ScalarType.FIXED32),
  port: ProtoField(3, ScalarType.UINT32),
  area: ProtoField(4, ScalarType.UINT32)
};
const ServerInfo = {
  serviceType: ProtoField(1, ScalarType.UINT32),
  serverAddrs: ProtoField(2, () => ServerAddr, false, true)
};

const MiniAppAdaptShareInfoReq = {
  appId: ProtoField(2, ScalarType.STRING),
  body: ProtoField(4, () => MiniAppAdaptShareInfoReqBody)
};
const MiniAppAdaptShareInfoReqBody = {
  extInfo: ProtoField(1, () => ExtInfo),
  appid: ProtoField(2, ScalarType.STRING),
  title: ProtoField(3, ScalarType.STRING),
  desc: ProtoField(4, ScalarType.STRING),
  time: ProtoField(5, ScalarType.UINT64),
  scene: ProtoField(6, ScalarType.UINT32),
  templateType: ProtoField(7, ScalarType.UINT32),
  businessType: ProtoField(8, ScalarType.UINT32),
  picUrl: ProtoField(9, ScalarType.STRING),
  vidUrl: ProtoField(10, ScalarType.STRING),
  jumpUrl: ProtoField(11, ScalarType.STRING),
  iconUrl: ProtoField(12, ScalarType.STRING),
  verType: ProtoField(13, ScalarType.UINT32),
  shareType: ProtoField(14, ScalarType.UINT32),
  versionId: ProtoField(15, ScalarType.STRING),
  withShareTicket: ProtoField(16, ScalarType.UINT32),
  webURL: ProtoField(17, ScalarType.STRING),
  appidRich: ProtoField(18, ScalarType.BYTES),
  template: ProtoField(19, () => Template),
  field20: ProtoField(20, ScalarType.STRING)
};
const ExtInfo = {
  field2: ProtoField(2, ScalarType.BYTES)
};
const Template = {
  templateId: ProtoField(1, ScalarType.STRING),
  templateData: ProtoField(2, ScalarType.STRING)
};
const MiniAppAdaptShareInfoResp = {
  field2: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.STRING),
  content: ProtoField(4, () => MiniAppAdaptShareInfoRespContent)
};
const MiniAppAdaptShareInfoRespContent = {
  jsonContent: ProtoField(2, ScalarType.STRING)
};

const DataHighwayHead = {
  version: ProtoField(1, ScalarType.UINT32),
  uin: ProtoField(2, ScalarType.STRING, true),
  command: ProtoField(3, ScalarType.STRING, true),
  seq: ProtoField(4, ScalarType.UINT32, true),
  retryTimes: ProtoField(5, ScalarType.UINT32, true),
  appId: ProtoField(6, ScalarType.UINT32),
  dataFlag: ProtoField(7, ScalarType.UINT32),
  commandId: ProtoField(8, ScalarType.UINT32),
  buildVer: ProtoField(9, ScalarType.BYTES, true)
};
const FileUploadExt = {
  unknown1: ProtoField(1, ScalarType.INT32),
  unknown2: ProtoField(2, ScalarType.INT32),
  unknown3: ProtoField(3, ScalarType.INT32),
  entry: ProtoField(100, () => FileUploadEntry),
  unknown200: ProtoField(200, ScalarType.INT32)
};
const FileUploadEntry = {
  busiBuff: ProtoField(100, () => ExcitingBusiInfo),
  fileEntry: ProtoField(200, () => ExcitingFileEntry),
  clientInfo: ProtoField(300, () => ExcitingClientInfo),
  fileNameInfo: ProtoField(400, () => ExcitingFileNameInfo),
  host: ProtoField(500, () => ExcitingHostConfig)
};
const ExcitingBusiInfo = {
  busId: ProtoField(1, ScalarType.INT32),
  senderUin: ProtoField(100, ScalarType.UINT64),
  receiverUin: ProtoField(200, ScalarType.UINT64),
  groupCode: ProtoField(400, ScalarType.UINT64)
};
const ExcitingFileEntry = {
  fileSize: ProtoField(100, ScalarType.UINT64),
  md5: ProtoField(200, ScalarType.BYTES),
  checkKey: ProtoField(300, ScalarType.BYTES),
  md5S2: ProtoField(400, ScalarType.BYTES),
  fileId: ProtoField(600, ScalarType.STRING),
  uploadKey: ProtoField(700, ScalarType.BYTES)
};
const ExcitingClientInfo = {
  clientType: ProtoField(100, ScalarType.INT32),
  appId: ProtoField(200, ScalarType.STRING),
  terminalType: ProtoField(300, ScalarType.INT32),
  clientVer: ProtoField(400, ScalarType.STRING),
  unknown: ProtoField(600, ScalarType.INT32)
};
const ExcitingFileNameInfo = {
  fileName: ProtoField(100, ScalarType.STRING)
};
const ExcitingHostConfig = {
  hosts: ProtoField(200, () => ExcitingHostInfo, false, true)
};
const ExcitingHostInfo = {
  url: ProtoField(1, () => ExcitingUrlInfo),
  port: ProtoField(2, ScalarType.UINT32)
};
const ExcitingUrlInfo = {
  unknown: ProtoField(1, ScalarType.INT32),
  host: ProtoField(2, ScalarType.STRING)
};
const LoginSigHead = {
  uint32LoginSigType: ProtoField(1, ScalarType.UINT32),
  bytesLoginSig: ProtoField(2, ScalarType.BYTES),
  appId: ProtoField(3, ScalarType.UINT32)
};
const NTV2RichMediaHighwayExt = {
  fileUuid: ProtoField(1, ScalarType.STRING),
  uKey: ProtoField(2, ScalarType.STRING),
  network: ProtoField(5, () => NTHighwayNetwork),
  msgInfoBody: ProtoField(6, () => MsgInfoBody, false, true),
  blockSize: ProtoField(10, ScalarType.UINT32),
  hash: ProtoField(11, () => NTHighwayHash)
};
const NTHighwayHash = {
  fileSha1: ProtoField(1, ScalarType.BYTES, false, true)
};
const NTHighwayNetwork = {
  ipv4s: ProtoField(1, () => NTHighwayIPv4, false, true)
};
const NTHighwayIPv4 = {
  domain: ProtoField(1, () => NTHighwayDomain),
  port: ProtoField(2, ScalarType.UINT32)
};
const NTHighwayDomain = {
  isEnable: ProtoField(1, ScalarType.BOOL),
  ip: ProtoField(2, ScalarType.STRING)
};
const ReqDataHighwayHead = {
  msgBaseHead: ProtoField(1, () => DataHighwayHead, true),
  msgSegHead: ProtoField(2, () => SegHead, true),
  bytesReqExtendInfo: ProtoField(3, ScalarType.BYTES, true),
  timestamp: ProtoField(4, ScalarType.UINT64),
  msgLoginSigHead: ProtoField(5, () => LoginSigHead, true)
};
const RespDataHighwayHead = {
  msgBaseHead: ProtoField(1, () => DataHighwayHead, true),
  msgSegHead: ProtoField(2, () => SegHead, true),
  errorCode: ProtoField(3, ScalarType.UINT32),
  allowRetry: ProtoField(4, ScalarType.UINT32),
  cacheCost: ProtoField(5, ScalarType.UINT32),
  htCost: ProtoField(6, ScalarType.UINT32),
  bytesRspExtendInfo: ProtoField(7, ScalarType.BYTES, true),
  timestamp: ProtoField(8, ScalarType.UINT64),
  range: ProtoField(9, ScalarType.UINT64),
  isReset: ProtoField(10, ScalarType.UINT32)
};
const SegHead = {
  serviceId: ProtoField(1, ScalarType.UINT32, true),
  filesize: ProtoField(2, ScalarType.UINT64),
  dataOffset: ProtoField(3, ScalarType.UINT64, true),
  dataLength: ProtoField(4, ScalarType.UINT32),
  retCode: ProtoField(5, ScalarType.UINT32, true),
  serviceTicket: ProtoField(6, ScalarType.BYTES),
  flag: ProtoField(7, ScalarType.UINT32, true),
  md5: ProtoField(8, ScalarType.BYTES),
  fileMd5: ProtoField(9, ScalarType.BYTES),
  cacheAddr: ProtoField(10, ScalarType.UINT32, true),
  queryTimes: ProtoField(11, ScalarType.UINT32),
  updateCacheIp: ProtoField(12, ScalarType.UINT32),
  cachePort: ProtoField(13, ScalarType.UINT32, true)
};
({
  type: ProtoField(1, ScalarType.UINT32),
  groupUin: ProtoField(2, ScalarType.UINT32),
  field5: ProtoField(5, ScalarType.UINT32),
  field6: ProtoField(6, ScalarType.UINT32)
});
({
  field1: ProtoField(1, ScalarType.UINT32)
});

const LongMsgResult = {
  action: ProtoField(2, () => LongMsgAction, false, true)
};
const LongMsgAction = {
  actionCommand: ProtoField(1, ScalarType.STRING),
  actionData: ProtoField(2, () => LongMsgContent)
};
const LongMsgContent = {
  msgBody: ProtoField(1, () => PushMsgBody, false, true)
};
const RecvLongMsgReq = {
  info: ProtoField(1, () => RecvLongMsgInfo, true),
  settings: ProtoField(15, () => LongMsgSettings, true)
};
const RecvLongMsgInfo = {
  uid: ProtoField(1, () => LongMsgUid, true),
  resId: ProtoField(2, ScalarType.STRING, true),
  acquire: ProtoField(3, ScalarType.BOOL)
};
const LongMsgUid = {
  uid: ProtoField(2, ScalarType.STRING, true)
};
const LongMsgSettings = {
  field1: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32),
  field4: ProtoField(4, ScalarType.UINT32)
};
const RecvLongMsgResp = {
  result: ProtoField(1, () => RecvLongMsgResult),
  settings: ProtoField(15, () => LongMsgSettings)
};
const RecvLongMsgResult = {
  resId: ProtoField(3, ScalarType.STRING),
  payload: ProtoField(4, ScalarType.BYTES)
};
const SendLongMsgReq = {
  info: ProtoField(2, () => SendLongMsgInfo),
  settings: ProtoField(15, () => LongMsgSettings)
};
const SendLongMsgInfo = {
  type: ProtoField(1, ScalarType.UINT32),
  uid: ProtoField(2, () => LongMsgUid, true),
  groupUin: ProtoField(3, ScalarType.UINT32, true),
  payload: ProtoField(4, ScalarType.BYTES, true)
};
const SendLongMsgResp = {
  result: ProtoField(2, () => SendLongMsgResult),
  settings: ProtoField(15, () => LongMsgSettings)
};
const SendLongMsgResult = {
  resId: ProtoField(3, ScalarType.STRING)
};
const SsoGetGroupMsg = {
  info: ProtoField(1, () => SsoGetGroupMsgInfo),
  direction: ProtoField(2, ScalarType.BOOL)
};
const SsoGetGroupMsgInfo = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  startSequence: ProtoField(2, ScalarType.UINT32),
  endSequence: ProtoField(3, ScalarType.UINT32)
};
const SsoGetGroupMsgResponse = {
  body: ProtoField(3, () => SsoGetGroupMsgResponseBody)
};
const SsoGetGroupMsgResponseBody = {
  groupUin: ProtoField(3, ScalarType.UINT32),
  startSequence: ProtoField(4, ScalarType.UINT32),
  endSequence: ProtoField(5, ScalarType.UINT32),
  messages: ProtoField(6, () => PushMsgBody, false, true)
};
({
  friendUid: ProtoField(1, ScalarType.STRING, true),
  time: ProtoField(2, ScalarType.UINT32),
  random: ProtoField(3, ScalarType.UINT32),
  count: ProtoField(4, ScalarType.UINT32),
  direction: ProtoField(5, ScalarType.BOOL)
});
({
  friendUid: ProtoField(3, ScalarType.STRING),
  timestamp: ProtoField(5, ScalarType.UINT32),
  random: ProtoField(6, ScalarType.UINT32)});
const SsoGetC2cMsg = {
  friendUid: ProtoField(2, ScalarType.STRING, true),
  startSequence: ProtoField(3, ScalarType.UINT32),
  endSequence: ProtoField(4, ScalarType.UINT32)
};
const SsoGetC2cMsgResponse = {
  friendUid: ProtoField(4, ScalarType.STRING),
  messages: ProtoField(7, () => PushMsgBody, false, true)
};

({
  uin: ProtoField(1, ScalarType.UINT32, true),
  uid: ProtoField(2, ScalarType.STRING, true),
  field3: ProtoField(3, ScalarType.UINT32, true),
  sig: ProtoField(4, ScalarType.UINT32, true),
  receiverUin: ProtoField(5, ScalarType.UINT32, true),
  receiverUid: ProtoField(6, ScalarType.STRING, true)
});

const Attr = {
  codePage: ProtoField(1, ScalarType.INT32),
  time: ProtoField(2, ScalarType.INT32),
  random: ProtoField(3, ScalarType.INT32),
  color: ProtoField(4, ScalarType.INT32),
  size: ProtoField(5, ScalarType.INT32),
  effect: ProtoField(6, ScalarType.INT32),
  charSet: ProtoField(7, ScalarType.INT32),
  pitchAndFamily: ProtoField(8, ScalarType.INT32),
  fontName: ProtoField(9, ScalarType.STRING),
  reserveData: ProtoField(10, ScalarType.BYTES)
};
const NotOnlineFile = {
  fileType: ProtoField(1, ScalarType.INT32, true),
  sig: ProtoField(2, ScalarType.BYTES, true),
  fileUuid: ProtoField(3, ScalarType.STRING, true),
  fileMd5: ProtoField(4, ScalarType.BYTES, true),
  fileName: ProtoField(5, ScalarType.STRING, true),
  fileSize: ProtoField(6, ScalarType.INT64, true),
  note: ProtoField(7, ScalarType.BYTES, true),
  reserved: ProtoField(8, ScalarType.INT32, true),
  subcmd: ProtoField(9, ScalarType.INT32, true),
  microCloud: ProtoField(10, ScalarType.INT32, true),
  bytesFileUrls: ProtoField(11, ScalarType.BYTES, false, true),
  downloadFlag: ProtoField(12, ScalarType.INT32, true),
  dangerEvel: ProtoField(50, ScalarType.INT32, true),
  lifeTime: ProtoField(51, ScalarType.INT32, true),
  uploadTime: ProtoField(52, ScalarType.INT32, true),
  absFileType: ProtoField(53, ScalarType.INT32, true),
  clientType: ProtoField(54, ScalarType.INT32, true),
  expireTime: ProtoField(55, ScalarType.INT32, true),
  pbReserve: ProtoField(56, ScalarType.BYTES, true),
  fileHash: ProtoField(57, ScalarType.STRING, true)
};
const Ptt = {
  fileType: ProtoField(1, ScalarType.INT32),
  srcUin: ProtoField(2, ScalarType.UINT64),
  fileUuid: ProtoField(3, ScalarType.STRING),
  fileMd5: ProtoField(4, ScalarType.BYTES),
  fileName: ProtoField(5, ScalarType.STRING),
  fileSize: ProtoField(6, ScalarType.INT32),
  reserve: ProtoField(7, ScalarType.BYTES),
  fileId: ProtoField(8, ScalarType.INT32),
  serverIp: ProtoField(9, ScalarType.INT32),
  serverPort: ProtoField(10, ScalarType.INT32),
  boolValid: ProtoField(11, ScalarType.BOOL),
  signature: ProtoField(12, ScalarType.BYTES),
  shortcut: ProtoField(13, ScalarType.BYTES),
  fileKey: ProtoField(14, ScalarType.BYTES),
  magicPttIndex: ProtoField(15, ScalarType.INT32),
  voiceSwitch: ProtoField(16, ScalarType.INT32),
  pttUrl: ProtoField(17, ScalarType.BYTES),
  groupFileKey: ProtoField(18, ScalarType.STRING),
  time: ProtoField(19, ScalarType.INT32),
  downPara: ProtoField(20, ScalarType.BYTES),
  format: ProtoField(29, ScalarType.INT32),
  pbReserve: ProtoField(30, ScalarType.BYTES),
  bytesPttUrls: ProtoField(31, ScalarType.BYTES, false, true),
  downloadFlag: ProtoField(32, ScalarType.INT32)
};
const RichText = {
  attr: ProtoField(1, () => Attr, true),
  elems: ProtoField(2, () => Elem, false, true),
  notOnlineFile: ProtoField(3, () => NotOnlineFile, true),
  ptt: ProtoField(4, () => Ptt, true)
};
({
  id: ProtoField(1, ScalarType.STRING)});
({
  label: ProtoField(1, ScalarType.STRING),
  visitedLabel: ProtoField(2, ScalarType.STRING),
  style: ProtoField(3, ScalarType.INT32)
});
({
  type: ProtoField(1, ScalarType.INT32),
  unsupportTips: ProtoField(4, ScalarType.STRING),
  data: ProtoField(5, ScalarType.STRING),
  reply: ProtoField(7, ScalarType.BOOL),
  enter: ProtoField(8, ScalarType.BOOL)
});
({
  type: ProtoField(1, ScalarType.INT32),
  specifyRoleIds: ProtoField(2, ScalarType.STRING, false, true),
  specifyUserIds: ProtoField(3, ScalarType.STRING, false, true)
});
const FileExtra = {
  file: ProtoField(1, () => NotOnlineFile),
  field6: ProtoField(6, () => PrivateFileExtra)
};
const PrivateFileExtra = {
  field2: ProtoField(2, () => PrivateFileExtraField2)
};
const PrivateFileExtraField2 = {
  field1: ProtoField(1, ScalarType.UINT32),
  fileUuid: ProtoField(4, ScalarType.STRING),
  fileName: ProtoField(5, ScalarType.STRING),
  field6: ProtoField(6, ScalarType.UINT32),
  field7: ProtoField(7, ScalarType.BYTES),
  field8: ProtoField(8, ScalarType.BYTES),
  timestamp1: ProtoField(9, ScalarType.UINT32),
  fileHash: ProtoField(14, ScalarType.STRING),
  selfUid: ProtoField(15, ScalarType.STRING),
  destUid: ProtoField(16, ScalarType.STRING)
};
const GroupFileExtra = {
  field1: ProtoField(1, ScalarType.UINT32),
  fileName: ProtoField(2, ScalarType.STRING),
  display: ProtoField(3, ScalarType.STRING),
  inner: ProtoField(7, () => GroupFileExtraInner)
};
const GroupFileExtraInner = {
  info: ProtoField(2, () => GroupFileExtraInfo)
};
const GroupFileExtraInfo = {
  busId: ProtoField(1, ScalarType.UINT32),
  fileId: ProtoField(2, ScalarType.STRING),
  fileSize: ProtoField(3, ScalarType.UINT64),
  fileName: ProtoField(4, ScalarType.STRING),
  field5: ProtoField(5, ScalarType.UINT32),
  fileSha: ProtoField(6, ScalarType.BYTES),
  extInfoString: ProtoField(7, ScalarType.STRING),
  fileMd5: ProtoField(8, ScalarType.BYTES)
};
({
  origUrl: ProtoField(30, ScalarType.STRING)
});
({
  type: ProtoField(1, ScalarType.UINT32),
  field7: ProtoField(7, ScalarType.UINT32),
  field8: ProtoField(8, ScalarType.UINT32)
});

const Elem = {
  text: ProtoField(1, () => Text, true),
  face: ProtoField(2, () => Face, true),
  onlineImage: ProtoField(3, () => OnlineImage, true),
  notOnlineImage: ProtoField(4, () => NotOnlineImage, true),
  transElem: ProtoField(5, () => TransElem, true),
  marketFace: ProtoField(6, () => MarketFace, true),
  customFace: ProtoField(8, () => CustomFace, true),
  elemFlags2: ProtoField(9, () => ElemFlags2, true),
  richMsg: ProtoField(12, () => RichMsg, true),
  groupFile: ProtoField(13, () => GroupFile, true),
  extraInfo: ProtoField(16, () => ExtraInfo, true),
  videoFile: ProtoField(19, () => VideoFile, true),
  anonymousGroupMessage: ProtoField(21, () => AnonymousGroupMessage, true),
  customElem: ProtoField(31, () => CustomElem, true),
  generalFlags: ProtoField(37, () => GeneralFlags, true),
  srcMsg: ProtoField(45, () => SrcMsg, true),
  lightAppElem: ProtoField(51, () => LightAppElem, true),
  commonElem: ProtoField(53, () => CommonElem, true)
};
const Text = {
  str: ProtoField(1, ScalarType.STRING, true),
  lint: ProtoField(2, ScalarType.STRING, true),
  attr6Buf: ProtoField(3, ScalarType.BYTES, true),
  attr7Buf: ProtoField(4, ScalarType.BYTES, true),
  buf: ProtoField(11, ScalarType.BYTES, true),
  pbReserve: ProtoField(12, ScalarType.BYTES, true)
};
const Face = {
  index: ProtoField(1, ScalarType.INT32, true),
  old: ProtoField(2, ScalarType.BYTES, true),
  buf: ProtoField(11, ScalarType.BYTES, true)
};
const OnlineImage = {
  guid: ProtoField(1, ScalarType.BYTES),
  filePath: ProtoField(2, ScalarType.BYTES),
  oldVerSendFile: ProtoField(3, ScalarType.BYTES)
};
const NotOnlineImage = {
  filePath: ProtoField(1, ScalarType.STRING),
  fileLen: ProtoField(2, ScalarType.UINT32),
  downloadPath: ProtoField(3, ScalarType.STRING),
  oldVerSendFile: ProtoField(4, ScalarType.BYTES),
  imgType: ProtoField(5, ScalarType.INT32),
  previewsImage: ProtoField(6, ScalarType.BYTES),
  picMd5: ProtoField(7, ScalarType.BYTES),
  picHeight: ProtoField(8, ScalarType.UINT32),
  picWidth: ProtoField(9, ScalarType.UINT32),
  resId: ProtoField(10, ScalarType.STRING),
  flag: ProtoField(11, ScalarType.BYTES),
  thumbUrl: ProtoField(12, ScalarType.STRING),
  original: ProtoField(13, ScalarType.INT32),
  bigUrl: ProtoField(14, ScalarType.STRING),
  origUrl: ProtoField(15, ScalarType.STRING),
  bizType: ProtoField(16, ScalarType.INT32),
  result: ProtoField(17, ScalarType.INT32),
  index: ProtoField(18, ScalarType.INT32),
  opFaceBuf: ProtoField(19, ScalarType.BYTES),
  oldPicMd5: ProtoField(20, ScalarType.BOOL),
  thumbWidth: ProtoField(21, ScalarType.INT32),
  thumbHeight: ProtoField(22, ScalarType.INT32),
  fileId: ProtoField(23, ScalarType.INT32),
  showLen: ProtoField(24, ScalarType.UINT32),
  downloadLen: ProtoField(25, ScalarType.UINT32),
  x400Url: ProtoField(26, ScalarType.STRING),
  x400Width: ProtoField(27, ScalarType.INT32),
  x400Height: ProtoField(28, ScalarType.INT32),
  pbRes: ProtoField(29, () => NotOnlineImage_PbReserve)
};
const NotOnlineImage_PbReserve = {
  subType: ProtoField(1, ScalarType.INT32),
  field3: ProtoField(3, ScalarType.INT32),
  field4: ProtoField(4, ScalarType.INT32),
  summary: ProtoField(8, ScalarType.STRING),
  field10: ProtoField(10, ScalarType.INT32),
  field20: ProtoField(20, () => NotOnlineImage_PbReserve2),
  url: ProtoField(30, ScalarType.STRING),
  md5Str: ProtoField(31, ScalarType.STRING)
};
const NotOnlineImage_PbReserve2 = {
  field1: ProtoField(1, ScalarType.INT32),
  field2: ProtoField(2, ScalarType.STRING),
  field3: ProtoField(3, ScalarType.INT32),
  field4: ProtoField(4, ScalarType.INT32),
  field5: ProtoField(5, ScalarType.INT32),
  field7: ProtoField(7, ScalarType.STRING)
};
const TransElem = {
  elemType: ProtoField(1, ScalarType.INT32),
  elemValue: ProtoField(2, ScalarType.BYTES)
};
const MarketFace = {
  faceName: ProtoField(1, ScalarType.STRING),
  itemType: ProtoField(2, ScalarType.INT32),
  faceInfo: ProtoField(3, ScalarType.INT32),
  faceId: ProtoField(4, ScalarType.BYTES),
  tabId: ProtoField(5, ScalarType.INT32),
  subType: ProtoField(6, ScalarType.INT32),
  key: ProtoField(7, ScalarType.STRING),
  param: ProtoField(8, ScalarType.BYTES),
  mediaType: ProtoField(9, ScalarType.INT32),
  imageWidth: ProtoField(10, ScalarType.INT32),
  imageHeight: ProtoField(11, ScalarType.INT32),
  mobileparam: ProtoField(12, ScalarType.BYTES),
  pbReserve: ProtoField(13, () => MarketFacePbRes)
};
const MarketFacePbRes = {
  field8: ProtoField(8, ScalarType.INT32)
};
const CustomFace = {
  guid: ProtoField(1, ScalarType.BYTES),
  filePath: ProtoField(2, ScalarType.STRING),
  shortcut: ProtoField(3, ScalarType.STRING),
  buffer: ProtoField(4, ScalarType.BYTES),
  flag: ProtoField(5, ScalarType.BYTES),
  oldData: ProtoField(6, ScalarType.BYTES, true),
  fileId: ProtoField(7, ScalarType.UINT32),
  serverIp: ProtoField(8, ScalarType.INT32, true),
  serverPort: ProtoField(9, ScalarType.INT32, true),
  fileType: ProtoField(10, ScalarType.INT32),
  signature: ProtoField(11, ScalarType.BYTES),
  useful: ProtoField(12, ScalarType.INT32),
  md5: ProtoField(13, ScalarType.BYTES),
  thumbUrl: ProtoField(14, ScalarType.STRING),
  bigUrl: ProtoField(15, ScalarType.STRING),
  origUrl: ProtoField(16, ScalarType.STRING),
  bizType: ProtoField(17, ScalarType.INT32),
  repeatIndex: ProtoField(18, ScalarType.INT32),
  repeatImage: ProtoField(19, ScalarType.INT32),
  imageType: ProtoField(20, ScalarType.INT32),
  index: ProtoField(21, ScalarType.INT32),
  width: ProtoField(22, ScalarType.INT32),
  height: ProtoField(23, ScalarType.INT32),
  source: ProtoField(24, ScalarType.INT32),
  size: ProtoField(25, ScalarType.UINT32),
  origin: ProtoField(26, ScalarType.INT32),
  thumbWidth: ProtoField(27, ScalarType.INT32, true),
  thumbHeight: ProtoField(28, ScalarType.INT32, true),
  showLen: ProtoField(29, ScalarType.INT32),
  downloadLen: ProtoField(30, ScalarType.INT32),
  x400Url: ProtoField(31, ScalarType.STRING, true),
  x400Width: ProtoField(32, ScalarType.INT32),
  x400Height: ProtoField(33, ScalarType.INT32),
  pbRes: ProtoField(34, () => CustomFace_PbReserve, true)
};
const CustomFace_PbReserve = {
  subType: ProtoField(1, ScalarType.INT32),
  summary: ProtoField(9, ScalarType.STRING)
};
const ElemFlags2 = {
  colorTextId: ProtoField(1, ScalarType.UINT32),
  msgId: ProtoField(2, ScalarType.UINT64),
  whisperSessionId: ProtoField(3, ScalarType.UINT32),
  pttChangeBit: ProtoField(4, ScalarType.UINT32),
  vipStatus: ProtoField(5, ScalarType.UINT32),
  compatibleId: ProtoField(6, ScalarType.UINT32),
  insts: ProtoField(7, () => Instance, false, true),
  msgRptCnt: ProtoField(8, ScalarType.UINT32),
  srcInst: ProtoField(9, () => Instance),
  longtitude: ProtoField(10, ScalarType.UINT32),
  latitude: ProtoField(11, ScalarType.UINT32),
  customFont: ProtoField(12, ScalarType.UINT32),
  pcSupportDef: ProtoField(13, () => PcSupportDef),
  crmFlags: ProtoField(14, ScalarType.UINT32, true)
};
const PcSupportDef = {
  pcPtlBegin: ProtoField(1, ScalarType.UINT32),
  pcPtlEnd: ProtoField(2, ScalarType.UINT32),
  macPtlBegin: ProtoField(3, ScalarType.UINT32),
  macPtlEnd: ProtoField(4, ScalarType.UINT32),
  ptlsSupport: ProtoField(5, ScalarType.INT32, false, true),
  ptlsNotSupport: ProtoField(6, ScalarType.UINT32, false, true)
};
const Instance = {
  appId: ProtoField(1, ScalarType.UINT32),
  instId: ProtoField(2, ScalarType.UINT32)
};
const RichMsg = {
  template1: ProtoField(1, ScalarType.BYTES, true),
  serviceId: ProtoField(2, ScalarType.INT32, true),
  msgResId: ProtoField(3, ScalarType.BYTES, true),
  rand: ProtoField(4, ScalarType.INT32, true),
  seq: ProtoField(5, ScalarType.UINT32, true)
};
const GroupFile = {
  filename: ProtoField(1, ScalarType.BYTES),
  fileSize: ProtoField(2, ScalarType.UINT64),
  fileId: ProtoField(3, ScalarType.BYTES),
  batchId: ProtoField(4, ScalarType.BYTES),
  fileKey: ProtoField(5, ScalarType.BYTES),
  mark: ProtoField(6, ScalarType.BYTES),
  sequence: ProtoField(7, ScalarType.UINT64),
  batchItemId: ProtoField(8, ScalarType.BYTES),
  feedMsgTime: ProtoField(9, ScalarType.INT32),
  pbReserve: ProtoField(10, ScalarType.BYTES)
};
const ExtraInfo = {
  nick: ProtoField(1, ScalarType.BYTES),
  groupCard: ProtoField(2, ScalarType.BYTES),
  level: ProtoField(3, ScalarType.INT32),
  flags: ProtoField(4, ScalarType.INT32),
  groupMask: ProtoField(5, ScalarType.INT32),
  msgTailId: ProtoField(6, ScalarType.INT32),
  senderTitle: ProtoField(7, ScalarType.BYTES),
  apnsTips: ProtoField(8, ScalarType.BYTES),
  uin: ProtoField(9, ScalarType.UINT64),
  msgStateFlag: ProtoField(10, ScalarType.INT32),
  apnsSoundType: ProtoField(11, ScalarType.INT32),
  newGroupFlag: ProtoField(12, ScalarType.INT32)
};
const VideoFile = {
  fileUuid: ProtoField(1, ScalarType.STRING),
  fileMd5: ProtoField(2, ScalarType.BYTES),
  fileName: ProtoField(3, ScalarType.STRING),
  fileFormat: ProtoField(4, ScalarType.INT32),
  fileTime: ProtoField(5, ScalarType.INT32),
  fileSize: ProtoField(6, ScalarType.INT32),
  thumbWidth: ProtoField(7, ScalarType.INT32),
  thumbHeight: ProtoField(8, ScalarType.INT32),
  thumbFileMd5: ProtoField(9, ScalarType.BYTES),
  source: ProtoField(10, ScalarType.BYTES),
  thumbFileSize: ProtoField(11, ScalarType.INT32),
  busiType: ProtoField(12, ScalarType.INT32),
  fromChatType: ProtoField(13, ScalarType.INT32),
  toChatType: ProtoField(14, ScalarType.INT32),
  boolSupportProgressive: ProtoField(15, ScalarType.BOOL),
  fileWidth: ProtoField(16, ScalarType.INT32),
  fileHeight: ProtoField(17, ScalarType.INT32),
  subBusiType: ProtoField(18, ScalarType.INT32),
  videoAttr: ProtoField(19, ScalarType.INT32),
  bytesThumbFileUrls: ProtoField(20, ScalarType.BYTES, false, true),
  bytesVideoFileUrls: ProtoField(21, ScalarType.BYTES, false, true),
  thumbDownloadFlag: ProtoField(22, ScalarType.INT32),
  videoDownloadFlag: ProtoField(23, ScalarType.INT32),
  pbReserve: ProtoField(24, ScalarType.BYTES)
};
const AnonymousGroupMessage = {
  flags: ProtoField(1, ScalarType.INT32),
  anonId: ProtoField(2, ScalarType.BYTES),
  anonNick: ProtoField(3, ScalarType.BYTES),
  headPortrait: ProtoField(4, ScalarType.INT32),
  expireTime: ProtoField(5, ScalarType.INT32),
  bubbleId: ProtoField(6, ScalarType.INT32),
  rankColor: ProtoField(7, ScalarType.BYTES)
};
const CustomElem = {
  desc: ProtoField(1, ScalarType.BYTES),
  data: ProtoField(2, ScalarType.BYTES),
  enumType: ProtoField(3, ScalarType.INT32),
  ext: ProtoField(4, ScalarType.BYTES),
  sound: ProtoField(5, ScalarType.BYTES)
};
const GeneralFlags = {
  bubbleDiyTextId: ProtoField(1, ScalarType.INT32),
  groupFlagNew: ProtoField(2, ScalarType.INT32),
  uin: ProtoField(3, ScalarType.UINT64),
  rpId: ProtoField(4, ScalarType.BYTES),
  prpFold: ProtoField(5, ScalarType.INT32),
  longTextFlag: ProtoField(6, ScalarType.INT32),
  longTextResId: ProtoField(7, ScalarType.STRING, true),
  groupType: ProtoField(8, ScalarType.INT32),
  toUinFlag: ProtoField(9, ScalarType.INT32),
  glamourLevel: ProtoField(10, ScalarType.INT32),
  memberLevel: ProtoField(11, ScalarType.INT32),
  groupRankSeq: ProtoField(12, ScalarType.UINT64),
  olympicTorch: ProtoField(13, ScalarType.INT32),
  babyqGuideMsgCookie: ProtoField(14, ScalarType.BYTES),
  uin32ExpertFlag: ProtoField(15, ScalarType.INT32),
  bubbleSubId: ProtoField(16, ScalarType.INT32),
  pendantId: ProtoField(17, ScalarType.UINT64),
  rpIndex: ProtoField(18, ScalarType.BYTES),
  pbReserve: ProtoField(19, ScalarType.BYTES)
};
const SrcMsg = {
  origSeqs: ProtoField(1, ScalarType.UINT32, false, true),
  senderUin: ProtoField(2, ScalarType.UINT64),
  time: ProtoField(3, ScalarType.INT32, true),
  flag: ProtoField(4, ScalarType.INT32, true),
  elems: ProtoField(5, () => Elem, false, true),
  type: ProtoField(6, ScalarType.INT32, true),
  richMsg: ProtoField(7, ScalarType.BYTES, true),
  pbReserve: ProtoField(8, () => SrcMsgPbRes, true),
  sourceMsg: ProtoField(9, ScalarType.BYTES, true),
  toUin: ProtoField(10, ScalarType.UINT64, true),
  troopName: ProtoField(11, ScalarType.BYTES, true)
};
const SrcMsgPbRes = {
  messageId: ProtoField(3, ScalarType.UINT64),
  senderUid: ProtoField(6, ScalarType.STRING, true),
  receiverUid: ProtoField(7, ScalarType.STRING, true),
  friendSeq: ProtoField(8, ScalarType.UINT32, true)
};
const LightAppElem = {
  data: ProtoField(1, ScalarType.BYTES),
  msgResid: ProtoField(2, ScalarType.BYTES, true)
};
const CommonElem = {
  serviceType: ProtoField(1, ScalarType.INT32),
  pbElem: ProtoField(2, ScalarType.BYTES),
  businessType: ProtoField(3, ScalarType.UINT32)
};
({
  faceId: ProtoField(1, ScalarType.INT32, true)
});
const MentionExtra = {
  type: ProtoField(3, ScalarType.INT32, true),
  uin: ProtoField(4, ScalarType.UINT32, true),
  field5: ProtoField(5, ScalarType.INT32, true),
  uid: ProtoField(9, ScalarType.STRING, true)
};
const QBigFaceExtra = {
  AniStickerPackId: ProtoField(1, ScalarType.STRING, true),
  AniStickerId: ProtoField(2, ScalarType.STRING, true),
  faceId: ProtoField(3, ScalarType.INT32, true),
  sourceType: ProtoField(4, ScalarType.INT32, true),
  AniStickerType: ProtoField(5, ScalarType.INT32, true),
  resultId: ProtoField(6, ScalarType.STRING, true),
  preview: ProtoField(7, ScalarType.STRING, true),
  randomType: ProtoField(9, ScalarType.INT32, true)
};
const QSmallFaceExtra = {
  faceId: ProtoField(1, ScalarType.UINT32),
  preview: ProtoField(2, ScalarType.STRING),
  preview2: ProtoField(3, ScalarType.STRING)
};
const MarkdownData = {
  content: ProtoField(1, ScalarType.STRING)
};

({
  type: ProtoField(1, ScalarType.UINT32),
  groupUin: ProtoField(2, ScalarType.UINT32)});
({
  sequence: ProtoField(1, ScalarType.UINT32),
  random: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32)
});
({
  field1: ProtoField(1, ScalarType.UINT32)
});

const ContentHead = {
  type: ProtoField(1, ScalarType.UINT32),
  subType: ProtoField(2, ScalarType.UINT32, true),
  c2cCmd: ProtoField(3, ScalarType.UINT32, true),
  ranDom: ProtoField(4, ScalarType.UINT32, true),
  sequence: ProtoField(5, ScalarType.UINT32, true),
  timeStamp: ProtoField(6, ScalarType.UINT32, true),
  pkgNum: ProtoField(7, ScalarType.UINT64, true),
  pkgIndex: ProtoField(8, ScalarType.UINT32, true),
  divSeq: ProtoField(9, ScalarType.UINT32, true),
  autoReply: ProtoField(10, ScalarType.UINT32),
  ntMsgSeq: ProtoField(10, ScalarType.UINT32, true),
  newId: ProtoField(12, ScalarType.UINT64, true),
  forward: ProtoField(15, () => ForwardHead, true)
};
const MessageBody = {
  richText: ProtoField(1, () => RichText, true),
  msgContent: ProtoField(2, ScalarType.BYTES, true),
  msgEncryptContent: ProtoField(3, ScalarType.BYTES, true)
};
({
  clientSequence: ProtoField(4, ScalarType.UINT32, true),
  random: ProtoField(5, ScalarType.UINT32, true),
  syncCookie: ProtoField(6, ScalarType.BYTES, true),
  via: ProtoField(8, ScalarType.UINT32, true),
  dataStatist: ProtoField(9, ScalarType.UINT32, true),
  multiSendSeq: ProtoField(14, ScalarType.UINT32)
});
({
  msgFlag: ProtoField(1, ScalarType.INT32)
});
const PushMsg = {
  message: ProtoField(1, () => PushMsgBody),
  status: ProtoField(3, ScalarType.INT32, true),
  pingFlag: ProtoField(5, ScalarType.INT32, true),
  generalFlag: ProtoField(9, ScalarType.INT32, true)
};
const GroupChangeInfo = {
  operator: ProtoField(1, () => GroupChangeOperator, true)
};
const GroupChangeOperator = {
  operatorUid: ProtoField(1, ScalarType.STRING, true)
};
const GroupChange = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  flag: ProtoField(2, ScalarType.UINT32),
  memberUid: ProtoField(3, ScalarType.STRING, true),
  decreaseType: ProtoField(4, ScalarType.UINT32),
  operatorInfo: ProtoField(5, ScalarType.BYTES, true),
  increaseType: ProtoField(6, ScalarType.UINT32),
  field7: ProtoField(7, ScalarType.BYTES, true)
};
const GroupReactionDataInnerDataTarget = {
  seq: ProtoField(1, ScalarType.UINT64, true)
};
const GroupReactionDataContent = {
  code: ProtoField(1, ScalarType.STRING, true),
  count: ProtoField(3, ScalarType.UINT32, true),
  operatorUid: ProtoField(4, ScalarType.STRING, true),
  type: ProtoField(5, ScalarType.UINT32, true)
};
const GroupReactionDataInnerData = {
  groupReactionTarget: ProtoField(2, () => GroupReactionDataInnerDataTarget, true),
  groupReactionDataContent: ProtoField(3, () => GroupReactionDataContent, true)
};
const GroupReactionDataInner = {
  data: ProtoField(1, () => GroupReactionDataInnerData, true)
};
const GroupReactionData = {
  data: ProtoField(1, () => GroupReactionDataInner, true)
};
const GroupReactNotify = {
  groupUin: ProtoField(4, ScalarType.UINT64, true),
  field13: ProtoField(13, ScalarType.UINT32, true),
  groupReactionData: ProtoField(44, () => GroupReactionData, true)
};
const GroupInvite = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.UINT32),
  field3: ProtoField(2, ScalarType.UINT32),
  field4: ProtoField(2, ScalarType.UINT32),
  invitorUid: ProtoField(5, ScalarType.STRING)
};
const PushMsgBody = {
  responseHead: ProtoField(1, () => ResponseHead),
  contentHead: ProtoField(2, () => ContentHead),
  body: ProtoField(3, () => MessageBody, true)
};
const ResponseHead = {
  fromUin: ProtoField(1, ScalarType.UINT32),
  fromUid: ProtoField(2, ScalarType.STRING, true),
  type: ProtoField(3, ScalarType.UINT32),
  sigMap: ProtoField(4, ScalarType.UINT32),
  toUin: ProtoField(5, ScalarType.UINT32),
  toUid: ProtoField(6, ScalarType.STRING, true),
  forward: ProtoField(7, () => ResponseForward, true),
  grp: ProtoField(8, () => ResponseGrp, true)
};

({
  instId: ProtoField(2, ScalarType.UINT32),
  appId: ProtoField(3, ScalarType.UINT32),
  longMessageFlag: ProtoField(4, ScalarType.UINT32),
  reserved: ProtoField(5, ScalarType.BYTES)
});
({
  fromUid: ProtoField(1, ScalarType.STRING),
  toUid: ProtoField(2, ScalarType.STRING),
  sequence: ProtoField(3, ScalarType.UINT32),
  newId: ProtoField(4, ScalarType.UINT64),
  time: ProtoField(5, ScalarType.UINT32),
  random: ProtoField(6, ScalarType.UINT32),
  pkgNum: ProtoField(7, ScalarType.UINT32),
  pkgIndex: ProtoField(8, ScalarType.UINT32),
  divSeq: ProtoField(9, ScalarType.UINT32)
});

const ForwardHead = {
  field1: ProtoField(1, ScalarType.UINT32, true),
  field2: ProtoField(2, ScalarType.UINT32, true),
  field3: ProtoField(3, ScalarType.UINT32, true),
  unknownBase64: ProtoField(5, ScalarType.STRING, true),
  avatar: ProtoField(6, ScalarType.STRING, true)
};
({
  groupCode: ProtoField(1, ScalarType.UINT32, true)
});
({
  groupUin: ProtoField(1, ScalarType.UINT32, true),
  toUin: ProtoField(2, ScalarType.UINT32, true)
});
const ResponseForward = {
  friendName: ProtoField(6, ScalarType.STRING, true)
};
const ResponseGrp = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  memberName: ProtoField(4, ScalarType.STRING),
  unknown5: ProtoField(5, ScalarType.UINT32),
  groupName: ProtoField(7, ScalarType.STRING)
};
({
  toUin: ProtoField(1, ScalarType.UINT64, true),
  ccCmd: ProtoField(2, ScalarType.UINT32, true),
  uid: ProtoField(8, ScalarType.STRING, true)
});
({
  toUin: ProtoField(1, ScalarType.UINT64),
  sig: ProtoField(2, ScalarType.BYTES)
});

const NTV2RichMediaReq = {
  ReqHead: ProtoField(1, () => MultiMediaReqHead),
  Upload: ProtoField(2, () => UploadReq),
  Download: ProtoField(3, () => DownloadReq),
  DownloadRKey: ProtoField(4, () => DownloadRKeyReq),
  Delete: ProtoField(5, () => DeleteReq),
  UploadCompleted: ProtoField(6, () => UploadCompletedReq),
  MsgInfoAuth: ProtoField(7, () => MsgInfoAuthReq),
  UploadKeyRenewal: ProtoField(8, () => UploadKeyRenewalReq),
  DownloadSafe: ProtoField(9, () => DownloadSafeReq),
  Extension: ProtoField(99, ScalarType.BYTES, true)
};
const MultiMediaReqHead = {
  Common: ProtoField(1, () => CommonHead),
  Scene: ProtoField(2, () => SceneInfo),
  Client: ProtoField(3, () => ClientMeta)
};
const CommonHead = {
  RequestId: ProtoField(1, ScalarType.UINT32),
  Command: ProtoField(2, ScalarType.UINT32)
};
const SceneInfo = {
  RequestType: ProtoField(101, ScalarType.UINT32),
  BusinessType: ProtoField(102, ScalarType.UINT32),
  SceneType: ProtoField(200, ScalarType.UINT32),
  C2C: ProtoField(201, () => C2CUserInfo, true),
  Group: ProtoField(202, () => NTGroupInfo, true)
};
const C2CUserInfo = {
  AccountType: ProtoField(1, ScalarType.UINT32),
  TargetUid: ProtoField(2, ScalarType.STRING)
};
const NTGroupInfo = {
  GroupUin: ProtoField(1, ScalarType.UINT32)
};
const ClientMeta = {
  AgentType: ProtoField(1, ScalarType.UINT32)
};
const DownloadReq = {
  Node: ProtoField(1, () => IndexNode),
  Download: ProtoField(2, () => DownloadExt)
};
const IndexNode = {
  Info: ProtoField(1, () => FileInfo),
  FileUuid: ProtoField(2, ScalarType.STRING),
  StoreId: ProtoField(3, ScalarType.UINT32),
  UploadTime: ProtoField(4, ScalarType.UINT32),
  Ttl: ProtoField(5, ScalarType.UINT32),
  SubType: ProtoField(6, ScalarType.UINT32)
};
const FileInfo = {
  FileSize: ProtoField(1, ScalarType.UINT32),
  FileHash: ProtoField(2, ScalarType.STRING),
  FileSha1: ProtoField(3, ScalarType.STRING),
  FileName: ProtoField(4, ScalarType.STRING),
  Type: ProtoField(5, () => FileType),
  Width: ProtoField(6, ScalarType.UINT32),
  Height: ProtoField(7, ScalarType.UINT32),
  Time: ProtoField(8, ScalarType.UINT32),
  Original: ProtoField(9, ScalarType.UINT32)
};
const FileType = {
  Type: ProtoField(1, ScalarType.UINT32),
  PicFormat: ProtoField(2, ScalarType.UINT32),
  VideoFormat: ProtoField(3, ScalarType.UINT32),
  VoiceFormat: ProtoField(4, ScalarType.UINT32)
};
const DownloadExt = {
  Pic: ProtoField(1, () => PicDownloadExt),
  Video: ProtoField(2, () => VideoDownloadExt),
  Ptt: ProtoField(3, () => PttDownloadExt)
};
const VideoDownloadExt = {
  BusiType: ProtoField(1, ScalarType.UINT32),
  SceneType: ProtoField(2, ScalarType.UINT32),
  SubBusiType: ProtoField(3, ScalarType.UINT32)
};
const PicDownloadExt = {};
const PttDownloadExt = {};
const DownloadRKeyReq = {
  Types: ProtoField(1, ScalarType.INT32, false, true)
};
const DeleteReq = {
  Index: ProtoField(1, () => IndexNode, false, true),
  NeedRecallMsg: ProtoField(2, ScalarType.BOOL),
  MsgSeq: ProtoField(3, ScalarType.UINT64),
  MsgRandom: ProtoField(4, ScalarType.UINT64),
  MsgTime: ProtoField(5, ScalarType.UINT64)
};
const UploadCompletedReq = {
  SrvSendMsg: ProtoField(1, ScalarType.BOOL),
  ClientRandomId: ProtoField(2, ScalarType.UINT64),
  MsgInfo: ProtoField(3, () => MsgInfo),
  ClientSeq: ProtoField(4, ScalarType.UINT32)
};
const MsgInfoAuthReq = {
  Msg: ProtoField(1, ScalarType.BYTES),
  AuthTime: ProtoField(2, ScalarType.UINT64)
};
const DownloadSafeReq = {
  Index: ProtoField(1, () => IndexNode)
};
const UploadKeyRenewalReq = {
  OldUKey: ProtoField(1, ScalarType.STRING),
  SubType: ProtoField(2, ScalarType.UINT32)
};
const MsgInfo = {
  MsgInfoBody: ProtoField(1, () => MsgInfoBody, false, true),
  ExtBizInfo: ProtoField(2, () => ExtBizInfo)
};
const MsgInfoBody = {
  Index: ProtoField(1, () => IndexNode),
  Picture: ProtoField(2, () => PictureInfo),
  Video: ProtoField(3, () => VideoInfo),
  Audio: ProtoField(4, () => AudioInfo),
  FileExist: ProtoField(5, ScalarType.BOOL),
  HashSum: ProtoField(6, ScalarType.BYTES)
};
const VideoInfo = {};
const AudioInfo = {};
const PictureInfo = {
  UrlPath: ProtoField(1, ScalarType.STRING),
  Ext: ProtoField(2, () => PicUrlExtInfo),
  Domain: ProtoField(3, ScalarType.STRING)
};
const PicUrlExtInfo = {
  OriginalParameter: ProtoField(1, ScalarType.STRING),
  BigParameter: ProtoField(2, ScalarType.STRING),
  ThumbParameter: ProtoField(3, ScalarType.STRING)
};
const VideoExtInfo = {
  VideoCodecFormat: ProtoField(1, ScalarType.UINT32)
};
const ExtBizInfo = {
  Pic: ProtoField(1, () => PicExtBizInfo),
  Video: ProtoField(2, () => VideoExtBizInfo),
  Ptt: ProtoField(3, () => PttExtBizInfo),
  BusiType: ProtoField(10, ScalarType.UINT32)
};
const PttExtBizInfo = {
  SrcUin: ProtoField(1, ScalarType.UINT64),
  PttScene: ProtoField(2, ScalarType.UINT32),
  PttType: ProtoField(3, ScalarType.UINT32),
  ChangeVoice: ProtoField(4, ScalarType.UINT32),
  Waveform: ProtoField(5, ScalarType.BYTES),
  AutoConvertText: ProtoField(6, ScalarType.UINT32),
  BytesReserve: ProtoField(11, ScalarType.BYTES),
  BytesPbReserve: ProtoField(12, ScalarType.BYTES),
  BytesGeneralFlags: ProtoField(13, ScalarType.BYTES)
};
const VideoExtBizInfo = {
  FromScene: ProtoField(1, ScalarType.UINT32),
  ToScene: ProtoField(2, ScalarType.UINT32),
  BytesPbReserve: ProtoField(3, ScalarType.BYTES)
};
const PicExtBizInfo = {
  BizType: ProtoField(1, ScalarType.UINT32),
  TextSummary: ProtoField(2, ScalarType.STRING),
  BytesPbReserveC2c: ProtoField(11, () => BytesPbReserveC2c),
  BytesPbReserveTroop: ProtoField(12, () => BytesPbReserveTroop),
  FromScene: ProtoField(1001, ScalarType.UINT32),
  ToScene: ProtoField(1002, ScalarType.UINT32),
  OldFileId: ProtoField(1003, ScalarType.UINT32)
};
const UploadReq = {
  UploadInfo: ProtoField(1, () => UploadInfo, false, true),
  TryFastUploadCompleted: ProtoField(2, ScalarType.BOOL),
  SrvSendMsg: ProtoField(3, ScalarType.BOOL),
  ClientRandomId: ProtoField(4, ScalarType.UINT64),
  CompatQMsgSceneType: ProtoField(5, ScalarType.UINT32),
  ExtBizInfo: ProtoField(6, () => ExtBizInfo),
  ClientSeq: ProtoField(7, ScalarType.UINT32),
  NoNeedCompatMsg: ProtoField(8, ScalarType.BOOL)
};
const UploadInfo = {
  FileInfo: ProtoField(1, () => FileInfo),
  SubFileType: ProtoField(2, ScalarType.UINT32)
};
const BytesPbReserveC2c = {
  subType: ProtoField(1, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32),
  field4: ProtoField(4, ScalarType.UINT32),
  field8: ProtoField(8, ScalarType.STRING),
  field10: ProtoField(10, ScalarType.UINT32),
  field12: ProtoField(12, ScalarType.STRING),
  field18: ProtoField(18, ScalarType.STRING),
  field19: ProtoField(19, ScalarType.STRING),
  field20: ProtoField(20, ScalarType.BYTES)
};
const BytesPbReserveTroop = {
  subType: ProtoField(1, ScalarType.UINT32),
  field3: ProtoField(3, ScalarType.UINT32),
  field4: ProtoField(4, ScalarType.UINT32),
  field9: ProtoField(9, ScalarType.STRING),
  field10: ProtoField(10, ScalarType.UINT32),
  field12: ProtoField(12, ScalarType.STRING),
  field18: ProtoField(18, ScalarType.STRING),
  field19: ProtoField(19, ScalarType.STRING),
  field21: ProtoField(21, ScalarType.BYTES)
};

const NTV2RichMediaResp = {
  respHead: ProtoField(1, () => MultiMediaRespHead),
  upload: ProtoField(2, () => UploadResp),
  download: ProtoField(3, () => DownloadResp),
  downloadRKey: ProtoField(4, () => DownloadRKeyResp),
  delete: ProtoField(5, () => DeleteResp),
  uploadCompleted: ProtoField(6, () => UploadCompletedResp),
  msgInfoAuth: ProtoField(7, () => MsgInfoAuthResp),
  uploadKeyRenewal: ProtoField(8, () => UploadKeyRenewalResp),
  downloadSafe: ProtoField(9, () => DownloadSafeResp),
  extension: ProtoField(99, ScalarType.BYTES, true)
};
const MultiMediaRespHead = {
  common: ProtoField(1, () => CommonHead),
  retCode: ProtoField(2, ScalarType.UINT32),
  message: ProtoField(3, ScalarType.STRING)
};
const DownloadResp = {
  rKeyParam: ProtoField(1, ScalarType.STRING),
  rKeyTtlSecond: ProtoField(2, ScalarType.UINT32),
  info: ProtoField(3, () => DownloadInfo),
  rKeyCreateTime: ProtoField(4, ScalarType.UINT32)
};
const DownloadInfo = {
  domain: ProtoField(1, ScalarType.STRING),
  urlPath: ProtoField(2, ScalarType.STRING),
  httpsPort: ProtoField(3, ScalarType.UINT32),
  ipv4s: ProtoField(4, () => IPv4, false, true),
  ipv6s: ProtoField(5, () => IPv6, false, true),
  picUrlExtInfo: ProtoField(6, () => PicUrlExtInfo),
  videoExtInfo: ProtoField(7, () => VideoExtInfo)
};
const IPv4 = {
  outIP: ProtoField(1, ScalarType.UINT32),
  outPort: ProtoField(2, ScalarType.UINT32),
  inIP: ProtoField(3, ScalarType.UINT32),
  inPort: ProtoField(4, ScalarType.UINT32),
  ipType: ProtoField(5, ScalarType.UINT32)
};
const IPv6 = {
  outIP: ProtoField(1, ScalarType.BYTES),
  outPort: ProtoField(2, ScalarType.UINT32),
  inIP: ProtoField(3, ScalarType.BYTES),
  inPort: ProtoField(4, ScalarType.UINT32),
  ipType: ProtoField(5, ScalarType.UINT32)
};
const UploadResp = {
  uKey: ProtoField(1, ScalarType.STRING, true),
  uKeyTtlSecond: ProtoField(2, ScalarType.UINT32),
  ipv4s: ProtoField(3, () => IPv4, false, true),
  ipv6s: ProtoField(4, () => IPv6, false, true),
  msgSeq: ProtoField(5, ScalarType.UINT64),
  msgInfo: ProtoField(6, () => MsgInfo),
  ext: ProtoField(7, () => RichMediaStorageTransInfo, false, true),
  compatQMsg: ProtoField(8, ScalarType.BYTES),
  subFileInfos: ProtoField(10, () => SubFileInfo, false, true)
};
const RichMediaStorageTransInfo = {
  subType: ProtoField(1, ScalarType.UINT32),
  extType: ProtoField(2, ScalarType.UINT32),
  extValue: ProtoField(3, ScalarType.BYTES)
};
const SubFileInfo = {
  subType: ProtoField(1, ScalarType.UINT32),
  uKey: ProtoField(2, ScalarType.STRING),
  uKeyTtlSecond: ProtoField(3, ScalarType.UINT32),
  ipv4s: ProtoField(4, () => IPv4, false, true),
  ipv6s: ProtoField(5, () => IPv6, false, true)
};
const DownloadSafeResp = {};
const UploadKeyRenewalResp = {
  ukey: ProtoField(1, ScalarType.STRING),
  ukeyTtlSec: ProtoField(2, ScalarType.UINT64)
};
const MsgInfoAuthResp = {
  authCode: ProtoField(1, ScalarType.UINT32),
  msg: ProtoField(2, ScalarType.BYTES),
  resultTime: ProtoField(3, ScalarType.UINT64)
};
const UploadCompletedResp = {
  msgSeq: ProtoField(1, ScalarType.UINT64)
};
const DeleteResp = {};
const DownloadRKeyResp = {
  rKeys: ProtoField(1, () => RKeyInfo, false, true)
};
const RKeyInfo = {
  rkey: ProtoField(1, ScalarType.STRING),
  rkeyTtlSec: ProtoField(2, ScalarType.UINT64),
  storeId: ProtoField(3, ScalarType.UINT32),
  rkeyCreateTime: ProtoField(4, ScalarType.UINT32, true),
  type: ProtoField(5, ScalarType.UINT32, true)
};

const OidbSvcTrpcTcp0x6D6 = {
  file: ProtoField(1, () => OidbSvcTrpcTcp0x6D6Upload, true),
  download: ProtoField(3, () => OidbSvcTrpcTcp0x6D6Download, true),
  delete: ProtoField(4, () => OidbSvcTrpcTcp0x6D6Delete, true),
  rename: ProtoField(5, () => OidbSvcTrpcTcp0x6D6Rename, true),
  move: ProtoField(6, () => OidbSvcTrpcTcp0x6D6Move, true)
};
const OidbSvcTrpcTcp0x6D6Upload = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  appId: ProtoField(2, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  entrance: ProtoField(4, ScalarType.UINT32),
  targetDirectory: ProtoField(5, ScalarType.STRING),
  fileName: ProtoField(6, ScalarType.STRING),
  localDirectory: ProtoField(7, ScalarType.STRING),
  fileSize: ProtoField(8, ScalarType.UINT64),
  fileSha1: ProtoField(9, ScalarType.BYTES),
  fileSha3: ProtoField(10, ScalarType.BYTES),
  fileMd5: ProtoField(11, ScalarType.BYTES),
  field15: ProtoField(15, ScalarType.BOOL)
};
const OidbSvcTrpcTcp0x6D6Download = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  appId: ProtoField(2, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(4, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Delete = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(5, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Rename = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(4, ScalarType.STRING),
  parentFolder: ProtoField(5, ScalarType.STRING),
  newFileName: ProtoField(6, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Move = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  appId: ProtoField(2, ScalarType.UINT32),
  busId: ProtoField(3, ScalarType.UINT32),
  fileId: ProtoField(4, ScalarType.STRING),
  parentDirectory: ProtoField(5, ScalarType.STRING),
  targetDirectory: ProtoField(6, ScalarType.STRING)
};
const OidbSvcTrpcTcp0x6D6Response = {
  upload: ProtoField(1, () => OidbSvcTrpcTcp0x6D6_0Response),
  download: ProtoField(3, () => OidbSvcTrpcTcp0x6D6_2Response),
  delete: ProtoField(4, () => OidbSvcTrpcTcp0x6D6_3_4_5Response),
  rename: ProtoField(5, () => OidbSvcTrpcTcp0x6D6_3_4_5Response),
  move: ProtoField(6, () => OidbSvcTrpcTcp0x6D6_3_4_5Response)
};
const OidbSvcTrpcTcp0x6D6_0Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  retMsg: ProtoField(2, ScalarType.STRING),
  clientWording: ProtoField(3, ScalarType.STRING),
  uploadIp: ProtoField(4, ScalarType.STRING),
  serverDns: ProtoField(5, ScalarType.STRING),
  busId: ProtoField(6, ScalarType.INT32),
  fileId: ProtoField(7, ScalarType.STRING),
  checkKey: ProtoField(8, ScalarType.BYTES),
  fileKey: ProtoField(9, ScalarType.BYTES),
  boolFileExist: ProtoField(10, ScalarType.BOOL),
  uploadIpLanV4: ProtoField(12, ScalarType.STRING, false, true),
  uploadIpLanV6: ProtoField(13, ScalarType.STRING, false, true),
  uploadPort: ProtoField(14, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0x6D6_2Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  retMsg: ProtoField(2, ScalarType.STRING),
  clientWording: ProtoField(3, ScalarType.STRING),
  downloadIp: ProtoField(4, ScalarType.STRING),
  downloadDns: ProtoField(5, ScalarType.STRING),
  downloadUrl: ProtoField(6, ScalarType.BYTES),
  fileSha1: ProtoField(7, ScalarType.BYTES),
  fileSha3: ProtoField(8, ScalarType.BYTES),
  fileMd5: ProtoField(9, ScalarType.BYTES),
  cookieVal: ProtoField(10, ScalarType.BYTES),
  saveFileName: ProtoField(11, ScalarType.STRING),
  previewPort: ProtoField(12, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0x6D6_3_4_5Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  retMsg: ProtoField(2, ScalarType.STRING),
  clientWording: ProtoField(3, ScalarType.STRING)
};

const OidbSvcTrpcTcp0X8FC_2_Body = {
  targetUid: ProtoField(1, ScalarType.STRING),
  specialTitle: ProtoField(5, ScalarType.STRING, true),
  expiredTime: ProtoField(6, ScalarType.INT32),
  uinName: ProtoField(7, ScalarType.STRING, true),
  targetName: ProtoField(8, ScalarType.STRING)
};
const OidbSvcTrpcTcp0X8FC_2 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  body: ProtoField(3, () => OidbSvcTrpcTcp0X8FC_2_Body)
};

const OidbSvcTrpcTcp0X9067_202 = {
  ReqHead: ProtoField(1, () => MultiMediaReqHead),
  DownloadRKeyReq: ProtoField(4, () => OidbSvcTrpcTcp0X9067_202Key)
};
const OidbSvcTrpcTcp0X9067_202Key = {
  key: ProtoField(1, ScalarType.INT32, false, true)
};
const OidbSvcTrpcTcp0X9067_202_RkeyList = {
  rkey: ProtoField(1, ScalarType.STRING),
  ttl: ProtoField(2, ScalarType.UINT64),
  time: ProtoField(4, ScalarType.UINT32),
  type: ProtoField(5, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0X9067_202_Data = {
  rkeyList: ProtoField(1, () => OidbSvcTrpcTcp0X9067_202_RkeyList, false, true)
};
const OidbSvcTrpcTcp0X9067_202_Rsp_Body = {
  data: ProtoField(4, () => OidbSvcTrpcTcp0X9067_202_Data)
};

const OidbSvcTrpcTcp0X929D_0 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  chatType: ProtoField(2, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0X929D_0Resp = {
  content: ProtoField(1, () => OidbSvcTrpcTcp0X929D_0RespContent, false, true)
};
const OidbSvcTrpcTcp0X929D_0RespContent = {
  category: ProtoField(1, ScalarType.STRING),
  voices: ProtoField(2, () => OidbSvcTrpcTcp0X929D_0RespContentVoice, false, true)
};
const OidbSvcTrpcTcp0X929D_0RespContentVoice = {
  voiceId: ProtoField(1, ScalarType.STRING),
  voiceDisplayName: ProtoField(2, ScalarType.STRING),
  voiceExampleUrl: ProtoField(3, ScalarType.STRING)
};
const OidbSvcTrpcTcp0X929B_0 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  voiceId: ProtoField(2, ScalarType.STRING),
  text: ProtoField(3, ScalarType.STRING),
  chatType: ProtoField(4, ScalarType.UINT32),
  session: ProtoField(5, () => OidbSvcTrpcTcp0X929B_0_Session)
};
const OidbSvcTrpcTcp0X929B_0_Session = {
  sessionId: ProtoField(1, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0X929B_0Resp = {
  statusCode: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.UINT32, true),
  field3: ProtoField(3, ScalarType.UINT32),
  msgInfo: ProtoField(4, () => MsgInfo, true)
};

const OidbSvcTrpcTcp0XE37_1200 = {
  subCommand: ProtoField(1, ScalarType.UINT32, true),
  field2: ProtoField(2, ScalarType.INT32, true),
  body: ProtoField(14, () => OidbSvcTrpcTcp0XE37_1200Body, true),
  field101: ProtoField(101, ScalarType.INT32, true),
  field102: ProtoField(102, ScalarType.INT32, true),
  field200: ProtoField(200, ScalarType.INT32, true),
  field99999: ProtoField(99999, ScalarType.BYTES, true)
};
const OidbSvcTrpcTcp0XE37_1200Body = {
  receiverUid: ProtoField(10, ScalarType.STRING, true),
  fileUuid: ProtoField(20, ScalarType.STRING, true),
  type: ProtoField(30, ScalarType.INT32, true),
  fileHash: ProtoField(60, ScalarType.STRING, true),
  t2: ProtoField(601, ScalarType.INT32, true)
};
const OidbSvcTrpcTcp0XE37_1200Response = {
  command: ProtoField(1, ScalarType.UINT32, true),
  subCommand: ProtoField(2, ScalarType.UINT32, true),
  body: ProtoField(14, () => OidbSvcTrpcTcp0XE37_1200ResponseBody, true),
  field50: ProtoField(50, ScalarType.UINT32, true)
};
const OidbSvcTrpcTcp0XE37_1200ResponseBody = {
  field10: ProtoField(10, ScalarType.UINT32, true),
  state: ProtoField(20, ScalarType.STRING, true),
  result: ProtoField(30, () => OidbSvcTrpcTcp0XE37_1200Result, true),
  metadata: ProtoField(40, () => OidbSvcTrpcTcp0XE37_800_1200Metadata, true)
};
const OidbSvcTrpcTcp0XE37_1200Result = {
  server: ProtoField(20, ScalarType.STRING, true),
  port: ProtoField(40, ScalarType.UINT32, true),
  url: ProtoField(50, ScalarType.STRING, true),
  additionalServer: ProtoField(60, ScalarType.STRING, false, true),
  ssoPort: ProtoField(80, ScalarType.UINT32, true),
  ssoUrl: ProtoField(90, ScalarType.STRING, true),
  extra: ProtoField(120, ScalarType.BYTES, true)
};
const OidbSvcTrpcTcp0XE37_800_1200Metadata = {
  uin: ProtoField(1, ScalarType.UINT32, true),
  field2: ProtoField(2, ScalarType.UINT32, true),
  field3: ProtoField(3, ScalarType.UINT32, true),
  size: ProtoField(4, ScalarType.UINT32, true),
  timestamp: ProtoField(5, ScalarType.UINT32, true),
  fileUuid: ProtoField(6, ScalarType.STRING, true),
  fileName: ProtoField(7, ScalarType.STRING, true),
  field100: ProtoField(100, ScalarType.BYTES, true),
  field101: ProtoField(101, ScalarType.BYTES, true),
  field110: ProtoField(110, ScalarType.UINT32, true),
  timestamp1: ProtoField(130, ScalarType.UINT32, true),
  fileHash: ProtoField(140, ScalarType.STRING, true),
  field141: ProtoField(141, ScalarType.BYTES, true),
  field142: ProtoField(142, ScalarType.BYTES, true)
};

const OidbSvcTrpcTcp0XE37_1700 = {
  command: ProtoField(1, ScalarType.UINT32, true),
  seq: ProtoField(2, ScalarType.INT32, true),
  upload: ProtoField(19, () => ApplyUploadReqV3, true),
  businessId: ProtoField(101, ScalarType.INT32, true),
  clientType: ProtoField(102, ScalarType.INT32, true),
  flagSupportMediaPlatform: ProtoField(200, ScalarType.INT32, true)
};
const ApplyUploadReqV3 = {
  senderUid: ProtoField(10, ScalarType.STRING, true),
  receiverUid: ProtoField(20, ScalarType.STRING, true),
  fileSize: ProtoField(30, ScalarType.UINT32, true),
  fileName: ProtoField(40, ScalarType.STRING, true),
  md510MCheckSum: ProtoField(50, ScalarType.BYTES, true),
  sha1CheckSum: ProtoField(60, ScalarType.BYTES, true),
  localPath: ProtoField(70, ScalarType.STRING, true),
  md5CheckSum: ProtoField(110, ScalarType.BYTES, true),
  sha3CheckSum: ProtoField(120, ScalarType.BYTES, true)
};

const OidbSvcTrpcTcp0XE37_800 = {
  subCommand: ProtoField(1, ScalarType.UINT32),
  field2: ProtoField(2, ScalarType.INT32),
  body: ProtoField(10, () => OidbSvcTrpcTcp0XE37_800Body, true),
  field101: ProtoField(101, ScalarType.INT32),
  field102: ProtoField(102, ScalarType.INT32),
  field200: ProtoField(200, ScalarType.INT32)
};
const OidbSvcTrpcTcp0XE37_800Body = {
  senderUid: ProtoField(10, ScalarType.STRING, true),
  receiverUid: ProtoField(20, ScalarType.STRING, true),
  fileUuid: ProtoField(30, ScalarType.STRING, true),
  fileHash: ProtoField(40, ScalarType.STRING, true)
};
const OidbSvcTrpcTcp0XE37Response = {
  command: ProtoField(1, ScalarType.UINT32),
  seq: ProtoField(2, ScalarType.INT32),
  upload: ProtoField(19, () => ApplyUploadRespV3, true),
  businessId: ProtoField(101, ScalarType.INT32),
  clientType: ProtoField(102, ScalarType.INT32),
  flagSupportMediaPlatform: ProtoField(200, ScalarType.INT32)
};
const ApplyUploadRespV3 = {
  retCode: ProtoField(10, ScalarType.INT32),
  retMsg: ProtoField(20, ScalarType.STRING, true),
  totalSpace: ProtoField(30, ScalarType.INT64),
  usedSpace: ProtoField(40, ScalarType.INT64),
  uploadedSize: ProtoField(50, ScalarType.INT64),
  uploadIp: ProtoField(60, ScalarType.STRING, true),
  uploadDomain: ProtoField(70, ScalarType.STRING, true),
  uploadPort: ProtoField(80, ScalarType.UINT32),
  uuid: ProtoField(90, ScalarType.STRING, true),
  uploadKey: ProtoField(100, ScalarType.BYTES, true),
  boolFileExist: ProtoField(110, ScalarType.BOOL),
  packSize: ProtoField(120, ScalarType.INT32),
  uploadIpList: ProtoField(130, ScalarType.STRING, false, true),
  // repeated
  uploadHttpsPort: ProtoField(140, ScalarType.INT32),
  uploadHttpsDomain: ProtoField(150, ScalarType.STRING, true),
  uploadDns: ProtoField(160, ScalarType.STRING, true),
  uploadLanip: ProtoField(170, ScalarType.STRING, true),
  fileAddon: ProtoField(200, ScalarType.STRING, true),
  mediaPlatformUploadKey: ProtoField(220, ScalarType.BYTES, true)
};
({
  command: ProtoField(1, ScalarType.UINT32, true),
  subCommand: ProtoField(2, ScalarType.UINT32, true),
  field50: ProtoField(50, ScalarType.UINT32, true)
});
({
  field10: ProtoField(10, ScalarType.UINT32, true)});

const OidbSvcTrpcTcp0XEB7_Body = {
  uin: ProtoField(1, ScalarType.STRING),
  groupUin: ProtoField(2, ScalarType.STRING),
  version: ProtoField(3, ScalarType.STRING)
};
const OidbSvcTrpcTcp0XEB7 = {
  body: ProtoField(2, () => OidbSvcTrpcTcp0XEB7_Body)
};

const OidbSvcTrpcTcp0XED3_1 = {
  uin: ProtoField(1, ScalarType.UINT32),
  groupUin: ProtoField(2, ScalarType.UINT32),
  friendUin: ProtoField(5, ScalarType.UINT32),
  ext: ProtoField(6, ScalarType.UINT32, true)
};

const OidbSvcTrpcTcp0XFE1_2 = {
  uin: ProtoField(1, ScalarType.UINT32),
  key: ProtoField(3, () => OidbSvcTrpcTcp0XFE1_2Key, false, true)
};
const OidbSvcTrpcTcp0XFE1_2Key = {
  key: ProtoField(1, ScalarType.UINT32)
};
const OidbSvcTrpcTcp0XFE1_2RSP_Status = {
  key: ProtoField(1, ScalarType.UINT32),
  value: ProtoField(2, ScalarType.UINT64)
};
const OidbSvcTrpcTcp0XFE1_2RSP_Data = {
  status: ProtoField(2, () => OidbSvcTrpcTcp0XFE1_2RSP_Status)
};
const OidbSvcTrpcTcp0XFE1_2RSP = {
  data: ProtoField(1, () => OidbSvcTrpcTcp0XFE1_2RSP_Data)
};

const OidbSvcTrpcTcpBase = {
  command: ProtoField(1, ScalarType.UINT32),
  subCommand: ProtoField(2, ScalarType.UINT32),
  errorCode: ProtoField(3, ScalarType.UINT32),
  body: ProtoField(4, ScalarType.BYTES),
  errorMsg: ProtoField(5, ScalarType.STRING, true),
  isReserved: ProtoField(12, ScalarType.UINT32)
};
({
  body: ProtoField(4, ScalarType.BYTES)
});

const OidbSvcTrpcTcp0xE07_0 = {
  version: ProtoField(1, ScalarType.UINT32),
  client: ProtoField(2, ScalarType.UINT32),
  entrance: ProtoField(3, ScalarType.UINT32),
  ocrReqBody: ProtoField(10, () => OcrReqBody, true)
};
const OcrReqBody = {
  imageUrl: ProtoField(1, ScalarType.STRING),
  languageType: ProtoField(2, ScalarType.UINT32),
  scene: ProtoField(3, ScalarType.UINT32),
  originMd5: ProtoField(10, ScalarType.STRING),
  afterCompressMd5: ProtoField(11, ScalarType.STRING),
  afterCompressFileSize: ProtoField(12, ScalarType.STRING),
  afterCompressWeight: ProtoField(13, ScalarType.STRING),
  afterCompressHeight: ProtoField(14, ScalarType.STRING),
  isCut: ProtoField(15, ScalarType.BOOL)
};
const OidbSvcTrpcTcp0xE07_0_Response = {
  retCode: ProtoField(1, ScalarType.INT32),
  errMsg: ProtoField(2, ScalarType.STRING),
  wording: ProtoField(3, ScalarType.STRING),
  ocrRspBody: ProtoField(10, () => OcrRspBody)
};
const OcrRspBody = {
  textDetections: ProtoField(1, () => TextDetection, false, true),
  language: ProtoField(2, ScalarType.STRING),
  requestId: ProtoField(3, ScalarType.STRING),
  ocrLanguageList: ProtoField(101, ScalarType.STRING, false, true),
  dstTranslateLanguageList: ProtoField(102, ScalarType.STRING, false, true),
  languageList: ProtoField(103, () => Language, false, true),
  afterCompressWeight: ProtoField(111, ScalarType.UINT32),
  afterCompressHeight: ProtoField(112, ScalarType.UINT32)
};
const TextDetection = {
  detectedText: ProtoField(1, ScalarType.STRING),
  confidence: ProtoField(2, ScalarType.UINT32),
  polygon: ProtoField(3, () => Polygon),
  advancedInfo: ProtoField(4, ScalarType.STRING)
};
const Polygon = {
  coordinates: ProtoField(1, () => Coordinate, false, true)
};
const Coordinate = {
  x: ProtoField(1, ScalarType.INT32),
  y: ProtoField(2, ScalarType.INT32)
};
const Language = {
  languageCode: ProtoField(1, ScalarType.STRING),
  languageDesc: ProtoField(2, ScalarType.STRING)
};

const OidbSvcTrpcTcp0XF90_1 = {
  groupUin: ProtoField(1, ScalarType.UINT32),
  msgSeq: ProtoField(2, ScalarType.UINT64)
};

class IHighwayUploader {
  trans;
  logger;
  constructor(trans, logger) {
    this.trans = trans;
    this.logger = logger;
  }
  // TODO: 没用到的加密方法先注释掉
  // private encryptTransExt (key: Uint8Array) {
  //   if (!this.trans.encrypt) return;
  //   this.trans.ext = tea.encrypt(Buffer.from(this.trans.ext), Buffer.from(key));
  // }
  timeout() {
    return new Promise((_resolve, reject) => {
      setTimeout(
        () => {
          reject(new Error(`[Highway] timeout after ${this.trans.timeout}s`));
        },
        (this.trans.timeout ?? Infinity) * 1e3
      );
    });
  }
  buildPicUpHead(offset, bodyLength, bodyMd5) {
    return new NapProtoMsg(ReqDataHighwayHead).encode({
      msgBaseHead: {
        version: 1,
        uin: this.trans.uin,
        command: "PicUp.DataUp",
        seq: 0,
        retryTimes: 0,
        appId: 1600001604,
        dataFlag: 16,
        commandId: this.trans.cmd
      },
      msgSegHead: {
        serviceId: 0,
        filesize: BigInt(this.trans.size),
        dataOffset: BigInt(offset),
        dataLength: bodyLength,
        serviceTicket: this.trans.ticket,
        md5: bodyMd5,
        fileMd5: this.trans.sum,
        cacheAddr: 0,
        cachePort: 0
      },
      bytesReqExtendInfo: this.trans.ext,
      timestamp: BigInt(0),
      msgLoginSigHead: {
        uint32LoginSigType: 8,
        appId: 1600001604
      }
    });
  }
}

class HighwayTcpUploaderTransform extends stream__default.Transform {
  uploader;
  offset;
  constructor(uploader) {
    super();
    this.uploader = uploader;
    this.offset = 0;
  }
  _transform(data, _, callback) {
    let chunkOffset = 0;
    while (chunkOffset < data.length) {
      const chunkSize = Math.min(BlockSize, data.length - chunkOffset);
      const chunk = data.subarray(chunkOffset, chunkOffset + chunkSize);
      const chunkMd5 = crypto__default$1.createHash("md5").update(chunk).digest();
      const head = this.uploader.buildPicUpHead(this.offset, chunk.length, chunkMd5);
      chunkOffset += chunk.length;
      this.offset += chunk.length;
      this.push(Frame.pack(Buffer.from(head), chunk));
    }
    callback(null);
  }
}
class HighwayTcpUploader extends IHighwayUploader {
  async upload() {
    const controller = new AbortController();
    const { signal } = controller;
    const upload = new Promise((resolve, reject) => {
      const highwayTransForm = new HighwayTcpUploaderTransform(this);
      const socket = net__default.connect(this.trans.port, this.trans.server, () => {
        this.trans.data.pipe(highwayTransForm).pipe(socket, { end: false });
      });
      const handleRspHeader = (header) => {
        const rsp = new NapProtoMsg(RespDataHighwayHead).decode(header);
        if (rsp.errorCode !== 0) {
          socket.end();
          reject(new Error(`[Highway] tcpUpload failed (code=${rsp.errorCode})`));
        }
        const percent = ((Number(rsp.msgSegHead?.dataOffset) + Number(rsp.msgSegHead?.dataLength)) / Number(rsp.msgSegHead?.filesize)).toFixed(2);
        this.logger.debug(`[Highway] tcpUpload ${rsp.errorCode} | ${percent} | ${Buffer.from(header).toString("hex")}`);
        if (Number(rsp.msgSegHead?.dataOffset) + Number(rsp.msgSegHead?.dataLength) >= Number(rsp.msgSegHead?.filesize)) {
          this.logger.debug("[Highway] tcpUpload finished.");
          socket.end();
          resolve();
        }
      };
      socket.on("data", (chunk) => {
        if (signal.aborted) {
          socket.end();
          reject(new Error("Upload aborted due to timeout"));
        }
        const [head] = Frame.unpack(chunk);
        handleRspHeader(head);
      });
      socket.on("close", () => {
        this.logger.debug("[Highway] tcpUpload socket closed.");
        resolve();
      });
      socket.on("error", (err) => {
        socket.end();
        reject(new Error(`[Highway] tcpUpload socket.on error: ${err}`));
      });
      this.trans.data.on("error", (err) => {
        socket.end();
        reject(new Error(`[Highway] tcpUpload readable error: ${err}`));
      });
    });
    const timeout = this.timeout().catch((err) => {
      controller.abort();
      throw new Error(err.message);
    });
    await Promise.race([upload, timeout]);
  }
}

class HighwayHttpUploader extends IHighwayUploader {
  async upload() {
    const controller = new AbortController();
    const { signal } = controller;
    const upload = (async () => {
      let offset = 0;
      for await (const chunk of this.trans.data) {
        if (signal.aborted) {
          throw new Error("Upload aborted due to timeout");
        }
        const block = chunk;
        try {
          await this.uploadBlock(block, offset);
        } catch (err) {
          throw new Error(`[Highway] httpUpload Error uploading block at offset ${offset}: ${err}`);
        }
        offset += block.length;
      }
    })();
    const timeout = this.timeout().catch((err) => {
      controller.abort();
      throw new Error(err.message);
    });
    await Promise.race([upload, timeout]);
  }
  async uploadBlock(block, offset) {
    const chunkMD5 = crypto__default$1.createHash("md5").update(block).digest();
    const payload = this.buildPicUpHead(offset, block.length, chunkMD5);
    const frame = Frame.pack(Buffer.from(payload), block);
    const resp = await this.httpPostHighwayContent(frame, `http://${this.trans.server}:${this.trans.port}/cgi-bin/httpconn?htcmd=0x6FF0087&uin=${this.trans.uin}`);
    const [head, body] = Frame.unpack(resp);
    const headData = new NapProtoMsg(RespDataHighwayHead).decode(head);
    this.logger.debug(`[Highway] httpUploadBlock: ${headData.errorCode} | ${headData.msgSegHead?.retCode} | ${headData.bytesRspExtendInfo} | ${head.toString("hex")} | ${body.toString("hex")}`);
    if (headData.errorCode !== 0) throw new Error(`[Highway] httpUploadBlock failed (code=${headData.errorCode})`);
  }
  async httpPostHighwayContent(frame, serverURL) {
    return new Promise((resolve, reject) => {
      try {
        const options = {
          method: "POST",
          headers: {
            Connection: "keep-alive",
            "Accept-Encoding": "identity",
            "User-Agent": "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2)",
            "Content-Length": frame.length.toString()
          }
        };
        const req = http.request(serverURL, options, (res) => {
          const data = [];
          res.on("data", (chunk) => {
            data.push(chunk);
          });
          res.on("end", () => {
            resolve(Buffer.concat(data));
          });
        });
        req.write(frame);
        req.on("error", (error) => {
          reject(error);
        });
      } catch (error) {
        reject(new Error(error.message));
      }
    });
  }
}

class PacketHighwayClient {
  sig;
  server = "htdata3.qq.com";
  port = 80;
  logger;
  constructor(sig, logger, _server = "htdata3.qq.com", _port = 80) {
    this.sig = sig;
    this.logger = logger;
  }
  changeServer(server, port) {
    this.server = server;
    this.port = port;
  }
  buildDataUpTrans(cmd, data, fileSize, md5, extendInfo, timeout = 1200) {
    return {
      uin: this.sig.uin,
      cmd,
      command: "PicUp.DataUp",
      data,
      sum: md5,
      size: fileSize,
      ticket: this.sig.sigSession,
      ext: extendInfo,
      encrypt: false,
      timeout,
      server: this.server,
      port: this.port
    };
  }
  async upload(cmd, data, fileSize, md5, extendInfo) {
    const trans = this.buildDataUpTrans(cmd, data, fileSize, md5, extendInfo);
    try {
      const tcpUploader = new HighwayTcpUploader(trans, this.logger);
      await tcpUploader.upload();
    } catch (e) {
      this.logger.error(`[Highway] upload failed: ${e}, fallback to http upload`);
      try {
        const httpUploader = new HighwayHttpUploader(trans, this.logger);
        await httpUploader.upload();
      } catch (e2) {
        this.logger.error(`[Highway] http upload failed: ${e2}`);
        throw e2;
      }
    }
  }
}

class ForwardMsgBuilder {
  static build(resId, msg, source, news, summary, prompt) {
    const id = crypto$1.randomUUID();
    const isGroupMsg = msg.some((m) => m.isGroupMsg);
    if (!source) {
      source = msg.length === 0 ? "聊天记录" : isGroupMsg ? "群聊的聊天记录" : msg.map((m) => m.senderName).filter((v, i, a) => a.indexOf(v) === i).slice(0, 4).join("和") + "的聊天记录";
    }
    if (!news) {
      news = msg.length === 0 ? [{
        text: "Nya~ This message is send from NapCat.Packet!"
      }] : msg.map((m) => ({
        text: `${m.senderName}: ${m.msg?.map((msg2) => msg2.preview).join("")}`
      }));
    }
    if (!summary) {
      summary = `查看${msg.length}条转发消息`;
    }
    if (!prompt) {
      prompt = "[聊天记录]";
    }
    return {
      app: "com.tencent.multimsg",
      config: {
        autosize: 1,
        forward: 1,
        round: 1,
        type: "normal",
        width: 300
      },
      desc: prompt,
      extra: {
        filename: id,
        tsum: msg.length
      },
      meta: {
        detail: {
          news,
          resid: resId,
          source,
          summary,
          uniseq: id
        }
      },
      prompt,
      ver: "0.0.0.5",
      view: "contact"
    };
  }
  static fromResId(resId) {
    return this.build(resId, []);
  }
  static fromPacketMsg(resId, packetMsg, source, news, summary, prompt) {
    return this.build(resId, packetMsg.map((msg) => ({
      senderName: msg.senderName,
      isGroupMsg: msg.groupId !== void 0,
      msg: msg.msg.map((m) => ({
        preview: m.valid ? m.toPreview() : "[该消息类型暂不支持查看]"
      }))
    })), source, news, summary, prompt);
  }
}

class IPacketMsgElement {
  constructor(_rawElement) {
  }
  get valid() {
    return true;
  }
  buildContent() {
    return void 0;
  }
  buildElement() {
    return [];
  }
  static parseElement;
  toPreview() {
    return "[暂不支持该消息类型喵~]";
  }
}
class PacketMsgTextElement extends IPacketMsgElement {
  text;
  constructor(element) {
    super(element);
    this.text = element.textElement.content;
  }
  buildElement() {
    return [{
      text: {
        str: this.text
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem.text?.str && (elem.text?.attr6Buf === void 0 || elem.text?.attr6Buf?.length === 0)) {
      return [{
        textElement: {
          content: elem.text?.str,
          atType: NTMsgAtType.ATTYPEUNKNOWN,
          atUid: "",
          atTinyId: "",
          atNtUid: ""
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    return void 0;
  };
  toPreview() {
    return this.text;
  }
}
class PacketMsgAtElement extends PacketMsgTextElement {
  targetUid;
  atAll;
  constructor(element) {
    super(element);
    this.targetUid = element.textElement.atNtUid;
    this.atAll = element.textElement.atType === NTMsgAtType.ATTYPEALL;
  }
  buildElement() {
    return [{
      text: {
        str: this.text,
        pbReserve: new NapProtoMsg(MentionExtra).encode(
          {
            type: this.atAll ? 1 : 2,
            uin: 0,
            field5: 0,
            uid: this.targetUid
          }
        )
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem.text?.str && (elem.text?.attr6Buf?.length ?? 100) >= 11) {
      return [{
        textElement: {
          content: elem.text?.str,
          atType: NTMsgAtType.ATTYPEONE,
          atUid: String(Buffer.from(elem.text.attr6Buf).readUInt32BE(7)),
          // FIXME: hack
          atTinyId: "",
          atNtUid: ""
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    return void 0;
  };
}
class PacketMsgReplyElement extends IPacketMsgElement {
  time;
  targetMessageId;
  targetMessageSeq;
  targetMessageClientSeq;
  targetUin;
  targetUid;
  targetElems;
  targetSourceMsg;
  targetPeer;
  constructor(element) {
    super(element);
    this.time = +(element.replyElement.replyMsgTime ?? Math.floor(Date.now() / 1e3));
    this.targetMessageId = BigInt(element.replyElement.replayMsgId ?? 0);
    this.targetMessageSeq = +(element.replyElement.replayMsgSeq ?? 0);
    this.targetMessageClientSeq = +(element.replyElement.replyMsgClientSeq ?? 0);
    this.targetUin = +(element.replyElement.senderUin ?? 0);
    this.targetUid = element.replyElement.senderUidStr ?? "";
    this.targetPeer = element.replyElement._replyMsgPeer;
  }
  get isGroupReply() {
    return this.targetMessageClientSeq === 0;
  }
  buildElement() {
    return [{
      srcMsg: {
        origSeqs: [this.isGroupReply ? this.targetMessageSeq : this.targetMessageClientSeq],
        senderUin: BigInt(this.targetUin),
        time: this.time,
        elems: this.targetElems ?? [],
        sourceMsg: new NapProtoMsg(PushMsgBody).encode(this.targetSourceMsg ?? {}),
        toUin: BigInt(0)
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem.srcMsg && elem.srcMsg.pbReserve) {
      const reserve = elem.srcMsg.pbReserve;
      return [{
        replyElement: {
          replayMsgSeq: String(reserve.friendSeq ?? elem.srcMsg?.origSeqs?.[0] ?? 0),
          replayMsgId: String(reserve.messageId ?? 0),
          senderUin: String(elem?.srcMsg ?? 0)
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    return void 0;
  };
  toPreview() {
    return "[回复消息]";
  }
}
class PacketMsgFaceElement extends IPacketMsgElement {
  faceId;
  isLargeFace;
  resultId;
  constructor(element) {
    super(element);
    this.faceId = element.faceElement.faceIndex;
    this.resultId = element.faceElement.resultId;
    this.isLargeFace = element.faceElement.faceType === FaceType.AniSticke;
  }
  buildElement() {
    if (this.isLargeFace) {
      return [{
        commonElem: {
          serviceType: 37,
          pbElem: new NapProtoMsg(QBigFaceExtra).encode({
            aniStickerPackId: "1",
            aniStickerId: "8",
            faceId: this.faceId,
            sourceType: 1,
            resultId: this.resultId,
            preview: "",
            randomType: 1
          }),
          businessType: 1
        }
      }];
    } else if (this.faceId < 260) {
      return [{
        face: {
          index: this.faceId
        }
      }];
    } else {
      return [{
        commonElem: {
          serviceType: 33,
          pbElem: new NapProtoMsg(QSmallFaceExtra).encode({
            faceId: this.faceId,
            preview: "",
            preview2: ""
          }),
          businessType: 1
        }
      }];
    }
  }
  static parseElement = (elem) => {
    if (elem.face?.index) {
      return [{
        faceElement: {
          faceIndex: elem.face.index,
          faceType: FaceType.Normal
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, null];
    }
    if (elem?.commonElem?.serviceType === 37 && elem?.commonElem?.pbElem) {
      const qface = new NapProtoMsg(QBigFaceExtra).decode(elem?.commonElem?.pbElem);
      if (qface?.faceId) {
        return [{
          faceElement: {
            faceIndex: qface.faceId,
            faceType: FaceType.Normal
          },
          elementType: ElementType.UNKNOWN,
          elementId: ""
        }, null];
      }
    }
    if (elem?.commonElem?.serviceType === 33 && elem?.commonElem?.pbElem) {
      const qface = new NapProtoMsg(QSmallFaceExtra).decode(elem?.commonElem?.pbElem);
      if (qface?.faceId) {
        return [{
          faceElement: {
            faceIndex: qface.faceId,
            faceType: FaceType.Normal
          },
          elementType: ElementType.UNKNOWN,
          elementId: ""
        }, null];
      }
    }
    return void 0;
  };
  toPreview() {
    return "[表情]";
  }
}
class PacketMsgMarkFaceElement extends IPacketMsgElement {
  emojiName;
  emojiId;
  emojiPackageId;
  emojiKey;
  constructor(element) {
    super(element);
    this.emojiName = element.marketFaceElement.faceName;
    this.emojiId = element.marketFaceElement.emojiId;
    this.emojiPackageId = element.marketFaceElement.emojiPackageId;
    this.emojiKey = element.marketFaceElement.key;
  }
  buildElement() {
    return [{
      marketFace: {
        faceName: this.emojiName,
        itemType: 6,
        faceInfo: 1,
        faceId: Buffer.from(this.emojiId, "hex"),
        tabId: this.emojiPackageId,
        subType: 3,
        key: this.emojiKey,
        imageWidth: 300,
        imageHeight: 300,
        pbReserve: {
          field8: 1
        }
      }
    }];
  }
  toPreview() {
    return `${this.emojiName}`;
  }
}
class PacketMsgPicElement extends IPacketMsgElement {
  path;
  name;
  size;
  md5;
  width;
  height;
  picType;
  picSubType;
  summary;
  sha1 = null;
  msgInfo = null;
  groupPicExt = null;
  c2cPicExt = null;
  constructor(element) {
    super(element);
    this.path = element.picElement.sourcePath;
    this.name = element.picElement.fileName;
    this.size = +element.picElement.fileSize;
    this.md5 = element.picElement.md5HexStr ?? "";
    this.width = element.picElement.picWidth;
    this.height = element.picElement.picHeight;
    this.picType = element.picElement.picType;
    this.picSubType = element.picElement.picSubType ?? 0;
    this.summary = element.picElement.summary === "" ? element.picElement.picSubType === 0 ? "[图片]" : "[动画表情]" : element.picElement.summary;
  }
  get valid() {
    return !!this.msgInfo;
  }
  buildElement() {
    if (!this.msgInfo) return [];
    return [{
      commonElem: {
        serviceType: 48,
        pbElem: new NapProtoMsg(MsgInfo).encode(this.msgInfo),
        businessType: 10
      }
    }];
  }
  static parseElement = (elem) => {
    if (elem?.commonElem?.serviceType === 48 || [10, 20].includes(elem?.commonElem?.businessType ?? 0)) {
      const extra = new NapProtoMsg(MsgInfo).decode(elem.commonElem.pbElem);
      const msgInfoBody = extra.msgInfoBody[0];
      const index = msgInfoBody?.index;
      return [{
        picElement: {
          fileSize: index?.info.fileSize ?? 0,
          picWidth: index?.info?.width ?? 0,
          picHeight: index?.info?.height ?? 0,
          fileName: index?.info?.fileHash ?? "",
          sourcePath: "",
          original: false,
          picType: PicType.NEWPIC_APNG,
          fileUuid: "",
          fileSubId: "",
          thumbFileSize: 0,
          summary: "[图片]",
          thumbPath: /* @__PURE__ */ new Map()
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      }, elem];
    }
    if (elem?.notOnlineImage) {
      const img = elem?.notOnlineImage;
      const preImg = {
        picElement: {
          fileSize: img.fileLen ?? 0,
          picWidth: img.picWidth ?? 0,
          picHeight: img.picHeight ?? 0,
          fileName: Buffer.from(img.picMd5).toString("hex") ?? "",
          sourcePath: "",
          original: false,
          picType: PicType.NEWPIC_APNG,
          fileUuid: "",
          fileSubId: "",
          thumbFileSize: 0,
          summary: "[图片]",
          thumbPath: /* @__PURE__ */ new Map()
        },
        elementType: ElementType.UNKNOWN,
        elementId: ""
      };
      if (img.origUrl?.includes("&fileid=")) {
        preImg.picElement.originImageUrl = `https://multimedia.nt.qq.com.cn${img.origUrl}`;
      } else {
        preImg.picElement.originImageUrl = `https://gchat.qpic.cn${img.origUrl}`;
      }
      return [preImg, elem];
    }
    return void 0;
  };
  toPreview() {
    return this.summary;
  }
}
class PacketMsgVideoElement extends IPacketMsgElement {
  fileSize;
  filePath;
  thumbSize;
  thumbPath;
  fileMd5;
  fileSha1;
  thumbMd5;
  thumbSha1;
  thumbWidth;
  thumbHeight;
  msgInfo = null;
  constructor(element) {
    super(element);
    this.fileSize = element.videoElement.fileSize;
    this.filePath = element.videoElement.filePath;
    this.thumbSize = element.videoElement.thumbSize;
    this.thumbPath = element.videoElement.thumbPath?.get(0);
    this.fileMd5 = element.videoElement.videoMd5;
    this.thumbMd5 = element.videoElement.thumbMd5;
    this.thumbWidth = element.videoElement.thumbWidth;
    this.thumbHeight = element.videoElement.thumbHeight;
  }
  get valid() {
    return !!this.msgInfo;
  }
  buildElement() {
    if (!this.msgInfo) return [];
    return [{
      commonElem: {
        serviceType: 48,
        pbElem: new NapProtoMsg(MsgInfo).encode(this.msgInfo),
        businessType: 21
      }
    }];
  }
  toPreview() {
    return "[视频]";
  }
}
class PacketMsgPttElement extends IPacketMsgElement {
  filePath;
  fileSize;
  fileMd5;
  fileSha1;
  fileDuration;
  msgInfo = null;
  constructor(element) {
    super(element);
    this.filePath = element.pttElement.filePath;
    this.fileSize = +element.pttElement.fileSize;
    this.fileMd5 = element.pttElement.md5HexStr;
    this.fileDuration = Math.round(element.pttElement.duration);
  }
  get valid() {
    return false;
  }
  buildElement() {
    return [];
  }
  toPreview() {
    return "[语音]";
  }
}
class PacketMsgFileElement extends IPacketMsgElement {
  fileName;
  filePath;
  fileSize;
  fileSha1;
  fileMd5;
  fileUuid;
  fileHash;
  isGroupFile;
  _private_send_uid;
  _private_recv_uid;
  _e37_800_rsp;
  constructor(element) {
    super(element);
    this.fileName = element.fileElement.fileName;
    this.filePath = element.fileElement.filePath;
    this.fileSize = +element.fileElement.fileSize;
  }
  get valid() {
    return this.isGroupFile || Boolean(this._e37_800_rsp);
  }
  buildContent() {
    if (this.isGroupFile || !this._e37_800_rsp) return void 0;
    return new NapProtoMsg(FileExtra).encode({
      file: {
        fileType: 0,
        fileUuid: this.fileUuid,
        fileMd5: this.fileMd5,
        fileName: this.fileName,
        fileSize: BigInt(this.fileSize),
        subcmd: 1,
        dangerEvel: 0,
        expireTime: Math.floor(Date.now() / 1e3) + 7 * 24 * 60 * 60,
        fileHash: this.fileHash
      },
      field6: {
        field2: {
          field1: this._e37_800_rsp?.body?.field30?.field110,
          fileUuid: this.fileUuid,
          fileName: this.fileName,
          field6: this._e37_800_rsp?.body?.field30?.field3,
          field7: this._e37_800_rsp?.body?.field30?.field101,
          field8: this._e37_800_rsp?.body?.field30?.field100,
          timestamp1: this._e37_800_rsp?.body?.field30?.timestamp1,
          fileHash: this.fileHash,
          selfUid: this._private_send_uid,
          destUid: this._private_recv_uid
        }
      }
    });
  }
  buildElement() {
    if (!this.isGroupFile) return [];
    const lb = Buffer.alloc(2);
    const transElemVal = new NapProtoMsg(GroupFileExtra).encode({
      field1: 6,
      fileName: this.fileName,
      inner: {
        info: {
          busId: 102,
          fileId: this.fileUuid,
          fileSize: BigInt(this.fileSize),
          fileName: this.fileName,
          fileSha: this.fileSha1,
          extInfoString: "",
          fileMd5: this.fileMd5
        }
      }
    });
    lb.writeUInt16BE(transElemVal.length);
    return [{
      transElem: {
        elemType: 24,
        elemValue: Buffer.concat([Buffer.from([1]), lb, transElemVal])
        // TLV
      }
    }];
  }
  toPreview() {
    return `[文件]${this.fileName}`;
  }
}
class PacketMsgLightAppElement extends IPacketMsgElement {
  payload;
  constructor(element) {
    super(element);
    this.payload = element.arkElement.bytesData;
  }
  buildElement() {
    return [{
      lightAppElem: {
        data: Buffer.concat([
          Buffer.from([1]),
          zlib.deflateSync(Buffer.from(this.payload, "utf-8"))
        ])
      }
    }];
  }
  toPreview() {
    return "[卡片消息]";
  }
}
class PacketMsgMarkDownElement extends IPacketMsgElement {
  content;
  constructor(element) {
    super(element);
    this.content = element.markdownElement.content;
  }
  buildElement() {
    return [{
      commonElem: {
        serviceType: 45,
        pbElem: new NapProtoMsg(MarkdownData).encode({
          content: this.content
        }),
        businessType: 1
      }
    }];
  }
  toPreview() {
    return `[Markdown消息 ${this.content}]`;
  }
}
class PacketMultiMsgElement extends IPacketMsgElement {
  resid;
  message;
  constructor(rawElement, message) {
    super(rawElement);
    this.resid = rawElement.multiForwardMsgElement.resId;
    this.message = message ?? [];
  }
  buildElement() {
    return [{
      lightAppElem: {
        data: Buffer.concat([
          Buffer.from([1]),
          zlib.deflateSync(Buffer.from(JSON.stringify(ForwardMsgBuilder.fromPacketMsg(this.resid, this.message)), "utf-8"))
        ])
      }
    }];
  }
  toPreview() {
    return "[聊天记录]";
  }
}

class PacketMsgBuilder {
  static failBackText = new PacketMsgTextElement(
    {
      textElement: { content: "[该消息类型暂不支持查看]" }
    }
  );
  buildFakeMsg(selfUid, element) {
    return element.map((node) => {
      const avatar = `https://q.qlogo.cn/headimg_dl?dst_uin=${node.senderUin}&spec=640&img_type=jpg`;
      const msgContent = node.msg.reduceRight((acc, msg) => {
        return acc ?? msg.buildContent();
      }, void 0);
      const msgElement = node.msg.flatMap((msg) => msg.buildElement() ?? []);
      if (!msgContent && !msgElement.length) {
        msgElement.push(PacketMsgBuilder.failBackText.buildElement());
      }
      return {
        responseHead: {
          fromUin: node.senderUin,
          type: 0,
          sigMap: 0,
          toUin: 0,
          fromUid: "",
          forward: node.groupId ? void 0 : {
            friendName: node.senderName
          },
          toUid: node.groupId ? void 0 : selfUid,
          grp: node.groupId ? {
            groupUin: node.groupId,
            memberName: node.senderName,
            unknown5: 2
          } : void 0
        },
        contentHead: {
          type: node.groupId ? 82 : 9,
          subType: node.groupId ? void 0 : 4,
          divSeq: node.groupId ? void 0 : 4,
          autoReply: 0,
          sequence: crypto$2.randomBytes(4).readUInt32LE(0),
          timeStamp: +node.time.toString().substring(0, 10),
          forward: {
            field1: 0,
            field2: 0,
            field3: node.groupId ? 1 : 2,
            unknownBase64: avatar,
            avatar
          }
        },
        body: {
          richText: {
            elems: msgElement
          },
          msgContent
        }
      };
    });
  }
}

const PacketBufBuilder = (str) => {
  return Buffer.from(str);
};
class PacketTransformer {
  msgBuilder;
  constructor() {
    this.msgBuilder = new PacketMsgBuilder();
  }
}

class FetchSessionKey extends PacketTransformer {
  build() {
    const req = new NapProtoMsg(HttpConn0x6ff_501).encode({
      httpConn: {
        field1: 0,
        field2: 0,
        field3: 16,
        field4: 1,
        field6: 3,
        serviceTypes: [1, 5, 10, 21],
        // tgt: "",  // TODO: do we really need tgt? seems not
        field9: 2,
        field10: 9,
        field11: 8,
        ver: "1.0.1"
      }
    });
    return {
      cmd: "HttpConn.0x6ff_501",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(HttpConn0x6ff_501Response).decode(data);
  }
}
const FetchSessionKey$1 = new FetchSessionKey();

const int32ip2str = (ip) => {
  ip = ip & 4294967295;
  return [ip & 255, (ip & 65280) >> 8, (ip & 16711680) >> 16, (ip & 4278190080) >> 24 & 255].join(".");
};
const oidbIpv4s2HighwayIpv4s = (ipv4s) => {
  return ipv4s.map((ip) => {
    return {
      domain: {
        isEnable: true,
        ip: int32ip2str(ip.outIP ?? 0)
      },
      port: ip.outPort
    };
  });
};

class Sha1Stream {
  Sha1BlockSize = 64;
  Sha1DigestSize = 20;
  _padding = Buffer.concat([Buffer.from([128]), Buffer.alloc(63)]);
  _state = new Uint32Array(5);
  _count = new Uint32Array(2);
  _buffer = Buffer.allocUnsafe(this.Sha1BlockSize);
  _w = new Uint32Array(80);
  constructor() {
    this.reset();
  }
  reset() {
    this._state[0] = 1732584193;
    this._state[1] = 4023233417;
    this._state[2] = 2562383102;
    this._state[3] = 271733878;
    this._state[4] = 3285377520;
    this._count[0] = 0;
    this._count[1] = 0;
    this._buffer.fill(0);
  }
  rotateLeft(v, o) {
    return (v << o | v >>> 32 - o) >>> 0;
  }
  transform(chunk, offset) {
    const w = this._w;
    const view = new DataView(chunk.buffer, chunk.byteOffset + offset, 64);
    for (let i = 0; i < 16; i++) {
      w[i] = view.getUint32(i * 4, false);
    }
    for (let i = 16; i < 80; i++) {
      w[i] = this.rotateLeft(w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16], 1) >>> 0;
    }
    let a = this._state[0];
    let b = this._state[1];
    let c = this._state[2];
    let d = this._state[3];
    let e = this._state[4];
    for (let i = 0; i < 80; i++) {
      let temp;
      if (i < 20) {
        temp = (b & c | ~b & d) + 1518500249;
      } else if (i < 40) {
        temp = (b ^ c ^ d) + 1859775393;
      } else if (i < 60) {
        temp = (b & c | b & d | c & d) + 2400959708;
      } else {
        temp = (b ^ c ^ d) + 3395469782;
      }
      temp += this.rotateLeft(a, 5) + e + w[i] >>> 0;
      e = d;
      d = c;
      c = this.rotateLeft(b, 30) >>> 0;
      b = a;
      a = temp;
    }
    this._state[0] = this._state[0] + a >>> 0;
    this._state[1] = this._state[1] + b >>> 0;
    this._state[2] = this._state[2] + c >>> 0;
    this._state[3] = this._state[3] + d >>> 0;
    this._state[4] = this._state[4] + e >>> 0;
  }
  update(data, len) {
    let index = (this._count[0] >>> 3 & 63) >>> 0;
    const dataLen = len ?? data.length;
    this._count[0] = this._count[0] + (dataLen << 3) >>> 0;
    if (this._count[0] < dataLen << 3) this._count[1] = this._count[1] + 1 >>> 0;
    this._count[1] = this._count[1] + (dataLen >>> 29) >>> 0;
    const partLen = this.Sha1BlockSize - index >>> 0;
    let i = 0;
    if (dataLen >= partLen) {
      data.copy(this._buffer, index, 0, partLen);
      this.transform(this._buffer, 0);
      for (i = partLen; i + this.Sha1BlockSize <= dataLen; i = i + this.Sha1BlockSize >>> 0) {
        this.transform(data, i);
      }
      index = 0;
    }
    data.copy(this._buffer, index, i, dataLen);
  }
  hash(bigEndian = true) {
    const digest = Buffer.allocUnsafe(this.Sha1DigestSize);
    if (bigEndian) {
      for (let i = 0; i < 5; i++) digest.writeUInt32BE(this._state[i], i * 4);
    } else {
      for (let i = 0; i < 5; i++) digest.writeUInt32LE(this._state[i], i * 4);
    }
    return digest;
  }
  final() {
    const digest = Buffer.allocUnsafe(this.Sha1DigestSize);
    const bits = Buffer.allocUnsafe(8);
    bits.writeUInt32BE(this._count[1], 0);
    bits.writeUInt32BE(this._count[0], 4);
    const index = (this._count[0] >>> 3 & 63) >>> 0;
    const padLen = (index < 56 ? 56 - index : 120 - index) >>> 0;
    this.update(this._padding, padLen);
    this.update(bits);
    for (let i = 0; i < 5; i++) {
      digest.writeUInt32BE(this._state[i], i * 4);
    }
    return digest;
  }
}

class CalculateStreamBytesTransform extends stream$3.Transform {
  blockSize = 1024 * 1024;
  sha1;
  buffer;
  bytesRead;
  byteArrayList;
  constructor() {
    super();
    this.sha1 = new Sha1Stream();
    this.buffer = Buffer.alloc(0);
    this.bytesRead = 0;
    this.byteArrayList = [];
  }
  _transform(chunk, _, callback) {
    try {
      this.buffer = Buffer.concat([this.buffer, chunk]);
      let offset = 0;
      while (this.buffer.length - offset >= this.sha1.Sha1BlockSize) {
        const block = this.buffer.subarray(offset, offset + this.sha1.Sha1BlockSize);
        this.sha1.update(block);
        offset += this.sha1.Sha1BlockSize;
        this.bytesRead += this.sha1.Sha1BlockSize;
        if (this.bytesRead % this.blockSize === 0) {
          const digest = this.sha1.hash(false);
          this.byteArrayList.push(Buffer.from(digest));
        }
      }
      this.buffer = this.buffer.subarray(offset);
      callback(null);
    } catch (err) {
      callback(err);
    }
  }
  _flush(callback) {
    try {
      if (this.buffer.length > 0) this.sha1.update(this.buffer);
      const finalDigest = this.sha1.final();
      this.byteArrayList.push(Buffer.from(finalDigest));
      for (const digest of this.byteArrayList) {
        this.push(digest);
      }
      callback(null);
    } catch (err) {
      callback(err);
    }
  }
}

function sha1Stream(readable) {
  return new Promise((resolve, reject) => {
    readable.on("error", reject);
    readable.pipe(crypto$2.createHash("sha1").on("error", reject).on("data", resolve));
  });
}
function md5Stream(readable) {
  return new Promise((resolve, reject) => {
    readable.on("error", reject);
    readable.pipe(crypto$2.createHash("md5").on("error", reject).on("data", resolve));
  });
}
function calculateSha1(filePath) {
  const readable = fs.createReadStream(filePath);
  return sha1Stream(readable);
}
function computeMd5AndLengthWithLimit(filePath, limit) {
  const readStream = fs.createReadStream(filePath, limit ? { start: 0, end: limit - 1 } : {});
  return md5Stream(readStream);
}
function calculateSha1StreamBytes(filePath) {
  return new Promise((resolve, reject) => {
    const readable = fs.createReadStream(filePath);
    const calculateStreamBytes = new CalculateStreamBytesTransform();
    const byteArrayList = [];
    calculateStreamBytes.on("data", (chunk) => {
      byteArrayList.push(chunk);
    });
    calculateStreamBytes.on("end", () => {
      resolve(byteArrayList);
    });
    calculateStreamBytes.on("error", (err) => {
      reject(err);
    });
    readable.pipe(calculateStreamBytes);
  });
}

class OidbBase extends PacketTransformer {
  build(cmd, subCmd, body, isUid = true, _isLafter = false) {
    const data = new NapProtoMsg(OidbSvcTrpcTcpBase).encode({
      command: cmd,
      subCommand: subCmd,
      body,
      isReserved: isUid ? 1 : 0
    });
    return {
      cmd: `OidbSvcTrpcTcp.0x${cmd.toString(16).toUpperCase()}_${subCmd}`,
      data: PacketBufBuilder(data)
    };
  }
  parse(data) {
    const res = new NapProtoMsg(OidbSvcTrpcTcpBase).decode(data);
    if (res.errorCode !== 0) {
      throw new Error(`OidbSvcTrpcTcpBase parse error: ${res.errorMsg} (code=${res.errorCode})`);
    }
    return res;
  }
}
const OidbBase$1 = new OidbBase();

class UploadGroupImage extends PacketTransformer {
  build(groupUin, img) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode(
      {
        reqHead: {
          common: {
            requestId: 1,
            command: 100
          },
          scene: {
            requestType: 2,
            businessType: 1,
            sceneType: 2,
            group: {
              groupUin
            }
          },
          client: {
            agentType: 2
          }
        },
        upload: {
          uploadInfo: [
            {
              fileInfo: {
                fileSize: +img.size,
                fileHash: img.md5,
                fileSha1: img.sha1,
                fileName: img.name,
                type: {
                  type: 1,
                  picFormat: img.picType,
                  // TODO: extend NapCat imgType /cc @MliKiowa
                  videoFormat: 0,
                  voiceFormat: 0
                },
                width: img.width,
                height: img.height,
                time: 0,
                original: 1
              },
              subFileType: 0
            }
          ],
          tryFastUploadCompleted: true,
          srvSendMsg: false,
          clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
          compatQMsgSceneType: 2,
          extBizInfo: {
            pic: {
              bizType: img.picSubType,
              bytesPbReserveTroop: {
                subType: img.picSubType
              },
              textSummary: img.summary
            },
            video: {
              bytesPbReserve: Buffer.alloc(0)
            },
            ptt: {
              bytesPbReserve: Buffer.alloc(0),
              bytesReserve: Buffer.alloc(0),
              bytesGeneralFlags: Buffer.alloc(0)
            }
          },
          clientSeq: 0,
          noNeedCompatMsg: false
        }
      }
    );
    return OidbBase$1.build(4548, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadGroupImage$1 = new UploadGroupImage();

class FetchAiVoiceList extends PacketTransformer {
  build(groupUin, chatType) {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0X929D_0).encode({
      groupUin,
      chatType
    });
    return OidbBase$1.build(37533, 0, data);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0X929D_0Resp).decode(oidbBody);
  }
}
const FetchAiVoiceList_default = new FetchAiVoiceList();

class GetAiVoice extends PacketTransformer {
  build(groupUin, voiceId, text, sessionId, chatType) {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0X929B_0).encode({
      groupUin,
      voiceId,
      text,
      chatType,
      session: {
        sessionId
      }
    });
    return OidbBase$1.build(37531, 0, data);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0X929B_0Resp).decode(oidbBody);
  }
}
const GetAiVoice_default = new GetAiVoice();

class GetMiniAppAdaptShareInfo extends PacketTransformer {
  build(req) {
    const data = new NapProtoMsg(MiniAppAdaptShareInfoReq).encode({
      appId: req.sdkId,
      body: {
        extInfo: {
          field2: Buffer.alloc(0)
        },
        appid: req.appId,
        title: req.title,
        desc: req.desc,
        time: BigInt(Date.now()),
        scene: req.scene,
        templateType: req.templateType,
        businessType: req.businessType,
        picUrl: req.picUrl,
        vidUrl: "",
        jumpUrl: req.jumpUrl,
        iconUrl: req.iconUrl,
        verType: req.verType,
        shareType: req.shareType,
        versionId: req.versionId,
        withShareTicket: req.withShareTicket,
        webURL: req.webUrl ?? "",
        appidRich: Buffer.alloc(0),
        template: {
          templateId: "",
          templateData: ""
        },
        field20: ""
      }
    });
    return {
      cmd: "LightAppSvc.mini_app_share.AdaptShareInfo",
      data: PacketBufBuilder(data)
    };
  }
  parse(data) {
    return new NapProtoMsg(MiniAppAdaptShareInfoResp).decode(data);
  }
}
const GetMiniAppAdaptShareInfo_default = new GetMiniAppAdaptShareInfo();

class GroupSign extends PacketTransformer {
  build(uin, groupCode) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XEB7).encode(
      {
        body: {
          uin: String(uin),
          groupUin: String(groupCode),
          version: "9.0.90"
        }
      }
    );
    return OidbBase$1.build(3767, 1, body, false, false);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
}
const GroupSign_default = new GroupSign();

class GetStrangerInfo extends PacketTransformer {
  build(uin) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XFE1_2).encode({
      uin,
      key: [{ key: 27372 }]
    });
    return OidbBase$1.build(4065, 2, body);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XFE1_2RSP).decode(oidbBody);
  }
}
const GetStrangerInfo_default = new GetStrangerInfo();

let SendPoke$1 = class SendPoke extends PacketTransformer {
  build(is_group, peer, target) {
    const payload = {
      uin: target,
      ext: 0,
      ...is_group ? { groupUin: peer } : { friendUin: peer }
    };
    const data = new NapProtoMsg(OidbSvcTrpcTcp0XED3_1).encode(payload);
    return OidbBase$1.build(3795, 1, data);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
};
const SendPoke_default = new SendPoke$1();

let SetSpecialTitle$1 = class SetSpecialTitle extends PacketTransformer {
  build(groupCode, uid, title) {
    const oidb_0x8FC_2 = new NapProtoMsg(OidbSvcTrpcTcp0X8FC_2).encode({
      groupUin: +groupCode,
      body: {
        targetUid: uid,
        specialTitle: title,
        expiredTime: -1,
        uinName: title
      }
    });
    return OidbBase$1.build(2300, 2, oidb_0x8FC_2, false, false);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
};
const SetSpecialTitle_default = new SetSpecialTitle$1();

class ImageOCR extends PacketTransformer {
  build(url) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0xE07_0).encode(
      {
        version: 1,
        client: 0,
        entrance: 1,
        ocrReqBody: {
          imageUrl: url,
          originMd5: "",
          afterCompressMd5: "",
          afterCompressFileSize: "",
          afterCompressWeight: "",
          afterCompressHeight: "",
          isCut: false
        }
      }
    );
    return OidbBase$1.build(3767, 1, body, false, false);
  }
  parse(data) {
    const base = OidbBase$1.parse(data);
    return new NapProtoMsg(OidbSvcTrpcTcp0xE07_0_Response).decode(base.body);
  }
}
const ImageOCR_default = new ImageOCR();

let MoveGroupFile$1 = class MoveGroupFile extends PacketTransformer {
  build(groupUin, fileUUID, currentParentDirectory, targetParentDirectory) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      move: {
        groupUin,
        appId: 5,
        busId: 102,
        fileId: fileUUID,
        parentDirectory: currentParentDirectory,
        targetDirectory: targetParentDirectory
      }
    });
    return OidbBase$1.build(1750, 5, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    const res = new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
    if (res.move.retCode !== 0) {
      throw new Error(`sendGroupFileMoveReq error: ${res.move.clientWording} (code=${res.move.retCode})`);
    }
    return res;
  }
};
const MoveGroupFile_default = new MoveGroupFile$1();

let RenameGroupFile$1 = class RenameGroupFile extends PacketTransformer {
  build(groupUin, fileUUID, currentParentDirectory, newName) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      rename: {
        groupUin,
        busId: 102,
        fileId: fileUUID,
        parentFolder: currentParentDirectory,
        newFileName: newName
      }
    });
    return OidbBase$1.build(1750, 4, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    const res = new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
    if (res.rename.retCode !== 0) {
      throw new Error(`sendGroupFileRenameReq error: ${res.rename.clientWording} (code=${res.rename.retCode})`);
    }
    return res;
  }
};
const RenameGroupFile_default = new RenameGroupFile$1();

let SetGroupTodo$1 = class SetGroupTodo extends PacketTransformer {
  build(peer, msgSeq) {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0XF90_1).encode({
      groupUin: peer,
      msgSeq: BigInt(msgSeq)
    });
    return OidbBase$1.build(3984, 1, data);
  }
  parse(data) {
    return OidbBase$1.parse(data);
  }
};
const SetGroupTodo_default = new SetGroupTodo$1();

class DownloadGroupFile extends PacketTransformer {
  build(groupUin, fileUUID) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      download: {
        groupUin,
        appId: 7,
        busId: 102,
        fileId: fileUUID
      }
    });
    return OidbBase$1.build(1750, 2, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    const res = new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
    if (res.download.retCode !== 0) {
      throw new Error(`sendGroupFileDownloadReq error: ${res.download.clientWording} (code=${res.download.retCode})`);
    }
    return res;
  }
}
const DownloadGroupFile_default = new DownloadGroupFile();

class DownloadGroupPtt extends PacketTransformer {
  build(groupUin, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 4,
          command: 200
        },
        scene: {
          requestType: 1,
          businessType: 3,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4718, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadGroupPtt_default = new DownloadGroupPtt();

class DownloadOfflineFile extends PacketTransformer {
  build(fileUUID, fileHash, senderUid, receiverUid) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XE37_800).encode({
      subCommand: 800,
      field2: 0,
      body: {
        senderUid,
        receiverUid,
        fileUuid: fileUUID,
        fileHash
      },
      field101: 3,
      field102: 1,
      field200: 1
    });
    return OidbBase$1.build(3639, 800, body, false, false);
  }
  // TODO:check
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XE37Response).decode(oidbBody);
  }
}
const DownloadOfflineFile_default = new DownloadOfflineFile();

class DownloadPrivateFile extends PacketTransformer {
  build(selfUid, fileUUID, fileHash) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XE37_1200).encode({
      subCommand: 1200,
      field2: 1,
      body: {
        receiverUid: selfUid,
        fileUuid: fileUUID,
        type: 2,
        fileHash,
        t2: 0
      },
      field101: 3,
      field102: 103,
      field200: 1,
      field99999: Buffer.from([192, 133, 44, 1])
    });
    return OidbBase$1.build(3639, 1200, body, false, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XE37_1200Response).decode(oidbBody);
  }
}
const DownloadPrivateFile_default = new DownloadPrivateFile();

class UploadGroupFile extends PacketTransformer {
  build(groupUin, file) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0x6D6).encode({
      file: {
        groupUin,
        appId: 4,
        busId: 102,
        entrance: 6,
        targetDirectory: "/",
        // TODO:
        fileName: file.fileName,
        localDirectory: `/${file.fileName}`,
        fileSize: BigInt(file.fileSize),
        fileMd5: file.fileMd5,
        fileSha1: file.fileSha1,
        fileSha3: Buffer.alloc(0),
        field15: true
      }
    });
    return OidbBase$1.build(1750, 0, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0x6D6Response).decode(oidbBody);
  }
}
const UploadGroupFile_default = new UploadGroupFile();

class UploadGroupPtt extends PacketTransformer {
  build(groupUin, ptt) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 3,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: ptt.fileSize,
              fileHash: ptt.fileMd5,
              fileSha1: ptt.fileSha1,
              fileName: `${ptt.fileMd5}.amr`,
              type: {
                type: 3,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 1
              },
              height: 0,
              width: 0,
              time: ptt.fileDuration,
              original: 0
            },
            subFileType: 0
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 2,
        extBizInfo: {
          pic: {
            textSummary: "Nya~"
          },
          video: {
            bytesPbReserve: Buffer.alloc(0)
          },
          ptt: {
            bytesPbReserve: Buffer.alloc(0),
            bytesReserve: Buffer.from([8, 0, 56, 0]),
            bytesGeneralFlags: Buffer.from([154, 1, 7, 170, 3, 4, 8, 8, 18, 0])
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4718, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const instance$1 = new UploadGroupPtt();

class UploadGroupVideo extends PacketTransformer {
  build(groupUin, video) {
    if (!video.fileSize || !video.thumbSize) throw new Error("video.fileSize or video.thumbSize is empty");
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 3,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: +video.fileSize,
              fileHash: video.fileMd5,
              fileSha1: video.fileSha1,
              fileName: "nya.mp4",
              type: {
                type: 2,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: 0,
              width: 0,
              time: 0,
              original: 0
            },
            subFileType: 0
          },
          {
            fileInfo: {
              fileSize: +video.thumbSize,
              fileHash: video.thumbMd5,
              fileSha1: video.thumbSha1,
              fileName: "nya.jpg",
              type: {
                type: 1,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: video.thumbHeight,
              width: video.thumbWidth,
              time: 0,
              original: 0
            },
            subFileType: 100
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 2,
        extBizInfo: {
          pic: {
            bizType: 0,
            textSummary: "Nya~"
          },
          video: {
            bytesPbReserve: Buffer.from([128, 1, 0])
          },
          ptt: {
            bytesPbReserve: Buffer.alloc(0),
            bytesReserve: Buffer.alloc(0),
            bytesGeneralFlags: Buffer.alloc(0)
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4586, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadGroupVideo_default = new UploadGroupVideo();

class UploadPrivateFile extends PacketTransformer {
  async build(selfUid, peerUid, file) {
    const body = new NapProtoMsg(OidbSvcTrpcTcp0XE37_1700).encode({
      command: 1700,
      seq: 0,
      upload: {
        senderUid: selfUid,
        receiverUid: peerUid,
        fileSize: file.fileSize,
        fileName: file.fileName,
        md510MCheckSum: await computeMd5AndLengthWithLimit(file.filePath, 10 * 1024 * 1024),
        sha1CheckSum: file.fileSha1,
        localPath: "/",
        md5CheckSum: file.fileMd5,
        sha3CheckSum: Buffer.alloc(0)
      },
      businessId: 3,
      clientType: 1,
      flagSupportMediaPlatform: 1
    });
    return OidbBase$1.build(3639, 1700, body, false, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0XE37Response).decode(oidbBody);
  }
}
const UploadPrivateFile_default = new UploadPrivateFile();

class UploadPrivateImage extends PacketTransformer {
  build(peerUin, img) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode(
      {
        reqHead: {
          common: {
            requestId: 1,
            command: 100
          },
          scene: {
            requestType: 2,
            businessType: 1,
            sceneType: 1,
            c2C: {
              accountType: 2,
              targetUid: peerUin
            }
          },
          client: {
            agentType: 2
          }
        },
        upload: {
          uploadInfo: [
            {
              fileInfo: {
                fileSize: +img.size,
                fileHash: img.md5,
                fileSha1: img.sha1,
                fileName: img.name,
                type: {
                  type: 1,
                  picFormat: img.picType,
                  // TODO: extend NapCat imgType /cc @MliKiowa
                  videoFormat: 0,
                  voiceFormat: 0
                },
                width: img.width,
                height: img.height,
                time: 0,
                original: 1
              },
              subFileType: 0
            }
          ],
          tryFastUploadCompleted: true,
          srvSendMsg: false,
          clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
          compatQMsgSceneType: 1,
          extBizInfo: {
            pic: {
              bizType: img.picSubType,
              bytesPbReserveC2C: {
                subType: img.picSubType
              },
              textSummary: img.summary
            },
            video: {
              bytesPbReserve: Buffer.alloc(0)
            },
            ptt: {
              bytesPbReserve: Buffer.alloc(0),
              bytesReserve: Buffer.alloc(0),
              bytesGeneralFlags: Buffer.alloc(0)
            }
          },
          clientSeq: 0,
          noNeedCompatMsg: false
        }
      }
    );
    return OidbBase$1.build(4549, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadPrivateImage_default = new UploadPrivateImage();

class UploadPrivatePtt extends PacketTransformer {
  build(peerUin, ptt) {
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 4,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 3,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: peerUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: ptt.fileSize,
              fileHash: ptt.fileMd5,
              fileSha1: ptt.fileSha1,
              fileName: `${ptt.fileMd5}.amr`,
              type: {
                type: 3,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 1
              },
              height: 0,
              width: 0,
              time: ptt.fileDuration,
              original: 0
            },
            subFileType: 0
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 1,
        extBizInfo: {
          pic: {
            textSummary: "Nya~"
          },
          ptt: {
            bytesReserve: Buffer.from([8, 0, 56, 0]),
            bytesGeneralFlags: Buffer.from([154, 1, 11, 170, 3, 8, 8, 4, 18, 4, 0, 0, 0, 0])
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4717, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadPrivatePtt_default = new UploadPrivatePtt();

class UploadPrivateVideo extends PacketTransformer {
  build(peerUin, video) {
    if (!video.fileSize || !video.thumbSize) throw new Error("video.fileSize or video.thumbSize is empty");
    const data = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 3,
          command: 100
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: peerUin
          }
        },
        client: {
          agentType: 2
        }
      },
      upload: {
        uploadInfo: [
          {
            fileInfo: {
              fileSize: +video.fileSize,
              fileHash: video.fileMd5,
              fileSha1: video.fileSha1,
              fileName: "nya.mp4",
              type: {
                type: 2,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: 0,
              width: 0,
              time: 0,
              original: 0
            },
            subFileType: 0
          },
          {
            fileInfo: {
              fileSize: +video.thumbSize,
              fileHash: video.thumbMd5,
              fileSha1: video.thumbSha1,
              fileName: "nya.jpg",
              type: {
                type: 1,
                picFormat: 0,
                videoFormat: 0,
                voiceFormat: 0
              },
              height: video.thumbHeight,
              width: video.thumbWidth,
              time: 0,
              original: 0
            },
            subFileType: 100
          }
        ],
        tryFastUploadCompleted: true,
        srvSendMsg: false,
        clientRandomId: crypto__default$1.randomBytes(8).readBigUInt64BE() & BigInt("0x7FFFFFFFFFFFFFFF"),
        compatQMsgSceneType: 2,
        extBizInfo: {
          pic: {
            bizType: 0,
            textSummary: "Nya~"
          },
          video: {
            bytesPbReserve: Buffer.from([128, 1, 0])
          },
          ptt: {
            bytesPbReserve: Buffer.alloc(0),
            bytesReserve: Buffer.alloc(0),
            bytesGeneralFlags: Buffer.alloc(0)
          }
        },
        clientSeq: 0,
        noNeedCompatMsg: false
      }
    });
    return OidbBase$1.build(4585, 100, data, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const UploadPrivateVideo_default = new UploadPrivateVideo();

class DownloadImage extends PacketTransformer {
  build(selfUid, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 1,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: selfUid
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4549, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadImage_default = new DownloadImage();

class DownloadGroupImage extends PacketTransformer {
  build(group_uin, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 1,
          sceneType: 2,
          group: {
            groupUin: group_uin
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4548, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadGroupImage_default = new DownloadGroupImage();

class DownloadVideo extends PacketTransformer {
  build(selfUid, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: selfUid
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4585, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadVideo_default = new DownloadVideo();

class DownloadGroupVideo extends PacketTransformer {
  build(groupUin, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 2,
          businessType: 2,
          sceneType: 2,
          group: {
            groupUin
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4586, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadGroupVideo_default = new DownloadGroupVideo();

class DownloadPtt extends PacketTransformer {
  build(selfUid, node) {
    const body = new NapProtoMsg(NTV2RichMediaReq).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 200
        },
        scene: {
          requestType: 1,
          businessType: 3,
          sceneType: 1,
          c2C: {
            accountType: 2,
            targetUid: selfUid
          }
        },
        client: {
          agentType: 2
        }
      },
      download: {
        node,
        download: {
          video: {
            busiType: 0,
            sceneType: 0
          }
        }
      }
    });
    return OidbBase$1.build(4717, 200, body, true, false);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(NTV2RichMediaResp).decode(oidbBody);
  }
}
const DownloadPtt_default = new DownloadPtt();

class UploadForwardMsg extends PacketTransformer {
  build(selfUid, msg, groupUin = 0) {
    const msgBody = this.msgBuilder.buildFakeMsg(selfUid, msg);
    const longMsgResultData = new NapProtoMsg(LongMsgResult).encode(
      {
        action: [{
          actionCommand: "MultiMsg",
          actionData: {
            msgBody
          }
        }]
      }
    );
    const payload = zlib__default.gzipSync(Buffer.from(longMsgResultData));
    const req = new NapProtoMsg(SendLongMsgReq).encode(
      {
        info: {
          type: groupUin === 0 ? 1 : 3,
          uid: {
            uid: groupUin === 0 ? selfUid : groupUin.toString()
          },
          groupUin,
          payload
        },
        settings: {
          field1: 4,
          field2: 1,
          field3: 7,
          field4: 0
        }
      }
    );
    return {
      cmd: "trpc.group.long_msg_interface.MsgService.SsoSendLongMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(SendLongMsgResp).decode(data);
  }
}
const UploadForwardMsg_default = new UploadForwardMsg();

class FetchGroupMessage extends PacketTransformer {
  build(groupUin, startSeq, endSeq) {
    const req = new NapProtoMsg(SsoGetGroupMsg).encode({
      info: {
        groupUin,
        startSequence: startSeq,
        endSequence: endSeq
      },
      direction: true
    });
    return {
      cmd: "trpc.msg.register_proxy.RegisterProxy.SsoGetGroupMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(SsoGetGroupMsgResponse).decode(data);
  }
}
const FetchGroupMessage_default = new FetchGroupMessage();

class FetchC2CMessage extends PacketTransformer {
  build(targetUid, startSeq, endSeq) {
    const req = new NapProtoMsg(SsoGetC2cMsg).encode({
      friendUid: targetUid,
      startSequence: startSeq,
      endSequence: endSeq
    });
    return {
      cmd: "trpc.msg.register_proxy.RegisterProxy.SsoGetC2cMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(SsoGetC2cMsgResponse).decode(data);
  }
}
const FetchC2CMessage_default = new FetchC2CMessage();

class DownloadForwardMsg extends PacketTransformer {
  build(uid, resId) {
    const req = new NapProtoMsg(RecvLongMsgReq).encode({
      info: {
        uid: {
          uid
        },
        resId,
        acquire: true
      },
      settings: {
        field1: 2,
        field2: 0,
        field3: 0,
        field4: 0
      }
    });
    return {
      cmd: "trpc.group.long_msg_interface.MsgService.SsoRecvLongMsg",
      data: PacketBufBuilder(req)
    };
  }
  parse(data) {
    return new NapProtoMsg(RecvLongMsgResp).decode(data);
  }
}
const DownloadForwardMsg_default = new DownloadForwardMsg();

class FetchRkey extends PacketTransformer {
  build() {
    const data = new NapProtoMsg(OidbSvcTrpcTcp0X9067_202).encode({
      reqHead: {
        common: {
          requestId: 1,
          command: 202
        },
        scene: {
          requestType: 2,
          businessType: 1,
          sceneType: 0
        },
        client: {
          agentType: 2
        }
      },
      downloadRKeyReq: {
        key: [10, 20, 2]
      }
    });
    return OidbBase$1.build(36967, 202, data);
  }
  parse(data) {
    const oidbBody = OidbBase$1.parse(data).body;
    return new NapProtoMsg(OidbSvcTrpcTcp0X9067_202_Rsp_Body).decode(oidbBody);
  }
}
const FetchRkey_default = new FetchRkey();

const BlockSize = 1024 * 1024;
class PacketHighwayContext {
  napcore;
  client;
  sig;
  logger;
  hwClient;
  cachedPrepareReq = null;
  constructor(napcore, logger, client) {
    this.napcore = napcore;
    this.client = client;
    this.sig = {
      uin: String(this.napcore.basicInfo.uin),
      uid: this.napcore.basicInfo.uid,
      sigSession: null,
      sessionKey: null,
      serverAddr: []
    };
    this.logger = logger;
    this.hwClient = new PacketHighwayClient(this.sig, this.logger);
  }
  async checkAvailable() {
    if (this.sig.sigSession === null || this.sig.sessionKey === null) {
      if (this.cachedPrepareReq === null) {
        this.cachedPrepareReq = this.prepareUpload().finally(() => {
          this.cachedPrepareReq = null;
        });
      }
      await this.cachedPrepareReq;
    }
  }
  async prepareUpload() {
    this.logger.debug("[Highway] on prepareUpload!");
    const packet = FetchSessionKey$1.build();
    const req = await this.client.sendOidbPacket(packet, true);
    const rsp = FetchSessionKey$1.parse(req);
    this.sig.sigSession = rsp.httpConn.sigSession;
    this.sig.sessionKey = rsp.httpConn.sessionKey;
    for (const info of rsp.httpConn.serverInfos) {
      if (info.serviceType !== 1) continue;
      for (const addr of info.serverAddrs) {
        this.logger.debug(`[Highway PrepareUpload] server addr add: ${int32ip2str(addr.ip)}:${addr.port}`);
        this.sig.serverAddr.push({
          ip: int32ip2str(addr.ip),
          port: addr.port
        });
        this.hwClient.changeServer(int32ip2str(addr.ip), addr.port);
      }
    }
    if (this.sig.serverAddr.length === 0) {
      this.logger.warn("[Highway PrepareUpload] server addr is empty!");
    }
  }
  async uploadImage(peer, img) {
    await this.checkAvailable();
    if (peer.chatType === ChatType.KCHATTYPEGROUP) {
      await this.uploadGroupImage(+peer.peerUid, img);
    } else if (peer.chatType === ChatType.KCHATTYPEC2C) {
      await this.uploadC2CImage(peer.peerUid, img);
    } else {
      throw new Error(`[Highway] unsupported chatType: ${peer.chatType}`);
    }
  }
  async uploadVideo(peer, video) {
    await this.checkAvailable();
    if (+(video.fileSize ?? 0) > 1024 * 1024 * 100) {
      throw new Error(`[Highway] 视频文件过大: ${(+(video.fileSize ?? 0) / (1024 * 1024)).toFixed(2)} MB > 100 MB，请使用文件上传！`);
    }
    if (peer.chatType === ChatType.KCHATTYPEGROUP) {
      await this.uploadGroupVideo(+peer.peerUid, video);
    } else if (peer.chatType === ChatType.KCHATTYPEC2C) {
      await this.uploadC2CVideo(peer.peerUid, video);
    } else {
      throw new Error(`[Highway] unsupported chatType: ${peer.chatType}`);
    }
  }
  async uploadPtt(peer, ptt) {
    await this.checkAvailable();
    if (peer.chatType === ChatType.KCHATTYPEGROUP) {
      await this.uploadGroupPtt(+peer.peerUid, ptt);
    } else if (peer.chatType === ChatType.KCHATTYPEC2C) {
      await this.uploadC2CPtt(peer.peerUid, ptt);
    } else {
      throw new Error(`[Highway] unsupported chatType: ${peer.chatType}`);
    }
  }
  async uploadFile(peer, file) {
    await this.checkAvailable();
    if (peer.chatType === ChatType.KCHATTYPEGROUP) {
      await this.uploadGroupFile(+peer.peerUid, file);
    } else if (peer.chatType === ChatType.KCHATTYPEC2C) {
      await this.uploadC2CFile(peer.peerUid, file);
    } else {
      throw new Error(`[Highway] unsupported chatType: ${peer.chatType}`);
    }
  }
  async uploadGroupImage(groupUin, img) {
    img.sha1 = Buffer.from(await calculateSha1(img.path)).toString("hex");
    const req = UploadGroupImage$1.build(groupUin, img);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadGroupImage$1.parse(resp);
    const ukey = preRespData.upload.uKey;
    if (ukey && ukey !== "") {
      this.logger.debug(`[Highway] uploadGroupImageReq get upload ukey: ${ukey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[0].index;
      const sha1 = Buffer.from(index.info.fileSha1, "hex");
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: ukey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(preRespData.upload.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: [sha1]
        }
      });
      await this.hwClient.upload(
        1004,
        fs__default.createReadStream(img.path, { highWaterMark: BlockSize }),
        img.size,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadGroupImageReq get upload invalid ukey ${ukey}, don't need upload!`);
    }
    img.msgInfo = preRespData.upload.msgInfo;
  }
  async uploadC2CImage(peerUid, img) {
    img.sha1 = Buffer.from(await calculateSha1(img.path)).toString("hex");
    const req = UploadPrivateImage_default.build(peerUid, img);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadPrivateImage_default.parse(resp);
    const ukey = preRespData.upload.uKey;
    if (ukey && ukey !== "") {
      this.logger.debug(`[Highway] uploadC2CImageReq get upload ukey: ${ukey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[0].index;
      const sha1 = Buffer.from(index.info.fileSha1, "hex");
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: ukey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(preRespData.upload.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: [sha1]
        }
      });
      await this.hwClient.upload(
        1003,
        fs__default.createReadStream(img.path, { highWaterMark: BlockSize }),
        img.size,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadC2CImageReq get upload invalid ukey ${ukey}, don't need upload!`);
    }
    img.msgInfo = preRespData.upload.msgInfo;
  }
  async uploadGroupVideo(groupUin, video) {
    if (!video.filePath || !video.thumbPath) throw new Error("video.filePath or video.thumbPath is empty");
    video.fileSha1 = Buffer.from(await calculateSha1(video.filePath)).toString("hex");
    video.thumbSha1 = Buffer.from(await calculateSha1(video.thumbPath)).toString("hex");
    const req = UploadGroupVideo_default.build(groupUin, video);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadGroupVideo_default.parse(resp);
    const ukey = preRespData.upload.uKey;
    if (ukey && ukey !== "") {
      this.logger.debug(`[Highway] uploadGroupVideoReq get upload video ukey: ${ukey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[0].index;
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: ukey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(preRespData.upload.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: await calculateSha1StreamBytes(video.filePath)
        }
      });
      await this.hwClient.upload(
        1005,
        fs__default.createReadStream(video.filePath, { highWaterMark: BlockSize }),
        +video.fileSize,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadGroupVideoReq get upload invalid ukey ${ukey}, don't need upload!`);
    }
    const subFile = preRespData.upload.subFileInfos[0];
    if (subFile.uKey && subFile.uKey !== "") {
      this.logger.debug(`[Highway] uploadGroupVideoReq get upload video thumb ukey: ${subFile.uKey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[1].index;
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const sha1 = Buffer.from(index.info.fileSha1, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: subFile.uKey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(subFile.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: [sha1]
        }
      });
      await this.hwClient.upload(
        1006,
        fs__default.createReadStream(video.thumbPath, { highWaterMark: BlockSize }),
        +video.thumbSize,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadGroupVideoReq get upload invalid thumb ukey ${subFile.uKey}, don't need upload!`);
    }
    video.msgInfo = preRespData.upload.msgInfo;
  }
  async uploadC2CVideo(peerUid, video) {
    if (!video.filePath || !video.thumbPath) throw new Error("video.filePath or video.thumbPath is empty");
    video.fileSha1 = Buffer.from(await calculateSha1(video.filePath)).toString("hex");
    video.thumbSha1 = Buffer.from(await calculateSha1(video.thumbPath)).toString("hex");
    const req = UploadPrivateVideo_default.build(peerUid, video);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadPrivateVideo_default.parse(resp);
    const ukey = preRespData.upload.uKey;
    if (ukey && ukey !== "") {
      this.logger.debug(`[Highway] uploadC2CVideoReq get upload video ukey: ${ukey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[0].index;
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: ukey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(preRespData.upload.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: await calculateSha1StreamBytes(video.filePath)
        }
      });
      await this.hwClient.upload(
        1001,
        fs__default.createReadStream(video.filePath, { highWaterMark: BlockSize }),
        +video.fileSize,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadC2CVideoReq get upload invalid ukey ${ukey}, don't need upload!`);
    }
    const subFile = preRespData.upload.subFileInfos[0];
    if (subFile.uKey && subFile.uKey !== "") {
      this.logger.debug(`[Highway] uploadC2CVideoReq get upload video thumb ukey: ${subFile.uKey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[1].index;
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const sha1 = Buffer.from(index.info.fileSha1, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: subFile.uKey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(subFile.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: [sha1]
        }
      });
      await this.hwClient.upload(
        1002,
        fs__default.createReadStream(video.thumbPath, { highWaterMark: BlockSize }),
        +video.thumbSize,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadC2CVideoReq get upload invalid thumb ukey ${subFile.uKey}, don't need upload!`);
    }
    video.msgInfo = preRespData.upload.msgInfo;
  }
  async uploadGroupPtt(groupUin, ptt) {
    ptt.fileSha1 = Buffer.from(await calculateSha1(ptt.filePath)).toString("hex");
    const req = instance$1.build(groupUin, ptt);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = instance$1.parse(resp);
    const ukey = preRespData.upload.uKey;
    if (ukey && ukey !== "") {
      this.logger.debug(`[Highway] uploadGroupPttReq get upload ptt ukey: ${ukey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[0].index;
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const sha1 = Buffer.from(index.info.fileSha1, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: ukey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(preRespData.upload.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: [sha1]
        }
      });
      await this.hwClient.upload(
        1008,
        fs__default.createReadStream(ptt.filePath, { highWaterMark: BlockSize }),
        ptt.fileSize,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadGroupPttReq get upload invalid ukey ${ukey}, don't need upload!`);
    }
    ptt.msgInfo = preRespData.upload.msgInfo;
  }
  async uploadC2CPtt(peerUid, ptt) {
    ptt.fileSha1 = Buffer.from(await calculateSha1(ptt.filePath)).toString("hex");
    const req = UploadPrivatePtt_default.build(peerUid, ptt);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadPrivatePtt_default.parse(resp);
    const ukey = preRespData.upload.uKey;
    if (ukey && ukey !== "") {
      this.logger.debug(`[Highway] uploadC2CPttReq get upload ptt ukey: ${ukey}, need upload!`);
      const index = preRespData.upload.msgInfo.msgInfoBody[0].index;
      const md5 = Buffer.from(index.info.fileHash, "hex");
      const sha1 = Buffer.from(index.info.fileSha1, "hex");
      const extend = new NapProtoMsg(NTV2RichMediaHighwayExt).encode({
        fileUuid: index.fileUuid,
        uKey: ukey,
        network: {
          ipv4S: oidbIpv4s2HighwayIpv4s(preRespData.upload.ipv4S)
        },
        msgInfoBody: preRespData.upload.msgInfo.msgInfoBody,
        blockSize: BlockSize,
        hash: {
          fileSha1: [sha1]
        }
      });
      await this.hwClient.upload(
        1007,
        fs__default.createReadStream(ptt.filePath, { highWaterMark: BlockSize }),
        ptt.fileSize,
        md5,
        extend
      );
    } else {
      this.logger.debug(`[Highway] uploadC2CPttReq get upload invalid ukey ${ukey}, don't need upload!`);
    }
    ptt.msgInfo = preRespData.upload.msgInfo;
  }
  async uploadGroupFile(groupUin, file) {
    file.isGroupFile = true;
    file.fileMd5 = await computeMd5AndLengthWithLimit(file.filePath);
    file.fileSha1 = await calculateSha1(file.filePath);
    const req = UploadGroupFile_default.build(groupUin, file);
    const resp = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadGroupFile_default.parse(resp);
    if (!preRespData?.upload?.boolFileExist) {
      this.logger.debug("[Highway] uploadGroupFileReq file not exist, need upload!");
      const ext = new NapProtoMsg(FileUploadExt).encode({
        unknown1: 100,
        unknown2: 1,
        entry: {
          busiBuff: {
            senderUin: BigInt(this.sig.uin),
            receiverUin: BigInt(groupUin),
            groupCode: BigInt(groupUin)
          },
          fileEntry: {
            fileSize: BigInt(file.fileSize),
            md5: file.fileMd5,
            md5S2: file.fileMd5,
            checkKey: preRespData.upload.checkKey,
            fileId: preRespData.upload.fileId,
            uploadKey: preRespData.upload.fileKey
          },
          clientInfo: {
            clientType: 3,
            appId: "100",
            terminalType: 3,
            clientVer: "1.1.1",
            unknown: 4
          },
          fileNameInfo: {
            fileName: file.fileName
          },
          host: {
            hosts: [
              {
                url: {
                  host: preRespData.upload.uploadIp,
                  unknown: 1
                },
                port: preRespData.upload.uploadPort
              }
            ]
          }
        },
        unknown200: 0
      });
      await this.hwClient.upload(
        71,
        fs__default.createReadStream(file.filePath, { highWaterMark: BlockSize }),
        file.fileSize,
        file.fileMd5,
        ext
      );
    } else {
      this.logger.debug("[Highway] uploadGroupFileReq file exist, don't need upload!");
    }
    file.fileUuid = preRespData.upload.fileId;
  }
  async uploadC2CFile(peerUid, file) {
    file.isGroupFile = false;
    file.fileMd5 = await computeMd5AndLengthWithLimit(file.filePath);
    file.fileSha1 = await calculateSha1(file.filePath);
    const req = await UploadPrivateFile_default.build(this.sig.uid, peerUid, file);
    const res = await this.client.sendOidbPacket(req, true);
    const preRespData = UploadPrivateFile_default.parse(res);
    if (!preRespData.upload?.boolFileExist) {
      this.logger.debug("[Highway] uploadC2CFileReq file not exist, need upload!");
      const ext = new NapProtoMsg(FileUploadExt).encode({
        unknown1: 100,
        unknown2: 1,
        entry: {
          busiBuff: {
            senderUin: BigInt(this.sig.uin)
          },
          fileEntry: {
            fileSize: BigInt(file.fileSize),
            md5: file.fileMd5,
            md5S2: file.fileMd5,
            checkKey: file.fileSha1,
            fileId: preRespData.upload?.uuid,
            uploadKey: preRespData.upload?.mediaPlatformUploadKey
          },
          clientInfo: {
            clientType: 3,
            appId: "100",
            terminalType: 3,
            clientVer: "1.1.1",
            unknown: 4
          },
          fileNameInfo: {
            fileName: file.fileName
          },
          host: {
            hosts: [
              {
                url: {
                  host: preRespData.upload?.uploadIp,
                  unknown: 1
                },
                port: preRespData.upload?.uploadPort
              }
            ]
          }
        },
        unknown200: 1,
        unknown3: 0
      });
      await this.hwClient.upload(
        95,
        fs__default.createReadStream(file.filePath, { highWaterMark: BlockSize }),
        file.fileSize,
        file.fileMd5,
        ext
      );
    }
    file.fileUuid = preRespData.upload?.uuid;
    file.fileHash = preRespData.upload?.fileAddon;
    const fileExistReq = DownloadOfflineFile_default.build(file.fileUuid, file.fileHash, this.sig.uid, peerUid);
    const fileExistRes = await this.client.sendOidbPacket(fileExistReq, true);
    file._e37_800_rsp = DownloadOfflineFile_default.parse(fileExistRes);
    file._private_send_uid = this.sig.uid;
    file._private_recv_uid = peerUid;
  }
}

var winston$1 = {};

var browser$4 = {};

var format$4;
var hasRequiredFormat$3;

function requireFormat$3 () {
	if (hasRequiredFormat$3) return format$4;
	hasRequiredFormat$3 = 1;

	/*
	 * Displays a helpful message and the source of
	 * the format when it is invalid.
	 */
	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _createClass(e, r, t) { return Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
	function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
	function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
	function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: true, configurable: true } }), Object.defineProperty(t, "prototype", { writable: false }), e && _setPrototypeOf(t, e); }
	function _wrapNativeSuper(t) { var r = "function" == typeof Map ? new Map() : void 0; return _wrapNativeSuper = function _wrapNativeSuper(t) { if (null === t || !_isNativeFunction(t)) return t; if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function"); if (void 0 !== r) { if (r.has(t)) return r.get(t); r.set(t, Wrapper); } function Wrapper() { return _construct(t, arguments, _getPrototypeOf(this).constructor); } return Wrapper.prototype = Object.create(t.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }), _setPrototypeOf(Wrapper, t); }, _wrapNativeSuper(t); }
	function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
	function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
	function _isNativeFunction(t) { try { return -1 !== Function.toString.call(t).indexOf("[native code]"); } catch (n) { return "function" == typeof t; } }
	function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
	function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
	var InvalidFormatError = /*#__PURE__*/function (_Error) {
	  function InvalidFormatError(formatFn) {
	    var _this;
	    _classCallCheck(this, InvalidFormatError);
	    _this = _callSuper(this, InvalidFormatError, ["Format functions must be synchronous taking a two arguments: (info, opts)\nFound: ".concat(formatFn.toString().split('\n')[0], "\n")]);
	    Error.captureStackTrace(_this, InvalidFormatError);
	    return _this;
	  }
	  _inherits(InvalidFormatError, _Error);
	  return _createClass(InvalidFormatError);
	}(/*#__PURE__*/_wrapNativeSuper(Error));
	/*
	 * function format (formatFn)
	 * Returns a create function for the `formatFn`.
	 */
	format$4 = function (formatFn) {
	  if (formatFn.length > 2) {
	    throw new InvalidFormatError(formatFn);
	  }

	  /*
	   * function Format (options)
	   * Base prototype which calls a `_format`
	   * function and pushes the result.
	   */
	  function Format() {
	    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    this.options = options;
	  }
	  Format.prototype.transform = formatFn;

	  //
	  // Create a function which returns new instances of
	  // FormatWrap for simple syntax like:
	  //
	  // require('winston').formats.json();
	  //
	  function createFormatWrap(opts) {
	    return new Format(opts);
	  }

	  //
	  // Expose the FormatWrap through the create function
	  // for testability.
	  //
	  createFormatWrap.Format = Format;
	  return createFormatWrap;
	};
	return format$4;
}

var colorize = {exports: {}};

var safe = {exports: {}};

var colors = {exports: {}};

var styles = {exports: {}};

/*
The MIT License (MIT)

Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

var hasRequiredStyles;

function requireStyles () {
	if (hasRequiredStyles) return styles.exports;
	hasRequiredStyles = 1;
	(function (module) {
		var styles = {};
		module['exports'] = styles;

		var codes = {
		  reset: [0, 0],

		  bold: [1, 22],
		  dim: [2, 22],
		  italic: [3, 23],
		  underline: [4, 24],
		  inverse: [7, 27],
		  hidden: [8, 28],
		  strikethrough: [9, 29],

		  black: [30, 39],
		  red: [31, 39],
		  green: [32, 39],
		  yellow: [33, 39],
		  blue: [34, 39],
		  magenta: [35, 39],
		  cyan: [36, 39],
		  white: [37, 39],
		  gray: [90, 39],
		  grey: [90, 39],

		  brightRed: [91, 39],
		  brightGreen: [92, 39],
		  brightYellow: [93, 39],
		  brightBlue: [94, 39],
		  brightMagenta: [95, 39],
		  brightCyan: [96, 39],
		  brightWhite: [97, 39],

		  bgBlack: [40, 49],
		  bgRed: [41, 49],
		  bgGreen: [42, 49],
		  bgYellow: [43, 49],
		  bgBlue: [44, 49],
		  bgMagenta: [45, 49],
		  bgCyan: [46, 49],
		  bgWhite: [47, 49],
		  bgGray: [100, 49],
		  bgGrey: [100, 49],

		  bgBrightRed: [101, 49],
		  bgBrightGreen: [102, 49],
		  bgBrightYellow: [103, 49],
		  bgBrightBlue: [104, 49],
		  bgBrightMagenta: [105, 49],
		  bgBrightCyan: [106, 49],
		  bgBrightWhite: [107, 49],

		  // legacy styles for colors pre v1.0.0
		  blackBG: [40, 49],
		  redBG: [41, 49],
		  greenBG: [42, 49],
		  yellowBG: [43, 49],
		  blueBG: [44, 49],
		  magentaBG: [45, 49],
		  cyanBG: [46, 49],
		  whiteBG: [47, 49],

		};

		Object.keys(codes).forEach(function(key) {
		  var val = codes[key];
		  var style = styles[key] = [];
		  style.open = '\u001b[' + val[0] + 'm';
		  style.close = '\u001b[' + val[1] + 'm';
		}); 
	} (styles));
	return styles.exports;
}

/*
MIT License

Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

var hasFlag;
var hasRequiredHasFlag;

function requireHasFlag () {
	if (hasRequiredHasFlag) return hasFlag;
	hasRequiredHasFlag = 1;

	hasFlag = function(flag, argv) {
	  argv = argv || process.argv || [];

	  var terminatorPos = argv.indexOf('--');
	  var prefix = /^-{1,2}/.test(flag) ? '' : '--';
	  var pos = argv.indexOf(prefix + flag);

	  return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
	};
	return hasFlag;
}

/*
The MIT License (MIT)

Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

var supportsColors;
var hasRequiredSupportsColors;

function requireSupportsColors () {
	if (hasRequiredSupportsColors) return supportsColors;
	hasRequiredSupportsColors = 1;

	var os = os__default;
	var hasFlag = requireHasFlag();

	var env = process.env;

	var forceColor = void 0;
	if (hasFlag('no-color') || hasFlag('no-colors') || hasFlag('color=false')) {
	  forceColor = false;
	} else if (hasFlag('color') || hasFlag('colors') || hasFlag('color=true')
	           || hasFlag('color=always')) {
	  forceColor = true;
	}
	if ('FORCE_COLOR' in env) {
	  forceColor = env.FORCE_COLOR.length === 0
	    || parseInt(env.FORCE_COLOR, 10) !== 0;
	}

	function translateLevel(level) {
	  if (level === 0) {
	    return false;
	  }

	  return {
	    level: level,
	    hasBasic: true,
	    has256: level >= 2,
	    has16m: level >= 3,
	  };
	}

	function supportsColor(stream) {
	  if (forceColor === false) {
	    return 0;
	  }

	  if (hasFlag('color=16m') || hasFlag('color=full')
	      || hasFlag('color=truecolor')) {
	    return 3;
	  }

	  if (hasFlag('color=256')) {
	    return 2;
	  }

	  if (stream && !stream.isTTY && forceColor !== true) {
	    return 0;
	  }

	  var min = forceColor ? 1 : 0;

	  if (process.platform === 'win32') {
	    // Node.js 7.5.0 is the first version of Node.js to include a patch to
	    // libuv that enables 256 color output on Windows. Anything earlier and it
	    // won't work. However, here we target Node.js 8 at minimum as it is an LTS
	    // release, and Node.js 7 is not. Windows 10 build 10586 is the first
	    // Windows release that supports 256 colors. Windows 10 build 14931 is the
	    // first release that supports 16m/TrueColor.
	    var osRelease = os.release().split('.');
	    if (Number(process.versions.node.split('.')[0]) >= 8
	        && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
	      return Number(osRelease[2]) >= 14931 ? 3 : 2;
	    }

	    return 1;
	  }

	  if ('CI' in env) {
	    if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(function(sign) {
	      return sign in env;
	    }) || env.CI_NAME === 'codeship') {
	      return 1;
	    }

	    return min;
	  }

	  if ('TEAMCITY_VERSION' in env) {
	    return (/^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0
	    );
	  }

	  if ('TERM_PROGRAM' in env) {
	    var version = parseInt((env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

	    switch (env.TERM_PROGRAM) {
	      case 'iTerm.app':
	        return version >= 3 ? 3 : 2;
	      case 'Hyper':
	        return 3;
	      case 'Apple_Terminal':
	        return 2;
	      // No default
	    }
	  }

	  if (/-256(color)?$/i.test(env.TERM)) {
	    return 2;
	  }

	  if (/^screen|^xterm|^vt100|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
	    return 1;
	  }

	  if ('COLORTERM' in env) {
	    return 1;
	  }

	  if (env.TERM === 'dumb') {
	    return min;
	  }

	  return min;
	}

	function getSupportLevel(stream) {
	  var level = supportsColor(stream);
	  return translateLevel(level);
	}

	supportsColors = {
	  supportsColor: getSupportLevel,
	  stdout: getSupportLevel(process.stdout),
	  stderr: getSupportLevel(process.stderr),
	};
	return supportsColors;
}

var trap = {exports: {}};

var hasRequiredTrap;

function requireTrap () {
	if (hasRequiredTrap) return trap.exports;
	hasRequiredTrap = 1;
	(function (module) {
		module['exports'] = function runTheTrap(text, options) {
		  var result = '';
		  text = text || 'Run the trap, drop the bass';
		  text = text.split('');
		  var trap = {
		    a: ['\u0040', '\u0104', '\u023a', '\u0245', '\u0394', '\u039b', '\u0414'],
		    b: ['\u00df', '\u0181', '\u0243', '\u026e', '\u03b2', '\u0e3f'],
		    c: ['\u00a9', '\u023b', '\u03fe'],
		    d: ['\u00d0', '\u018a', '\u0500', '\u0501', '\u0502', '\u0503'],
		    e: ['\u00cb', '\u0115', '\u018e', '\u0258', '\u03a3', '\u03be', '\u04bc',
		      '\u0a6c'],
		    f: ['\u04fa'],
		    g: ['\u0262'],
		    h: ['\u0126', '\u0195', '\u04a2', '\u04ba', '\u04c7', '\u050a'],
		    i: ['\u0f0f'],
		    j: ['\u0134'],
		    k: ['\u0138', '\u04a0', '\u04c3', '\u051e'],
		    l: ['\u0139'],
		    m: ['\u028d', '\u04cd', '\u04ce', '\u0520', '\u0521', '\u0d69'],
		    n: ['\u00d1', '\u014b', '\u019d', '\u0376', '\u03a0', '\u048a'],
		    o: ['\u00d8', '\u00f5', '\u00f8', '\u01fe', '\u0298', '\u047a', '\u05dd',
		      '\u06dd', '\u0e4f'],
		    p: ['\u01f7', '\u048e'],
		    q: ['\u09cd'],
		    r: ['\u00ae', '\u01a6', '\u0210', '\u024c', '\u0280', '\u042f'],
		    s: ['\u00a7', '\u03de', '\u03df', '\u03e8'],
		    t: ['\u0141', '\u0166', '\u0373'],
		    u: ['\u01b1', '\u054d'],
		    v: ['\u05d8'],
		    w: ['\u0428', '\u0460', '\u047c', '\u0d70'],
		    x: ['\u04b2', '\u04fe', '\u04fc', '\u04fd'],
		    y: ['\u00a5', '\u04b0', '\u04cb'],
		    z: ['\u01b5', '\u0240'],
		  };
		  text.forEach(function(c) {
		    c = c.toLowerCase();
		    var chars = trap[c] || [' '];
		    var rand = Math.floor(Math.random() * chars.length);
		    if (typeof trap[c] !== 'undefined') {
		      result += trap[c][rand];
		    } else {
		      result += c;
		    }
		  });
		  return result;
		}; 
	} (trap));
	return trap.exports;
}

var zalgo = {exports: {}};

var hasRequiredZalgo;

function requireZalgo () {
	if (hasRequiredZalgo) return zalgo.exports;
	hasRequiredZalgo = 1;
	(function (module) {
		// please no
		module['exports'] = function zalgo(text, options) {
		  text = text || '   he is here   ';
		  var soul = {
		    'up': [
		      '̍', '̎', '̄', '̅',
		      '̿', '̑', '̆', '̐',
		      '͒', '͗', '͑', '̇',
		      '̈', '̊', '͂', '̓',
		      '̈', '͊', '͋', '͌',
		      '̃', '̂', '̌', '͐',
		      '̀', '́', '̋', '̏',
		      '̒', '̓', '̔', '̽',
		      '̉', 'ͣ', 'ͤ', 'ͥ',
		      'ͦ', 'ͧ', 'ͨ', 'ͩ',
		      'ͪ', 'ͫ', 'ͬ', 'ͭ',
		      'ͮ', 'ͯ', '̾', '͛',
		      '͆', '̚',
		    ],
		    'down': [
		      '̖', '̗', '̘', '̙',
		      '̜', '̝', '̞', '̟',
		      '̠', '̤', '̥', '̦',
		      '̩', '̪', '̫', '̬',
		      '̭', '̮', '̯', '̰',
		      '̱', '̲', '̳', '̹',
		      '̺', '̻', '̼', 'ͅ',
		      '͇', '͈', '͉', '͍',
		      '͎', '͓', '͔', '͕',
		      '͖', '͙', '͚', '̣',
		    ],
		    'mid': [
		      '̕', '̛', '̀', '́',
		      '͘', '̡', '̢', '̧',
		      '̨', '̴', '̵', '̶',
		      '͜', '͝', '͞',
		      '͟', '͠', '͢', '̸',
		      '̷', '͡', ' ҉',
		    ],
		  };
		  var all = [].concat(soul.up, soul.down, soul.mid);

		  function randomNumber(range) {
		    var r = Math.floor(Math.random() * range);
		    return r;
		  }

		  function isChar(character) {
		    var bool = false;
		    all.filter(function(i) {
		      bool = (i === character);
		    });
		    return bool;
		  }


		  function heComes(text, options) {
		    var result = '';
		    var counts;
		    var l;
		    options = options || {};
		    options['up'] =
		      typeof options['up'] !== 'undefined' ? options['up'] : true;
		    options['mid'] =
		      typeof options['mid'] !== 'undefined' ? options['mid'] : true;
		    options['down'] =
		      typeof options['down'] !== 'undefined' ? options['down'] : true;
		    options['size'] =
		      typeof options['size'] !== 'undefined' ? options['size'] : 'maxi';
		    text = text.split('');
		    for (l in text) {
		      if (isChar(l)) {
		        continue;
		      }
		      result = result + text[l];
		      counts = {'up': 0, 'down': 0, 'mid': 0};
		      switch (options.size) {
		        case 'mini':
		          counts.up = randomNumber(8);
		          counts.mid = randomNumber(2);
		          counts.down = randomNumber(8);
		          break;
		        case 'maxi':
		          counts.up = randomNumber(16) + 3;
		          counts.mid = randomNumber(4) + 1;
		          counts.down = randomNumber(64) + 3;
		          break;
		        default:
		          counts.up = randomNumber(8) + 1;
		          counts.mid = randomNumber(6) / 2;
		          counts.down = randomNumber(8) + 1;
		          break;
		      }

		      var arr = ['up', 'mid', 'down'];
		      for (var d in arr) {
		        var index = arr[d];
		        for (var i = 0; i <= counts[index]; i++) {
		          if (options[index]) {
		            result = result + soul[index][randomNumber(soul[index].length)];
		          }
		        }
		      }
		    }
		    return result;
		  }
		  // don't summon him
		  return heComes(text, options);
		}; 
	} (zalgo));
	return zalgo.exports;
}

var america = {exports: {}};

var hasRequiredAmerica;

function requireAmerica () {
	if (hasRequiredAmerica) return america.exports;
	hasRequiredAmerica = 1;
	(function (module) {
		module['exports'] = function(colors) {
		  return function(letter, i, exploded) {
		    if (letter === ' ') return letter;
		    switch (i%3) {
		      case 0: return colors.red(letter);
		      case 1: return colors.white(letter);
		      case 2: return colors.blue(letter);
		    }
		  };
		}; 
	} (america));
	return america.exports;
}

var zebra = {exports: {}};

var hasRequiredZebra;

function requireZebra () {
	if (hasRequiredZebra) return zebra.exports;
	hasRequiredZebra = 1;
	(function (module) {
		module['exports'] = function(colors) {
		  return function(letter, i, exploded) {
		    return i % 2 === 0 ? letter : colors.inverse(letter);
		  };
		}; 
	} (zebra));
	return zebra.exports;
}

var rainbow = {exports: {}};

var hasRequiredRainbow;

function requireRainbow () {
	if (hasRequiredRainbow) return rainbow.exports;
	hasRequiredRainbow = 1;
	(function (module) {
		module['exports'] = function(colors) {
		  // RoY G BiV
		  var rainbowColors = ['red', 'yellow', 'green', 'blue', 'magenta'];
		  return function(letter, i, exploded) {
		    if (letter === ' ') {
		      return letter;
		    } else {
		      return colors[rainbowColors[i++ % rainbowColors.length]](letter);
		    }
		  };
		}; 
	} (rainbow));
	return rainbow.exports;
}

var random = {exports: {}};

var hasRequiredRandom;

function requireRandom () {
	if (hasRequiredRandom) return random.exports;
	hasRequiredRandom = 1;
	(function (module) {
		module['exports'] = function(colors) {
		  var available = ['underline', 'inverse', 'grey', 'yellow', 'red', 'green',
		    'blue', 'white', 'cyan', 'magenta', 'brightYellow', 'brightRed',
		    'brightGreen', 'brightBlue', 'brightWhite', 'brightCyan', 'brightMagenta'];
		  return function(letter, i, exploded) {
		    return letter === ' ' ? letter :
		      colors[
		          available[Math.round(Math.random() * (available.length - 2))]
		      ](letter);
		  };
		}; 
	} (random));
	return random.exports;
}

/*

The MIT License (MIT)

Original Library
  - Copyright (c) Marak Squires

Additional functionality
 - Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

var hasRequiredColors;

function requireColors () {
	if (hasRequiredColors) return colors.exports;
	hasRequiredColors = 1;
	(function (module) {
		var colors = {};
		module['exports'] = colors;

		colors.themes = {};

		var util = require$$0$4;
		var ansiStyles = colors.styles = requireStyles();
		var defineProps = Object.defineProperties;
		var newLineRegex = new RegExp(/[\r\n]+/g);

		colors.supportsColor = requireSupportsColors().supportsColor;

		if (typeof colors.enabled === 'undefined') {
		  colors.enabled = colors.supportsColor() !== false;
		}

		colors.enable = function() {
		  colors.enabled = true;
		};

		colors.disable = function() {
		  colors.enabled = false;
		};

		colors.stripColors = colors.strip = function(str) {
		  return ('' + str).replace(/\x1B\[\d+m/g, '');
		};

		// eslint-disable-next-line no-unused-vars
		colors.stylize = function stylize(str, style) {
		  if (!colors.enabled) {
		    return str+'';
		  }

		  var styleMap = ansiStyles[style];

		  // Stylize should work for non-ANSI styles, too
		  if (!styleMap && style in colors) {
		    // Style maps like trap operate as functions on strings;
		    // they don't have properties like open or close.
		    return colors[style](str);
		  }

		  return styleMap.open + str + styleMap.close;
		};

		var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
		var escapeStringRegexp = function(str) {
		  if (typeof str !== 'string') {
		    throw new TypeError('Expected a string');
		  }
		  return str.replace(matchOperatorsRe, '\\$&');
		};

		function build(_styles) {
		  var builder = function builder() {
		    return applyStyle.apply(builder, arguments);
		  };
		  builder._styles = _styles;
		  // __proto__ is used because we must return a function, but there is
		  // no way to create a function with a different prototype.
		  builder.__proto__ = proto;
		  return builder;
		}

		var styles = (function() {
		  var ret = {};
		  ansiStyles.grey = ansiStyles.gray;
		  Object.keys(ansiStyles).forEach(function(key) {
		    ansiStyles[key].closeRe =
		      new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
		    ret[key] = {
		      get: function() {
		        return build(this._styles.concat(key));
		      },
		    };
		  });
		  return ret;
		})();

		var proto = defineProps(function colors() {}, styles);

		function applyStyle() {
		  var args = Array.prototype.slice.call(arguments);

		  var str = args.map(function(arg) {
		    // Use weak equality check so we can colorize null/undefined in safe mode
		    if (arg != null && arg.constructor === String) {
		      return arg;
		    } else {
		      return util.inspect(arg);
		    }
		  }).join(' ');

		  if (!colors.enabled || !str) {
		    return str;
		  }

		  var newLinesPresent = str.indexOf('\n') != -1;

		  var nestedStyles = this._styles;

		  var i = nestedStyles.length;
		  while (i--) {
		    var code = ansiStyles[nestedStyles[i]];
		    str = code.open + str.replace(code.closeRe, code.open) + code.close;
		    if (newLinesPresent) {
		      str = str.replace(newLineRegex, function(match) {
		        return code.close + match + code.open;
		      });
		    }
		  }

		  return str;
		}

		colors.setTheme = function(theme) {
		  if (typeof theme === 'string') {
		    console.log('colors.setTheme now only accepts an object, not a string.  ' +
		      'If you are trying to set a theme from a file, it is now your (the ' +
		      'caller\'s) responsibility to require the file.  The old syntax ' +
		      'looked like colors.setTheme(__dirname + ' +
		      '\'/../themes/generic-logging.js\'); The new syntax looks like '+
		      'colors.setTheme(require(__dirname + ' +
		      '\'/../themes/generic-logging.js\'));');
		    return;
		  }
		  for (var style in theme) {
		    (function(style) {
		      colors[style] = function(str) {
		        if (typeof theme[style] === 'object') {
		          var out = str;
		          for (var i in theme[style]) {
		            out = colors[theme[style][i]](out);
		          }
		          return out;
		        }
		        return colors[theme[style]](str);
		      };
		    })(style);
		  }
		};

		function init() {
		  var ret = {};
		  Object.keys(styles).forEach(function(name) {
		    ret[name] = {
		      get: function() {
		        return build([name]);
		      },
		    };
		  });
		  return ret;
		}

		var sequencer = function sequencer(map, str) {
		  var exploded = str.split('');
		  exploded = exploded.map(map);
		  return exploded.join('');
		};

		// custom formatter methods
		colors.trap = requireTrap();
		colors.zalgo = requireZalgo();

		// maps
		colors.maps = {};
		colors.maps.america = requireAmerica()(colors);
		colors.maps.zebra = requireZebra()(colors);
		colors.maps.rainbow = requireRainbow()(colors);
		colors.maps.random = requireRandom()(colors);

		for (var map in colors.maps) {
		  (function(map) {
		    colors[map] = function(str) {
		      return sequencer(colors.maps[map], str);
		    };
		  })(map);
		}

		defineProps(colors, init()); 
	} (colors));
	return colors.exports;
}

var hasRequiredSafe;

function requireSafe () {
	if (hasRequiredSafe) return safe.exports;
	hasRequiredSafe = 1;
	(function (module) {
		//
		// Remark: Requiring this file will use the "safe" colors API,
		// which will not touch String.prototype.
		//
		//   var colors = require('colors/safe');
		//   colors.red("foo")
		//
		//
		var colors = requireColors();
		module['exports'] = colors; 
	} (safe));
	return safe.exports;
}

var tripleBeam = {};

var config$1 = {};

var cli$1 = {};

/**
 * cli.js: Config that conform to commonly used CLI logging levels.
 *
 * (C) 2010 Charlie Robbins
 * MIT LICENCE
 */

var hasRequiredCli$1;

function requireCli$1 () {
	if (hasRequiredCli$1) return cli$1;
	hasRequiredCli$1 = 1;

	/**
	 * Default levels for the CLI configuration.
	 * @type {Object}
	 */
	cli$1.levels = {
	  error: 0,
	  warn: 1,
	  help: 2,
	  data: 3,
	  info: 4,
	  debug: 5,
	  prompt: 6,
	  verbose: 7,
	  input: 8,
	  silly: 9
	};

	/**
	 * Default colors for the CLI configuration.
	 * @type {Object}
	 */
	cli$1.colors = {
	  error: 'red',
	  warn: 'yellow',
	  help: 'cyan',
	  data: 'grey',
	  info: 'green',
	  debug: 'blue',
	  prompt: 'grey',
	  verbose: 'cyan',
	  input: 'grey',
	  silly: 'magenta'
	};
	return cli$1;
}

var npm = {};

/**
 * npm.js: Config that conform to npm logging levels.
 *
 * (C) 2010 Charlie Robbins
 * MIT LICENCE
 */

var hasRequiredNpm;

function requireNpm () {
	if (hasRequiredNpm) return npm;
	hasRequiredNpm = 1;

	/**
	 * Default levels for the npm configuration.
	 * @type {Object}
	 */
	npm.levels = {
	  error: 0,
	  warn: 1,
	  info: 2,
	  http: 3,
	  verbose: 4,
	  debug: 5,
	  silly: 6
	};

	/**
	 * Default levels for the npm configuration.
	 * @type {Object}
	 */
	npm.colors = {
	  error: 'red',
	  warn: 'yellow',
	  info: 'green',
	  http: 'green',
	  verbose: 'cyan',
	  debug: 'blue',
	  silly: 'magenta'
	};
	return npm;
}

var syslog = {};

/**
 * syslog.js: Config that conform to syslog logging levels.
 *
 * (C) 2010 Charlie Robbins
 * MIT LICENCE
 */

var hasRequiredSyslog;

function requireSyslog () {
	if (hasRequiredSyslog) return syslog;
	hasRequiredSyslog = 1;

	/**
	 * Default levels for the syslog configuration.
	 * @type {Object}
	 */
	syslog.levels = {
	  emerg: 0,
	  alert: 1,
	  crit: 2,
	  error: 3,
	  warning: 4,
	  notice: 5,
	  info: 6,
	  debug: 7
	};

	/**
	 * Default levels for the syslog configuration.
	 * @type {Object}
	 */
	syslog.colors = {
	  emerg: 'red',
	  alert: 'yellow',
	  crit: 'red',
	  error: 'red',
	  warning: 'red',
	  notice: 'yellow',
	  info: 'green',
	  debug: 'blue'
	};
	return syslog;
}

/**
 * index.js: Default settings for all levels that winston knows about.
 *
 * (C) 2010 Charlie Robbins
 * MIT LICENCE
 */

var hasRequiredConfig$1;

function requireConfig$1 () {
	if (hasRequiredConfig$1) return config$1;
	hasRequiredConfig$1 = 1;
	(function (exports$1) {

		/**
		 * Export config set for the CLI.
		 * @type {Object}
		 */
		Object.defineProperty(exports$1, 'cli', {
		  value: requireCli$1()
		});

		/**
		 * Export config set for npm.
		 * @type {Object}
		 */
		Object.defineProperty(exports$1, 'npm', {
		  value: requireNpm()
		});

		/**
		 * Export config set for the syslog.
		 * @type {Object}
		 */
		Object.defineProperty(exports$1, 'syslog', {
		  value: requireSyslog()
		}); 
	} (config$1));
	return config$1;
}

var hasRequiredTripleBeam;

function requireTripleBeam () {
	if (hasRequiredTripleBeam) return tripleBeam;
	hasRequiredTripleBeam = 1;
	(function (exports$1) {

		/**
		 * A shareable symbol constant that can be used
		 * as a non-enumerable / semi-hidden level identifier
		 * to allow the readable level property to be mutable for
		 * operations like colorization
		 *
		 * @type {Symbol}
		 */
		Object.defineProperty(exports$1, 'LEVEL', {
		  value: Symbol.for('level')
		});

		/**
		 * A shareable symbol constant that can be used
		 * as a non-enumerable / semi-hidden message identifier
		 * to allow the final message property to not have
		 * side effects on another.
		 *
		 * @type {Symbol}
		 */
		Object.defineProperty(exports$1, 'MESSAGE', {
		  value: Symbol.for('message')
		});

		/**
		 * A shareable symbol constant that can be used
		 * as a non-enumerable / semi-hidden message identifier
		 * to allow the extracted splat property be hidden
		 *
		 * @type {Symbol}
		 */
		Object.defineProperty(exports$1, 'SPLAT', {
		  value: Symbol.for('splat')
		});

		/**
		 * A shareable object constant  that can be used
		 * as a standard configuration for winston@3.
		 *
		 * @type {Object}
		 */
		Object.defineProperty(exports$1, 'configs', {
		  value: requireConfig$1()
		}); 
	} (tripleBeam));
	return tripleBeam;
}

var hasRequiredColorize;

function requireColorize () {
	if (hasRequiredColorize) return colorize.exports;
	hasRequiredColorize = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	var colors = requireSafe();
	var _require = requireTripleBeam(),
	  LEVEL = _require.LEVEL,
	  MESSAGE = _require.MESSAGE;

	//
	// Fix colors not appearing in non-tty environments
	//
	colors.enabled = true;

	/**
	 * @property {RegExp} hasSpace
	 * Simple regex to check for presence of spaces.
	 */
	var hasSpace = /\s+/;

	/*
	 * Colorizer format. Wraps the `level` and/or `message` properties
	 * of the `info` objects with ANSI color codes based on a few options.
	 */
	var Colorizer = /*#__PURE__*/function () {
	  function Colorizer() {
	    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    _classCallCheck(this, Colorizer);
	    if (opts.colors) {
	      this.addColors(opts.colors);
	    }
	    this.options = opts;
	  }

	  /*
	   * Adds the colors Object to the set of allColors
	   * known by the Colorizer
	   *
	   * @param {Object} colors Set of color mappings to add.
	   */
	  return _createClass(Colorizer, [{
	    key: "addColors",
	    value:
	    /*
	     * Adds the colors Object to the set of allColors
	     * known by the Colorizer
	     *
	     * @param {Object} colors Set of color mappings to add.
	     */
	    function addColors(clrs) {
	      return Colorizer.addColors(clrs);
	    }

	    /*
	     * function colorize (lookup, level, message)
	     * Performs multi-step colorization using @colors/colors/safe
	     */
	  }, {
	    key: "colorize",
	    value: function colorize(lookup, level, message) {
	      if (typeof message === 'undefined') {
	        message = level;
	      }

	      //
	      // If the color for the level is just a string
	      // then attempt to colorize the message with it.
	      //
	      if (!Array.isArray(Colorizer.allColors[lookup])) {
	        return colors[Colorizer.allColors[lookup]](message);
	      }

	      //
	      // If it is an Array then iterate over that Array, applying
	      // the colors function for each item.
	      //
	      for (var i = 0, len = Colorizer.allColors[lookup].length; i < len; i++) {
	        message = colors[Colorizer.allColors[lookup][i]](message);
	      }
	      return message;
	    }

	    /*
	     * function transform (info, opts)
	     * Attempts to colorize the { level, message } of the given
	     * `logform` info object.
	     */
	  }, {
	    key: "transform",
	    value: function transform(info, opts) {
	      if (opts.all && typeof info[MESSAGE] === 'string') {
	        info[MESSAGE] = this.colorize(info[LEVEL], info.level, info[MESSAGE]);
	      }
	      if (opts.level || opts.all || !opts.message) {
	        info.level = this.colorize(info[LEVEL], info.level);
	      }
	      if (opts.all || opts.message) {
	        info.message = this.colorize(info[LEVEL], info.level, info.message);
	      }
	      return info;
	    }
	  }], [{
	    key: "addColors",
	    value: function addColors(clrs) {
	      var nextColors = Object.keys(clrs).reduce(function (acc, level) {
	        acc[level] = hasSpace.test(clrs[level]) ? clrs[level].split(hasSpace) : clrs[level];
	        return acc;
	      }, {});
	      Colorizer.allColors = Object.assign({}, Colorizer.allColors || {}, nextColors);
	      return Colorizer.allColors;
	    }
	  }]);
	}();
	/*
	 * function colorize (info)
	 * Returns a new instance of the colorize Format that applies
	 * level colors to `info` objects. This was previously exposed
	 * as { colorize: true } to transports in `winston < 3.0.0`.
	 */
	colorize.exports = function (opts) {
	  return new Colorizer(opts);
	};

	//
	// Attach the Colorizer for registration purposes
	//
	colorize.exports.Colorizer = colorize.exports.Format = Colorizer;
	return colorize.exports;
}

var levels;
var hasRequiredLevels;

function requireLevels () {
	if (hasRequiredLevels) return levels;
	hasRequiredLevels = 1;

	var _require = requireColorize(),
	  Colorizer = _require.Colorizer;

	/*
	 * Simple method to register colors with a simpler require
	 * path within the module.
	 */
	levels = function (config) {
	  Colorizer.addColors(config.colors || config);
	  return config;
	};
	return levels;
}

var align;
var hasRequiredAlign;

function requireAlign () {
	if (hasRequiredAlign) return align;
	hasRequiredAlign = 1;

	var format = requireFormat$3();

	/*
	 * function align (info)
	 * Returns a new instance of the align Format which adds a `\t`
	 * delimiter before the message to properly align it in the same place.
	 * It was previously { align: true } in winston < 3.0.0
	 */
	align = format(function (info) {
	  info.message = "\t".concat(info.message);
	  return info;
	});
	return align;
}

var cli = {exports: {}};

var padLevels = {exports: {}};

/* eslint no-unused-vars: 0 */

var hasRequiredPadLevels;

function requirePadLevels () {
	if (hasRequiredPadLevels) return padLevels.exports;
	hasRequiredPadLevels = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
	function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
	function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
	function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
	function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
	function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	var _require = requireTripleBeam(),
	  configs = _require.configs,
	  LEVEL = _require.LEVEL,
	  MESSAGE = _require.MESSAGE;
	var Padder = /*#__PURE__*/function () {
	  function Padder() {
	    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
	      levels: configs.npm.levels
	    };
	    _classCallCheck(this, Padder);
	    this.paddings = Padder.paddingForLevels(opts.levels, opts.filler);
	    this.options = opts;
	  }

	  /**
	   * Returns the maximum length of keys in the specified `levels` Object.
	   * @param  {Object} levels Set of all levels to calculate longest level against.
	   * @returns {Number} Maximum length of the longest level string.
	   */
	  return _createClass(Padder, [{
	    key: "transform",
	    value:
	    /**
	     * Prepends the padding onto the `message` based on the `LEVEL` of
	     * the `info`. This is based on the behavior of `winston@2` which also
	     * prepended the level onto the message.
	     *
	     * See: https://github.com/winstonjs/winston/blob/2.x/lib/winston/logger.js#L198-L201
	     *
	     * @param  {Info} info Logform info object
	     * @param  {Object} opts Options passed along to this instance.
	     * @returns {Info} Modified logform info object.
	     */
	    function transform(info, opts) {
	      info.message = "".concat(this.paddings[info[LEVEL]]).concat(info.message);
	      if (info[MESSAGE]) {
	        info[MESSAGE] = "".concat(this.paddings[info[LEVEL]]).concat(info[MESSAGE]);
	      }
	      return info;
	    }
	  }], [{
	    key: "getLongestLevel",
	    value: function getLongestLevel(levels) {
	      var lvls = Object.keys(levels).map(function (level) {
	        return level.length;
	      });
	      return Math.max.apply(Math, _toConsumableArray(lvls));
	    }

	    /**
	     * Returns the padding for the specified `level` assuming that the
	     * maximum length of all levels it's associated with is `maxLength`.
	     * @param  {String} level Level to calculate padding for.
	     * @param  {String} filler Repeatable text to use for padding.
	     * @param  {Number} maxLength Length of the longest level
	     * @returns {String} Padding string for the `level`
	     */
	  }, {
	    key: "paddingForLevel",
	    value: function paddingForLevel(level, filler, maxLength) {
	      var targetLen = maxLength + 1 - level.length;
	      var rep = Math.floor(targetLen / filler.length);
	      var padding = "".concat(filler).concat(filler.repeat(rep));
	      return padding.slice(0, targetLen);
	    }

	    /**
	     * Returns an object with the string paddings for the given `levels`
	     * using the specified `filler`.
	     * @param  {Object} levels Set of all levels to calculate padding for.
	     * @param  {String} filler Repeatable text to use for padding.
	     * @returns {Object} Mapping of level to desired padding.
	     */
	  }, {
	    key: "paddingForLevels",
	    value: function paddingForLevels(levels) {
	      var filler = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' ';
	      var maxLength = Padder.getLongestLevel(levels);
	      return Object.keys(levels).reduce(function (acc, level) {
	        acc[level] = Padder.paddingForLevel(level, filler, maxLength);
	        return acc;
	      }, {});
	    }
	  }]);
	}();
	/*
	 * function padLevels (info)
	 * Returns a new instance of the padLevels Format which pads
	 * levels to be the same length. This was previously exposed as
	 * { padLevels: true } to transports in `winston < 3.0.0`.
	 */
	padLevels.exports = function (opts) {
	  return new Padder(opts);
	};
	padLevels.exports.Padder = padLevels.exports.Format = Padder;
	return padLevels.exports;
}

var hasRequiredCli;

function requireCli () {
	if (hasRequiredCli) return cli.exports;
	hasRequiredCli = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	var _require = requireColorize(),
	  Colorizer = _require.Colorizer;
	var _require2 = requirePadLevels(),
	  Padder = _require2.Padder;
	var _require3 = requireTripleBeam(),
	  configs = _require3.configs,
	  MESSAGE = _require3.MESSAGE;

	/**
	 * Cli format class that handles initial state for a a separate
	 * Colorizer and Padder instance.
	 */
	var CliFormat = /*#__PURE__*/function () {
	  function CliFormat() {
	    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    _classCallCheck(this, CliFormat);
	    if (!opts.levels) {
	      opts.levels = configs.cli.levels;
	    }
	    this.colorizer = new Colorizer(opts);
	    this.padder = new Padder(opts);
	    this.options = opts;
	  }

	  /*
	   * function transform (info, opts)
	   * Attempts to both:
	   * 1. Pad the { level }
	   * 2. Colorize the { level, message }
	   * of the given `logform` info object depending on the `opts`.
	   */
	  return _createClass(CliFormat, [{
	    key: "transform",
	    value: function transform(info, opts) {
	      this.colorizer.transform(this.padder.transform(info, opts), opts);
	      info[MESSAGE] = "".concat(info.level, ":").concat(info.message);
	      return info;
	    }
	  }]);
	}();
	/*
	 * function cli (opts)
	 * Returns a new instance of the CLI format that turns a log
	 * `info` object into the same format previously available
	 * in `winston.cli()` in `winston < 3.0.0`.
	 */
	cli.exports = function (opts) {
	  return new CliFormat(opts);
	};

	//
	// Attach the CliFormat for registration purposes
	//
	cli.exports.Format = CliFormat;
	return cli.exports;
}

var combine$1 = {exports: {}};

var hasRequiredCombine;

function requireCombine () {
	if (hasRequiredCombine) return combine$1.exports;
	hasRequiredCombine = 1;

	var format = requireFormat$3();

	/*
	 * function cascade(formats)
	 * Returns a function that invokes the `._format` function in-order
	 * for the specified set of `formats`. In this manner we say that Formats
	 * are "pipe-like", but not a pure pumpify implementation. Since there is no back
	 * pressure we can remove all of the "readable" plumbing in Node streams.
	 */
	function cascade(formats) {
	  if (!formats.every(isValidFormat)) {
	    return;
	  }
	  return function (info) {
	    var obj = info;
	    for (var i = 0; i < formats.length; i++) {
	      obj = formats[i].transform(obj, formats[i].options);
	      if (!obj) {
	        return false;
	      }
	    }
	    return obj;
	  };
	}

	/*
	 * function isValidFormat(format)
	 * If the format does not define a `transform` function throw an error
	 * with more detailed usage.
	 */
	function isValidFormat(fmt) {
	  if (typeof fmt.transform !== 'function') {
	    throw new Error(['No transform function found on format. Did you create a format instance?', 'const myFormat = format(formatFn);', 'const instance = myFormat();'].join('\n'));
	  }
	  return true;
	}

	/*
	 * function combine (info)
	 * Returns a new instance of the combine Format which combines the specified
	 * formats into a new format. This is similar to a pipe-chain in transform streams.
	 * We choose to combine the prototypes this way because there is no back pressure in
	 * an in-memory transform chain.
	 */
	combine$1.exports = function () {
	  for (var _len = arguments.length, formats = new Array(_len), _key = 0; _key < _len; _key++) {
	    formats[_key] = arguments[_key];
	  }
	  var combinedFormat = format(cascade(formats));
	  var instance = combinedFormat();
	  instance.Format = combinedFormat.Format;
	  return instance;
	};

	//
	// Export the cascade method for use in cli and other
	// combined formats that should not be assumed to be
	// singletons.
	//
	combine$1.exports.cascade = cascade;
	return combine$1.exports;
}

/* eslint no-undefined: 0 */

var errors$1;
var hasRequiredErrors$1;

function requireErrors$1 () {
	if (hasRequiredErrors$1) return errors$1;
	hasRequiredErrors$1 = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: true, configurable: true, writable: true }) : e[r] = t, e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
	var format = requireFormat$3();
	var _require = requireTripleBeam(),
	  LEVEL = _require.LEVEL,
	  MESSAGE = _require.MESSAGE;

	/*
	 * function errors (info)
	 * If the `message` property of the `info` object is an instance of `Error`,
	 * replace the `Error` object its own `message` property.
	 *
	 * Optionally, the Error's `stack` and/or `cause` properties can also be appended to the `info` object.
	 */
	errors$1 = format(function (einfo, _ref) {
	  var stack = _ref.stack,
	    cause = _ref.cause;
	  if (einfo instanceof Error) {
	    var info = Object.assign({}, einfo, _defineProperty(_defineProperty(_defineProperty({
	      level: einfo.level
	    }, LEVEL, einfo[LEVEL] || einfo.level), "message", einfo.message), MESSAGE, einfo[MESSAGE] || einfo.message));
	    if (stack) info.stack = einfo.stack;
	    if (cause) info.cause = einfo.cause;
	    return info;
	  }
	  if (!(einfo.message instanceof Error)) return einfo;

	  // Assign all enumerable properties and the
	  // message property from the error provided.
	  var err = einfo.message;
	  Object.assign(einfo, err);
	  einfo.message = err.message;
	  einfo[MESSAGE] = err.message;

	  // Assign the stack and/or cause if requested.
	  if (stack) einfo.stack = err.stack;
	  if (cause) einfo.cause = err.cause;
	  return einfo;
	});
	return errors$1;
}

var safeStableStringify = {exports: {}};

var hasRequiredSafeStableStringify;

function requireSafeStableStringify () {
	if (hasRequiredSafeStableStringify) return safeStableStringify.exports;
	hasRequiredSafeStableStringify = 1;
	(function (module, exports$1) {

		const { hasOwnProperty } = Object.prototype;

		const stringify = configure();

		// @ts-expect-error
		stringify.configure = configure;
		// @ts-expect-error
		stringify.stringify = stringify;

		// @ts-expect-error
		stringify.default = stringify;

		// @ts-expect-error used for named export
		exports$1.stringify = stringify;
		// @ts-expect-error used for named export
		exports$1.configure = configure;

		module.exports = stringify;

		// eslint-disable-next-line no-control-regex
		const strEscapeSequencesRegExp = /[\u0000-\u001f\u0022\u005c\ud800-\udfff]/;

		// Escape C0 control characters, double quotes, the backslash and every code
		// unit with a numeric value in the inclusive range 0xD800 to 0xDFFF.
		function strEscape (str) {
		  // Some magic numbers that worked out fine while benchmarking with v8 8.0
		  if (str.length < 5000 && !strEscapeSequencesRegExp.test(str)) {
		    return `"${str}"`
		  }
		  return JSON.stringify(str)
		}

		function sort (array, comparator) {
		  // Insertion sort is very efficient for small input sizes, but it has a bad
		  // worst case complexity. Thus, use native array sort for bigger values.
		  if (array.length > 2e2 || comparator) {
		    return array.sort(comparator)
		  }
		  for (let i = 1; i < array.length; i++) {
		    const currentValue = array[i];
		    let position = i;
		    while (position !== 0 && array[position - 1] > currentValue) {
		      array[position] = array[position - 1];
		      position--;
		    }
		    array[position] = currentValue;
		  }
		  return array
		}

		const typedArrayPrototypeGetSymbolToStringTag =
		  Object.getOwnPropertyDescriptor(
		    Object.getPrototypeOf(
		      Object.getPrototypeOf(
		        new Int8Array()
		      )
		    ),
		    Symbol.toStringTag
		  ).get;

		function isTypedArrayWithEntries (value) {
		  return typedArrayPrototypeGetSymbolToStringTag.call(value) !== undefined && value.length !== 0
		}

		function stringifyTypedArray (array, separator, maximumBreadth) {
		  if (array.length < maximumBreadth) {
		    maximumBreadth = array.length;
		  }
		  const whitespace = separator === ',' ? '' : ' ';
		  let res = `"0":${whitespace}${array[0]}`;
		  for (let i = 1; i < maximumBreadth; i++) {
		    res += `${separator}"${i}":${whitespace}${array[i]}`;
		  }
		  return res
		}

		function getCircularValueOption (options) {
		  if (hasOwnProperty.call(options, 'circularValue')) {
		    const circularValue = options.circularValue;
		    if (typeof circularValue === 'string') {
		      return `"${circularValue}"`
		    }
		    if (circularValue == null) {
		      return circularValue
		    }
		    if (circularValue === Error || circularValue === TypeError) {
		      return {
		        toString () {
		          throw new TypeError('Converting circular structure to JSON')
		        }
		      }
		    }
		    throw new TypeError('The "circularValue" argument must be of type string or the value null or undefined')
		  }
		  return '"[Circular]"'
		}

		function getDeterministicOption (options) {
		  let value;
		  if (hasOwnProperty.call(options, 'deterministic')) {
		    value = options.deterministic;
		    if (typeof value !== 'boolean' && typeof value !== 'function') {
		      throw new TypeError('The "deterministic" argument must be of type boolean or comparator function')
		    }
		  }
		  return value === undefined ? true : value
		}

		function getBooleanOption (options, key) {
		  let value;
		  if (hasOwnProperty.call(options, key)) {
		    value = options[key];
		    if (typeof value !== 'boolean') {
		      throw new TypeError(`The "${key}" argument must be of type boolean`)
		    }
		  }
		  return value === undefined ? true : value
		}

		function getPositiveIntegerOption (options, key) {
		  let value;
		  if (hasOwnProperty.call(options, key)) {
		    value = options[key];
		    if (typeof value !== 'number') {
		      throw new TypeError(`The "${key}" argument must be of type number`)
		    }
		    if (!Number.isInteger(value)) {
		      throw new TypeError(`The "${key}" argument must be an integer`)
		    }
		    if (value < 1) {
		      throw new RangeError(`The "${key}" argument must be >= 1`)
		    }
		  }
		  return value === undefined ? Infinity : value
		}

		function getItemCount (number) {
		  if (number === 1) {
		    return '1 item'
		  }
		  return `${number} items`
		}

		function getUniqueReplacerSet (replacerArray) {
		  const replacerSet = new Set();
		  for (const value of replacerArray) {
		    if (typeof value === 'string' || typeof value === 'number') {
		      replacerSet.add(String(value));
		    }
		  }
		  return replacerSet
		}

		function getStrictOption (options) {
		  if (hasOwnProperty.call(options, 'strict')) {
		    const value = options.strict;
		    if (typeof value !== 'boolean') {
		      throw new TypeError('The "strict" argument must be of type boolean')
		    }
		    if (value) {
		      return (value) => {
		        let message = `Object can not safely be stringified. Received type ${typeof value}`;
		        if (typeof value !== 'function') message += ` (${value.toString()})`;
		        throw new Error(message)
		      }
		    }
		  }
		}

		function configure (options) {
		  options = { ...options };
		  const fail = getStrictOption(options);
		  if (fail) {
		    if (options.bigint === undefined) {
		      options.bigint = false;
		    }
		    if (!('circularValue' in options)) {
		      options.circularValue = Error;
		    }
		  }
		  const circularValue = getCircularValueOption(options);
		  const bigint = getBooleanOption(options, 'bigint');
		  const deterministic = getDeterministicOption(options);
		  const comparator = typeof deterministic === 'function' ? deterministic : undefined;
		  const maximumDepth = getPositiveIntegerOption(options, 'maximumDepth');
		  const maximumBreadth = getPositiveIntegerOption(options, 'maximumBreadth');

		  function stringifyFnReplacer (key, parent, stack, replacer, spacer, indentation) {
		    let value = parent[key];

		    if (typeof value === 'object' && value !== null && typeof value.toJSON === 'function') {
		      value = value.toJSON(key);
		    }
		    value = replacer.call(parent, key, value);

		    switch (typeof value) {
		      case 'string':
		        return strEscape(value)
		      case 'object': {
		        if (value === null) {
		          return 'null'
		        }
		        if (stack.indexOf(value) !== -1) {
		          return circularValue
		        }

		        let res = '';
		        let join = ',';
		        const originalIndentation = indentation;

		        if (Array.isArray(value)) {
		          if (value.length === 0) {
		            return '[]'
		          }
		          if (maximumDepth < stack.length + 1) {
		            return '"[Array]"'
		          }
		          stack.push(value);
		          if (spacer !== '') {
		            indentation += spacer;
		            res += `\n${indentation}`;
		            join = `,\n${indentation}`;
		          }
		          const maximumValuesToStringify = Math.min(value.length, maximumBreadth);
		          let i = 0;
		          for (; i < maximumValuesToStringify - 1; i++) {
		            const tmp = stringifyFnReplacer(String(i), value, stack, replacer, spacer, indentation);
		            res += tmp !== undefined ? tmp : 'null';
		            res += join;
		          }
		          const tmp = stringifyFnReplacer(String(i), value, stack, replacer, spacer, indentation);
		          res += tmp !== undefined ? tmp : 'null';
		          if (value.length - 1 > maximumBreadth) {
		            const removedKeys = value.length - maximumBreadth - 1;
		            res += `${join}"... ${getItemCount(removedKeys)} not stringified"`;
		          }
		          if (spacer !== '') {
		            res += `\n${originalIndentation}`;
		          }
		          stack.pop();
		          return `[${res}]`
		        }

		        let keys = Object.keys(value);
		        const keyLength = keys.length;
		        if (keyLength === 0) {
		          return '{}'
		        }
		        if (maximumDepth < stack.length + 1) {
		          return '"[Object]"'
		        }
		        let whitespace = '';
		        let separator = '';
		        if (spacer !== '') {
		          indentation += spacer;
		          join = `,\n${indentation}`;
		          whitespace = ' ';
		        }
		        const maximumPropertiesToStringify = Math.min(keyLength, maximumBreadth);
		        if (deterministic && !isTypedArrayWithEntries(value)) {
		          keys = sort(keys, comparator);
		        }
		        stack.push(value);
		        for (let i = 0; i < maximumPropertiesToStringify; i++) {
		          const key = keys[i];
		          const tmp = stringifyFnReplacer(key, value, stack, replacer, spacer, indentation);
		          if (tmp !== undefined) {
		            res += `${separator}${strEscape(key)}:${whitespace}${tmp}`;
		            separator = join;
		          }
		        }
		        if (keyLength > maximumBreadth) {
		          const removedKeys = keyLength - maximumBreadth;
		          res += `${separator}"...":${whitespace}"${getItemCount(removedKeys)} not stringified"`;
		          separator = join;
		        }
		        if (spacer !== '' && separator.length > 1) {
		          res = `\n${indentation}${res}\n${originalIndentation}`;
		        }
		        stack.pop();
		        return `{${res}}`
		      }
		      case 'number':
		        return isFinite(value) ? String(value) : fail ? fail(value) : 'null'
		      case 'boolean':
		        return value === true ? 'true' : 'false'
		      case 'undefined':
		        return undefined
		      case 'bigint':
		        if (bigint) {
		          return String(value)
		        }
		        // fallthrough
		      default:
		        return fail ? fail(value) : undefined
		    }
		  }

		  function stringifyArrayReplacer (key, value, stack, replacer, spacer, indentation) {
		    if (typeof value === 'object' && value !== null && typeof value.toJSON === 'function') {
		      value = value.toJSON(key);
		    }

		    switch (typeof value) {
		      case 'string':
		        return strEscape(value)
		      case 'object': {
		        if (value === null) {
		          return 'null'
		        }
		        if (stack.indexOf(value) !== -1) {
		          return circularValue
		        }

		        const originalIndentation = indentation;
		        let res = '';
		        let join = ',';

		        if (Array.isArray(value)) {
		          if (value.length === 0) {
		            return '[]'
		          }
		          if (maximumDepth < stack.length + 1) {
		            return '"[Array]"'
		          }
		          stack.push(value);
		          if (spacer !== '') {
		            indentation += spacer;
		            res += `\n${indentation}`;
		            join = `,\n${indentation}`;
		          }
		          const maximumValuesToStringify = Math.min(value.length, maximumBreadth);
		          let i = 0;
		          for (; i < maximumValuesToStringify - 1; i++) {
		            const tmp = stringifyArrayReplacer(String(i), value[i], stack, replacer, spacer, indentation);
		            res += tmp !== undefined ? tmp : 'null';
		            res += join;
		          }
		          const tmp = stringifyArrayReplacer(String(i), value[i], stack, replacer, spacer, indentation);
		          res += tmp !== undefined ? tmp : 'null';
		          if (value.length - 1 > maximumBreadth) {
		            const removedKeys = value.length - maximumBreadth - 1;
		            res += `${join}"... ${getItemCount(removedKeys)} not stringified"`;
		          }
		          if (spacer !== '') {
		            res += `\n${originalIndentation}`;
		          }
		          stack.pop();
		          return `[${res}]`
		        }
		        stack.push(value);
		        let whitespace = '';
		        if (spacer !== '') {
		          indentation += spacer;
		          join = `,\n${indentation}`;
		          whitespace = ' ';
		        }
		        let separator = '';
		        for (const key of replacer) {
		          const tmp = stringifyArrayReplacer(key, value[key], stack, replacer, spacer, indentation);
		          if (tmp !== undefined) {
		            res += `${separator}${strEscape(key)}:${whitespace}${tmp}`;
		            separator = join;
		          }
		        }
		        if (spacer !== '' && separator.length > 1) {
		          res = `\n${indentation}${res}\n${originalIndentation}`;
		        }
		        stack.pop();
		        return `{${res}}`
		      }
		      case 'number':
		        return isFinite(value) ? String(value) : fail ? fail(value) : 'null'
		      case 'boolean':
		        return value === true ? 'true' : 'false'
		      case 'undefined':
		        return undefined
		      case 'bigint':
		        if (bigint) {
		          return String(value)
		        }
		        // fallthrough
		      default:
		        return fail ? fail(value) : undefined
		    }
		  }

		  function stringifyIndent (key, value, stack, spacer, indentation) {
		    switch (typeof value) {
		      case 'string':
		        return strEscape(value)
		      case 'object': {
		        if (value === null) {
		          return 'null'
		        }
		        if (typeof value.toJSON === 'function') {
		          value = value.toJSON(key);
		          // Prevent calling `toJSON` again.
		          if (typeof value !== 'object') {
		            return stringifyIndent(key, value, stack, spacer, indentation)
		          }
		          if (value === null) {
		            return 'null'
		          }
		        }
		        if (stack.indexOf(value) !== -1) {
		          return circularValue
		        }
		        const originalIndentation = indentation;

		        if (Array.isArray(value)) {
		          if (value.length === 0) {
		            return '[]'
		          }
		          if (maximumDepth < stack.length + 1) {
		            return '"[Array]"'
		          }
		          stack.push(value);
		          indentation += spacer;
		          let res = `\n${indentation}`;
		          const join = `,\n${indentation}`;
		          const maximumValuesToStringify = Math.min(value.length, maximumBreadth);
		          let i = 0;
		          for (; i < maximumValuesToStringify - 1; i++) {
		            const tmp = stringifyIndent(String(i), value[i], stack, spacer, indentation);
		            res += tmp !== undefined ? tmp : 'null';
		            res += join;
		          }
		          const tmp = stringifyIndent(String(i), value[i], stack, spacer, indentation);
		          res += tmp !== undefined ? tmp : 'null';
		          if (value.length - 1 > maximumBreadth) {
		            const removedKeys = value.length - maximumBreadth - 1;
		            res += `${join}"... ${getItemCount(removedKeys)} not stringified"`;
		          }
		          res += `\n${originalIndentation}`;
		          stack.pop();
		          return `[${res}]`
		        }

		        let keys = Object.keys(value);
		        const keyLength = keys.length;
		        if (keyLength === 0) {
		          return '{}'
		        }
		        if (maximumDepth < stack.length + 1) {
		          return '"[Object]"'
		        }
		        indentation += spacer;
		        const join = `,\n${indentation}`;
		        let res = '';
		        let separator = '';
		        let maximumPropertiesToStringify = Math.min(keyLength, maximumBreadth);
		        if (isTypedArrayWithEntries(value)) {
		          res += stringifyTypedArray(value, join, maximumBreadth);
		          keys = keys.slice(value.length);
		          maximumPropertiesToStringify -= value.length;
		          separator = join;
		        }
		        if (deterministic) {
		          keys = sort(keys, comparator);
		        }
		        stack.push(value);
		        for (let i = 0; i < maximumPropertiesToStringify; i++) {
		          const key = keys[i];
		          const tmp = stringifyIndent(key, value[key], stack, spacer, indentation);
		          if (tmp !== undefined) {
		            res += `${separator}${strEscape(key)}: ${tmp}`;
		            separator = join;
		          }
		        }
		        if (keyLength > maximumBreadth) {
		          const removedKeys = keyLength - maximumBreadth;
		          res += `${separator}"...": "${getItemCount(removedKeys)} not stringified"`;
		          separator = join;
		        }
		        if (separator !== '') {
		          res = `\n${indentation}${res}\n${originalIndentation}`;
		        }
		        stack.pop();
		        return `{${res}}`
		      }
		      case 'number':
		        return isFinite(value) ? String(value) : fail ? fail(value) : 'null'
		      case 'boolean':
		        return value === true ? 'true' : 'false'
		      case 'undefined':
		        return undefined
		      case 'bigint':
		        if (bigint) {
		          return String(value)
		        }
		        // fallthrough
		      default:
		        return fail ? fail(value) : undefined
		    }
		  }

		  function stringifySimple (key, value, stack) {
		    switch (typeof value) {
		      case 'string':
		        return strEscape(value)
		      case 'object': {
		        if (value === null) {
		          return 'null'
		        }
		        if (typeof value.toJSON === 'function') {
		          value = value.toJSON(key);
		          // Prevent calling `toJSON` again
		          if (typeof value !== 'object') {
		            return stringifySimple(key, value, stack)
		          }
		          if (value === null) {
		            return 'null'
		          }
		        }
		        if (stack.indexOf(value) !== -1) {
		          return circularValue
		        }

		        let res = '';

		        const hasLength = value.length !== undefined;
		        if (hasLength && Array.isArray(value)) {
		          if (value.length === 0) {
		            return '[]'
		          }
		          if (maximumDepth < stack.length + 1) {
		            return '"[Array]"'
		          }
		          stack.push(value);
		          const maximumValuesToStringify = Math.min(value.length, maximumBreadth);
		          let i = 0;
		          for (; i < maximumValuesToStringify - 1; i++) {
		            const tmp = stringifySimple(String(i), value[i], stack);
		            res += tmp !== undefined ? tmp : 'null';
		            res += ',';
		          }
		          const tmp = stringifySimple(String(i), value[i], stack);
		          res += tmp !== undefined ? tmp : 'null';
		          if (value.length - 1 > maximumBreadth) {
		            const removedKeys = value.length - maximumBreadth - 1;
		            res += `,"... ${getItemCount(removedKeys)} not stringified"`;
		          }
		          stack.pop();
		          return `[${res}]`
		        }

		        let keys = Object.keys(value);
		        const keyLength = keys.length;
		        if (keyLength === 0) {
		          return '{}'
		        }
		        if (maximumDepth < stack.length + 1) {
		          return '"[Object]"'
		        }
		        let separator = '';
		        let maximumPropertiesToStringify = Math.min(keyLength, maximumBreadth);
		        if (hasLength && isTypedArrayWithEntries(value)) {
		          res += stringifyTypedArray(value, ',', maximumBreadth);
		          keys = keys.slice(value.length);
		          maximumPropertiesToStringify -= value.length;
		          separator = ',';
		        }
		        if (deterministic) {
		          keys = sort(keys, comparator);
		        }
		        stack.push(value);
		        for (let i = 0; i < maximumPropertiesToStringify; i++) {
		          const key = keys[i];
		          const tmp = stringifySimple(key, value[key], stack);
		          if (tmp !== undefined) {
		            res += `${separator}${strEscape(key)}:${tmp}`;
		            separator = ',';
		          }
		        }
		        if (keyLength > maximumBreadth) {
		          const removedKeys = keyLength - maximumBreadth;
		          res += `${separator}"...":"${getItemCount(removedKeys)} not stringified"`;
		        }
		        stack.pop();
		        return `{${res}}`
		      }
		      case 'number':
		        return isFinite(value) ? String(value) : fail ? fail(value) : 'null'
		      case 'boolean':
		        return value === true ? 'true' : 'false'
		      case 'undefined':
		        return undefined
		      case 'bigint':
		        if (bigint) {
		          return String(value)
		        }
		        // fallthrough
		      default:
		        return fail ? fail(value) : undefined
		    }
		  }

		  function stringify (value, replacer, space) {
		    if (arguments.length > 1) {
		      let spacer = '';
		      if (typeof space === 'number') {
		        spacer = ' '.repeat(Math.min(space, 10));
		      } else if (typeof space === 'string') {
		        spacer = space.slice(0, 10);
		      }
		      if (replacer != null) {
		        if (typeof replacer === 'function') {
		          return stringifyFnReplacer('', { '': value }, [], replacer, spacer, '')
		        }
		        if (Array.isArray(replacer)) {
		          return stringifyArrayReplacer('', value, [], getUniqueReplacerSet(replacer), spacer, '')
		        }
		      }
		      if (spacer.length !== 0) {
		        return stringifyIndent('', value, [], spacer, '')
		      }
		    }
		    return stringifySimple('', value, [])
		  }

		  return stringify
		} 
	} (safeStableStringify, safeStableStringify.exports));
	return safeStableStringify.exports;
}

var json$1;
var hasRequiredJson$1;

function requireJson$1 () {
	if (hasRequiredJson$1) return json$1;
	hasRequiredJson$1 = 1;

	var format = requireFormat$3();
	var _require = requireTripleBeam(),
	  MESSAGE = _require.MESSAGE;
	var stringify = requireSafeStableStringify();

	/*
	 * function replacer (key, value)
	 * Handles proper stringification of Buffer and bigint output.
	 */
	function replacer(key, value) {
	  // safe-stable-stringify does support BigInt, however, it doesn't wrap the value in quotes.
	  // Leading to a loss in fidelity if the resulting string is parsed.
	  // It would also be a breaking change for logform.
	  if (typeof value === 'bigint') return value.toString();
	  return value;
	}

	/*
	 * function json (info)
	 * Returns a new instance of the JSON format that turns a log `info`
	 * object into pure JSON. This was previously exposed as { json: true }
	 * to transports in `winston < 3.0.0`.
	 */
	json$1 = format(function (info, opts) {
	  var jsonStringify = stringify.configure(opts);
	  info[MESSAGE] = jsonStringify(info, opts.replacer || replacer, opts.space);
	  return info;
	});
	return json$1;
}

var label;
var hasRequiredLabel;

function requireLabel () {
	if (hasRequiredLabel) return label;
	hasRequiredLabel = 1;

	var format = requireFormat$3();

	/*
	 * function label (info)
	 * Returns a new instance of the label Format which adds the specified
	 * `opts.label` before the message. This was previously exposed as
	 * { label: 'my label' } to transports in `winston < 3.0.0`.
	 */
	label = format(function (info, opts) {
	  if (opts.message) {
	    info.message = "[".concat(opts.label, "] ").concat(info.message);
	    return info;
	  }
	  info.label = opts.label;
	  return info;
	});
	return label;
}

var logstash;
var hasRequiredLogstash;

function requireLogstash () {
	if (hasRequiredLogstash) return logstash;
	hasRequiredLogstash = 1;

	var format = requireFormat$3();
	var _require = requireTripleBeam(),
	  MESSAGE = _require.MESSAGE;
	var jsonStringify = requireSafeStableStringify();

	/*
	 * function logstash (info)
	 * Returns a new instance of the LogStash Format that turns a
	 * log `info` object into pure JSON with the appropriate logstash
	 * options. This was previously exposed as { logstash: true }
	 * to transports in `winston < 3.0.0`.
	 */
	logstash = format(function (info) {
	  var logstash = {};
	  if (info.message) {
	    logstash['@message'] = info.message;
	    delete info.message;
	  }
	  if (info.timestamp) {
	    logstash['@timestamp'] = info.timestamp;
	    delete info.timestamp;
	  }
	  logstash['@fields'] = info;
	  info[MESSAGE] = jsonStringify(logstash);
	  return info;
	});
	return logstash;
}

var metadata$1;
var hasRequiredMetadata$1;

function requireMetadata$1 () {
	if (hasRequiredMetadata$1) return metadata$1;
	hasRequiredMetadata$1 = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: true, configurable: true, writable: true }) : e[r] = t, e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
	var format = requireFormat$3();
	function fillExcept(info, fillExceptKeys, metadataKey) {
	  var savedKeys = fillExceptKeys.reduce(function (acc, key) {
	    acc[key] = info[key];
	    delete info[key];
	    return acc;
	  }, {});
	  var metadata = Object.keys(info).reduce(function (acc, key) {
	    acc[key] = info[key];
	    delete info[key];
	    return acc;
	  }, {});
	  Object.assign(info, savedKeys, _defineProperty({}, metadataKey, metadata));
	  return info;
	}
	function fillWith(info, fillWithKeys, metadataKey) {
	  info[metadataKey] = fillWithKeys.reduce(function (acc, key) {
	    acc[key] = info[key];
	    delete info[key];
	    return acc;
	  }, {});
	  return info;
	}

	/**
	 * Adds in a "metadata" object to collect extraneous data, similar to the metadata
	 * object in winston 2.x.
	 */
	metadata$1 = format(function (info) {
	  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	  var metadataKey = 'metadata';
	  if (opts.key) {
	    metadataKey = opts.key;
	  }
	  var fillExceptKeys = [];
	  if (!opts.fillExcept && !opts.fillWith) {
	    fillExceptKeys.push('level');
	    fillExceptKeys.push('message');
	  }
	  if (opts.fillExcept) {
	    fillExceptKeys = opts.fillExcept;
	  }
	  if (fillExceptKeys.length > 0) {
	    return fillExcept(info, fillExceptKeys, metadataKey);
	  }
	  if (opts.fillWith) {
	    return fillWith(info, opts.fillWith, metadataKey);
	  }
	  return info;
	});
	return metadata$1;
}

var ms_1;
var hasRequiredMs$1;

function requireMs$1 () {
	if (hasRequiredMs$1) return ms_1;
	hasRequiredMs$1 = 1;

	var _this = void 0;
	var format = requireFormat$3();
	var ms = requireMs$2();

	/*
	 * function ms (info)
	 * Returns an `info` with a `ms` property. The `ms` property holds the Value
	 * of the time difference between two calls in milliseconds.
	 */
	ms_1 = format(function (info) {
	  var curr = +new Date();
	  _this.diff = curr - (_this.prevTime || curr);
	  _this.prevTime = curr;
	  info.ms = "+".concat(ms(_this.diff));
	  return info;
	});
	return ms_1;
}

var prettyPrint;
var hasRequiredPrettyPrint;

function requirePrettyPrint () {
	if (hasRequiredPrettyPrint) return prettyPrint;
	hasRequiredPrettyPrint = 1;

	var inspect = require$$0$4.inspect;
	var format = requireFormat$3();
	var _require = requireTripleBeam(),
	  LEVEL = _require.LEVEL,
	  MESSAGE = _require.MESSAGE,
	  SPLAT = _require.SPLAT;

	/*
	 * function prettyPrint (info)
	 * Returns a new instance of the prettyPrint Format that "prettyPrint"
	 * serializes `info` objects. This was previously exposed as
	 * { prettyPrint: true } to transports in `winston < 3.0.0`.
	 */
	prettyPrint = format(function (info) {
	  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	  //
	  // info[{LEVEL, MESSAGE, SPLAT}] are enumerable here. Since they
	  // are internal, we remove them before util.inspect so they
	  // are not printed.
	  //
	  var stripped = Object.assign({}, info);

	  // Remark (indexzero): update this technique in April 2019
	  // when node@6 is EOL
	  delete stripped[LEVEL];
	  delete stripped[MESSAGE];
	  delete stripped[SPLAT];
	  info[MESSAGE] = inspect(stripped, false, opts.depth || null, opts.colorize);
	  return info;
	});
	return prettyPrint;
}

var printf = {exports: {}};

var hasRequiredPrintf;

function requirePrintf () {
	if (hasRequiredPrintf) return printf.exports;
	hasRequiredPrintf = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	var _require = requireTripleBeam(),
	  MESSAGE = _require.MESSAGE;
	var Printf = /*#__PURE__*/function () {
	  function Printf(templateFn) {
	    _classCallCheck(this, Printf);
	    this.template = templateFn;
	  }
	  return _createClass(Printf, [{
	    key: "transform",
	    value: function transform(info) {
	      info[MESSAGE] = this.template(info);
	      return info;
	    }
	  }]);
	}();
	/*
	 * function printf (templateFn)
	 * Returns a new instance of the printf Format that creates an
	 * intermediate prototype to store the template string-based formatter
	 * function.
	 */
	printf.exports = function (opts) {
	  return new Printf(opts);
	};
	printf.exports.Printf = printf.exports.Format = Printf;
	return printf.exports;
}

/* eslint no-undefined: 0 */

var simple;
var hasRequiredSimple;

function requireSimple () {
	if (hasRequiredSimple) return simple;
	hasRequiredSimple = 1;

	var format = requireFormat$3();
	var _require = requireTripleBeam(),
	  MESSAGE = _require.MESSAGE;
	var jsonStringify = requireSafeStableStringify();

	/*
	 * function simple (info)
	 * Returns a new instance of the simple format TransformStream
	 * which writes a simple representation of logs.
	 *
	 *    const { level, message, splat, ...rest } = info;
	 *
	 *    ${level}: ${message}                            if rest is empty
	 *    ${level}: ${message} ${JSON.stringify(rest)}    otherwise
	 */
	simple = format(function (info) {
	  var stringifiedRest = jsonStringify(Object.assign({}, info, {
	    level: undefined,
	    message: undefined,
	    splat: undefined
	  }));
	  var padding = info.padding && info.padding[info.level] || '';
	  if (stringifiedRest !== '{}') {
	    info[MESSAGE] = "".concat(info.level, ":").concat(padding, " ").concat(info.message, " ").concat(stringifiedRest);
	  } else {
	    info[MESSAGE] = "".concat(info.level, ":").concat(padding, " ").concat(info.message);
	  }
	  return info;
	});
	return simple;
}

var splat;
var hasRequiredSplat;

function requireSplat () {
	if (hasRequiredSplat) return splat;
	hasRequiredSplat = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
	function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
	function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
	function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
	function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
	function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	var util = require$$0$4;
	var _require = requireTripleBeam(),
	  SPLAT = _require.SPLAT;

	/**
	 * Captures the number of format (i.e. %s strings) in a given string.
	 * Based on `util.format`, see Node.js source:
	 * https://github.com/nodejs/node/blob/b1c8f15c5f169e021f7c46eb7b219de95fe97603/lib/util.js#L201-L230
	 * @type {RegExp}
	 */
	var formatRegExp = /%[scdjifoO%]/g;

	/**
	 * Captures the number of escaped % signs in a format string (i.e. %s strings).
	 * @type {RegExp}
	 */
	var escapedPercent = /%%/g;
	var Splatter = /*#__PURE__*/function () {
	  function Splatter(opts) {
	    _classCallCheck(this, Splatter);
	    this.options = opts;
	  }

	  /**
	     * Check to see if tokens <= splat.length, assign { splat, meta } into the
	     * `info` accordingly, and write to this instance.
	     *
	     * @param  {Info} info Logform info message.
	     * @param  {String[]} tokens Set of string interpolation tokens.
	     * @returns {Info} Modified info message
	     * @private
	     */
	  return _createClass(Splatter, [{
	    key: "_splat",
	    value: function _splat(info, tokens) {
	      var msg = info.message;
	      var splat = info[SPLAT] || info.splat || [];
	      var percents = msg.match(escapedPercent);
	      var escapes = percents && percents.length || 0;

	      // The expected splat is the number of tokens minus the number of escapes
	      // e.g.
	      // - { expectedSplat: 3 } '%d %s %j'
	      // - { expectedSplat: 5 } '[%s] %d%% %d%% %s %j'
	      //
	      // Any "meta" will be arugments in addition to the expected splat size
	      // regardless of type. e.g.
	      //
	      // logger.log('info', '%d%% %s %j', 100, 'wow', { such: 'js' }, { thisIsMeta: true });
	      // would result in splat of four (4), but only three (3) are expected. Therefore:
	      //
	      // extraSplat = 3 - 4 = -1
	      // metas = [100, 'wow', { such: 'js' }, { thisIsMeta: true }].splice(-1, -1 * -1);
	      // splat = [100, 'wow', { such: 'js' }]
	      var expectedSplat = tokens.length - escapes;
	      var extraSplat = expectedSplat - splat.length;
	      var metas = extraSplat < 0 ? splat.splice(extraSplat, -1 * extraSplat) : [];

	      // Now that { splat } has been separated from any potential { meta }. we
	      // can assign this to the `info` object and write it to our format stream.
	      // If the additional metas are **NOT** objects or **LACK** enumerable properties
	      // you are going to have a bad time.
	      var metalen = metas.length;
	      if (metalen) {
	        for (var i = 0; i < metalen; i++) {
	          Object.assign(info, metas[i]);
	        }
	      }
	      info.message = util.format.apply(util, [msg].concat(_toConsumableArray(splat)));
	      return info;
	    }

	    /**
	      * Transforms the `info` message by using `util.format` to complete
	      * any `info.message` provided it has string interpolation tokens.
	      * If no tokens exist then `info` is immutable.
	      *
	      * @param  {Info} info Logform info message.
	      * @param  {Object} opts Options for this instance.
	      * @returns {Info} Modified info message
	      */
	  }, {
	    key: "transform",
	    value: function transform(info) {
	      var msg = info.message;
	      var splat = info[SPLAT] || info.splat;

	      // No need to process anything if splat is undefined
	      if (!splat || !splat.length) {
	        return info;
	      }

	      // Extract tokens, if none available default to empty array to
	      // ensure consistancy in expected results
	      var tokens = msg && msg.match && msg.match(formatRegExp);

	      // This condition will take care of inputs with info[SPLAT]
	      // but no tokens present
	      if (!tokens && (splat || splat.length)) {
	        var metas = splat.length > 1 ? splat.splice(0) : splat;

	        // Now that { splat } has been separated from any potential { meta }. we
	        // can assign this to the `info` object and write it to our format stream.
	        // If the additional metas are **NOT** objects or **LACK** enumerable properties
	        // you are going to have a bad time.
	        var metalen = metas.length;
	        if (metalen) {
	          for (var i = 0; i < metalen; i++) {
	            Object.assign(info, metas[i]);
	          }
	        }
	        return info;
	      }
	      if (tokens) {
	        return this._splat(info, tokens);
	      }
	      return info;
	    }
	  }]);
	}();
	/*
	 * function splat (info)
	 * Returns a new instance of the splat format TransformStream
	 * which performs string interpolation from `info` objects. This was
	 * previously exposed implicitly in `winston < 3.0.0`.
	 */
	splat = function (opts) {
	  return new Splatter(opts);
	};
	return splat;
}

var token$1 = /d{1,4}|M{1,4}|YY(?:YY)?|S{1,3}|Do|ZZ|Z|([HhMsDm])\1?|[aA]|"[^"]*"|'[^']*'/g;
var twoDigitsOptional = "\\d\\d?";
var twoDigits = "\\d\\d";
var threeDigits = "\\d{3}";
var fourDigits = "\\d{4}";
var word = "[^\\s]+";
var literal$1 = /\[([^]*?)\]/gm;
function shorten(arr, sLen) {
    var newArr = [];
    for (var i = 0, len = arr.length; i < len; i++) {
        newArr.push(arr[i].substr(0, sLen));
    }
    return newArr;
}
var monthUpdate = function (arrName) { return function (v, i18n) {
    var lowerCaseArr = i18n[arrName].map(function (v) { return v.toLowerCase(); });
    var index = lowerCaseArr.indexOf(v.toLowerCase());
    if (index > -1) {
        return index;
    }
    return null;
}; };
function assign$1(origObj) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
        var obj = args_1[_a];
        for (var key in obj) {
            // @ts-ignore ex
            origObj[key] = obj[key];
        }
    }
    return origObj;
}
var dayNames = [
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday"
];
var monthNames = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
];
var monthNamesShort = shorten(monthNames, 3);
var dayNamesShort = shorten(dayNames, 3);
var defaultI18n = {
    dayNamesShort: dayNamesShort,
    dayNames: dayNames,
    monthNamesShort: monthNamesShort,
    monthNames: monthNames,
    amPm: ["am", "pm"],
    DoFn: function (dayOfMonth) {
        return (dayOfMonth +
            ["th", "st", "nd", "rd"][dayOfMonth % 10 > 3
                ? 0
                : ((dayOfMonth - (dayOfMonth % 10) !== 10 ? 1 : 0) * dayOfMonth) % 10]);
    }
};
var globalI18n = assign$1({}, defaultI18n);
var setGlobalDateI18n = function (i18n) {
    return (globalI18n = assign$1(globalI18n, i18n));
};
var regexEscape = function (str) {
    return str.replace(/[|\\{()[^$+*?.-]/g, "\\$&");
};
var pad = function (val, len) {
    if (len === void 0) { len = 2; }
    val = String(val);
    while (val.length < len) {
        val = "0" + val;
    }
    return val;
};
var formatFlags = {
    D: function (dateObj) { return String(dateObj.getDate()); },
    DD: function (dateObj) { return pad(dateObj.getDate()); },
    Do: function (dateObj, i18n) {
        return i18n.DoFn(dateObj.getDate());
    },
    d: function (dateObj) { return String(dateObj.getDay()); },
    dd: function (dateObj) { return pad(dateObj.getDay()); },
    ddd: function (dateObj, i18n) {
        return i18n.dayNamesShort[dateObj.getDay()];
    },
    dddd: function (dateObj, i18n) {
        return i18n.dayNames[dateObj.getDay()];
    },
    M: function (dateObj) { return String(dateObj.getMonth() + 1); },
    MM: function (dateObj) { return pad(dateObj.getMonth() + 1); },
    MMM: function (dateObj, i18n) {
        return i18n.monthNamesShort[dateObj.getMonth()];
    },
    MMMM: function (dateObj, i18n) {
        return i18n.monthNames[dateObj.getMonth()];
    },
    YY: function (dateObj) {
        return pad(String(dateObj.getFullYear()), 4).substr(2);
    },
    YYYY: function (dateObj) { return pad(dateObj.getFullYear(), 4); },
    h: function (dateObj) { return String(dateObj.getHours() % 12 || 12); },
    hh: function (dateObj) { return pad(dateObj.getHours() % 12 || 12); },
    H: function (dateObj) { return String(dateObj.getHours()); },
    HH: function (dateObj) { return pad(dateObj.getHours()); },
    m: function (dateObj) { return String(dateObj.getMinutes()); },
    mm: function (dateObj) { return pad(dateObj.getMinutes()); },
    s: function (dateObj) { return String(dateObj.getSeconds()); },
    ss: function (dateObj) { return pad(dateObj.getSeconds()); },
    S: function (dateObj) {
        return String(Math.round(dateObj.getMilliseconds() / 100));
    },
    SS: function (dateObj) {
        return pad(Math.round(dateObj.getMilliseconds() / 10), 2);
    },
    SSS: function (dateObj) { return pad(dateObj.getMilliseconds(), 3); },
    a: function (dateObj, i18n) {
        return dateObj.getHours() < 12 ? i18n.amPm[0] : i18n.amPm[1];
    },
    A: function (dateObj, i18n) {
        return dateObj.getHours() < 12
            ? i18n.amPm[0].toUpperCase()
            : i18n.amPm[1].toUpperCase();
    },
    ZZ: function (dateObj) {
        var offset = dateObj.getTimezoneOffset();
        return ((offset > 0 ? "-" : "+") +
            pad(Math.floor(Math.abs(offset) / 60) * 100 + (Math.abs(offset) % 60), 4));
    },
    Z: function (dateObj) {
        var offset = dateObj.getTimezoneOffset();
        return ((offset > 0 ? "-" : "+") +
            pad(Math.floor(Math.abs(offset) / 60), 2) +
            ":" +
            pad(Math.abs(offset) % 60, 2));
    }
};
var monthParse = function (v) { return +v - 1; };
var emptyDigits = [null, twoDigitsOptional];
var emptyWord = [null, word];
var amPm = [
    "isPm",
    word,
    function (v, i18n) {
        var val = v.toLowerCase();
        if (val === i18n.amPm[0]) {
            return 0;
        }
        else if (val === i18n.amPm[1]) {
            return 1;
        }
        return null;
    }
];
var timezoneOffset = [
    "timezoneOffset",
    "[^\\s]*?[\\+\\-]\\d\\d:?\\d\\d|[^\\s]*?Z?",
    function (v) {
        var parts = (v + "").match(/([+-]|\d\d)/gi);
        if (parts) {
            var minutes = +parts[1] * 60 + parseInt(parts[2], 10);
            return parts[0] === "+" ? minutes : -minutes;
        }
        return 0;
    }
];
var parseFlags = {
    D: ["day", twoDigitsOptional],
    DD: ["day", twoDigits],
    Do: ["day", twoDigitsOptional + word, function (v) { return parseInt(v, 10); }],
    M: ["month", twoDigitsOptional, monthParse],
    MM: ["month", twoDigits, monthParse],
    YY: [
        "year",
        twoDigits,
        function (v) {
            var now = new Date();
            var cent = +("" + now.getFullYear()).substr(0, 2);
            return +("" + (+v > 68 ? cent - 1 : cent) + v);
        }
    ],
    h: ["hour", twoDigitsOptional, undefined, "isPm"],
    hh: ["hour", twoDigits, undefined, "isPm"],
    H: ["hour", twoDigitsOptional],
    HH: ["hour", twoDigits],
    m: ["minute", twoDigitsOptional],
    mm: ["minute", twoDigits],
    s: ["second", twoDigitsOptional],
    ss: ["second", twoDigits],
    YYYY: ["year", fourDigits],
    S: ["millisecond", "\\d", function (v) { return +v * 100; }],
    SS: ["millisecond", twoDigits, function (v) { return +v * 10; }],
    SSS: ["millisecond", threeDigits],
    d: emptyDigits,
    dd: emptyDigits,
    ddd: emptyWord,
    dddd: emptyWord,
    MMM: ["month", word, monthUpdate("monthNamesShort")],
    MMMM: ["month", word, monthUpdate("monthNames")],
    a: amPm,
    A: amPm,
    ZZ: timezoneOffset,
    Z: timezoneOffset
};
// Some common format strings
var globalMasks = {
    default: "ddd MMM DD YYYY HH:mm:ss",
    shortDate: "M/D/YY",
    mediumDate: "MMM D, YYYY",
    longDate: "MMMM D, YYYY",
    fullDate: "dddd, MMMM D, YYYY",
    isoDate: "YYYY-MM-DD",
    isoDateTime: "YYYY-MM-DDTHH:mm:ssZ",
    shortTime: "HH:mm",
    mediumTime: "HH:mm:ss",
    longTime: "HH:mm:ss.SSS"
};
var setGlobalDateMasks = function (masks) { return assign$1(globalMasks, masks); };
/***
 * Format a date
 * @method format
 * @param {Date|number} dateObj
 * @param {string} mask Format of the date, i.e. 'mm-dd-yy' or 'shortDate'
 * @returns {string} Formatted date string
 */
var format$3 = function (dateObj, mask, i18n) {
    if (mask === void 0) { mask = globalMasks["default"]; }
    if (i18n === void 0) { i18n = {}; }
    if (typeof dateObj === "number") {
        dateObj = new Date(dateObj);
    }
    if (Object.prototype.toString.call(dateObj) !== "[object Date]" ||
        isNaN(dateObj.getTime())) {
        throw new Error("Invalid Date pass to format");
    }
    mask = globalMasks[mask] || mask;
    var literals = [];
    // Make literals inactive by replacing them with @@@
    mask = mask.replace(literal$1, function ($0, $1) {
        literals.push($1);
        return "@@@";
    });
    var combinedI18nSettings = assign$1(assign$1({}, globalI18n), i18n);
    // Apply formatting rules
    mask = mask.replace(token$1, function ($0) {
        return formatFlags[$0](dateObj, combinedI18nSettings);
    });
    // Inline literal values back into the formatted value
    return mask.replace(/@@@/g, function () { return literals.shift(); });
};
/**
 * Parse a date string into a Javascript Date object /
 * @method parse
 * @param {string} dateStr Date string
 * @param {string} format Date parse format
 * @param {i18n} I18nSettingsOptional Full or subset of I18N settings
 * @returns {Date|null} Returns Date object. Returns null what date string is invalid or doesn't match format
 */
function parse$1(dateStr, format, i18n) {
    if (i18n === void 0) { i18n = {}; }
    if (typeof format !== "string") {
        throw new Error("Invalid format in fecha parse");
    }
    // Check to see if the format is actually a mask
    format = globalMasks[format] || format;
    // Avoid regular expression denial of service, fail early for really long strings
    // https://www.owasp.org/index.php/Regular_expression_Denial_of_Service_-_ReDoS
    if (dateStr.length > 1000) {
        return null;
    }
    // Default to the beginning of the year.
    var today = new Date();
    var dateInfo = {
        year: today.getFullYear(),
        month: 0,
        day: 1,
        hour: 0,
        minute: 0,
        second: 0,
        millisecond: 0,
        isPm: null,
        timezoneOffset: null
    };
    var parseInfo = [];
    var literals = [];
    // Replace all the literals with @@@. Hopefully a string that won't exist in the format
    var newFormat = format.replace(literal$1, function ($0, $1) {
        literals.push(regexEscape($1));
        return "@@@";
    });
    var specifiedFields = {};
    var requiredFields = {};
    // Change every token that we find into the correct regex
    newFormat = regexEscape(newFormat).replace(token$1, function ($0) {
        var info = parseFlags[$0];
        var field = info[0], regex = info[1], requiredField = info[3];
        // Check if the person has specified the same field twice. This will lead to confusing results.
        if (specifiedFields[field]) {
            throw new Error("Invalid format. " + field + " specified twice in format");
        }
        specifiedFields[field] = true;
        // Check if there are any required fields. For instance, 12 hour time requires AM/PM specified
        if (requiredField) {
            requiredFields[requiredField] = true;
        }
        parseInfo.push(info);
        return "(" + regex + ")";
    });
    // Check all the required fields are present
    Object.keys(requiredFields).forEach(function (field) {
        if (!specifiedFields[field]) {
            throw new Error("Invalid format. " + field + " is required in specified format");
        }
    });
    // Add back all the literals after
    newFormat = newFormat.replace(/@@@/g, function () { return literals.shift(); });
    // Check if the date string matches the format. If it doesn't return null
    var matches = dateStr.match(new RegExp(newFormat, "i"));
    if (!matches) {
        return null;
    }
    var combinedI18nSettings = assign$1(assign$1({}, globalI18n), i18n);
    // For each match, call the parser function for that date part
    for (var i = 1; i < matches.length; i++) {
        var _a = parseInfo[i - 1], field = _a[0], parser = _a[2];
        var value = parser
            ? parser(matches[i], combinedI18nSettings)
            : +matches[i];
        // If the parser can't make sense of the value, return null
        if (value == null) {
            return null;
        }
        dateInfo[field] = value;
    }
    if (dateInfo.isPm === 1 && dateInfo.hour != null && +dateInfo.hour !== 12) {
        dateInfo.hour = +dateInfo.hour + 12;
    }
    else if (dateInfo.isPm === 0 && +dateInfo.hour === 12) {
        dateInfo.hour = 0;
    }
    var dateTZ;
    if (dateInfo.timezoneOffset == null) {
        dateTZ = new Date(dateInfo.year, dateInfo.month, dateInfo.day, dateInfo.hour, dateInfo.minute, dateInfo.second, dateInfo.millisecond);
        var validateFields = [
            ["month", "getMonth"],
            ["day", "getDate"],
            ["hour", "getHours"],
            ["minute", "getMinutes"],
            ["second", "getSeconds"]
        ];
        for (var i = 0, len = validateFields.length; i < len; i++) {
            // Check to make sure the date field is within the allowed range. Javascript dates allows values
            // outside the allowed range. If the values don't match the value was invalid
            if (specifiedFields[validateFields[i][0]] &&
                dateInfo[validateFields[i][0]] !== dateTZ[validateFields[i][1]]()) {
                return null;
            }
        }
    }
    else {
        dateTZ = new Date(Date.UTC(dateInfo.year, dateInfo.month, dateInfo.day, dateInfo.hour, dateInfo.minute - dateInfo.timezoneOffset, dateInfo.second, dateInfo.millisecond));
        // We can't validate dates in another timezone unfortunately. Do a basic check instead
        if (dateInfo.month > 11 ||
            dateInfo.month < 0 ||
            dateInfo.day > 31 ||
            dateInfo.day < 1 ||
            dateInfo.hour > 23 ||
            dateInfo.hour < 0 ||
            dateInfo.minute > 59 ||
            dateInfo.minute < 0 ||
            dateInfo.second > 59 ||
            dateInfo.second < 0) {
            return null;
        }
    }
    // Don't allow invalid dates
    return dateTZ;
}
var fecha = {
    format: format$3,
    parse: parse$1,
    defaultI18n: defaultI18n,
    setGlobalDateI18n: setGlobalDateI18n,
    setGlobalDateMasks: setGlobalDateMasks
};

const fecha$1 = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
    __proto__: null,
    assign: assign$1,
    default: fecha,
    defaultI18n,
    format: format$3,
    parse: parse$1,
    setGlobalDateI18n,
    setGlobalDateMasks
}, Symbol.toStringTag, { value: 'Module' }));

const require$$0$3 = /*@__PURE__*/getAugmentedNamespace(fecha$1);

var timestamp;
var hasRequiredTimestamp;

function requireTimestamp () {
	if (hasRequiredTimestamp) return timestamp;
	hasRequiredTimestamp = 1;

	var fecha = require$$0$3;
	var format = requireFormat$3();

	/*
	 * function timestamp (info)
	 * Returns a new instance of the timestamp Format which adds a timestamp
	 * to the info. It was previously available in winston < 3.0.0 as:
	 *
	 * - { timestamp: true }             // `new Date.toISOString()`
	 * - { timestamp: function:String }  // Value returned by `timestamp()`
	 */
	timestamp = format(function (info) {
	  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	  if (opts.format) {
	    info.timestamp = typeof opts.format === 'function' ? opts.format() : fecha.format(new Date(), opts.format);
	  }
	  if (!info.timestamp) {
	    info.timestamp = new Date().toISOString();
	  }
	  if (opts.alias) {
	    info[opts.alias] = info.timestamp;
	  }
	  return info;
	});
	return timestamp;
}

var uncolorize;
var hasRequiredUncolorize;

function requireUncolorize () {
	if (hasRequiredUncolorize) return uncolorize;
	hasRequiredUncolorize = 1;

	var colors = requireSafe();
	var format = requireFormat$3();
	var _require = requireTripleBeam(),
	  MESSAGE = _require.MESSAGE;

	/*
	 * function uncolorize (info)
	 * Returns a new instance of the uncolorize Format that strips colors
	 * from `info` objects. This was previously exposed as { stripColors: true }
	 * to transports in `winston < 3.0.0`.
	 */
	uncolorize = format(function (info, opts) {
	  if (opts.level !== false) {
	    info.level = colors.strip(info.level);
	  }
	  if (opts.message !== false) {
	    info.message = colors.strip(String(info.message));
	  }
	  if (opts.raw !== false && info[MESSAGE]) {
	    info[MESSAGE] = colors.strip(String(info[MESSAGE]));
	  }
	  return info;
	});
	return uncolorize;
}

var hasRequiredBrowser$4;

function requireBrowser$4 () {
	if (hasRequiredBrowser$4) return browser$4;
	hasRequiredBrowser$4 = 1;

	/*
	 * @api public
	 * @property {function} format
	 * Both the construction method and set of exposed
	 * formats.
	 */
	var format = browser$4.format = requireFormat$3();

	/*
	 * @api public
	 * @method {function} levels
	 * Registers the specified levels with logform.
	 */
	browser$4.levels = requireLevels();

	//
	// Setup all transports as eager-loaded exports
	// so that they are static for the bundlers.
	//
	Object.defineProperty(format, 'align', {
	  value: requireAlign()
	});
	Object.defineProperty(format, 'cli', {
	  value: requireCli()
	});
	Object.defineProperty(format, 'colorize', {
	  value: requireColorize()
	});
	Object.defineProperty(format, 'combine', {
	  value: requireCombine()
	});
	Object.defineProperty(format, 'errors', {
	  value: requireErrors$1()
	});
	Object.defineProperty(format, 'json', {
	  value: requireJson$1()
	});
	Object.defineProperty(format, 'label', {
	  value: requireLabel()
	});
	Object.defineProperty(format, 'logstash', {
	  value: requireLogstash()
	});
	Object.defineProperty(format, 'metadata', {
	  value: requireMetadata$1()
	});
	Object.defineProperty(format, 'ms', {
	  value: requireMs$1()
	});
	Object.defineProperty(format, 'padLevels', {
	  value: requirePadLevels()
	});
	Object.defineProperty(format, 'prettyPrint', {
	  value: requirePrettyPrint()
	});
	Object.defineProperty(format, 'printf', {
	  value: requirePrintf()
	});
	Object.defineProperty(format, 'simple', {
	  value: requireSimple()
	});
	Object.defineProperty(format, 'splat', {
	  value: requireSplat()
	});
	Object.defineProperty(format, 'timestamp', {
	  value: requireTimestamp()
	});
	Object.defineProperty(format, 'uncolorize', {
	  value: requireUncolorize()
	});
	return browser$4;
}

var common = {};

/**
 * common.js: Internal helper and utility functions for winston.
 *
 * (C) 2010 Charlie Robbins
 * MIT LICENCE
 */

var hasRequiredCommon;

function requireCommon () {
	if (hasRequiredCommon) return common;
	hasRequiredCommon = 1;
	(function (exports$1) {

		var _require = require$$0$4,
		  format = _require.format;

		/**
		 * Set of simple deprecation notices and a way to expose them for a set of
		 * properties.
		 * @type {Object}
		 * @private
		 */
		exports$1.warn = {
		  deprecated: function deprecated(prop) {
		    return function () {
		      throw new Error(format('{ %s } was removed in winston@3.0.0.', prop));
		    };
		  },
		  useFormat: function useFormat(prop) {
		    return function () {
		      throw new Error([format('{ %s } was removed in winston@3.0.0.', prop), 'Use a custom winston.format = winston.format(function) instead.'].join('\n'));
		    };
		  },
		  forFunctions: function forFunctions(obj, type, props) {
		    props.forEach(function (prop) {
		      obj[prop] = exports$1.warn[type](prop);
		    });
		  },
		  forProperties: function forProperties(obj, type, props) {
		    props.forEach(function (prop) {
		      var notice = exports$1.warn[type](prop);
		      Object.defineProperty(obj, prop, {
		        get: notice,
		        set: notice
		      });
		    });
		  }
		}; 
	} (common));
	return common;
}

const version = "3.18.3";
const require$$2$1 = {
  version};

var transports = {};

var dist = {exports: {}};

var modern$1 = {exports: {}};

var browser$3;
var hasRequiredBrowser$3;

function requireBrowser$3 () {
	if (hasRequiredBrowser$3) return browser$3;
	hasRequiredBrowser$3 = 1;
	/**
	 * Module exports.
	 */

	browser$3 = deprecate;

	/**
	 * Mark that a method should not be used.
	 * Returns a modified function which warns once by default.
	 *
	 * If `localStorage.noDeprecation = true` is set, then it is a no-op.
	 *
	 * If `localStorage.throwDeprecation = true` is set, then deprecated functions
	 * will throw an Error when invoked.
	 *
	 * If `localStorage.traceDeprecation = true` is set, then deprecated functions
	 * will invoke `console.trace()` instead of `console.error()`.
	 *
	 * @param {Function} fn - the function to deprecate
	 * @param {String} msg - the string to print to the console when `fn` is invoked
	 * @returns {Function} a new "deprecated" version of `fn`
	 * @api public
	 */

	function deprecate (fn, msg) {
	  if (config('noDeprecation')) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (config('throwDeprecation')) {
	        throw new Error(msg);
	      } else if (config('traceDeprecation')) {
	        console.trace(msg);
	      } else {
	        console.warn(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	}

	/**
	 * Checks `localStorage` for boolean values for the given `name`.
	 *
	 * @param {String} name
	 * @returns {Boolean}
	 * @api private
	 */

	function config (name) {
	  // accessing global.localStorage can trigger a DOMException in sandboxed iframes
	  try {
	    if (!commonjsGlobal.localStorage) return false;
	  } catch (_) {
	    return false;
	  }
	  var val = commonjsGlobal.localStorage[name];
	  if (null == val) return false;
	  return String(val).toLowerCase() === 'true';
	}
	return browser$3;
}

var streamBrowser$1;
var hasRequiredStreamBrowser$1;

function requireStreamBrowser$1 () {
	if (hasRequiredStreamBrowser$1) return streamBrowser$1;
	hasRequiredStreamBrowser$1 = 1;
	streamBrowser$1 = require$$0$5.EventEmitter;
	return streamBrowser$1;
}

var destroy_1$1;
var hasRequiredDestroy$1;

function requireDestroy$1 () {
	if (hasRequiredDestroy$1) return destroy_1$1;
	hasRequiredDestroy$1 = 1;

	// undocumented cb() API, needed for core, not for public API
	function destroy(err, cb) {
	  var _this = this;
	  var readableDestroyed = this._readableState && this._readableState.destroyed;
	  var writableDestroyed = this._writableState && this._writableState.destroyed;
	  if (readableDestroyed || writableDestroyed) {
	    if (cb) {
	      cb(err);
	    } else if (err) {
	      if (!this._writableState) {
	        process.nextTick(emitErrorNT, this, err);
	      } else if (!this._writableState.errorEmitted) {
	        this._writableState.errorEmitted = true;
	        process.nextTick(emitErrorNT, this, err);
	      }
	    }
	    return this;
	  }

	  // we set destroyed to true before firing error callbacks in order
	  // to make it re-entrance safe in case destroy() is called within callbacks

	  if (this._readableState) {
	    this._readableState.destroyed = true;
	  }

	  // if this is a duplex stream mark the writable part as destroyed as well
	  if (this._writableState) {
	    this._writableState.destroyed = true;
	  }
	  this._destroy(err || null, function (err) {
	    if (!cb && err) {
	      if (!_this._writableState) {
	        process.nextTick(emitErrorAndCloseNT, _this, err);
	      } else if (!_this._writableState.errorEmitted) {
	        _this._writableState.errorEmitted = true;
	        process.nextTick(emitErrorAndCloseNT, _this, err);
	      } else {
	        process.nextTick(emitCloseNT, _this);
	      }
	    } else if (cb) {
	      process.nextTick(emitCloseNT, _this);
	      cb(err);
	    } else {
	      process.nextTick(emitCloseNT, _this);
	    }
	  });
	  return this;
	}
	function emitErrorAndCloseNT(self, err) {
	  emitErrorNT(self, err);
	  emitCloseNT(self);
	}
	function emitCloseNT(self) {
	  if (self._writableState && !self._writableState.emitClose) return;
	  if (self._readableState && !self._readableState.emitClose) return;
	  self.emit('close');
	}
	function undestroy() {
	  if (this._readableState) {
	    this._readableState.destroyed = false;
	    this._readableState.reading = false;
	    this._readableState.ended = false;
	    this._readableState.endEmitted = false;
	  }
	  if (this._writableState) {
	    this._writableState.destroyed = false;
	    this._writableState.ended = false;
	    this._writableState.ending = false;
	    this._writableState.finalCalled = false;
	    this._writableState.prefinished = false;
	    this._writableState.finished = false;
	    this._writableState.errorEmitted = false;
	  }
	}
	function emitErrorNT(self, err) {
	  self.emit('error', err);
	}
	function errorOrDestroy(stream, err) {
	  // We have tests that rely on errors being emitted
	  // in the same tick, so changing this is semver major.
	  // For now when you opt-in to autoDestroy we allow
	  // the error to be emitted nextTick. In a future
	  // semver major update we should change the default to this.

	  var rState = stream._readableState;
	  var wState = stream._writableState;
	  if (rState && rState.autoDestroy || wState && wState.autoDestroy) stream.destroy(err);else stream.emit('error', err);
	}
	destroy_1$1 = {
	  destroy: destroy,
	  undestroy: undestroy,
	  errorOrDestroy: errorOrDestroy
	};
	return destroy_1$1;
}

var errorsBrowser = {};

var hasRequiredErrorsBrowser;

function requireErrorsBrowser () {
	if (hasRequiredErrorsBrowser) return errorsBrowser;
	hasRequiredErrorsBrowser = 1;

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

	var codes = {};

	function createErrorType(code, message, Base) {
	  if (!Base) {
	    Base = Error;
	  }

	  function getMessage(arg1, arg2, arg3) {
	    if (typeof message === 'string') {
	      return message;
	    } else {
	      return message(arg1, arg2, arg3);
	    }
	  }

	  var NodeError =
	  /*#__PURE__*/
	  function (_Base) {
	    _inheritsLoose(NodeError, _Base);

	    function NodeError(arg1, arg2, arg3) {
	      return _Base.call(this, getMessage(arg1, arg2, arg3)) || this;
	    }

	    return NodeError;
	  }(Base);

	  NodeError.prototype.name = Base.name;
	  NodeError.prototype.code = code;
	  codes[code] = NodeError;
	} // https://github.com/nodejs/node/blob/v10.8.0/lib/internal/errors.js


	function oneOf(expected, thing) {
	  if (Array.isArray(expected)) {
	    var len = expected.length;
	    expected = expected.map(function (i) {
	      return String(i);
	    });

	    if (len > 2) {
	      return "one of ".concat(thing, " ").concat(expected.slice(0, len - 1).join(', '), ", or ") + expected[len - 1];
	    } else if (len === 2) {
	      return "one of ".concat(thing, " ").concat(expected[0], " or ").concat(expected[1]);
	    } else {
	      return "of ".concat(thing, " ").concat(expected[0]);
	    }
	  } else {
	    return "of ".concat(thing, " ").concat(String(expected));
	  }
	} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith


	function startsWith(str, search, pos) {
	  return str.substr(0 , search.length) === search;
	} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith


	function endsWith(str, search, this_len) {
	  if (this_len === undefined || this_len > str.length) {
	    this_len = str.length;
	  }

	  return str.substring(this_len - search.length, this_len) === search;
	} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes


	function includes(str, search, start) {
	  if (typeof start !== 'number') {
	    start = 0;
	  }

	  if (start + search.length > str.length) {
	    return false;
	  } else {
	    return str.indexOf(search, start) !== -1;
	  }
	}

	createErrorType('ERR_INVALID_OPT_VALUE', function (name, value) {
	  return 'The value "' + value + '" is invalid for option "' + name + '"';
	}, TypeError);
	createErrorType('ERR_INVALID_ARG_TYPE', function (name, expected, actual) {
	  // determiner: 'must be' or 'must not be'
	  var determiner;

	  if (typeof expected === 'string' && startsWith(expected, 'not ')) {
	    determiner = 'must not be';
	    expected = expected.replace(/^not /, '');
	  } else {
	    determiner = 'must be';
	  }

	  var msg;

	  if (endsWith(name, ' argument')) {
	    // For cases like 'first argument'
	    msg = "The ".concat(name, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
	  } else {
	    var type = includes(name, '.') ? 'property' : 'argument';
	    msg = "The \"".concat(name, "\" ").concat(type, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
	  }

	  msg += ". Received type ".concat(typeof actual);
	  return msg;
	}, TypeError);
	createErrorType('ERR_STREAM_PUSH_AFTER_EOF', 'stream.push() after EOF');
	createErrorType('ERR_METHOD_NOT_IMPLEMENTED', function (name) {
	  return 'The ' + name + ' method is not implemented';
	});
	createErrorType('ERR_STREAM_PREMATURE_CLOSE', 'Premature close');
	createErrorType('ERR_STREAM_DESTROYED', function (name) {
	  return 'Cannot call ' + name + ' after a stream was destroyed';
	});
	createErrorType('ERR_MULTIPLE_CALLBACK', 'Callback called multiple times');
	createErrorType('ERR_STREAM_CANNOT_PIPE', 'Cannot pipe, not readable');
	createErrorType('ERR_STREAM_WRITE_AFTER_END', 'write after end');
	createErrorType('ERR_STREAM_NULL_VALUES', 'May not write null values to stream', TypeError);
	createErrorType('ERR_UNKNOWN_ENCODING', function (arg) {
	  return 'Unknown encoding: ' + arg;
	}, TypeError);
	createErrorType('ERR_STREAM_UNSHIFT_AFTER_END_EVENT', 'stream.unshift() after end event');
	errorsBrowser.codes = codes;
	return errorsBrowser;
}

var state;
var hasRequiredState;

function requireState () {
	if (hasRequiredState) return state;
	hasRequiredState = 1;

	var ERR_INVALID_OPT_VALUE = requireErrorsBrowser().codes.ERR_INVALID_OPT_VALUE;
	function highWaterMarkFrom(options, isDuplex, duplexKey) {
	  return options.highWaterMark != null ? options.highWaterMark : isDuplex ? options[duplexKey] : null;
	}
	function getHighWaterMark(state, options, duplexKey, isDuplex) {
	  var hwm = highWaterMarkFrom(options, isDuplex, duplexKey);
	  if (hwm != null) {
	    if (!(isFinite(hwm) && Math.floor(hwm) === hwm) || hwm < 0) {
	      var name = isDuplex ? duplexKey : 'highWaterMark';
	      throw new ERR_INVALID_OPT_VALUE(name, hwm);
	    }
	    return Math.floor(hwm);
	  }

	  // Default value
	  return state.objectMode ? 16 : 16 * 1024;
	}
	state = {
	  getHighWaterMark: getHighWaterMark
	};
	return state;
}

var inherits_browser = {exports: {}};

var hasRequiredInherits_browser;

function requireInherits_browser () {
	if (hasRequiredInherits_browser) return inherits_browser.exports;
	hasRequiredInherits_browser = 1;
	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  inherits_browser.exports = function inherits(ctor, superCtor) {
	    if (superCtor) {
	      ctor.super_ = superCtor;
	      ctor.prototype = Object.create(superCtor.prototype, {
	        constructor: {
	          value: ctor,
	          enumerable: false,
	          writable: true,
	          configurable: true
	        }
	      });
	    }
	  };
	} else {
	  // old school shim for old browsers
	  inherits_browser.exports = function inherits(ctor, superCtor) {
	    if (superCtor) {
	      ctor.super_ = superCtor;
	      var TempCtor = function () {};
	      TempCtor.prototype = superCtor.prototype;
	      ctor.prototype = new TempCtor();
	      ctor.prototype.constructor = ctor;
	    }
	  };
	}
	return inherits_browser.exports;
}

var buffer_list;
var hasRequiredBuffer_list;

function requireBuffer_list () {
	if (hasRequiredBuffer_list) return buffer_list;
	hasRequiredBuffer_list = 1;

	function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
	function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
	function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
	function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(input); }
	var _require = require$$0$6,
	  Buffer = _require.Buffer;
	var _require2 = require$$0$4,
	  inspect = _require2.inspect;
	var custom = inspect && inspect.custom || 'inspect';
	function copyBuffer(src, target, offset) {
	  Buffer.prototype.copy.call(src, target, offset);
	}
	buffer_list = /*#__PURE__*/function () {
	  function BufferList() {
	    _classCallCheck(this, BufferList);
	    this.head = null;
	    this.tail = null;
	    this.length = 0;
	  }
	  _createClass(BufferList, [{
	    key: "push",
	    value: function push(v) {
	      var entry = {
	        data: v,
	        next: null
	      };
	      if (this.length > 0) this.tail.next = entry;else this.head = entry;
	      this.tail = entry;
	      ++this.length;
	    }
	  }, {
	    key: "unshift",
	    value: function unshift(v) {
	      var entry = {
	        data: v,
	        next: this.head
	      };
	      if (this.length === 0) this.tail = entry;
	      this.head = entry;
	      ++this.length;
	    }
	  }, {
	    key: "shift",
	    value: function shift() {
	      if (this.length === 0) return;
	      var ret = this.head.data;
	      if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
	      --this.length;
	      return ret;
	    }
	  }, {
	    key: "clear",
	    value: function clear() {
	      this.head = this.tail = null;
	      this.length = 0;
	    }
	  }, {
	    key: "join",
	    value: function join(s) {
	      if (this.length === 0) return '';
	      var p = this.head;
	      var ret = '' + p.data;
	      while (p = p.next) ret += s + p.data;
	      return ret;
	    }
	  }, {
	    key: "concat",
	    value: function concat(n) {
	      if (this.length === 0) return Buffer.alloc(0);
	      var ret = Buffer.allocUnsafe(n >>> 0);
	      var p = this.head;
	      var i = 0;
	      while (p) {
	        copyBuffer(p.data, ret, i);
	        i += p.data.length;
	        p = p.next;
	      }
	      return ret;
	    }

	    // Consumes a specified amount of bytes or characters from the buffered data.
	  }, {
	    key: "consume",
	    value: function consume(n, hasStrings) {
	      var ret;
	      if (n < this.head.data.length) {
	        // `slice` is the same for buffers and strings.
	        ret = this.head.data.slice(0, n);
	        this.head.data = this.head.data.slice(n);
	      } else if (n === this.head.data.length) {
	        // First chunk is a perfect match.
	        ret = this.shift();
	      } else {
	        // Result spans more than one buffer.
	        ret = hasStrings ? this._getString(n) : this._getBuffer(n);
	      }
	      return ret;
	    }
	  }, {
	    key: "first",
	    value: function first() {
	      return this.head.data;
	    }

	    // Consumes a specified amount of characters from the buffered data.
	  }, {
	    key: "_getString",
	    value: function _getString(n) {
	      var p = this.head;
	      var c = 1;
	      var ret = p.data;
	      n -= ret.length;
	      while (p = p.next) {
	        var str = p.data;
	        var nb = n > str.length ? str.length : n;
	        if (nb === str.length) ret += str;else ret += str.slice(0, n);
	        n -= nb;
	        if (n === 0) {
	          if (nb === str.length) {
	            ++c;
	            if (p.next) this.head = p.next;else this.head = this.tail = null;
	          } else {
	            this.head = p;
	            p.data = str.slice(nb);
	          }
	          break;
	        }
	        ++c;
	      }
	      this.length -= c;
	      return ret;
	    }

	    // Consumes a specified amount of bytes from the buffered data.
	  }, {
	    key: "_getBuffer",
	    value: function _getBuffer(n) {
	      var ret = Buffer.allocUnsafe(n);
	      var p = this.head;
	      var c = 1;
	      p.data.copy(ret);
	      n -= p.data.length;
	      while (p = p.next) {
	        var buf = p.data;
	        var nb = n > buf.length ? buf.length : n;
	        buf.copy(ret, ret.length - n, 0, nb);
	        n -= nb;
	        if (n === 0) {
	          if (nb === buf.length) {
	            ++c;
	            if (p.next) this.head = p.next;else this.head = this.tail = null;
	          } else {
	            this.head = p;
	            p.data = buf.slice(nb);
	          }
	          break;
	        }
	        ++c;
	      }
	      this.length -= c;
	      return ret;
	    }

	    // Make sure the linked list only shows the minimal necessary information.
	  }, {
	    key: custom,
	    value: function value(_, options) {
	      return inspect(this, _objectSpread(_objectSpread({}, options), {}, {
	        // Only inspect one level.
	        depth: 0,
	        // It should not recurse.
	        customInspect: false
	      }));
	    }
	  }]);
	  return BufferList;
	}();
	return buffer_list;
}

var string_decoder$1 = {};

var safeBuffer$1 = {exports: {}};

/*! safe-buffer. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */

var hasRequiredSafeBuffer$1;

function requireSafeBuffer$1 () {
	if (hasRequiredSafeBuffer$1) return safeBuffer$1.exports;
	hasRequiredSafeBuffer$1 = 1;
	(function (module, exports$1) {
		/* eslint-disable node/no-deprecated-api */
		var buffer = require$$0$6;
		var Buffer = buffer.Buffer;

		// alternative to using Object.keys for old browsers
		function copyProps (src, dst) {
		  for (var key in src) {
		    dst[key] = src[key];
		  }
		}
		if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
		  module.exports = buffer;
		} else {
		  // Copy properties from require('buffer')
		  copyProps(buffer, exports$1);
		  exports$1.Buffer = SafeBuffer;
		}

		function SafeBuffer (arg, encodingOrOffset, length) {
		  return Buffer(arg, encodingOrOffset, length)
		}

		SafeBuffer.prototype = Object.create(Buffer.prototype);

		// Copy static methods from Buffer
		copyProps(Buffer, SafeBuffer);

		SafeBuffer.from = function (arg, encodingOrOffset, length) {
		  if (typeof arg === 'number') {
		    throw new TypeError('Argument must not be a number')
		  }
		  return Buffer(arg, encodingOrOffset, length)
		};

		SafeBuffer.alloc = function (size, fill, encoding) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  var buf = Buffer(size);
		  if (fill !== undefined) {
		    if (typeof encoding === 'string') {
		      buf.fill(fill, encoding);
		    } else {
		      buf.fill(fill);
		    }
		  } else {
		    buf.fill(0);
		  }
		  return buf
		};

		SafeBuffer.allocUnsafe = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return Buffer(size)
		};

		SafeBuffer.allocUnsafeSlow = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return buffer.SlowBuffer(size)
		}; 
	} (safeBuffer$1, safeBuffer$1.exports));
	return safeBuffer$1.exports;
}

var hasRequiredString_decoder$1;

function requireString_decoder$1 () {
	if (hasRequiredString_decoder$1) return string_decoder$1;
	hasRequiredString_decoder$1 = 1;

	/*<replacement>*/

	var Buffer = requireSafeBuffer$1().Buffer;
	/*</replacement>*/

	var isEncoding = Buffer.isEncoding || function (encoding) {
	  encoding = '' + encoding;
	  switch (encoding && encoding.toLowerCase()) {
	    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
	      return true;
	    default:
	      return false;
	  }
	};

	function _normalizeEncoding(enc) {
	  if (!enc) return 'utf8';
	  var retried;
	  while (true) {
	    switch (enc) {
	      case 'utf8':
	      case 'utf-8':
	        return 'utf8';
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return 'utf16le';
	      case 'latin1':
	      case 'binary':
	        return 'latin1';
	      case 'base64':
	      case 'ascii':
	      case 'hex':
	        return enc;
	      default:
	        if (retried) return; // undefined
	        enc = ('' + enc).toLowerCase();
	        retried = true;
	    }
	  }
	}
	// Do not cache `Buffer.isEncoding` when checking encoding names as some
	// modules monkey-patch it to support additional encodings
	function normalizeEncoding(enc) {
	  var nenc = _normalizeEncoding(enc);
	  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
	  return nenc || enc;
	}

	// StringDecoder provides an interface for efficiently splitting a series of
	// buffers into a series of JS strings without breaking apart multi-byte
	// characters.
	string_decoder$1.StringDecoder = StringDecoder;
	function StringDecoder(encoding) {
	  this.encoding = normalizeEncoding(encoding);
	  var nb;
	  switch (this.encoding) {
	    case 'utf16le':
	      this.text = utf16Text;
	      this.end = utf16End;
	      nb = 4;
	      break;
	    case 'utf8':
	      this.fillLast = utf8FillLast;
	      nb = 4;
	      break;
	    case 'base64':
	      this.text = base64Text;
	      this.end = base64End;
	      nb = 3;
	      break;
	    default:
	      this.write = simpleWrite;
	      this.end = simpleEnd;
	      return;
	  }
	  this.lastNeed = 0;
	  this.lastTotal = 0;
	  this.lastChar = Buffer.allocUnsafe(nb);
	}

	StringDecoder.prototype.write = function (buf) {
	  if (buf.length === 0) return '';
	  var r;
	  var i;
	  if (this.lastNeed) {
	    r = this.fillLast(buf);
	    if (r === undefined) return '';
	    i = this.lastNeed;
	    this.lastNeed = 0;
	  } else {
	    i = 0;
	  }
	  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
	  return r || '';
	};

	StringDecoder.prototype.end = utf8End;

	// Returns only complete characters in a Buffer
	StringDecoder.prototype.text = utf8Text;

	// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
	StringDecoder.prototype.fillLast = function (buf) {
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
	  this.lastNeed -= buf.length;
	};

	// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
	// continuation byte. If an invalid byte is detected, -2 is returned.
	function utf8CheckByte(byte) {
	  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
	  return byte >> 6 === 0x02 ? -1 : -2;
	}

	// Checks at most 3 bytes at the end of a Buffer in order to detect an
	// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
	// needed to complete the UTF-8 character (if applicable) are returned.
	function utf8CheckIncomplete(self, buf, i) {
	  var j = buf.length - 1;
	  if (j < i) return 0;
	  var nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 1;
	    return nb;
	  }
	  if (--j < i || nb === -2) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 2;
	    return nb;
	  }
	  if (--j < i || nb === -2) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) {
	      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
	    }
	    return nb;
	  }
	  return 0;
	}

	// Validates as many continuation bytes for a multi-byte UTF-8 character as
	// needed or are available. If we see a non-continuation byte where we expect
	// one, we "replace" the validated continuation bytes we've seen so far with
	// a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
	// behavior. The continuation byte check is included three times in the case
	// where all of the continuation bytes for a character exist in the same buffer.
	// It is also done this way as a slight performance increase instead of using a
	// loop.
	function utf8CheckExtraBytes(self, buf, p) {
	  if ((buf[0] & 0xC0) !== 0x80) {
	    self.lastNeed = 0;
	    return '\ufffd';
	  }
	  if (self.lastNeed > 1 && buf.length > 1) {
	    if ((buf[1] & 0xC0) !== 0x80) {
	      self.lastNeed = 1;
	      return '\ufffd';
	    }
	    if (self.lastNeed > 2 && buf.length > 2) {
	      if ((buf[2] & 0xC0) !== 0x80) {
	        self.lastNeed = 2;
	        return '\ufffd';
	      }
	    }
	  }
	}

	// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
	function utf8FillLast(buf) {
	  var p = this.lastTotal - this.lastNeed;
	  var r = utf8CheckExtraBytes(this, buf);
	  if (r !== undefined) return r;
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, p, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, p, 0, buf.length);
	  this.lastNeed -= buf.length;
	}

	// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
	// partial character, the character's bytes are buffered until the required
	// number of bytes are available.
	function utf8Text(buf, i) {
	  var total = utf8CheckIncomplete(this, buf, i);
	  if (!this.lastNeed) return buf.toString('utf8', i);
	  this.lastTotal = total;
	  var end = buf.length - (total - this.lastNeed);
	  buf.copy(this.lastChar, 0, end);
	  return buf.toString('utf8', i, end);
	}

	// For UTF-8, a replacement character is added when ending on a partial
	// character.
	function utf8End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + '\ufffd';
	  return r;
	}

	// UTF-16LE typically needs two bytes per character, but even if we have an even
	// number of bytes available, we need to check if we end on a leading/high
	// surrogate. In that case, we need to wait for the next two bytes in order to
	// decode the last character properly.
	function utf16Text(buf, i) {
	  if ((buf.length - i) % 2 === 0) {
	    var r = buf.toString('utf16le', i);
	    if (r) {
	      var c = r.charCodeAt(r.length - 1);
	      if (c >= 0xD800 && c <= 0xDBFF) {
	        this.lastNeed = 2;
	        this.lastTotal = 4;
	        this.lastChar[0] = buf[buf.length - 2];
	        this.lastChar[1] = buf[buf.length - 1];
	        return r.slice(0, -1);
	      }
	    }
	    return r;
	  }
	  this.lastNeed = 1;
	  this.lastTotal = 2;
	  this.lastChar[0] = buf[buf.length - 1];
	  return buf.toString('utf16le', i, buf.length - 1);
	}

	// For UTF-16LE we do not explicitly append special replacement characters if we
	// end on a partial character, we simply let v8 handle that.
	function utf16End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) {
	    var end = this.lastTotal - this.lastNeed;
	    return r + this.lastChar.toString('utf16le', 0, end);
	  }
	  return r;
	}

	function base64Text(buf, i) {
	  var n = (buf.length - i) % 3;
	  if (n === 0) return buf.toString('base64', i);
	  this.lastNeed = 3 - n;
	  this.lastTotal = 3;
	  if (n === 1) {
	    this.lastChar[0] = buf[buf.length - 1];
	  } else {
	    this.lastChar[0] = buf[buf.length - 2];
	    this.lastChar[1] = buf[buf.length - 1];
	  }
	  return buf.toString('base64', i, buf.length - n);
	}

	function base64End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
	  return r;
	}

	// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
	function simpleWrite(buf) {
	  return buf.toString(this.encoding);
	}

	function simpleEnd(buf) {
	  return buf && buf.length ? this.write(buf) : '';
	}
	return string_decoder$1;
}

var endOfStream$1;
var hasRequiredEndOfStream$1;

function requireEndOfStream$1 () {
	if (hasRequiredEndOfStream$1) return endOfStream$1;
	hasRequiredEndOfStream$1 = 1;

	var ERR_STREAM_PREMATURE_CLOSE = requireErrorsBrowser().codes.ERR_STREAM_PREMATURE_CLOSE;
	function once(callback) {
	  var called = false;
	  return function () {
	    if (called) return;
	    called = true;
	    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }
	    callback.apply(this, args);
	  };
	}
	function noop() {}
	function isRequest(stream) {
	  return stream.setHeader && typeof stream.abort === 'function';
	}
	function eos(stream, opts, callback) {
	  if (typeof opts === 'function') return eos(stream, null, opts);
	  if (!opts) opts = {};
	  callback = once(callback || noop);
	  var readable = opts.readable || opts.readable !== false && stream.readable;
	  var writable = opts.writable || opts.writable !== false && stream.writable;
	  var onlegacyfinish = function onlegacyfinish() {
	    if (!stream.writable) onfinish();
	  };
	  var writableEnded = stream._writableState && stream._writableState.finished;
	  var onfinish = function onfinish() {
	    writable = false;
	    writableEnded = true;
	    if (!readable) callback.call(stream);
	  };
	  var readableEnded = stream._readableState && stream._readableState.endEmitted;
	  var onend = function onend() {
	    readable = false;
	    readableEnded = true;
	    if (!writable) callback.call(stream);
	  };
	  var onerror = function onerror(err) {
	    callback.call(stream, err);
	  };
	  var onclose = function onclose() {
	    var err;
	    if (readable && !readableEnded) {
	      if (!stream._readableState || !stream._readableState.ended) err = new ERR_STREAM_PREMATURE_CLOSE();
	      return callback.call(stream, err);
	    }
	    if (writable && !writableEnded) {
	      if (!stream._writableState || !stream._writableState.ended) err = new ERR_STREAM_PREMATURE_CLOSE();
	      return callback.call(stream, err);
	    }
	  };
	  var onrequest = function onrequest() {
	    stream.req.on('finish', onfinish);
	  };
	  if (isRequest(stream)) {
	    stream.on('complete', onfinish);
	    stream.on('abort', onclose);
	    if (stream.req) onrequest();else stream.on('request', onrequest);
	  } else if (writable && !stream._writableState) {
	    // legacy streams
	    stream.on('end', onlegacyfinish);
	    stream.on('close', onlegacyfinish);
	  }
	  stream.on('end', onend);
	  stream.on('finish', onfinish);
	  if (opts.error !== false) stream.on('error', onerror);
	  stream.on('close', onclose);
	  return function () {
	    stream.removeListener('complete', onfinish);
	    stream.removeListener('abort', onclose);
	    stream.removeListener('request', onrequest);
	    if (stream.req) stream.req.removeListener('finish', onfinish);
	    stream.removeListener('end', onlegacyfinish);
	    stream.removeListener('close', onlegacyfinish);
	    stream.removeListener('finish', onfinish);
	    stream.removeListener('end', onend);
	    stream.removeListener('error', onerror);
	    stream.removeListener('close', onclose);
	  };
	}
	endOfStream$1 = eos;
	return endOfStream$1;
}

var async_iterator;
var hasRequiredAsync_iterator;

function requireAsync_iterator () {
	if (hasRequiredAsync_iterator) return async_iterator;
	hasRequiredAsync_iterator = 1;

	var _Object$setPrototypeO;
	function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
	function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
	function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
	var finished = requireEndOfStream$1();
	var kLastResolve = Symbol('lastResolve');
	var kLastReject = Symbol('lastReject');
	var kError = Symbol('error');
	var kEnded = Symbol('ended');
	var kLastPromise = Symbol('lastPromise');
	var kHandlePromise = Symbol('handlePromise');
	var kStream = Symbol('stream');
	function createIterResult(value, done) {
	  return {
	    value: value,
	    done: done
	  };
	}
	function readAndResolve(iter) {
	  var resolve = iter[kLastResolve];
	  if (resolve !== null) {
	    var data = iter[kStream].read();
	    // we defer if data is null
	    // we can be expecting either 'end' or
	    // 'error'
	    if (data !== null) {
	      iter[kLastPromise] = null;
	      iter[kLastResolve] = null;
	      iter[kLastReject] = null;
	      resolve(createIterResult(data, false));
	    }
	  }
	}
	function onReadable(iter) {
	  // we wait for the next tick, because it might
	  // emit an error with process.nextTick
	  process.nextTick(readAndResolve, iter);
	}
	function wrapForNext(lastPromise, iter) {
	  return function (resolve, reject) {
	    lastPromise.then(function () {
	      if (iter[kEnded]) {
	        resolve(createIterResult(undefined, true));
	        return;
	      }
	      iter[kHandlePromise](resolve, reject);
	    }, reject);
	  };
	}
	var AsyncIteratorPrototype = Object.getPrototypeOf(function () {});
	var ReadableStreamAsyncIteratorPrototype = Object.setPrototypeOf((_Object$setPrototypeO = {
	  get stream() {
	    return this[kStream];
	  },
	  next: function next() {
	    var _this = this;
	    // if we have detected an error in the meanwhile
	    // reject straight away
	    var error = this[kError];
	    if (error !== null) {
	      return Promise.reject(error);
	    }
	    if (this[kEnded]) {
	      return Promise.resolve(createIterResult(undefined, true));
	    }
	    if (this[kStream].destroyed) {
	      // We need to defer via nextTick because if .destroy(err) is
	      // called, the error will be emitted via nextTick, and
	      // we cannot guarantee that there is no error lingering around
	      // waiting to be emitted.
	      return new Promise(function (resolve, reject) {
	        process.nextTick(function () {
	          if (_this[kError]) {
	            reject(_this[kError]);
	          } else {
	            resolve(createIterResult(undefined, true));
	          }
	        });
	      });
	    }

	    // if we have multiple next() calls
	    // we will wait for the previous Promise to finish
	    // this logic is optimized to support for await loops,
	    // where next() is only called once at a time
	    var lastPromise = this[kLastPromise];
	    var promise;
	    if (lastPromise) {
	      promise = new Promise(wrapForNext(lastPromise, this));
	    } else {
	      // fast path needed to support multiple this.push()
	      // without triggering the next() queue
	      var data = this[kStream].read();
	      if (data !== null) {
	        return Promise.resolve(createIterResult(data, false));
	      }
	      promise = new Promise(this[kHandlePromise]);
	    }
	    this[kLastPromise] = promise;
	    return promise;
	  }
	}, _defineProperty(_Object$setPrototypeO, Symbol.asyncIterator, function () {
	  return this;
	}), _defineProperty(_Object$setPrototypeO, "return", function _return() {
	  var _this2 = this;
	  // destroy(err, cb) is a private API
	  // we can guarantee we have that here, because we control the
	  // Readable class this is attached to
	  return new Promise(function (resolve, reject) {
	    _this2[kStream].destroy(null, function (err) {
	      if (err) {
	        reject(err);
	        return;
	      }
	      resolve(createIterResult(undefined, true));
	    });
	  });
	}), _Object$setPrototypeO), AsyncIteratorPrototype);
	var createReadableStreamAsyncIterator = function createReadableStreamAsyncIterator(stream) {
	  var _Object$create;
	  var iterator = Object.create(ReadableStreamAsyncIteratorPrototype, (_Object$create = {}, _defineProperty(_Object$create, kStream, {
	    value: stream,
	    writable: true
	  }), _defineProperty(_Object$create, kLastResolve, {
	    value: null,
	    writable: true
	  }), _defineProperty(_Object$create, kLastReject, {
	    value: null,
	    writable: true
	  }), _defineProperty(_Object$create, kError, {
	    value: null,
	    writable: true
	  }), _defineProperty(_Object$create, kEnded, {
	    value: stream._readableState.endEmitted,
	    writable: true
	  }), _defineProperty(_Object$create, kHandlePromise, {
	    value: function value(resolve, reject) {
	      var data = iterator[kStream].read();
	      if (data) {
	        iterator[kLastPromise] = null;
	        iterator[kLastResolve] = null;
	        iterator[kLastReject] = null;
	        resolve(createIterResult(data, false));
	      } else {
	        iterator[kLastResolve] = resolve;
	        iterator[kLastReject] = reject;
	      }
	    },
	    writable: true
	  }), _Object$create));
	  iterator[kLastPromise] = null;
	  finished(stream, function (err) {
	    if (err && err.code !== 'ERR_STREAM_PREMATURE_CLOSE') {
	      var reject = iterator[kLastReject];
	      // reject if we are waiting for data in the Promise
	      // returned by next() and store the error
	      if (reject !== null) {
	        iterator[kLastPromise] = null;
	        iterator[kLastResolve] = null;
	        iterator[kLastReject] = null;
	        reject(err);
	      }
	      iterator[kError] = err;
	      return;
	    }
	    var resolve = iterator[kLastResolve];
	    if (resolve !== null) {
	      iterator[kLastPromise] = null;
	      iterator[kLastResolve] = null;
	      iterator[kLastReject] = null;
	      resolve(createIterResult(undefined, true));
	    }
	    iterator[kEnded] = true;
	  });
	  stream.on('readable', onReadable.bind(null, iterator));
	  return iterator;
	};
	async_iterator = createReadableStreamAsyncIterator;
	return async_iterator;
}

var fromBrowser;
var hasRequiredFromBrowser;

function requireFromBrowser () {
	if (hasRequiredFromBrowser) return fromBrowser;
	hasRequiredFromBrowser = 1;
	fromBrowser = function () {
	  throw new Error('Readable.from is not available in the browser')
	};
	return fromBrowser;
}

var _stream_readable$1;
var hasRequired_stream_readable$1;

function require_stream_readable$1 () {
	if (hasRequired_stream_readable$1) return _stream_readable$1;
	hasRequired_stream_readable$1 = 1;

	_stream_readable$1 = Readable;

	/*<replacement>*/
	var Duplex;
	/*</replacement>*/

	Readable.ReadableState = ReadableState;

	/*<replacement>*/
	require$$0$5.EventEmitter;
	var EElistenerCount = function EElistenerCount(emitter, type) {
	  return emitter.listeners(type).length;
	};
	/*</replacement>*/

	/*<replacement>*/
	var Stream = requireStreamBrowser$1();
	/*</replacement>*/

	var Buffer = require$$0$6.Buffer;
	var OurUint8Array = (typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}

	/*<replacement>*/
	var debugUtil = require$$0$4;
	var debug;
	if (debugUtil && debugUtil.debuglog) {
	  debug = debugUtil.debuglog('stream');
	} else {
	  debug = function debug() {};
	}
	/*</replacement>*/

	var BufferList = requireBuffer_list();
	var destroyImpl = requireDestroy$1();
	var _require = requireState(),
	  getHighWaterMark = _require.getHighWaterMark;
	var _require$codes = requireErrorsBrowser().codes,
	  ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
	  ERR_STREAM_PUSH_AFTER_EOF = _require$codes.ERR_STREAM_PUSH_AFTER_EOF,
	  ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED,
	  ERR_STREAM_UNSHIFT_AFTER_END_EVENT = _require$codes.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;

	// Lazy loaded to improve the startup performance.
	var StringDecoder;
	var createReadableStreamAsyncIterator;
	var from;
	requireInherits_browser()(Readable, Stream);
	var errorOrDestroy = destroyImpl.errorOrDestroy;
	var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];
	function prependListener(emitter, event, fn) {
	  // Sadly this is not cacheable as some libraries bundle their own
	  // event emitter implementation with them.
	  if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn);

	  // This is a hack to make sure that our error handler is attached before any
	  // userland ones.  NEVER DO THIS. This is here only because this code needs
	  // to continue to work with older versions of Node.js that do not include
	  // the prependListener() method. The goal is to eventually remove this hack.
	  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (Array.isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
	}
	function ReadableState(options, stream, isDuplex) {
	  Duplex = Duplex || require_stream_duplex$1();
	  options = options || {};

	  // Duplex streams are both readable and writable, but share
	  // the same options object.
	  // However, some cases require setting options to different
	  // values for the readable and the writable sides of the duplex stream.
	  // These options can be provided separately as readableXXX and writableXXX.
	  if (typeof isDuplex !== 'boolean') isDuplex = stream instanceof Duplex;

	  // object stream flag. Used to make read(n) ignore n and to
	  // make all the buffer merging and length checks go away
	  this.objectMode = !!options.objectMode;
	  if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

	  // the point at which it stops calling _read() to fill the buffer
	  // Note: 0 is a valid value, means "don't call _read preemptively ever"
	  this.highWaterMark = getHighWaterMark(this, options, 'readableHighWaterMark', isDuplex);

	  // A linked list is used to store data chunks instead of an array because the
	  // linked list can remove elements from the beginning faster than
	  // array.shift()
	  this.buffer = new BufferList();
	  this.length = 0;
	  this.pipes = null;
	  this.pipesCount = 0;
	  this.flowing = null;
	  this.ended = false;
	  this.endEmitted = false;
	  this.reading = false;

	  // a flag to be able to tell if the event 'readable'/'data' is emitted
	  // immediately, or on a later tick.  We set this to true at first, because
	  // any actions that shouldn't happen until "later" should generally also
	  // not happen before the first read call.
	  this.sync = true;

	  // whenever we return null, then we set a flag to say
	  // that we're awaiting a 'readable' event emission.
	  this.needReadable = false;
	  this.emittedReadable = false;
	  this.readableListening = false;
	  this.resumeScheduled = false;
	  this.paused = true;

	  // Should close be emitted on destroy. Defaults to true.
	  this.emitClose = options.emitClose !== false;

	  // Should .destroy() be called after 'end' (and potentially 'finish')
	  this.autoDestroy = !!options.autoDestroy;

	  // has it been destroyed
	  this.destroyed = false;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // the number of writers that are awaiting a drain event in .pipe()s
	  this.awaitDrain = 0;

	  // if true, a maybeReadMore has been scheduled
	  this.readingMore = false;
	  this.decoder = null;
	  this.encoding = null;
	  if (options.encoding) {
	    if (!StringDecoder) StringDecoder = requireString_decoder$1().StringDecoder;
	    this.decoder = new StringDecoder(options.encoding);
	    this.encoding = options.encoding;
	  }
	}
	function Readable(options) {
	  Duplex = Duplex || require_stream_duplex$1();
	  if (!(this instanceof Readable)) return new Readable(options);

	  // Checking for a Stream.Duplex instance is faster here instead of inside
	  // the ReadableState constructor, at least with V8 6.5
	  var isDuplex = this instanceof Duplex;
	  this._readableState = new ReadableState(options, this, isDuplex);

	  // legacy
	  this.readable = true;
	  if (options) {
	    if (typeof options.read === 'function') this._read = options.read;
	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	  }
	  Stream.call(this);
	}
	Object.defineProperty(Readable.prototype, 'destroyed', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    if (this._readableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed;
	  },
	  set: function set(value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._readableState) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	  }
	});
	Readable.prototype.destroy = destroyImpl.destroy;
	Readable.prototype._undestroy = destroyImpl.undestroy;
	Readable.prototype._destroy = function (err, cb) {
	  cb(err);
	};

	// Manually shove something into the read() buffer.
	// This returns true if the highWaterMark has not been hit yet,
	// similar to how Writable.write() returns true if you should
	// write() some more.
	Readable.prototype.push = function (chunk, encoding) {
	  var state = this._readableState;
	  var skipChunkCheck;
	  if (!state.objectMode) {
	    if (typeof chunk === 'string') {
	      encoding = encoding || state.defaultEncoding;
	      if (encoding !== state.encoding) {
	        chunk = Buffer.from(chunk, encoding);
	        encoding = '';
	      }
	      skipChunkCheck = true;
	    }
	  } else {
	    skipChunkCheck = true;
	  }
	  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
	};

	// Unshift should *always* be something directly out of read()
	Readable.prototype.unshift = function (chunk) {
	  return readableAddChunk(this, chunk, null, true, false);
	};
	function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
	  debug('readableAddChunk', chunk);
	  var state = stream._readableState;
	  if (chunk === null) {
	    state.reading = false;
	    onEofChunk(stream, state);
	  } else {
	    var er;
	    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
	    if (er) {
	      errorOrDestroy(stream, er);
	    } else if (state.objectMode || chunk && chunk.length > 0) {
	      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
	        chunk = _uint8ArrayToBuffer(chunk);
	      }
	      if (addToFront) {
	        if (state.endEmitted) errorOrDestroy(stream, new ERR_STREAM_UNSHIFT_AFTER_END_EVENT());else addChunk(stream, state, chunk, true);
	      } else if (state.ended) {
	        errorOrDestroy(stream, new ERR_STREAM_PUSH_AFTER_EOF());
	      } else if (state.destroyed) {
	        return false;
	      } else {
	        state.reading = false;
	        if (state.decoder && !encoding) {
	          chunk = state.decoder.write(chunk);
	          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
	        } else {
	          addChunk(stream, state, chunk, false);
	        }
	      }
	    } else if (!addToFront) {
	      state.reading = false;
	      maybeReadMore(stream, state);
	    }
	  }

	  // We can push more data if we are below the highWaterMark.
	  // Also, if we have no data yet, we can stand some more bytes.
	  // This is to work around cases where hwm=0, such as the repl.
	  return !state.ended && (state.length < state.highWaterMark || state.length === 0);
	}
	function addChunk(stream, state, chunk, addToFront) {
	  if (state.flowing && state.length === 0 && !state.sync) {
	    state.awaitDrain = 0;
	    stream.emit('data', chunk);
	  } else {
	    // update the buffer info.
	    state.length += state.objectMode ? 1 : chunk.length;
	    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);
	    if (state.needReadable) emitReadable(stream);
	  }
	  maybeReadMore(stream, state);
	}
	function chunkInvalid(state, chunk) {
	  var er;
	  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new ERR_INVALID_ARG_TYPE('chunk', ['string', 'Buffer', 'Uint8Array'], chunk);
	  }
	  return er;
	}
	Readable.prototype.isPaused = function () {
	  return this._readableState.flowing === false;
	};

	// backwards compatibility.
	Readable.prototype.setEncoding = function (enc) {
	  if (!StringDecoder) StringDecoder = requireString_decoder$1().StringDecoder;
	  var decoder = new StringDecoder(enc);
	  this._readableState.decoder = decoder;
	  // If setEncoding(null), decoder.encoding equals utf8
	  this._readableState.encoding = this._readableState.decoder.encoding;

	  // Iterate over current buffer to convert already stored Buffers:
	  var p = this._readableState.buffer.head;
	  var content = '';
	  while (p !== null) {
	    content += decoder.write(p.data);
	    p = p.next;
	  }
	  this._readableState.buffer.clear();
	  if (content !== '') this._readableState.buffer.push(content);
	  this._readableState.length = content.length;
	  return this;
	};

	// Don't raise the hwm > 1GB
	var MAX_HWM = 0x40000000;
	function computeNewHighWaterMark(n) {
	  if (n >= MAX_HWM) {
	    // TODO(ronag): Throw ERR_VALUE_OUT_OF_RANGE.
	    n = MAX_HWM;
	  } else {
	    // Get the next highest power of 2 to prevent increasing hwm excessively in
	    // tiny amounts
	    n--;
	    n |= n >>> 1;
	    n |= n >>> 2;
	    n |= n >>> 4;
	    n |= n >>> 8;
	    n |= n >>> 16;
	    n++;
	  }
	  return n;
	}

	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function howMuchToRead(n, state) {
	  if (n <= 0 || state.length === 0 && state.ended) return 0;
	  if (state.objectMode) return 1;
	  if (n !== n) {
	    // Only flow one buffer at a time
	    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
	  }
	  // If we're asking for more than the current hwm, then raise the hwm.
	  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
	  if (n <= state.length) return n;
	  // Don't have enough
	  if (!state.ended) {
	    state.needReadable = true;
	    return 0;
	  }
	  return state.length;
	}

	// you can override either this method, or the async _read(n) below.
	Readable.prototype.read = function (n) {
	  debug('read', n);
	  n = parseInt(n, 10);
	  var state = this._readableState;
	  var nOrig = n;
	  if (n !== 0) state.emittedReadable = false;

	  // if we're doing read(0) to trigger a readable event, but we
	  // already have a bunch of data in the buffer, then just trigger
	  // the 'readable' event and move on.
	  if (n === 0 && state.needReadable && ((state.highWaterMark !== 0 ? state.length >= state.highWaterMark : state.length > 0) || state.ended)) {
	    debug('read: emitReadable', state.length, state.ended);
	    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
	    return null;
	  }
	  n = howMuchToRead(n, state);

	  // if we've ended, and we're now clear, then finish it up.
	  if (n === 0 && state.ended) {
	    if (state.length === 0) endReadable(this);
	    return null;
	  }

	  // All the actual chunk generation logic needs to be
	  // *below* the call to _read.  The reason is that in certain
	  // synthetic stream cases, such as passthrough streams, _read
	  // may be a completely synchronous operation which may change
	  // the state of the read buffer, providing enough data when
	  // before there was *not* enough.
	  //
	  // So, the steps are:
	  // 1. Figure out what the state of things will be after we do
	  // a read from the buffer.
	  //
	  // 2. If that resulting state will trigger a _read, then call _read.
	  // Note that this may be asynchronous, or synchronous.  Yes, it is
	  // deeply ugly to write APIs this way, but that still doesn't mean
	  // that the Readable class should behave improperly, as streams are
	  // designed to be sync/async agnostic.
	  // Take note if the _read call is sync or async (ie, if the read call
	  // has returned yet), so that we know whether or not it's safe to emit
	  // 'readable' etc.
	  //
	  // 3. Actually pull the requested chunks out of the buffer and return.

	  // if we need a readable event, then we need to do some reading.
	  var doRead = state.needReadable;
	  debug('need readable', doRead);

	  // if we currently have less than the highWaterMark, then also read some
	  if (state.length === 0 || state.length - n < state.highWaterMark) {
	    doRead = true;
	    debug('length less than watermark', doRead);
	  }

	  // however, if we've ended, then there's no point, and if we're already
	  // reading, then it's unnecessary.
	  if (state.ended || state.reading) {
	    doRead = false;
	    debug('reading or ended', doRead);
	  } else if (doRead) {
	    debug('do read');
	    state.reading = true;
	    state.sync = true;
	    // if the length is currently zero, then we *need* a readable event.
	    if (state.length === 0) state.needReadable = true;
	    // call internal read method
	    this._read(state.highWaterMark);
	    state.sync = false;
	    // If _read pushed data synchronously, then `reading` will be false,
	    // and we need to re-evaluate how much data we can return to the user.
	    if (!state.reading) n = howMuchToRead(nOrig, state);
	  }
	  var ret;
	  if (n > 0) ret = fromList(n, state);else ret = null;
	  if (ret === null) {
	    state.needReadable = state.length <= state.highWaterMark;
	    n = 0;
	  } else {
	    state.length -= n;
	    state.awaitDrain = 0;
	  }
	  if (state.length === 0) {
	    // If we have nothing in the buffer, then we want to know
	    // as soon as we *do* get something into the buffer.
	    if (!state.ended) state.needReadable = true;

	    // If we tried to read() past the EOF, then emit end on the next tick.
	    if (nOrig !== n && state.ended) endReadable(this);
	  }
	  if (ret !== null) this.emit('data', ret);
	  return ret;
	};
	function onEofChunk(stream, state) {
	  debug('onEofChunk');
	  if (state.ended) return;
	  if (state.decoder) {
	    var chunk = state.decoder.end();
	    if (chunk && chunk.length) {
	      state.buffer.push(chunk);
	      state.length += state.objectMode ? 1 : chunk.length;
	    }
	  }
	  state.ended = true;
	  if (state.sync) {
	    // if we are sync, wait until next tick to emit the data.
	    // Otherwise we risk emitting data in the flow()
	    // the readable code triggers during a read() call
	    emitReadable(stream);
	  } else {
	    // emit 'readable' now to make sure it gets picked up.
	    state.needReadable = false;
	    if (!state.emittedReadable) {
	      state.emittedReadable = true;
	      emitReadable_(stream);
	    }
	  }
	}

	// Don't emit readable right away in sync mode, because this can trigger
	// another read() call => stack overflow.  This way, it might trigger
	// a nextTick recursion warning, but that's not so bad.
	function emitReadable(stream) {
	  var state = stream._readableState;
	  debug('emitReadable', state.needReadable, state.emittedReadable);
	  state.needReadable = false;
	  if (!state.emittedReadable) {
	    debug('emitReadable', state.flowing);
	    state.emittedReadable = true;
	    process.nextTick(emitReadable_, stream);
	  }
	}
	function emitReadable_(stream) {
	  var state = stream._readableState;
	  debug('emitReadable_', state.destroyed, state.length, state.ended);
	  if (!state.destroyed && (state.length || state.ended)) {
	    stream.emit('readable');
	    state.emittedReadable = false;
	  }

	  // The stream needs another readable event if
	  // 1. It is not flowing, as the flow mechanism will take
	  //    care of it.
	  // 2. It is not ended.
	  // 3. It is below the highWaterMark, so we can schedule
	  //    another readable later.
	  state.needReadable = !state.flowing && !state.ended && state.length <= state.highWaterMark;
	  flow(stream);
	}

	// at this point, the user has presumably seen the 'readable' event,
	// and called read() to consume some data.  that may have triggered
	// in turn another _read(n) call, in which case reading = true if
	// it's in progress.
	// However, if we're not ended, or reading, and the length < hwm,
	// then go ahead and try to read some more preemptively.
	function maybeReadMore(stream, state) {
	  if (!state.readingMore) {
	    state.readingMore = true;
	    process.nextTick(maybeReadMore_, stream, state);
	  }
	}
	function maybeReadMore_(stream, state) {
	  // Attempt to read more data if we should.
	  //
	  // The conditions for reading more data are (one of):
	  // - Not enough data buffered (state.length < state.highWaterMark). The loop
	  //   is responsible for filling the buffer with enough data if such data
	  //   is available. If highWaterMark is 0 and we are not in the flowing mode
	  //   we should _not_ attempt to buffer any extra data. We'll get more data
	  //   when the stream consumer calls read() instead.
	  // - No data in the buffer, and the stream is in flowing mode. In this mode
	  //   the loop below is responsible for ensuring read() is called. Failing to
	  //   call read here would abort the flow and there's no other mechanism for
	  //   continuing the flow if the stream consumer has just subscribed to the
	  //   'data' event.
	  //
	  // In addition to the above conditions to keep reading data, the following
	  // conditions prevent the data from being read:
	  // - The stream has ended (state.ended).
	  // - There is already a pending 'read' operation (state.reading). This is a
	  //   case where the the stream has called the implementation defined _read()
	  //   method, but they are processing the call asynchronously and have _not_
	  //   called push() with new data. In this case we skip performing more
	  //   read()s. The execution ends in this method again after the _read() ends
	  //   up calling push() with more data.
	  while (!state.reading && !state.ended && (state.length < state.highWaterMark || state.flowing && state.length === 0)) {
	    var len = state.length;
	    debug('maybeReadMore read 0');
	    stream.read(0);
	    if (len === state.length)
	      // didn't get any data, stop spinning.
	      break;
	  }
	  state.readingMore = false;
	}

	// abstract method.  to be overridden in specific implementation classes.
	// call cb(er, data) where data is <= n in length.
	// for virtual (non-string, non-buffer) streams, "length" is somewhat
	// arbitrary, and perhaps not very meaningful.
	Readable.prototype._read = function (n) {
	  errorOrDestroy(this, new ERR_METHOD_NOT_IMPLEMENTED('_read()'));
	};
	Readable.prototype.pipe = function (dest, pipeOpts) {
	  var src = this;
	  var state = this._readableState;
	  switch (state.pipesCount) {
	    case 0:
	      state.pipes = dest;
	      break;
	    case 1:
	      state.pipes = [state.pipes, dest];
	      break;
	    default:
	      state.pipes.push(dest);
	      break;
	  }
	  state.pipesCount += 1;
	  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);
	  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
	  var endFn = doEnd ? onend : unpipe;
	  if (state.endEmitted) process.nextTick(endFn);else src.once('end', endFn);
	  dest.on('unpipe', onunpipe);
	  function onunpipe(readable, unpipeInfo) {
	    debug('onunpipe');
	    if (readable === src) {
	      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
	        unpipeInfo.hasUnpiped = true;
	        cleanup();
	      }
	    }
	  }
	  function onend() {
	    debug('onend');
	    dest.end();
	  }

	  // when the dest drains, it reduces the awaitDrain counter
	  // on the source.  This would be more elegant with a .once()
	  // handler in flow(), but adding and removing repeatedly is
	  // too slow.
	  var ondrain = pipeOnDrain(src);
	  dest.on('drain', ondrain);
	  var cleanedUp = false;
	  function cleanup() {
	    debug('cleanup');
	    // cleanup event handlers once the pipe is broken
	    dest.removeListener('close', onclose);
	    dest.removeListener('finish', onfinish);
	    dest.removeListener('drain', ondrain);
	    dest.removeListener('error', onerror);
	    dest.removeListener('unpipe', onunpipe);
	    src.removeListener('end', onend);
	    src.removeListener('end', unpipe);
	    src.removeListener('data', ondata);
	    cleanedUp = true;

	    // if the reader is waiting for a drain event from this
	    // specific writer, then it would cause it to never start
	    // flowing again.
	    // So, if this is awaiting a drain, then we just call it now.
	    // If we don't know, then assume that we are waiting for one.
	    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
	  }
	  src.on('data', ondata);
	  function ondata(chunk) {
	    debug('ondata');
	    var ret = dest.write(chunk);
	    debug('dest.write', ret);
	    if (ret === false) {
	      // If the user unpiped during `dest.write()`, it is possible
	      // to get stuck in a permanently paused state if that write
	      // also returned false.
	      // => Check whether `dest` is still a piping destination.
	      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
	        debug('false write response, pause', state.awaitDrain);
	        state.awaitDrain++;
	      }
	      src.pause();
	    }
	  }

	  // if the dest has an error, then stop piping into it.
	  // however, don't suppress the throwing behavior for this.
	  function onerror(er) {
	    debug('onerror', er);
	    unpipe();
	    dest.removeListener('error', onerror);
	    if (EElistenerCount(dest, 'error') === 0) errorOrDestroy(dest, er);
	  }

	  // Make sure our error handler is attached before userland ones.
	  prependListener(dest, 'error', onerror);

	  // Both close and finish should trigger unpipe, but only once.
	  function onclose() {
	    dest.removeListener('finish', onfinish);
	    unpipe();
	  }
	  dest.once('close', onclose);
	  function onfinish() {
	    debug('onfinish');
	    dest.removeListener('close', onclose);
	    unpipe();
	  }
	  dest.once('finish', onfinish);
	  function unpipe() {
	    debug('unpipe');
	    src.unpipe(dest);
	  }

	  // tell the dest that it's being piped to
	  dest.emit('pipe', src);

	  // start the flow if it hasn't been started already.
	  if (!state.flowing) {
	    debug('pipe resume');
	    src.resume();
	  }
	  return dest;
	};
	function pipeOnDrain(src) {
	  return function pipeOnDrainFunctionResult() {
	    var state = src._readableState;
	    debug('pipeOnDrain', state.awaitDrain);
	    if (state.awaitDrain) state.awaitDrain--;
	    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
	      state.flowing = true;
	      flow(src);
	    }
	  };
	}
	Readable.prototype.unpipe = function (dest) {
	  var state = this._readableState;
	  var unpipeInfo = {
	    hasUnpiped: false
	  };

	  // if we're not piping anywhere, then do nothing.
	  if (state.pipesCount === 0) return this;

	  // just one destination.  most common case.
	  if (state.pipesCount === 1) {
	    // passed in one, but it's not the right one.
	    if (dest && dest !== state.pipes) return this;
	    if (!dest) dest = state.pipes;

	    // got a match.
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	    if (dest) dest.emit('unpipe', this, unpipeInfo);
	    return this;
	  }

	  // slow case. multiple pipe destinations.

	  if (!dest) {
	    // remove all.
	    var dests = state.pipes;
	    var len = state.pipesCount;
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	    for (var i = 0; i < len; i++) dests[i].emit('unpipe', this, {
	      hasUnpiped: false
	    });
	    return this;
	  }

	  // try to find the right one.
	  var index = indexOf(state.pipes, dest);
	  if (index === -1) return this;
	  state.pipes.splice(index, 1);
	  state.pipesCount -= 1;
	  if (state.pipesCount === 1) state.pipes = state.pipes[0];
	  dest.emit('unpipe', this, unpipeInfo);
	  return this;
	};

	// set up data events if they are asked for
	// Ensure readable listeners eventually get something
	Readable.prototype.on = function (ev, fn) {
	  var res = Stream.prototype.on.call(this, ev, fn);
	  var state = this._readableState;
	  if (ev === 'data') {
	    // update readableListening so that resume() may be a no-op
	    // a few lines down. This is needed to support once('readable').
	    state.readableListening = this.listenerCount('readable') > 0;

	    // Try start flowing on next tick if stream isn't explicitly paused
	    if (state.flowing !== false) this.resume();
	  } else if (ev === 'readable') {
	    if (!state.endEmitted && !state.readableListening) {
	      state.readableListening = state.needReadable = true;
	      state.flowing = false;
	      state.emittedReadable = false;
	      debug('on readable', state.length, state.reading);
	      if (state.length) {
	        emitReadable(this);
	      } else if (!state.reading) {
	        process.nextTick(nReadingNextTick, this);
	      }
	    }
	  }
	  return res;
	};
	Readable.prototype.addListener = Readable.prototype.on;
	Readable.prototype.removeListener = function (ev, fn) {
	  var res = Stream.prototype.removeListener.call(this, ev, fn);
	  if (ev === 'readable') {
	    // We need to check if there is someone still listening to
	    // readable and reset the state. However this needs to happen
	    // after readable has been emitted but before I/O (nextTick) to
	    // support once('readable', fn) cycles. This means that calling
	    // resume within the same tick will have no
	    // effect.
	    process.nextTick(updateReadableListening, this);
	  }
	  return res;
	};
	Readable.prototype.removeAllListeners = function (ev) {
	  var res = Stream.prototype.removeAllListeners.apply(this, arguments);
	  if (ev === 'readable' || ev === undefined) {
	    // We need to check if there is someone still listening to
	    // readable and reset the state. However this needs to happen
	    // after readable has been emitted but before I/O (nextTick) to
	    // support once('readable', fn) cycles. This means that calling
	    // resume within the same tick will have no
	    // effect.
	    process.nextTick(updateReadableListening, this);
	  }
	  return res;
	};
	function updateReadableListening(self) {
	  var state = self._readableState;
	  state.readableListening = self.listenerCount('readable') > 0;
	  if (state.resumeScheduled && !state.paused) {
	    // flowing needs to be set to true now, otherwise
	    // the upcoming resume will not flow.
	    state.flowing = true;

	    // crude way to check if we should resume
	  } else if (self.listenerCount('data') > 0) {
	    self.resume();
	  }
	}
	function nReadingNextTick(self) {
	  debug('readable nexttick read 0');
	  self.read(0);
	}

	// pause() and resume() are remnants of the legacy readable stream API
	// If the user uses them, then switch into old mode.
	Readable.prototype.resume = function () {
	  var state = this._readableState;
	  if (!state.flowing) {
	    debug('resume');
	    // we flow only if there is no one listening
	    // for readable, but we still have to call
	    // resume()
	    state.flowing = !state.readableListening;
	    resume(this, state);
	  }
	  state.paused = false;
	  return this;
	};
	function resume(stream, state) {
	  if (!state.resumeScheduled) {
	    state.resumeScheduled = true;
	    process.nextTick(resume_, stream, state);
	  }
	}
	function resume_(stream, state) {
	  debug('resume', state.reading);
	  if (!state.reading) {
	    stream.read(0);
	  }
	  state.resumeScheduled = false;
	  stream.emit('resume');
	  flow(stream);
	  if (state.flowing && !state.reading) stream.read(0);
	}
	Readable.prototype.pause = function () {
	  debug('call pause flowing=%j', this._readableState.flowing);
	  if (this._readableState.flowing !== false) {
	    debug('pause');
	    this._readableState.flowing = false;
	    this.emit('pause');
	  }
	  this._readableState.paused = true;
	  return this;
	};
	function flow(stream) {
	  var state = stream._readableState;
	  debug('flow', state.flowing);
	  while (state.flowing && stream.read() !== null);
	}

	// wrap an old-style stream as the async data source.
	// This is *not* part of the readable stream interface.
	// It is an ugly unfortunate mess of history.
	Readable.prototype.wrap = function (stream) {
	  var _this = this;
	  var state = this._readableState;
	  var paused = false;
	  stream.on('end', function () {
	    debug('wrapped end');
	    if (state.decoder && !state.ended) {
	      var chunk = state.decoder.end();
	      if (chunk && chunk.length) _this.push(chunk);
	    }
	    _this.push(null);
	  });
	  stream.on('data', function (chunk) {
	    debug('wrapped data');
	    if (state.decoder) chunk = state.decoder.write(chunk);

	    // don't skip over falsy values in objectMode
	    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;
	    var ret = _this.push(chunk);
	    if (!ret) {
	      paused = true;
	      stream.pause();
	    }
	  });

	  // proxy all the other methods.
	  // important when wrapping filters and duplexes.
	  for (var i in stream) {
	    if (this[i] === undefined && typeof stream[i] === 'function') {
	      this[i] = function methodWrap(method) {
	        return function methodWrapReturnFunction() {
	          return stream[method].apply(stream, arguments);
	        };
	      }(i);
	    }
	  }

	  // proxy certain important events.
	  for (var n = 0; n < kProxyEvents.length; n++) {
	    stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
	  }

	  // when we try to consume some more bytes, simply unpause the
	  // underlying stream.
	  this._read = function (n) {
	    debug('wrapped _read', n);
	    if (paused) {
	      paused = false;
	      stream.resume();
	    }
	  };
	  return this;
	};
	if (typeof Symbol === 'function') {
	  Readable.prototype[Symbol.asyncIterator] = function () {
	    if (createReadableStreamAsyncIterator === undefined) {
	      createReadableStreamAsyncIterator = requireAsync_iterator();
	    }
	    return createReadableStreamAsyncIterator(this);
	  };
	}
	Object.defineProperty(Readable.prototype, 'readableHighWaterMark', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._readableState.highWaterMark;
	  }
	});
	Object.defineProperty(Readable.prototype, 'readableBuffer', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._readableState && this._readableState.buffer;
	  }
	});
	Object.defineProperty(Readable.prototype, 'readableFlowing', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._readableState.flowing;
	  },
	  set: function set(state) {
	    if (this._readableState) {
	      this._readableState.flowing = state;
	    }
	  }
	});

	// exposed for testing purposes only.
	Readable._fromList = fromList;
	Object.defineProperty(Readable.prototype, 'readableLength', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._readableState.length;
	  }
	});

	// Pluck off n bytes from an array of buffers.
	// Length is the combined lengths of all the buffers in the list.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromList(n, state) {
	  // nothing buffered
	  if (state.length === 0) return null;
	  var ret;
	  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
	    // read it all, truncate the list
	    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.first();else ret = state.buffer.concat(state.length);
	    state.buffer.clear();
	  } else {
	    // read part of list
	    ret = state.buffer.consume(n, state.decoder);
	  }
	  return ret;
	}
	function endReadable(stream) {
	  var state = stream._readableState;
	  debug('endReadable', state.endEmitted);
	  if (!state.endEmitted) {
	    state.ended = true;
	    process.nextTick(endReadableNT, state, stream);
	  }
	}
	function endReadableNT(state, stream) {
	  debug('endReadableNT', state.endEmitted, state.length);

	  // Check that we didn't get one last unshift.
	  if (!state.endEmitted && state.length === 0) {
	    state.endEmitted = true;
	    stream.readable = false;
	    stream.emit('end');
	    if (state.autoDestroy) {
	      // In case of duplex streams we need a way to detect
	      // if the writable side is ready for autoDestroy as well
	      var wState = stream._writableState;
	      if (!wState || wState.autoDestroy && wState.finished) {
	        stream.destroy();
	      }
	    }
	  }
	}
	if (typeof Symbol === 'function') {
	  Readable.from = function (iterable, opts) {
	    if (from === undefined) {
	      from = requireFromBrowser();
	    }
	    return from(Readable, iterable, opts);
	  };
	}
	function indexOf(xs, x) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    if (xs[i] === x) return i;
	  }
	  return -1;
	}
	return _stream_readable$1;
}

var _stream_duplex$1;
var hasRequired_stream_duplex$1;

function require_stream_duplex$1 () {
	if (hasRequired_stream_duplex$1) return _stream_duplex$1;
	hasRequired_stream_duplex$1 = 1;

	/*<replacement>*/
	var objectKeys = Object.keys || function (obj) {
	  var keys = [];
	  for (var key in obj) keys.push(key);
	  return keys;
	};
	/*</replacement>*/

	_stream_duplex$1 = Duplex;
	var Readable = require_stream_readable$1();
	var Writable = require_stream_writable$1();
	requireInherits_browser()(Duplex, Readable);
	{
	  // Allow the keys array to be GC'ed.
	  var keys = objectKeys(Writable.prototype);
	  for (var v = 0; v < keys.length; v++) {
	    var method = keys[v];
	    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
	  }
	}
	function Duplex(options) {
	  if (!(this instanceof Duplex)) return new Duplex(options);
	  Readable.call(this, options);
	  Writable.call(this, options);
	  this.allowHalfOpen = true;
	  if (options) {
	    if (options.readable === false) this.readable = false;
	    if (options.writable === false) this.writable = false;
	    if (options.allowHalfOpen === false) {
	      this.allowHalfOpen = false;
	      this.once('end', onend);
	    }
	  }
	}
	Object.defineProperty(Duplex.prototype, 'writableHighWaterMark', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._writableState.highWaterMark;
	  }
	});
	Object.defineProperty(Duplex.prototype, 'writableBuffer', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._writableState && this._writableState.getBuffer();
	  }
	});
	Object.defineProperty(Duplex.prototype, 'writableLength', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._writableState.length;
	  }
	});

	// the no-half-open enforcer
	function onend() {
	  // If the writable side ended, then we're ok.
	  if (this._writableState.ended) return;

	  // no more data can be written.
	  // But allow more writes to happen in this tick.
	  process.nextTick(onEndNT, this);
	}
	function onEndNT(self) {
	  self.end();
	}
	Object.defineProperty(Duplex.prototype, 'destroyed', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed && this._writableState.destroyed;
	  },
	  set: function set(value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	    this._writableState.destroyed = value;
	  }
	});
	return _stream_duplex$1;
}

var _stream_writable$1;
var hasRequired_stream_writable$1;

function require_stream_writable$1 () {
	if (hasRequired_stream_writable$1) return _stream_writable$1;
	hasRequired_stream_writable$1 = 1;

	_stream_writable$1 = Writable;

	// It seems a linked list but it is not
	// there will be only 2 of these for each stream
	function CorkedRequest(state) {
	  var _this = this;
	  this.next = null;
	  this.entry = null;
	  this.finish = function () {
	    onCorkedFinish(_this, state);
	  };
	}
	/* </replacement> */

	/*<replacement>*/
	var Duplex;
	/*</replacement>*/

	Writable.WritableState = WritableState;

	/*<replacement>*/
	var internalUtil = {
	  deprecate: requireBrowser$3()
	};
	/*</replacement>*/

	/*<replacement>*/
	var Stream = requireStreamBrowser$1();
	/*</replacement>*/

	var Buffer = require$$0$6.Buffer;
	var OurUint8Array = (typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}
	var destroyImpl = requireDestroy$1();
	var _require = requireState(),
	  getHighWaterMark = _require.getHighWaterMark;
	var _require$codes = requireErrorsBrowser().codes,
	  ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
	  ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED,
	  ERR_MULTIPLE_CALLBACK = _require$codes.ERR_MULTIPLE_CALLBACK,
	  ERR_STREAM_CANNOT_PIPE = _require$codes.ERR_STREAM_CANNOT_PIPE,
	  ERR_STREAM_DESTROYED = _require$codes.ERR_STREAM_DESTROYED,
	  ERR_STREAM_NULL_VALUES = _require$codes.ERR_STREAM_NULL_VALUES,
	  ERR_STREAM_WRITE_AFTER_END = _require$codes.ERR_STREAM_WRITE_AFTER_END,
	  ERR_UNKNOWN_ENCODING = _require$codes.ERR_UNKNOWN_ENCODING;
	var errorOrDestroy = destroyImpl.errorOrDestroy;
	requireInherits_browser()(Writable, Stream);
	function nop() {}
	function WritableState(options, stream, isDuplex) {
	  Duplex = Duplex || require_stream_duplex$1();
	  options = options || {};

	  // Duplex streams are both readable and writable, but share
	  // the same options object.
	  // However, some cases require setting options to different
	  // values for the readable and the writable sides of the duplex stream,
	  // e.g. options.readableObjectMode vs. options.writableObjectMode, etc.
	  if (typeof isDuplex !== 'boolean') isDuplex = stream instanceof Duplex;

	  // object stream flag to indicate whether or not this stream
	  // contains buffers or objects.
	  this.objectMode = !!options.objectMode;
	  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

	  // the point at which write() starts returning false
	  // Note: 0 is a valid value, means that we always return false if
	  // the entire buffer is not flushed immediately on write()
	  this.highWaterMark = getHighWaterMark(this, options, 'writableHighWaterMark', isDuplex);

	  // if _final has been called
	  this.finalCalled = false;

	  // drain event flag.
	  this.needDrain = false;
	  // at the start of calling end()
	  this.ending = false;
	  // when end() has been called, and returned
	  this.ended = false;
	  // when 'finish' is emitted
	  this.finished = false;

	  // has it been destroyed
	  this.destroyed = false;

	  // should we decode strings into buffers before passing to _write?
	  // this is here so that some node-core streams can optimize string
	  // handling at a lower level.
	  var noDecode = options.decodeStrings === false;
	  this.decodeStrings = !noDecode;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // not an actual buffer we keep track of, but a measurement
	  // of how much we're waiting to get pushed to some underlying
	  // socket or file.
	  this.length = 0;

	  // a flag to see when we're in the middle of a write.
	  this.writing = false;

	  // when true all writes will be buffered until .uncork() call
	  this.corked = 0;

	  // a flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;

	  // a flag to know if we're processing previously buffered items, which
	  // may call the _write() callback in the same tick, so that we don't
	  // end up in an overlapped onwrite situation.
	  this.bufferProcessing = false;

	  // the callback that's passed to _write(chunk,cb)
	  this.onwrite = function (er) {
	    onwrite(stream, er);
	  };

	  // the callback that the user supplies to write(chunk,encoding,cb)
	  this.writecb = null;

	  // the amount that is being written when _write is called.
	  this.writelen = 0;
	  this.bufferedRequest = null;
	  this.lastBufferedRequest = null;

	  // number of pending user-supplied write callbacks
	  // this must be 0 before 'finish' can be emitted
	  this.pendingcb = 0;

	  // emit prefinish if the only thing we're waiting for is _write cbs
	  // This is relevant for synchronous Transform streams
	  this.prefinished = false;

	  // True if the error was already emitted and should not be thrown again
	  this.errorEmitted = false;

	  // Should close be emitted on destroy. Defaults to true.
	  this.emitClose = options.emitClose !== false;

	  // Should .destroy() be called after 'finish' (and potentially 'end')
	  this.autoDestroy = !!options.autoDestroy;

	  // count buffered requests
	  this.bufferedRequestCount = 0;

	  // allocate the first CorkedRequest, there is always
	  // one allocated and free to use, and we maintain at most two
	  this.corkedRequestsFree = new CorkedRequest(this);
	}
	WritableState.prototype.getBuffer = function getBuffer() {
	  var current = this.bufferedRequest;
	  var out = [];
	  while (current) {
	    out.push(current);
	    current = current.next;
	  }
	  return out;
	};
	(function () {
	  try {
	    Object.defineProperty(WritableState.prototype, 'buffer', {
	      get: internalUtil.deprecate(function writableStateBufferGetter() {
	        return this.getBuffer();
	      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
	    });
	  } catch (_) {}
	})();

	// Test _writableState for inheritance to account for Duplex streams,
	// whose prototype chain only points to Readable.
	var realHasInstance;
	if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
	  realHasInstance = Function.prototype[Symbol.hasInstance];
	  Object.defineProperty(Writable, Symbol.hasInstance, {
	    value: function value(object) {
	      if (realHasInstance.call(this, object)) return true;
	      if (this !== Writable) return false;
	      return object && object._writableState instanceof WritableState;
	    }
	  });
	} else {
	  realHasInstance = function realHasInstance(object) {
	    return object instanceof this;
	  };
	}
	function Writable(options) {
	  Duplex = Duplex || require_stream_duplex$1();

	  // Writable ctor is applied to Duplexes, too.
	  // `realHasInstance` is necessary because using plain `instanceof`
	  // would return false, as no `_writableState` property is attached.

	  // Trying to use the custom `instanceof` for Writable here will also break the
	  // Node.js LazyTransform implementation, which has a non-trivial getter for
	  // `_writableState` that would lead to infinite recursion.

	  // Checking for a Stream.Duplex instance is faster here instead of inside
	  // the WritableState constructor, at least with V8 6.5
	  var isDuplex = this instanceof Duplex;
	  if (!isDuplex && !realHasInstance.call(Writable, this)) return new Writable(options);
	  this._writableState = new WritableState(options, this, isDuplex);

	  // legacy.
	  this.writable = true;
	  if (options) {
	    if (typeof options.write === 'function') this._write = options.write;
	    if (typeof options.writev === 'function') this._writev = options.writev;
	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	    if (typeof options.final === 'function') this._final = options.final;
	  }
	  Stream.call(this);
	}

	// Otherwise people can pipe Writable streams, which is just wrong.
	Writable.prototype.pipe = function () {
	  errorOrDestroy(this, new ERR_STREAM_CANNOT_PIPE());
	};
	function writeAfterEnd(stream, cb) {
	  var er = new ERR_STREAM_WRITE_AFTER_END();
	  // TODO: defer error events consistently everywhere, not just the cb
	  errorOrDestroy(stream, er);
	  process.nextTick(cb, er);
	}

	// Checks that a user-supplied chunk is valid, especially for the particular
	// mode the stream is in. Currently this means that `null` is never accepted
	// and undefined/non-string values are only allowed in object mode.
	function validChunk(stream, state, chunk, cb) {
	  var er;
	  if (chunk === null) {
	    er = new ERR_STREAM_NULL_VALUES();
	  } else if (typeof chunk !== 'string' && !state.objectMode) {
	    er = new ERR_INVALID_ARG_TYPE('chunk', ['string', 'Buffer'], chunk);
	  }
	  if (er) {
	    errorOrDestroy(stream, er);
	    process.nextTick(cb, er);
	    return false;
	  }
	  return true;
	}
	Writable.prototype.write = function (chunk, encoding, cb) {
	  var state = this._writableState;
	  var ret = false;
	  var isBuf = !state.objectMode && _isUint8Array(chunk);
	  if (isBuf && !Buffer.isBuffer(chunk)) {
	    chunk = _uint8ArrayToBuffer(chunk);
	  }
	  if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }
	  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;
	  if (typeof cb !== 'function') cb = nop;
	  if (state.ending) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
	    state.pendingcb++;
	    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
	  }
	  return ret;
	};
	Writable.prototype.cork = function () {
	  this._writableState.corked++;
	};
	Writable.prototype.uncork = function () {
	  var state = this._writableState;
	  if (state.corked) {
	    state.corked--;
	    if (!state.writing && !state.corked && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
	  }
	};
	Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
	  // node::ParseEncoding() requires lower case.
	  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
	  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new ERR_UNKNOWN_ENCODING(encoding);
	  this._writableState.defaultEncoding = encoding;
	  return this;
	};
	Object.defineProperty(Writable.prototype, 'writableBuffer', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._writableState && this._writableState.getBuffer();
	  }
	});
	function decodeChunk(state, chunk, encoding) {
	  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
	    chunk = Buffer.from(chunk, encoding);
	  }
	  return chunk;
	}
	Object.defineProperty(Writable.prototype, 'writableHighWaterMark', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._writableState.highWaterMark;
	  }
	});

	// if we're already writing something, then just put this
	// in the queue, and wait our turn.  Otherwise, call _write
	// If we return false, then we need a drain event, so set that flag.
	function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
	  if (!isBuf) {
	    var newChunk = decodeChunk(state, chunk, encoding);
	    if (chunk !== newChunk) {
	      isBuf = true;
	      encoding = 'buffer';
	      chunk = newChunk;
	    }
	  }
	  var len = state.objectMode ? 1 : chunk.length;
	  state.length += len;
	  var ret = state.length < state.highWaterMark;
	  // we must ensure that previous needDrain will not be reset to false.
	  if (!ret) state.needDrain = true;
	  if (state.writing || state.corked) {
	    var last = state.lastBufferedRequest;
	    state.lastBufferedRequest = {
	      chunk: chunk,
	      encoding: encoding,
	      isBuf: isBuf,
	      callback: cb,
	      next: null
	    };
	    if (last) {
	      last.next = state.lastBufferedRequest;
	    } else {
	      state.bufferedRequest = state.lastBufferedRequest;
	    }
	    state.bufferedRequestCount += 1;
	  } else {
	    doWrite(stream, state, false, len, chunk, encoding, cb);
	  }
	  return ret;
	}
	function doWrite(stream, state, writev, len, chunk, encoding, cb) {
	  state.writelen = len;
	  state.writecb = cb;
	  state.writing = true;
	  state.sync = true;
	  if (state.destroyed) state.onwrite(new ERR_STREAM_DESTROYED('write'));else if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
	  state.sync = false;
	}
	function onwriteError(stream, state, sync, er, cb) {
	  --state.pendingcb;
	  if (sync) {
	    // defer the callback if we are being called synchronously
	    // to avoid piling up things on the stack
	    process.nextTick(cb, er);
	    // this can emit finish, and it will always happen
	    // after error
	    process.nextTick(finishMaybe, stream, state);
	    stream._writableState.errorEmitted = true;
	    errorOrDestroy(stream, er);
	  } else {
	    // the caller expect this to happen before if
	    // it is async
	    cb(er);
	    stream._writableState.errorEmitted = true;
	    errorOrDestroy(stream, er);
	    // this can emit finish, but finish must
	    // always follow error
	    finishMaybe(stream, state);
	  }
	}
	function onwriteStateUpdate(state) {
	  state.writing = false;
	  state.writecb = null;
	  state.length -= state.writelen;
	  state.writelen = 0;
	}
	function onwrite(stream, er) {
	  var state = stream._writableState;
	  var sync = state.sync;
	  var cb = state.writecb;
	  if (typeof cb !== 'function') throw new ERR_MULTIPLE_CALLBACK();
	  onwriteStateUpdate(state);
	  if (er) onwriteError(stream, state, sync, er, cb);else {
	    // Check if we're actually ready to finish, but don't emit yet
	    var finished = needFinish(state) || stream.destroyed;
	    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
	      clearBuffer(stream, state);
	    }
	    if (sync) {
	      process.nextTick(afterWrite, stream, state, finished, cb);
	    } else {
	      afterWrite(stream, state, finished, cb);
	    }
	  }
	}
	function afterWrite(stream, state, finished, cb) {
	  if (!finished) onwriteDrain(stream, state);
	  state.pendingcb--;
	  cb();
	  finishMaybe(stream, state);
	}

	// Must force callback to be called on nextTick, so that we don't
	// emit 'drain' before the write() consumer gets the 'false' return
	// value, and has a chance to attach a 'drain' listener.
	function onwriteDrain(stream, state) {
	  if (state.length === 0 && state.needDrain) {
	    state.needDrain = false;
	    stream.emit('drain');
	  }
	}

	// if there's something in the buffer waiting, then process it
	function clearBuffer(stream, state) {
	  state.bufferProcessing = true;
	  var entry = state.bufferedRequest;
	  if (stream._writev && entry && entry.next) {
	    // Fast case, write everything using _writev()
	    var l = state.bufferedRequestCount;
	    var buffer = new Array(l);
	    var holder = state.corkedRequestsFree;
	    holder.entry = entry;
	    var count = 0;
	    var allBuffers = true;
	    while (entry) {
	      buffer[count] = entry;
	      if (!entry.isBuf) allBuffers = false;
	      entry = entry.next;
	      count += 1;
	    }
	    buffer.allBuffers = allBuffers;
	    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

	    // doWrite is almost always async, defer these to save a bit of time
	    // as the hot path ends with doWrite
	    state.pendingcb++;
	    state.lastBufferedRequest = null;
	    if (holder.next) {
	      state.corkedRequestsFree = holder.next;
	      holder.next = null;
	    } else {
	      state.corkedRequestsFree = new CorkedRequest(state);
	    }
	    state.bufferedRequestCount = 0;
	  } else {
	    // Slow case, write chunks one-by-one
	    while (entry) {
	      var chunk = entry.chunk;
	      var encoding = entry.encoding;
	      var cb = entry.callback;
	      var len = state.objectMode ? 1 : chunk.length;
	      doWrite(stream, state, false, len, chunk, encoding, cb);
	      entry = entry.next;
	      state.bufferedRequestCount--;
	      // if we didn't call the onwrite immediately, then
	      // it means that we need to wait until it does.
	      // also, that means that the chunk and cb are currently
	      // being processed, so move the buffer counter past them.
	      if (state.writing) {
	        break;
	      }
	    }
	    if (entry === null) state.lastBufferedRequest = null;
	  }
	  state.bufferedRequest = entry;
	  state.bufferProcessing = false;
	}
	Writable.prototype._write = function (chunk, encoding, cb) {
	  cb(new ERR_METHOD_NOT_IMPLEMENTED('_write()'));
	};
	Writable.prototype._writev = null;
	Writable.prototype.end = function (chunk, encoding, cb) {
	  var state = this._writableState;
	  if (typeof chunk === 'function') {
	    cb = chunk;
	    chunk = null;
	    encoding = null;
	  } else if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }
	  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

	  // .end() fully uncorks
	  if (state.corked) {
	    state.corked = 1;
	    this.uncork();
	  }

	  // ignore unnecessary end() calls.
	  if (!state.ending) endWritable(this, state, cb);
	  return this;
	};
	Object.defineProperty(Writable.prototype, 'writableLength', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    return this._writableState.length;
	  }
	});
	function needFinish(state) {
	  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
	}
	function callFinal(stream, state) {
	  stream._final(function (err) {
	    state.pendingcb--;
	    if (err) {
	      errorOrDestroy(stream, err);
	    }
	    state.prefinished = true;
	    stream.emit('prefinish');
	    finishMaybe(stream, state);
	  });
	}
	function prefinish(stream, state) {
	  if (!state.prefinished && !state.finalCalled) {
	    if (typeof stream._final === 'function' && !state.destroyed) {
	      state.pendingcb++;
	      state.finalCalled = true;
	      process.nextTick(callFinal, stream, state);
	    } else {
	      state.prefinished = true;
	      stream.emit('prefinish');
	    }
	  }
	}
	function finishMaybe(stream, state) {
	  var need = needFinish(state);
	  if (need) {
	    prefinish(stream, state);
	    if (state.pendingcb === 0) {
	      state.finished = true;
	      stream.emit('finish');
	      if (state.autoDestroy) {
	        // In case of duplex streams we need a way to detect
	        // if the readable side is ready for autoDestroy as well
	        var rState = stream._readableState;
	        if (!rState || rState.autoDestroy && rState.endEmitted) {
	          stream.destroy();
	        }
	      }
	    }
	  }
	  return need;
	}
	function endWritable(stream, state, cb) {
	  state.ending = true;
	  finishMaybe(stream, state);
	  if (cb) {
	    if (state.finished) process.nextTick(cb);else stream.once('finish', cb);
	  }
	  state.ended = true;
	  stream.writable = false;
	}
	function onCorkedFinish(corkReq, state, err) {
	  var entry = corkReq.entry;
	  corkReq.entry = null;
	  while (entry) {
	    var cb = entry.callback;
	    state.pendingcb--;
	    cb(err);
	    entry = entry.next;
	  }

	  // reuse the free corkReq.
	  state.corkedRequestsFree.next = corkReq;
	}
	Object.defineProperty(Writable.prototype, 'destroyed', {
	  // making it explicit this property is not enumerable
	  // because otherwise some prototype manipulation in
	  // userland will fail
	  enumerable: false,
	  get: function get() {
	    if (this._writableState === undefined) {
	      return false;
	    }
	    return this._writableState.destroyed;
	  },
	  set: function set(value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._writableState) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._writableState.destroyed = value;
	  }
	});
	Writable.prototype.destroy = destroyImpl.destroy;
	Writable.prototype._undestroy = destroyImpl.undestroy;
	Writable.prototype._destroy = function (err, cb) {
	  cb(err);
	};
	return _stream_writable$1;
}

var hasRequiredModern$1;

function requireModern$1 () {
	if (hasRequiredModern$1) return modern$1.exports;
	hasRequiredModern$1 = 1;

	var util = require$$0$4;
	var Writable = require_stream_writable$1();

	var _require = requireTripleBeam(),
	    LEVEL = _require.LEVEL;

	/**
	 * Constructor function for the TransportStream. This is the base prototype
	 * that all `winston >= 3` transports should inherit from.
	 * @param {Object} options - Options for this TransportStream instance
	 * @param {String} options.level - Highest level according to RFC5424.
	 * @param {Boolean} options.handleExceptions - If true, info with
	 * { exception: true } will be written.
	 * @param {Function} options.log - Custom log function for simple Transport
	 * creation
	 * @param {Function} options.close - Called on "unpipe" from parent.
	 */


	var TransportStream = modern$1.exports = function TransportStream() {
	  var _this = this;

	  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

	  Writable.call(this, { objectMode: true, highWaterMark: options.highWaterMark });

	  this.format = options.format;
	  this.level = options.level;
	  this.handleExceptions = options.handleExceptions;
	  this.handleRejections = options.handleRejections;
	  this.silent = options.silent;

	  if (options.log) this.log = options.log;
	  if (options.logv) this.logv = options.logv;
	  if (options.close) this.close = options.close;

	  // Get the levels from the source we are piped from.
	  this.once('pipe', function (logger) {
	    // Remark (indexzero): this bookkeeping can only support multiple
	    // Logger parents with the same `levels`. This comes into play in
	    // the `winston.Container` code in which `container.add` takes
	    // a fully realized set of options with pre-constructed TransportStreams.
	    _this.levels = logger.levels;
	    _this.parent = logger;
	  });

	  // If and/or when the transport is removed from this instance
	  this.once('unpipe', function (src) {
	    // Remark (indexzero): this bookkeeping can only support multiple
	    // Logger parents with the same `levels`. This comes into play in
	    // the `winston.Container` code in which `container.add` takes
	    // a fully realized set of options with pre-constructed TransportStreams.
	    if (src === _this.parent) {
	      _this.parent = null;
	      if (_this.close) {
	        _this.close();
	      }
	    }
	  });
	};

	/*
	 * Inherit from Writeable using Node.js built-ins
	 */
	util.inherits(TransportStream, Writable);

	/**
	 * Writes the info object to our transport instance.
	 * @param {mixed} info - TODO: add param description.
	 * @param {mixed} enc - TODO: add param description.
	 * @param {function} callback - TODO: add param description.
	 * @returns {undefined}
	 * @private
	 */
	TransportStream.prototype._write = function _write(info, enc, callback) {
	  if (this.silent || info.exception === true && !this.handleExceptions) {
	    return callback(null);
	  }

	  // Remark: This has to be handled in the base transport now because we
	  // cannot conditionally write to our pipe targets as stream. We always
	  // prefer any explicit level set on the Transport itself falling back to
	  // any level set on the parent.
	  var level = this.level || this.parent && this.parent.level;

	  if (!level || this.levels[level] >= this.levels[info[LEVEL]]) {
	    if (info && !this.format) {
	      return this.log(info, callback);
	    }

	    var errState = void 0;
	    var transformed = void 0;

	    // We trap(and re-throw) any errors generated by the user-provided format, but also
	    // guarantee that the streams callback is invoked so that we can continue flowing.
	    try {
	      transformed = this.format.transform(Object.assign({}, info), this.format.options);
	    } catch (err) {
	      errState = err;
	    }

	    if (errState || !transformed) {
	      // eslint-disable-next-line callback-return
	      callback();
	      if (errState) throw errState;
	      return;
	    }

	    return this.log(transformed, callback);
	  }
	  this._writableState.sync = false;
	  return callback(null);
	};

	/**
	 * Writes the batch of info objects (i.e. "object chunks") to our transport
	 * instance after performing any necessary filtering.
	 * @param {mixed} chunks - TODO: add params description.
	 * @param {function} callback - TODO: add params description.
	 * @returns {mixed} - TODO: add returns description.
	 * @private
	 */
	TransportStream.prototype._writev = function _writev(chunks, callback) {
	  if (this.logv) {
	    var infos = chunks.filter(this._accept, this);
	    if (!infos.length) {
	      return callback(null);
	    }

	    // Remark (indexzero): from a performance perspective if Transport
	    // implementers do choose to implement logv should we make it their
	    // responsibility to invoke their format?
	    return this.logv(infos, callback);
	  }

	  for (var i = 0; i < chunks.length; i++) {
	    if (!this._accept(chunks[i])) continue;

	    if (chunks[i].chunk && !this.format) {
	      this.log(chunks[i].chunk, chunks[i].callback);
	      continue;
	    }

	    var errState = void 0;
	    var transformed = void 0;

	    // We trap(and re-throw) any errors generated by the user-provided format, but also
	    // guarantee that the streams callback is invoked so that we can continue flowing.
	    try {
	      transformed = this.format.transform(Object.assign({}, chunks[i].chunk), this.format.options);
	    } catch (err) {
	      errState = err;
	    }

	    if (errState || !transformed) {
	      // eslint-disable-next-line callback-return
	      chunks[i].callback();
	      if (errState) {
	        // eslint-disable-next-line callback-return
	        callback(null);
	        throw errState;
	      }
	    } else {
	      this.log(transformed, chunks[i].callback);
	    }
	  }

	  return callback(null);
	};

	/**
	 * Predicate function that returns true if the specfied `info` on the
	 * WriteReq, `write`, should be passed down into the derived
	 * TransportStream's I/O via `.log(info, callback)`.
	 * @param {WriteReq} write - winston@3 Node.js WriteReq for the `info` object
	 * representing the log message.
	 * @returns {Boolean} - Value indicating if the `write` should be accepted &
	 * logged.
	 */
	TransportStream.prototype._accept = function _accept(write) {
	  var info = write.chunk;
	  if (this.silent) {
	    return false;
	  }

	  // We always prefer any explicit level set on the Transport itself
	  // falling back to any level set on the parent.
	  var level = this.level || this.parent && this.parent.level;

	  // Immediately check the average case: log level filtering.
	  if (info.exception === true || !level || this.levels[level] >= this.levels[info[LEVEL]]) {
	    // Ensure the info object is valid based on `{ exception }`:
	    // 1. { handleExceptions: true }: all `info` objects are valid
	    // 2. { exception: false }: accepted by all transports.
	    if (this.handleExceptions || info.exception !== true) {
	      return true;
	    }
	  }

	  return false;
	};

	/**
	 * _nop is short for "No operation"
	 * @returns {Boolean} Intentionally false.
	 */
	TransportStream.prototype._nop = function _nop() {
	  // eslint-disable-next-line no-undefined
	  return void undefined;
	};
	return modern$1.exports;
}

var legacy$1 = {exports: {}};

var hasRequiredLegacy$1;

function requireLegacy$1 () {
	if (hasRequiredLegacy$1) return legacy$1.exports;
	hasRequiredLegacy$1 = 1;

	var util = require$$0$4;

	var _require = requireTripleBeam(),
	    LEVEL = _require.LEVEL;

	var TransportStream = requireModern$1();

	/**
	 * Constructor function for the LegacyTransportStream. This is an internal
	 * wrapper `winston >= 3` uses to wrap older transports implementing
	 * log(level, message, meta).
	 * @param {Object} options - Options for this TransportStream instance.
	 * @param {Transpot} options.transport - winston@2 or older Transport to wrap.
	 */

	var LegacyTransportStream = legacy$1.exports = function LegacyTransportStream() {
	  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

	  TransportStream.call(this, options);
	  if (!options.transport || typeof options.transport.log !== 'function') {
	    throw new Error('Invalid transport, must be an object with a log method.');
	  }

	  this.transport = options.transport;
	  this.level = this.level || options.transport.level;
	  this.handleExceptions = this.handleExceptions || options.transport.handleExceptions;

	  // Display our deprecation notice.
	  this._deprecated();

	  // Properly bubble up errors from the transport to the
	  // LegacyTransportStream instance, but only once no matter how many times
	  // this transport is shared.
	  function transportError(err) {
	    this.emit('error', err, this.transport);
	  }

	  if (!this.transport.__winstonError) {
	    this.transport.__winstonError = transportError.bind(this);
	    this.transport.on('error', this.transport.__winstonError);
	  }
	};

	/*
	 * Inherit from TransportStream using Node.js built-ins
	 */
	util.inherits(LegacyTransportStream, TransportStream);

	/**
	 * Writes the info object to our transport instance.
	 * @param {mixed} info - TODO: add param description.
	 * @param {mixed} enc - TODO: add param description.
	 * @param {function} callback - TODO: add param description.
	 * @returns {undefined}
	 * @private
	 */
	LegacyTransportStream.prototype._write = function _write(info, enc, callback) {
	  if (this.silent || info.exception === true && !this.handleExceptions) {
	    return callback(null);
	  }

	  // Remark: This has to be handled in the base transport now because we
	  // cannot conditionally write to our pipe targets as stream.
	  if (!this.level || this.levels[this.level] >= this.levels[info[LEVEL]]) {
	    this.transport.log(info[LEVEL], info.message, info, this._nop);
	  }

	  callback(null);
	};

	/**
	 * Writes the batch of info objects (i.e. "object chunks") to our transport
	 * instance after performing any necessary filtering.
	 * @param {mixed} chunks - TODO: add params description.
	 * @param {function} callback - TODO: add params description.
	 * @returns {mixed} - TODO: add returns description.
	 * @private
	 */
	LegacyTransportStream.prototype._writev = function _writev(chunks, callback) {
	  for (var i = 0; i < chunks.length; i++) {
	    if (this._accept(chunks[i])) {
	      this.transport.log(chunks[i].chunk[LEVEL], chunks[i].chunk.message, chunks[i].chunk, this._nop);
	      chunks[i].callback();
	    }
	  }

	  return callback(null);
	};

	/**
	 * Displays a deprecation notice. Defined as a function so it can be
	 * overriden in tests.
	 * @returns {undefined}
	 */
	LegacyTransportStream.prototype._deprecated = function _deprecated() {
	  // eslint-disable-next-line no-console
	  console.error([this.transport.name + ' is a legacy winston transport. Consider upgrading: ', '- Upgrade docs: https://github.com/winstonjs/winston/blob/master/UPGRADE-3.0.md'].join('\n'));
	};

	/**
	 * Clean up error handling state on the legacy transport associated
	 * with this instance.
	 * @returns {undefined}
	 */
	LegacyTransportStream.prototype.close = function close() {
	  if (this.transport.close) {
	    this.transport.close();
	  }

	  if (this.transport.__winstonError) {
	    this.transport.removeListener('error', this.transport.__winstonError);
	    this.transport.__winstonError = null;
	  }
	};
	return legacy$1.exports;
}

var hasRequiredDist;

function requireDist () {
	if (hasRequiredDist) return dist.exports;
	hasRequiredDist = 1;

	// Expose modern transport directly as the export

	dist.exports = requireModern$1();

	// Expose legacy stream
	dist.exports.LegacyTransportStream = requireLegacy$1();
	return dist.exports;
}

/* eslint-disable no-console */

var console_1$1;
var hasRequiredConsole$1;

function requireConsole$1 () {
	if (hasRequiredConsole$1) return console_1$1;
	hasRequiredConsole$1 = 1;

	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
	function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
	function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
	function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
	function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
	function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: true, configurable: true } }), Object.defineProperty(t, "prototype", { writable: false }), e && _setPrototypeOf(t, e); }
	function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
	var os = os__default;
	var _require = requireTripleBeam(),
	  LEVEL = _require.LEVEL,
	  MESSAGE = _require.MESSAGE;
	var TransportStream = requireDist();

	/**
	 * Transport for outputting to the console.
	 * @type {Console}
	 * @extends {TransportStream}
	 */
	console_1$1 = /*#__PURE__*/function (_TransportStream) {
	  /**
	   * Constructor function for the Console transport object responsible for
	   * persisting log messages and metadata to a terminal or TTY.
	   * @param {!Object} [options={}] - Options for this instance.
	   */
	  function Console() {
	    var _this;
	    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    _classCallCheck(this, Console);
	    _this = _callSuper(this, Console, [options]);

	    // Expose the name of this Transport on the prototype
	    _this.name = options.name || 'console';
	    _this.stderrLevels = _this._stringArrayToSet(options.stderrLevels);
	    _this.consoleWarnLevels = _this._stringArrayToSet(options.consoleWarnLevels);
	    _this.eol = typeof options.eol === 'string' ? options.eol : os.EOL;
	    _this.forceConsole = options.forceConsole || false;

	    // Keep a reference to the log, warn, and error console methods
	    // in case they get redirected to this transport after the logger is
	    // instantiated. This prevents a circular reference issue.
	    _this._consoleLog = console.log.bind(console);
	    _this._consoleWarn = console.warn.bind(console);
	    _this._consoleError = console.error.bind(console);
	    _this.setMaxListeners(30);
	    return _this;
	  }

	  /**
	   * Core logging method exposed to Winston.
	   * @param {Object} info - TODO: add param description.
	   * @param {Function} callback - TODO: add param description.
	   * @returns {undefined}
	   */
	  _inherits(Console, _TransportStream);
	  return _createClass(Console, [{
	    key: "log",
	    value: function log(info, callback) {
	      var _this2 = this;
	      setImmediate(function () {
	        return _this2.emit('logged', info);
	      });

	      // Remark: what if there is no raw...?
	      if (this.stderrLevels[info[LEVEL]]) {
	        if (console._stderr && !this.forceConsole) {
	          // Node.js maps `process.stderr` to `console._stderr`.
	          console._stderr.write("".concat(info[MESSAGE]).concat(this.eol));
	        } else {
	          // console.error adds a newline
	          this._consoleError(info[MESSAGE]);
	        }
	        if (callback) {
	          callback(); // eslint-disable-line callback-return
	        }
	        return;
	      } else if (this.consoleWarnLevels[info[LEVEL]]) {
	        if (console._stderr && !this.forceConsole) {
	          // Node.js maps `process.stderr` to `console._stderr`.
	          // in Node.js console.warn is an alias for console.error
	          console._stderr.write("".concat(info[MESSAGE]).concat(this.eol));
	        } else {
	          // console.warn adds a newline
	          this._consoleWarn(info[MESSAGE]);
	        }
	        if (callback) {
	          callback(); // eslint-disable-line callback-return
	        }
	        return;
	      }
	      if (console._stdout && !this.forceConsole) {
	        // Node.js maps `process.stdout` to `console._stdout`.
	        console._stdout.write("".concat(info[MESSAGE]).concat(this.eol));
	      } else {
	        // console.log adds a newline.
	        this._consoleLog(info[MESSAGE]);
	      }
	      if (callback) {
	        callback(); // eslint-disable-line callback-return
	      }
	    }

	    /**
	     * Returns a Set-like object with strArray's elements as keys (each with the
	     * value true).
	     * @param {Array} strArray - Array of Set-elements as strings.
	     * @param {?string} [errMsg] - Custom error message thrown on invalid input.
	     * @returns {Object} - TODO: add return description.
	     * @private
	     */
	  }, {
	    key: "_stringArrayToSet",
	    value: function _stringArrayToSet(strArray, errMsg) {
	      if (!strArray) return {};
	      errMsg = errMsg || 'Cannot make set from type other than Array of string elements';
	      if (!Array.isArray(strArray)) {
	        throw new Error(errMsg);
	      }
	      return strArray.reduce(function (set, el) {
	        if (typeof el !== 'string') {
	          throw new Error(errMsg);
	        }
	        set[el] = true;
	        return set;
	      }, {});
	    }
	  }]);
	}(TransportStream);
	return console_1$1;
}

var series = {exports: {}};

var parallel = {exports: {}};

var isArrayLike = {exports: {}};

var hasRequiredIsArrayLike;

function requireIsArrayLike () {
	if (hasRequiredIsArrayLike) return isArrayLike.exports;
	hasRequiredIsArrayLike = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = isArrayLike;
		function isArrayLike(value) {
		    return value && typeof value.length === 'number' && value.length >= 0 && value.length % 1 === 0;
		}
		module.exports = exports$1.default; 
	} (isArrayLike, isArrayLike.exports));
	return isArrayLike.exports;
}

var wrapAsync = {};

var asyncify = {exports: {}};

var initialParams = {exports: {}};

var hasRequiredInitialParams;

function requireInitialParams () {
	if (hasRequiredInitialParams) return initialParams.exports;
	hasRequiredInitialParams = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});

		exports$1.default = function (fn) {
		    return function (...args /*, callback*/) {
		        var callback = args.pop();
		        return fn.call(this, args, callback);
		    };
		};

		module.exports = exports$1.default; 
	} (initialParams, initialParams.exports));
	return initialParams.exports;
}

var setImmediate$1 = {};

var hasRequiredSetImmediate;

function requireSetImmediate () {
	if (hasRequiredSetImmediate) return setImmediate$1;
	hasRequiredSetImmediate = 1;

	Object.defineProperty(setImmediate$1, "__esModule", {
	    value: true
	});
	setImmediate$1.fallback = fallback;
	setImmediate$1.wrap = wrap;
	/* istanbul ignore file */

	var hasQueueMicrotask = setImmediate$1.hasQueueMicrotask = typeof queueMicrotask === 'function' && queueMicrotask;
	var hasSetImmediate = setImmediate$1.hasSetImmediate = typeof setImmediate === 'function' && setImmediate;
	var hasNextTick = setImmediate$1.hasNextTick = typeof process === 'object' && typeof process.nextTick === 'function';

	function fallback(fn) {
	    setTimeout(fn, 0);
	}

	function wrap(defer) {
	    return (fn, ...args) => defer(() => fn(...args));
	}

	var _defer;

	if (hasQueueMicrotask) {
	    _defer = queueMicrotask;
	} else if (hasSetImmediate) {
	    _defer = setImmediate;
	} else if (hasNextTick) {
	    _defer = process.nextTick;
	} else {
	    _defer = fallback;
	}

	setImmediate$1.default = wrap(_defer);
	return setImmediate$1;
}

var hasRequiredAsyncify;

function requireAsyncify () {
	if (hasRequiredAsyncify) return asyncify.exports;
	hasRequiredAsyncify = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = asyncify;

		var _initialParams = requireInitialParams();

		var _initialParams2 = _interopRequireDefault(_initialParams);

		var _setImmediate = requireSetImmediate();

		var _setImmediate2 = _interopRequireDefault(_setImmediate);

		var _wrapAsync = requireWrapAsync();

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		/**
		 * Take a sync function and make it async, passing its return value to a
		 * callback. This is useful for plugging sync functions into a waterfall,
		 * series, or other async functions. Any arguments passed to the generated
		 * function will be passed to the wrapped function (except for the final
		 * callback argument). Errors thrown will be passed to the callback.
		 *
		 * If the function passed to `asyncify` returns a Promise, that promises's
		 * resolved/rejected state will be used to call the callback, rather than simply
		 * the synchronous return value.
		 *
		 * This also means you can asyncify ES2017 `async` functions.
		 *
		 * @name asyncify
		 * @static
		 * @memberOf module:Utils
		 * @method
		 * @alias wrapSync
		 * @category Util
		 * @param {Function} func - The synchronous function, or Promise-returning
		 * function to convert to an {@link AsyncFunction}.
		 * @returns {AsyncFunction} An asynchronous wrapper of the `func`. To be
		 * invoked with `(args..., callback)`.
		 * @example
		 *
		 * // passing a regular synchronous function
		 * async.waterfall([
		 *     async.apply(fs.readFile, filename, "utf8"),
		 *     async.asyncify(JSON.parse),
		 *     function (data, next) {
		 *         // data is the result of parsing the text.
		 *         // If there was a parsing error, it would have been caught.
		 *     }
		 * ], callback);
		 *
		 * // passing a function returning a promise
		 * async.waterfall([
		 *     async.apply(fs.readFile, filename, "utf8"),
		 *     async.asyncify(function (contents) {
		 *         return db.model.create(contents);
		 *     }),
		 *     function (model, next) {
		 *         // `model` is the instantiated model object.
		 *         // If there was an error, this function would be skipped.
		 *     }
		 * ], callback);
		 *
		 * // es2017 example, though `asyncify` is not needed if your JS environment
		 * // supports async functions out of the box
		 * var q = async.queue(async.asyncify(async function(file) {
		 *     var intermediateStep = await processFile(file);
		 *     return await somePromise(intermediateStep)
		 * }));
		 *
		 * q.push(files);
		 */
		function asyncify(func) {
		    if ((0, _wrapAsync.isAsync)(func)) {
		        return function (...args /*, callback*/) {
		            const callback = args.pop();
		            const promise = func.apply(this, args);
		            return handlePromise(promise, callback);
		        };
		    }

		    return (0, _initialParams2.default)(function (args, callback) {
		        var result;
		        try {
		            result = func.apply(this, args);
		        } catch (e) {
		            return callback(e);
		        }
		        // if result is Promise object
		        if (result && typeof result.then === 'function') {
		            return handlePromise(result, callback);
		        } else {
		            callback(null, result);
		        }
		    });
		}

		function handlePromise(promise, callback) {
		    return promise.then(value => {
		        invokeCallback(callback, null, value);
		    }, err => {
		        invokeCallback(callback, err && (err instanceof Error || err.message) ? err : new Error(err));
		    });
		}

		function invokeCallback(callback, error, value) {
		    try {
		        callback(error, value);
		    } catch (err) {
		        (0, _setImmediate2.default)(e => {
		            throw e;
		        }, err);
		    }
		}
		module.exports = exports$1.default; 
	} (asyncify, asyncify.exports));
	return asyncify.exports;
}

var hasRequiredWrapAsync;

function requireWrapAsync () {
	if (hasRequiredWrapAsync) return wrapAsync;
	hasRequiredWrapAsync = 1;

	Object.defineProperty(wrapAsync, "__esModule", {
	    value: true
	});
	wrapAsync.isAsyncIterable = wrapAsync.isAsyncGenerator = wrapAsync.isAsync = undefined;

	var _asyncify = requireAsyncify();

	var _asyncify2 = _interopRequireDefault(_asyncify);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function isAsync(fn) {
	    return fn[Symbol.toStringTag] === 'AsyncFunction';
	}

	function isAsyncGenerator(fn) {
	    return fn[Symbol.toStringTag] === 'AsyncGenerator';
	}

	function isAsyncIterable(obj) {
	    return typeof obj[Symbol.asyncIterator] === 'function';
	}

	function wrapAsync$1(asyncFn) {
	    if (typeof asyncFn !== 'function') throw new Error('expected a function');
	    return isAsync(asyncFn) ? (0, _asyncify2.default)(asyncFn) : asyncFn;
	}

	wrapAsync.default = wrapAsync$1;
	wrapAsync.isAsync = isAsync;
	wrapAsync.isAsyncGenerator = isAsyncGenerator;
	wrapAsync.isAsyncIterable = isAsyncIterable;
	return wrapAsync;
}

var awaitify = {exports: {}};

var hasRequiredAwaitify;

function requireAwaitify () {
	if (hasRequiredAwaitify) return awaitify.exports;
	hasRequiredAwaitify = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = awaitify;
		// conditionally promisify a function.
		// only return a promise if a callback is omitted
		function awaitify(asyncFn, arity) {
		    if (!arity) arity = asyncFn.length;
		    if (!arity) throw new Error('arity is undefined');
		    function awaitable(...args) {
		        if (typeof args[arity - 1] === 'function') {
		            return asyncFn.apply(this, args);
		        }

		        return new Promise((resolve, reject) => {
		            args[arity - 1] = (err, ...cbArgs) => {
		                if (err) return reject(err);
		                resolve(cbArgs.length > 1 ? cbArgs : cbArgs[0]);
		            };
		            asyncFn.apply(this, args);
		        });
		    }

		    return awaitable;
		}
		module.exports = exports$1.default; 
	} (awaitify, awaitify.exports));
	return awaitify.exports;
}

var hasRequiredParallel;

function requireParallel () {
	if (hasRequiredParallel) return parallel.exports;
	hasRequiredParallel = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});

		var _isArrayLike = requireIsArrayLike();

		var _isArrayLike2 = _interopRequireDefault(_isArrayLike);

		var _wrapAsync = requireWrapAsync();

		var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

		var _awaitify = requireAwaitify();

		var _awaitify2 = _interopRequireDefault(_awaitify);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		exports$1.default = (0, _awaitify2.default)((eachfn, tasks, callback) => {
		    var results = (0, _isArrayLike2.default)(tasks) ? [] : {};

		    eachfn(tasks, (task, key, taskCb) => {
		        (0, _wrapAsync2.default)(task)((err, ...result) => {
		            if (result.length < 2) {
		                [result] = result;
		            }
		            results[key] = result;
		            taskCb(err);
		        });
		    }, err => callback(err, results));
		}, 3);
		module.exports = exports$1.default; 
	} (parallel, parallel.exports));
	return parallel.exports;
}

var eachOfSeries = {exports: {}};

var eachOfLimit$1 = {exports: {}};

var eachOfLimit = {exports: {}};

var once$1 = {exports: {}};

var hasRequiredOnce$1;

function requireOnce$1 () {
	if (hasRequiredOnce$1) return once$1.exports;
	hasRequiredOnce$1 = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = once;
		function once(fn) {
		    function wrapper(...args) {
		        if (fn === null) return;
		        var callFn = fn;
		        fn = null;
		        callFn.apply(this, args);
		    }
		    Object.assign(wrapper, fn);
		    return wrapper;
		}
		module.exports = exports$1.default; 
	} (once$1, once$1.exports));
	return once$1.exports;
}

var iterator = {exports: {}};

var getIterator = {exports: {}};

var hasRequiredGetIterator;

function requireGetIterator () {
	if (hasRequiredGetIterator) return getIterator.exports;
	hasRequiredGetIterator = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});

		exports$1.default = function (coll) {
		    return coll[Symbol.iterator] && coll[Symbol.iterator]();
		};

		module.exports = exports$1.default; 
	} (getIterator, getIterator.exports));
	return getIterator.exports;
}

var hasRequiredIterator;

function requireIterator () {
	if (hasRequiredIterator) return iterator.exports;
	hasRequiredIterator = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = createIterator;

		var _isArrayLike = requireIsArrayLike();

		var _isArrayLike2 = _interopRequireDefault(_isArrayLike);

		var _getIterator = requireGetIterator();

		var _getIterator2 = _interopRequireDefault(_getIterator);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		function createArrayIterator(coll) {
		    var i = -1;
		    var len = coll.length;
		    return function next() {
		        return ++i < len ? { value: coll[i], key: i } : null;
		    };
		}

		function createES2015Iterator(iterator) {
		    var i = -1;
		    return function next() {
		        var item = iterator.next();
		        if (item.done) return null;
		        i++;
		        return { value: item.value, key: i };
		    };
		}

		function createObjectIterator(obj) {
		    var okeys = obj ? Object.keys(obj) : [];
		    var i = -1;
		    var len = okeys.length;
		    return function next() {
		        var key = okeys[++i];
		        if (key === '__proto__') {
		            return next();
		        }
		        return i < len ? { value: obj[key], key } : null;
		    };
		}

		function createIterator(coll) {
		    if ((0, _isArrayLike2.default)(coll)) {
		        return createArrayIterator(coll);
		    }

		    var iterator = (0, _getIterator2.default)(coll);
		    return iterator ? createES2015Iterator(iterator) : createObjectIterator(coll);
		}
		module.exports = exports$1.default; 
	} (iterator, iterator.exports));
	return iterator.exports;
}

var onlyOnce = {exports: {}};

var hasRequiredOnlyOnce;

function requireOnlyOnce () {
	if (hasRequiredOnlyOnce) return onlyOnce.exports;
	hasRequiredOnlyOnce = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = onlyOnce;
		function onlyOnce(fn) {
		    return function (...args) {
		        if (fn === null) throw new Error("Callback was already called.");
		        var callFn = fn;
		        fn = null;
		        callFn.apply(this, args);
		    };
		}
		module.exports = exports$1.default; 
	} (onlyOnce, onlyOnce.exports));
	return onlyOnce.exports;
}

var asyncEachOfLimit = {exports: {}};

var breakLoop = {exports: {}};

var hasRequiredBreakLoop;

function requireBreakLoop () {
	if (hasRequiredBreakLoop) return breakLoop.exports;
	hasRequiredBreakLoop = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		// A temporary value used to identify if the loop should be broken.
		// See #1064, #1293
		const breakLoop = {};
		exports$1.default = breakLoop;
		module.exports = exports$1.default; 
	} (breakLoop, breakLoop.exports));
	return breakLoop.exports;
}

var hasRequiredAsyncEachOfLimit;

function requireAsyncEachOfLimit () {
	if (hasRequiredAsyncEachOfLimit) return asyncEachOfLimit.exports;
	hasRequiredAsyncEachOfLimit = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = asyncEachOfLimit;

		var _breakLoop = requireBreakLoop();

		var _breakLoop2 = _interopRequireDefault(_breakLoop);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		// for async generators
		function asyncEachOfLimit(generator, limit, iteratee, callback) {
		    let done = false;
		    let canceled = false;
		    let awaiting = false;
		    let running = 0;
		    let idx = 0;

		    function replenish() {
		        //console.log('replenish')
		        if (running >= limit || awaiting || done) return;
		        //console.log('replenish awaiting')
		        awaiting = true;
		        generator.next().then(({ value, done: iterDone }) => {
		            //console.log('got value', value)
		            if (canceled || done) return;
		            awaiting = false;
		            if (iterDone) {
		                done = true;
		                if (running <= 0) {
		                    //console.log('done nextCb')
		                    callback(null);
		                }
		                return;
		            }
		            running++;
		            iteratee(value, idx, iterateeCallback);
		            idx++;
		            replenish();
		        }).catch(handleError);
		    }

		    function iterateeCallback(err, result) {
		        //console.log('iterateeCallback')
		        running -= 1;
		        if (canceled) return;
		        if (err) return handleError(err);

		        if (err === false) {
		            done = true;
		            canceled = true;
		            return;
		        }

		        if (result === _breakLoop2.default || done && running <= 0) {
		            done = true;
		            //console.log('done iterCb')
		            return callback(null);
		        }
		        replenish();
		    }

		    function handleError(err) {
		        if (canceled) return;
		        awaiting = false;
		        done = true;
		        callback(err);
		    }

		    replenish();
		}
		module.exports = exports$1.default; 
	} (asyncEachOfLimit, asyncEachOfLimit.exports));
	return asyncEachOfLimit.exports;
}

var hasRequiredEachOfLimit$1;

function requireEachOfLimit$1 () {
	if (hasRequiredEachOfLimit$1) return eachOfLimit.exports;
	hasRequiredEachOfLimit$1 = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});

		var _once = requireOnce$1();

		var _once2 = _interopRequireDefault(_once);

		var _iterator = requireIterator();

		var _iterator2 = _interopRequireDefault(_iterator);

		var _onlyOnce = requireOnlyOnce();

		var _onlyOnce2 = _interopRequireDefault(_onlyOnce);

		var _wrapAsync = requireWrapAsync();

		var _asyncEachOfLimit = requireAsyncEachOfLimit();

		var _asyncEachOfLimit2 = _interopRequireDefault(_asyncEachOfLimit);

		var _breakLoop = requireBreakLoop();

		var _breakLoop2 = _interopRequireDefault(_breakLoop);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		exports$1.default = limit => {
		    return (obj, iteratee, callback) => {
		        callback = (0, _once2.default)(callback);
		        if (limit <= 0) {
		            throw new RangeError('concurrency limit cannot be less than 1');
		        }
		        if (!obj) {
		            return callback(null);
		        }
		        if ((0, _wrapAsync.isAsyncGenerator)(obj)) {
		            return (0, _asyncEachOfLimit2.default)(obj, limit, iteratee, callback);
		        }
		        if ((0, _wrapAsync.isAsyncIterable)(obj)) {
		            return (0, _asyncEachOfLimit2.default)(obj[Symbol.asyncIterator](), limit, iteratee, callback);
		        }
		        var nextElem = (0, _iterator2.default)(obj);
		        var done = false;
		        var canceled = false;
		        var running = 0;
		        var looping = false;

		        function iterateeCallback(err, value) {
		            if (canceled) return;
		            running -= 1;
		            if (err) {
		                done = true;
		                callback(err);
		            } else if (err === false) {
		                done = true;
		                canceled = true;
		            } else if (value === _breakLoop2.default || done && running <= 0) {
		                done = true;
		                return callback(null);
		            } else if (!looping) {
		                replenish();
		            }
		        }

		        function replenish() {
		            looping = true;
		            while (running < limit && !done) {
		                var elem = nextElem();
		                if (elem === null) {
		                    done = true;
		                    if (running <= 0) {
		                        callback(null);
		                    }
		                    return;
		                }
		                running += 1;
		                iteratee(elem.value, elem.key, (0, _onlyOnce2.default)(iterateeCallback));
		            }
		            looping = false;
		        }

		        replenish();
		    };
		};

		module.exports = exports$1.default; 
	} (eachOfLimit, eachOfLimit.exports));
	return eachOfLimit.exports;
}

var hasRequiredEachOfLimit;

function requireEachOfLimit () {
	if (hasRequiredEachOfLimit) return eachOfLimit$1.exports;
	hasRequiredEachOfLimit = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});

		var _eachOfLimit2 = requireEachOfLimit$1();

		var _eachOfLimit3 = _interopRequireDefault(_eachOfLimit2);

		var _wrapAsync = requireWrapAsync();

		var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

		var _awaitify = requireAwaitify();

		var _awaitify2 = _interopRequireDefault(_awaitify);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		/**
		 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs a maximum of `limit` async operations at a
		 * time.
		 *
		 * @name eachOfLimit
		 * @static
		 * @memberOf module:Collections
		 * @method
		 * @see [async.eachOf]{@link module:Collections.eachOf}
		 * @alias forEachOfLimit
		 * @category Collection
		 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
		 * @param {number} limit - The maximum number of async operations at a time.
		 * @param {AsyncFunction} iteratee - An async function to apply to each
		 * item in `coll`. The `key` is the item's key, or index in the case of an
		 * array.
		 * Invoked with (item, key, callback).
		 * @param {Function} [callback] - A callback which is called when all
		 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
		 * @returns {Promise} a promise, if a callback is omitted
		 */
		function eachOfLimit(coll, limit, iteratee, callback) {
		    return (0, _eachOfLimit3.default)(limit)(coll, (0, _wrapAsync2.default)(iteratee), callback);
		}

		exports$1.default = (0, _awaitify2.default)(eachOfLimit, 4);
		module.exports = exports$1.default; 
	} (eachOfLimit$1, eachOfLimit$1.exports));
	return eachOfLimit$1.exports;
}

var hasRequiredEachOfSeries;

function requireEachOfSeries () {
	if (hasRequiredEachOfSeries) return eachOfSeries.exports;
	hasRequiredEachOfSeries = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});

		var _eachOfLimit = requireEachOfLimit();

		var _eachOfLimit2 = _interopRequireDefault(_eachOfLimit);

		var _awaitify = requireAwaitify();

		var _awaitify2 = _interopRequireDefault(_awaitify);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		/**
		 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs only a single async operation at a time.
		 *
		 * @name eachOfSeries
		 * @static
		 * @memberOf module:Collections
		 * @method
		 * @see [async.eachOf]{@link module:Collections.eachOf}
		 * @alias forEachOfSeries
		 * @category Collection
		 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
		 * @param {AsyncFunction} iteratee - An async function to apply to each item in
		 * `coll`.
		 * Invoked with (item, key, callback).
		 * @param {Function} [callback] - A callback which is called when all `iteratee`
		 * functions have finished, or an error occurs. Invoked with (err).
		 * @returns {Promise} a promise, if a callback is omitted
		 */
		function eachOfSeries(coll, iteratee, callback) {
		    return (0, _eachOfLimit2.default)(coll, 1, iteratee, callback);
		}
		exports$1.default = (0, _awaitify2.default)(eachOfSeries, 3);
		module.exports = exports$1.default; 
	} (eachOfSeries, eachOfSeries.exports));
	return eachOfSeries.exports;
}

var hasRequiredSeries;

function requireSeries () {
	if (hasRequiredSeries) return series.exports;
	hasRequiredSeries = 1;
	(function (module, exports$1) {

		Object.defineProperty(exports$1, "__esModule", {
		    value: true
		});
		exports$1.default = series;

		var _parallel2 = requireParallel();

		var _parallel3 = _interopRequireDefault(_parallel2);

		var _eachOfSeries = requireEachOfSeries();

		var _eachOfSeries2 = _interopRequireDefault(_eachOfSeries);

		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

		/**
		 * Run the functions in the `tasks` collection in series, each one running once
		 * the previous function has completed. If any functions in the series pass an
		 * error to its callback, no more functions are run, and `callback` is
		 * immediately called with the value of the error. Otherwise, `callback`
		 * receives an array of results when `tasks` have completed.
		 *
		 * It is also possible to use an object instead of an array. Each property will
		 * be run as a function, and the results will be passed to the final `callback`
		 * as an object instead of an array. This can be a more readable way of handling
		 *  results from {@link async.series}.
		 *
		 * **Note** that while many implementations preserve the order of object
		 * properties, the [ECMAScript Language Specification](http://www.ecma-international.org/ecma-262/5.1/#sec-8.6)
		 * explicitly states that
		 *
		 * > The mechanics and order of enumerating the properties is not specified.
		 *
		 * So if you rely on the order in which your series of functions are executed,
		 * and want this to work on all platforms, consider using an array.
		 *
		 * @name series
		 * @static
		 * @memberOf module:ControlFlow
		 * @method
		 * @category Control Flow
		 * @param {Array|Iterable|AsyncIterable|Object} tasks - A collection containing
		 * [async functions]{@link AsyncFunction} to run in series.
		 * Each function can complete with any number of optional `result` values.
		 * @param {Function} [callback] - An optional callback to run once all the
		 * functions have completed. This function gets a results array (or object)
		 * containing all the result arguments passed to the `task` callbacks. Invoked
		 * with (err, result).
		 * @return {Promise} a promise, if no callback is passed
		 * @example
		 *
		 * //Using Callbacks
		 * async.series([
		 *     function(callback) {
		 *         setTimeout(function() {
		 *             // do some async task
		 *             callback(null, 'one');
		 *         }, 200);
		 *     },
		 *     function(callback) {
		 *         setTimeout(function() {
		 *             // then do another async task
		 *             callback(null, 'two');
		 *         }, 100);
		 *     }
		 * ], function(err, results) {
		 *     console.log(results);
		 *     // results is equal to ['one','two']
		 * });
		 *
		 * // an example using objects instead of arrays
		 * async.series({
		 *     one: function(callback) {
		 *         setTimeout(function() {
		 *             // do some async task
		 *             callback(null, 1);
		 *         }, 200);
		 *     },
		 *     two: function(callback) {
		 *         setTimeout(function() {
		 *             // then do another async task
		 *             callback(null, 2);
		 *         }, 100);
		 *     }
		 * }, function(err, results) {
		 *     console.log(results);
		 *     // results is equal to: { one: 1, two: 2 }
		 * });
		 *
		 * //Using Promises
		 * async.series([
		 *     function(callback) {
		 *         setTimeout(function() {
		 *             callback(null, 'one');
		 *         }, 200);
		 *     },
		 *     function(callback) {
		 *         setTimeout(function() {
		 *             callback(null, 'two');
		 *         }, 100);
		 *     }
		 * ]).then(results => {
		 *     console.log(results);
		 *     // results is equal to ['one','two']
		 * }).catch(err => {
		 *     console.log(err);
		 * });
		 *
		 * // an example using an object instead of an array
		 * async.series({
		 *     one: function(callback) {
		 *         setTimeout(function() {
		 *             // do some async task
		 *             callback(null, 1);
		 *         }, 200);
		 *     },
		 *     two: function(callback) {
		 *         setTimeout(function() {
		 *             // then do another async task
		 *             callback(null, 2);
		 *         }, 100);
		 *     }
		 * }).then(results => {
		 *     console.log(results);
		 *     // results is equal to: { one: 1, two: 2 }
		 * }).catch(err => {
		 *     console.log(err);
		 * });
		 *
		 * //Using async/await
		 * async () => {
		 *     try {
		 *         let results = await async.series([
		 *             function(callback) {
		 *                 setTimeout(function() {
		 *                     // do some async task
		 *                     callback(null, 'one');
		 *                 }, 200);
		 *             },
		 *             function(callback) {
		 *                 setTimeout(function() {
		 *                     // then do another async task
		 *                     callback(null, 'two');
		 *                 }, 100);
		 *             }
		 *         ]);
		 *         console.log(results);
		 *         // results is equal to ['one','two']
		 *     }
		 *     catch (err) {
		 *         console.log(err);
		 *     }
		 * }
		 *
		 * // an example using an object instead of an array
		 * async () => {
		 *     try {
		 *         let results = await async.parallel({
		 *             one: function(callback) {
		 *                 setTimeout(function() {
		 *                     // do some async task
		 *                     callback(null, 1);
		 *                 }, 200);
		 *             },
		 *            two: function(callback) {
		 *                 setTimeout(function() {
		 *                     // then do another async task
		 *                     callback(null, 2);
		 *                 }, 100);
		 *            }
		 *         });
		 *         console.log(results);
		 *         // results is equal to: { one: 1, two: 2 }
		 *     }
		 *     catch (err) {
		 *         console.log(err);
		 *     }
		 * }
		 *
		 */
		function series(tasks, callback) {
		    return (0, _parallel3.default)(_eachOfSeries2.default, tasks, callback);
		}
		module.exports = exports$1.default; 
	} (series, series.exports));
	return series.exports;
}

var readableBrowser$1 = {exports: {}};

var _stream_transform$1;
var hasRequired_stream_transform$1;

function require_stream_transform$1 () {
	if (hasRequired_stream_transform$1) return _stream_transform$1;
	hasRequired_stream_transform$1 = 1;

	_stream_transform$1 = Transform;
	var _require$codes = requireErrorsBrowser().codes,
	  ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED,
	  ERR_MULTIPLE_CALLBACK = _require$codes.ERR_MULTIPLE_CALLBACK,
	  ERR_TRANSFORM_ALREADY_TRANSFORMING = _require$codes.ERR_TRANSFORM_ALREADY_TRANSFORMING,
	  ERR_TRANSFORM_WITH_LENGTH_0 = _require$codes.ERR_TRANSFORM_WITH_LENGTH_0;
	var Duplex = require_stream_duplex$1();
	requireInherits_browser()(Transform, Duplex);
	function afterTransform(er, data) {
	  var ts = this._transformState;
	  ts.transforming = false;
	  var cb = ts.writecb;
	  if (cb === null) {
	    return this.emit('error', new ERR_MULTIPLE_CALLBACK());
	  }
	  ts.writechunk = null;
	  ts.writecb = null;
	  if (data != null)
	    // single equals check for both `null` and `undefined`
	    this.push(data);
	  cb(er);
	  var rs = this._readableState;
	  rs.reading = false;
	  if (rs.needReadable || rs.length < rs.highWaterMark) {
	    this._read(rs.highWaterMark);
	  }
	}
	function Transform(options) {
	  if (!(this instanceof Transform)) return new Transform(options);
	  Duplex.call(this, options);
	  this._transformState = {
	    afterTransform: afterTransform.bind(this),
	    needTransform: false,
	    transforming: false,
	    writecb: null,
	    writechunk: null,
	    writeencoding: null
	  };

	  // start out asking for a readable event once data is transformed.
	  this._readableState.needReadable = true;

	  // we have implemented the _read method, and done the other things
	  // that Readable wants before the first _read call, so unset the
	  // sync guard flag.
	  this._readableState.sync = false;
	  if (options) {
	    if (typeof options.transform === 'function') this._transform = options.transform;
	    if (typeof options.flush === 'function') this._flush = options.flush;
	  }

	  // When the writable side finishes, then flush out anything remaining.
	  this.on('prefinish', prefinish);
	}
	function prefinish() {
	  var _this = this;
	  if (typeof this._flush === 'function' && !this._readableState.destroyed) {
	    this._flush(function (er, data) {
	      done(_this, er, data);
	    });
	  } else {
	    done(this, null, null);
	  }
	}
	Transform.prototype.push = function (chunk, encoding) {
	  this._transformState.needTransform = false;
	  return Duplex.prototype.push.call(this, chunk, encoding);
	};

	// This is the part where you do stuff!
	// override this function in implementation classes.
	// 'chunk' is an input chunk.
	//
	// Call `push(newChunk)` to pass along transformed output
	// to the readable side.  You may call 'push' zero or more times.
	//
	// Call `cb(err)` when you are done with this chunk.  If you pass
	// an error, then that'll put the hurt on the whole operation.  If you
	// never call cb(), then you'll never get another chunk.
	Transform.prototype._transform = function (chunk, encoding, cb) {
	  cb(new ERR_METHOD_NOT_IMPLEMENTED('_transform()'));
	};
	Transform.prototype._write = function (chunk, encoding, cb) {
	  var ts = this._transformState;
	  ts.writecb = cb;
	  ts.writechunk = chunk;
	  ts.writeencoding = encoding;
	  if (!ts.transforming) {
	    var rs = this._readableState;
	    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
	  }
	};

	// Doesn't matter what the args are here.
	// _transform does all the work.
	// That we got here means that the readable side wants more data.
	Transform.prototype._read = function (n) {
	  var ts = this._transformState;
	  if (ts.writechunk !== null && !ts.transforming) {
	    ts.transforming = true;
	    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
	  } else {
	    // mark that we need a transform, so that any data that comes in
	    // will get processed, now that we've asked for it.
	    ts.needTransform = true;
	  }
	};
	Transform.prototype._destroy = function (err, cb) {
	  Duplex.prototype._destroy.call(this, err, function (err2) {
	    cb(err2);
	  });
	};
	function done(stream, er, data) {
	  if (er) return stream.emit('error', er);
	  if (data != null)
	    // single equals check for both `null` and `undefined`
	    stream.push(data);

	  // TODO(BridgeAR): Write a test for these two error cases
	  // if there's nothing in the write buffer, then that means
	  // that nothing more will ever be provided
	  if (stream._writableState.length) throw new ERR_TRANSFORM_WITH_LENGTH_0();
	  if (stream._transformState.transforming) throw new ERR_TRANSFORM_ALREADY_TRANSFORMING();
	  return stream.push(null);
	}
	return _stream_transform$1;
}

var _stream_passthrough$1;
var hasRequired_stream_passthrough$1;

function require_stream_passthrough$1 () {
	if (hasRequired_stream_passthrough$1) return _stream_passthrough$1;
	hasRequired_stream_passthrough$1 = 1;

	_stream_passthrough$1 = PassThrough;
	var Transform = require_stream_transform$1();
	requireInherits_browser()(PassThrough, Transform);
	function PassThrough(options) {
	  if (!(this instanceof PassThrough)) return new PassThrough(options);
	  Transform.call(this, options);
	}
	PassThrough.prototype._transform = function (chunk, encoding, cb) {
	  cb(null, chunk);
	};
	return _stream_passthrough$1;
}

var pipeline_1;
var hasRequiredPipeline;

function requirePipeline () {
	if (hasRequiredPipeline) return pipeline_1;
	hasRequiredPipeline = 1;

	var eos;
	function once(callback) {
	  var called = false;
	  return function () {
	    if (called) return;
	    called = true;
	    callback.apply(void 0, arguments);
	  };
	}
	var _require$codes = requireErrorsBrowser().codes,
	  ERR_MISSING_ARGS = _require$codes.ERR_MISSING_ARGS,
	  ERR_STREAM_DESTROYED = _require$codes.ERR_STREAM_DESTROYED;
	function noop(err) {
	  // Rethrow the error if it exists to avoid swallowing it
	  if (err) throw err;
	}
	function isRequest(stream) {
	  return stream.setHeader && typeof stream.abort === 'function';
	}
	function destroyer(stream, reading, writing, callback) {
	  callback = once(callback);
	  var closed = false;
	  stream.on('close', function () {
	    closed = true;
	  });
	  if (eos === undefined) eos = requireEndOfStream$1();
	  eos(stream, {
	    readable: reading,
	    writable: writing
	  }, function (err) {
	    if (err) return callback(err);
	    closed = true;
	    callback();
	  });
	  var destroyed = false;
	  return function (err) {
	    if (closed) return;
	    if (destroyed) return;
	    destroyed = true;

	    // request.destroy just do .end - .abort is what we want
	    if (isRequest(stream)) return stream.abort();
	    if (typeof stream.destroy === 'function') return stream.destroy();
	    callback(err || new ERR_STREAM_DESTROYED('pipe'));
	  };
	}
	function call(fn) {
	  fn();
	}
	function pipe(from, to) {
	  return from.pipe(to);
	}
	function popCallback(streams) {
	  if (!streams.length) return noop;
	  if (typeof streams[streams.length - 1] !== 'function') return noop;
	  return streams.pop();
	}
	function pipeline() {
	  for (var _len = arguments.length, streams = new Array(_len), _key = 0; _key < _len; _key++) {
	    streams[_key] = arguments[_key];
	  }
	  var callback = popCallback(streams);
	  if (Array.isArray(streams[0])) streams = streams[0];
	  if (streams.length < 2) {
	    throw new ERR_MISSING_ARGS('streams');
	  }
	  var error;
	  var destroys = streams.map(function (stream, i) {
	    var reading = i < streams.length - 1;
	    var writing = i > 0;
	    return destroyer(stream, reading, writing, function (err) {
	      if (!error) error = err;
	      if (err) destroys.forEach(call);
	      if (reading) return;
	      destroys.forEach(call);
	      callback(error);
	    });
	  });
	  return streams.reduce(pipe);
	}
	pipeline_1 = pipeline;
	return pipeline_1;
}

var hasRequiredReadableBrowser$1;

function requireReadableBrowser$1 () {
	if (hasRequiredReadableBrowser$1) return readableBrowser$1.exports;
	hasRequiredReadableBrowser$1 = 1;
	(function (module, exports$1) {
		exports$1 = module.exports = require_stream_readable$1();
		exports$1.Stream = exports$1;
		exports$1.Readable = exports$1;
		exports$1.Writable = require_stream_writable$1();
		exports$1.Duplex = require_stream_duplex$1();
		exports$1.Transform = require_stream_transform$1();
		exports$1.PassThrough = require_stream_passthrough$1();
		exports$1.finished = requireEndOfStream$1();
		exports$1.pipeline = requirePipeline(); 
	} (readableBrowser$1, readableBrowser$1.exports));
	return readableBrowser$1.exports;
}

var browser$2 = {exports: {}};

/**
 * Contains all configured adapters for the given environment.
 *
 * @type {Array}
 * @public
 */

var diagnostics;
var hasRequiredDiagnostics;

function requireDiagnostics () {
	if (hasRequiredDiagnostics) return diagnostics;
	hasRequiredDiagnostics = 1;
	var adapters = [];

	/**
	 * Contains all modifier functions.
	 *
	 * @typs {Array}
	 * @public
	 */
	var modifiers = [];

	/**
	 * Our default logger.
	 *
	 * @public
	 */
	var logger = function devnull() {};

	/**
	 * Register a new adapter that will used to find environments.
	 *
	 * @param {Function} adapter A function that will return the possible env.
	 * @returns {Boolean} Indication of a successful add.
	 * @public
	 */
	function use(adapter) {
	  if (~adapters.indexOf(adapter)) return false;

	  adapters.push(adapter);
	  return true;
	}

	/**
	 * Assign a new log method.
	 *
	 * @param {Function} custom The log method.
	 * @public
	 */
	function set(custom) {
	  logger = custom;
	}

	/**
	 * Check if the namespace is allowed by any of our adapters.
	 *
	 * @param {String} namespace The namespace that needs to be enabled
	 * @returns {Boolean|Promise} Indication if the namespace is enabled by our adapters.
	 * @public
	 */
	function enabled(namespace) {
	  var async = [];

	  for (var i = 0; i < adapters.length; i++) {
	    if (adapters[i].async) {
	      async.push(adapters[i]);
	      continue;
	    }

	    if (adapters[i](namespace)) return true;
	  }

	  if (!async.length) return false;

	  //
	  // Now that we know that we Async functions, we know we run in an ES6
	  // environment and can use all the API's that they offer, in this case
	  // we want to return a Promise so that we can `await` in React-Native
	  // for an async adapter.
	  //
	  return new Promise(function pinky(resolve) {
	    Promise.all(
	      async.map(function prebind(fn) {
	        return fn(namespace);
	      })
	    ).then(function resolved(values) {
	      resolve(values.some(Boolean));
	    });
	  });
	}

	/**
	 * Add a new message modifier to the debugger.
	 *
	 * @param {Function} fn Modification function.
	 * @returns {Boolean} Indication of a successful add.
	 * @public
	 */
	function modify(fn) {
	  if (~modifiers.indexOf(fn)) return false;

	  modifiers.push(fn);
	  return true;
	}

	/**
	 * Write data to the supplied logger.
	 *
	 * @param {Object} meta Meta information about the log.
	 * @param {Array} args Arguments for console.log.
	 * @public
	 */
	function write() {
	  logger.apply(logger, arguments);
	}

	/**
	 * Process the message with the modifiers.
	 *
	 * @param {Mixed} message The message to be transformed by modifers.
	 * @returns {String} Transformed message.
	 * @public
	 */
	function process(message) {
	  for (var i = 0; i < modifiers.length; i++) {
	    message = modifiers[i].apply(modifiers[i], arguments);
	  }

	  return message;
	}

	/**
	 * Introduce options to the logger function.
	 *
	 * @param {Function} fn Calback function.
	 * @param {Object} options Properties to introduce on fn.
	 * @returns {Function} The passed function
	 * @public
	 */
	function introduce(fn, options) {
	  var has = Object.prototype.hasOwnProperty;

	  for (var key in options) {
	    if (has.call(options, key)) {
	      fn[key] = options[key];
	    }
	  }

	  return fn;
	}

	/**
	 * Nope, we're not allowed to write messages.
	 *
	 * @returns {Boolean} false
	 * @public
	 */
	function nope(options) {
	  options.enabled = false;
	  options.modify = modify;
	  options.set = set;
	  options.use = use;

	  return introduce(function diagnopes() {
	    return false;
	  }, options);
	}

	/**
	 * Yep, we're allowed to write debug messages.
	 *
	 * @param {Object} options The options for the process.
	 * @returns {Function} The function that does the logging.
	 * @public
	 */
	function yep(options) {
	  /**
	   * The function that receives the actual debug information.
	   *
	   * @returns {Boolean} indication that we're logging.
	   * @public
	   */
	  function diagnostics() {
	    var args = Array.prototype.slice.call(arguments, 0);

	    write.call(write, options, process(args, options));
	    return true;
	  }

	  options.enabled = true;
	  options.modify = modify;
	  options.set = set;
	  options.use = use;

	  return introduce(diagnostics, options);
	}

	/**
	 * Simple helper function to introduce various of helper methods to our given
	 * diagnostics function.
	 *
	 * @param {Function} diagnostics The diagnostics function.
	 * @returns {Function} diagnostics
	 * @public
	 */
	diagnostics = function create(diagnostics) {
	  diagnostics.introduce = introduce;
	  diagnostics.enabled = enabled;
	  diagnostics.process = process;
	  diagnostics.modify = modify;
	  diagnostics.write = write;
	  diagnostics.nope = nope;
	  diagnostics.yep = yep;
	  diagnostics.set = set;
	  diagnostics.use = use;

	  return diagnostics;
	};
	return diagnostics;
}

var production;
var hasRequiredProduction;

function requireProduction () {
	if (hasRequiredProduction) return production;
	hasRequiredProduction = 1;
	var create = requireDiagnostics();

	/**
	 * Create a new diagnostics logger.
	 *
	 * @param {String} namespace The namespace it should enable.
	 * @param {Object} options Additional options.
	 * @returns {Function} The logger.
	 * @public
	 */
	var diagnostics = create(function prod(namespace, options) {
	  options = options || {};
	  options.namespace = namespace;
	  options.prod = true;
	  options.dev = false;

	  if (!(options.force || prod.force)) return prod.nope(options);
	  return prod.yep(options);
	});

	//
	// Expose the diagnostics logger.
	//
	production = diagnostics;
	return production;
}

var index_cjs;
var hasRequiredIndex_cjs;

function requireIndex_cjs () {
	if (hasRequiredIndex_cjs) return index_cjs;
	hasRequiredIndex_cjs = 1;

	var cssKeywords = {
		aliceblue: [240, 248, 255],
		antiquewhite: [250, 235, 215],
		aqua: [0, 255, 255],
		aquamarine: [127, 255, 212],
		azure: [240, 255, 255],
		beige: [245, 245, 220],
		bisque: [255, 228, 196],
		black: [0, 0, 0],
		blanchedalmond: [255, 235, 205],
		blue: [0, 0, 255],
		blueviolet: [138, 43, 226],
		brown: [165, 42, 42],
		burlywood: [222, 184, 135],
		cadetblue: [95, 158, 160],
		chartreuse: [127, 255, 0],
		chocolate: [210, 105, 30],
		coral: [255, 127, 80],
		cornflowerblue: [100, 149, 237],
		cornsilk: [255, 248, 220],
		crimson: [220, 20, 60],
		cyan: [0, 255, 255],
		darkblue: [0, 0, 139],
		darkcyan: [0, 139, 139],
		darkgoldenrod: [184, 134, 11],
		darkgray: [169, 169, 169],
		darkgreen: [0, 100, 0],
		darkgrey: [169, 169, 169],
		darkkhaki: [189, 183, 107],
		darkmagenta: [139, 0, 139],
		darkolivegreen: [85, 107, 47],
		darkorange: [255, 140, 0],
		darkorchid: [153, 50, 204],
		darkred: [139, 0, 0],
		darksalmon: [233, 150, 122],
		darkseagreen: [143, 188, 143],
		darkslateblue: [72, 61, 139],
		darkslategray: [47, 79, 79],
		darkslategrey: [47, 79, 79],
		darkturquoise: [0, 206, 209],
		darkviolet: [148, 0, 211],
		deeppink: [255, 20, 147],
		deepskyblue: [0, 191, 255],
		dimgray: [105, 105, 105],
		dimgrey: [105, 105, 105],
		dodgerblue: [30, 144, 255],
		firebrick: [178, 34, 34],
		floralwhite: [255, 250, 240],
		forestgreen: [34, 139, 34],
		fuchsia: [255, 0, 255],
		gainsboro: [220, 220, 220],
		ghostwhite: [248, 248, 255],
		gold: [255, 215, 0],
		goldenrod: [218, 165, 32],
		gray: [128, 128, 128],
		green: [0, 128, 0],
		greenyellow: [173, 255, 47],
		grey: [128, 128, 128],
		honeydew: [240, 255, 240],
		hotpink: [255, 105, 180],
		indianred: [205, 92, 92],
		indigo: [75, 0, 130],
		ivory: [255, 255, 240],
		khaki: [240, 230, 140],
		lavender: [230, 230, 250],
		lavenderblush: [255, 240, 245],
		lawngreen: [124, 252, 0],
		lemonchiffon: [255, 250, 205],
		lightblue: [173, 216, 230],
		lightcoral: [240, 128, 128],
		lightcyan: [224, 255, 255],
		lightgoldenrodyellow: [250, 250, 210],
		lightgray: [211, 211, 211],
		lightgreen: [144, 238, 144],
		lightgrey: [211, 211, 211],
		lightpink: [255, 182, 193],
		lightsalmon: [255, 160, 122],
		lightseagreen: [32, 178, 170],
		lightskyblue: [135, 206, 250],
		lightslategray: [119, 136, 153],
		lightslategrey: [119, 136, 153],
		lightsteelblue: [176, 196, 222],
		lightyellow: [255, 255, 224],
		lime: [0, 255, 0],
		limegreen: [50, 205, 50],
		linen: [250, 240, 230],
		magenta: [255, 0, 255],
		maroon: [128, 0, 0],
		mediumaquamarine: [102, 205, 170],
		mediumblue: [0, 0, 205],
		mediumorchid: [186, 85, 211],
		mediumpurple: [147, 112, 219],
		mediumseagreen: [60, 179, 113],
		mediumslateblue: [123, 104, 238],
		mediumspringgreen: [0, 250, 154],
		mediumturquoise: [72, 209, 204],
		mediumvioletred: [199, 21, 133],
		midnightblue: [25, 25, 112],
		mintcream: [245, 255, 250],
		mistyrose: [255, 228, 225],
		moccasin: [255, 228, 181],
		navajowhite: [255, 222, 173],
		navy: [0, 0, 128],
		oldlace: [253, 245, 230],
		olive: [128, 128, 0],
		olivedrab: [107, 142, 35],
		orange: [255, 165, 0],
		orangered: [255, 69, 0],
		orchid: [218, 112, 214],
		palegoldenrod: [238, 232, 170],
		palegreen: [152, 251, 152],
		paleturquoise: [175, 238, 238],
		palevioletred: [219, 112, 147],
		papayawhip: [255, 239, 213],
		peachpuff: [255, 218, 185],
		peru: [205, 133, 63],
		pink: [255, 192, 203],
		plum: [221, 160, 221],
		powderblue: [176, 224, 230],
		purple: [128, 0, 128],
		rebeccapurple: [102, 51, 153],
		red: [255, 0, 0],
		rosybrown: [188, 143, 143],
		royalblue: [65, 105, 225],
		saddlebrown: [139, 69, 19],
		salmon: [250, 128, 114],
		sandybrown: [244, 164, 96],
		seagreen: [46, 139, 87],
		seashell: [255, 245, 238],
		sienna: [160, 82, 45],
		silver: [192, 192, 192],
		skyblue: [135, 206, 235],
		slateblue: [106, 90, 205],
		slategray: [112, 128, 144],
		slategrey: [112, 128, 144],
		snow: [255, 250, 250],
		springgreen: [0, 255, 127],
		steelblue: [70, 130, 180],
		tan: [210, 180, 140],
		teal: [0, 128, 128],
		thistle: [216, 191, 216],
		tomato: [255, 99, 71],
		turquoise: [64, 224, 208],
		violet: [238, 130, 238],
		wheat: [245, 222, 179],
		white: [255, 255, 255],
		whitesmoke: [245, 245, 245],
		yellow: [255, 255, 0],
		yellowgreen: [154, 205, 50]
	};

	const reverseNames = Object.create(null);

	// Create a list of reverse color names
	for (const name in cssKeywords) {
		if (Object.hasOwn(cssKeywords, name)) {
			reverseNames[cssKeywords[name]] = name;
		}
	}

	const cs = {
		to: {},
		get: {},
	};

	cs.get = function (string) {
		const prefix = string.slice(0, 3).toLowerCase();
		let value;
		let model;
		switch (prefix) {
			case 'hsl': {
				value = cs.get.hsl(string);
				model = 'hsl';
				break;
			}

			case 'hwb': {
				value = cs.get.hwb(string);
				model = 'hwb';
				break;
			}

			default: {
				value = cs.get.rgb(string);
				model = 'rgb';
				break;
			}
		}

		if (!value) {
			return null;
		}

		return {model, value};
	};

	cs.get.rgb = function (string) {
		if (!string) {
			return null;
		}

		const abbr = /^#([a-f\d]{3,4})$/i;
		const hex = /^#([a-f\d]{6})([a-f\d]{2})?$/i;
		const rgba = /^rgba?\(\s*([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)\s*(?:[\s,|/]\s*([+-]?[\d.]+)(%?)\s*)?\)$/;
		const per = /^rgba?\(\s*([+-]?[\d.]+)%\s*,?\s*([+-]?[\d.]+)%\s*,?\s*([+-]?[\d.]+)%\s*(?:[\s,|/]\s*([+-]?[\d.]+)(%?)\s*)?\)$/;
		const keyword = /^(\w+)$/;

		let rgb = [0, 0, 0, 1];
		let match;
		let i;
		let hexAlpha;

		if (match = string.match(hex)) {
			hexAlpha = match[2];
			match = match[1];

			for (i = 0; i < 3; i++) {
				// https://jsperf.com/slice-vs-substr-vs-substring-methods-long-string/19
				const i2 = i * 2;
				rgb[i] = Number.parseInt(match.slice(i2, i2 + 2), 16);
			}

			if (hexAlpha) {
				rgb[3] = Number.parseInt(hexAlpha, 16) / 255;
			}
		} else if (match = string.match(abbr)) {
			match = match[1];
			hexAlpha = match[3];

			for (i = 0; i < 3; i++) {
				rgb[i] = Number.parseInt(match[i] + match[i], 16);
			}

			if (hexAlpha) {
				rgb[3] = Number.parseInt(hexAlpha + hexAlpha, 16) / 255;
			}
		} else if (match = string.match(rgba)) {
			for (i = 0; i < 3; i++) {
				rgb[i] = Number.parseInt(match[i + 1], 10);
			}

			if (match[4]) {
				rgb[3] = match[5] ? Number.parseFloat(match[4]) * 0.01 : Number.parseFloat(match[4]);
			}
		} else if (match = string.match(per)) {
			for (i = 0; i < 3; i++) {
				rgb[i] = Math.round(Number.parseFloat(match[i + 1]) * 2.55);
			}

			if (match[4]) {
				rgb[3] = match[5] ? Number.parseFloat(match[4]) * 0.01 : Number.parseFloat(match[4]);
			}
		} else if (match = string.match(keyword)) {
			if (match[1] === 'transparent') {
				return [0, 0, 0, 0];
			}

			if (!Object.hasOwn(cssKeywords, match[1])) {
				return null;
			}

			rgb = cssKeywords[match[1]];
			rgb[3] = 1;

			return rgb;
		} else {
			return null;
		}

		for (i = 0; i < 3; i++) {
			rgb[i] = clamp(rgb[i], 0, 255);
		}

		rgb[3] = clamp(rgb[3], 0, 1);

		return rgb;
	};

	cs.get.hsl = function (string) {
		if (!string) {
			return null;
		}

		const hsl = /^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,?\s*([+-]?[\d.]+)%\s*,?\s*([+-]?[\d.]+)%\s*(?:[,|/]\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/;
		const match = string.match(hsl);

		if (match) {
			const alpha = Number.parseFloat(match[4]);
			const h = ((Number.parseFloat(match[1]) % 360) + 360) % 360;
			const s = clamp(Number.parseFloat(match[2]), 0, 100);
			const l = clamp(Number.parseFloat(match[3]), 0, 100);
			const a = clamp(Number.isNaN(alpha) ? 1 : alpha, 0, 1);

			return [h, s, l, a];
		}

		return null;
	};

	cs.get.hwb = function (string) {
		if (!string) {
			return null;
		}

		const hwb = /^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*[\s,]\s*([+-]?[\d.]+)%\s*[\s,]\s*([+-]?[\d.]+)%\s*(?:[\s,]\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/;
		const match = string.match(hwb);

		if (match) {
			const alpha = Number.parseFloat(match[4]);
			const h = ((Number.parseFloat(match[1]) % 360) + 360) % 360;
			const w = clamp(Number.parseFloat(match[2]), 0, 100);
			const b = clamp(Number.parseFloat(match[3]), 0, 100);
			const a = clamp(Number.isNaN(alpha) ? 1 : alpha, 0, 1);
			return [h, w, b, a];
		}

		return null;
	};

	cs.to.hex = function (...rgba) {
		return (
			'#' +
			hexDouble(rgba[0]) +
			hexDouble(rgba[1]) +
			hexDouble(rgba[2]) +
			(rgba[3] < 1
				? (hexDouble(Math.round(rgba[3] * 255)))
				: '')
		);
	};

	cs.to.rgb = function (...rgba) {
		return rgba.length < 4 || rgba[3] === 1
			? 'rgb(' + Math.round(rgba[0]) + ', ' + Math.round(rgba[1]) + ', ' + Math.round(rgba[2]) + ')'
			: 'rgba(' + Math.round(rgba[0]) + ', ' + Math.round(rgba[1]) + ', ' + Math.round(rgba[2]) + ', ' + rgba[3] + ')';
	};

	cs.to.rgb.percent = function (...rgba) {
		const r = Math.round(rgba[0] / 255 * 100);
		const g = Math.round(rgba[1] / 255 * 100);
		const b = Math.round(rgba[2] / 255 * 100);

		return rgba.length < 4 || rgba[3] === 1
			? 'rgb(' + r + '%, ' + g + '%, ' + b + '%)'
			: 'rgba(' + r + '%, ' + g + '%, ' + b + '%, ' + rgba[3] + ')';
	};

	cs.to.hsl = function (...hsla) {
		return hsla.length < 4 || hsla[3] === 1
			? 'hsl(' + hsla[0] + ', ' + hsla[1] + '%, ' + hsla[2] + '%)'
			: 'hsla(' + hsla[0] + ', ' + hsla[1] + '%, ' + hsla[2] + '%, ' + hsla[3] + ')';
	};

	// Hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax
	// (hwb have alpha optional & 1 is default value)
	cs.to.hwb = function (...hwba) {
		let a = '';
		if (hwba.length >= 4 && hwba[3] !== 1) {
			a = ', ' + hwba[3];
		}

		return 'hwb(' + hwba[0] + ', ' + hwba[1] + '%, ' + hwba[2] + '%' + a + ')';
	};

	cs.to.keyword = function (...rgb) {
		return reverseNames[rgb.slice(0, 3)];
	};

	// Helpers
	function clamp(number_, min, max) {
		return Math.min(Math.max(min, number_), max);
	}

	function hexDouble(number_) {
		const string_ = Math.round(number_).toString(16).toUpperCase();
		return (string_.length < 2) ? '0' + string_ : string_;
	}

	/* MIT license */
	/* eslint-disable no-mixed-operators */

	// NOTE: conversions should only return primitive values (i.e. arrays, or
	//       values that give correct `typeof` results).
	//       do not use box values types (i.e. Number(), String(), etc.)

	const reverseKeywords = {};
	for (const key of Object.keys(cssKeywords)) {
		reverseKeywords[cssKeywords[key]] = key;
	}

	const convert$1 = {
		rgb: {channels: 3, labels: 'rgb'},
		hsl: {channels: 3, labels: 'hsl'},
		hsv: {channels: 3, labels: 'hsv'},
		hwb: {channels: 3, labels: 'hwb'},
		cmyk: {channels: 4, labels: 'cmyk'},
		xyz: {channels: 3, labels: 'xyz'},
		lab: {channels: 3, labels: 'lab'},
		oklab: {channels: 3, labels: ['okl', 'oka', 'okb']},
		lch: {channels: 3, labels: 'lch'},
		oklch: {channels: 3, labels: ['okl', 'okc', 'okh']},
		hex: {channels: 1, labels: ['hex']},
		keyword: {channels: 1, labels: ['keyword']},
		ansi16: {channels: 1, labels: ['ansi16']},
		ansi256: {channels: 1, labels: ['ansi256']},
		hcg: {channels: 3, labels: ['h', 'c', 'g']},
		apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
		gray: {channels: 1, labels: ['gray']},
	};

	// LAB f(t) constant
	const LAB_FT = (6 / 29) ** 3;

	// SRGB non-linear transform functions
	function srgbNonlinearTransform(c) {
		const cc = c > 0.003_130_8
			? ((1.055 * (c ** (1 / 2.4))) - 0.055)
			: c * 12.92;
		return Math.min(Math.max(0, cc), 1);
	}

	function srgbNonlinearTransformInv(c) {
		return c > 0.040_45 ? (((c + 0.055) / 1.055) ** 2.4) : (c / 12.92);
	}

	// Hide .channels and .labels properties
	for (const model of Object.keys(convert$1)) {
		if (!('channels' in convert$1[model])) {
			throw new Error('missing channels property: ' + model);
		}

		if (!('labels' in convert$1[model])) {
			throw new Error('missing channel labels property: ' + model);
		}

		if (convert$1[model].labels.length !== convert$1[model].channels) {
			throw new Error('channel and label counts mismatch: ' + model);
		}

		const {channels, labels} = convert$1[model];
		delete convert$1[model].channels;
		delete convert$1[model].labels;
		Object.defineProperty(convert$1[model], 'channels', {value: channels});
		Object.defineProperty(convert$1[model], 'labels', {value: labels});
	}

	convert$1.rgb.hsl = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const min = Math.min(r, g, b);
		const max = Math.max(r, g, b);
		const delta = max - min;
		let h;
		let s;

		switch (max) {
			case min: {
				h = 0;

				break;
			}

			case r: {
				h = (g - b) / delta;

				break;
			}

			case g: {
				h = 2 + (b - r) / delta;

				break;
			}

			case b: {
				h = 4 + (r - g) / delta;

				break;
			}
		// No default
		}

		h = Math.min(h * 60, 360);

		if (h < 0) {
			h += 360;
		}

		const l = (min + max) / 2;

		if (max === min) {
			s = 0;
		} else if (l <= 0.5) {
			s = delta / (max + min);
		} else {
			s = delta / (2 - max - min);
		}

		return [h, s * 100, l * 100];
	};

	convert$1.rgb.hsv = function (rgb) {
		let rdif;
		let gdif;
		let bdif;
		let h;
		let s;

		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const v = Math.max(r, g, b);
		const diff = v - Math.min(r, g, b);
		const diffc = function (c) {
			return (v - c) / 6 / diff + 1 / 2;
		};

		if (diff === 0) {
			h = 0;
			s = 0;
		} else {
			s = diff / v;
			rdif = diffc(r);
			gdif = diffc(g);
			bdif = diffc(b);

			switch (v) {
				case r: {
					h = bdif - gdif;

					break;
				}

				case g: {
					h = (1 / 3) + rdif - bdif;

					break;
				}

				case b: {
					h = (2 / 3) + gdif - rdif;

					break;
				}
			// No default
			}

			if (h < 0) {
				h += 1;
			} else if (h > 1) {
				h -= 1;
			}
		}

		return [
			h * 360,
			s * 100,
			v * 100,
		];
	};

	convert$1.rgb.hwb = function (rgb) {
		const r = rgb[0];
		const g = rgb[1];
		let b = rgb[2];
		const h = convert$1.rgb.hsl(rgb)[0];
		const w = 1 / 255 * Math.min(r, Math.min(g, b));

		b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

		return [h, w * 100, b * 100];
	};

	convert$1.rgb.oklab = function (rgb) {
		// Assume sRGB
		const r = srgbNonlinearTransformInv(rgb[0] / 255);
		const g = srgbNonlinearTransformInv(rgb[1] / 255);
		const b = srgbNonlinearTransformInv(rgb[2] / 255);

		const lp = Math.cbrt(0.412_221_470_8 * r + 0.536_332_536_3 * g + 0.051_445_992_9 * b);
		const mp = Math.cbrt(0.211_903_498_2 * r + 0.680_699_545_1 * g + 0.107_396_956_6 * b);
		const sp = Math.cbrt(0.088_302_461_9 * r + 0.281_718_837_6 * g + 0.629_978_700_5 * b);

		const l = 0.210_454_255_3 * lp + 0.793_617_785 * mp - 0.004_072_046_8 * sp;
		const aa = 1.977_998_495_1 * lp - 2.428_592_205 * mp + 0.450_593_709_9 * sp;
		const bb = 0.025_904_037_1 * lp + 0.782_771_766_2 * mp - 0.808_675_766 * sp;

		return [l * 100, aa * 100, bb * 100];
	};

	convert$1.rgb.cmyk = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;

		const k = Math.min(1 - r, 1 - g, 1 - b);
		const c = (1 - r - k) / (1 - k) || 0;
		const m = (1 - g - k) / (1 - k) || 0;
		const y = (1 - b - k) / (1 - k) || 0;

		return [c * 100, m * 100, y * 100, k * 100];
	};

	function comparativeDistance(x, y) {
		/*
			See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
		*/
		return (
			((x[0] - y[0]) ** 2) +
			((x[1] - y[1]) ** 2) +
			((x[2] - y[2]) ** 2)
		);
	}

	convert$1.rgb.keyword = function (rgb) {
		const reversed = reverseKeywords[rgb];
		if (reversed) {
			return reversed;
		}

		let currentClosestDistance = Number.POSITIVE_INFINITY;
		let currentClosestKeyword;

		for (const keyword of Object.keys(cssKeywords)) {
			const value = cssKeywords[keyword];

			// Compute comparative distance
			const distance = comparativeDistance(rgb, value);

			// Check if its less, if so set as closest
			if (distance < currentClosestDistance) {
				currentClosestDistance = distance;
				currentClosestKeyword = keyword;
			}
		}

		return currentClosestKeyword;
	};

	convert$1.keyword.rgb = function (keyword) {
		return cssKeywords[keyword];
	};

	convert$1.rgb.xyz = function (rgb) {
		// Assume sRGB
		const r = srgbNonlinearTransformInv(rgb[0] / 255);
		const g = srgbNonlinearTransformInv(rgb[1] / 255);
		const b = srgbNonlinearTransformInv(rgb[2] / 255);

		const x = (r * 0.412_456_4) + (g * 0.357_576_1) + (b * 0.180_437_5);
		const y = (r * 0.212_672_9) + (g * 0.715_152_2) + (b * 0.072_175);
		const z = (r * 0.019_333_9) + (g * 0.119_192) + (b * 0.950_304_1);

		return [x * 100, y * 100, z * 100];
	};

	convert$1.rgb.lab = function (rgb) {
		const xyz = convert$1.rgb.xyz(rgb);
		let x = xyz[0];
		let y = xyz[1];
		let z = xyz[2];

		x /= 95.047;
		y /= 100;
		z /= 108.883;

		x = x > LAB_FT ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
		y = y > LAB_FT ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
		z = z > LAB_FT ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

		const l = (116 * y) - 16;
		const a = 500 * (x - y);
		const b = 200 * (y - z);

		return [l, a, b];
	};

	convert$1.hsl.rgb = function (hsl) {
		const h = hsl[0] / 360;
		const s = hsl[1] / 100;
		const l = hsl[2] / 100;
		let t3;
		let value;

		if (s === 0) {
			value = l * 255;
			return [value, value, value];
		}

		const t2 = l < 0.5 ? l * (1 + s) : l + s - l * s;

		const t1 = 2 * l - t2;

		const rgb = [0, 0, 0];
		for (let i = 0; i < 3; i++) {
			t3 = h + 1 / 3 * -(i - 1);
			if (t3 < 0) {
				t3++;
			}

			if (t3 > 1) {
				t3--;
			}

			if (6 * t3 < 1) {
				value = t1 + (t2 - t1) * 6 * t3;
			} else if (2 * t3 < 1) {
				value = t2;
			} else if (3 * t3 < 2) {
				value = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
			} else {
				value = t1;
			}

			rgb[i] = value * 255;
		}

		return rgb;
	};

	convert$1.hsl.hsv = function (hsl) {
		const h = hsl[0];
		let s = hsl[1] / 100;
		let l = hsl[2] / 100;
		let smin = s;
		const lmin = Math.max(l, 0.01);

		l *= 2;
		s *= (l <= 1) ? l : 2 - l;
		smin *= lmin <= 1 ? lmin : 2 - lmin;
		const v = (l + s) / 2;
		const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

		return [h, sv * 100, v * 100];
	};

	convert$1.hsv.rgb = function (hsv) {
		const h = hsv[0] / 60;
		const s = hsv[1] / 100;
		let v = hsv[2] / 100;
		const hi = Math.floor(h) % 6;

		const f = h - Math.floor(h);
		const p = 255 * v * (1 - s);
		const q = 255 * v * (1 - (s * f));
		const t = 255 * v * (1 - (s * (1 - f)));
		v *= 255;

		switch (hi) {
			case 0: {
				return [v, t, p];
			}

			case 1: {
				return [q, v, p];
			}

			case 2: {
				return [p, v, t];
			}

			case 3: {
				return [p, q, v];
			}

			case 4: {
				return [t, p, v];
			}

			case 5: {
				return [v, p, q];
			}
		}
	};

	convert$1.hsv.hsl = function (hsv) {
		const h = hsv[0];
		const s = hsv[1] / 100;
		const v = hsv[2] / 100;
		const vmin = Math.max(v, 0.01);
		let sl;
		let l;

		l = (2 - s) * v;
		const lmin = (2 - s) * vmin;
		sl = s * vmin;
		sl /= (lmin <= 1) ? lmin : 2 - lmin;
		sl = sl || 0;
		l /= 2;

		return [h, sl * 100, l * 100];
	};

	// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
	convert$1.hwb.rgb = function (hwb) {
		const h = hwb[0] / 360;
		let wh = hwb[1] / 100;
		let bl = hwb[2] / 100;
		const ratio = wh + bl;
		let f;

		// Wh + bl cant be > 1
		if (ratio > 1) {
			wh /= ratio;
			bl /= ratio;
		}

		const i = Math.floor(6 * h);
		const v = 1 - bl;
		f = 6 * h - i;

		// eslint-disable-next-line no-bitwise
		if ((i & 0x01) !== 0) {
			f = 1 - f;
		}

		const n = wh + f * (v - wh); // Linear interpolation

		let r;
		let g;
		let b;
		/* eslint-disable max-statements-per-line,no-multi-spaces, default-case-last */
		switch (i) {
			default:
			case 6:
			case 0: { r = v;  g = n;  b = wh; break;
			}

			case 1: { r = n;  g = v;  b = wh; break;
			}

			case 2: { r = wh; g = v;  b = n; break;
			}

			case 3: { r = wh; g = n;  b = v; break;
			}

			case 4: { r = n;  g = wh; b = v; break;
			}

			case 5: { r = v;  g = wh; b = n; break;
			}
		}
		/* eslint-enable max-statements-per-line,no-multi-spaces, default-case-last */

		return [r * 255, g * 255, b * 255];
	};

	convert$1.cmyk.rgb = function (cmyk) {
		const c = cmyk[0] / 100;
		const m = cmyk[1] / 100;
		const y = cmyk[2] / 100;
		const k = cmyk[3] / 100;

		const r = 1 - Math.min(1, c * (1 - k) + k);
		const g = 1 - Math.min(1, m * (1 - k) + k);
		const b = 1 - Math.min(1, y * (1 - k) + k);

		return [r * 255, g * 255, b * 255];
	};

	convert$1.xyz.rgb = function (xyz) {
		const x = xyz[0] / 100;
		const y = xyz[1] / 100;
		const z = xyz[2] / 100;
		let r;
		let g;
		let b;

		r = (x * 3.240_454_2) + (y * -1.5371385) + (z * -0.4985314);
		g = (x * -0.969266) + (y * 1.876_010_8) + (z * 0.041_556);
		b = (x * 0.055_643_4) + (y * -0.2040259) + (z * 1.057_225_2);

		// Assume sRGB
		r = srgbNonlinearTransform(r);
		g = srgbNonlinearTransform(g);
		b = srgbNonlinearTransform(b);

		return [r * 255, g * 255, b * 255];
	};

	convert$1.xyz.lab = function (xyz) {
		let x = xyz[0];
		let y = xyz[1];
		let z = xyz[2];

		x /= 95.047;
		y /= 100;
		z /= 108.883;

		x = x > LAB_FT ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
		y = y > LAB_FT ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
		z = z > LAB_FT ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

		const l = (116 * y) - 16;
		const a = 500 * (x - y);
		const b = 200 * (y - z);

		return [l, a, b];
	};

	convert$1.xyz.oklab = function (xyz) {
		const x = xyz[0] / 100;
		const y = xyz[1] / 100;
		const z = xyz[2] / 100;

		const lp = Math.cbrt(0.818_933_010_1 * x + 0.361_866_742_4 * y - 0.128_859_713_7 * z);
		const mp = Math.cbrt(0.032_984_543_6 * x + 0.929_311_871_5 * y + 0.036_145_638_7 * z);
		const sp = Math.cbrt(0.048_200_301_8 * x + 0.264_366_269_1 * y + 0.633_851_707 * z);

		const l = 0.210_454_255_3 * lp + 0.793_617_785 * mp - 0.004_072_046_8 * sp;
		const a = 1.977_998_495_1 * lp - 2.428_592_205 * mp + 0.450_593_709_9 * sp;
		const b = 0.025_904_037_1 * lp + 0.782_771_766_2 * mp - 0.808_675_766 * sp;

		return [l * 100, a * 100, b * 100];
	};

	convert$1.oklab.oklch = function (oklab) {
		return convert$1.lab.lch(oklab);
	};

	convert$1.oklab.xyz = function (oklab) {
		const ll = oklab[0] / 100;
		const a = oklab[1] / 100;
		const b = oklab[2] / 100;

		const l = (0.999_999_998 * ll + 0.396_337_792 * a + 0.215_803_758 * b) ** 3;
		const m = (1.000_000_008 * ll - 0.105_561_342 * a - 0.063_854_175 * b) ** 3;
		const s = (1.000_000_055 * ll - 0.089_484_182 * a - 1.291_485_538 * b) ** 3;

		const x = 1.227_013_851 * l - 0.557_799_98 * m + 0.281_256_149 * s;
		const y = -0.040580178 * l + 1.112_256_87 * m - 0.071_676_679 * s;
		const z = -0.076381285 * l - 0.421_481_978 * m + 1.586_163_22 * s;

		return [x * 100, y * 100, z * 100];
	};

	convert$1.oklab.rgb = function (oklab) {
		const ll = oklab[0] / 100;
		const aa = oklab[1] / 100;
		const bb = oklab[2] / 100;

		const l = (ll + 0.396_337_777_4 * aa + 0.215_803_757_3 * bb) ** 3;
		const m = (ll - 0.105_561_345_8 * aa - 0.063_854_172_8 * bb) ** 3;
		const s = (ll - 0.089_484_177_5 * aa - 1.291_485_548 * bb) ** 3;

		// Assume sRGB
		const r = srgbNonlinearTransform(4.076_741_662_1 * l - 3.307_711_591_3 * m + 0.230_969_929_2 * s);
		const g = srgbNonlinearTransform(-1.2684380046 * l + 2.609_757_401_1 * m - 0.341_319_396_5 * s);
		const b = srgbNonlinearTransform(-0.0041960863 * l - 0.703_418_614_7 * m + 1.707_614_701 * s);

		return [r * 255, g * 255, b * 255];
	};

	convert$1.oklch.oklab = function (oklch) {
		return convert$1.lch.lab(oklch);
	};

	convert$1.lab.xyz = function (lab) {
		const l = lab[0];
		const a = lab[1];
		const b = lab[2];
		let x;
		let y;
		let z;

		y = (l + 16) / 116;
		x = a / 500 + y;
		z = y - b / 200;

		const y2 = y ** 3;
		const x2 = x ** 3;
		const z2 = z ** 3;
		y = y2 > LAB_FT ? y2 : (y - 16 / 116) / 7.787;
		x = x2 > LAB_FT ? x2 : (x - 16 / 116) / 7.787;
		z = z2 > LAB_FT ? z2 : (z - 16 / 116) / 7.787;

		// Illuminant D65 XYZ Tristrimulus Values
		// https://en.wikipedia.org/wiki/CIE_1931_color_space
		x *= 95.047;
		y *= 100;
		z *= 108.883;

		return [x, y, z];
	};

	convert$1.lab.lch = function (lab) {
		const l = lab[0];
		const a = lab[1];
		const b = lab[2];
		let h;

		const hr = Math.atan2(b, a);
		h = hr * 360 / 2 / Math.PI;

		if (h < 0) {
			h += 360;
		}

		const c = Math.sqrt(a * a + b * b);

		return [l, c, h];
	};

	convert$1.lch.lab = function (lch) {
		const l = lch[0];
		const c = lch[1];
		const h = lch[2];

		const hr = h / 360 * 2 * Math.PI;
		const a = c * Math.cos(hr);
		const b = c * Math.sin(hr);

		return [l, a, b];
	};

	convert$1.rgb.ansi16 = function (args, saturation = null) {
		const [r, g, b] = args;
		let value = saturation === null ? convert$1.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

		value = Math.round(value / 50);

		if (value === 0) {
			return 30;
		}

		let ansi = 30
			/* eslint-disable no-bitwise */
			+ ((Math.round(b / 255) << 2)
			| (Math.round(g / 255) << 1)
			| Math.round(r / 255));
			/* eslint-enable no-bitwise */

		if (value === 2) {
			ansi += 60;
		}

		return ansi;
	};

	convert$1.hsv.ansi16 = function (args) {
		// Optimization here; we already know the value and don't need to get
		// it converted for us.
		return convert$1.rgb.ansi16(convert$1.hsv.rgb(args), args[2]);
	};

	convert$1.rgb.ansi256 = function (args) {
		const r = args[0];
		const g = args[1];
		const b = args[2];

		// We use the extended greyscale palette here, with the exception of
		// black and white. normal palette only has 4 greyscale shades.
		// eslint-disable-next-line no-bitwise
		if (r >> 4 === g >> 4 && g >> 4 === b >> 4) {
			if (r < 8) {
				return 16;
			}

			if (r > 248) {
				return 231;
			}

			return Math.round(((r - 8) / 247) * 24) + 232;
		}

		const ansi = 16
			+ (36 * Math.round(r / 255 * 5))
			+ (6 * Math.round(g / 255 * 5))
			+ Math.round(b / 255 * 5);

		return ansi;
	};

	convert$1.ansi16.rgb = function (args) {
		args = args[0];

		let color = args % 10;

		// Handle greyscale
		if (color === 0 || color === 7) {
			if (args > 50) {
				color += 3.5;
			}

			color = color / 10.5 * 255;

			return [color, color, color];
		}

		const mult = (Math.trunc(args > 50) + 1) * 0.5;
		/* eslint-disable no-bitwise */
		const r = ((color & 1) * mult) * 255;
		const g = (((color >> 1) & 1) * mult) * 255;
		const b = (((color >> 2) & 1) * mult) * 255;
		/* eslint-enable no-bitwise */

		return [r, g, b];
	};

	convert$1.ansi256.rgb = function (args) {
		args = args[0];

		// Handle greyscale
		if (args >= 232) {
			const c = (args - 232) * 10 + 8;
			return [c, c, c];
		}

		args -= 16;

		let rem;
		const r = Math.floor(args / 36) / 5 * 255;
		const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
		const b = (rem % 6) / 5 * 255;

		return [r, g, b];
	};

	convert$1.rgb.hex = function (args) {
		/* eslint-disable no-bitwise */
		const integer = ((Math.round(args[0]) & 0xFF) << 16)
			+ ((Math.round(args[1]) & 0xFF) << 8)
			+ (Math.round(args[2]) & 0xFF);
		/* eslint-enable no-bitwise */

		const string = integer.toString(16).toUpperCase();
		return '000000'.slice(string.length) + string;
	};

	convert$1.hex.rgb = function (args) {
		const match = args.toString(16).match(/[a-f\d]{6}|[a-f\d]{3}/i);
		if (!match) {
			return [0, 0, 0];
		}

		let colorString = match[0];

		if (match[0].length === 3) {
			colorString = [...colorString].map(char => char + char).join('');
		}

		const integer = Number.parseInt(colorString, 16);
		/* eslint-disable no-bitwise */
		const r = (integer >> 16) & 0xFF;
		const g = (integer >> 8) & 0xFF;
		const b = integer & 0xFF;
		/* eslint-enable no-bitwise */

		return [r, g, b];
	};

	convert$1.rgb.hcg = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const max = Math.max(Math.max(r, g), b);
		const min = Math.min(Math.min(r, g), b);
		const chroma = (max - min);
		let hue;

		const grayscale = chroma < 1 ? min / (1 - chroma) : 0;

		if (chroma <= 0) {
			hue = 0;
		} else if (max === r) {
			hue = ((g - b) / chroma) % 6;
		} else if (max === g) {
			hue = 2 + (b - r) / chroma;
		} else {
			hue = 4 + (r - g) / chroma;
		}

		hue /= 6;
		hue %= 1;

		return [hue * 360, chroma * 100, grayscale * 100];
	};

	convert$1.hsl.hcg = function (hsl) {
		const s = hsl[1] / 100;
		const l = hsl[2] / 100;

		const c = l < 0.5 ? (2 * s * l) : (2 * s * (1 - l));

		let f = 0;
		if (c < 1) {
			f = (l - 0.5 * c) / (1 - c);
		}

		return [hsl[0], c * 100, f * 100];
	};

	convert$1.hsv.hcg = function (hsv) {
		const s = hsv[1] / 100;
		const v = hsv[2] / 100;

		const c = s * v;
		let f = 0;

		if (c < 1) {
			f = (v - c) / (1 - c);
		}

		return [hsv[0], c * 100, f * 100];
	};

	convert$1.hcg.rgb = function (hcg) {
		const h = hcg[0] / 360;
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		if (c === 0) {
			return [g * 255, g * 255, g * 255];
		}

		const pure = [0, 0, 0];
		const hi = (h % 1) * 6;
		const v = hi % 1;
		const w = 1 - v;
		let mg = 0;

		/* eslint-disable max-statements-per-line */
		switch (Math.floor(hi)) {
			case 0: {
				pure[0] = 1; pure[1] = v; pure[2] = 0; break;
			}

			case 1: {
				pure[0] = w; pure[1] = 1; pure[2] = 0; break;
			}

			case 2: {
				pure[0] = 0; pure[1] = 1; pure[2] = v; break;
			}

			case 3: {
				pure[0] = 0; pure[1] = w; pure[2] = 1; break;
			}

			case 4: {
				pure[0] = v; pure[1] = 0; pure[2] = 1; break;
			}

			default: {
				pure[0] = 1; pure[1] = 0; pure[2] = w;
			}
		}
		/* eslint-enable max-statements-per-line */

		mg = (1 - c) * g;

		return [
			(c * pure[0] + mg) * 255,
			(c * pure[1] + mg) * 255,
			(c * pure[2] + mg) * 255,
		];
	};

	convert$1.hcg.hsv = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		const v = c + g * (1 - c);
		let f = 0;

		if (v > 0) {
			f = c / v;
		}

		return [hcg[0], f * 100, v * 100];
	};

	convert$1.hcg.hsl = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		const l = g * (1 - c) + 0.5 * c;
		let s = 0;

		if (l > 0 && l < 0.5) {
			s = c / (2 * l);
		} else if (l >= 0.5 && l < 1) {
			s = c / (2 * (1 - l));
		}

		return [hcg[0], s * 100, l * 100];
	};

	convert$1.hcg.hwb = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;
		const v = c + g * (1 - c);
		return [hcg[0], (v - c) * 100, (1 - v) * 100];
	};

	convert$1.hwb.hcg = function (hwb) {
		const w = hwb[1] / 100;
		const b = hwb[2] / 100;
		const v = 1 - b;
		const c = v - w;
		let g = 0;

		if (c < 1) {
			g = (v - c) / (1 - c);
		}

		return [hwb[0], c * 100, g * 100];
	};

	convert$1.apple.rgb = function (apple) {
		return [(apple[0] / 65_535) * 255, (apple[1] / 65_535) * 255, (apple[2] / 65_535) * 255];
	};

	convert$1.rgb.apple = function (rgb) {
		return [(rgb[0] / 255) * 65_535, (rgb[1] / 255) * 65_535, (rgb[2] / 255) * 65_535];
	};

	convert$1.gray.rgb = function (args) {
		return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
	};

	convert$1.gray.hsl = function (args) {
		return [0, 0, args[0]];
	};

	convert$1.gray.hsv = convert$1.gray.hsl;

	convert$1.gray.hwb = function (gray) {
		return [0, 100, gray[0]];
	};

	convert$1.gray.cmyk = function (gray) {
		return [0, 0, 0, gray[0]];
	};

	convert$1.gray.lab = function (gray) {
		return [gray[0], 0, 0];
	};

	convert$1.gray.hex = function (gray) {
		/* eslint-disable no-bitwise */
		const value = Math.round(gray[0] / 100 * 255) & 0xFF;
		const integer = (value << 16) + (value << 8) + value;
		/* eslint-enable no-bitwise */

		const string = integer.toString(16).toUpperCase();
		return '000000'.slice(string.length) + string;
	};

	convert$1.rgb.gray = function (rgb) {
		const value = (rgb[0] + rgb[1] + rgb[2]) / 3;
		return [value / 255 * 100];
	};

	/*
		This function routes a model to all other models.

		all functions that are routed have a property `.conversion` attached
		to the returned synthetic function. This property is an array
		of strings, each with the steps in between the 'from' and 'to'
		color models (inclusive).

		conversions that are not possible simply are not included.
	*/

	function buildGraph() {
		const graph = {};
		// https://jsperf.com/object-keys-vs-for-in-with-closure/3
		const models = Object.keys(convert$1);

		for (let {length} = models, i = 0; i < length; i++) {
			graph[models[i]] = {
				// http://jsperf.com/1-vs-infinity
				// micro-opt, but this is simple.
				distance: -1,
				parent: null,
			};
		}

		return graph;
	}

	// https://en.wikipedia.org/wiki/Breadth-first_search
	function deriveBFS(fromModel) {
		const graph = buildGraph();
		const queue = [fromModel]; // Unshift -> queue -> pop

		graph[fromModel].distance = 0;

		while (queue.length > 0) {
			const current = queue.pop();
			const adjacents = Object.keys(convert$1[current]);

			for (let {length} = adjacents, i = 0; i < length; i++) {
				const adjacent = adjacents[i];
				const node = graph[adjacent];

				if (node.distance === -1) {
					node.distance = graph[current].distance + 1;
					node.parent = current;
					queue.unshift(adjacent);
				}
			}
		}

		return graph;
	}

	function link(from, to) {
		return function (args) {
			return to(from(args));
		};
	}

	function wrapConversion(toModel, graph) {
		const path = [graph[toModel].parent, toModel];
		let fn = convert$1[graph[toModel].parent][toModel];

		let cur = graph[toModel].parent;
		while (graph[cur].parent) {
			path.unshift(graph[cur].parent);
			fn = link(convert$1[graph[cur].parent][cur], fn);
			cur = graph[cur].parent;
		}

		fn.conversion = path;
		return fn;
	}

	function route(fromModel) {
		const graph = deriveBFS(fromModel);
		const conversion = {};

		const models = Object.keys(graph);
		for (let {length} = models, i = 0; i < length; i++) {
			const toModel = models[i];
			const node = graph[toModel];

			if (node.parent === null) {
				// No possible conversion, or this node is the source model.
				continue;
			}

			conversion[toModel] = wrapConversion(toModel, graph);
		}

		return conversion;
	}

	const convert = {};

	const models = Object.keys(convert$1);

	function wrapRaw(fn) {
		const wrappedFn = function (...args) {
			const arg0 = args[0];
			if (arg0 === undefined || arg0 === null) {
				return arg0;
			}

			if (arg0.length > 1) {
				args = arg0;
			}

			return fn(args);
		};

		// Preserve .conversion property if there is one
		if ('conversion' in fn) {
			wrappedFn.conversion = fn.conversion;
		}

		return wrappedFn;
	}

	function wrapRounded(fn) {
		const wrappedFn = function (...args) {
			const arg0 = args[0];

			if (arg0 === undefined || arg0 === null) {
				return arg0;
			}

			if (arg0.length > 1) {
				args = arg0;
			}

			const result = fn(args);

			// We're assuming the result is an array here.
			// see notice in conversions.js; don't use box types
			// in conversion functions.
			if (typeof result === 'object') {
				for (let {length} = result, i = 0; i < length; i++) {
					result[i] = Math.round(result[i]);
				}
			}

			return result;
		};

		// Preserve .conversion property if there is one
		if ('conversion' in fn) {
			wrappedFn.conversion = fn.conversion;
		}

		return wrappedFn;
	}

	for (const fromModel of models) {
		convert[fromModel] = {};

		Object.defineProperty(convert[fromModel], 'channels', {value: convert$1[fromModel].channels});
		Object.defineProperty(convert[fromModel], 'labels', {value: convert$1[fromModel].labels});

		const routes = route(fromModel);
		const routeModels = Object.keys(routes);

		for (const toModel of routeModels) {
			const fn = routes[toModel];

			convert[fromModel][toModel] = wrapRounded(fn);
			convert[fromModel][toModel].raw = wrapRaw(fn);
		}
	}

	const skippedModels = [
		// To be honest, I don't really feel like keyword belongs in color convert, but eh.
		'keyword',

		// Gray conflicts with some method names, and has its own method defined.
		'gray',

		// Shouldn't really be in color-convert either...
		'hex',
	];

	const hashedModelKeys = {};
	for (const model of Object.keys(convert)) {
		hashedModelKeys[[...convert[model].labels].sort().join('')] = model;
	}

	const limiters = {};

	function Color(object, model) {
		if (!(this instanceof Color)) {
			return new Color(object, model);
		}

		if (model && model in skippedModels) {
			model = null;
		}

		if (model && !(model in convert)) {
			throw new Error('Unknown model: ' + model);
		}

		let i;
		let channels;

		if (object == null) { // eslint-disable-line no-eq-null,eqeqeq
			this.model = 'rgb';
			this.color = [0, 0, 0];
			this.valpha = 1;
		} else if (object instanceof Color) {
			this.model = object.model;
			this.color = [...object.color];
			this.valpha = object.valpha;
		} else if (typeof object === 'string') {
			const result = cs.get(object);
			if (result === null) {
				throw new Error('Unable to parse color from string: ' + object);
			}

			this.model = result.model;
			channels = convert[this.model].channels;
			this.color = result.value.slice(0, channels);
			this.valpha = typeof result.value[channels] === 'number' ? result.value[channels] : 1;
		} else if (object.length > 0) {
			this.model = model || 'rgb';
			channels = convert[this.model].channels;
			const newArray = Array.prototype.slice.call(object, 0, channels);
			this.color = zeroArray(newArray, channels);
			this.valpha = typeof object[channels] === 'number' ? object[channels] : 1;
		} else if (typeof object === 'number') {
			// This is always RGB - can be converted later on.
			this.model = 'rgb';
			this.color = [
				(object >> 16) & 0xFF,
				(object >> 8) & 0xFF,
				object & 0xFF,
			];
			this.valpha = 1;
		} else {
			this.valpha = 1;

			const keys = Object.keys(object);
			if ('alpha' in object) {
				keys.splice(keys.indexOf('alpha'), 1);
				this.valpha = typeof object.alpha === 'number' ? object.alpha : 0;
			}

			const hashedKeys = keys.sort().join('');
			if (!(hashedKeys in hashedModelKeys)) {
				throw new Error('Unable to parse color from object: ' + JSON.stringify(object));
			}

			this.model = hashedModelKeys[hashedKeys];

			const {labels} = convert[this.model];
			const color = [];
			for (i = 0; i < labels.length; i++) {
				color.push(object[labels[i]]);
			}

			this.color = zeroArray(color);
		}

		// Perform limitations (clamping, etc.)
		if (limiters[this.model]) {
			channels = convert[this.model].channels;
			for (i = 0; i < channels; i++) {
				const limit = limiters[this.model][i];
				if (limit) {
					this.color[i] = limit(this.color[i]);
				}
			}
		}

		this.valpha = Math.max(0, Math.min(1, this.valpha));

		if (Object.freeze) {
			Object.freeze(this);
		}
	}

	Color.prototype = {
		toString() {
			return this.string();
		},

		toJSON() {
			return this[this.model]();
		},

		string(places) {
			let self = this.model in cs.to ? this : this.rgb();
			self = self.round(typeof places === 'number' ? places : 1);
			const arguments_ = self.valpha === 1 ? self.color : [...self.color, this.valpha];
			return cs.to[self.model](...arguments_);
		},

		percentString(places) {
			const self = this.rgb().round(typeof places === 'number' ? places : 1);
			const arguments_ = self.valpha === 1 ? self.color : [...self.color, this.valpha];
			return cs.to.rgb.percent(...arguments_);
		},

		array() {
			return this.valpha === 1 ? [...this.color] : [...this.color, this.valpha];
		},

		object() {
			const result = {};
			const {channels} = convert[this.model];
			const {labels} = convert[this.model];

			for (let i = 0; i < channels; i++) {
				result[labels[i]] = this.color[i];
			}

			if (this.valpha !== 1) {
				result.alpha = this.valpha;
			}

			return result;
		},

		unitArray() {
			const rgb = this.rgb().color;
			rgb[0] /= 255;
			rgb[1] /= 255;
			rgb[2] /= 255;

			if (this.valpha !== 1) {
				rgb.push(this.valpha);
			}

			return rgb;
		},

		unitObject() {
			const rgb = this.rgb().object();
			rgb.r /= 255;
			rgb.g /= 255;
			rgb.b /= 255;

			if (this.valpha !== 1) {
				rgb.alpha = this.valpha;
			}

			return rgb;
		},

		round(places) {
			places = Math.max(places || 0, 0);
			return new Color([...this.color.map(roundToPlace(places)), this.valpha], this.model);
		},

		alpha(value) {
			if (value !== undefined) {
				return new Color([...this.color, Math.max(0, Math.min(1, value))], this.model);
			}

			return this.valpha;
		},

		// Rgb
		red: getset('rgb', 0, maxfn(255)),
		green: getset('rgb', 1, maxfn(255)),
		blue: getset('rgb', 2, maxfn(255)),

		hue: getset(['hsl', 'hsv', 'hsl', 'hwb', 'hcg'], 0, value => ((value % 360) + 360) % 360),

		saturationl: getset('hsl', 1, maxfn(100)),
		lightness: getset('hsl', 2, maxfn(100)),

		saturationv: getset('hsv', 1, maxfn(100)),
		value: getset('hsv', 2, maxfn(100)),

		chroma: getset('hcg', 1, maxfn(100)),
		gray: getset('hcg', 2, maxfn(100)),

		white: getset('hwb', 1, maxfn(100)),
		wblack: getset('hwb', 2, maxfn(100)),

		cyan: getset('cmyk', 0, maxfn(100)),
		magenta: getset('cmyk', 1, maxfn(100)),
		yellow: getset('cmyk', 2, maxfn(100)),
		black: getset('cmyk', 3, maxfn(100)),

		x: getset('xyz', 0, maxfn(95.047)),
		y: getset('xyz', 1, maxfn(100)),
		z: getset('xyz', 2, maxfn(108.833)),

		l: getset('lab', 0, maxfn(100)),
		a: getset('lab', 1),
		b: getset('lab', 2),

		keyword(value) {
			if (value !== undefined) {
				return new Color(value);
			}

			return convert[this.model].keyword(this.color);
		},

		hex(value) {
			if (value !== undefined) {
				return new Color(value);
			}

			return cs.to.hex(...this.rgb().round().color);
		},

		hexa(value) {
			if (value !== undefined) {
				return new Color(value);
			}

			const rgbArray = this.rgb().round().color;

			let alphaHex = Math.round(this.valpha * 255).toString(16).toUpperCase();
			if (alphaHex.length === 1) {
				alphaHex = '0' + alphaHex;
			}

			return cs.to.hex(...rgbArray) + alphaHex;
		},

		rgbNumber() {
			const rgb = this.rgb().color;
			return ((rgb[0] & 0xFF) << 16) | ((rgb[1] & 0xFF) << 8) | (rgb[2] & 0xFF);
		},

		luminosity() {
			// http://www.w3.org/TR/WCAG20/#relativeluminancedef
			const rgb = this.rgb().color;

			const lum = [];
			for (const [i, element] of rgb.entries()) {
				const chan = element / 255;
				lum[i] = (chan <= 0.04045) ? chan / 12.92 : ((chan + 0.055) / 1.055) ** 2.4;
			}

			return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
		},

		contrast(color2) {
			// http://www.w3.org/TR/WCAG20/#contrast-ratiodef
			const lum1 = this.luminosity();
			const lum2 = color2.luminosity();

			if (lum1 > lum2) {
				return (lum1 + 0.05) / (lum2 + 0.05);
			}

			return (lum2 + 0.05) / (lum1 + 0.05);
		},

		level(color2) {
			// https://www.w3.org/TR/WCAG/#contrast-enhanced
			const contrastRatio = this.contrast(color2);
			if (contrastRatio >= 7) {
				return 'AAA';
			}

			return (contrastRatio >= 4.5) ? 'AA' : '';
		},

		isDark() {
			// YIQ equation from http://24ways.org/2010/calculating-color-contrast
			const rgb = this.rgb().color;
			const yiq = (rgb[0] * 2126 + rgb[1] * 7152 + rgb[2] * 722) / 10000;
			return yiq < 128;
		},

		isLight() {
			return !this.isDark();
		},

		negate() {
			const rgb = this.rgb();
			for (let i = 0; i < 3; i++) {
				rgb.color[i] = 255 - rgb.color[i];
			}

			return rgb;
		},

		lighten(ratio) {
			const hsl = this.hsl();
			hsl.color[2] += hsl.color[2] * ratio;
			return hsl;
		},

		darken(ratio) {
			const hsl = this.hsl();
			hsl.color[2] -= hsl.color[2] * ratio;
			return hsl;
		},

		saturate(ratio) {
			const hsl = this.hsl();
			hsl.color[1] += hsl.color[1] * ratio;
			return hsl;
		},

		desaturate(ratio) {
			const hsl = this.hsl();
			hsl.color[1] -= hsl.color[1] * ratio;
			return hsl;
		},

		whiten(ratio) {
			const hwb = this.hwb();
			hwb.color[1] += hwb.color[1] * ratio;
			return hwb;
		},

		blacken(ratio) {
			const hwb = this.hwb();
			hwb.color[2] += hwb.color[2] * ratio;
			return hwb;
		},

		grayscale() {
			// http://en.wikipedia.org/wiki/Grayscale#Converting_colour_to_grayscale
			const rgb = this.rgb().color;
			const value = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;
			return Color.rgb(value, value, value);
		},

		fade(ratio) {
			return this.alpha(this.valpha - (this.valpha * ratio));
		},

		opaquer(ratio) {
			return this.alpha(this.valpha + (this.valpha * ratio));
		},

		rotate(degrees) {
			const hsl = this.hsl();
			let hue = hsl.color[0];
			hue = (hue + degrees) % 360;
			hue = hue < 0 ? 360 + hue : hue;
			hsl.color[0] = hue;
			return hsl;
		},

		mix(mixinColor, weight) {
			// Ported from sass implementation in C
			// https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209
			if (!mixinColor || !mixinColor.rgb) {
				throw new Error('Argument to "mix" was not a Color instance, but rather an instance of ' + typeof mixinColor);
			}

			const color1 = mixinColor.rgb();
			const color2 = this.rgb();
			const p = weight === undefined ? 0.5 : weight;

			const w = 2 * p - 1;
			const a = color1.alpha() - color2.alpha();

			const w1 = (((w * a === -1) ? w : (w + a) / (1 + w * a)) + 1) / 2;
			const w2 = 1 - w1;

			return Color.rgb(
				w1 * color1.red() + w2 * color2.red(),
				w1 * color1.green() + w2 * color2.green(),
				w1 * color1.blue() + w2 * color2.blue(),
				color1.alpha() * p + color2.alpha() * (1 - p));
		},
	};

	// Model conversion methods and static constructors
	for (const model of Object.keys(convert)) {
		if (skippedModels.includes(model)) {
			continue;
		}

		const {channels} = convert[model];

		// Conversion methods
		Color.prototype[model] = function (...arguments_) {
			if (this.model === model) {
				return new Color(this);
			}

			if (arguments_.length > 0) {
				return new Color(arguments_, model);
			}

			return new Color([...assertArray(convert[this.model][model].raw(this.color)), this.valpha], model);
		};

		// 'static' construction methods
		Color[model] = function (...arguments_) {
			let color = arguments_[0];
			if (typeof color === 'number') {
				color = zeroArray(arguments_, channels);
			}

			return new Color(color, model);
		};
	}

	function roundTo(number, places) {
		return Number(number.toFixed(places));
	}

	function roundToPlace(places) {
		return function (number) {
			return roundTo(number, places);
		};
	}

	function getset(model, channel, modifier) {
		model = Array.isArray(model) ? model : [model];

		for (const m of model) {
			(limiters[m] ||= [])[channel] = modifier;
		}

		model = model[0];

		return function (value) {
			let result;

			if (value !== undefined) {
				if (modifier) {
					value = modifier(value);
				}

				result = this[model]();
				result.color[channel] = value;
				return result;
			}

			result = this[model]().color[channel];
			if (modifier) {
				result = modifier(result);
			}

			return result;
		};
	}

	function maxfn(max) {
		return function (v) {
			return Math.max(0, Math.min(max, v));
		};
	}

	function assertArray(value) {
		return Array.isArray(value) ? value : [value];
	}

	function zeroArray(array, length) {
		for (let i = 0; i < length; i++) {
			if (typeof array[i] !== 'number') {
				array[i] = 0;
			}
		}

		return array;
	}

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	/***
	 * Convert string to hex color.
	 *
	 * @param {String} str Text to hash and convert to hex.
	 * @returns {String}
	 * @api public
	 */
	var textHex = function hex(str) {
	  for (
	    var i = 0, hash = 0;
	    i < str.length;
	    hash = str.charCodeAt(i++) + ((hash << 5) - hash)
	  );

	  var color = Math.floor(
	    Math.abs(
	      (Math.sin(hash) * 10000) % 1 * 16777216
	    )
	  ).toString(16);

	  return '#' + Array(6 - color.length + 1).join('0') + color;
	};

	var hex = /*@__PURE__*/getDefaultExportFromCjs(textHex);

	/**
	 * Generate a color for a given name. But be reasonably smart about it by
	 * understanding name spaces and coloring each namespace a bit lighter so they
	 * still have the same base color as the root.
	 *
	 * @param {string} namespace The namespace
	 * @param {string} [delimiter] The delimiter
	 * @returns {string} color
	 */
	function colorspace(namespace, delimiter) {
	  const split = namespace.split(delimiter || ':');
	  let base = hex(split[0]);
	  if (!split.length) return base;
	  for (let i = 0, l = split.length - 1; i < l; i++) {
	    base = Color(base).mix(Color(hex(split[i + 1]))).saturate(1).hex();
	  }
	  return base;
	}

	index_cjs = colorspace;
	return index_cjs;
}

var namespace;
var hasRequiredNamespace;

function requireNamespace () {
	if (hasRequiredNamespace) return namespace;
	hasRequiredNamespace = 1;
	var colorspace = requireIndex_cjs();

	/**
	 * Prefix the messages with a colored namespace.
	 *
	 * @param {Array} messages The messages array that is getting written.
	 * @param {Object} options Options for diagnostics.
	 * @returns {Array} Altered messages array.
	 * @public
	 */
	namespace = function colorNamespace(args, options) {
	  var namespace = options.namespace;

	  if (options.colors === false) {
	    args[0] = namespace +': '+ args[0];
	    return args;
	  }

	  var color = colorspace(namespace);

	  //
	  // The console API supports a special %c formatter in browsers. This is used
	  // to style console messages with any CSS styling, in our case we want to
	  // use colorize the namespace for clarity. As these are formatters, and
	  // we need to inject our CSS string as second messages argument so it
	  // gets picked up correctly.
	  //
	  args[0] = '%c'+ namespace +':%c '+ args[0];
	  args.splice(1, 0, 'color:'+ color, 'color:inherit');

	  return args;
	};
	return namespace;
}

var enabled;
var hasRequiredEnabled;

function requireEnabled () {
	if (hasRequiredEnabled) return enabled;
	hasRequiredEnabled = 1;

	/**
	 * Checks if a given namespace is allowed by the given variable.
	 *
	 * @param {String} name namespace that should be included.
	 * @param {String} variable Value that needs to be tested.
	 * @returns {Boolean} Indication if namespace is enabled.
	 * @public
	 */
	enabled = function enabled(name, variable) {
	  if (!variable) return false;

	  var variables = variable.split(/[\s,]+/)
	    , i = 0;

	  for (; i < variables.length; i++) {
	    variable = variables[i].replace('*', '.*?');

	    if ('-' === variable.charAt(0)) {
	      if ((new RegExp('^'+ variable.substr(1) +'$')).test(name)) {
	        return false;
	      }

	      continue;
	    }

	    if ((new RegExp('^'+ variable +'$')).test(name)) {
	      return true;
	    }
	  }

	  return false;
	};
	return enabled;
}

var adapters;
var hasRequiredAdapters;

function requireAdapters () {
	if (hasRequiredAdapters) return adapters;
	hasRequiredAdapters = 1;
	var enabled = requireEnabled();

	/**
	 * Creates a new Adapter.
	 *
	 * @param {Function} fn Function that returns the value.
	 * @returns {Function} The adapter logic.
	 * @public
	 */
	adapters = function create(fn) {
	  return function adapter(namespace) {
	    try {
	      return enabled(namespace, fn());
	    } catch (e) { /* Any failure means that we found nothing */ }

	    return false;
	  };
	};
	return adapters;
}

var localstorage;
var hasRequiredLocalstorage;

function requireLocalstorage () {
	if (hasRequiredLocalstorage) return localstorage;
	hasRequiredLocalstorage = 1;
	var adapter = requireAdapters();

	/**
	 * Extracts the values from process.env.
	 *
	 * @type {Function}
	 * @public
	 */
	localstorage = adapter(function storage() {
	  return localStorage.getItem('debug') || localStorage.getItem('diagnostics');
	});
	return localstorage;
}

var hash;
var hasRequiredHash;

function requireHash () {
	if (hasRequiredHash) return hash;
	hasRequiredHash = 1;
	var adapter = requireAdapters();

	/**
	 * Extracts the values from process.env.
	 *
	 * @type {Function}
	 * @public
	 */
	hash = adapter(function hash() {
	  return /(debug|diagnostics)=([^&]+)/i.exec(window.location.hash)[2];
	});
	return hash;
}

/**
 * An idiot proof logger to be used as default. We've wrapped it in a try/catch
 * statement to ensure the environments without the `console` API do not crash
 * as well as an additional fix for ancient browsers like IE8 where the
 * `console.log` API doesn't have an `apply`, so we need to use the Function's
 * apply functionality to apply the arguments.
 *
 * @param {Object} meta Options of the logger.
 * @param {Array} messages The actuall message that needs to be logged.
 * @public
 */

var console_1;
var hasRequiredConsole;

function requireConsole () {
	if (hasRequiredConsole) return console_1;
	hasRequiredConsole = 1;
	console_1 = function (meta, messages) {
	  //
	  // So yea. IE8 doesn't have an apply so we need a work around to puke the
	  // arguments in place.
	  //
	  try { Function.prototype.apply.call(console.log, console, messages); }
	  catch (e) {}
	};
	return console_1;
}

var development;
var hasRequiredDevelopment;

function requireDevelopment () {
	if (hasRequiredDevelopment) return development;
	hasRequiredDevelopment = 1;
	var create = requireDiagnostics();

	/**
	 * Create a new diagnostics logger.
	 *
	 * @param {String} namespace The namespace it should enable.
	 * @param {Object} options Additional options.
	 * @returns {Function} The logger.
	 * @public
	 */
	var diagnostics = create(function dev(namespace, options) {
	  options = options || {};
	  options.namespace = namespace;
	  options.prod = false;
	  options.dev = true;

	  if (!dev.enabled(namespace) && !(options.force || dev.force)) {
	    return dev.nope(options);
	  }

	  return dev.yep(options);
	});

	//
	// Configure the logger for the given environment.
	//
	diagnostics.modify(requireNamespace());
	diagnostics.use(requireLocalstorage());
	diagnostics.use(requireHash());
	diagnostics.set(requireConsole());

	//
	// Expose the diagnostics logger.
	//
	development = diagnostics;
	return development;
}

var hasRequiredBrowser$2;

function requireBrowser$2 () {
	if (hasRequiredBrowser$2) return browser$2.exports;
	hasRequiredBrowser$2 = 1;
	//
	// Select the correct build version depending on the environment.
	//
	if (process.env.NODE_ENV === 'production') {
	  browser$2.exports = requireProduction();
	} else {
	  browser$2.exports = requireDevelopment();
	}
	return browser$2.exports;
}

/**
 * tail-file.js: TODO: add file header description.
 *
 * (C) 2010 Charlie Robbins
 * MIT LICENCE
 */

var tailFile;
var hasRequiredTailFile;

function requireTailFile () {
	if (hasRequiredTailFile) return tailFile;
	hasRequiredTailFile = 1;

	var fs = fs__default;
	var _require = require$$1$1,
	  StringDecoder = _require.StringDecoder;
	var _require2 = requireReadableBrowser$1(),
	  Stream = _require2.Stream;

	/**
	 * Simple no-op function.
	 * @returns {undefined}
	 */
	function noop() {}

	/**
	 * TODO: add function description.
	 * @param {Object} options - Options for tail.
	 * @param {function} iter - Iterator function to execute on every line.
	* `tail -f` a file. Options must include file.
	 * @returns {mixed} - TODO: add return description.
	 */
	tailFile = function (options, iter) {
	  var buffer = Buffer.alloc(64 * 1024);
	  var decode = new StringDecoder('utf8');
	  var stream = new Stream();
	  var buff = '';
	  var pos = 0;
	  var row = 0;
	  if (options.start === -1) {
	    delete options.start;
	  }
	  stream.readable = true;
	  stream.destroy = function () {
	    stream.destroyed = true;
	    stream.emit('end');
	    stream.emit('close');
	  };
	  fs.open(options.file, 'a+', '0644', function (err, fd) {
	    if (err) {
	      if (!iter) {
	        stream.emit('error', err);
	      } else {
	        iter(err);
	      }
	      stream.destroy();
	      return;
	    }
	    (function read() {
	      if (stream.destroyed) {
	        fs.close(fd, noop);
	        return;
	      }
	      return fs.read(fd, buffer, 0, buffer.length, pos, function (error, bytes) {
	        if (error) {
	          if (!iter) {
	            stream.emit('error', error);
	          } else {
	            iter(error);
	          }
	          stream.destroy();
	          return;
	        }
	        if (!bytes) {
	          if (buff) {
	            // eslint-disable-next-line eqeqeq
	            if (options.start == null || row > options.start) {
	              if (!iter) {
	                stream.emit('line', buff);
	              } else {
	                iter(null, buff);
	              }
	            }
	            row++;
	            buff = '';
	          }
	          return setTimeout(read, 1000);
	        }
	        var data = decode.write(buffer.slice(0, bytes));
	        if (!iter) {
	          stream.emit('data', data);
	        }
	        data = (buff + data).split(/\n+/);
	        var l = data.length - 1;
	        var i = 0;
	        for (; i < l; i++) {
	          // eslint-disable-next-line eqeqeq
	          if (options.start == null || row > options.start) {
	            if (!iter) {
	              stream.emit('line', data[i]);
	            } else {
	              iter(null, data[i]);
	            }
	          }
	          row++;
	        }
	        buff = data[l];
	        pos += bytes;
	        return read();
	      });
	    })();
	  });
	  if (!iter) {
	    return stream;
	  }
	  return stream.destroy;
	};
	return tailFile;
}

/* eslint-disable complexity,max-statements */

var file;
var hasRequiredFile;

function requireFile () {
	if (hasRequiredFile) return file;
	hasRequiredFile = 1;
	function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
	function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
	function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
	function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), Object.defineProperty(e, "prototype", { writable: false }), e; }
	function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
	function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return (String )(t); }
	function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
	function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
	function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
	function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
	function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
	function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: true, configurable: true } }), Object.defineProperty(t, "prototype", { writable: false }), e && _setPrototypeOf(t, e); }
	function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
	var fs = fs__default;
	var path = path__default;
	var asyncSeries = requireSeries();
	var zlib = require$$1$2;
	var _require = requireTripleBeam(),
	  MESSAGE = _require.MESSAGE;
	var _require2 = requireReadableBrowser$1(),
	  Stream = _require2.Stream,
	  PassThrough = _require2.PassThrough;
	var TransportStream = requireDist();
	var debug = requireBrowser$2()('winston:file');
	var os = os__default;
	var tailFile = requireTailFile();

	/**
	 * Transport for outputting to a local log file.
	 * @type {File}
	 * @extends {TransportStream}
	 */
	file = /*#__PURE__*/function (_TransportStream) {
	  /**
	   * Constructor function for the File transport object responsible for
	   * persisting log messages and metadata to one or more files.
	   * @param {Object} options - Options for this instance.
	   */
	  function File() {
	    var _this;
	    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    _classCallCheck(this, File);
	    _this = _callSuper(this, File, [options]);

	    // Expose the name of this Transport on the prototype.
	    _this.name = options.name || 'file';

	    // Helper function which throws an `Error` in the event that any of the
	    // rest of the arguments is present in `options`.
	    function throwIf(target) {
	      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	        args[_key - 1] = arguments[_key];
	      }
	      args.slice(1).forEach(function (name) {
	        if (options[name]) {
	          throw new Error("Cannot set ".concat(name, " and ").concat(target, " together"));
	        }
	      });
	    }

	    // Setup the base stream that always gets piped to to handle buffering.
	    _this._stream = new PassThrough();
	    _this._stream.setMaxListeners(30);

	    // Bind this context for listener methods.
	    _this._onError = _this._onError.bind(_this);
	    if (options.filename || options.dirname) {
	      throwIf('filename or dirname', 'stream');
	      _this._basename = _this.filename = options.filename ? path.basename(options.filename) : 'winston.log';
	      _this.dirname = options.dirname || path.dirname(options.filename);
	      _this.options = options.options || {
	        flags: 'a'
	      };
	    } else if (options.stream) {
	      // eslint-disable-next-line no-console
	      console.warn('options.stream will be removed in winston@4. Use winston.transports.Stream');
	      throwIf('stream', 'filename', 'maxsize');
	      _this._dest = _this._stream.pipe(_this._setupStream(options.stream));
	      _this.dirname = path.dirname(_this._dest.path);
	      // We need to listen for drain events when write() returns false. This
	      // can make node mad at times.
	    } else {
	      throw new Error('Cannot log to file without filename or stream.');
	    }
	    _this.maxsize = options.maxsize || null;
	    _this.rotationFormat = options.rotationFormat || false;
	    _this.zippedArchive = options.zippedArchive || false;
	    _this.maxFiles = options.maxFiles || null;
	    _this.eol = typeof options.eol === 'string' ? options.eol : os.EOL;
	    _this.tailable = options.tailable || false;
	    _this.lazy = options.lazy || false;

	    // Internal state variables representing the number of files this instance
	    // has created and the current size (in bytes) of the current logfile.
	    _this._size = 0;
	    _this._pendingSize = 0;
	    _this._created = 0;
	    _this._drain = false;
	    _this._opening = false;
	    _this._ending = false;
	    _this._fileExist = false;
	    if (_this.dirname) _this._createLogDirIfNotExist(_this.dirname);
	    if (!_this.lazy) _this.open();
	    return _this;
	  }
	  _inherits(File, _TransportStream);
	  return _createClass(File, [{
	    key: "finishIfEnding",
	    value: function finishIfEnding() {
	      var _this2 = this;
	      if (this._ending) {
	        if (this._opening) {
	          this.once('open', function () {
	            _this2._stream.once('finish', function () {
	              return _this2.emit('finish');
	            });
	            setImmediate(function () {
	              return _this2._stream.end();
	            });
	          });
	        } else {
	          this._stream.once('finish', function () {
	            return _this2.emit('finish');
	          });
	          setImmediate(function () {
	            return _this2._stream.end();
	          });
	        }
	      }
	    }

	    /**
	     * Core logging method exposed to Winston. Metadata is optional.
	     * @param {Object} info - TODO: add param description.
	     * @param {Function} callback - TODO: add param description.
	     * @returns {undefined}
	     */
	  }, {
	    key: "log",
	    value: function log(info) {
	      var _this3 = this;
	      var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};
	      // Remark: (jcrugzz) What is necessary about this callback(null, true) now
	      // when thinking about 3.x? Should silent be handled in the base
	      // TransportStream _write method?
	      if (this.silent) {
	        callback();
	        return true;
	      }

	      // Output stream buffer is full and has asked us to wait for the drain event
	      if (this._drain) {
	        this._stream.once('drain', function () {
	          _this3._drain = false;
	          _this3.log(info, callback);
	        });
	        return;
	      }
	      if (this._rotate) {
	        this._stream.once('rotate', function () {
	          _this3._rotate = false;
	          _this3.log(info, callback);
	        });
	        return;
	      }
	      if (this.lazy) {
	        if (!this._fileExist) {
	          if (!this._opening) {
	            this.open();
	          }
	          this.once('open', function () {
	            _this3._fileExist = true;
	            _this3.log(info, callback);
	            return;
	          });
	          return;
	        }
	        if (this._needsNewFile(this._pendingSize)) {
	          this._dest.once('close', function () {
	            if (!_this3._opening) {
	              _this3.open();
	            }
	            _this3.once('open', function () {
	              _this3.log(info, callback);
	              return;
	            });
	            return;
	          });
	          return;
	        }
	      }

	      // Grab the raw string and append the expected EOL.
	      var output = "".concat(info[MESSAGE]).concat(this.eol);
	      var bytes = Buffer.byteLength(output);

	      // After we have written to the PassThrough check to see if we need
	      // to rotate to the next file.
	      //
	      // Remark: This gets called too early and does not depict when data
	      // has been actually flushed to disk.
	      function logged() {
	        var _this4 = this;
	        this._size += bytes;
	        this._pendingSize -= bytes;
	        debug('logged %s %s', this._size, output);
	        this.emit('logged', info);

	        // Do not attempt to rotate files while rotating
	        if (this._rotate) {
	          return;
	        }

	        // Do not attempt to rotate files while opening
	        if (this._opening) {
	          return;
	        }

	        // Check to see if we need to end the stream and create a new one.
	        if (!this._needsNewFile()) {
	          return;
	        }
	        if (this.lazy) {
	          this._endStream(function () {
	            _this4.emit('fileclosed');
	          });
	          return;
	        }

	        // End the current stream, ensure it flushes and create a new one.
	        // This could potentially be optimized to not run a stat call but its
	        // the safest way since we are supporting `maxFiles`.
	        this._rotate = true;
	        this._endStream(function () {
	          return _this4._rotateFile();
	        });
	      }

	      // Keep track of the pending bytes being written while files are opening
	      // in order to properly rotate the PassThrough this._stream when the file
	      // eventually does open.
	      this._pendingSize += bytes;
	      if (this._opening && !this.rotatedWhileOpening && this._needsNewFile(this._size + this._pendingSize)) {
	        this.rotatedWhileOpening = true;
	      }
	      var written = this._stream.write(output, logged.bind(this));
	      if (!written) {
	        this._drain = true;
	        this._stream.once('drain', function () {
	          _this3._drain = false;
	          callback();
	        });
	      } else {
	        callback(); // eslint-disable-line callback-return
	      }
	      debug('written', written, this._drain);
	      this.finishIfEnding();
	      return written;
	    }

	    /**
	     * Query the transport. Options object is optional.
	     * @param {Object} options - Loggly-like query options for this instance.
	     * @param {function} callback - Continuation to respond to when complete.
	     * TODO: Refactor me.
	     */
	  }, {
	    key: "query",
	    value: function query(options, callback) {
	      if (typeof options === 'function') {
	        callback = options;
	        options = {};
	      }
	      options = normalizeQuery(options);
	      var file = path.join(this.dirname, this.filename);
	      var buff = '';
	      var results = [];
	      var row = 0;
	      var stream = fs.createReadStream(file, {
	        encoding: 'utf8'
	      });
	      stream.on('error', function (err) {
	        if (stream.readable) {
	          stream.destroy();
	        }
	        if (!callback) {
	          return;
	        }
	        return err.code !== 'ENOENT' ? callback(err) : callback(null, results);
	      });
	      stream.on('data', function (data) {
	        data = (buff + data).split(/\n+/);
	        var l = data.length - 1;
	        var i = 0;
	        for (; i < l; i++) {
	          if (!options.start || row >= options.start) {
	            add(data[i]);
	          }
	          row++;
	        }
	        buff = data[l];
	      });
	      stream.on('close', function () {
	        if (buff) {
	          add(buff, true);
	        }
	        if (options.order === 'desc') {
	          results = results.reverse();
	        }

	        // eslint-disable-next-line callback-return
	        if (callback) callback(null, results);
	      });
	      function add(buff, attempt) {
	        try {
	          var log = JSON.parse(buff);
	          if (check(log)) {
	            push(log);
	          }
	        } catch (e) {
	          if (!attempt) {
	            stream.emit('error', e);
	          }
	        }
	      }
	      function push(log) {
	        if (options.rows && results.length >= options.rows && options.order !== 'desc') {
	          if (stream.readable) {
	            stream.destroy();
	          }
	          return;
	        }
	        if (options.fields) {
	          log = options.fields.reduce(function (obj, key) {
	            obj[key] = log[key];
	            return obj;
	          }, {});
	        }
	        if (options.order === 'desc') {
	          if (results.length >= options.rows) {
	            results.shift();
	          }
	        }
	        results.push(log);
	      }
	      function check(log) {
	        if (!log) {
	          return;
	        }
	        if (_typeof(log) !== 'object') {
	          return;
	        }
	        var time = new Date(log.timestamp);
	        if (options.from && time < options.from || options.until && time > options.until || options.level && options.level !== log.level) {
	          return;
	        }
	        return true;
	      }
	      function normalizeQuery(options) {
	        options = options || {};

	        // limit
	        options.rows = options.rows || options.limit || 10;

	        // starting row offset
	        options.start = options.start || 0;

	        // now
	        options.until = options.until || new Date();
	        if (_typeof(options.until) !== 'object') {
	          options.until = new Date(options.until);
	        }

	        // now - 24
	        options.from = options.from || options.until - 24 * 60 * 60 * 1000;
	        if (_typeof(options.from) !== 'object') {
	          options.from = new Date(options.from);
	        }

	        // 'asc' or 'desc'
	        options.order = options.order || 'desc';
	        return options;
	      }
	    }

	    /**
	     * Returns a log stream for this transport. Options object is optional.
	     * @param {Object} options - Stream options for this instance.
	     * @returns {Stream} - TODO: add return description.
	     * TODO: Refactor me.
	     */
	  }, {
	    key: "stream",
	    value: function stream() {
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var file = path.join(this.dirname, this.filename);
	      var stream = new Stream();
	      var tail = {
	        file: file,
	        start: options.start
	      };
	      stream.destroy = tailFile(tail, function (err, line) {
	        if (err) {
	          return stream.emit('error', err);
	        }
	        try {
	          stream.emit('data', line);
	          line = JSON.parse(line);
	          stream.emit('log', line);
	        } catch (e) {
	          stream.emit('error', e);
	        }
	      });
	      return stream;
	    }

	    /**
	     * Checks to see the filesize of.
	     * @returns {undefined}
	     */
	  }, {
	    key: "open",
	    value: function open() {
	      var _this5 = this;
	      // If we do not have a filename then we were passed a stream and
	      // don't need to keep track of size.
	      if (!this.filename) return;
	      if (this._opening) return;
	      this._opening = true;

	      // Stat the target file to get the size and create the stream.
	      this.stat(function (err, size) {
	        if (err) {
	          return _this5.emit('error', err);
	        }
	        debug('stat done: %s { size: %s }', _this5.filename, size);
	        _this5._size = size;
	        _this5._dest = _this5._createStream(_this5._stream);
	        _this5._opening = false;
	        _this5.once('open', function () {
	          if (!_this5._stream.emit('rotate')) {
	            _this5._rotate = false;
	          }
	        });
	      });
	    }

	    /**
	     * Stat the file and assess information in order to create the proper stream.
	     * @param {function} callback - TODO: add param description.
	     * @returns {undefined}
	     */
	  }, {
	    key: "stat",
	    value: function stat(callback) {
	      var _this6 = th