function getBridge() {
  const bridge = globalThis.__NAPCAT_BRIDGE__;
  if (!bridge) throw new Error('[QCE Overlay] Bridge未初始化');
  return bridge;
}

export const FileApi = {
  async downloadMedia(msgId, chatType, peerUid, elementId, thumbPath, sourcePath, timeout, force) {
    const { core } = getBridge();
    const impl = core?.apis?.FileApi?.downloadMedia || core?.apis?.file?.downloadMedia;
    if (!impl) throw new Error('[QCE Overlay] FileApi.downloadMedia 不可用');
    return impl.call(core.apis.FileApi || core.apis.file, msgId, chatType, peerUid, elementId, thumbPath, sourcePath, timeout, force);
  }
};

export const NTQQFileApi = FileApi;
export default FileApi;
