function getBridge() {
  const bridge = globalThis.__NAPCAT_BRIDGE__;
  if (!bridge) throw new Error('[QCE Overlay] Bridge未初始化');
  return bridge;
}

export const UserApi = {
  async getUserDetailInfo(uid, noCache = false) {
    const { core } = getBridge();
    const impl = core?.apis?.UserApi?.getUserDetailInfo || core?.apis?.user?.getUserDetailInfo;
    if (impl) return impl.call(core.apis.UserApi || core.apis.user, uid, noCache);
    
    const { actions, instance } = getBridge();
    const handler = actions?.get?.('get_stranger_info');
    if (!handler) throw new Error('[QCE Overlay] get_stranger_info 不可用');
    const result = await handler.handle({ user_id: Number(uid) }, 'plugin', instance?.config);
    return result?.data;
  },

  async getRecentContactListSnapShot(count = 100) {
    const { core } = getBridge();
    const impl = core?.apis?.UserApi?.getRecentContactListSnapShot || core?.apis?.user?.getRecentContactListSnapShot;
    if (!impl) throw new Error('[QCE Overlay] UserApi.getRecentContactListSnapShot 不可用');
    return impl.call(core.apis.UserApi || core.apis.user, count);
  }
};

export const NTQQUserApi = UserApi;
export default UserApi;
