function getBridge() {
  const bridge = globalThis.__NAPCAT_BRIDGE__;
  if (!bridge) throw new Error('[QCE Overlay] Bridge未初始化');
  return bridge;
}

import { MsgApi } from './apis/msg.js';
import { FileApi } from './apis/file.js';
import { GroupApi } from './apis/group.js';
import { UserApi } from './apis/user.js';
import { FriendApi } from './apis/friend.js';

export class NapCatCore {
  constructor() {
    const { core } = getBridge();
    if (!core) throw new Error('[QCE Overlay] NapCatCore实例不可用');
    
    this.apis = { MsgApi, FileApi, GroupApi, UserApi, FriendApi };
    this.context = {
      logger: {
        log: (...args) => core.context?.logger?.log?.(...args) || console.log('[QCE]', ...args),
        logError: (...args) => core.context?.logger?.logError?.(...args) || console.error('[QCE]', ...args),
        logWarn: (...args) => core.context?.logger?.logWarn?.(...args) || console.warn('[QCE]', ...args),
        logDebug: (...args) => core.context?.logger?.logDebug?.(...args) || console.debug('[QCE]', ...args)
      },
      session: core.context?.session
    };
    
    Object.defineProperty(this, 'selfInfo', { get() { return core.selfInfo; } });
  }
}

export { ChatType, ElementType, NTMsgType, RawMessage, MessageElement } from './types.js';

export class Peer {
  constructor(chatType, peerUid, guildId = '') {
    this.chatType = chatType;
    this.peerUid = peerUid;
    this.guildId = guildId;
  }
}

export default NapCatCore;
