/*
 * Decompiled with CFR 0.152.
 */
package newhorizon;

import arc.Core;
import arc.scene.Element;
import arc.scene.actions.RunnableAction;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Dialog;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.graphics.Pal;
import mindustry.ui.dialogs.BaseDialog;
import newhorizon.content.NHContent;

public class NHSetting {
    public static final String START_LOG = "nh-hide-starting-log";
    public static final String EFFECT_DETAIL = "nh-effect-detail";
    public static final String OVERRIDE_UNIT_SHIELD = "nh-override-unit-shield";
    public static final String OVERRIDE_CORE_UNIT = "nh-override-core-unit";
    public static final String OVERRIDE_LOGISTIC = "nh-override-logistic";
    public static final String OVERRIDE_DRILL = "nh-override-drill";
    public static final String OVERRIDE_FACTORIES = "nh-override-factories";
    public static final String OVERRIDE_POWER = "nh-override-power";
    public static final String OVERRIDE_UNIT = "nh-override-unit";
    public static final String OVERRIDE_LOGIC = "nh-override-logic";
    public static final String OVERRIDE_ITEM = "nh-override-item";
    public static final String OVERRIDE_TURRET = "nh-override-turret";
    public static final String EVENT_RAID = "nh-event-raid";
    public static final String DEBUGGING = "nh-debugging";
    public static final String DEBUG_PANEL = "nh-debug-panel";
    public static boolean enableEffectDetail = true;
    public static boolean changed = false;
    public static OrderedMap<String, Seq<SettingKey<?>>> allSettings = new OrderedMap();

    public static String overrideStatus() {
        StringBuilder overrideStatus = new StringBuilder();
        ((Seq)allSettings.get((Object)"override")).each(setting -> overrideStatus.append(setting.key).append(":").append(NHSetting.getBool(setting.key)).append("|"));
        return overrideStatus.toString();
    }

    public static void load() {
        allSettings.put((Object)"graphic", (Object)Seq.with((Object[])new SettingKey[]{new BoolSetting(START_LOG, false, false), new BoolSetting(EFFECT_DETAIL, true, true)}));
        allSettings.put((Object)"override", (Object)Seq.with((Object[])new SettingKey[]{new BoolSetting(OVERRIDE_UNIT_SHIELD, false, true), new BoolSetting(OVERRIDE_CORE_UNIT, false, true), new BoolSetting(OVERRIDE_LOGISTIC, false, true), new BoolSetting(OVERRIDE_DRILL, false, true), new BoolSetting(OVERRIDE_FACTORIES, false, true), new BoolSetting(OVERRIDE_POWER, false, true), new BoolSetting(OVERRIDE_UNIT, false, true), new BoolSetting(OVERRIDE_LOGIC, false, true), new BoolSetting(OVERRIDE_ITEM, false, true), new BoolSetting(OVERRIDE_TURRET, false, true)}));
        allSettings.put((Object)"event", (Object)Seq.with((Object[])new SettingKey[]{new BoolSetting(EVENT_RAID, false, true)}));
        allSettings.put((Object)"debug", (Object)Seq.with((Object[])new SettingKey[]{new BoolSetting(DEBUGGING, false, true), new BoolSetting(DEBUG_PANEL, false, true)}));
        allSettings.each((name, seq) -> seq.each(SettingKey::setDefault));
        if (Vars.headless) {
            ((Seq)allSettings.get((Object)"override")).each(setting -> Core.settings.put(setting.key, (Object)true));
            ((Seq)allSettings.get((Object)"event")).each(setting -> Core.settings.put(setting.key, (Object)true));
        }
        enableEffectDetail = NHSetting.getBool(EFFECT_DETAIL);
    }

    public static void loadUI() {
        Vars.ui.settings.addCategory("@mod.ui.nh-extra-menu", (Drawable)new TextureRegionDrawable(NHContent.icon), NHSetting::buildTable);
    }

    public static void update() {
        enableEffectDetail = NHSetting.getBool(EFFECT_DETAIL);
    }

    public static void buildTable(Table table) {
        ((ScrollPane)table.pane(t -> allSettings.each((category, settings) -> {
            t.label(() -> Core.bundle.get("nh.setting." + category)).row();
            t.image().color(Pal.accent).size(0.0f, 4.0f).growX().pad(4.0f).row();
            settings.each(settingKey -> settingKey.buildTable((Table)t));
        })).margin(60.0f).get()).setForceScroll(false, true);
    }

    public static void showDialog() {
        BaseDialog dialog = new BaseDialog("@nh.setting"){

            public void hide() {
                super.hide();
                if (changed) {
                    Vars.ui.showConfirm("@mods.reloadexit", () -> Core.app.exit());
                }
            }
        };
        NHSetting.buildTable(dialog.cont);
        dialog.addCloseButton();
        dialog.show();
    }

    public static boolean enableDetails() {
        return enableEffectDetail;
    }

    public static boolean getBool(String key) {
        return Core.settings.getBool(key);
    }

    public static abstract class SettingKey<T> {
        public final String key;
        public boolean requireReload = false;

        public SettingKey(String key) {
            this.key = key;
        }

        public abstract T getValue();

        public abstract void setDefault();

        public abstract void buildTable(Table var1);
    }

    public static class BoolSetting
    extends SettingKey<Boolean> {
        public boolean def;

        public BoolSetting(String key, boolean def, boolean requireReload) {
            super(key);
            this.def = def;
            this.requireReload = requireReload;
        }

        @Override
        public Boolean getValue() {
            return Core.settings.getBool(this.key);
        }

        @Override
        public void setDefault() {
            if (!Core.settings.has(this.key)) {
                Core.settings.put(this.key, (Object)this.def);
            }
        }

        @Override
        public void buildTable(Table table) {
            table.table(t -> {
                t.add((Element)new CheckBox(Core.bundle.get("nh.setting." + this.key + ".name")){
                    {
                        super(arg0);
                        this.changed(() -> {
                            Core.settings.put(key, (Object)this.isChecked());
                            if (requireReload) {
                                if (!changed) {
                                    Dialog.setHideAction(() -> new RunnableAction(){
                                        {
                                            this.setRunnable(() -> Vars.ui.showConfirm("@mods.reloadexit", () -> Core.app.exit()));
                                        }
                                    });
                                }
                                changed = true;
                            }
                        });
                        this.update(() -> this.setChecked(Core.settings.getBool(key)));
                    }
                }).padRight(6.0f).left();
                t.row().table(i -> {
                    i.left();
                    i.defaults().left();
                    i.add((CharSequence)("[lightgray]" + Core.bundle.get("nh.setting." + this.key + ".desc") + "[]")).padLeft(6.0f).wrap().width(Math.min((float)Core.graphics.getWidth() / 1.2f, 420.0f)).row();
                }).growX();
            }).growX().fillY().margin(8.0f).left().width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).row();
        }
    }
}

