/*
 * Decompiled with CFR 0.152.
 */
package newhorizon;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.util.CommandHandler;
import arc.util.Http;
import arc.util.Log;
import arc.util.OS;
import arc.util.Scaling;
import arc.util.Threads;
import arc.util.Time;
import arc.util.serialization.Jval;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.net.ServerGroup;
import mindustry.ui.Links;
import mindustry.ui.Styles;
import mindustry.ui.WarningBar;
import mindustry.ui.dialogs.BaseDialog;
import newhorizon.NHInputListener;
import newhorizon.NHRegister;
import newhorizon.NHSetting;
import newhorizon.NHUI;
import newhorizon.NHVars;
import newhorizon.content.NHBlocks;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHContent;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.content.NHLogic;
import newhorizon.content.NHPlanets;
import newhorizon.content.NHPostProcess;
import newhorizon.content.NHSectorPresents;
import newhorizon.content.NHShaders;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.content.NHTechTree;
import newhorizon.content.NHUnitTypes;
import newhorizon.content.NHWeathers;
import newhorizon.content.register.RecipeRegister;
import newhorizon.content.register.UnitRecipeRegister;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.util.DebugFunc;
import newhorizon.util.ui.TableFunc;
import newhorizon.util.ui.dialog.NewFeatureDialog;

public class NewHorizon
extends Mod {
    public static final boolean DEBUGGING_SPRITE = false;
    public static final String MOD_RELEASES = "https://github.com/Yuria-Shikibe/NewHorizonMod/releases";
    public static final String MOD_REPO = "Yuria-Shikibe/NewHorizonMod";
    public static final String MOD_GITHUB_URL = "https://github.com/Yuria-Shikibe/NewHorizonMod.git";
    public static final String MOD_NAME = "new-horizon";
    public static final String SERVER = "203.135.99.51:10094";
    public static boolean DEBUGGING = false;
    public static Mods.LoadedMod MOD;
    public static Links.LinkEntry[] links;
    private static boolean showed;

    public NewHorizon() {
        DEBUGGING = NHSetting.getBool("nh-debugging");
        NHInputListener.registerModBinding();
        Events.on(EventType.ContentInitEvent.class, e -> NHPostProcess.postProcessOverride());
        Events.on(EventType.PlayerConnect.class, e -> Call.clientPacketReliable((String)"override_check", (String)NHSetting.overrideStatus()));
        Events.on(EventType.ClientLoadEvent.class, e -> {
            Core.app.post(NHUI::init);
            this.updateServer();
            this.fetchNewRelease();
            this.showNewDialog();
            this.showStartLog();
            Time.run((float)60.0f, () -> {
                if (OS.username.equals("LaoHuaJi")) {
                    DebugFunc.updateBlockList();
                    DebugFunc.generateBlankBundle();
                    DebugFunc.writeVanillaBlockList();
                }
                DebugFunc.unlockModContent();
            });
        });
        if (!Vars.headless) {
            Vars.netClient.addPacketHandler("override_check", string -> {
                try {
                    String[] status = string.split("\\|");
                    boolean canConnect = true;
                    for (String s : status) {
                        String[] setting = s.split(":");
                        if (NHSetting.getBool(setting[0]) == Boolean.parseBoolean(setting[1])) continue;
                        canConnect = false;
                        break;
                    }
                    if (!canConnect) {
                        StringBuilder str = new StringBuilder();
                        for (String s : status) {
                            String[] setting = s.split(":");
                            boolean enabled = Boolean.parseBoolean(setting[1]);
                            if (NHSetting.getBool(setting[0]) == enabled) continue;
                            str.append(Core.bundle.get("nh.setting." + setting[0] + ".name")).append("\n");
                        }
                        Vars.ui.showConfirm(Core.bundle.format("mod.ui.require.need-override", new Object[]{str.toString()}), NHSetting::showDialog);
                        Vars.net.disconnect();
                    }
                }
                catch (Exception e) {
                    Log.err((Throwable)e);
                    Vars.net.disconnect();
                }
            });
        }
    }

    public static void debugLog(Object obj) {
        if (DEBUGGING) {
            Log.info((Object)obj);
        }
    }

    public static String name(String name) {
        return "new-horizon-" + name;
    }

    private static void showAbout() {
        if (links == null) {
            links = new Links.LinkEntry[]{new Links.LinkEntry("mod.discord", "https://discord.gg/yNmbMcuwyW", (Drawable)Icon.discord, Color.valueOf((String)"7289da")), new Links.LinkEntry("mod.github", MOD_GITHUB_URL, (Drawable)Icon.github, Color.valueOf((String)"24292e")), new Links.LinkEntry("yuria.plugin", "https://github.com/Yuria-Shikibe/RangeImager", (Drawable)Icon.export, NHColor.thurmixRed)};
        }
        BaseDialog dialog = new BaseDialog("@links");
        dialog.cont.pane(table -> {
            for (Links.LinkEntry entry : links) {
                TableFunc.link(table, entry);
            }
        }).grow().row();
        dialog.cont.button("@back", (Drawable)Icon.left, Styles.cleart, () -> ((BaseDialog)dialog).hide()).size(240.0f, 60.0f);
        dialog.addCloseListener();
        dialog.show();
    }

    public static void showNew() {
        NewFeatureDialog newFeatureDialog = new NewFeatureDialog();
        newFeatureDialog.show();
    }

    public static void startLog() {
        if (showed) {
            return;
        }
        showed = true;
        BaseDialog dialog = new BaseDialog(""){

            public void hide() {
                super.hide();
            }
        };
        dialog.cont.pane(inner -> {
            inner.pane(table -> {
                table.table(t -> t.image(NHContent.icon2).fill()).center().growX().fillY().row();
                table.image().fillX().height(4.3636365f).pad(4.0f).color(Color.white).row();
                table.pane(p -> p.add((CharSequence)"[white]<< Powered by New Horizon Mod >>", Styles.techLabel).row()).fillY().growX().row();
                table.image().fillX().height(4.3636365f).pad(4.0f).color(Color.white).row();
                table.add((CharSequence)"").row();
            }).growX().center().row();
            inner.table(table -> {
                if (!Vars.mobile) {
                    table.table(t -> {}).grow();
                }
                table.table(t -> {
                    t.button("@back", (Drawable)Icon.left, Styles.cleart, () -> ((BaseDialog)dialog).hide()).growX().height(60.0f).padLeft(12.0f).padRight(12.0f).row();
                    t.button("@links", (Drawable)Icon.link, Styles.cleart, NewHorizon::showAbout).growX().height(60.0f).padLeft(12.0f).padRight(12.0f).row();
                    t.button("@hide-setting", (Drawable)Icon.settings, Styles.cleart, () -> Core.settings.put("nh_hide_starting_log", (Object)true)).disabled(b -> Core.settings.getBool("nh_hide_starting_log", false)).growX().height(60.0f).padLeft(12.0f).padRight(12.0f).row();
                    t.button("@log", (Drawable)Icon.book, Styles.cleart, NewHorizon::showNew).growX().height(60.0f).padLeft(12.0f).padRight(12.0f).row();
                    t.button(Core.bundle.get("servers.remote") + "\n(" + Core.bundle.get("waves.copy") + ")", (Drawable)Icon.host, Styles.cleart, () -> Core.app.setClipboardText(SERVER)).growX().height(60.0f).padLeft(12.0f).padRight(12.0f).row();
                }).grow();
                if (!Vars.mobile) {
                    table.table(t -> {}).grow();
                }
            }).fill();
        }).grow();
        dialog.show();
    }

    public void init() {
        Events.on(EventType.ClientLoadEvent.class, e -> {
            if (Vars.netServer != null) {
                Vars.netServer.admins.addChatFilter((player, text) -> text.replace("jvav", "java"));
            }
            NHVars.init();
        });
    }

    public void registerClientCommands(CommandHandler handler) {
        super.registerClientCommands(handler);
        handler.register("js", "<code...>", "Execute JavaScript code.", (args, player) -> {
            if (player.admin) {
                String output = Vars.mods.getScripts().runConsole(args[0]);
                player.sendMessage("> " + (this.isError(output) ? "[#ff341c]" + output : output));
            } else {
                player.sendMessage("[scarlet]You must be admin to use this command.");
            }
        });
    }

    private boolean isError(String output) {
        try {
            String errorName = output.substring(0, output.indexOf(32) - 1);
            Class.forName("org.mozilla.javascript." + errorName);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void loadContent() {
        Time.mark();
        MOD = Vars.mods.getMod(((Object)((Object)this)).getClass());
        NewHorizon.MOD.meta.displayName = Core.bundle.get("mod.new-horizon.name");
        NewHorizon.MOD.meta.author = Core.bundle.get("mod.new-horizon.author");
        NewHorizon.MOD.meta.description = Core.bundle.get("mod.new-horizon.description");
        NewHorizon.MOD.meta.subtitle = Core.bundle.get("mod.new-horizon.subtitle");
        EntityRegister.load();
        NHRegister.load();
        NHContent.loadPriority();
        NHSounds.load();
        if (!Vars.headless) {
            NHShaders.init();
        }
        NHContent.loadBeforeContentLoad();
        NHStatusEffects.load();
        NHItems.load();
        NHLiquids.load();
        NHBullets.load();
        NHUnitTypes.load();
        NHBlocks.load();
        NHWeathers.load();
        NHPlanets.load();
        NHSectorPresents.load();
        NHTechTree.load();
        NHSetting.load();
        NHPostProcess.load();
        NHPostProcess.loadOptional();
        NHContent.loadLast();
        NHLogic.load();
        RecipeRegister.load();
        UnitRecipeRegister.load();
        Log.info((Object)("New Horizon Loaded Complete: " + NewHorizon.MOD.meta.version + " | Cost Time: " + Time.elapsed() / 60.0f + " sec."));
    }

    private void updateServer() {
        Vars.defaultServers.add((Object)new ServerGroup(){
            {
                this.name = "[sky]New Horizon [white]Mod [lightgray]Servers";
                this.addresses = new String[]{NewHorizon.SERVER};
            }
        });
    }

    private void fetchNewRelease() {
        if (!DEBUGGING) {
            Time.runTask((float)15.0f, () -> Threads.daemon(() -> Http.get((String)"https://api.github.com/repos/Yuria-Shikibe/NewHorizonMod/releases/latest", res -> {
                Jval json = Jval.read((String)res.getResultAsString());
                final String tag = json.get("tag_name").asString();
                final String body = json.get("body").asString();
                if (tag != null && body != null && !tag.equals(Core.settings.get("new-horizon-last-gh-release-tag", (Object)"0")) && !tag.equals('v' + NewHorizon.MOD.meta.version)) {
                    Core.app.post(() -> new BaseDialog(Core.bundle.get("mod.ui.has-new-update") + ": " + tag){
                        {
                            super(arg0);
                            this.cont.table(t -> {
                                t.add((Element)new WarningBar()).growX().height(30.0f).padLeft(-60.0f).padRight(-60.0f).padTop(60.0f).expandX().row();
                                t.image(NHContent.icon2).center().pad(12.0f).color(Pal.accent).scaling(Scaling.bounded).row();
                                t.add((Element)new WarningBar()).growX().height(30.0f).padLeft(-60.0f).padRight(-60.0f).padBottom(60.0f).expandX().row();
                                t.add((CharSequence)("\t[lightgray]Version: [accent]" + tag)).left().row();
                                t.image().growX().height(4.0f).pad(4.0f).row();
                                t.pane(c -> {
                                    c.align(10).margin(12.0f);
                                    c.add((CharSequence)("[accent]Description: \n[]" + body)).left();
                                }).grow();
                            }).grow().padBottom(12.0f).row();
                            this.cont.table(table -> {
                                table.button("@back", (Drawable)Icon.left, Styles.cleart, () -> (this).hide()).growX().height(60.0f);
                                table.button("@mods.github.open", (Drawable)Icon.github, Styles.cleart, () -> Core.app.openURI(NewHorizon.MOD_RELEASES)).growX().height(60.0f);
                            }).bottom().growX().height(60.0f).padTop(12.0f);
                            this.addCloseListener();
                        }
                    }.show());
                }
                if (tag != null) {
                    Core.settings.put("new-horizon-last-gh-release-tag", (Object)tag);
                }
            }, ex -> Log.err((String)ex.toString(), (Object[])new Object[0]))));
        }
    }

    private void showNewDialog() {
        Time.runTask((float)10.0f, () -> {
            if (!Core.settings.get("nh-lastver", (Object)-1).equals(NewHorizon.MOD.meta.version)) {
                NewHorizon.showNew();
            }
            Core.settings.put("nh-lastver", (Object)NewHorizon.MOD.meta.version);
        });
    }

    private void showStartLog() {
        if (!Core.settings.getBool("nh-hide-starting-log")) {
            Core.app.post((Runnable)Time.runTask((float)10.0f, NewHorizon::startLog));
        }
    }

    static {
        showed = false;
    }
}

