/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.pattern.ShootAlternate;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.pattern.ShootMulti;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.pattern.ShootSine;
import mindustry.entities.pattern.ShootSpread;
import mindustry.entities.pattern.ShootSummon;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.gen.Sounds;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.LaserTurret;
import mindustry.world.blocks.defense.turrets.PointDefenseTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.Prop;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.environment.SteamVent;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.LiquidSource;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.draw.DrawArcSmelt;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawCrucibleFlame;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawPlasma;
import mindustry.world.draw.DrawRegion;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.NHSetting;
import newhorizon.NewHorizon;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHContent;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.content.blocks.CraftingBlock;
import newhorizon.content.blocks.DefenseBlock;
import newhorizon.content.blocks.DistributionBlock;
import newhorizon.content.blocks.EnvironmentBlock;
import newhorizon.content.blocks.InnerBlock;
import newhorizon.content.blocks.LiquidBlock;
import newhorizon.content.blocks.LogicBlock;
import newhorizon.content.blocks.ModuleBlock;
import newhorizon.content.blocks.PayloadBlock;
import newhorizon.content.blocks.PowerBlock;
import newhorizon.content.blocks.ProductionBlock;
import newhorizon.content.blocks.SpecialBlock;
import newhorizon.content.blocks.TurretBlock;
import newhorizon.content.blocks.UnitBlock;
import newhorizon.expand.block.commandable.AirRaider;
import newhorizon.expand.block.commandable.BombLauncher;
import newhorizon.expand.block.commandable.CommandableAttackerBlock;
import newhorizon.expand.block.defence.FireExtinguisher;
import newhorizon.expand.block.defence.HyperSpaceWarper;
import newhorizon.expand.block.defence.ShockwaveGenerator;
import newhorizon.expand.block.drawer.ArcCharge;
import newhorizon.expand.block.special.HyperGenerator;
import newhorizon.expand.block.special.UnitSpawner;
import newhorizon.expand.block.turrets.MultTractorBeamTurret;
import newhorizon.expand.block.turrets.ShootMatchTurret;
import newhorizon.expand.block.turrets.Webber;
import newhorizon.expand.bullets.AccelBulletType;
import newhorizon.expand.bullets.AdaptedLightningBulletType;
import newhorizon.expand.bullets.AdaptedShootHelix;
import newhorizon.expand.bullets.ChainBulletType;
import newhorizon.expand.bullets.DelayedPointBulletType;
import newhorizon.expand.bullets.LightningLinkerBulletType;
import newhorizon.expand.bullets.TrailFadeBulletType;
import newhorizon.expand.game.NHPartProgress;
import newhorizon.expand.game.NHUnitSorts;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.EffectWrapper;
import newhorizon.util.graphic.OptionalMultiEffect;

public class NHBlocks {
    public static Block reinForcedItemSource;
    public static Block reinForcedLiquidSource;
    public static Block hyperGenerator;
    public static Block ancientArtillery;
    public static Block dendrite;
    public static Block interferon;
    public static Block prism;
    public static Block hive;
    public static Block bloodStar;
    public static Block blaster;
    public static Block endOfEra;
    public static Block railGun;
    public static Block executor;
    public static Block gravity;
    public static Block multipleLauncher;
    public static Block antibody;
    public static Block atomSeparator;
    public static Block eternity;
    public static Block largeWaterExtractor;
    public static Block antiBulletTurret;
    public static Block fireExtinguisher;
    public static Block webber;
    public static Block hyperspaceWarper;
    public static Block bombLauncher;
    public static Block airRaider;
    public static Block unitIniter;
    public static Block armorClear;
    public static Block quantumField;
    public static Block quantumFieldDeep;
    public static Block quantumFieldDisturbing;
    public static Block metalWall;
    public static Block metalWallQuantum;
    public static Block metalTower;
    public static Block metalGround;
    public static Block metalGroundQuantum;
    public static Block metalScarp;
    public static Block metalVent;
    public static Block metalGroundHeat;

    private static void loadEnv() {
        metalScarp = new Prop("metal-scrap"){
            {
                this.variants = 3;
                this.breakEffect = new Effect(23.0f, e -> {
                    float scl = Math.max(e.rotation, 1.0f);
                    Fx.rand.setSeed((long)e.id);
                    Angles.randLenVectors((long)e.id, (int)6, (float)(19.0f * e.finpow() * scl), (x, y) -> {
                        Draw.color((Color)Tmp.c1.set(e.color).mul(1.0f + Fx.rand.range(0.125f)));
                        Fill.square((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.5f * scl + 0.3f));
                    });
                }).layer(20.0f);
                this.breakSound = NHSounds.metalWalk;
            }
        };
        metalWall = new StaticWall("metal-unit-quantum"){
            {
                this.variants = 6;
            }
        };
        metalWallQuantum = new StaticWall("metal-unit"){
            {
                this.variants = 6;
            }
        };
        final Cons quantumSetter = f -> {
            f.wall = metalWall;
            f.attributes.set(Attribute.water, -1.0f);
            f.attributes.set(Attribute.oil, -1.0f);
            f.attributes.set(Attribute.heat, 0.0f);
            f.attributes.set(Attribute.light, 0.0f);
            f.attributes.set(Attribute.spores, -1.0f);
            f.walkSound = NHSounds.metalWalk;
            f.walkSoundVolume = 0.05f;
            f.speedMultiplier = 1.25f;
            f.decoration = metalScarp;
        };
        metalGroundHeat = new Floor("metal-ground-heat", 3){
            {
                this.wall = metalWall;
                this.attributes.set(NHContent.quantum, 1.0f);
                this.attributes.set(Attribute.water, -1.0f);
                this.attributes.set(Attribute.oil, -1.0f);
                this.attributes.set(Attribute.heat, 1.25f);
                this.attributes.set(Attribute.light, 1.0f);
                this.attributes.set(Attribute.spores, -1.0f);
                this.walkSound = NHSounds.metalWalk;
                this.walkSoundVolume = 0.05f;
                this.speedMultiplier = 1.25f;
                this.liquidMultiplier = 0.8f;
                this.liquidDrop = NHLiquids.quantumLiquid;
                this.lightColor = NHColor.darkEnrColor;
                this.emitLight = true;
                this.lightRadius = 35.0f;
                this.decoration = metalScarp;
            }
        };
        quantumField = new Floor("quantum-field", 8){
            {
                this.status = NHStatusEffects.quantization;
                this.statusDuration = 60.0f;
                this.speedMultiplier = 1.15f;
                this.liquidDrop = NHLiquids.quantumLiquid;
                this.liquidMultiplier = 0.25f;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.attributes.set(Attribute.light, 2.0f);
                this.emitLight = true;
                this.lightRadius = 32.0f;
                this.lightColor = NHColor.darkEnrColor.cpy().lerp(Color.black, 0.1f);
                this.blendGroup = this;
                this.attributes.set(NHContent.quantum, 0.25f);
                this.attributes.set(Attribute.heat, 0.05f);
                this.attributes.set(Attribute.water, -1.0f);
                this.attributes.set(Attribute.oil, -1.0f);
                this.attributes.set(Attribute.spores, -1.0f);
            }
        };
        quantumFieldDeep = new Floor("quantum-field-deep", 0){
            {
                this.drownTime = 180.0f;
                this.status = NHStatusEffects.quantization;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 1.3f;
                this.liquidDrop = NHLiquids.quantumLiquid;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.attributes.set(Attribute.light, 3.0f);
                this.emitLight = true;
                this.lightRadius = 40.0f;
                this.liquidMultiplier = 0.5f;
                this.lightColor = NHColor.darkEnrColor.cpy().lerp(Color.black, 0.2f);
                this.blendGroup = this;
                this.attributes.set(NHContent.quantum, 0.375f);
                this.attributes.set(Attribute.heat, 0.15f);
                this.attributes.set(Attribute.water, -1.0f);
                this.attributes.set(Attribute.oil, -1.0f);
                this.attributes.set(Attribute.spores, -1.0f);
            }
        };
        quantumFieldDisturbing = new Floor("quantum-field-disturbing", 0){
            {
                this.status = NHStatusEffects.quantization;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 1.3f;
                this.liquidDrop = NHLiquids.quantumLiquid;
                this.isLiquid = true;
                this.attributes.set(Attribute.light, 3.0f);
                this.emitLight = true;
                this.lightRadius = 40.0f;
                this.liquidMultiplier = 0.5f;
                this.lightColor = NHColor.darkEnrColor.cpy().lerp(Color.white, 0.2f);
                this.blendGroup = this;
                this.wall = metalWall;
                this.attributes.set(NHContent.quantum, 0.5f);
                this.attributes.set(Attribute.heat, 0.25f);
                this.attributes.set(Attribute.water, -1.0f);
                this.attributes.set(Attribute.oil, -1.0f);
                this.attributes.set(Attribute.spores, -1.0f);
                this.cacheLayer = NHContent.quantumLayer;
                this.details = "Has unique shader.";
            }

            public void load() {
                super.load();
                this.uiIcon = this.region = Core.atlas.find(NewHorizon.name("quantum-field-disturbing-icon"));
                this.fullIcon = this.region;
            }
        };
        metalTower = new StaticWall("metal-tower"){
            {
                this.variants = 3;
                this.layer = 36.0f;
            }
        };
        metalGround = new Floor("metal-ground", 6){
            {
                super(arg0, arg1);
                this.mapColor = Pal.darkerGray;
                quantumSetter.get((Object)this);
            }
        };
        metalVent = new SteamVent("metal-vent"){
            {
                this.variants = 2;
                this.parent = this.blendGroup = metalGround;
                this.attributes.set(NHContent.quantum, 1.0f);
                this.effectColor = Pal.darkerMetal;
                this.effect = new OptionalMultiEffect(new Effect(140.0f, e -> {
                    Draw.color((Color)e.color, (Color)NHColor.darkEnr, (float)(e.fin() * 0.86f));
                    Draw.alpha((float)(e.fslope() * 0.78f));
                    float length = 3.0f + e.finpow() * 10.0f;
                    Fx.rand.setSeed((long)e.id);
                    for (int i = 0; i < Fx.rand.random(3, 5); ++i) {
                        Fx.v.trns(Fx.rand.random(360.0f), Fx.rand.random(length));
                        Fill.circle((float)(e.x + Fx.v.x), (float)(e.y + Fx.v.y), (float)(Fx.rand.random(1.2f, 3.5f) + e.fslope() * 1.1f));
                    }
                }).layer(79.0f));
            }
        };
        metalGroundQuantum = new Floor("metal-ground-quantum", 2){
            {
                super(arg0, arg1);
                this.mapColor = Pal.darkerMetal;
                this.wall = metalWall;
                this.blendGroup = metalGround;
                this.attributes.set(Attribute.heat, 0.2f);
                quantumSetter.get((Object)this);
                this.wall = metalWallQuantum;
                this.emitLight = true;
                this.lightColor = NHColor.darkEnrColor;
                this.lightRadius = 4.4f;
            }

            public void load() {
                super.load();
                this.region = Core.atlas.find(NewHorizon.name("metal-ground1"));
            }
        };
    }

    private static void loadTurrets() {
        hive = new ShootMatchTurret("hive"){
            {
                Color heatC;
                this.size = 4;
                this.health = 3200;
                this.armor = 10.0f;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 300, NHItems.seniorProcessor, 60, NHItems.juniorProcessor, 120, NHItems.presstanium, 200, Items.graphite, 150}));
                this.outlineColor = Pal.darkOutline;
                this.warmupMaintainTime = 90.0f;
                this.shootWarmupSpeed /= 2.0f;
                this.reload = 150.0f;
                this.targetGround = false;
                this.range = 560.0f;
                this.trackingRange = this.range * 1.4f;
                this.xRand = 6.0f;
                this.velocityRnd = 0.105f;
                this.shootY = 8.0f;
                this.rotateSpeed = 3.0f;
                this.cooldownTime = 60.0f;
                this.recoil = 1.25f;
                this.heatColor = heatC = Pal.turretHeat.cpy().lerp(Color.red, 0.33f);
                this.shake = 1.1f;
                this.shootSound = Sounds.shootMissileLarge;
                this.shoot = new AdaptedShootHelix(){
                    {
                        this.flip = true;
                        this.shots = 10;
                        this.mag = 1.65f;
                        this.scl = 6.0f;
                        this.shotDelay = 3.5f;
                        this.offset = 61.26106f;
                        this.rotSpeedOffset = 0.015f;
                        this.rotSpeedBegin = 0.925f;
                    }
                };
                this.canOverdrive = true;
                this.ammo(new Object[]{NHItems.juniorProcessor, new AccelBulletType(5.2f, 75.0f, NHBullets.STRIKE){
                    {
                        super(speed, damage, bulletSprite);
                        this.width = 7.0f;
                        this.height = 13.0f;
                        this.shrinkY = 0.0f;
                        this.collidesTiles = false;
                        this.collidesGround = false;
                        this.collideFloor = false;
                        this.ammoMultiplier = 8.0f;
                        this.lightningColor = this.hitColor = Pal.bulletYellowBack;
                        this.backColor = this.hitColor;
                        this.lightColor = this.frontColor = Pal.bulletYellow;
                        this.splashDamageRadius = 12.0f;
                        this.splashDamage = this.damage / 3.0f;
                        this.despawnEffect = Fx.smoke;
                        this.hitEffect = NHFx.hitSpark;
                        this.lifetime = 100.0f;
                        this.lightningDamage = this.damage / 2.0f;
                        this.lightning = 2;
                        this.lightningLength = 3;
                        this.lightningLengthRand = 12;
                        this.status = NHStatusEffects.emp2;
                        this.statusDuration = 180.0f;
                        this.hitSound = this.despawnSound = Sounds.explosionDull;
                        this.hitSoundVolume = 0.6f;
                        this.hitSoundPitch -= 0.11f;
                        this.hitShake = 1.1f;
                        this.shootEffect = EffectWrapper.wrap(Fx.shootBigSmoke2, 180.0f, true);
                        this.smokeEffect = NHFx.hugeSmokeGray;
                        this.lightningType = NHBullets.lightningAir;
                        this.inaccuracy = 0.3f;
                        this.weaveMag = 3.0f;
                        this.weaveScale = 3.55f;
                        this.homingDelay = 5.0f;
                        this.homingPower = 0.25f;
                        this.homingRange = 160.0f;
                        this.velocityBegin = 1.4f;
                        this.velocityIncrease = 8.0f;
                        this.accelerateBegin = 0.005f;
                        this.accelerateEnd = 0.75f;
                        this.trailColor = NHColor.trail;
                        this.trailWidth = 1.0f;
                        this.trailLength = 15;
                    }
                }, NHItems.seniorProcessor, new AccelBulletType(5.2f, 200.0f, NHBullets.STRIKE){
                    {
                        super(speed, damage, bulletSprite);
                        this.width = 14.0f;
                        this.height = 28.0f;
                        this.shrinkY = 0.0f;
                        this.lightningType = NHBullets.lightningAir;
                        this.collidesTiles = false;
                        this.collidesGround = false;
                        this.collideFloor = false;
                        this.ammoMultiplier = 2.0f;
                        this.lightningColor = this.hitColor = Pal.bulletYellowBack;
                        this.backColor = this.hitColor;
                        this.lightColor = this.frontColor = Pal.bulletYellow;
                        this.splashDamageRadius = 64.0f;
                        this.splashDamage = this.damage / 5.0f;
                        this.scaledSplashDamage = true;
                        this.despawnEffect = NHFx.blast(this.backColor, 64.0f);
                        this.lifetime = 142.0f;
                        this.hitEffect = NHFx.subEffect(90.0f, 120.0f, 18, 60.0f, (Interp)Interp.pow2Out, (i, x, y, rot, fin) -> {
                            float fout = 1.0f - fin;
                            Draw.color((Color)this.hitColor, (Color)Color.white, (float)(fin * 0.7f));
                            float f = (float)NHFunc.rand(i).random(5, 8) * Mathf.curve((float)fin, (float)0.0f, (float)0.1f) * fout;
                            Fill.circle((float)x, (float)y, (float)f);
                            Drawf.light((float)x, (float)y, (float)(f * 1.25f), (Color)this.hitColor, (float)0.7f);
                        });
                        this.lightningDamage = this.damage / 2.0f;
                        this.lightning = 4;
                        this.lightningLength = 12;
                        this.lightningLengthRand = 18;
                        this.status = NHStatusEffects.emp3;
                        this.statusDuration = 640.0f;
                        this.rangeChange = 80.0f;
                        this.reloadMultiplier = 0.25f;
                        this.hitSound = this.despawnSound = Sounds.explosion;
                        this.despawnShake = 6.1f;
                        this.hitShake = 6.1f;
                        this.shootEffect = EffectWrapper.wrap(NHFx.circleSplash, this.hitColor);
                        this.smokeEffect = EffectWrapper.wrap(NHFx.missileShoot, Color.gray.cpy().a(0.84f));
                        this.inaccuracy = 0.3f;
                        this.weaveMag = 2.0f;
                        this.weaveScale = 8.0f;
                        this.homingDelay = 5.0f;
                        this.homingPower = 0.325f;
                        this.homingRange = 320.0f;
                        this.velocityBegin = 0.6f;
                        this.velocityIncrease = 6.0f;
                        this.accelerateBegin = 0.005f;
                        this.accelerateEnd = 0.75f;
                        this.trailColor = NHColor.trail;
                        this.trailWidth = 2.0f;
                        this.trailLength = 18;
                    }
                }});
                this.ammoPerShot = 4;
                this.maxAmmo = 120;
                AdaptedShootHelix shootS = (AdaptedShootHelix)this.shoot.copy();
                shootS.flip = false;
                shootS.shots = 4;
                shootS.shotDelay = 6.0f;
                shootS.mag /= 2.0f;
                shootS.scl *= 2.0f;
                shootS.offset = shootS.scl * ((float)Math.PI * 2);
                this.shooter(new Object[]{NHItems.juniorProcessor, this.shoot, NHItems.seniorProcessor, shootS});
                final float mainMoveX = 2.5f;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-barrel-main"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.moveX = mainMoveX;
                                this.heatColor = heatC;
                                this.heatLightOpacity = 0.86f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-charger"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.moveX = mainMoveX;
                                this.moves.add((Object)new DrawPart.PartMove(){
                                    {
                                        this.y = -1.0f;
                                        this.x = 1.0f;
                                        this.progress = DrawPart.PartProgress.warmup.compress(0.3f, 0.86f);
                                    }
                                });
                            }
                        });
                        this.parts.add((Object)new RegionPart("-back"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.moveX = mainMoveX;
                                this.moves.add((Object)new DrawPart.PartMove(){
                                    {
                                        this.y = -1.0f;
                                        this.x = 1.5f;
                                        this.progress = DrawPart.PartProgress.warmup.compress(0.4f, 0.95f);
                                    }
                                });
                            }
                        });
                    }
                };
                this.liquidCapacity = 120.0f;
                this.coolantMultiplier = 2.4f;
                this.coolant = new ConsumeLiquid(Liquids.water, 0.5f);
                this.squareSprite = false;
            }
        };
        prism = new ItemTurret("prism"){
            {
                this.size = 4;
                this.recoil = 2.0f;
                this.health = 6500;
                this.armor = 25.0f;
                this.unitSort = UnitSorts.strongest;
                this.outlineColor = Pal.darkOutline;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.irayrondPanel, 100, NHItems.seniorProcessor, 120, Items.tungsten, 350, NHItems.zeta, 500}));
                this.shootY = 4.0f;
                this.minWarmup = 0.9f;
                this.warmupMaintainTime = 25.0f;
                this.shootWarmupSpeed /= 2.0f;
                this.shootSound = Sounds.shootSmite;
                this.rotateSpeed = 1.1f;
                this.cooldownTime = 90.0f;
                this.squareSprite = false;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        heatColor = Color.red;
                        this.parts.add((Object)new RegionPart("-top"){
                            {
                                super(arg0);
                                this.turretShading = true;
                                this.under = true;
                                this.outlineLayerOffset = -0.0015f;
                                this.layerOffset = -0.0015f;
                                this.heatLayerOffset = -5.0E-4f;
                            }
                        }, (Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.heatColor = Color.red;
                                this.mirror = true;
                                this.layerOffset = 0.001f;
                                this.outlineLayerOffset = -0.0025f;
                                this.moveY = 1.0f;
                                this.moveX = 1.5f;
                                this.moveRot = 8.0f;
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.smoothReload, 0.5f);
                                this.children.add((Object)new RegionPart(""){
                                    {
                                        super(arg0);
                                        this.name = NewHorizon.name("prism-barrel-charger");
                                        this.mirror = true;
                                        this.layerOffset = 0.001f;
                                        this.outlineLayerOffset = -0.0025f;
                                        this.moveX = 0.75f;
                                        this.moveY = -0.75f;
                                        this.progress = DrawPart.PartProgress.warmup;
                                    }
                                });
                                this.progress = NHPartProgress.recoilWarmup;
                            }
                        });
                    }
                };
                this.reload = 420.0f;
                this.shootCone = 5.0f;
                this.ammoPerShot = 16;
                this.maxAmmo = 80;
                this.ammo(new Object[]{NHItems.fusionEnergy, new DelayedPointBulletType(){
                    {
                        this.width = 15.0f;
                        this.damage = 1200.0f;
                        this.lightningDamage = 40.0f;
                        this.hitColor = NHColor.lightSkyBack;
                        this.lightningColor = this.trailColor = NHColor.lightSkyMiddle;
                        this.lightColor = this.trailColor;
                        this.rangeOverride = 600.0f;
                        this.ammoMultiplier = 1.0f;
                        this.lightning = 3;
                        this.lightningLengthRand = 8;
                        this.lightningLength = 8;
                        this.despawnEffect = NHFx.lightningHitLarge;
                        this.hitEffect = NHFx.hitSparkHuge;
                        this.errorCorrectionRadius = 32.0f;
                        this.status = NHStatusEffects.ultFireBurn;
                        this.statusDuration = 600.0f;
                        this.trailEffect = new Effect(30.0f, 50.0f, e -> {
                            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
                            float f = e.finpow();
                            Rand rand = Fx.rand;
                            rand.setSeed((long)(e.id + 1));
                            Angles.randLenVectors((long)e.id, (int)6, (float)16.0f, (float)0.0f, (float)360.0f, (x, y) -> {
                                Fill.poly((float)(e.x + x * f), (float)(e.y + y * f), (int)3, (float)((float)rand.random(3, 5) * e.fout()), (float)((float)rand.random(360) + (float)rand.random(80, 220) * e.fin((Interp)Interp.pow3Out)));
                                Drawf.light((float)(e.x + x * f), (float)(e.y + y * f), (float)8.0f, (Color)e.color, (float)0.7f);
                            });
                        });
                        this.trailSpacing *= 2.0f;
                        this.shootEffect = EffectWrapper.wrap(NHFx.shootLine(32.0f, 12.0f), this.hitColor);
                        this.smokeEffect = EffectWrapper.wrap(NHFx.square45_6_45, this.hitColor);
                        this.hitShake = 2.0f;
                        this.despawnShake = 2.0f;
                        this.fragBullets = 2;
                        this.fragBullet = new ChainBulletType(700.0f){
                            {
                                super(damage);
                                this.length = 0.0f;
                                this.collidesGround = true;
                                this.collidesAir = true;
                                this.quietShoot = true;
                                this.hitColor = NHColor.lightSkyBack;
                                this.lightningColor = this.trailColor = NHColor.lightSkyMiddle;
                                this.lightColor = this.trailColor;
                                this.thick = 7.3f;
                                this.maxHit = 5;
                                this.hitEffect = NHFx.lightningHitSmall;
                                this.effectController = (t, f) -> DelayedPointBulletType.laser.at(f.getX(), f.getY(), this.thick, this.hitColor, (Object)new Vec2().set(t));
                            }
                        };
                    }
                }, NHItems.thermoCorePositive, new DelayedPointBulletType(){
                    {
                        this.width = 15.0f;
                        this.damage = 500.0f;
                        this.splashDamage = 800.0f;
                        this.splashDamageRadius = 120.0f;
                        this.lightningDamage = 80.0f;
                        this.hitColor = NHColor.thermoPst;
                        this.lightningColor = this.trailColor = NHColor.thermoPst;
                        this.lightColor = this.trailColor;
                        this.rangeOverride = 600.0f;
                        this.ammoMultiplier = 1.0f;
                        this.lightning = 5;
                        this.lightningLengthRand = 18;
                        this.lightningLength = 18;
                        this.despawnEffect = new OptionalMultiEffect(NHFx.smoothColorCircle(this.hitColor, this.splashDamageRadius + 50.0f, 95.0f), NHFx.circleOut(95.0f, this.splashDamageRadius + 50.0f, 2.0f), NHFx.spreadOutSpark(160.0f, this.splashDamageRadius + 40.0f, 72, 4, 72.0f, 13.0f, 4.0f, (Interp)Interp.pow3Out));
                        this.hitEffect = NHFx.square45_6_45;
                        this.status = NHStatusEffects.scrambler;
                        this.statusDuration = 600.0f;
                        this.trailEffect = NHFx.square45_4_45;
                        this.trailSpacing *= 2.0f;
                        this.reloadMultiplier = 0.75f;
                        this.hitShake = 5.0f;
                        this.despawnShake = 5.0f;
                        this.despawnSound = this.hitSound = NHSounds.shock;
                        this.hitSoundVolume = 2.0f;
                        this.fragBullets = 2;
                        this.fragBullet = NHBullets.hyperBlastLinker;
                        this.fragLifeMax = 1.3f;
                        this.fragLifeMin = 0.6f;
                        this.fragVelocityMax = 0.55f;
                        this.fragVelocityMin = 0.2f;
                        this.shootEffect = EffectWrapper.wrap(NHFx.shootLine(32.0f, 12.0f), this.hitColor);
                        this.smokeEffect = EffectWrapper.wrap(NHFx.square45_6_45, this.hitColor);
                    }
                }});
                this.shake = 4.0f;
                this.hasLiquids = true;
                this.liquidCapacity = 80.0f;
                this.coolant = new ConsumeCoolant(0.5f);
                this.coolantMultiplier = 2.25f;
                this.range = 520.0f;
                this.trackingRange = this.range * 1.4f;
            }
        };
        interferon = new PowerTurret("interferon"){
            {
                this.size = 3;
                this.recoil = 1.0f;
                this.reload = 120.0f;
                this.health = 1800;
                this.armor = 8.0f;
                this.shoot = new ShootSine(){
                    {
                        this.scl = 16.0f;
                        this.mag = 8.0f;
                    }
                };
                this.shootSound = Sounds.explosion;
                this.outlineColor = Pal.darkOutline;
                this.warmupMaintainTime = 45.0f;
                this.minWarmup = 0.9f;
                this.shootWarmupSpeed /= 2.0f;
                this.cooldownTime = 65.0f;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 250, NHItems.juniorProcessor, 120, Items.beryllium, 90, NHItems.zeta, 300}));
                this.shootY -= 6.0f;
                this.shootType = new LightningLinkerBulletType(1.5f, 40.0f){
                    {
                        super(speed, damage);
                        this.lifetime = 110.0f;
                        this.keepVelocity = false;
                        this.sprite = NHBullets.MISSILE_LARGE;
                        this.lightningColor = this.hitColor = NHColor.ancientLightMid;
                        this.lightColor = this.hitColor;
                        this.trailColor = this.hitColor;
                        this.backColor = NHColor.ancientLightMid;
                        this.frontColor = NHColor.ancientLight;
                        this.hitSpacing = 3.0f;
                        this.hitShake = 1.0f;
                        this.splashDamage = 45.0f;
                        this.damage = 45.0f;
                        this.lightningDamage = 45.0f;
                        this.splashDamageRadius = 50.0f;
                        this.lightning = 1;
                        this.lightningLengthRand = 8;
                        this.lightningLength = 8;
                        this.effectLightningChance /= 3.0f;
                        this.effectLightningLength = 17.0f;
                        this.effectLingtning = 1;
                        this.maxHit = 8;
                        this.despawnShake = 5.0f;
                        this.hitSound = this.despawnSound = Sounds.beamPlasma;
                        this.statusDuration = 120.0f;
                        this.status = NHStatusEffects.emp1;
                        this.size = 5.0f;
                        this.width = 7.0f;
                        this.height = 22.0f;
                        this.drawCircle = false;
                        this.trailWidth = 3.0f;
                        this.trailLength = 16;
                        this.linkRange = 60.0f;
                        this.scaleLife = false;
                        this.despawnHit = true;
                        this.collidesGround = true;
                        this.collidesAir = true;
                        this.shootEffect = EffectWrapper.wrap(NHFx.shootLine(33.0f, 33.0f), this.hitColor);
                        this.smokeEffect = EffectWrapper.wrap(NHFx.hitSparkHuge, this.hitColor);
                        this.hitEffect = NHFx.hitSpark;
                        this.despawnEffect = NHFx.blast(this.hitColor, 42.0f);
                        this.spreadEffect = EffectWrapper.wrap(NHFx.hitSpark, this.hitColor);
                    }
                };
                this.squareSprite = false;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-handle"){
                            {
                                super(arg0);
                                this.x = -5.0f;
                                this.moveX = 5.0f;
                                this.mirror = true;
                                this.turretShading = true;
                                this.under = true;
                                this.progress = DrawPart.PartProgress.warmup;
                            }
                        }, (Object)new RegionPart("-turret-base"){
                            {
                                super(arg0);
                                this.turretShading = true;
                                this.under = true;
                            }
                        }, (Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.turretShading = true;
                                this.under = true;
                                this.moveY = -4.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                    }
                };
                this.hasLiquids = true;
                this.coolant = new ConsumeCoolant(0.15f);
                this.consumePowerCond(12.0f, Turret.TurretBuild::isActive);
                this.range = 160.0f;
                this.trackingRange = this.range * 1.4f;
                this.inaccuracy = 1.25f;
            }
        };
        antibody = new ItemTurret("antibody"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 220, Items.tungsten, 150, NHItems.juniorProcessor, 80, Items.phaseFabric, 50}));
                this.size = 3;
                this.health = 1800;
                this.armor = 10.0f;
                this.range = 200.0f;
                this.trackingRange = this.range * 1.4f;
                this.warmupMaintainTime = 22.0f;
                this.shootWarmupSpeed /= 2.0f;
                this.minWarmup = 0.9f;
                this.squareSprite = false;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-top"){
                            {
                                super(arg0);
                                this.turretShading = true;
                                this.under = true;
                                this.outline = true;
                            }
                        }, (Object)new RegionPart("-side"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.moveY = 2.75f;
                                this.moveX = 5.5f;
                                this.moveRot = -45.0f;
                                this.progress = DrawPart.PartProgress.warmup;
                            }
                        });
                    }
                };
                this.reload = 60.0f;
                this.shoot = new ShootMulti(new ShootPattern(), new ShootPattern[]{new ShootPattern(){
                    {
                        this.shots = 2;
                        this.shotDelay = 4.0f;
                    }
                }, new ShootBarrel(){
                    {
                        this.shots = 4;
                        this.shotDelay = 4.0f;
                        this.firstShotDelay = 8.0f;
                        this.barrels = new float[]{5.35f, -14.0f, -45.0f, -5.35f, -14.0f, 45.0f};
                    }
                }});
                this.rotateSpeed = 3.0f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(NHLiquids.quantumLiquid, 0.16666667f));
                this.coolantMultiplier = 2.0f;
                this.inaccuracy = 3.0f;
                this.shootSound = NHSounds.laser3;
                this.outlineColor = Pal.darkOutline;
                this.ammo(new Object[]{NHItems.zeta, new AccelBulletType(2.85f, 40.0f){
                    {
                        super(speed, damage);
                        this.frontColor = NHColor.ancientLight;
                        this.hitColor = this.lightColor = NHColor.ancient;
                        this.trailColor = this.lightColor;
                        this.lightningColor = this.lightColor;
                        this.backColor = this.lightColor;
                        this.lifetime = 55.0f;
                        this.status = NHStatusEffects.emp2;
                        this.statusDuration = 120.0f;
                        this.width = 6.0f;
                        this.height = 18.0f;
                        this.velocityBegin = 0.35f;
                        this.velocityIncrease = 7.0f;
                        this.accelInterp = NHInterp.inOut;
                        this.accelerateBegin = 0.0f;
                        this.accelerateEnd = 0.775f;
                        this.homingDelay = 2.0f;
                        this.homingPower = 0.035f;
                        this.homingRange = 120.0f;
                        this.despawnHit = true;
                        this.despawnShake = 2.0f;
                        this.hitShake = 2.0f;
                        this.hitEffect = NHFx.hitSpark;
                        this.despawnEffect = NHFx.square45_4_45;
                        this.shootEffect = new Effect(18.0f, e -> {
                            Draw.color((Color)this.backColor, (Color)this.frontColor, (float)(e.fout() * 0.75f));
                            Angles.randLenVectors((long)e.id, (int)9, (float)(e.finpow() * 23.0f), (float)e.rotation, (float)20.0f, (x, y) -> DrawFunc.arrow(e.x + x, e.y + y, e.fslope() * 1.1f + e.fout() * 1.15f, e.fout() * 5.5f + 0.75f, -e.fout() * 0.6f - 0.2f, Mathf.angle((float)x, (float)y)));
                        });
                        this.smokeEffect = Fx.none;
                        this.trailEffect = NHFx.trailToGray;
                        this.trailLength = 6;
                        this.trailWidth = 2.0f;
                        this.fragBullets = 1;
                        this.fragBullet = new ShrapnelBulletType(){
                            {
                                this.width = 6.0f;
                                this.length = 60.0f;
                                this.lifetime = 22.0f;
                                this.damage = 70.0f;
                                this.status = NHStatusEffects.emp2;
                                this.serrationLenScl = 2.0f;
                                this.serrationWidth = 2.0f;
                                this.serrations = 3;
                                this.statusDuration = 120.0f;
                                this.fromColor = NHColor.ancientLight;
                                this.lightningColor = this.toColor = NHColor.ancient;
                                this.lightColor = this.toColor;
                                this.hitColor = this.toColor;
                                this.shootEffect = NHFx.lightningHitSmall(NHColor.ancient);
                                this.smokeEffect = NHFx.circleSplash;
                            }
                        };
                    }

                    public void createFrags(Bullet b, float x, float y) {
                        if (this.fragBullet != null && (this.fragOnAbsorb || !b.absorbed)) {
                            float a = b.rotation();
                            for (int i = 0; i < this.fragBullets; ++i) {
                                this.fragBullet.create(b, x, y, a);
                            }
                        }
                    }
                }});
                this.maxAmmo = 40;
            }
        };
        webber = new Webber("webber"){
            {
                this.size = 3;
                this.moveInterp = Interp.pow3In;
                this.status = NHStatusEffects.scrambler;
                this.shootLength = 22.0f;
                this.laserColor = NHColor.thermoPst;
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 50, Items.plastanium, 85, NHItems.seniorProcessor, 35, NHItems.presstanium, 80}));
                this.hasPower = true;
                this.cal = d -> 4.0f * Interp.pow3Out.apply(d) - 3.0f;
                this.scaledForce = 0.0f;
                this.force = 45.0f;
                this.range = 280.0f;
                this.damage = 0.3f;
                this.scaledHealth = 160.0f;
                this.rotateSpeed = 10.0f;
                this.consumePower(12.0f);
            }
        };
        gravity = new MultTractorBeamTurret("gravity"){
            {
                this.size = 3;
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.metaglass, 35, NHItems.juniorProcessor, 15, Items.lead, 80, NHItems.presstanium, 45}));
                this.health = 1020;
                this.maxAttract = 8;
                this.shootCone = 60.0f;
                this.range = 300.0f;
                this.hasPower = true;
                this.force = 40.0f;
                this.scaledForce = 8.0f;
                this.shootLength = (float)(this.size * 8) / 2.0f - 3.0f;
                this.damage = 0.15f;
                this.rotateSpeed = 6.0f;
                this.consumePowerCond(6.0f, e -> e.target != null);
            }
        };
        eternity = new ItemTurret("eternity"){
            {
                this.armor = 30.0f;
                this.size = 16;
                this.outlineRadius = 7;
                this.range = 1200.0f;
                this.heatColor = NHColor.darkEnrColor;
                this.unitSort = NHUnitSorts.regionalHPMaximum_All;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(NHLiquids.quantumLiquid, 1.0f));
                this.liquidCapacity = 120.0f;
                this.coolantMultiplier = 2.5f;
                this.buildCostMultiplier *= 2.0f;
                this.canOverdrive = false;
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-side"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.layerOffset = -0.1f;
                                this.moveX = 6.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.inv().curve((Interp)Interp.pow3Out);
                            }
                        }, (Object)new RegionPart("-side-down"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.layerOffset = -0.5f;
                                this.moveX = 10.0f;
                                this.moveY = 45.0f;
                                this.y = 10.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.inv().curve((Interp)Interp.pow3Out);
                            }
                        }, (Object)new RegionPart("-side-down"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.layerOffset = -0.35f;
                                this.moveX = -9.0f;
                                this.moveY = 7.0f;
                                this.y = -2.0f;
                                this.x = 8.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.inv().curve((Interp)Interp.pow3Out);
                            }
                        }, (Object)new RegionPart("-side-down"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.layerOffset = -0.2f;
                                this.moveY = -33.0f;
                                this.y = -33.0f;
                                this.x = 14.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.inv().curve((Interp)Interp.pow3Out);
                            }
                        });
                        this.parts.add((Object)new ArcCharge(){
                            {
                                this.progress = DrawPart.PartProgress.smoothReload.inv().curve((Interp)Interp.pow5Out);
                                this.color = NHColor.darkEnrColor;
                                this.chargeY = t -> -35.0f;
                                this.shootY = t -> 90.0f * this.curve.apply(1.0f - t.smoothReload);
                            }
                        });
                    }
                };
                this.shoot = new ShootPattern();
                this.inaccuracy = 0.0f;
                this.ammoPerShot = 40;
                this.coolantMultiplier = 0.8f;
                this.rotateSpeed = 0.25f;
                float chargeCircleFrontRad = 12.0f;
                this.shootEffect = new Effect(120.0f, 2000.0f, e -> {
                    float scl = 1.0f;
                    if (e.data instanceof Float) {
                        scl *= ((Float)e.data).floatValue();
                    }
                    Draw.color((Color)this.heatColor, (Color)Color.white, (float)(e.fout() * 0.25f));
                    float rand = Mathf.randomSeed((long)e.id, (float)60.0f);
                    float extend = Mathf.curve((float)e.fin((Interp)Interp.pow10Out), (float)0.075f, (float)1.0f) * scl;
                    float rot = e.fout((Interp)Interp.pow10In);
                    for (int i : Mathf.signs) {
                        DrawFunc.tri(e.x, e.y, chargeCircleFrontRad * 1.2f * e.foutpowdown() * scl, 200.0f + 500.0f * extend, e.rotation + (90.0f + rand) * rot + (float)(90 * i) - 45.0f);
                    }
                    for (int i : Mathf.signs) {
                        DrawFunc.tri(e.x, e.y, chargeCircleFrontRad * 1.2f * e.foutpowdown() * scl, 200.0f + 500.0f * extend, e.rotation + (90.0f + rand) * rot + (float)(90 * i) + 45.0f);
                    }
                });
                this.smokeEffect = new Effect(50.0f, e -> {
                    Draw.color((Color)this.heatColor);
                    Lines.stroke((float)(e.fout() * 5.0f));
                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 300.0f));
                    Lines.stroke((float)(e.fout() * 3.0f));
                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 180.0f));
                    Lines.stroke((float)(e.fout() * 3.2f));
                    Angles.randLenVectors((long)e.id, (int)30, (float)(18.0f + 80.0f * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 14.0f + 5.0f)));
                    Draw.color((Color)Color.white);
                    Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 120.0f), (Color)this.heatColor, (float)0.7f);
                });
                this.recoil = 18.0f;
                this.shake = 80.0f;
                this.health = 800000;
                this.shootCone = 5.0f;
                this.maxAmmo = 80;
                this.consumePowerCond(800.0f, Turret.TurretBuild::isActive);
                this.reload = 1800.0f;
                this.ammo(new Object[]{NHItems.darkEnergy, NHBullets.eternity});
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.nodexPlate, 5000, NHItems.darkEnergy, 2000}));
            }
        };
        antiBulletTurret = new PointDefenseTurret("anti-bullet-turret"){
            {
                this.health = 1080;
                this.size = 3;
                this.coolant = this.consumeCoolant(0.1f);
                this.color = this.lightColor = NHColor.lightSkyBack;
                this.beamEffect = Fx.chainLightning;
                this.hitEffect = NHFx.square45_4_45;
                this.shootEffect = NHFx.shootLineSmall(this.color);
                this.shootSound = NHSounds.gauss;
                this.range = 280.0f;
                this.hasPower = true;
                this.consumePowerCond(8.0f, b -> b.target != null);
                this.shootLength = 5.0f;
                this.bulletDamage = 150.0f;
                this.reload = 6.0f;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 90, NHItems.juniorProcessor, 60, NHItems.presstanium, 120, NHItems.zeta, 120, Items.graphite, 80}));
            }
        };
        dendrite = new ShootMatchTurret("dendrite"){
            {
                this.health = 6000;
                this.armor = 15.0f;
                this.range = 360.0f;
                this.trackingRange = this.range * 1.4f;
                this.recoil = 6.0f;
                this.size = 4;
                this.shake = 12.0f;
                this.reload = 60.0f;
                this.rotateSpeed = 2.4f;
                this.shootSound = NHSounds.flak2;
                this.ammo(new Object[]{NHItems.ancimembrane, new TrailFadeBulletType(4.0f, 580.0f, "circle-bullet"){
                    {
                        super(speed, damage, bulletSprite);
                        this.velocityBegin = 8.8f;
                        this.velocityIncrease = -8.15f;
                        this.accelerateBegin = 0.1f;
                        this.accelerateEnd = 0.925f;
                        this.accelInterp = Interp.pow2Out;
                        this.lifetime = 92.0f;
                        this.trailColor = this.hitColor = NHColor.ancient;
                        this.lightningColor = this.hitColor;
                        this.lightColor = this.hitColor;
                        this.backColor = this.hitColor;
                        this.frontColor = NHColor.ancientLight;
                        this.impact = true;
                        this.knockback = 3.0f;
                        this.status = NHStatusEffects.entangled;
                        this.statusDuration = 120.0f;
                        this.hitSize = 12.0f;
                        this.lightning = 2;
                        this.lightningLengthRand = 5;
                        this.lightningLength = 3;
                        this.lightningDamage = this.damage / 10.0f;
                        this.reloadMultiplier = 0.5f;
                        this.ammoMultiplier = 2.0f;
                        this.width = 155.0f;
                        this.height = 7.0f;
                        this.shrinkX = 0.45f;
                        this.shrinkY = -2.48f;
                        this.shrinkInterp = Interp.reverse;
                        this.pierce = true;
                        this.pierceCap = 4;
                        this.tracers = 1;
                        this.tracerUpdateSpacing = 3.0f;
                        this.tracerFadeOffset = 5;
                        this.tracerRandX = 16.0f;
                        this.tracerStrokeOffset = 6;
                        this.addBeginPoint = true;
                        this.smokeEffect = NHFx.hugeSmokeGray;
                        this.shootEffect = new EffectWrapper(NHFx.shootLine(30.0f, 120.0f), this.backColor);
                        this.hitEffect = NHFx.square45_6_45;
                        this.despawnEffect = new Effect(35.0f, 70.0f, e -> {
                            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.7f));
                            for (int i : Mathf.signs) {
                                Drawf.tri((float)e.x, (float)e.y, (float)(this.height * 1.5f * e.fout()), (float)(this.width * 0.885f * e.fout()), (float)(e.rotation + (float)(i * 90)));
                                Drawf.tri((float)e.x, (float)e.y, (float)(this.height * 0.8f * e.fout()), (float)(this.width * 0.252f * e.fout()), (float)(e.rotation + 90.0f + (float)(i * 90)));
                            }
                        });
                    }

                    @Override
                    public void hitEntity(Bullet b, Hitboxc entity, float health) {
                        super.hitEntity(b, entity, health);
                        b.fdata += 1.0f;
                        if (b.fdata > (float)this.pierceCap) {
                            b.hit = true;
                            b.remove();
                        }
                    }

                    @Override
                    public void update(Bullet b) {
                        super.update(b);
                        b.collided.clear();
                    }
                }, NHItems.setonAlloy, new AccelBulletType(2.85f, 280.0f){
                    {
                        super(speed, damage);
                        this.frontColor = NHColor.ancientLight;
                        this.hitColor = this.lightColor = NHColor.ancient;
                        this.trailColor = this.lightColor;
                        this.lightningColor = this.lightColor;
                        this.backColor = this.lightColor;
                        this.lifetime = 92.0f;
                        this.knockback = 2.0f;
                        this.ammoMultiplier = 6.0f;
                        this.accelerateBegin = 0.1f;
                        this.accelerateEnd = 0.85f;
                        this.despawnSound = this.hitSound = Sounds.explosionDull;
                        this.velocityBegin = 6.0f;
                        this.velocityIncrease = -4.0f;
                        this.homingDelay = 20.0f;
                        this.homingPower = 0.05f;
                        this.homingRange = 120.0f;
                        this.status = NHStatusEffects.entangled;
                        this.statusDuration = 120.0f;
                        this.pierceBuilding = true;
                        this.despawnHit = true;
                        this.despawnShake = 5.0f;
                        this.hitShake = 5.0f;
                        this.lightning = 1;
                        this.lightningCone = 360.0f;
                        this.lightningLengthRand = 12;
                        this.lightningLength = 4;
                        this.width = 10.0f;
                        this.height = 35.0f;
                        this.pierceCap = 8;
                        this.shrinkY = 0.0f;
                        this.shrinkX = 0.0f;
                        this.reloadMultiplier = 1.75f;
                        this.lightningDamage = this.damage * 0.8f;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.despawnEffect = NHFx.square45_6_45;
                        this.shootEffect = new EffectWrapper(NHFx.shootLine(22.0f, 20.0f), this.backColor);
                        this.smokeEffect = NHFx.hugeSmokeGray;
                        this.trailEffect = NHFx.trailToGray;
                        this.trailLength = 15;
                        this.trailWidth = 2.0f;
                        this.drawSize = 300.0f;
                        this.status = NHStatusEffects.blackWall;
                        this.statusDuration = 120.0f;
                    }
                }});
                this.shooter(NHItems.ancimembrane, new ShootSpread(){
                    {
                        this.shots = 15;
                        this.spread = 8.0f;
                    }
                }, NHItems.setonAlloy, new ShootAlternate(){
                    {
                        this.shots = 3;
                        this.shotDelay = 5.0f;
                        this.spread = 11.0f;
                    }
                });
                this.shootCone = 35.0f;
                this.ammoPerShot = 6;
                this.maxAmmo = 30;
                this.cooldownTime = 65.0f;
                this.squareSprite = false;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-top"){
                            {
                                super(arg0);
                                this.layerOffset = 0.1f;
                                this.heatLayerOffset = 0.0f;
                            }
                        }, (Object)new RegionPart("-back"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.layerOffset = 0.1f;
                                this.moveX = 1.5f;
                                this.moveY = -1.5f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatLayerOffset = 0.0f;
                            }
                        }, (Object)new RegionPart("-panel"){
                            {
                                super(arg0);
                                this.layerOffset = 0.1f;
                                this.moveX = 0.0f;
                                this.moveY = 2.75f;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.progress = NHPartProgress.recoilWarmup;
                                this.heatLayerOffset = 0.0f;
                            }
                        });
                    }
                };
                this.warmupMaintainTime = 45.0f;
                this.shootWarmupSpeed = 0.04f;
                this.minWarmup = 0.85f;
                this.outlineColor = Pal.darkOutline;
                this.canOverdrive = false;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(NHLiquids.quantumLiquid, 0.25f));
                this.coolantMultiplier = 2.0f;
                this.consumePowerCond(12.0f, Turret.TurretBuild::isActive);
                this.unitSort = UnitSorts.weakest;
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 200, NHItems.ancimembrane, 200, NHItems.zeta, 250, NHItems.metalOxhydrigen, 150}));
            }
        };
        atomSeparator = new LaserTurret("atom-separator"){
            {
                this.health = 12000;
                this.range = 360.0f;
                this.shootEffect = NHFx.hugeSmokeGray;
                this.shootCone = 20.0f;
                this.recoil = 6.0f;
                this.size = 5;
                this.shake = 4.0f;
                this.reload = 60.0f;
                this.canOverdrive = false;
                this.accurateDelay = false;
                this.rotateSpeed = 3.0f;
                this.firingMoveFract = 0.15f;
                this.shootDuration = 200.0f;
                this.loopSoundVolume = 2.0f;
                this.shootType = NHBullets.atomSeparator;
                this.coolant = this.consumeCoolant(1.0f);
                this.consumePower(50.0f);
                this.unitSort = NHUnitSorts.slowest;
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 200, NHItems.irayrondPanel, 200, NHItems.zeta, 150, NHItems.presstanium, 250, NHItems.metalOxhydrigen, 150}));
            }
        };
        bloodStar = new ShootMatchTurret("blood-star"){
            {
                this.size = 5;
                this.coolant = this.consumeCoolant(0.2f);
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.irayrondPanel, 230, NHItems.zeta, 300, NHItems.seniorProcessor, 200, NHItems.presstanium, 300}));
                this.recoil = 5.0f;
                this.reload = 150.0f;
                this.range = 520.0f;
                this.unitSort = (u, x, y) -> -u.hitSize();
                this.shootSound = Sounds.shootLaser;
                this.inaccuracy = 0.0f;
                this.heatColor = Items.surgeAlloy.color.cpy().lerp(Color.white, 0.2f);
                this.consumePowerCond(12.0f, Turret.TurretBuild::isActive);
                this.coolantMultiplier = 3.0f;
                this.health = 8000;
                this.ammo(new Object[]{NHItems.thermoCorePositive, new BasicBulletType(4.0f, 600.0f, "large-bomb"){
                    {
                        super(arg0, arg1, arg2);
                        this.lightning = 6;
                        this.lightningCone = 360.0f;
                        this.lightningLength = 12;
                        this.lightningLengthRand = 12;
                        this.splashDamageRadius = 60.0f;
                        this.splashDamage = this.lightningDamage = 0.5f * this.damage;
                        this.trailEffect = NHFx.hitSparkLarge;
                        this.trailInterval = 3.0f;
                        this.lightColor = this.lightningColor = heatColor;
                        this.hitColor = this.lightningColor;
                        this.backColor = this.lightningColor;
                        this.trailColor = this.lightningColor;
                        this.frontColor = Color.white;
                        this.homingRange = 100.0f;
                        this.homingPower = 0.08f;
                        this.intervalBullets = 2;
                        this.bulletInterval = 3.0f;
                        this.intervalBullet = new AdaptedLightningBulletType(){
                            {
                                this.hitColor = this.lightColor = heatColor;
                                this.trailColor = this.lightColor;
                                this.lightningColor = this.lightColor;
                                this.lightningLength = 4;
                                this.lightningLengthRand = 15;
                                this.damage = 60.0f;
                            }
                        };
                        this.status = NHStatusEffects.emp3;
                        this.statusDuration = 90.0f;
                        this.spin = 3.0f;
                        this.trailLength = 40;
                        this.trailWidth = 2.5f;
                        this.lifetime = 140.0f;
                        this.shrinkY = 0.0f;
                        this.shrinkX = 0.0f;
                        this.drawSize = 60.0f;
                        this.despawnShake = 6.0f;
                        this.hitShake = 6.0f;
                        this.shootEffect = NHFx.instShoot(this.backColor, this.frontColor);
                        this.smokeEffect = Fx.shootBigSmoke2;
                        this.hitEffect = new Effect(50.0f, e -> {
                            Draw.color((Color)this.backColor);
                            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * this.height / 1.5f));
                            Lines.stroke((float)(e.fout() * 3.0f));
                            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 80.0f));
                            Lines.stroke((float)(e.fout() * 2.0f));
                            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 50.0f));
                            Angles.randLenVectors((long)e.id, (int)35, (float)(18.0f + 100.0f * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 12.0f + 4.0f)));
                            Draw.color((Color)this.frontColor);
                            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * this.height / 2.0f));
                        });
                        this.despawnEffect = new OptionalMultiEffect(NHFx.crossBlast(this.backColor, 120.0f), NHFx.instHit(this.backColor, 3, 80.0f), NHFx.spreadOutSpark(120.0f, this.splashDamageRadius + 30.0f, 36, 4, 42.0f, 17.0f, 4.0f, (Interp)Interp.pow3Out));
                        this.width = 40.0f;
                        this.height = 40.0f;
                    }

                    public void draw(Bullet b) {
                        super.draw(b);
                        float f = Mathf.curve((float)b.fout(), (float)0.0f, (float)0.05f);
                        float f2 = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.1f);
                        Draw.color((Color)this.backColor);
                        float fi = Mathf.randomSeed((long)b.id, (float)360.0f);
                        for (int i : Mathf.signs) {
                            DrawFunc.tri(b.x, b.y, 3.0f * f2 * f, 60.0f * f2 * f, fi + (float)((i + 1) * 90) + Time.time * 2.0f);
                            DrawFunc.tri(b.x, b.y, 3.0f * f2 * f, 35.0f * f2 * f, fi + (float)((i + 1) * 90) - Time.time * 2.0f + 90.0f);
                        }
                    }
                }});
                this.shooter(NHItems.thermoCorePositive, new ShootSpread(){
                    {
                        this.firstShotDelay = 90.0f;
                        this.shots = 3;
                        shootCone = 30.0f;
                        this.shotDelay = 15.0f;
                    }
                });
            }
        };
        multipleLauncher = new ItemTurret("multiple-launcher"){
            {
                this.size = 3;
                this.health = 1250;
                this.coolant = this.consumeCoolant(0.2f);
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 45, NHItems.metalOxhydrigen, 45, NHItems.juniorProcessor, 30}));
                this.canOverdrive = false;
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-shooter"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.progress = DrawPart.PartProgress.warmup.compress(0.0f, 0.75f);
                                this.moveX = 0.75f;
                                this.moveY = -1.5f;
                            }
                        });
                    }
                };
                this.ammo(new Object[]{Items.titanium, NHBullets.missileTitanium, Items.thorium, NHBullets.missileThorium, NHItems.zeta, NHBullets.missileZeta, Items.graphite, NHBullets.missileNormal, NHItems.presstanium, NHBullets.missileStrike});
                this.smokeEffect = Fx.shootSmallFlame;
                this.shootEffect = Fx.shootBig2;
                this.recoil = 3.0f;
                this.range = 280.0f;
                this.reload = 90.0f;
                this.shoot = new ShootBarrel(){
                    {
                        this.barrels = new float[]{-4.0f, -2.0f, 0.0f, 0.0f, -3.0f, 0.0f, 4.0f, -2.0f, 0.0f};
                        this.shotDelay = 2.0f;
                        this.shots = 15;
                    }
                };
                this.maxAmmo = 160;
                this.ammoPerShot = 15;
                this.ammoEjectBack = 6.0f;
                this.inaccuracy = 9.0f;
                this.xRand = (float)(8 * this.size) / 6.5f;
                this.coolantMultiplier = 0.85f;
            }
        };
        railGun = new ItemTurret("rail-gun"){
            {
                this.unitSort = (u, x, y) -> -u.speed();
                this.maxAmmo = 40;
                this.ammoPerShot = 8;
                this.squareSprite = false;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-acceler"){
                            {
                                super(arg0);
                                this.mirror = false;
                                this.moveX = 0.0f;
                                this.moveY = -5.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        }, (Object)new RegionPart("-top"){
                            {
                                super(arg0);
                                this.outline = true;
                                this.heatLight = false;
                                this.mirror = false;
                                this.moveX = 0.0f;
                                this.moveY = 0.0f;
                            }
                        });
                    }
                };
                this.ammo(new Object[]{NHItems.irayrondPanel, NHBullets.railGun1, NHItems.setonAlloy, NHBullets.railGun2, NHItems.nodexPlate, NHBullets.railGun3});
                this.consumePowerCond(12.0f, Turret.TurretBuild::isActive);
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 1;
                        this.firstShotDelay = 90.0f;
                    }
                };
                this.moveWhileCharging = false;
                this.shootCone = 6.0f;
                this.size = 4;
                this.health = 4550;
                this.armor = 15.0f;
                this.reload = 200.0f;
                this.recoil = 1.0f;
                this.shake = 8.0f;
                this.range = 620.0f;
                this.trackingRange = this.range * 1.4f;
                this.minRange = 160.0f;
                this.rotateSpeed = 1.5f;
                this.buildType = () -> new ItemTurret.ItemTurretBuild(){

                    public void drawSelect() {
                        super.drawSelect();
                        Drawf.dashCircle((float)this.x, (float)this.y, (float)minRange, (Color)Pal.redderDust);
                    }

                    protected boolean validateTarget() {
                        return !Units.invalidateTarget((Posc)this.target, (Team)(this.canHeal() ? Team.derelict : this.team), (float)this.x, (float)this.y) && !this.within((Position)this.target, minRange) || this.isControlled() || this.logicControlled();
                    }
                };
                this.shootSound = NHSounds.railGunBlast;
                this.outlineColor = Pal.darkOutline;
                this.accurateDelay = true;
                this.coolantMultiplier = 0.55f;
                this.cooldownTime = 90.0f;
                this.coolant = this.consumeCoolant(0.3f);
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.setonAlloy, 150, NHItems.seniorProcessor, 200, NHItems.zeta, 500, Items.phaseFabric, 125}));
            }

            public void drawPlace(int x, int y, int rotation, boolean valid) {
                super.drawPlace(x, y, rotation, valid);
                Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.minRange, (Color)Pal.redderDust);
            }

            public void setStats() {
                super.setStats();
                this.stats.add(Stat.shootRange, this.minRange / 8.0f, StatUnit.blocks);
            }
        };
        endOfEra = new ShootMatchTurret("end-of-era"){
            {
                this.recoil = 5.0f;
                this.armor = 15.0f;
                this.shootCone = 15.0f;
                this.squareSprite = false;
                this.unitSort = UnitSorts.strongest;
                this.warmupMaintainTime = 50.0f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(NHLiquids.quantumLiquid, 0.33333334f));
                this.coolantMultiplier = 2.5f;
                this.moveWhileCharging = false;
                this.canOverdrive = false;
                this.shootWarmupSpeed = 0.035f;
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-charger"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.layerOffset = -0.002f;
                                this.moveX = 14.0f;
                                this.moveY = -9.0f;
                                this.moveRot = -45.0f;
                                this.y = -4.0f;
                                this.x = 16.0f;
                                this.progress = DrawPart.PartProgress.warmup;
                            }
                        }, (Object)new RegionPart(){
                            {
                                this.drawRegion = false;
                                this.mirror = true;
                                this.heatColor = Color.clear;
                                this.progress = DrawPart.PartProgress.recoil.min(DrawPart.PartProgress.warmup);
                                this.moveY = -10.0f;
                                this.children.add((Object)new RegionPart("-wing"){
                                    {
                                        super(arg0);
                                        this.mirror = true;
                                        this.under = true;
                                        this.moveRot = 12.5f;
                                        this.moveY = 14.0f;
                                        this.moveX = 4.0f;
                                        this.heatColor = NHColor.darkEnrColor;
                                        this.progress = DrawPart.PartProgress.warmup;
                                    }
                                });
                            }
                        }, (Object)new RegionPart("-shooter"){
                            {
                                super(arg0);
                                this.outline = true;
                                this.layerOffset = 0.001f;
                                this.moveY = -12.0f;
                                this.heatColor = NHColor.darkEnrColor;
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.recoil, 0.5f);
                            }
                        });
                    }
                };
                this.shoot = new ShootPattern(){
                    {
                        this.firstShotDelay = NHFx.darkEnergyChargeBegin.lifetime;
                    }
                };
                this.outlineColor = Pal.darkOutline;
                this.chargeSound = NHSounds.railGunCharge;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.nodexPlate, 1500}));
                this.ammo(new Object[]{NHItems.darkEnergy, NHBullets.arc_9000, NHItems.nodexPlate, new BulletType(){
                    {
                        this.hittable = false;
                        this.lightColor = this.trailColor = NHColor.darkEnrFront;
                        this.hitColor = this.trailColor;
                        this.ammoMultiplier = 1.0f;
                        this.spawnUnit = NHBullets.airRaidMissile;
                        this.chargeEffect = NHFx.railShoot(NHColor.darkEnrColor, 800.0f, 18.0f, NHFx.darkEnergyChargeBegin.lifetime, 25.0f);
                        this.shootEffect = NHFx.instShoot(NHColor.darkEnrColor, NHColor.darkEnrFront);
                        this.smokeEffect = new Effect(180.0f, 300.0f, b -> {
                            float intensity = 2.0f;
                            Rand rand = Fx.rand;
                            Draw.color((Color)b.color, (float)0.7f);
                            int i = 0;
                            while (i < 4) {
                                rand.setSeed((long)(b.id * 2 + i));
                                float lenScl = rand.random(0.5f, 1.0f);
                                int fi = i++;
                                b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), (float)e.fin((Interp)Interp.pow4Out), (int)((int)(2.0f * intensity)), (float)(35.0f * intensity), (float)e.rotation, (float)20.0f, (x, y, in, out) -> {
                                    float fout = e.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                                    float rad = fout * ((2.0f + intensity) * 1.75f);
                                    Fill.circle((float)(e.x + x), (float)(e.y + y), (float)rad);
                                    Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(rad * 2.5f), (Color)b.color, (float)0.5f);
                                }));
                            }
                        });
                    }
                }});
                this.shooter(NHItems.nodexPlate, new ShootBarrel(){
                    {
                        this.barrels = new float[]{22.0f, -12.0f, 25.0f, -22.0f, -12.0f, -25.0f, 0.0f, -22.0f, 0.0f};
                        this.firstShotDelay = NHFx.darkEnergyChargeBegin.lifetime;
                        this.shots = 3;
                        this.shotDelay = 12.0f;
                    }
                });
                this.shootCone = 12.0f;
                this.rotateSpeed = 0.75f;
                this.ammoPerShot = 4;
                this.maxAmmo = 20;
                this.size = 8;
                this.health = 28000;
                this.armor = 15.0f;
                this.hasItems = true;
                this.heatColor = NHColor.darkEnrColor;
                this.consumePower(30.0f);
                this.reload = 420.0f;
                this.range = 800.0f;
                this.trackingRange = this.range * 1.4f;
                this.inaccuracy = 0.0f;
            }
        };
        executor = new ItemTurret("executor"){
            {
                this.size = 6;
                this.health = 15200;
                this.armor = 10.0f;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.irayrondPanel, 650, Items.tungsten, 375, NHItems.seniorProcessor, 150, NHItems.multipleSteel, 400}));
                this.ammo(new Object[]{NHItems.thermoCorePositive, NHBullets.blastEnergyPst, NHItems.thermoCoreNegative, NHBullets.blastEnergyNgt});
                this.shoot = new ShootBarrel(){
                    {
                        this.shots = 3;
                        this.barrels = new float[]{-11.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 11.0f, 2.0f, 0.0f};
                        this.shotDelay = 4.0f;
                    }
                };
                this.canOverdrive = false;
                this.maxAmmo = 80;
                this.ammoPerShot = 8;
                this.xRand = 1.0f;
                this.velocityRnd = 0.08f;
                this.reload = 16.0f;
                this.shootCone = 50.0f;
                this.rotateSpeed = 2.5f;
                this.range = 440.0f;
                this.inaccuracy = 1.0f;
                this.heatColor = NHBullets.blastEnergyPst.lightColor;
                this.recoil = 4.0f;
                this.shootSound = NHSounds.thermoShoot;
                this.coolant = new ConsumeCoolant(0.25f);
            }
        };
    }

    private static void loadPowers() {
        hyperGenerator = new HyperGenerator("hyper-generator"){
            {
                this.size = 8;
                this.health = 40000;
                this.armor = 50.0f;
                this.powerProduction = 4000.0f;
                this.updateLightningRand = 3;
                this.updateLightning = 3;
                this.effectColor = NHColor.thermoPst;
                this.itemCapacity = 40;
                this.itemDuration = 180.0f;
                this.ambientSoundVolume = 0.1f;
                this.consumePower(100.0f);
                this.consumeItems(ItemStack.with((Object[])new Object[]{NHItems.thermoCoreNegative, 6, Items.phaseFabric, 6})).optional(true, true);
                this.consumeItems(new ItemStack[]{new ItemStack(NHItems.thermoCorePositive, 6), new ItemStack(NHItems.metalOxhydrigen, 6)});
                this.consumeLiquid(NHLiquids.zetaFluidNegative, 0.13333334f);
                this.consumeLiquids(new LiquidStack[]{new LiquidStack(NHLiquids.zetaFluidPositive, 0.13333334f)}).optional(true, true);
                this.requirements(Category.power, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.nodexPlate, 800, NHItems.setonAlloy, 600, NHItems.irayrondPanel, 400, NHItems.presstanium, 1500, Items.surgeAlloy, 250}));
            }
        };
    }

    public static void load() {
        blaster = new ShockwaveGenerator("blaster"){
            {
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 120, NHItems.juniorProcessor, 120, NHItems.multipleSteel, 30}));
                this.squareSprite = false;
                this.size = 3;
                this.chargerOffset = 5.65f;
                this.rotateOffset = -45.0f;
                this.damage = 150.0f;
                this.lightningDamage = 200.0f;
                this.generateLiNum = 3;
                this.generateLiLen = 12;
                this.generateLenRand = 20;
                this.gettingBoltNum = 1;
                this.lightningColor = NHColor.darkEnrColor;
                this.generateEffect = NHFx.blastgenerate;
                this.acceptEffect = NHFx.blastAccept;
                this.status = NHStatusEffects.emp2;
                this.range = 240.0f;
                this.health = 1200;
                this.knockback = 10.0f;
                this.consumePower(8.0f);
                this.itemCapacity = 30;
                this.consumeItem(NHItems.zeta, 3);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawArcSmelt(){
                    {
                        this.midColor = this.flameColor = NHColor.darkEnrColor;
                        this.circleStroke = 1.125f;
                        this.circleSpace = 1.9f;
                    }
                }, new DrawDefault()});
            }
        };
        reinForcedLiquidSource = new LiquidSource("reinforced-liquid-source"){
            {
                this.size = 1;
                this.health = 800;
                this.armor = 10.0f;
                this.buildVisibility = BuildVisibility.sandboxOnly;
                this.category = Category.liquid;
                this.buildType = () -> new LiquidSource.LiquidSourceBuild(){

                    public boolean canPickup() {
                        return false;
                    }

                    public void write(Writes write) {
                        write.str(this.source == null ? "null-liquid" : this.source.name);
                    }

                    public void read(Reads read, byte revision) {
                        this.source = Vars.content.liquid(read.str());
                    }
                };
            }
        };
        reinForcedItemSource = new ItemSource("reinforced-item-source"){
            {
                this.size = 1;
                this.health = 800;
                this.armor = 10.0f;
                this.buildVisibility = BuildVisibility.sandboxOnly;
                this.buildType = () -> new ItemSource.ItemSourceBuild(){

                    public boolean canPickup() {
                        return false;
                    }

                    public void draw() {
                        if (this.block.variants != 0 && this.block.variantRegions != null) {
                            Draw.rect((TextureRegion)this.block.variantRegions[Mathf.randomSeed((long)this.tile.pos(), (int)0, (int)Math.max(0, this.block.variantRegions.length - 1))], (float)this.x, (float)this.y, (float)this.drawrot());
                        } else {
                            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y, (float)this.drawrot());
                        }
                        this.drawTeamTop();
                        if (this.outputItem == null) {
                            Draw.rect((TextureRegion)NHContent.crossRegion, (float)this.x, (float)this.y);
                        } else {
                            Draw.color((Color)this.outputItem.color);
                            Draw.rect((TextureRegion)NHContent.sourceCenter, (float)this.x, (float)this.y);
                            Draw.color();
                        }
                    }

                    public void write(Writes write) {
                        write.str(this.outputItem == null ? "null-item" : this.outputItem.name);
                    }

                    public void read(Reads read, byte revision) {
                        this.outputItem = Vars.content.item(read.str());
                    }
                };
            }

            public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
                this.drawPlanConfigCenter(plan, plan.config, NewHorizon.name("source-center"), true);
            }
        };
        fireExtinguisher = new FireExtinguisher("fire-extinguisher"){
            {
                this.size = 3;
                this.health = 920;
                this.intensity = 1600.0f;
                this.consumeItem(NHItems.metalOxhydrigen, 2);
                this.consumePowerCond(3.0f, FireExtinguisher.FireExtinguisherBuild::isActive);
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 60, NHItems.presstanium, 120}));
            }
        };
        airRaider = new AirRaider("air-raider"){
            {
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.nodexPlate, 160, NHItems.presstanium, 260, NHItems.seniorProcessor, 120, NHItems.juniorProcessor, 100, Items.phaseFabric, 150}));
                this.shoot = new ShootSummon(0.0f, 0.0f, 120.0f, 0.0f){
                    {
                        super(arg0, arg1, arg2, arg3);
                        this.shots = 4;
                        this.shotDelay = 8.0f;
                    }
                };
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawCrucibleFlame(){
                    {
                        this.alpha = 0.375f;
                        this.particles = 20;
                        this.particleSize = 2.6f;
                        this.particleRad = 7.0f;
                        this.flameColor = NHColor.darkEnrColor;
                        this.midColor = NHColor.darkEnrColor.cpy().lerp(Color.white, 0.1f);
                    }
                }, new DrawDefault()});
                this.size = 3;
                this.consumePowerCond(6.0f, CommandableAttackerBlock.CommandableAttackerBlockBuild::isCharging);
                this.consumeItem(NHItems.darkEnergy, 4);
                this.itemCapacity = 16;
                this.health = 4500;
                this.triggeredEffect = new Effect(45.0f, e -> {
                    Draw.color((Color)NHColor.darkEnrColor);
                    Lines.stroke((float)(e.fout() * 2.0f));
                    Lines.square((float)e.x, (float)e.y, (float)((float)(this.size * 8) / 2.0f + 12.0f * e.fin((Interp)Interp.pow2In)));
                });
                this.bullet = NHBullets.airRaidBomb;
            }
        };
        unitIniter = new UnitSpawner("unit-initer");
        bombLauncher = new BombLauncher("bomb-launcher"){
            {
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 100, NHItems.presstanium, 300, NHItems.juniorProcessor, 200, Items.surgeAlloy, 75}));
                this.size = 3;
                this.storage = 2;
                this.bullet = new LightningLinkerBulletType(0.0f, 200.0f){
                    {
                        super(speed, damage);
                        this.trailWidth = 4.5f;
                        this.trailLength = 66;
                        this.spreadEffect = this.slopeEffect = Fx.none;
                        this.trailEffect = NHFx.hitSparkHuge;
                        this.trailInterval = 5.0f;
                        this.lightColor = this.lightningColor = NHColor.thurmixRed;
                        this.hitColor = this.lightningColor;
                        this.trailColor = this.lightningColor;
                        this.backColor = this.lightningColor;
                        this.frontColor = NHColor.thurmixRed;
                        this.randomGenerateRange = 240.0f;
                        this.randomLightningNum = 1;
                        this.linkRange = 120.0f;
                        this.range = 200.0f;
                        this.drawSize = 20.0f;
                        this.drag = 0.0035f;
                        this.fragLifeMin = 0.3f;
                        this.fragLifeMax = 1.0f;
                        this.fragVelocityMin = 0.3f;
                        this.fragVelocityMax = 1.25f;
                        this.fragBullets = 3;
                        this.fragBullet = new FlakBulletType(3.75f, 50.0f){
                            {
                                super(arg0, arg1);
                                this.lightColor = this.lightningColor = NHColor.thurmixRed;
                                this.trailColor = this.lightningColor;
                                this.backColor = NHColor.thurmixRed;
                                this.frontColor = NHColor.thurmixRed;
                                this.trailLength = 14;
                                this.trailWidth = 2.7f;
                                this.trailRotation = true;
                                this.trailInterval = 3.0f;
                                this.trailEffect = NHFx.polyTrail(this.backColor, this.frontColor, 4.65f, 22.0f);
                                this.trailChance = 0.0f;
                                this.knockback = 12.0f;
                                this.lifetime = 40.0f;
                                this.width = 17.0f;
                                this.height = 42.0f;
                                this.collidesTiles = false;
                                this.splashDamageRadius = 60.0f;
                                this.splashDamage = this.damage * 0.6f;
                                this.lightning = 3;
                                this.lightningLength = 8;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.hitShake = 8.0f;
                                this.status = StatusEffects.sapped;
                                this.statusDuration = 600.0f;
                            }
                        };
                        this.splashDamageRadius = 120.0f;
                        this.splashDamage = 200.0f;
                        this.lightningDamage = 40.0f;
                        this.collidesTiles = true;
                        this.pierce = false;
                        this.collides = false;
                        this.lifetime = 10.0f;
                        this.despawnEffect = new OptionalMultiEffect(NHFx.crossBlast(this.hitColor, this.splashDamageRadius * 0.8f), NHFx.blast(this.hitColor, this.splashDamageRadius * 0.8f), NHFx.circleOut(this.hitColor, this.splashDamageRadius * 0.8f));
                    }

                    @Override
                    public void update(Bullet b) {
                        super.update(b);
                        if (NHSetting.enableDetails() && b.timer(1, 6.0f)) {
                            for (int j = 0; j < 2; ++j) {
                                NHFunc.randFadeLightningEffect(b.x, b.y, Mathf.random((int)360), Mathf.random((int)7, (int)12), this.backColor, Mathf.chance((double)0.5));
                            }
                        }
                    }

                    @Override
                    public void draw(Bullet b) {
                        Draw.color((Color)this.backColor);
                        DrawFunc.surround(b.id, b.x, b.y, this.size * 1.45f, 14, 7.0f, 11.0f, (b.fin(NHInterp.parabola4Reversed) + 1.0f) / 2.0f * b.fout(0.1f));
                        this.drawTrail(b);
                        Draw.color((Color)this.backColor);
                        Fill.circle((float)b.x, (float)b.y, (float)this.size);
                        Draw.z((float)110.0001f);
                        Draw.color((Color)this.frontColor);
                        Fill.circle((float)b.x, (float)b.y, (float)(this.size * 0.62f));
                        Draw.z((float)99.89f);
                        Draw.color((Color)this.frontColor);
                        Fill.circle((float)b.x, (float)b.y, (float)(this.size * 0.66f));
                        Draw.z((float)100.0f);
                        Drawf.light((float)b.x, (float)b.y, (float)(this.size * 1.85f), (Color)this.backColor, (float)0.7f);
                    }
                };
                this.reloadTime = 300.0f;
                this.consumePowerCond(6.0f, CommandableAttackerBlock.CommandableAttackerBlockBuild::isCharging);
                this.consumeItem(NHItems.fusionEnergy, 2);
                this.itemCapacity = 16;
                this.health = 1200;
            }
        };
        hyperspaceWarper = new HyperSpaceWarper("hyper-space-warper"){
            {
                this.size = 4;
                this.health = 2250;
                this.squareSprite = false;
                this.completeEffect = NHFx.square45_4_45;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawPlasma(){
                    {
                        this.plasma1 = NHColor.darkEnrColor;
                        this.plasma2 = NHColor.darkEnr;
                    }
                }, new DrawDefault()});
                this.hasLiquids = true;
                this.hasItems = true;
                this.hasPower = true;
                this.itemCapacity = 20;
                this.liquidCapacity = 120.0f;
                this.consumeItem(NHItems.fusionEnergy, 5);
                this.consumePower(12.0f);
                this.consumeLiquid(NHLiquids.quantumLiquid, 0.5f);
                this.requirements(Category.units, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.ancimembrane, 200, NHItems.seniorProcessor, 200, NHItems.presstanium, 450, NHItems.zeta, 200}));
            }
        };
        largeWaterExtractor = new SolidPump("large-water-extractor"){
            {
                this.size = 3;
                this.pumpAmount = 0.31f;
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 50, NHItems.juniorProcessor, 45, Items.tungsten, 30, Items.titanium, 30}));
                this.result = Liquids.water;
                this.liquidCapacity = 60.0f;
                this.rotateSpeed = 1.4f;
                this.attribute = Attribute.water;
                this.consumePower(4.0f);
            }
        };
        NHBlocks.loadTurrets();
        NHBlocks.loadEnv();
        NHBlocks.loadPowers();
        InnerBlock.load();
        ModuleBlock.load();
        ProductionBlock.load();
        TurretBlock.load();
        DefenseBlock.load();
        EnvironmentBlock.load();
        SpecialBlock.load();
        CraftingBlock.load();
        PowerBlock.load();
        LogicBlock.load();
        LiquidBlock.load();
        UnitBlock.load();
        DistributionBlock.load();
        PayloadBlock.load();
    }
}

