/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Core;
import arc.func.Cons;
import arc.func.Func;
import arc.func.Prov;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.scene.style.TextureRegionDrawable;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.game.MapObjectives;
import mindustry.gen.Icon;
import mindustry.gen.LogicIO;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Pal;
import mindustry.logic.LAssembler;
import mindustry.logic.LCategory;
import mindustry.logic.LStatement;
import mindustry.world.meta.Attribute;
import newhorizon.NewHorizon;
import newhorizon.content.NHShaders;
import newhorizon.expand.entities.UltFire;
import newhorizon.expand.game.MapMarker.RaidIndicator;
import newhorizon.expand.game.MapObjectives.ReuseObjective;
import newhorizon.expand.game.MapObjectives.TriggerObjective;
import newhorizon.expand.logic.DefaultRaid;
import newhorizon.expand.logic.ThreatLevel;
import newhorizon.expand.logic.statements.GravityWell;
import newhorizon.expand.logic.statements.LineTarget;
import newhorizon.expand.logic.statements.RaidControl;
import newhorizon.expand.logic.statements.RandomSpawn;
import newhorizon.expand.logic.statements.RandomTarget;
import newhorizon.expand.logic.statements.TeamThreat;

public class NHContent
extends Content {
    public static final float GRAVITY_TRAP_LAYER = 142.472f;
    public static final float QUANTUM_LAYER = 35.1919f;
    public static final float POWER_AREA = 70.114f;
    public static final float POWER_DYNAMIC = 70.514f;
    public static Texture smoothNoise;
    public static Texture particleNoise;
    public static Texture darkerNoise;
    public static Texture noise;
    public static CacheLayer quantumLayer;
    public static CacheLayer armorLayer;
    public static TextureRegion crossRegion;
    public static TextureRegion sourceCenter;
    public static TextureRegion timeIcon;
    public static TextureRegion xenIcon;
    public static TextureRegion iconLevel;
    public static TextureRegion ammoInfo;
    public static TextureRegion arrowRegion;
    public static TextureRegion pointerRegion;
    public static TextureRegion icon;
    public static TextureRegion icon2;
    public static TextureRegion upgrade;
    public static TextureRegion upgrade2;
    public static TextureRegion linkArrow;
    public static TextureRegion activeBoost;
    public static TextureRegion raid;
    public static TextureRegion objective;
    public static TextureRegion fleet;
    public static TextureRegion capture;
    public static TextureRegion khs0;
    public static TextureRegion khs1;
    public static TextureRegion ks1;
    public static TextureRegion ks2;
    public static TextureRegion ks3;
    public static TextureRegion ks4;
    public static TextureRegion ks5;
    public static TextureRegion ks6;
    public static TextureRegion ks7;
    public static TextureRegion ks8;
    public static Attribute quantum;
    public static Attribute density;
    public static LCategory nhwproc;
    public static LCategory nhwprocevent;
    public static LCategory nhcutscene;
    public static LCategory nhaction;
    public static LCategory nhcamera;
    public static LCategory nhcurtain;
    public static LCategory nhinfo;
    public static LCategory nhevent;
    public static LCategory nhsignal;
    public static LCategory nhui;
    public static LCategory nhalert;

    public static void loadPriority() {
        new NHContent().load();
    }

    public static void loadBeforeContentLoad() {
        quantumLayer = new CacheLayer.ShaderLayer((Shader)NHShaders.quantum);
        CacheLayer.add((CacheLayer[])new CacheLayer[]{quantumLayer});
        quantum = Attribute.add((String)"quantum");
        density = Attribute.add((String)"density");
    }

    public static void loadLast() {
        nhwproc = new LCategory("nh-wproc", Pal.heal.cpy().lerp(Pal.gray, 0.2f));
        nhcutscene = new LCategory("nh-cutscene", Pal.remove.cpy().lerp(Pal.gray, 0.3f));
        nhaction = new LCategory("nh-action", Pal.surge.cpy().lerp(Pal.gray, 0.3f));
        ThreatLevel.init();
        LAssembler.customParsers.put((Object)"gravitywell", GravityWell::new);
        LAssembler.customParsers.put((Object)"linetarget", LineTarget::new);
        LAssembler.customParsers.put((Object)"randspawn", RandomSpawn::new);
        LAssembler.customParsers.put((Object)"randtarget", RandomTarget::new);
        LAssembler.customParsers.put((Object)"teamthreat", TeamThreat::new);
        LAssembler.customParsers.put((Object)"raidcontrol", RaidControl::new);
        LogicIO.allStatements.addUnique(GravityWell::new);
        LogicIO.allStatements.addUnique(LineTarget::new);
        LogicIO.allStatements.addUnique(RandomSpawn::new);
        LogicIO.allStatements.addUnique(RandomTarget::new);
        LogicIO.allStatements.addUnique(TeamThreat::new);
        LogicIO.allStatements.addUnique(RaidControl::new);
        NHContent.registerStatement("defaultraid", (Func<String[], LStatement>)((Func)DefaultRaid::new), (Prov<LStatement>)((Prov)DefaultRaid::new));
        MapObjectives.registerObjective((Prov[])new Prov[]{ReuseObjective::new});
        MapObjectives.registerObjective((Prov[])new Prov[]{TriggerObjective::new});
        MapObjectives.registerMarker((Prov[])new Prov[]{RaidIndicator::new});
    }

    public static void registerStatement(String name, Func<String[], LStatement> func, Prov<LStatement> prov) {
        LAssembler.customParsers.put((Object)name, func);
        LogicIO.allStatements.addUnique(prov);
    }

    public ContentType getContentType() {
        return ContentType.error;
    }

    public void load() {
        if (Vars.headless) {
            return;
        }
        Icon.icons.put((Object)"midantha", (Object)new TextureRegionDrawable((TextureRegion)Core.atlas.find(NewHorizon.name("midantha"))));
        Icon.icons.put((Object)"nh", (Object)new TextureRegionDrawable((TextureRegion)Core.atlas.find(NewHorizon.name("icon-2"))));
        UltFire.load();
        crossRegion = Core.atlas.find("cross");
        sourceCenter = Core.atlas.find(NewHorizon.name("source-center"));
        timeIcon = Core.atlas.find(NewHorizon.name("time-icon"));
        xenIcon = Core.atlas.find(NewHorizon.name("xen-icon"));
        upgrade = Core.atlas.find(NewHorizon.name("upgrade"));
        upgrade2 = Core.atlas.find(NewHorizon.name("upgrade2"));
        arrowRegion = Core.atlas.find(NewHorizon.name("jump-gate-arrow"));
        ammoInfo = Core.atlas.find(NewHorizon.name("upgrade-info"));
        iconLevel = Core.atlas.find(NewHorizon.name("level-up"));
        pointerRegion = Core.atlas.find(NewHorizon.name("jump-gate-pointer"));
        icon = Core.atlas.find(NewHorizon.name("icon-white"));
        icon2 = Core.atlas.find(NewHorizon.name("icon-2"));
        raid = Core.atlas.find(NewHorizon.name("raid"));
        objective = Core.atlas.find(NewHorizon.name("objective"));
        fleet = Core.atlas.find(NewHorizon.name("fleet"));
        capture = Core.atlas.find(NewHorizon.name("capture"));
        linkArrow = Core.atlas.find(NewHorizon.name("linked-arrow"));
        activeBoost = Core.atlas.find(NewHorizon.name("active-boost"));
        khs0 = Core.atlas.find(NewHorizon.name("kill-streak-hs-0"));
        khs1 = Core.atlas.find(NewHorizon.name("kill-streak-hs-1"));
        ks1 = Core.atlas.find(NewHorizon.name("kill-streak-1"));
        ks2 = Core.atlas.find(NewHorizon.name("kill-streak-2"));
        ks3 = Core.atlas.find(NewHorizon.name("kill-streak-3"));
        ks4 = Core.atlas.find(NewHorizon.name("kill-streak-4"));
        ks5 = Core.atlas.find(NewHorizon.name("kill-streak-5"));
        ks6 = Core.atlas.find(NewHorizon.name("kill-streak-6"));
        ks7 = Core.atlas.find(NewHorizon.name("kill-streak-7"));
        ks8 = Core.atlas.find(NewHorizon.name("kill-streak-8"));
        smoothNoise = this.loadTex("smooth-noise", (Cons<Texture>)((Cons)t -> {
            t.setFilter(Texture.TextureFilter.linear);
            t.setWrap(Texture.TextureWrap.repeat);
        }));
        particleNoise = this.loadTex("particle-noise", (Cons<Texture>)((Cons)t -> {
            t.setFilter(Texture.TextureFilter.linear);
            t.setWrap(Texture.TextureWrap.repeat);
        }));
        darkerNoise = this.loadTex("darker-noise", (Cons<Texture>)((Cons)t -> {
            t.setFilter(Texture.TextureFilter.linear);
            t.setWrap(Texture.TextureWrap.repeat);
        }));
        noise = this.loadTex("noise", (Cons<Texture>)((Cons)t -> {
            t.setFilter(Texture.TextureFilter.linear);
            t.setWrap(Texture.TextureWrap.repeat);
        }));
    }

    Texture loadTex(String name, Cons<Texture> modifier) {
        Texture tex = new Texture(NewHorizon.MOD.root.child("textures").child(name + (name.endsWith(".png") ? "" : ".png")));
        modifier.get((Object)tex);
        return tex;
    }
}

