/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.IntMap;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.effect.MultiEffect;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import newhorizon.NHSetting;
import newhorizon.content.NHColor;
import newhorizon.content.NHContent;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.struct.Vec2Seq;

public class NHFx {
    public static final float EFFECT_MASK = 110.0001f;
    public static final float EFFECT_BOTTOM = 99.89f;
    public static final IntMap<Effect> same = new IntMap();
    public static final float lightningAlign = 0.5f;
    private static final Rand rand = new Rand();
    private static final Rand rand2 = new Rand();
    private static final Vec2 v = new Vec2();
    private static final int[] oneArr = new int[]{1};
    public static Effect trailFadeFast = new Effect(600.0f, e -> {
        if (!(e.data instanceof Trail)) {
            return;
        }
        Trail trail = (Trail)e.data();
        e.lifetime = (float)trail.length * 1.4f;
        if (!Vars.state.isPaused()) {
            trail.shorten();
            trail.shorten();
        }
        trail.drawCap(e.color, e.rotation * e.foutpow());
        trail.draw(e.color, e.rotation * e.foutpow());
    });
    public static Effect cautionOutline = new Effect(60.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fout() * 2.0f));
        Lines.square((float)e.x, (float)e.y, (float)(e.rotation + e.rotation / 8.0f * e.fin(Interp.circleOut) + 1.0f));
    });
    public static Effect missileShoot = new Effect(130.0f, 300.0f, e -> {
        Draw.color((Color)e.color);
        Draw.alpha((float)(0.67f * e.fout(0.9f)));
        rand.setSeed((long)e.id);
        for (int i = 0; i < 35; ++i) {
            v.trns(e.rotation + 180.0f + rand.range(21.0f), rand.random(e.finpow() * 90.0f)).add(rand.range(3.0f), rand.range(3.0f));
            e.scaled(e.lifetime * rand.random(0.2f, 1.0f), b -> Fill.circle((float)(e.x + NHFx.v.x), (float)(e.y + NHFx.v.y), (float)(b.fout() * 9.0f + 0.3f)));
        }
    });
    public static Effect healReceiveCircle = new Effect(11.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fout() * 1.667f));
        Lines.circle((float)e.x, (float)e.y, (float)(2.0f + e.finpow() * 7.0f));
    });
    public static Effect healSendCircle = new Effect(22.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fout() * 2.0f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.finpow() * e.rotation));
    });
    public static Effect crossSpinBlast = new Effect(150.0f, 600.0f, e -> {
        float scl = 1.0f;
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.25f));
        float extend = Mathf.curve((float)e.fin(), (float)0.0f, (float)0.015f) * scl;
        float rot = e.fout((Interp)Interp.pow3In);
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, 9.0f * e.foutpowdown() * scl, 100.0f + 300.0f * extend, e.rotation + 180.0f * rot + (float)(90 * i) + 45.0f);
            DrawFunc.tri(e.x, e.y, 9.0f * e.foutpowdown() * scl, 100.0f + 300.0f * extend, e.rotation + 180.0f * rot + (float)(90 * i) - 45.0f);
        }
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, 6.0f * e.foutpowdown() * scl, 40.0f + 120.0f * extend, e.rotation + 270.0f * rot + (float)(90 * i) + 45.0f);
            DrawFunc.tri(e.x, e.y, 6.0f * e.foutpowdown() * scl, 40.0f + 120.0f * extend, e.rotation + 270.0f * rot + (float)(90 * i) - 45.0f);
        }
    }).followParent(true).layer(100.0f);
    public static Effect energyUnitBlast = new Effect(150.0f, 1600.0f, e -> {
        float rad = e.rotation;
        rand.setSeed((long)e.id);
        Draw.color((Color)Color.white, (Color)e.color, (float)(e.fin() / 5.0f + 0.6f));
        float circleRad = e.fin(Interp.circleOut) * rad;
        Lines.stroke((float)(12.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)circleRad);
        e.scaled(120.0f, i -> {
            Fill.circle((float)i.x, (float)i.y, (float)(rad * i.fout() / 2.0f));
            Lines.stroke((float)(18.0f * i.fout()));
            Lines.circle((float)i.x, (float)i.y, (float)(i.fin(Interp.circleOut) * rad * 1.2f));
            Angles.randLenVectors((long)i.id, (int)((int)(rad / 4.0f)), (float)(rad / 6.0f), (float)(rad * (1.0f + i.fout(Interp.circleOut)) / 2.0f), (x, y) -> {
                float angle = Mathf.angle((float)x, (float)y);
                float width = i.foutpowdown() * rand.random(rad / 8.0f, rad / 10.0f);
                float length = rand.random(rad / 2.0f, rad) * i.fout(Interp.circleOut);
                Draw.color((Color)i.color);
                DrawFunc.tri(i.x + x, i.y + y, width, rad / 8.0f * i.fout(Interp.circleOut), angle - 180.0f);
                DrawFunc.tri(i.x + x, i.y + y, width, length, angle);
                Draw.color((Color)Color.black);
                DrawFunc.tri(i.x + x, i.y + y, (width *= i.fout()) / 2.0f, rad / 8.0f * i.fout(Interp.circleOut) * 0.9f * i.fout(), angle - 180.0f);
                DrawFunc.tri(i.x + x, i.y + y, width / 2.0f, length / 1.5f * i.fout(), angle);
            });
            Draw.color((Color)Color.black);
            Fill.circle((float)i.x, (float)i.y, (float)(rad * i.fout() * 0.375f));
        });
        Drawf.light((float)e.x, (float)e.y, (float)(rad * e.fout() * 4.0f * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f)), (Color)e.color, (float)0.7f);
    }).layer(110.001f);
    public static Effect absorbFix = new Effect(12.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(2.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(5.0f * e.fout()));
    });
    public static Effect collapserBulletExplode = new Effect(300.0f, 1600.0f, e -> {
        float rad = 150.0f;
        rand.setSeed((long)e.id);
        Draw.color((Color)Color.white, (Color)e.color, (float)(e.fin() + 0.6f));
        float circleRad = e.fin(Interp.circleOut) * rad * 4.0f;
        Lines.stroke((float)(12.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)circleRad);
        for (int i2 = 0; i2 < 24; ++i2) {
            Tmp.v1.set(1.0f, 0.0f).setToRandomDirection(rand).scl(circleRad);
            DrawFunc.tri(e.x + Tmp.v1.x, e.y + Tmp.v1.y, rand.random(circleRad / 16.0f, circleRad / 12.0f) * e.fout(), rand.random(circleRad / 4.0f, circleRad / 1.5f) * (1.0f + e.fin()) / 2.0f, Tmp.v1.angle() - 180.0f);
        }
        if (NHSetting.enableDetails()) {
            Draw.blend((Blending)Blending.additive);
            Draw.z((float)110.1f);
            Fill.light((float)e.x, (float)e.y, (int)Lines.circleVertices((float)circleRad), (float)circleRad, (Color)Color.clear, (Color)Tmp.c1.set(Draw.getColor()).a(e.fout((Interp)Interp.pow10Out)));
            Draw.blend();
            Draw.z((float)110.0f);
        }
        e.scaled(120.0f, i -> {
            Draw.color((Color)Color.white, (Color)i.color, (float)(i.fin() + 0.4f));
            Fill.circle((float)i.x, (float)i.y, (float)(rad * i.fout()));
            Lines.stroke((float)(18.0f * i.fout()));
            Lines.circle((float)i.x, (float)i.y, (float)(i.fin(Interp.circleOut) * rad * 1.2f));
            Angles.randLenVectors((long)i.id, (int)40, (float)(rad / 3.0f), (float)(rad * i.fin((Interp)Interp.pow2Out)), (x, y) -> Lines.lineAngle((float)(i.x + x), (float)(i.y + y), (float)Mathf.angle((float)x, (float)y), (float)(i.fslope() * 25.0f + 10.0f)));
            if (NHSetting.enableDetails()) {
                Angles.randLenVectors((long)i.id, (int)((int)(rad / 4.0f)), (float)(rad / 6.0f), (float)(rad * (1.0f + i.fout(Interp.circleOut)) / 1.5f), (x, y) -> {
                    float angle = Mathf.angle((float)x, (float)y);
                    float width = i.foutpowdown() * rand.random(rad / 6.0f, rad / 3.0f);
                    float length = rand.random(rad / 2.0f, rad * 5.0f) * i.fout(Interp.circleOut);
                    Draw.color((Color)i.color);
                    DrawFunc.tri(i.x + x, i.y + y, width, rad / 3.0f * i.fout(Interp.circleOut), angle - 180.0f);
                    DrawFunc.tri(i.x + x, i.y + y, width, length, angle);
                    Draw.color((Color)Color.black);
                    DrawFunc.tri(i.x + x, i.y + y, (width *= i.fout()) / 2.0f, rad / 3.0f * i.fout(Interp.circleOut) * 0.9f * i.fout(), angle - 180.0f);
                    DrawFunc.tri(i.x + x, i.y + y, width / 2.0f, length / 1.5f * i.fout(), angle);
                });
            }
            Draw.color((Color)Color.black);
            Fill.circle((float)i.x, (float)i.y, (float)(rad * i.fout() * 0.75f));
        });
        Drawf.light((float)e.x, (float)e.y, (float)(rad * e.fout(Interp.circleOut) * 4.0f), (Color)e.color, (float)0.7f);
    }).layer(110.001f);
    public static Effect hitSpark = new Effect(45.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.3f));
        Lines.stroke((float)(e.fout() * 1.6f));
        rand.setSeed((long)e.id);
        Angles.randLenVectors((long)e.id, (int)8, (float)(e.finpow() * 20.0f), (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * rand.random(1.95f, 4.25f) + 1.0f));
        });
    });
    public static Effect hitSparkLarge = new Effect(40.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.3f));
        Lines.stroke((float)(e.fout() * 1.6f));
        rand.setSeed((long)e.id);
        Angles.randLenVectors((long)e.id, (int)18, (float)(e.finpow() * 27.0f), (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * (float)rand.random(4, 8) + 2.0f));
        });
    });
    public static Effect hitSparkHuge = new Effect(70.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.3f));
        Lines.stroke((float)(e.fout() * 1.6f));
        rand.setSeed((long)e.id);
        Angles.randLenVectors((long)e.id, (int)26, (float)(e.finpow() * 65.0f), (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * (float)rand.random(6, 9) + 3.0f));
        });
    });
    public static Effect chainLightningFade = new Effect(220.0f, 500.0f, e -> {
        int i;
        if (!(e.data instanceof Position)) {
            return;
        }
        Position p = (Position)e.data();
        float tx = p.getX();
        float ty = p.getY();
        float dst = Mathf.dst((float)e.x, (float)e.y, (float)tx, (float)ty);
        Tmp.v1.set(p).sub(e.x, e.y).nor();
        e.lifetime = dst * 0.3f;
        float normx = Tmp.v1.x;
        float normy = Tmp.v1.y;
        float range = e.rotation;
        int links = Mathf.ceil((float)(dst / range));
        float spacing = dst / (float)links;
        Lines.stroke((float)(2.5f * Mathf.curve((float)e.fout(), (float)0.0f, (float)0.7f)));
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        Lines.beginLine();
        Fill.circle((float)e.x, (float)e.y, (float)(Lines.getStroke() / 2.0f));
        Lines.linePoint((float)e.x, (float)e.y);
        rand.setSeed((long)e.id);
        float fin = Mathf.curve((float)e.fin(), (float)0.0f, (float)0.5f);
        float nx = e.x;
        float ny = e.y;
        for (i = 0; i < (int)((float)links * fin); ++i) {
            if (i == links - 1) {
                nx = tx;
                ny = ty;
            } else {
                float len = (float)(i + 1) * spacing;
                Tmp.v1.setToRandomDirection(rand).scl(range / 2.0f);
                nx = e.x + normx * len + Tmp.v1.x;
                ny = e.y + normy * len + Tmp.v1.y;
            }
            Lines.linePoint((float)nx, (float)ny);
        }
        if (NHSetting.enableDetails() && i < links) {
            float f = Mathf.clamp((float)(fin * (float)links % 1.0f));
            float len = (float)(i + 1) * spacing;
            Tmp.v1.setToRandomDirection(rand).scl(range / 2.0f);
            Tmp.v2.set(nx, ny);
            if (i == links - 1) {
                Tmp.v2.lerp(tx, ty, f);
            } else {
                Tmp.v2.lerp(e.x + (normx * len + Tmp.v1.x), e.y + (normy * len + Tmp.v1.y), f);
            }
            Lines.linePoint((float)Tmp.v2.x, (float)Tmp.v2.y);
            Fill.circle((float)Tmp.v2.x, (float)Tmp.v2.y, (float)(Lines.getStroke() / 2.0f));
        }
        Lines.endLine();
    }).followParent(false);
    public static Effect chainLightningFadeReversed = new Effect(220.0f, 500.0f, e -> {
        int i;
        if (!(e.data instanceof Position)) {
            return;
        }
        Position p = (Position)e.data();
        float tx = e.x;
        float ty = e.y;
        float dst = Mathf.dst((float)p.getX(), (float)p.getY(), (float)tx, (float)ty);
        Tmp.v1.set(e.x, e.y).sub(p).nor();
        e.lifetime = dst * 0.3f;
        float normx = Tmp.v1.x;
        float normy = Tmp.v1.y;
        float range = e.rotation;
        int links = Mathf.ceil((float)(dst / range));
        float spacing = dst / (float)links;
        Lines.stroke((float)(2.5f * Mathf.curve((float)e.fout(), (float)0.0f, (float)0.7f)));
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        Lines.beginLine();
        Fill.circle((float)p.getX(), (float)p.getY(), (float)(Lines.getStroke() / 2.0f));
        Lines.linePoint((Position)p);
        rand.setSeed((long)e.id);
        float fin = Mathf.curve((float)e.fin(), (float)0.0f, (float)0.5f);
        float nx = p.getX();
        float ny = p.getY();
        for (i = 0; i < (int)((float)links * fin); ++i) {
            if (i == links - 1) {
                nx = tx;
                ny = ty;
            } else {
                float len = (float)(i + 1) * spacing;
                Tmp.v1.setToRandomDirection(rand).scl(range / 2.0f);
                nx = p.getX() + normx * len + Tmp.v1.x;
                ny = p.getY() + normy * len + Tmp.v1.y;
            }
            Lines.linePoint((float)nx, (float)ny);
        }
        if (NHSetting.enableDetails() && i < links) {
            float f = Mathf.clamp((float)(fin * (float)links % 1.0f));
            float len = (float)(i + 1) * spacing;
            Tmp.v1.setToRandomDirection(rand).scl(range / 2.0f);
            Tmp.v2.set(nx, ny);
            if (i == links - 1) {
                Tmp.v2.lerp(tx, ty, f);
            } else {
                Tmp.v2.lerp(p.getX() + (normx * len + Tmp.v1.x), p.getY() + (normy * len + Tmp.v1.y), f);
            }
            Lines.linePoint((float)Tmp.v2.x, (float)Tmp.v2.y);
            Fill.circle((float)Tmp.v2.x, (float)Tmp.v2.y, (float)(Lines.getStroke() / 2.0f));
        }
        Lines.endLine();
    }).followParent(false);
    public static Effect lightningHitLarge = new Effect(50.0f, 180.0f, e -> {
        Draw.color((Color)e.color);
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 90.0f), (Color)e.color, (float)0.7f);
        e.scaled(25.0f, t -> {
            Lines.stroke((float)(3.0f * t.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(3.0f + t.fin((Interp)Interp.pow3Out) * 80.0f));
        });
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 8.0f));
        Angles.randLenVectors((long)(e.id + 1), (int)4, (float)(1.0f + 60.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 5.0f)));
        Draw.color((Color)Color.gray);
        Angles.randLenVectors((long)e.id, (int)8, (float)(2.0f + 30.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f + 0.5f)));
    });
    public static Effect lightningHitSmall = new Effect(Fx.chainLightning.lifetime, e -> {
        Draw.color((Color)Color.white, (Color)e.color, (float)(e.fin() + 0.25f));
        e.scaled(7.0f, s -> {
            Lines.stroke((float)(0.5f + s.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(s.fin() * (e.rotation + 12.0f)));
        });
        Lines.stroke((float)(0.75f + e.fout()));
        Angles.randLenVectors((long)e.id, (int)6, (float)(e.fin() * e.rotation + 7.0f), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * 4.0f + 2.0f)));
        Fill.circle((float)e.x, (float)e.y, (float)(2.5f * e.fout()));
    });
    public static Effect lightningSpark = new Effect(Fx.chainLightning.lifetime, e -> {
        Draw.color((Color)Color.white, (Color)e.color, (float)(e.fin() + 0.25f));
        Lines.stroke((float)(0.65f + e.fout()));
        Angles.randLenVectors((long)e.id, (int)3, (float)(e.fin() * e.rotation + 6.0f), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * 4.0f + 2.0f)));
        Fill.circle((float)e.x, (float)e.y, (float)(2.5f * e.fout()));
    });
    public static Effect absorb = new Effect(20.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.rotation * e.fout()));
        Lines.poly((float)e.x, (float)e.y, (int)6, (float)((e.rotation + e.rotation * e.fin((Interp)Interp.pow2In) * 1.75f) / 2.0f));
    });
    public static Effect project = new Effect(60.0f, 1600.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        Position data = (Position)e.data();
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.rotation * e.fout(0.5f)));
        Lines.line((float)e.x, (float)e.y, (float)data.getX(), (float)data.getY(), (boolean)false);
        Fill.circle((float)e.x, (float)e.y, (float)(Lines.getStroke() * 1.25f));
        Fill.circle((float)data.getX(), (float)data.getY(), (float)(Lines.getStroke() * 2.0f));
    });
    public static Effect transport = new Effect(22.0f, 400.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        Position to = (Position)e.data();
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow3).add(Tmp.v2.sub(e.x, e.y).nor().rotate90(1).scl(Mathf.randomSeedRange((long)e.id, (float)1.0f) * e.fslope() * 10.0f));
        float x = Tmp.v1.x;
        float y = Tmp.v1.y;
        float size = 1.0f;
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.75f));
        Fill.circle((float)x, (float)y, (float)(e.fslope() * e.rotation * size));
    });
    public static Effect attackWarningPos = new Effect(120.0f, 2000.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        e.lifetime = e.rotation;
        Position pos = (Position)e.data();
        Draw.color((Color)e.color);
        TextureRegion arrowRegion = NHContent.arrowRegion;
        float scl = Mathf.curve((float)e.fout(), (float)0.0f, (float)0.1f);
        Lines.stroke((float)(2.0f * scl));
        Lines.line((float)pos.getX(), (float)pos.getY(), (float)e.x, (float)e.y);
        Fill.circle((float)pos.getX(), (float)pos.getY(), (float)Lines.getStroke());
        Fill.circle((float)e.x, (float)e.y, (float)Lines.getStroke());
        Tmp.v1.set(e.x, e.y).sub(pos).scl(e.fin((Interp)Interp.pow2In)).add(pos);
        Draw.rect((TextureRegion)arrowRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)((float)arrowRegion.width * scl * Draw.scl), (float)((float)arrowRegion.height * scl * Draw.scl), (float)(pos.angleTo(e.x, e.y) - 90.0f));
    });
    public static Effect attackWarningRange = new Effect(120.0f, 2000.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(2.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)e.rotation);
        for (float i = 0.75f; i < 1.5f; i += 0.25f) {
            Lines.spikes((float)e.x, (float)e.y, (float)(e.rotation / i), (float)(e.rotation / 10.0f), (int)4, (float)e.time);
            Lines.spikes((float)e.x, (float)e.y, (float)(e.rotation / i / 1.5f), (float)(e.rotation / 12.0f), (int)4, (float)(-e.time * 1.25f));
        }
        TextureRegion arrowRegion = NHContent.arrowRegion;
        float scl = Mathf.curve((float)e.fout(), (float)0.0f, (float)0.1f);
        for (int l = 0; l < 4; ++l) {
            float angle = 90 * l;
            float regSize = e.rotation / 150.0f;
            for (int i = 0; i < 4; ++i) {
                Tmp.v1.trns(angle, (float)((i - 4) * 8) * e.rotation / 8.0f / 4.0f);
                float f = (100.0f - (Time.time - (float)(25 * i)) % 100.0f) / 100.0f;
                Draw.rect((TextureRegion)arrowRegion, (float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)((float)arrowRegion.width * regSize * f * scl), (float)((float)arrowRegion.height * regSize * f * scl), (float)(angle - 90.0f));
            }
        }
    });
    public static Effect shareDamage = new Effect(45.0f, e -> {
        if (!(e.data instanceof Number)) {
            return;
        }
        Draw.color((Color)e.color);
        Draw.alpha((float)(((Number)e.data()).floatValue() * e.fout()));
        Fill.square((float)e.x, (float)e.y, (float)e.rotation);
    });
    public static Effect square45_4_45 = new Effect(45.0f, e -> {
        Draw.color((Color)e.color);
        Angles.randLenVectors((long)e.id, (int)5, (float)(20.0f * e.finpow()), (x, y) -> {
            Fill.square((float)(e.x + x), (float)(e.y + y), (float)(4.0f * e.fout()), (float)45.0f);
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 6.0f), (Color)e.color, (float)0.7f);
        });
    });
    public static Effect square45_6_45 = new Effect(45.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        Angles.randLenVectors((long)e.id, (int)6, (float)(27.0f * e.finpow()), (x, y) -> {
            Fill.square((float)(e.x + x), (float)(e.y + y), (float)(5.0f * e.fout()), (float)45.0f);
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 9.0f), (Color)e.color, (float)0.7f);
        });
    });
    public static Effect square45_6_45_Charge = new Effect(90.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fin() * 0.6f));
        Angles.randLenVectors((long)e.id, (int)12, (float)(60.0f * e.fout((Interp)Interp.pow4Out)), (x, y) -> {
            Fill.square((float)(e.x + x), (float)(e.y + y), (float)(5.0f * e.fin()), (float)45.0f);
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fin() * 9.0f), (Color)e.color, (float)0.7f);
        });
        Lines.stroke((float)(2.0f * e.fin()));
        Lines.circle((float)e.x, (float)e.y, (float)(80.0f * e.fout((Interp)Interp.pow5Out)));
    });
    public static Effect square45_8_45 = new Effect(45.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        Angles.randLenVectors((long)e.id, (int)7, (float)(34.0f * e.finpow()), (x, y) -> {
            Fill.square((float)(e.x + x), (float)(e.y + y), (float)(8.0f * e.fout()), (float)45.0f);
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 12.0f), (Color)e.color, (float)0.7f);
        });
    });
    public static Effect poly = new Effect(25.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fout() * 2.0f));
        Lines.poly((float)e.x, (float)e.y, (int)6, (float)(2.0f + e.finpow() * e.rotation));
    });
    public static Effect healEffectSky = new Effect(11.0f, e -> {
        Draw.color((Color)NHColor.lightSkyBack);
        Lines.stroke((float)(e.fout() * 2.0f));
        Lines.poly((float)e.x, (float)e.y, (int)6, (float)(2.0f + e.finpow() * 79.0f));
    });
    public static Effect activeEffectSky = new Effect(22.0f, e -> {
        Draw.color((Color)NHColor.lightSkyBack);
        Lines.stroke((float)(e.fout() * 3.0f));
        Lines.poly((float)e.x, (float)e.y, (int)6, (float)(4.0f + e.finpow() * e.rotation));
    });
    public static Effect spawnGround = new Effect(60.0f, e -> {
        Draw.color((Color)e.color, (Color)Pal.gray, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)((int)(e.rotation * 1.35f)), (float)(e.rotation * 8.0f / 1.125f * e.fin()), (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(e.rotation * e.fout()), (float)45.0f));
    });
    public static Effect spawnWave = new Effect(60.0f, e -> {
        Lines.stroke((float)(3.0f * e.fout()), (Color)e.color);
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.finpow()));
    });
    public static Effect trailToGray = new Effect(50.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.gray, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)2, (float)(8.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.rotation * e.fout())));
    });
    public static Effect trailFromWhite = new Effect(50.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.35f));
        Angles.randLenVectors((long)e.id, (int)2, (float)(8.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.rotation * e.fout())));
    });
    public static Effect trailSolid = new Effect(50.0f, e -> {
        Draw.color((Color)e.color);
        Angles.randLenVectors((long)e.id, (int)2, (float)(8.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.rotation * e.fout())));
    });
    public static Effect boolSelector = new Effect(0.0f, 0.0f, e -> {});
    public static Effect skyTrail = new Effect(22.0f, e -> {
        Draw.color((Color)NHColor.lightSkyBack, (Color)Pal.gray, (float)(e.fin() * 0.6f));
        rand.setSeed((long)e.id);
        Angles.randLenVectors((long)e.id, (int)3, (float)(e.finpow() * 13.0f), (float)(e.rotation - 180.0f), (float)30.0f, (x, y) -> Fill.poly((float)(e.x + x), (float)(e.y + y), (int)6, (float)((float)rand.random(2, 4) * e.foutpow()), (float)e.rotation));
    });
    public static Effect circleOut = new Effect(60.0f, 500.0f, e -> {
        Lines.stroke((float)(2.5f * e.fout()), (Color)e.color);
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fin((Interp)Interp.pow3Out)));
    });
    public static Effect circleOutQuick = new Effect(30.0f, 500.0f, e -> {
        Lines.stroke((float)(2.5f * e.fout()), (Color)e.color);
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fin((Interp)Interp.pow3Out)));
    });
    public static Effect circleOutLong = new Effect(120.0f, 500.0f, e -> {
        Lines.stroke((float)(2.5f * e.fout()), (Color)e.color);
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fin((Interp)Interp.pow3Out)));
    });
    public static Effect shuttle = new Effect(70.0f, 800.0f, e -> {
        if (!(e.data instanceof Float)) {
            return;
        }
        float len = ((Float)e.data()).floatValue();
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.3f));
        Lines.stroke((float)(e.fout() * 2.2f));
        Angles.randLenVectors((long)e.id, (int)((int)Mathf.clamp((float)(len / 12.0f), (float)10.0f, (float)40.0f)), (float)(e.finpow() * len), (float)e.rotation, (float)360.0f, (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * len * 0.15f + len * 0.025f));
        });
        float fout = e.fout((Interp)Interp.exp10Out);
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, len / 17.0f * fout * (Mathf.absin((float)0.8f, (float)0.07f) + 1.0f), len * 3.0f * Interp.swingOut.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.7f)) * (Mathf.absin((float)0.8f, (float)0.12f) + 1.0f) * e.fout(0.2f), e.rotation + 90.0f + (float)(i * 90));
        }
    });
    public static Effect shuttleDark = new Effect(70.0f, 800.0f, e -> {
        if (!(e.data instanceof Float)) {
            return;
        }
        float len = ((Float)e.data()).floatValue();
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.3f));
        Lines.stroke((float)(e.fout() * 2.2f));
        Angles.randLenVectors((long)e.id, (int)((int)Mathf.clamp((float)(len / 12.0f), (float)10.0f, (float)40.0f)), (float)(e.finpow() * len), (float)e.rotation, (float)360.0f, (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * len * 0.15f + len * 0.025f));
        });
        float fout = e.fout((Interp)Interp.exp10Out);
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, len / 17.0f * fout * (Mathf.absin((float)0.8f, (float)0.07f) + 1.0f), len * 3.0f * Interp.swingOut.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.7f)) * (Mathf.absin((float)0.8f, (float)0.12f) + 1.0f) * e.fout(0.2f), e.rotation + 90.0f + (float)(i * 90));
        }
        float len1 = len * 0.66f;
        Draw.z((float)110.0001f);
        Draw.color((Color)Color.black);
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, len1 / 17.0f * fout * (Mathf.absin((float)0.8f, (float)0.07f) + 1.0f), len1 * 3.0f * Interp.swingOut.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.7f)) * (Mathf.absin((float)0.8f, (float)0.12f) + 1.0f) * e.fout(0.2f), e.rotation + 90.0f + (float)(i * 90));
        }
        Draw.z((float)99.89f);
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, len1 / 17.0f * fout * (Mathf.absin((float)0.8f, (float)0.07f) + 1.0f), len1 * 3.0f * Interp.swingOut.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.7f)) * (Mathf.absin((float)0.8f, (float)0.12f) + 1.0f) * e.fout(0.2f), e.rotation + 90.0f + (float)(i * 90));
        }
    }).layer(109.0f);
    public static Effect shuttleLerp = new Effect(180.0f, 800.0f, e -> {
        if (!(e.data instanceof Float)) {
            return;
        }
        float f = Mathf.curve((float)e.fin((Interp)Interp.pow5In), (float)0.0f, (float)0.07f) * Mathf.curve((float)e.fout(), (float)0.0f, (float)0.4f);
        float len = ((Float)e.data()).floatValue();
        Draw.color((Color)e.color);
        v.trns(e.rotation - 90.0f, (len + Mathf.randomSeed((long)e.id, (float)0.0f, (float)len)) * e.fin(Interp.circleOut));
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x + NHFx.v.x, e.y + NHFx.v.y, Mathf.clamp((float)(len / 8.0f), (float)8.0f, (float)25.0f) * (f + e.fout(0.2f) * 2.0f) / 3.5f, len * 1.75f * e.fin(Interp.circleOut), e.rotation + 90.0f + (float)(i * 90));
        }
    });
    public static Effect line = new Effect(30.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.75f));
        Lines.stroke((float)(2.0f * e.fout()));
        Angles.randLenVectors((long)e.id, (int)6, (float)(3.0f + e.rotation * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 14.0f + 4.0f)));
    });
    public static Effect circle = new Effect(25.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.65f));
        Lines.stroke((float)(Mathf.clamp((float)(e.rotation / 18.0f), (float)2.0f, (float)6.0f) * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.finpow()));
    });
    public static Effect spawn = new Effect(100.0f, e -> {
        TextureRegion pointerRegion = NHContent.pointerRegion;
        Draw.color((Color)e.color);
        for (int j = 1; j <= 3; ++j) {
            for (int i = 0; i < 4; ++i) {
                float length = e.rotation * 3.0f + 8.0f;
                float x = Angles.trnsx((float)(i * 90), (float)(-length));
                float y = Angles.trnsy((float)(i * 90), (float)(-length));
                e.scaled((float)(30 * j), k -> {
                    float signSize = e.rotation / 8.0f / 3.0f * Draw.scl * k.fout();
                    Draw.rect((TextureRegion)pointerRegion, (float)(e.x + x * k.finpow()), (float)(e.y + y * k.finpow()), (float)((float)pointerRegion.width * signSize), (float)((float)pointerRegion.height * signSize), (float)(Angles.angle((float)x, (float)y) - 90.0f));
                    Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * signSize * (float)pointerRegion.height), (Color)e.color, (float)0.7f);
                });
            }
        }
    });
    public static Effect jumpTrail = new Effect(120.0f, 5000.0f, e -> {
        if (!(e.data instanceof UnitType)) {
            return;
        }
        UnitType type = (UnitType)e.data();
        Draw.color((Color)(type.engineColor == null ? e.color : type.engineColor));
        if (type.engineLayer > 0.0f) {
            Draw.z((float)type.engineLayer);
        } else {
            Draw.z((float)((type.lowAltitude ? 90.0f : 115.0f) - 0.001f));
        }
        for (int index = 0; index < type.engines.size; ++index) {
            UnitType.UnitEngine engine = (UnitType.UnitEngine)type.engines.get(index);
            if (Angles.angleDist((float)engine.rotation, (float)-90.0f) > 75.0f) {
                return;
            }
            float ang = Mathf.slerp((float)engine.rotation, (float)-90.0f, (float)0.75f);
            Tmp.v1.trns(e.rotation, engine.y, -engine.x);
            e.scaled(80.0f, i -> {
                DrawFunc.tri(i.x + Tmp.v1.x, i.y + Tmp.v1.y, engine.radius * 1.5f * i.fout((Interp)Interp.slowFast), 3000.0f * engine.radius / (type.engineSize + 4.0f), i.rotation + ang - 90.0f);
                Fill.circle((float)(i.x + Tmp.v1.x), (float)(i.y + Tmp.v1.y), (float)(engine.radius * 1.5f * i.fout((Interp)Interp.slowFast)));
            });
            Angles.randLenVectors((long)(e.id + index), (int)22, (float)(400.0f * engine.radius / (type.engineSize + 4.0f)), (float)(e.rotation + ang - 90.0f), (float)0.0f, (x, y) -> Lines.lineAngle((float)(e.x + x + Tmp.v1.x), (float)(e.y + y + Tmp.v1.y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * 60.0f)));
        }
        Draw.color();
        Draw.mixcol((Color)e.color, (float)1.0f);
        Draw.rect((TextureRegion)type.fullIcon, (float)e.x, (float)e.y, (float)((float)type.fullIcon.width * e.fout((Interp)Interp.pow2Out) * Draw.scl * 1.2f), (float)((float)type.fullIcon.height * e.fout((Interp)Interp.pow2Out) * Draw.scl * 1.2f), (float)(e.rotation - 90.0f));
        Draw.reset();
    });
    public static Effect jumpTrailOut = new Effect(120.0f, 200.0f, e -> {
        if (!(e.data instanceof UnitType)) {
            return;
        }
        UnitType type = (UnitType)e.data();
        Draw.color((Color)(type.engineColor == null ? e.color : type.engineColor));
        if (type.engineLayer > 0.0f) {
            Draw.z((float)type.engineLayer);
        } else {
            Draw.z((float)((type.lowAltitude ? 90.0f : 115.0f) - 0.001f));
        }
        Tmp.v2.trns(e.rotation, 2300.0f);
        for (int index = 0; index < type.engines.size; ++index) {
            UnitType.UnitEngine engine = (UnitType.UnitEngine)type.engines.get(index);
            if (Angles.angleDist((float)engine.rotation, (float)-90.0f) > 75.0f) {
                return;
            }
            float ang = Mathf.slerp((float)engine.rotation, (float)-90.0f, (float)0.75f);
            Tmp.v1.trns(e.rotation, engine.y, -engine.x).add(Tmp.v2);
            rand.setSeed((long)e.id);
            e.scaled(80.0f, i -> {
                DrawFunc.tri(i.x + Tmp.v1.x, i.y + Tmp.v1.y, engine.radius * 3.0f * i.fout((Interp)Interp.slowFast), 2300 + rand.range(120), i.rotation + ang - 90.0f);
                Fill.circle((float)(i.x + Tmp.v1.x), (float)(i.y + Tmp.v1.y), (float)(engine.radius * 3.0f * i.fout((Interp)Interp.slowFast)));
            });
            Angles.randLenVectors((long)(e.id + index), (int)42, (float)2330.0f, (float)(e.rotation + ang - 90.0f), (float)0.0f, (x, y) -> Lines.lineAngle((float)(e.x + x + Tmp.v1.x), (float)(e.y + y + Tmp.v1.y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * 60.0f)));
        }
    });
    public static Effect dataTransport = new Effect(60.0f, 100.0f, e -> {
        rand.setSeed((long)e.id);
        int i = rand.random(8, 10000);
        Vec2 vec2 = Tmp.v1.setToRandomDirection(rand).scl(rand.random(36.0f, 80.0f) * e.rotation * e.fout((Interp)Interp.pow2Out)).add(e.x, e.y);
        String text = Integer.toBinaryString(i).substring(1);
        Font font = Fonts.tech;
        GlyphLayout layout = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.1f) * e.rotation * (e.fout((Interp)Interp.pow2In) * 3.0f + 1.0f) / 4.0f / Scl.scl((float)1.0f) + 0.01f);
        layout.setText(font, (CharSequence)text);
        font.setColor(e.color);
        font.draw((CharSequence)text, vec2.x, vec2.y, 1);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free((Object)layout);
    });
    public static Effect darkEnergySpread = new Effect(32.0f, e -> Angles.randLenVectors((long)e.id, (int)2, (float)(6.0f + 45.0f * e.fin()), (x, y) -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 15.0f));
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 9.0f));
        Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 25.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    }));
    public static Effect largeDarkEnergyHitCircle = new Effect(20.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 44.0f));
        Angles.randLenVectors((long)e.id, (int)5, (float)(60.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 8.0f)));
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 30.0f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 55.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    });
    public static Effect largeDarkEnergyHit = new Effect(50.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 44.0f));
        Lines.stroke((float)(e.fout() * 3.2f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 80.0f));
        Lines.stroke((float)(e.fout() * 2.5f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 50.0f));
        Lines.stroke((float)(e.fout() * 3.2f));
        Angles.randLenVectors((long)e.id, (int)30, (float)(18.0f + 80.0f * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 14.0f + 5.0f)));
        Draw.z((float)110.0001f);
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 30.0f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 80.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
        Draw.z((float)99.89f);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 31.0f));
        Draw.z((float)109.9999f);
    }).layer(109.9999f);
    public static Effect mediumDarkEnergyHit = new Effect(23.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Lines.stroke((float)(e.fout() * 2.8f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 60.0f));
        Lines.stroke((float)(e.fout() * 2.12f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 35.0f));
        Lines.stroke((float)(e.fout() * 2.25f));
        Angles.randLenVectors((long)e.id, (int)9, (float)(7.0f + 60.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(4.0f + e.fout() * 12.0f)));
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 22.0f));
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 14.0f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 80.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    });
    public static Effect darkEnergySmokeBig = new Effect(30.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 32.0f));
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 20.0f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 36.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    });
    public static Effect darkEnergyShootBig = new Effect(40.0f, 100.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Lines.stroke((float)(e.fout() * 3.7f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 100.0f + 15.0f));
        Lines.stroke((float)(e.fout() * 2.5f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 60.0f + 15.0f));
        Angles.randLenVectors((long)e.id, (int)15, (float)(7.0f + 60.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(4.0f + e.fout() * 16.0f)));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 120.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    });
    public static Effect polyTrail = new Effect(25.0f, e -> {
        Draw.color((Color)e.color, (Color)Pal.gray, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)4, (float)(46.0f * e.fin()), (x, y) -> {
            Fill.poly((float)(e.x + x), (float)(e.y + y), (int)6, (float)(e.rotation * e.fslope() * e.fout()));
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * e.rotation * 1.15f), (Color)e.color, (float)0.7f);
        });
    });
    public static Effect darkEnergyLaserShoot = new Effect(26.0f, 880.0f, e -> {
        Draw.color((Color)Color.white, (Color)NHColor.darkEnrColor, (float)(e.fin() * 0.75f));
        float length = !(e.data instanceof Float) ? 70.0f : ((Float)e.data).floatValue();
        Angles.randLenVectors((long)e.id, (int)9, (float)length, (float)e.rotation, (float)0.0f, (x, y) -> {
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * (length / 14.0f)));
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * (length / 12.0f)), (Color)NHColor.darkEnrColor, (float)0.7f);
        });
    });
    public static Effect circleShieldBreak = new Effect(30.0f, 600.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(3.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation + e.fin() * 5.0f));
    }).followParent(true);
    public static Effect darkEnergySmoke = new Effect(25.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Angles.randLenVectors((long)e.id, (int)4, (float)(60.0f * e.fin()), (float)e.rotation, (float)30.0f, (x, y) -> {
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f));
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.5f), (Color)NHColor.darkEnrColor, (float)0.7f);
        });
    });
    public static Effect darkEnergyShoot = new Effect(25.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        for (int i : Mathf.signs) {
            DrawFunc.tri(e.x, e.y, 2.0f + 2.0f * e.fout(), 28.0f * e.fout(), e.rotation + (float)(90 * i));
        }
    });
    public static Effect darkEnergyCharge = new Effect(130.0f, e -> {
        rand.setSeed((long)e.id);
        Angles.randLenVectors((long)e.id, (int)12, (float)(140.0f * e.fout((Interp)Interp.pow3Out)), (x, y) -> {
            Draw.color((Color)NHColor.darkEnrColor);
            float rad = rand.random(9.0f, 18.0f);
            float scl = rand.random(0.6f, 1.0f);
            float dx = e.x + scl * x;
            float dy = e.y + scl * y;
            Fill.circle((float)dx, (float)dy, (float)(e.fin() * rad));
            Draw.color((Color)NHColor.darkEnr);
            Draw.z((float)110.0001f);
            Fill.circle((float)dx, (float)dy, (float)(e.fin() * rad / 1.8f));
            Draw.z((float)99.89f);
            Fill.circle((float)dx, (float)dy, (float)(e.fin() * rad / 1.8f));
            Draw.z((float)110.0f);
            Drawf.light((float)dx, (float)dy, (float)(e.fin() * rad * 1.5f), (Color)NHColor.darkEnrColor, (float)0.7f);
        });
    });
    public static Effect hugeTrail = new Effect(40.0f, e -> {
        Draw.color((Color)e.color);
        Draw.alpha((float)(e.fout(0.85f) * 0.85f));
        Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + e.rotation * 5.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)(e.fout((Interp)Interp.pow3Out) * e.rotation)));
    });
    public static Effect hugeSmokeGray = new Effect(40.0f, e -> {
        Draw.color((Color)Color.gray, (Color)Color.darkGray, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + 19.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)(e.fout() * 2.0f)));
        e.scaled(25.0f, i -> Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + 19.0f * i.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(i.fout() * 4.0f))));
    });
    public static Effect hugeSmoke = new Effect(40.0f, e -> {
        Draw.color((Color)e.color);
        Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + 19.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)(e.fout() * 2.0f)));
        e.scaled(25.0f, i -> Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + 19.0f * i.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(i.fout() * 4.0f))));
    });
    public static Effect hugeSmokeLong = new Effect(120.0f, e -> {
        Draw.color((Color)e.color);
        Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + 19.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)(e.fout() * 2.0f)));
        e.scaled(25.0f, i -> Angles.randLenVectors((long)e.id, (int)6, (float)(2.0f + 19.0f * i.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(i.fout() * 4.0f))));
    });
    public static Effect darkEnergyChargeBegin = new Effect(130.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * 32.0f));
        Lines.stroke((float)(e.fin() * 3.7f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fout() * 80.0f));
        Draw.z((float)110.0001f);
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * 20.0f));
        Draw.z((float)99.89f);
        Draw.color((Color)NHColor.darkEnr);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * 22.0f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fin() * 35.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    });
    public static Effect upgrading = new Effect(30.0f, e -> {
        Draw.color((Color)e.color);
        float drawSize = e.rotation * 8.0f * e.fout();
        Draw.rect((TextureRegion)Core.atlas.find("new-horizon-upgrade"), (float)e.x, (float)(e.y + e.rotation * 8.0f * 1.35f * e.finpow()), (float)drawSize, (float)drawSize);
    });
    public static Effect darkErnExplosion = new Effect(40.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        e.scaled(20.0f, i -> {
            Lines.stroke((float)(3.0f * i.foutpow()));
            Lines.circle((float)e.x, (float)e.y, (float)(3.0f + i.finpow() * 80.0f));
        });
        Lines.stroke((float)e.fout());
        Angles.randLenVectors((long)(e.id + 1), (int)8, (float)(1.0f + 60.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(1.0f + e.fout() * 3.0f)));
        Draw.color((Color)Color.gray);
        Angles.randLenVectors((long)e.id, (int)5, (float)(2.0f + 70.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f + 0.5f)));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout((Interp)Interp.pow2Out) * 100.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    });
    public static Effect lightSkyCircleSplash = new Effect(26.0f, e -> {
        Draw.color((Color)NHColor.lightSkyBack);
        Angles.randLenVectors((long)e.id, (int)4, (float)(3.0f + 23.0f * e.fin()), (x, y) -> {
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.0f));
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.5f), (Color)NHColor.lightSkyBack, (float)0.7f);
        });
    });
    public static Effect darkEnrCircleSplash = new Effect(26.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Angles.randLenVectors((long)e.id, (int)4, (float)(3.0f + 23.0f * e.fin()), (x, y) -> {
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.5f));
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 5.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
        });
    });
    public static Effect circleSplash = new Effect(26.0f, e -> {
        Draw.color((Color)Color.white, (Color)e.color, (float)(e.fin() + 0.15f));
        Angles.randLenVectors((long)e.id, (int)4, (float)(3.0f + 23.0f * e.fin()), (x, y) -> {
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.0f));
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.5f), (Color)e.color, (float)0.7f);
        });
    });
    public static Effect blastgenerate = new MultiEffect(new Effect[]{new Effect(40.0f, 600.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Lines.stroke((float)(e.fout() * 3.7f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow3Out) * 240.0f + 15.0f));
        rand.setSeed((long)e.id);
        Angles.randLenVectors((long)e.id, (int)12, (float)(8.0f + 60.0f * e.fin((Interp)Interp.pow5Out)), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout(Interp.circleIn) * (6.0f + rand.random(6.0f)))));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 320.0f), (Color)NHColor.darkEnrColor, (float)0.7f);
    }), NHFx.circleOut(NHColor.darkEnrColor, 120.0f)});
    public static Effect blastAccept = new Effect(20.0f, e -> {
        Draw.color((Color)NHColor.darkEnrColor);
        Angles.randLenVectors((long)e.id, (int)3, (float)(5.0f + 30.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f)));
    });
    public static Effect thurmixHit = new Effect(35.0f, 80.0f, e -> {
        Draw.color((Color)NHColor.thurmixRedLight, (Color)Color.white, (float)e.fin());
        Lines.stroke((float)(3.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(75.0f * e.fin()));
        Lines.stroke((float)(1.3f * e.fslope()));
        e.scaled(20.0f, i -> Angles.randLenVectors((long)e.id, (int)11, (float)(1.0f + 60.0f * i.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(5.0f + i.fslope() * 8.0f))));
        Draw.color((Color)Color.gray);
        Angles.randLenVectors((long)(e.id + 1), (int)7, (float)(8.0f + 70.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 6.0f + 0.5f)));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 80.0f), (Color)NHColor.thurmixRedLight, (float)0.7f);
    });
    public static Effect hyperCloud = new Effect(140.0f, 400.0f, e -> Angles.randLenVectors((long)e.id, (int)20, (float)(e.finpow() * 160.0f), (x, y) -> {
        float size = e.fout() * 15.0f;
        Draw.color((Color)e.color, (Color)Color.lightGray, (float)e.fin());
        Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(size / 2.0f));
        Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * size), (Color)e.color, (float)0.7f);
    }));
    public static Effect hyperExplode = new Effect(30.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.75f));
        Lines.stroke((float)(1.3f * e.fslope()));
        Lines.circle((float)e.x, (float)e.y, (float)(45.0f * e.fin()));
        Angles.randLenVectors((long)(e.id + 1), (int)5, (float)(8.0f + 60.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 7.0f)));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 70.0f), (Color)e.color, (float)0.7f);
    });
    public static Effect hyperInstall = new Effect(30.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.55f));
        Lines.stroke((float)(2.5f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(75.0f * e.fin()));
        Lines.stroke((float)(1.3f * e.fslope()));
        Lines.circle((float)e.x, (float)e.y, (float)(45.0f * e.fin()));
        for (int i = 0; i < 4; ++i) {
            DrawFunc.tri(e.x, e.y, e.rotation * (e.fout() + 1.0f) / 3.0f, e.rotation * 27.0f * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.12f) * e.fout(), i * 90);
        }
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 80.0f), (Color)e.color, (float)0.7f);
    });
    public static Effect emped = new Effect(20.0f, e -> {
        Draw.color((Color)Color.valueOf((String)"#F7B080"), (Color)Color.valueOf((String)"#915923"), (float)e.fin());
        Lines.stroke((float)(e.fout() * 2.4f));
        Angles.randLenVectors((long)e.id, (int)4, (float)(7.0f + 50.0f * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 5.0f + 1.0f)));
        Draw.color((Color)Color.gray, (Color)Color.darkGray, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)3, (float)(3.0f + 28.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f)));
    });
    public static Effect hyperSpace = new Effect(600.0f, 300.0f, e -> {
        Draw.color((Color)e.color);
        float step = 0.2475f;
        float finX = Mathf.curve((float)e.fslope(), (float)0.0f, (float)0.2475f);
        float finY = Mathf.curve((float)e.fslope(), (float)0.2975f, (float)0.495f);
        Fill.rect((float)e.x, (float)e.y, (float)(e.rotation * finX), (float)((e.rotation - 1.0f) * finY + 1.0f));
    });
    public static Effect triTrail = new Effect(28.0f, 50.0f, e -> {
        Rand rand = NHFunc.rand;
        rand.setSeed((long)e.id);
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        for (int i : Mathf.signs) {
            float ang = e.rotation - 180.0f + (float)(rand.random(10, 45) * i);
            Tmp.v1.trns(ang, (float)rand.random(4, 14) * (0.75f + e.fin() * 1.5f)).scl(0.3f + e.fin((Interp)Interp.pow3Out)).add(e.x, e.y);
            DrawFunc.arrow(Tmp.v1.x, Tmp.v1.y, rand.random(3.0f, 6.5f) * e.fout(), (float)rand.random(17, 28) * e.fout((Interp)Interp.pow3Out) * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f), (float)rand.random(-4, -8) * e.fout(), ang);
        }
    });
    public static Effect ultFireBurn = new Effect(25.0f, e -> {
        Draw.color((Color)NHColor.lightSkyBack, (Color)Color.gray, (float)(e.fin() * 0.75f));
        Angles.randLenVectors((long)e.id, (int)2, (float)(2.0f + e.fin() * 7.0f), (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(0.2f + e.fout() * 1.5f), (float)45.0f));
    }).layer(101.0f);
    public static Effect slidePoly = new Effect(60.0f, 600.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        Position data = (Position)e.data();
        e.lifetime = data.dst(e.x, e.y) / 7.0f;
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f));
        Lines.stroke((float)(4.0f * e.fout()));
        Lines.poly((float)Mathf.lerp((float)e.x, (float)data.getX(), (float)e.fin((Interp)Interp.pow2Out)), (float)Mathf.lerp((float)e.y, (float)data.getY(), (float)e.fin((Interp)Interp.pow2Out)), (int)6, (float)(Math.max(10.0f, e.rotation - 18.0f) * e.fin() + 18.0f));
    });
    public static Effect lightningFade = new Effect(PosLightning.lifetime, 1200.0f, e -> {
        if (!(e.data instanceof Vec2Seq)) {
            return;
        }
        Vec2Seq points = (Vec2Seq)e.data();
        e.lifetime = points.size() < 2 ? 0.0f : 1000.0f;
        int strokeOffset = (int)e.rotation;
        if (points.size() > strokeOffset + 1 && strokeOffset > 0 && points.size() > 2) {
            points.removeRange(0, points.size() - strokeOffset - 1);
        }
        if (!Vars.state.isPaused() && points.any()) {
            points.remove(0);
        }
        if (points.size() < 2) {
            return;
        }
        Vec2 data = points.peekTmp();
        float stroke = data.x;
        float fadeOffset = data.y;
        Draw.color((Color)e.color);
        for (int i = 1; i < points.size() - 1; ++i) {
            Lines.stroke((float)(Mathf.clamp((float)(((float)i + fadeOffset / 2.0f) / (float)points.size() * (float)(strokeOffset - (points.size() - i)) / (float)strokeOffset)) * stroke));
            Vec2 from = points.setVec2(i - 1, Tmp.v1);
            Vec2 to = points.setVec2(i, Tmp.v2);
            Lines.line((float)from.x, (float)from.y, (float)to.x, (float)to.y, (boolean)false);
            Fill.circle((float)from.x, (float)from.y, (float)(Lines.getStroke() / 2.0f));
        }
        Vec2 last = points.tmpVec2(points.size() - 2);
        Fill.circle((float)last.x, (float)last.y, (float)(Lines.getStroke() / 2.0f));
    }).layer(109.999f);
    public static Effect crossBlastArrow45 = new Effect(65.0f, 140.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.55f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 70.0f), (Color)e.color, (float)0.7f);
        e.scaled(10.0f, i -> {
            Lines.stroke((float)(1.35f * i.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(49.0f * i.finpow()));
        });
        rand.setSeed((long)e.id);
        float sizeDiv = 138.0f;
        float randL = rand.random(sizeDiv);
        float f = Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f);
        for (int i2 = 0; i2 < 4; ++i2) {
            Tmp.v1.trns((float)(45 + i2 * 90), 66.0f);
            DrawFunc.arrow(e.x + Tmp.v1.x, e.y + Tmp.v1.y, 27.5f * (e.fout() * 3.0f + 1.0f) / 4.0f * e.fout((Interp)Interp.pow3In), (sizeDiv + randL) * f * e.fout((Interp)Interp.pow3), -randL / 6.0f * f, i2 * 90 + 45);
        }
    });
    public static Effect crossBlast = new Effect(35.0f, 140.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.55f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 70.0f), (Color)e.color, (float)0.7f);
        e.scaled(10.0f, i -> {
            Lines.stroke((float)(1.35f * i.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(49.0f * i.finpow()));
        });
        rand.setSeed((long)e.id);
        float sizeDiv = 35.0f;
        float randL = rand.random(sizeDiv);
        for (int i2 = 0; i2 < 4; ++i2) {
            DrawFunc.tri(e.x, e.y, 3.5f * (e.fout() * 3.0f + 1.0f) / 4.0f * (e.fout((Interp)Interp.pow3In) + 0.5f) / 1.5f, (sizeDiv + randL) * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f) * e.fout((Interp)Interp.pow3), i2 * 90);
        }
    });
    public static Effect crossBlast_45 = new Effect(35.0f, 140.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.55f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 70.0f), (Color)e.color, (float)0.7f);
        e.scaled(10.0f, i -> {
            Lines.stroke((float)(1.35f * i.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(55.0f * i.finpow()));
        });
        rand.setSeed((long)e.id);
        float sizeDiv = 60.0f;
        float randL = rand.random(sizeDiv);
        for (int i2 = 0; i2 < 4; ++i2) {
            DrawFunc.tri(e.x, e.y, 5.85f * (e.fout() * 3.0f + 1.0f) / 4.0f * (e.fout((Interp)Interp.pow3In) + 0.5f) / 1.5f, (sizeDiv + randL) * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f) * e.fout((Interp)Interp.pow3), i2 * 90 + 45);
        }
    });
    public static Effect triSpark = new Effect(30.0f, e -> {
        rand.setSeed((long)e.id);
        Draw.color((Color)e.color, (Color)Color.white, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)2, (float)(1.0f + 8.0f * e.fin()), (float)4.0f, (x, y) -> {
            float randN = rand.random(120.0f);
            Fill.poly((float)(e.x + x), (float)(e.y + y), (int)3, (float)(e.fout() * 4.0f * rand.random(0.8f, 1.2f)), (float)(e.rotation + randN * e.fin()));
        });
    });
    public static Effect triSpark1 = new Effect(26.0f, e -> {
        rand.setSeed((long)e.id);
        Draw.color((Color)Pal.techBlue, (Color)Color.white, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)3, (float)(3.0f + 24.0f * e.fin()), (float)5.0f, (x, y) -> {
            float randN = rand.random(120.0f);
            Fill.poly((float)(e.x + x), (float)(e.y + y), (int)3, (float)(e.fout() * 8.0f * rand.random(0.8f, 1.2f)), (float)(e.rotation + randN * e.fin()));
        });
    });
    public static Effect triSpark2 = new Effect(26.0f, e -> {
        rand.setSeed((long)e.id);
        Draw.color((Color)NHColor.ancient, (Color)Color.white, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)3, (float)(3.0f + 24.0f * e.fin()), (float)5.0f, (x, y) -> {
            float randN = rand.random(120.0f);
            Fill.poly((float)(e.x + x), (float)(e.y + y), (int)3, (float)(e.fout() * 8.0f * rand.random(0.8f, 1.2f)), (float)(e.rotation + randN * e.fin()));
        });
    });

    public static float fslope(float fin) {
        return (0.5f - Math.abs(fin - 0.5f)) * 2.0f;
    }

    public static float fout(float fin, float margin) {
        if (fin >= 1.0f - margin) {
            return 1.0f - (fin - (1.0f - margin)) / margin;
        }
        return 1.0f;
    }

    public static void drawDark(Runnable runnable) {
        Draw.draw((float)99.89f, (Runnable)runnable);
        Draw.draw((float)110.0001f, (Runnable)runnable);
    }

    public static int hash(String m, Color c) {
        return Arrays.hashCode(new int[]{m.hashCode(), c.hashCode()});
    }

    public static Effect get(String m, Color c, Effect effect) {
        int hash = NHFx.hash(m, c);
        Effect or = (Effect)same.get(hash);
        if (or == null) {
            same.put(hash, (Object)effect);
        }
        return or == null ? effect : or;
    }

    public static Effect spreadOutSpark(float lifetime, float radius, int sparks, int sparkSpikes, float sparkLifetime, float sparkSize, float sparkLength, Interp spreadOutInterp) {
        return new Effect(lifetime, radius * 2.0f, e -> {
            rand.setSeed((long)e.id);
            float finT = e.lifetime * e.fin(spreadOutInterp);
            for (int s = 0; s < sparks; ++s) {
                float sBegin = rand.random(e.lifetime - sparkLifetime);
                float fin = (finT - sBegin) / sparkLifetime;
                if (fin < 0.0f || fin > 1.0f) continue;
                float fout = 1.0f - fin;
                float fslope = (0.5f - Math.abs(fin - 0.5f)) * 2.0f;
                rand2.setSeed((long)(e.id + s));
                v.setToRandomDirection(rand2).scl(radius * sBegin / (e.lifetime - sparkLifetime));
                Tmp.c1.set(e.color).lerp(Color.white, fout * 0.7f);
                Draw.color((Color)Tmp.c1);
                Lines.stroke((float)(1.2f * Mathf.curve((float)fout, (float)0.0f, (float)0.22f)));
                Angles.randLenVectors((long)(e.id + s + 1), (int)sparkSpikes, (float)(sparkSize * fin), (x, y) -> {
                    Lines.lineAngle((float)(e.x + x + NHFx.v.x), (float)(e.y + y + NHFx.v.y), (float)Mathf.angle((float)x, (float)y), (float)(fslope * sparkLength + 2.0f));
                    Drawf.light((float)(e.x + x + NHFx.v.x), (float)(e.y + y + NHFx.v.y), (float)(fin * sparkLength * fslope * 1.3f), (Color)Tmp.c1, (float)0.7f);
                });
            }
        });
    }

    public static Effect subEffect(float lifetime, float radius, int num, float childLifetime, Interp spreadOutInterp, EffectParam drawer) {
        return new Effect(lifetime, radius * 2.0f, e -> {
            rand.setSeed((long)e.id);
            float finT = e.lifetime * e.fin(spreadOutInterp);
            for (int s = 0; s < num; ++s) {
                float sBegin = rand.random(e.lifetime - childLifetime);
                float fin = (finT - sBegin) / childLifetime;
                if (fin < 0.0f || fin > 1.0f) continue;
                float fout = 1.0f - fin;
                rand2.setSeed((long)(e.id + s));
                float theta = rand2.random(0.0f, (float)Math.PI * 2);
                v.set(Mathf.cos((float)theta), Mathf.sin((float)theta)).scl(radius * sBegin / (e.lifetime - childLifetime));
                Tmp.c1.set(e.color).lerp(Color.white, fout * 0.7f);
                Draw.color((Color)Tmp.c1);
                drawer.draw(e.id + s + 9999, e.x + NHFx.v.x, e.y + NHFx.v.y, 57.295776f * theta, fin);
            }
        });
    }

    public static Effect circleOut(float lifetime, float radius, float thick) {
        return new Effect(lifetime, radius * 2.0f, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.7f));
            Lines.stroke((float)(thick * e.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(radius * e.fin((Interp)Interp.pow3Out)));
        });
    }

    public static Effect squareRand(Color color, float sizeMin, float sizeMax) {
        return new Effect(20.0f, sizeMax * 2.0f, e -> {
            Draw.color((Color)Color.white, (Color)color, (float)(e.fin() + 0.15f));
            if (e.id % 2 == 0) {
                Lines.stroke((float)(1.5f * e.fout((Interp)Interp.pow3Out)));
                Lines.square((float)e.x, (float)e.y, (float)(Mathf.randomSeed((long)e.id, (float)sizeMin, (float)sizeMax) * e.fin((Interp)Interp.pow2Out) + 3.0f), (float)45.0f);
            } else {
                Fill.square((float)e.x, (float)e.y, (float)(Mathf.randomSeed((long)e.id, (float)(sizeMin * 0.5f), (float)(sizeMin * 0.8f)) * e.fout((Interp)Interp.pow2Out)), (float)45.0f);
            }
        });
    }

    public static Effect railShoot(Color color, float length, float width, float lifetime, float spacing) {
        return new Effect(lifetime, length * 2.0f, e -> {
            TextureRegion arrowRegion = NHContent.arrowRegion;
            Draw.color((Color)color);
            float railF = Mathf.curve((float)e.fin((Interp)Interp.pow2Out), (float)0.0f, (float)0.25f) * Mathf.curve((float)e.fout((Interp)Interp.pow4Out), (float)0.0f, (float)0.3f) * e.fin();
            int i = 0;
            while ((float)i <= length / spacing) {
                Tmp.v1.trns(e.rotation, (float)i * spacing);
                float f = Interp.pow3Out.apply(Mathf.clamp((float)((e.fin() * length - (float)i * spacing) / spacing))) * (0.6f + railF * 0.4f);
                Draw.rect((TextureRegion)arrowRegion, (float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)((float)arrowRegion.width * Draw.scl * f), (float)((float)arrowRegion.height * Draw.scl * f), (float)(e.rotation - 90.0f));
                ++i;
            }
            Tmp.v1.trns(e.rotation, 0.0f, (2.0f - railF) * 8.0f * 1.4f);
            Lines.stroke((float)(railF * 2.0f));
            for (int i2 : Mathf.signs) {
                Lines.lineAngle((float)(e.x + Tmp.v1.x * (float)i2), (float)(e.y + Tmp.v1.y * (float)i2), (float)e.rotation, (float)(length * (0.75f + railF / 4.0f) * Mathf.curve((float)e.fout((Interp)Interp.pow5Out), (float)0.0f, (float)0.1f)));
            }
        }).followParent(true);
    }

    public static Effect polyTrail(Color fromColor, Color toColor, float size, float lifetime) {
        return new Effect(lifetime, size * 2.0f, e -> {
            Draw.color((Color)fromColor, (Color)toColor, (float)e.fin());
            Fill.poly((float)e.x, (float)e.y, (int)6, (float)(size * e.fout()), (float)e.rotation);
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * size), (Color)fromColor, (float)0.7f);
        });
    }

    public static Effect genericCharge(Color color, float size, float range, float lifetime) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)color);
            Lines.stroke((float)(size / 7.0f * e.fin()));
            Angles.randLenVectors((long)e.id, (int)15, (float)(3.0f + 60.0f * e.fout()), (float)e.rotation, (float)range, (x, y) -> {
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * size + size / 4.0f));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout(0.25f) * size), (Color)color, (float)0.7f);
            });
            Fill.circle((float)e.x, (float)e.y, (float)(size * 0.48f * Interp.pow3Out.apply(e.fin())));
        });
    }

    public static Effect genericChargeBegin(Color color, float size, float lifetime) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)color);
            Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * size));
            Drawf.light((float)e.x, (float)e.y, (float)(e.fin() * size), (Color)color, (float)0.7f);
            Draw.color();
            Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * size / 2.0f));
        });
    }

    public static Effect lightningHitSmall(Color color) {
        return NHFx.get("lightningHitSmall", color, new Effect(20.0f, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.7f));
            Angles.randLenVectors((long)e.id, (int)5, (float)(18.0f * e.fin()), (x, y) -> {
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 6.0f + 2.0f));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fin() * 12.0f * e.fout(0.25f)), (Color)color, (float)0.7f);
            });
        }));
    }

    public static Effect shootCircle(float size) {
        return new Effect(45.0f, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.75f));
            rand.setSeed((long)e.id);
            Angles.randLenVectors((long)e.id, (int)((int)(size / 7.0f)), (float)(3.0f + size * 1.5f * e.fin()), (float)e.rotation, (float)25.0f, (x, y) -> {
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * rand.random(1.5f, 3.2f) * size / 30.0f));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.5f), (Color)e.color, (float)0.7f);
            });
        });
    }

    public static Effect shootCircleSmall(Color color) {
        return NHFx.get("shootCircleSmall", color, new Effect(30.0f, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.75f));
            rand.setSeed((long)e.id);
            Angles.randLenVectors((long)e.id, (int)3, (float)(3.0f + 23.0f * e.fin()), (float)e.rotation, (float)22.0f, (x, y) -> {
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * rand.random(1.5f, 3.2f)));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.5f), (Color)color, (float)0.7f);
            });
        }));
    }

    public static Effect shootLineSmall(Color color) {
        return NHFx.get("shootLineSmall", color, new Effect(37.0f, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.7f));
            Angles.randLenVectors((long)e.id, (int)4, (float)(8.0f + 32.0f * e.fin()), (float)e.rotation, (float)22.0f, (x, y) -> {
                Lines.stroke((float)(1.25f * e.fout(0.2f)));
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * 6.0f + 3.0f));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 13.0f + 3.0f), (Color)color, (float)0.7f);
            });
        }));
    }

    public static Effect shootLine(float size, float angleRange) {
        int num = Mathf.clamp((int)((int)size / 6), (int)6, (int)20);
        float thick = Mathf.clamp((float)0.75f, (float)2.0f, (float)(size / 22.0f));
        return new Effect(37.0f, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.7f));
            rand.setSeed((long)e.id);
            DrawFunc.randLenVectors(e.id, num, 4.0f + size * 1.2f * e.fin(), size * 0.15f * e.fin(), e.rotation, angleRange, (x, y) -> {
                Lines.stroke((float)(thick * e.fout(0.32f)));
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)((e.fslope() + e.fin()) * 0.5f * (size * rand.random(0.15f, 0.5f) + rand.random(2.0f)) + rand.random(2.0f)));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fslope() * (size * 0.5f + 14.0f) + 3.0f), (Color)e.color, (float)0.7f);
            });
        });
    }

    public static Effect shootSquare(float lifetime, int num, float size, float angle, float range, float angleRange) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.7f));
            rand.setSeed((long)e.id);
            DrawFunc.randLenVectors(e.id, num, size + range * e.fin(), size * 0.15f * e.fin(), e.rotation, angleRange, (x, y) -> {
                float size0 = (e.fslope() + e.fout()) * 0.5f * (size * rand.random(0.25f, 1.0f));
                Fill.square((float)(e.x + x), (float)(e.y + y), (float)size0, (float)angle);
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(size0 * 1.25f), (Color)e.color, (float)0.7f);
            });
        });
    }

    public static Effect laserHit(Color color) {
        return NHFx.get("laserHit", color, new Effect(20.0f, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.7f));
            Angles.randLenVectors((long)e.id, (int)9, (float)(18.0f * e.fin()), (float)e.rotation, (float)40.0f, (x, y) -> {
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 8.0f + 2.0f));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout(0.25f) * 12.0f), (Color)color, (float)0.7f);
            });
        }));
    }

    public static Effect lightningHitLarge(Color color) {
        return NHFx.get("lightningHitLarge", color, new Effect(50.0f, 180.0f, e -> {
            Draw.color((Color)color);
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 90.0f), (Color)color, (float)0.7f);
            e.scaled(25.0f, t -> {
                Lines.stroke((float)(3.0f * t.fout()));
                Lines.circle((float)e.x, (float)e.y, (float)(3.0f + t.fin((Interp)Interp.pow3Out) * 80.0f));
            });
            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 8.0f));
            Angles.randLenVectors((long)(e.id + 1), (int)4, (float)(1.0f + 60.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 5.0f)));
            Draw.color((Color)Color.gray);
            Angles.randLenVectors((long)e.id, (int)8, (float)(2.0f + 30.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f + 0.5f)));
        }));
    }

    public static Effect blast(Color color, float range) {
        float lifetime = Mathf.clamp((float)(range * 1.5f), (float)90.0f, (float)600.0f);
        return new Effect(lifetime, range * 2.5f, e -> {
            Draw.color((Color)color);
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * range), (Color)color, (float)0.7f);
            e.scaled(lifetime / 3.0f, t -> {
                Lines.stroke((float)(3.0f * t.fout()));
                Lines.circle((float)e.x, (float)e.y, (float)(8.0f + t.fin(Interp.circleOut) * range * 1.35f));
            });
            e.scaled(lifetime / 2.0f, t -> {
                Fill.circle((float)t.x, (float)t.y, (float)(t.fout() * 8.0f));
                if (NHSetting.enableDetails()) {
                    Angles.randLenVectors((long)(t.id + 1), (int)((int)(range / 13.0f)), (float)(2.0f + range * 0.75f * t.finpow()), (x, y) -> {
                        Fill.circle((float)(t.x + x), (float)(t.y + y), (float)(t.fout((Interp)Interp.pow2Out) * Mathf.clamp((float)(range / 15.0f), (float)3.0f, (float)14.0f)));
                        Drawf.light((float)(t.x + x), (float)(t.y + y), (float)(t.fout((Interp)Interp.pow2Out) * Mathf.clamp((float)(range / 15.0f), (float)3.0f, (float)14.0f)), (Color)color, (float)0.5f);
                    });
                }
            });
            if (!NHSetting.enableDetails()) {
                return;
            }
            Draw.z((float)99.999f);
            Draw.color((Color)Color.gray);
            Draw.alpha((float)0.85f);
            float intensity = Mathf.clamp((float)(range / 10.0f), (float)5.0f, (float)25.0f);
            int i = 0;
            while (i < 4) {
                rand.setSeed(((long)e.id << 1) + (long)i);
                float lenScl = rand.random(0.4f, 1.0f);
                int fi = i++;
                e.scaled(e.lifetime * lenScl, eIn -> Angles.randLenVectors((long)(eIn.id + fi - 1), (float)eIn.fin((Interp)Interp.pow10Out), (int)((int)(intensity / 2.5f)), (float)(8.0f * intensity), (x, y, in, out) -> {
                    float fout = eIn.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                    Fill.circle((float)(eIn.x + x), (float)(eIn.y + y), (float)(fout * ((2.0f + intensity) * 1.8f)));
                }));
            }
        });
    }

    public static Effect laserEffect(float num) {
        return new Effect(26.0f, e -> {
            Draw.color((Color)Color.white);
            float length = !(e.data instanceof Float) ? 70.0f : ((Float)e.data).floatValue();
            Angles.randLenVectors((long)e.id, (int)((int)(length / num)), (float)length, (float)e.rotation, (float)0.0f, (x, y) -> {
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * 9.0f));
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(e.fout(0.25f) * 12.0f), (Color)Color.white, (float)0.7f);
            });
        });
    }

    public static Effect chargeEffectSmall(Color color, float lifetime) {
        return new Effect(lifetime, 100.0f, e -> {
            Draw.color((Color)color);
            Drawf.light((float)e.x, (float)e.y, (float)(e.fin() * 55.0f), (Color)color, (float)0.7f);
            Angles.randLenVectors((long)e.id, (int)7, (float)(3.0f + 50.0f * e.fout()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.finpow() * 3.0f)));
            Lines.stroke((float)(e.fin() * 1.75f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fout() * 40.0f));
            Angles.randLenVectors((long)(e.id + 1), (int)16, (float)(3.0f + 70.0f * e.fout()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 7.0f + 3.0f)));
        });
    }

    public static Effect chargeBeginEffect(Color color, float size, float lifetime) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)color);
            Drawf.light((float)e.x, (float)e.y, (float)(e.fin() * size), (Color)color, (float)0.7f);
            Fill.circle((float)e.x, (float)e.y, (float)(size * e.fin()));
        });
    }

    public static Effect crossBlast(Color color) {
        return NHFx.get("crossBlast", color, NHFx.crossBlast(color, 72.0f));
    }

    public static Effect crossBlast(Color color, float size) {
        return NHFx.crossBlast(color, size, 0.0f);
    }

    public static Effect crossBlast(Color color, float size, float rotate) {
        return new Effect(Mathf.clamp((float)(size / 3.0f), (float)35.0f, (float)240.0f), size * 2.0f, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.55f));
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * size), (Color)color, (float)0.7f);
            e.scaled(10.0f, i -> {
                Lines.stroke((float)(1.35f * i.fout()));
                Lines.circle((float)e.x, (float)e.y, (float)(size * 0.7f * i.finpow()));
            });
            rand.setSeed((long)e.id);
            float sizeDiv = size / 1.5f;
            float randL = rand.random(sizeDiv);
            for (int i2 = 0; i2 < 4; ++i2) {
                DrawFunc.tri(e.x, e.y, size / 20.0f * (e.fout() * 3.0f + 1.0f) / 4.0f * (e.fout((Interp)Interp.pow3In) + 0.5f) / 1.5f, (sizeDiv + randL) * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f) * e.fout((Interp)Interp.pow3), (float)(i2 * 90) + rotate);
            }
        });
    }

    public static Effect hyperBlast(Color color) {
        return NHFx.get("hyperBlast", color, new Effect(30.0f, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.75f));
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * 55.0f), (Color)color, (float)0.7f);
            Lines.stroke((float)(1.3f * e.fslope()));
            Lines.circle((float)e.x, (float)e.y, (float)(45.0f * e.fin()));
            Angles.randLenVectors((long)(e.id + 1), (int)5, (float)(8.0f + 50.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 7.0f)));
        }));
    }

    public static Effect instShoot(Color color, Color colorInner) {
        return new Effect(24.0f, e -> {
            e.scaled(10.0f, b -> {
                Draw.color((Color)Color.white, (Color)color, (float)b.fin());
                Lines.stroke((float)(b.fout() * 3.0f + 0.2f));
                Lines.circle((float)b.x, (float)b.y, (float)(b.fin() * 50.0f));
            });
            Draw.color((Color)color);
            for (int i : Mathf.signs) {
                DrawFunc.tri(e.x, e.y, 8.0f * e.fout(), 85.0f, e.rotation + 90.0f * (float)i);
                DrawFunc.tri(e.x, e.y, 8.0f * e.fout(), 50.0f, 90.0f + 90.0f * (float)i);
            }
            if (!NHSetting.enableDetails()) {
                return;
            }
            Draw.color((Color)colorInner);
            for (int i : Mathf.signs) {
                DrawFunc.tri(e.x, e.y, 5.0f * e.fout(), 48.0f, e.rotation + 90.0f * (float)i);
                DrawFunc.tri(e.x, e.y, 5.0f * e.fout(), 29.0f, 90.0f + 90.0f * (float)i);
            }
        });
    }

    public static Effect hitSpark(Color color, float lifetime, int num, float range, float stroke, float length) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)color, (Color)Color.white, (float)(e.fout() * 0.3f));
            Lines.stroke((float)(e.fout() * stroke));
            Angles.randLenVectors((long)e.id, (int)num, (float)(e.finpow() * range), (float)e.rotation, (float)360.0f, (x, y) -> {
                float ang = Mathf.angle((float)x, (float)y);
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * length * 0.85f + length * 0.15f));
            });
        });
    }

    public static Effect instBomb(Color color) {
        return NHFx.get("instBomb", color, NHFx.instBombSize(color, 4, 80.0f));
    }

    public static Effect instBombSize(Color color, int num, float size) {
        return new Effect(22.0f, size * 1.5f, e -> {
            int i;
            Draw.color((Color)color);
            Lines.stroke((float)(e.fout() * 4.0f));
            Lines.circle((float)e.x, (float)e.y, (float)(4.0f + e.finpow() * size / 4.0f));
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * size), (Color)color, (float)0.7f);
            for (i = 0; i < num; ++i) {
                DrawFunc.tri(e.x, e.y, size / 12.0f, size * e.fout(), i * 90 + 45);
            }
            Draw.color();
            for (i = 0; i < num; ++i) {
                DrawFunc.tri(e.x, e.y, size / 26.0f, size / 2.5f * e.fout(), i * 90 + 45);
            }
        });
    }

    public static Effect instHit(Color color) {
        return NHFx.get("instHit", color, NHFx.instHit(color, 5, 50.0f));
    }

    public static Effect instHit(Color color, int num, float size) {
        return new Effect(20.0f, size * 1.5f, e -> {
            rand.setSeed((long)e.id);
            for (int i = 0; i < 2; ++i) {
                Draw.color((Color)(i == 0 ? color : color.cpy().lerp(Color.white, 0.25f)));
                float m = i == 0 ? 1.0f : 0.5f;
                for (int j = 0; j < num; ++j) {
                    float rot = e.rotation + rand.range(size);
                    float w = 15.0f * e.fout() * m;
                    DrawFunc.tri(e.x, e.y, w, (size + rand.range(size * 0.6f)) * m, rot);
                    DrawFunc.tri(e.x, e.y, w, size * 0.3f * m, rot + 180.0f);
                }
            }
            e.scaled(12.0f, c -> {
                Draw.color((Color)color.cpy().lerp(Color.white, 0.25f));
                Lines.stroke((float)(c.fout() * 2.0f + 0.2f));
                Lines.circle((float)e.x, (float)e.y, (float)(c.fin() * size * 1.1f));
            });
            if (NHSetting.enableDetails()) {
                e.scaled(18.0f, c -> {
                    Draw.color((Color)color);
                    Angles.randLenVectors((long)e.id, (int)25, (float)(8.0f + e.fin() * size * 1.25f), (float)e.rotation, (float)60.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(c.fout() * 3.0f), (float)45.0f));
                });
            }
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * size), (Color)color, (float)0.7f);
        });
    }

    public static Effect smoothColorRect(Color out, float rad, float lifetime) {
        return new Effect(lifetime, rad * 2.0f, e -> {
            Draw.blend((Blending)Blending.additive);
            float radius = e.fin((Interp)Interp.pow3Out) * rad;
            Fill.light((float)e.x, (float)e.y, (int)4, (float)radius, (float)45.0f, (Color)Color.clear, (Color)Tmp.c1.set(out).a(e.fout((Interp)Interp.pow5Out)));
            Draw.blend();
        }).layer(110.15f);
    }

    public static Effect smoothColorCircle(Color out, float rad, float lifetime) {
        return new Effect(lifetime, rad * 2.0f, e -> {
            Draw.blend((Blending)Blending.additive);
            float radius = e.fin((Interp)Interp.pow3Out) * rad;
            Fill.light((float)e.x, (float)e.y, (int)Lines.circleVertices((float)radius), (float)radius, (Color)Color.clear, (Color)Tmp.c1.set(out).a(e.fout((Interp)Interp.pow5Out)));
            Drawf.light((float)e.x, (float)e.y, (float)(radius * 1.3f), (Color)out, (float)(0.7f * e.fout(0.23f)));
            Draw.blend();
        }).layer(110.15f);
    }

    public static Effect smoothColorCircle(Color out, float rad, float lifetime, float alpha) {
        return new Effect(lifetime, rad * 2.0f, e -> {
            Draw.blend((Blending)Blending.additive);
            float radius = e.fin((Interp)Interp.pow3Out) * rad;
            Fill.light((float)e.x, (float)e.y, (int)Lines.circleVertices((float)radius), (float)radius, (Color)Color.clear, (Color)Tmp.c1.set(out).a(e.fout((Interp)Interp.pow5Out) * alpha));
            Drawf.light((float)e.x, (float)e.y, (float)(radius * 1.3f), (Color)out, (float)(0.7f * e.fout(0.23f)));
            Draw.blend();
        }).layer(110.15f);
    }

    public static Effect instTrail(Color color, float angle, boolean random) {
        return new Effect(30.0f, e -> {
            for (int j : angle == 0.0f ? oneArr : Mathf.signs) {
                for (int i = 0; i < 2; ++i) {
                    Draw.color((Color)(i == 0 ? color : color.cpy().lerp(Color.white, 0.15f)));
                    float m = i == 0 ? 1.0f : 0.5f;
                    float rot = e.rotation + 180.0f;
                    float w = 10.0f * e.fout() * m;
                    DrawFunc.tri(e.x, e.y, w, 30.0f + (random ? Mathf.randomSeedRange((long)e.id, (float)15.0f) : 8.0f) * m, rot + (float)j * angle);
                    if (angle == 0.0f) {
                        DrawFunc.tri(e.x, e.y, w, 10.0f * m, rot + 180.0f + (float)j * angle);
                        continue;
                    }
                    Fill.circle((float)e.x, (float)e.y, (float)(w / 2.0f));
                }
            }
        });
    }

    public static Effect lineCircleOut(Color color, float lifetime, float size, float stroke) {
        return new Effect(50.0f, e -> {
            Draw.color((Color)color);
            Lines.stroke((float)(e.fout() * stroke));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow3Out) * size));
        });
    }

    public static Effect lineSquareOut(Color color, float lifetime, float size, float stroke, float rotation) {
        return new Effect(50.0f, e -> {
            Draw.color((Color)color);
            Lines.stroke((float)(e.fout() * stroke));
            Lines.square((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow3Out) * size), (float)rotation);
        });
    }

    public static Effect polyCloud(Color color, float lifetime, float size, float range, int num) {
        return new Effect(lifetime, e -> Angles.randLenVectors((long)e.id, (int)num, (float)(range * e.finpow()), (x, y) -> {
            Draw.color((Color)color, (Color)Pal.gray, (float)(e.fin() * 0.65f));
            Fill.poly((float)(e.x + x), (float)(e.y + y), (int)6, (float)(size * e.fout()), (float)e.rotation);
            Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(size * e.fout() * 2.5f), (Color)color, (float)(e.fout() * 0.65f));
            Draw.color((Color)Color.white, (Color)Pal.gray, (float)(e.fin() * 0.65f));
            Fill.poly((float)(e.x + x), (float)(e.y + y), (int)6, (float)(size * e.fout() / 2.0f), (float)e.rotation);
        })).layer(100.0f);
    }

    public static Effect square(Color color, float lifetime, int num, float range, float size) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)color);
            rand.setSeed((long)e.id);
            Angles.randLenVectors((long)e.id, (int)num, (float)(range * e.finpow()), (x, y) -> {
                float s = e.fout((Interp)Interp.pow3In) * (size + rand.range(size / 3.0f));
                Fill.square((float)(e.x + x), (float)(e.y + y), (float)s, (float)45.0f);
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(s * 2.25f), (Color)color, (float)0.7f);
            });
        });
    }

    public static Effect circleSplash(Color color, float lifetime, int num, float range, float size) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)color);
            rand.setSeed((long)e.id);
            Angles.randLenVectors((long)e.id, (int)num, (float)(range * e.finpow()), (x, y) -> {
                float s = e.fout((Interp)Interp.pow3In) * (size + rand.range(size / 3.0f));
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)s);
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(s * 2.25f), (Color)color, (float)0.7f);
            });
        });
    }

    public static Effect circleOut(Color color, float range) {
        return new Effect(Mathf.clamp((float)(range / 2.0f), (float)45.0f, (float)360.0f), range * 1.5f, e -> {
            rand.setSeed((long)e.id);
            Draw.color((Color)Color.white, (Color)color, (float)(e.fin() + 0.6f));
            float circleRad = e.fin(Interp.circleOut) * range;
            Lines.stroke((float)(Mathf.clamp((float)(range / 24.0f), (float)4.0f, (float)20.0f) * e.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            if (NHSetting.enableDetails()) {
                int i = 0;
                while ((float)i < Mathf.clamp((float)(range / 12.0f), (float)9.0f, (float)60.0f)) {
                    Tmp.v1.set(1.0f, 0.0f).setToRandomDirection(rand).scl(circleRad);
                    DrawFunc.tri(e.x + Tmp.v1.x, e.y + Tmp.v1.y, rand.random(circleRad / 16.0f, circleRad / 12.0f) * e.fout(), rand.random(circleRad / 4.0f, circleRad / 1.5f) * (1.0f + e.fin()) / 2.0f, Tmp.v1.angle() - 180.0f);
                    ++i;
                }
            }
        });
    }

    public static Effect sharpBlast(Color colorExternal, Color colorInternal, float lifetime, float range) {
        return new Effect(lifetime, range * 2.0f, e -> Angles.randLenVectors((long)e.id, (int)((int)Mathf.clamp((float)(range / 8.0f), (float)4.0f, (float)18.0f)), (float)(range / 8.0f), (float)(range * (1.0f + e.fout(Interp.pow2OutInverse)) / 2.0f), (x, y) -> {
            float angle = Mathf.angle((float)x, (float)y);
            float width = e.foutpowdown() * rand.random(range / 6.0f, range / 3.0f) / 2.0f * e.fout();
            rand.setSeed((long)e.id);
            float length = rand.random(range / 2.0f, range * 1.1f) * e.fout();
            Draw.color((Color)colorExternal);
            DrawFunc.tri(e.x + x, e.y + y, width, range / 3.0f * e.fout((Interp)Interp.pow2In), angle - 180.0f);
            DrawFunc.tri(e.x + x, e.y + y, width, length, angle);
            if (!NHSetting.enableDetails()) {
                return;
            }
            Draw.color((Color)colorInternal);
            DrawFunc.tri(e.x + x, e.y + y, (width *= e.fout()) / 2.0f, range / 3.0f * e.fout((Interp)Interp.pow2In) * 0.9f * e.fout(), angle - 180.0f);
            DrawFunc.tri(e.x + x, e.y + y, width / 2.0f, length / 1.5f * e.fout(), angle);
        }));
    }

    public static Effect sharpBlastRand(Color colorExternal, Color colorInternal, float rotation, float ranAngle, float lifetime, float range) {
        return new Effect(lifetime, range * 2.0f, e -> Angles.randLenVectors((long)e.id, (int)((int)Mathf.clamp((float)(range / 8.0f), (float)2.0f, (float)6.0f)), (float)((1.0f + e.fout(Interp.pow2OutInverse)) / 2.0f), (float)rotation, (float)ranAngle, (x, y) -> {
            float angle = Mathf.angle((float)x, (float)y);
            float width = e.foutpowdown() * rand.random(range / 6.0f, range / 3.0f) / 2.0f * e.fout();
            rand.setSeed((long)e.id);
            float length = rand.random(range / 2.0f, range * 1.1f) * e.fout();
            Draw.color((Color)colorExternal);
            DrawFunc.tri(e.x + x, e.y + y, width, length, angle);
            if (!NHSetting.enableDetails()) {
                return;
            }
            Draw.color((Color)colorInternal);
            DrawFunc.tri(e.x + x, e.y + y, (width *= e.fout()) / 2.0f, length / 1.5f * e.fout(), angle);
        }));
    }

    public static interface EffectParam {
        public void draw(long var1, float var3, float var4, float var5, float var6);
    }
}

