/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Events;
import arc.func.Boolf;
import arc.struct.Seq;
import arc.util.Log;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.MapObjectives;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.world.Tile;
import mindustry.world.blocks.logic.LogicBlock;
import newhorizon.NHSetting;
import newhorizon.expand.game.MapObjectives.ReuseObjective;
import newhorizon.expand.game.MapObjectives.TriggerObjective;

public class NHLogic {
    public static Seq<LogicBlock.LogicBuild> processors = new Seq();

    public static void load() {
        if (NHSetting.getBool("nh-event-raid")) {
            Events.on(EventType.PlayEvent.class, event -> {
                if (Vars.state.rules.mode() == Gamemode.sandbox || Vars.state.rules.mode() == Gamemode.pvp) {
                    return;
                }
                NHLogic.updateWprocList();
                NHLogic.registerDefaultRaid();
            });
        }
    }

    public static void registerDefaultRaid() {
        NHLogic.registerWproc("wait 300\nsetflag \"raid-trigger\" true", "raid protection period");
        NHLogic.registerWproc("defaultraid raid-executor raid-timer 30 5 200 1 5 20", "raid event");
        NHLogic.registerReuseTimer(18000.0f, "raid-trigger", "raid-executor");
        NHLogic.registerTriggerTimer("raid-timer");
    }

    public static void registerWproc(String code, String tag) {
        AtomicBoolean contains = new AtomicBoolean(false);
        processors.each(logicBlock -> {
            if (Objects.equals(logicBlock.tag, tag)) {
                contains.set(true);
            }
        });
        if (contains.get()) {
            if (Log.level == Log.LogLevel.debug) {
                Log.info((Object)("Already registered wproc: " + tag + ", Skip."));
            }
            return;
        }
        boolean foundAny = false;
        block0: for (int y = 0; y < Vars.world.height(); ++y) {
            for (int x = 0; x < Vars.world.width(); ++x) {
                Tile tile = Vars.world.rawTile(x, y);
                if (tile.synthetic()) continue;
                foundAny = true;
                tile.setNet(Blocks.worldProcessor, Team.sharded, 0);
                Building building = tile.build;
                if (building instanceof LogicBlock.LogicBuild) {
                    LogicBlock.LogicBuild wproc = (LogicBlock.LogicBuild)building;
                    wproc.updateCode(code);
                    wproc.tag = tag;
                }
                if (!Vars.headless && Vars.ui.editor.isShown()) {
                    NHLogic.updateStatic(x, y);
                }
                Log.info((Object)("Registered wproc: " + tag));
                break block0;
            }
        }
        if (!foundAny) {
            Log.info((Object)("Failed to registered wproc: " + tag + ", no space available."));
        }
    }

    public static void updateStatic(int x, int y) {
        Vars.renderer.blocks.floor.recacheTile(x, y);
        if (x > 0) {
            Vars.renderer.blocks.floor.recacheTile(x - 1, y);
        }
        if (y > 0) {
            Vars.renderer.blocks.floor.recacheTile(x, y - 1);
        }
        if (x < Vars.world.width() - 1) {
            Vars.renderer.blocks.floor.recacheTile(x + 1, y);
        }
        if (y < Vars.world.height() - 1) {
            Vars.renderer.blocks.floor.recacheTile(x, y + 1);
        }
    }

    public static void updateWprocList() {
        Vars.world.tiles.eachTile(t -> {
            if (t.isCenter() && t.block() == Blocks.worldProcessor) {
                processors.add((Object)((LogicBlock.LogicBuild)t.build));
            }
        });
    }

    public static void registerReuseTimer(float time, String eventTrigger, String eventExecutor) {
        if (!NHLogic.containObjective((Boolf<MapObjectives.MapObjective>)((Boolf)obj -> {
            if (!(obj instanceof ReuseObjective)) return false;
            ReuseObjective reuse = (ReuseObjective)((Object)obj);
            if (!Objects.equals(reuse.trigger, eventTrigger)) return false;
            if (!Objects.equals(reuse.executor, eventExecutor)) return false;
            return true;
        }))) {
            NHLogic.objectives().all.add((Object)new ReuseObjective(time, eventTrigger, eventExecutor));
            Log.info((Object)("Registered reuse timer: " + eventTrigger + "|" + eventExecutor));
        } else if (Log.level == Log.LogLevel.debug) {
            Log.info((Object)("Already registered reuse timer: " + eventTrigger + "|" + eventExecutor + ", Skip."));
        }
    }

    public static void registerTriggerTimer(String eventTimer) {
        if (!NHLogic.containObjective((Boolf<MapObjectives.MapObjective>)((Boolf)obj -> {
            if (!(obj instanceof TriggerObjective)) return false;
            TriggerObjective reuse = (TriggerObjective)((Object)obj);
            if (!Objects.equals(reuse.timer, eventTimer)) return false;
            return true;
        }))) {
            NHLogic.objectives().all.add((Object)new TriggerObjective(eventTimer));
            Log.info((Object)("Registered trigger timer: " + eventTimer));
        } else if (Log.level == Log.LogLevel.debug) {
            Log.info((Object)("Already registered Trigger timer: " + eventTimer + ", Skip."));
        }
    }

    public static MapObjectives objectives() {
        return Vars.state.rules.objectives;
    }

    public static boolean containObjective(Boolf<MapObjectives.MapObjective> checker) {
        AtomicBoolean found = new AtomicBoolean(false);
        NHLogic.objectives().each(objective -> {
            if (checker.get(objective)) {
                found.set(true);
            }
        });
        return found.get();
    }
}

