/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.func.Cons;
import arc.func.Intc;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Structs;
import java.lang.reflect.Field;
import java.util.Objects;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.Planets;
import mindustry.content.StatusEffects;
import mindustry.content.TechTree;
import mindustry.content.UnitTypes;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.EmptyBulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.ParticleEffect;
import mindustry.game.SpawnGroup;
import mindustry.game.Waves;
import mindustry.gen.Sounds;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.Planet;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ContinuousLiquidTurret;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.LaserTurret;
import mindustry.world.blocks.defense.turrets.LiquidTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.blocks.logic.MemoryBlock;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.logic.SwitchBlock;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.blocks.production.AttributeCrafter;
import mindustry.world.blocks.production.BeamDrill;
import mindustry.world.blocks.production.BurstDrill;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.Pump;
import mindustry.world.blocks.production.WallCrafter;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import newhorizon.NHSetting;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.content.NHPlanets;
import newhorizon.content.NHStatValues;
import newhorizon.content.NHStatusEffects;
import newhorizon.content.NHUnitTypes;
import newhorizon.expand.ability.passive.PassiveShield;
import newhorizon.expand.bullets.AdaptedLightningBulletType;

public class NHPostProcess {
    public static final Seq<SpawnGroup> modSpawnGroup = new Seq();
    public static final Seq<Color> validColor = new Seq();
    private static final Seq<TechTree.TechNode> tmpVanillaNode = new Seq();
    private static final Seq<TechTree.TechNode> tmpCreatedNode = new Seq();

    public static void load() {
        modSpawnGroup.addAll((Object[])new SpawnGroup[]{new SpawnGroup(NHUnitTypes.origin){
            {
                this.end = 12;
                this.unitScaling = 2.0f;
                this.max = 30;
            }
        }, new SpawnGroup(NHUnitTypes.assaulter){
            {
                this.begin = 4;
                this.end = 13;
                this.unitAmount = 1;
                this.unitScaling = 1.25f;
            }
        }, new SpawnGroup(NHUnitTypes.sharp){
            {
                this.begin = 6;
                this.end = 16;
                this.unitScaling = 1.0f;
            }
        }, new SpawnGroup(NHUnitTypes.origin){
            {
                this.begin = 11;
                this.unitScaling = 1.7f;
                this.spacing = 2;
                this.max = 4;
                this.shieldScaling = 25.0f;
            }
        }, new SpawnGroup(NHUnitTypes.thynomo){
            {
                this.begin = 16;
                this.spacing = 3;
                this.unitScaling = 0.5f;
                this.max = 25;
            }
        }, new SpawnGroup(NHUnitTypes.origin){
            {
                this.begin = 12;
                this.unitScaling = 1.0f;
                this.unitAmount = 4;
                this.spacing = 2;
                this.shieldScaling = 20.0f;
                this.max = 14;
            }
        }, new SpawnGroup(NHUnitTypes.thynomo){
            {
                this.begin = 28;
                this.spacing = 3;
                this.unitScaling = 1.0f;
                this.end = 40;
                this.shieldScaling = 20.0f;
            }
        }, new SpawnGroup(NHUnitTypes.aliotiat){
            {
                this.begin = 35;
                this.spacing = 3;
                this.unitScaling = 1.0f;
                this.max = 18;
                this.shieldScaling = 30.0f;
                this.shields = 100.0f;
            }
        }, new SpawnGroup(NHUnitTypes.aliotiat){
            {
                this.begin = 40;
                this.spacing = 3;
                this.unitScaling = 1.0f;
                this.max = 15;
                this.shieldScaling = 50.0f;
                this.shields = 150.0f;
                this.effect = StatusEffects.overdrive;
            }
        }, new SpawnGroup(NHUnitTypes.sharp){
            {
                this.begin = 16;
                this.unitScaling = 1.0f;
                this.spacing = 2;
                this.shieldScaling = 20.0f;
                this.max = 20;
            }
        }, new SpawnGroup(NHUnitTypes.warper){
            {
                this.begin = 40;
                this.end = 80;
                this.spacing = 5;
                this.unitAmount = 2;
                this.unitScaling = 2.0f;
                this.max = 20;
                this.shieldScaling = 30.0f;
                this.effect = StatusEffects.overdrive;
            }
        }, new SpawnGroup(NHUnitTypes.branch){
            {
                this.begin = 35;
                this.spacing = 3;
                this.unitAmount = 4;
                this.effect = StatusEffects.overdrive;
                this.items = new ItemStack(NHItems.thermoCorePositive, 60);
                this.end = 60;
            }
        }, new SpawnGroup(NHUnitTypes.branch){
            {
                this.begin = 8;
                this.spacing = 3;
                this.unitAmount = 4;
                this.effect = StatusEffects.overdrive;
                this.items = new ItemStack(NHItems.thermoCorePositive, 100);
                this.end = 130;
                this.max = 30;
            }
        }, new SpawnGroup(NHUnitTypes.warper){
            {
                this.begin = 30;
                this.unitAmount = 2;
                this.spacing = 2;
                this.unitScaling = 2.0f;
                this.shieldScaling = 20.0f;
            }
        }, new SpawnGroup(NHUnitTypes.tarlidor){
            {
                this.begin = 35;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 6;
                this.shieldScaling = 80.0f;
            }
        }, new SpawnGroup(NHUnitTypes.annihilation){
            {
                this.begin = 65;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 6;
                this.shields = 2000.0f;
                this.shieldScaling = 800.0f;
            }
        }, new SpawnGroup(NHUnitTypes.laugra){
            {
                this.begin = 75;
                this.unitAmount = 2;
                this.unitScaling = 1.0f;
                this.spacing = 12;
                this.shieldScaling = 600.0f;
                this.effect = StatusEffects.boss;
            }
        }, new SpawnGroup(NHUnitTypes.macrophage){
            {
                this.begin = 75;
                this.unitAmount = 2;
                this.unitScaling = 0.5f;
                this.spacing = 5;
                this.shieldScaling = 500.0f;
                this.shields = 1200.0f;
                this.effect = NHStatusEffects.quantization;
            }
        }, new SpawnGroup(NHUnitTypes.laugra){
            {
                this.begin = 105;
                this.unitAmount = 1;
                this.unitScaling = 0.7f;
                this.spacing = 4;
                this.shieldScaling = 200.0f;
                this.effect = NHStatusEffects.overphased;
            }
        }, new SpawnGroup(NHUnitTypes.sin){
            {
                this.begin = 110;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 10;
                this.shieldScaling = 30.0f;
            }
        }, new SpawnGroup(NHUnitTypes.hurricane){
            {
                this.begin = 105;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 10;
                this.shieldScaling = 300.0f;
            }
        }, new SpawnGroup(NHUnitTypes.anvil){
            {
                this.begin = 70;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 15;
                this.shieldScaling = 30.0f;
                this.shields = 300.0f;
            }
        }, new SpawnGroup(NHUnitTypes.guardian){
            {
                this.begin = 75;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 20;
                this.shieldScaling = 30.0f;
                this.shields = 500.0f;
            }
        }, new SpawnGroup(NHUnitTypes.saviour){
            {
                this.begin = 70;
                this.unitAmount = 1;
                this.unitScaling = 3.0f;
                this.spacing = 9;
                this.shieldScaling = 30.0f;
                this.shields = 3000.0f;
            }
        }, new SpawnGroup(NHUnitTypes.naxos){
            {
                this.begin = 75;
                this.unitAmount = 2;
                this.unitScaling = 3.0f;
                this.spacing = 4;
                this.shields = 40.0f;
                this.shieldScaling = 30.0f;
            }
        }, new SpawnGroup(NHUnitTypes.sin){
            {
                this.begin = 100;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.effect = StatusEffects.boss;
                this.spacing = 15;
                this.shields = 80.0f;
                this.shieldScaling = 100.0f;
            }
        }, new SpawnGroup(NHUnitTypes.longinus){
            {
                this.begin = 90;
                this.unitAmount = 2;
                this.unitScaling = 3.0f;
                this.spacing = 10;
                this.shields = 40.0f;
                this.shieldScaling = 20.0f;
            }
        }, new SpawnGroup(NHUnitTypes.collapser){
            {
                this.begin = 120;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 12;
                this.shields = 19000.0f;
                this.shieldScaling = 3500.0f;
            }
        }, new SpawnGroup(NHUnitTypes.nucleoid){
            {
                this.begin = 180;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 20;
                this.shields = 80000.0f;
                this.shieldScaling = 2000.0f;
            }
        }, new SpawnGroup(NHUnitTypes.pester){
            {
                this.begin = 130;
                this.unitAmount = 1;
                this.unitScaling = 1.0f;
                this.spacing = 20;
                this.shields = 26000.0f;
                this.shieldScaling = 5000.0f;
            }
        }});
        NHPostProcess.contentOverride();
        NHPostProcess.setModContentEnv();
    }

    public static void loadOptional() {
        if (NHSetting.getBool("nh-override-unit-shield")) {
            NHPostProcess.overrideUnitShield();
        }
        if (NHSetting.getBool("nh-override-core-unit")) {
            NHPostProcess.overrideCoreUnit();
        }
        if (NHSetting.getBool("nh-override-logistic")) {
            NHPostProcess.overrideLogistic();
        }
        if (NHSetting.getBool("nh-override-factories")) {
            NHPostProcess.overrideFactories();
        }
        if (NHSetting.getBool("nh-override-power")) {
            NHPostProcess.overridePower();
        }
        if (NHSetting.getBool("nh-override-unit")) {
            NHPostProcess.overrideUnit();
        }
        if (NHSetting.getBool("nh-override-logic")) {
            NHPostProcess.overrideLogic();
        }
        if (NHSetting.getBool("nh-override-item")) {
            NHPostProcess.overrideItem();
        }
        if (NHSetting.getBool("nh-override-turret")) {
            NHPostProcess.overrideTurret();
        }
    }

    public static void contentOverride() {
    }

    public static void postProcessOverride() {
        NHPostProcess.overrideStats();
    }

    public static void setModContentEnv() {
        for (Block block : Vars.content.blocks()) {
            if (!block.name.startsWith("new-horizon")) continue;
            block.shownPlanets.clear();
            block.shownPlanets.addAll((Object[])new Planet[]{Planets.serpulo, Planets.erekir, NHPlanets.midantha});
        }
        Seq items = Seq.with((Object[])new Item[]{NHItems.silicon, NHItems.titanium, NHItems.tungsten, NHItems.zeta, NHItems.presstanium, NHItems.juniorProcessor, NHItems.carbide, NHItems.metalOxhydrigen, NHItems.surgeAlloy, NHItems.phaseFabric, NHItems.multipleSteel, NHItems.seniorProcessor, NHItems.irayrondPanel, NHItems.setonAlloy, NHItems.nodexPlate, NHItems.ancimembrane, NHItems.fusionEnergy, NHItems.thermoCorePositive, NHItems.thermoCoreNegative, NHItems.darkEnergy});
        Seq liquids = Seq.with((Object[])new Liquid[]{NHLiquids.quantumLiquid, NHLiquids.xenFluid, NHLiquids.zetaFluidPositive, NHLiquids.zetaFluidNegative, NHLiquids.irdryonFluid});
        Vars.content.items().each(item -> item.shownPlanets.remove((Object)NHPlanets.midantha));
        Vars.content.liquids().each(liquid -> liquid.shownPlanets.remove((Object)NHPlanets.midantha));
        items.each(item -> item.shownPlanets.addAll((Object[])new Planet[]{Planets.serpulo, Planets.erekir, NHPlanets.midantha}));
        liquids.each(liquid -> liquid.shownPlanets.addAll((Object[])new Planet[]{Planets.serpulo, Planets.erekir, NHPlanets.midantha}));
    }

    public static Seq<SpawnGroup> generate(float difficulty, boolean airOnly) {
        return NHPostProcess.generate(difficulty, new Rand(), false, airOnly, false);
    }

    public static Seq<SpawnGroup> generate(final float difficulty, final Rand rand, boolean attack, boolean airOnly, boolean naval) {
        UnitType[][] species = new UnitType[][]{{NHUnitTypes.origin, NHUnitTypes.thynomo, NHUnitTypes.aliotiat, NHUnitTypes.tarlidor, NHUnitTypes.annihilation, NHUnitTypes.sin}, {NHUnitTypes.sharp, NHUnitTypes.branch, NHUnitTypes.warper, NHUnitTypes.naxos, NHUnitTypes.hurricane}, {UnitTypes.flare, NHUnitTypes.assaulter, NHUnitTypes.restrictionEnzyme, NHUnitTypes.destruction, NHUnitTypes.longinus}, {NHUnitTypes.sharp, NHUnitTypes.assaulter, NHUnitTypes.branch, NHUnitTypes.longinus, NHUnitTypes.guardian}, {UnitTypes.risso, UnitTypes.minke, NHUnitTypes.ghost, NHUnitTypes.zarkov, NHUnitTypes.declining}, {UnitTypes.risso, UnitTypes.oxynoe, UnitTypes.cyerce, UnitTypes.aegires, UnitTypes.navanax}, {NHUnitTypes.branch, UnitTypes.zenith, rand.chance(0.5) ? NHUnitTypes.naxos : NHUnitTypes.macrophage, rand.chance(0.5) ? NHUnitTypes.longinus : NHUnitTypes.laugra, rand.chance(0.5) ? NHUnitTypes.anvil : NHUnitTypes.hurricane}};
        if (airOnly) {
            species = (UnitType[][])Structs.filter(UnitType[].class, (Object[])species, v -> v[0].flying);
        }
        species = naval ? (UnitType[][])Structs.filter(UnitType[].class, (Object[])species, v -> v[0].flying || v[0].naval) : (UnitType[][])Structs.filter(UnitType[].class, (Object[])species, v -> !v[0].naval);
        UnitType[][] fspec = species;
        Seq out = new Seq();
        final int cap = 150;
        float[] shieldStart = new float[]{30.0f};
        final float shieldsPerWave = 20.0f + difficulty * 30.0f;
        final float[] scaling = new float[]{1.0f, 1.15f, 1.55f, 2.5f, 2.7f, 3.0f};
        Intc createProgression = start -> {
            UnitType[] curSpecies = (UnitType[])Structs.random((Object[])fspec);
            int curTier = 0;
            int i = start;
            while (i < cap) {
                final int f = i;
                final int next = rand.random(8, 16) + (int)Mathf.lerp((float)5.0f, (float)0.0f, (float)difficulty) + curTier * 4;
                final float shieldAmount = Math.max(((float)i - shieldStart[0]) * shieldsPerWave, 0.0f);
                final int space = start == 0 ? 1 : rand.random(1, 2);
                final int ctier = curTier;
                out.add((Object)new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(arg0);
                        this.unitAmount = f == start ? 1 : (int)(6.0f / scaling[ctier]);
                        this.begin = f;
                        this.end = f + next >= cap ? Integer.MAX_VALUE : f + next;
                        this.max = 13;
                        this.unitScaling = (difficulty < 0.4f ? rand.random(2.5f, 5.0f) : rand.random(1.0f, 4.0f)) * scaling[ctier];
                        this.shields = shieldAmount;
                        this.shieldScaling = shieldsPerWave;
                        this.spacing = space;
                    }
                });
                i += next + 1;
                if (curTier < 3 || rand.chance(0.05) && (double)difficulty > 0.8) {
                    ++curTier;
                }
                curTier = Math.min(curTier, 6);
                if (!rand.chance(0.3)) continue;
                curSpecies = (UnitType[])Structs.random((Object[])fspec);
            }
        };
        createProgression.get(0);
        for (int step = 5 + rand.random(5); step <= cap; step += (int)((float)rand.random(15, 30) * Mathf.lerp((float)1.0f, (float)0.5f, (float)difficulty))) {
            createProgression.get(step);
        }
        final int bossWave = (int)((float)rand.random(90, 120) * Mathf.lerp((float)1.0f, (float)0.5f, (float)difficulty));
        final int bossSpacing = (int)((float)rand.random(25, 40) * Mathf.lerp((float)1.0f, (float)0.5f, (float)difficulty));
        int bossTier = (double)difficulty < 0.6 ? 3 : 4;
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = bossWave;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = bossWave + rand.random(3, 5) * bossSpacing;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        final int finalBossStart = 120 + rand.random(30);
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = finalBossStart;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = finalBossStart + 15;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        if (attack && (double)difficulty >= 0.5) {
            int amount = Mathf.random((int)1, (int)(3 + (int)(difficulty * 2.0f)));
            for (int i = 0; i < amount; ++i) {
                final int wave = Mathf.random((int)3, (int)20);
                out.add((Object)new SpawnGroup(UnitTypes.mega){
                    {
                        super(arg0);
                        this.unitAmount = 1;
                        this.begin = wave;
                        this.end = wave;
                        this.max = 16;
                    }
                });
            }
        }
        int shift = Math.max((int)(difficulty * 14.0f - 5.0f), 0);
        for (SpawnGroup group : out) {
            group.begin -= shift;
            group.end -= shift;
        }
        out.add(modSpawnGroup);
        if ((double)difficulty > 0.9) {
            out.add((Object)new SpawnGroup(NHUnitTypes.pester){
                {
                    this.effect = NHStatusEffects.overphased;
                    this.begin = 148;
                    this.spacing = 1;
                    this.unitAmount = 1;
                }
            });
        }
        out.each(s -> {
            if (s.type == NHUnitTypes.longinus || s.type == NHUnitTypes.naxos) {
                s.unitScaling *= 1.75f;
                s.unitAmount = (int)Math.max(1.0f, (float)s.unitAmount / 1.5f);
            }
        });
        return out;
    }

    public static void overrideStats() {
        for (Block block : Vars.content.blocks()) {
            if (block.minfo != null && block.minfo.mod != null && Objects.equals(block.minfo.mod.name, "exogenesis")) continue;
            if (block instanceof ItemTurret) {
                ItemTurret itemTurret = (ItemTurret)block;
                NHPostProcess.processAmmoStat(block, (ObjectMap<? extends UnlockableContent, BulletType>)itemTurret.ammoTypes);
            }
            if (block instanceof LiquidTurret) {
                LiquidTurret liquidTurret = (LiquidTurret)block;
                NHPostProcess.processAmmoStat(block, (ObjectMap<? extends UnlockableContent, BulletType>)liquidTurret.ammoTypes);
            }
            if (block instanceof PowerTurret) {
                PowerTurret powerTurret = (PowerTurret)block;
                NHPostProcess.processAmmoStat(block, (ObjectMap<? extends UnlockableContent, BulletType>)ObjectMap.of((Object[])new Object[]{powerTurret, powerTurret.shootType}));
            }
            if (block instanceof ContinuousTurret) {
                ContinuousTurret continuousTurret = (ContinuousTurret)block;
                NHPostProcess.processAmmoStat(block, (ObjectMap<? extends UnlockableContent, BulletType>)ObjectMap.of((Object[])new Object[]{continuousTurret, continuousTurret.shootType}));
            }
            if (!(block instanceof ContinuousLiquidTurret)) continue;
            ContinuousLiquidTurret continuousLiquidTurret = (ContinuousLiquidTurret)block;
            NHPostProcess.processAmmoStat(block, (ObjectMap<? extends UnlockableContent, BulletType>)continuousLiquidTurret.ammoTypes);
        }
        for (UnitType unitType : Vars.content.units()) {
            unitType.checkStats();
            OrderedMap map = unitType.stats.toMap();
            if (map.get((Object)StatCat.function) == null || ((OrderedMap)map.get((Object)StatCat.function)).get((Object)Stat.weapons) == null) continue;
            unitType.stats.remove(Stat.weapons);
            unitType.stats.add(Stat.weapons, NHStatValues.weapons(unitType, (Seq<Weapon>)unitType.weapons));
        }
    }

    private static void processAmmoStat(Block block, ObjectMap<? extends UnlockableContent, BulletType> ammo) {
        block.checkStats();
        OrderedMap map = block.stats.toMap();
        if (map.get((Object)StatCat.function) != null && ((OrderedMap)map.get((Object)StatCat.function)).get((Object)Stat.ammo) != null) {
            block.stats.remove(Stat.ammo);
            if (block instanceof ContinuousLiquidTurret) {
                ContinuousLiquidTurret continuousLiquidTurret = (ContinuousLiquidTurret)block;
                block.stats.add(Stat.ammo, table -> {
                    table.row();
                    StatValues.number((float)(continuousLiquidTurret.liquidConsumed * 60.0f), (StatUnit)StatUnit.perSecond, (boolean)true).display(table);
                });
            }
            block.stats.add(Stat.ammo, NHStatValues.ammo(ammo, 0, false));
        }
    }

    private static void replaceVanillaVisualContent() {
        if (NHSetting.enableDetails()) {
            Fx.trailFade.clip = 2000.0f;
        }
        Fx.lightning.layer(Fx.lightning.layer - 0.1f);
    }

    private static void replaceVanillaSpawnGroup() {
        try {
            Field field = Waves.class.getDeclaredField("spawns");
            field.setAccessible(true);
            Vars.waves.get();
            Seq spawns = (Seq)field.get(Vars.waves);
            spawns.addAll(modSpawnGroup);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Log.info((Object)e);
        }
    }

    private static void overrideLogic() {
        NHPostProcess.adjustContent((Content)Blocks.message, (Cons<Content>)((Cons)content -> {
            MessageBlock logicBlock = (MessageBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 5});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.reinforcedMessage, (Cons<Content>)((Cons)content -> {
            MessageBlock logicBlock = (MessageBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 5});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.switchBlock, (Cons<Content>)((Cons)content -> {
            SwitchBlock logicBlock = (SwitchBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 5});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.microProcessor, (Cons<Content>)((Cons)content -> {
            LogicBlock logicBlock = (LogicBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 50, Items.titanium, 50});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.logicProcessor, (Cons<Content>)((Cons)content -> {
            LogicBlock logicBlock = (LogicBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 50, NHItems.presstanium, 50});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.hyperProcessor, (Cons<Content>)((Cons)content -> {
            LogicBlock logicBlock = (LogicBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 100, NHItems.zeta, 200, Items.surgeAlloy, 150});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.memoryCell, (Cons<Content>)((Cons)content -> {
            MemoryBlock logicBlock = (MemoryBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 30});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.memoryBank, (Cons<Content>)((Cons)content -> {
            MemoryBlock logicBlock = (MemoryBlock)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 80, Items.phaseFabric, 40});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.logicDisplay, (Cons<Content>)((Cons)content -> {
            LogicDisplay logicBlock = (LogicDisplay)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 50});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
        NHPostProcess.adjustContent((Content)Blocks.largeLogicDisplay, (Cons<Content>)((Cons)content -> {
            LogicDisplay logicBlock = (LogicDisplay)content;
            logicBlock.requirements = ItemStack.with((Object[])new Object[]{Items.silicon, 150, Items.phaseFabric, 75});
            logicBlock.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir, NHPlanets.midantha});
        }));
    }

    private static void overrideLogistic() {
        NHPostProcess.adjustContent((Content)Blocks.rotaryPump, (Cons<Content>)((Cons)content -> {
            Pump pump = (Pump)content;
            pump.requirements = ItemStack.with((Object[])new Object[]{Items.graphite, 80, Items.metaglass, 50});
        }));
        NHPostProcess.hideContent((UnlockableContent)Blocks.conveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.titaniumConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.armoredConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.plastaniumConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.junction);
        NHPostProcess.hideContent((UnlockableContent)Blocks.phaseConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.sorter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.invertedSorter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.overflowGate);
        NHPostProcess.hideContent((UnlockableContent)Blocks.underflowGate);
        NHPostProcess.hideContent((UnlockableContent)Blocks.duct);
        NHPostProcess.hideContent((UnlockableContent)Blocks.armoredDuct);
        NHPostProcess.hideContent((UnlockableContent)Blocks.ductRouter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.overflowDuct);
        NHPostProcess.hideContent((UnlockableContent)Blocks.underflowDuct);
        NHPostProcess.hideContent((UnlockableContent)Blocks.ductUnloader);
        NHPostProcess.hideContent((UnlockableContent)Blocks.surgeConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.surgeRouter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.mechanicalPump);
        NHPostProcess.hideContent((UnlockableContent)Blocks.impulsePump);
        NHPostProcess.hideContent((UnlockableContent)Blocks.pulseConduit);
        NHPostProcess.hideContent((UnlockableContent)Blocks.platedConduit);
        NHPostProcess.hideContent((UnlockableContent)Blocks.liquidRouter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.liquidJunction);
        NHPostProcess.hideContent((UnlockableContent)Blocks.bridgeConduit);
        NHPostProcess.hideContent((UnlockableContent)Blocks.phaseConduit);
        NHPostProcess.hideContent((UnlockableContent)Blocks.reinforcedConduit);
        NHPostProcess.hideContent((UnlockableContent)Blocks.reinforcedLiquidJunction);
        NHPostProcess.hideContent((UnlockableContent)Blocks.reinforcedBridgeConduit);
        NHPostProcess.hideContent((UnlockableContent)Blocks.reinforcedLiquidRouter);
    }

    private static void overrideDrill() {
        NHPostProcess.hideContent((UnlockableContent)Blocks.mechanicalDrill);
        NHPostProcess.hideContent((UnlockableContent)Blocks.laserDrill);
        NHPostProcess.hideContent((UnlockableContent)Blocks.blastDrill);
        NHPostProcess.hideContent((UnlockableContent)Blocks.eruptionDrill);
        NHPostProcess.adjustContent((Content)Blocks.pneumaticDrill, (Cons<Content>)((Cons)content -> {
            Drill drill = (Drill)content;
            drill.requirements = ItemStack.with((Object[])new Object[]{Items.copper, 15, Items.lead, 20});
            drill.hardnessDrillMultiplier = 0.0f;
            drill.liquidBoostIntensity = Mathf.sqrt((float)1.5f);
            drill.drillTime = 60.0f * (float)drill.size * (float)drill.size;
            drill.drillMultipliers.put((Object)Items.sand, 1.0f);
            drill.drillMultipliers.put((Object)Items.scrap, 1.0f);
            drill.drillMultipliers.put((Object)Items.copper, 1.0f);
            drill.drillMultipliers.put((Object)Items.lead, 1.0f);
            drill.drillMultipliers.put((Object)Items.coal, 1.0f);
            drill.drillMultipliers.put((Object)Items.titanium, 0.75f);
            drill.drillMultipliers.put((Object)Items.beryllium, 0.75f);
        }));
        NHPostProcess.adjustContent((Content)Blocks.impactDrill, (Cons<Content>)((Cons)content -> {
            BurstDrill drill = (BurstDrill)content;
            drill.requirements = ItemStack.with((Object[])new Object[]{Items.beryllium, 60, Items.graphite, 45});
            drill.hardnessDrillMultiplier = 0.0f;
            drill.drillTime = 90.0f * (float)drill.size * (float)drill.size / 6.0f;
            drill.drillMultipliers.put((Object)Items.sand, 1.0f);
            drill.drillMultipliers.put((Object)Items.scrap, 1.0f);
            drill.drillMultipliers.put((Object)Items.copper, 1.0f);
            drill.drillMultipliers.put((Object)Items.lead, 1.0f);
            drill.drillMultipliers.put((Object)Items.coal, 1.0f);
            drill.drillMultipliers.put((Object)Items.titanium, 0.75f);
            drill.drillMultipliers.put((Object)Items.beryllium, 0.75f);
            drill.drillMultipliers.put((Object)Items.tungsten, 0.5f);
            drill.removeConsumers(consume -> consume instanceof ConsumeLiquid);
            drill.consume(new ConsumeLiquid(Liquids.water, 0.16666667f).boost());
            drill.liquidBoostIntensity = 1.5f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.plasmaBore, (Cons<Content>)((Cons)content -> {
            BeamDrill drill = (BeamDrill)content;
            drill.drillTime = 60.0f;
            drill.optionalBoostIntensity = 2.5f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.largePlasmaBore, (Cons<Content>)((Cons)content -> {
            BeamDrill drill = (BeamDrill)content;
            drill.drillTime = 30.0f;
            drill.optionalBoostIntensity = 2.5f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.cliffCrusher, (Cons<Content>)((Cons)content -> {
            WallCrafter wallCrafter = (WallCrafter)content;
            wallCrafter.drillTime = 60.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.largeCliffCrusher, (Cons<Content>)((Cons)content -> {
            WallCrafter wallCrafter = (WallCrafter)content;
            wallCrafter.drillTime = 30.0f;
            wallCrafter.itemBoostIntensity = 2.5f;
            wallCrafter.itemConsumer = wallCrafter.consumeItem(Items.graphite).boost();
        }));
    }

    private static void overridePower() {
        NHPostProcess.adjustContent((Content)Blocks.turbineCondenser, (Cons<Content>)((Cons)content -> {
            ThermalGenerator generator = (ThermalGenerator)content;
            generator.powerProduction = 0.5f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.differentialGenerator, (Cons<Content>)((Cons)content -> {
            ConsumeGenerator generator = (ConsumeGenerator)content;
            generator.itemDuration = 240.0f;
        }));
        NHPostProcess.hideContent((UnlockableContent)Blocks.powerNode);
        NHPostProcess.hideContent((UnlockableContent)Blocks.powerNodeLarge);
        NHPostProcess.hideContent((UnlockableContent)Blocks.surgeTower);
        NHPostProcess.hideContent((UnlockableContent)Blocks.beamLink);
        NHPostProcess.hideContent((UnlockableContent)Blocks.beamNode);
        NHPostProcess.hideContent((UnlockableContent)Blocks.beamTower);
    }

    private static void overrideTurret() {
        NHPostProcess.adjustContent((Content)Blocks.duo, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new BasicBulletType(){
                {
                    this.damage = 30.0f;
                    this.rangeChange = 40.0f;
                    this.lightningDamage = 8.0f;
                    this.lightning = 2;
                    this.lightningLength = 3;
                    this.lightningLengthRand = 1;
                    this.speed = 6.0f;
                    this.width = 7.0f;
                    this.height = 9.0f;
                    this.lifetime = 33.0f;
                    this.ammoMultiplier = 5.0f;
                    this.reloadMultiplier = 1.25f;
                    this.pierceArmor = true;
                    this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    this.backColor = this.trailColor = NHItems.zeta.color;
                    this.hitColor = this.trailColor;
                    this.lightningColor = this.trailColor;
                    this.frontColor = this.trailColor;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.wave, (Cons<Content>)((Cons)content -> {
            LiquidTurret turret = (LiquidTurret)content;
            turret.ammoTypes.put((Object)NHLiquids.xenFluid, (Object)new LiquidBulletType(){
                {
                    this.liquid = NHLiquids.xenFluid;
                    this.damage = 5.0f;
                    this.status = NHStatusEffects.ultFireBurn;
                    this.statusDuration = 120.0f;
                }
            });
            turret.ammoTypes.put((Object)NHLiquids.irdryonFluid, (Object)new LiquidBulletType(){
                {
                    this.liquid = NHLiquids.irdryonFluid;
                    this.status = NHStatusEffects.emp3;
                    this.statusDuration = 120.0f;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.swarmer, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new MissileBulletType(){
                {
                    this.damage = 40.0f;
                    this.rangeChange = 40.0f;
                    this.lightningDamage = 10.0f;
                    this.lightning = 3;
                    this.lightningLength = 1;
                    this.lightningLengthRand = 4;
                    this.speed = 3.0f;
                    this.lifetime = 120.0f;
                    this.width = 8.0f;
                    this.height = 8.0f;
                    this.ammoMultiplier = 2.0f;
                    this.lightColor = this.backColor = NHItems.zeta.color;
                    this.hitColor = this.backColor;
                    this.lightningColor = this.backColor;
                    this.frontColor = Color.white;
                    this.trailColor = Color.gray;
                    this.trailParam = 1.8f;
                    this.hitEffect = Fx.blastExplosion;
                    this.shootEffect = Fx.shootSmallFlame;
                    this.splashDamageRadius = 4.0f;
                    this.splashDamage = 15.0f;
                    this.reloadMultiplier = 0.85f;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.salvo, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new BasicBulletType(){
                {
                    this.lightColor = this.backColor = NHItems.zeta.color;
                    this.hitColor = this.backColor;
                    this.trailColor = this.backColor;
                    this.lightningColor = this.backColor;
                    this.frontColor = Color.white;
                    this.speed = 7.0f;
                    this.damage = 20.0f;
                    this.rangeChange = 40.0f;
                    this.lightningDamage = 10.0f;
                    this.lightning = 1;
                    this.lightningLengthRand = 3;
                    this.reloadMultiplier = 1.5f;
                    this.lifetime = 30.0f;
                    this.width = 7.0f;
                    this.height = 10.0f;
                    this.ammoMultiplier = 4.0f;
                    this.shootEffect = Fx.shootBig;
                    this.hitEffect = this.despawnEffect = Fx.none;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.tsunami, (Cons<Content>)((Cons)content -> {
            LiquidTurret turret = (LiquidTurret)content;
            turret.ammoTypes.put((Object)NHLiquids.xenFluid, (Object)new LiquidBulletType(){
                {
                    this.liquid = NHLiquids.xenFluid;
                    this.lifetime = 49.0f;
                    this.speed = 4.0f;
                    this.knockback = 1.3f;
                    this.puddleSize = 8.0f;
                    this.orbSize = 4.0f;
                    this.drag = 0.001f;
                    this.ammoMultiplier = 0.4f;
                    this.statusDuration = 240.0f;
                    this.damage = 10.0f;
                    this.status = NHStatusEffects.ultFireBurn;
                }
            });
            turret.ammoTypes.put((Object)NHLiquids.irdryonFluid, (Object)new LiquidBulletType(){
                {
                    this.liquid = NHLiquids.irdryonFluid;
                    this.lifetime = 49.0f;
                    this.speed = 4.0f;
                    this.knockback = 1.3f;
                    this.puddleSize = 8.0f;
                    this.orbSize = 4.0f;
                    this.drag = 0.001f;
                    this.ammoMultiplier = 0.4f;
                    this.statusDuration = 240.0f;
                    this.damage = 0.2f;
                    this.status = NHStatusEffects.emp3;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.fuse, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new ShrapnelBulletType(){
                {
                    this.reloadMultiplier = 1.5f;
                    this.rangeChange = 40.0f;
                    this.length = 140.0f;
                    this.damage = 150.0f;
                    this.width = 20.0f;
                    this.lightColor = this.fromColor = NHItems.zeta.color;
                    this.hitColor = this.fromColor;
                    this.trailColor = this.fromColor;
                    this.lightningColor = this.fromColor;
                    this.toColor = Color.valueOf((String)"ffafaf");
                    this.ammoMultiplier = 2.0f;
                    this.pierce = true;
                    this.smokeEffect = this.shootEffect = new ParticleEffect(){
                        {
                            this.particles = 5;
                            this.line = true;
                            this.length = 55.0f;
                            this.baseLength = 0.0f;
                            this.lifetime = 15.0f;
                            this.colorFrom = fromColor;
                            this.colorTo = toColor;
                            this.cone = 60.0f;
                        }
                    };
                    this.fragRandomSpread = 90.0f;
                    this.fragBullets = 2;
                    this.fragBullet = new AdaptedLightningBulletType(){
                        {
                            this.damage = 30.0f;
                            this.hitColor = this.lightColor = NHItems.zeta.color;
                            this.trailColor = this.lightColor;
                            this.lightningColor = this.lightColor;
                            this.lightningLength = 10;
                            this.lightningLengthRand = 15;
                            this.collidesAir = true;
                        }
                    };
                    this.fragOnHit = false;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.ripple, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new ArtilleryBulletType(){
                {
                    this.damage = 40.0f;
                    this.rangeChange = 60.0f;
                    this.lightningDamage = 10.0f;
                    this.lightning = 3;
                    this.lightningLength = 10;
                    this.speed = 3.0f;
                    this.lifetime = 180.0f;
                    this.width = 10.0f;
                    this.height = 20.0f;
                    this.ammoMultiplier = 2.0f;
                    this.lightColor = this.backColor = NHItems.zeta.color;
                    this.hitColor = this.backColor;
                    this.trailColor = this.backColor;
                    this.lightningColor = this.backColor;
                    this.trailParam = 2.3f;
                    this.frontColor = Color.white;
                    this.hitEffect = Fx.flakExplosionBig;
                    this.shootEffect = Fx.shootSmallFlame;
                    this.splashDamageRadius = 45.0f;
                    this.splashDamage = 60.0f;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.cyclone, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new BasicBulletType(){
                {
                    this.damage = 5.0f;
                    this.ammoMultiplier = 2.0f;
                    this.speed = 6.0f;
                    this.splashDamage = 60.0f;
                    this.splashDamageRadius = 38.0f;
                    this.width = 20.0f;
                    this.height = 20.0f;
                    this.backSprite = "large-bomb-back";
                    this.sprite = "mine-bullet";
                    this.rangeChange = 24.0f;
                    this.lightningDamage = 8.0f;
                    this.lightning = 2;
                    this.lightningLength = 10;
                    this.shootEffect = Fx.shootBig;
                    this.collidesGround = true;
                    this.trailColor = this.lightningColor = NHItems.zeta.color;
                    this.hitColor = this.lightningColor;
                    this.backColor = this.lightningColor;
                    this.frontColor = Color.white;
                    this.despawnEffect = Fx.hitBulletColor;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.spectre, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new BasicBulletType(){
                {
                    this.lightColor = this.backColor = NHItems.zeta.color;
                    this.hitColor = this.backColor;
                    this.trailColor = this.backColor;
                    this.lightningColor = this.backColor;
                    this.frontColor = Color.white;
                    this.speed = 10.0f;
                    this.lifetime = 30.0f;
                    this.rangeChange = 40.0f;
                    this.knockback = 1.8f;
                    this.width = 18.0f;
                    this.height = 20.0f;
                    this.damage = 100.0f;
                    this.splashDamageRadius = 20.0f;
                    this.reloadMultiplier = 1.2f;
                    this.splashDamage = 35.0f;
                    this.shootEffect = Fx.shootBig;
                    this.hitEffect = NHFx.hitSpark;
                    this.ammoMultiplier = 2.0f;
                    this.lightningDamage = 30.0f;
                    this.lightning = 1;
                    this.lightningLengthRand = 3;
                    this.lightningLength = 4;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.meltdown, (Cons<Content>)((Cons)content -> {
            LaserTurret turret = (LaserTurret)content;
            ContinuousLaserBulletType meltDownType = (ContinuousLaserBulletType)turret.shootType;
            meltDownType.length += 80.0f;
            meltDownType.damage += 20.0f;
            turret.range += 80.0f;
            turret.shootDuration += 60.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.breach, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new BasicBulletType(){
                {
                    this.width = 13.0f;
                    this.height = 19.0f;
                    this.hitSize = 7.0f;
                    this.damage = 100.0f;
                    this.lifetime = 32.0f;
                    this.speed = 8.0f;
                    this.shootEffect = Fx.shootSmallFlame;
                    this.smokeEffect = Fx.shootBigSmoke;
                    this.ammoMultiplier = 1.0f;
                    this.reloadMultiplier = 1.0f;
                    this.pierceCap = 3;
                    this.pierce = true;
                    this.pierceBuilding = true;
                    this.backColor = this.trailColor = NHItems.zeta.color;
                    this.hitColor = this.trailColor;
                    this.frontColor = Color.white;
                    this.trailWidth = 2.2f;
                    this.trailLength = 20;
                    this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    this.rangeChange = 56.0f;
                    this.buildingDamageMultiplier = 0.3f;
                    this.lightningDamage = 30.0f;
                    this.lightning = 1;
                    this.lightningLengthRand = 3;
                    this.lightningLength = 4;
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.titan, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new ArtilleryBulletType(2.5f, 500.0f, "shell"){
                {
                    this.hitEffect = new MultiEffect(new Effect[]{Fx.titanExplosionLarge, Fx.titanSmokeLarge, Fx.smokeAoeCloud});
                    this.despawnEffect = Fx.none;
                    this.knockback = 2.0f;
                    this.lifetime = 190.0f;
                    this.height = 19.0f;
                    this.width = 17.0f;
                    this.reloadMultiplier = 0.65f;
                    this.splashDamageRadius = 110.0f;
                    this.rangeChange = 8.0f;
                    this.splashDamage = 300.0f;
                    this.scaledSplashDamage = true;
                    this.trailColor = this.lightningColor = NHItems.zeta.color;
                    this.backColor = this.lightningColor;
                    this.hitColor = this.lightningColor;
                    this.frontColor = NHItems.zeta.color;
                    this.ammoMultiplier = 1.0f;
                    this.hitSound = Sounds.explosionTitan;
                    this.status = StatusEffects.blasted;
                    this.trailLength = 32;
                    this.trailWidth = 3.35f;
                    this.trailSinScl = 2.5f;
                    this.trailSinMag = 0.5f;
                    this.trailEffect = Fx.vapor;
                    this.trailInterval = 3.0f;
                    this.despawnShake = 7.0f;
                    this.shootEffect = Fx.shootTitan;
                    this.smokeEffect = Fx.shootSmokeTitan;
                    this.trailInterp = v -> Math.max(Mathf.slope((float)v), 0.8f);
                    this.shrinkX = 0.2f;
                    this.shrinkY = 0.1f;
                    this.buildingDamageMultiplier = 0.25f;
                    this.lightningDamage = 30.0f;
                    this.lightning = 4;
                    this.lightningLengthRand = 3;
                    this.lightningLength = 15;
                    this.fragBullets = 4;
                    this.fragBullet = new EmptyBulletType(){
                        {
                            this.lifetime = 180.0f;
                            this.speed = 0.3f;
                            this.bulletInterval = 20.0f;
                            this.intervalBullet = new EmptyBulletType(){
                                {
                                    this.splashDamage = 60.0f;
                                    this.collidesGround = true;
                                    this.collidesAir = false;
                                    this.collides = false;
                                    this.hitEffect = Fx.none;
                                    this.pierce = true;
                                    this.instantDisappear = true;
                                    this.splashDamageRadius = 90.0f;
                                    this.buildingDamageMultiplier = 0.2f;
                                    this.lightningDamage = 10.0f;
                                    this.lightning = 2;
                                    this.lightningLengthRand = 3;
                                    this.lightningLength = 5;
                                }
                            };
                        }
                    };
                }
            });
        }));
        NHPostProcess.adjustContent((Content)Blocks.disperse, (Cons<Content>)((Cons)content -> {
            ItemTurret turret = (ItemTurret)content;
            turret.ammoTypes.put((Object)NHItems.zeta, (Object)new BasicBulletType(){
                {
                    this.reloadMultiplier = 0.59f;
                    this.damage = 80.0f;
                    this.rangeChange = 24.0f;
                    this.lightning = 4;
                    this.lightningLength = 6;
                    this.lightningDamage = 24.0f;
                    this.lightningLengthRand = 3;
                    this.speed = 10.0f;
                    this.height = 16.0f;
                    this.width = 16.0f;
                    this.shrinkY = 0.3f;
                    this.backSprite = "large-bomb-back";
                    this.sprite = "mine-bullet";
                    this.collidesGround = false;
                    this.collidesTiles = false;
                    this.shootEffect = Fx.shootBig2;
                    this.smokeEffect = Fx.shootSmokeDisperse;
                    this.frontColor = Color.white;
                    this.hitColor = this.lightningColor = NHItems.zeta.color;
                    this.trailColor = this.lightningColor;
                    this.backColor = this.lightningColor;
                    this.trailChance = 0.44f;
                    this.ammoMultiplier = 3.0f;
                    this.lifetime = 34.0f;
                    this.rotationOffset = 90.0f;
                    this.trailRotation = true;
                    this.trailEffect = Fx.disperseTrail;
                    this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    this.bulletInterval = 3.0f;
                    this.intervalBullet = new BulletType(){
                        {
                            this.collidesGround = false;
                            this.collidesTiles = false;
                            this.lightningLengthRand = 2;
                            this.lightningLength = 2;
                            this.lightningCone = 30.0f;
                            this.lightningDamage = 10.0f;
                            this.lightning = 1;
                            this.collides = false;
                            this.hittable = false;
                            this.instantDisappear = true;
                            this.hitEffect = this.despawnEffect = Fx.none;
                        }
                    };
                }
            });
        }));
    }

    private static void overrideFactories() {
        NHPostProcess.adjustContent((Content)Blocks.graphitePress, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.consume((Consume)new ConsumeItems(ItemStack.with((Object[])new Object[]{Items.coal, 2})));
            crafter.outputItems = ItemStack.with((Object[])new Object[]{Items.graphite, 3});
            crafter.craftTime = 60.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.multiPress, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.consume((Consume)new ConsumeItems(ItemStack.with((Object[])new Object[]{Items.coal, 2})));
            crafter.outputItems = ItemStack.with((Object[])new Object[]{Items.graphite, 5});
            crafter.craftTime = 40.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.siliconSmelter, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.consume((Consume)new ConsumeItems(ItemStack.with((Object[])new Object[]{Items.sand, 3})));
            crafter.outputItems = ItemStack.with((Object[])new Object[]{Items.silicon, 2});
            crafter.craftTime = 60.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.siliconCrucible, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.requirements = ItemStack.with((Object[])new Object[]{Items.titanium, 120, Items.metaglass, 80, Items.silicon, 60});
            crafter.consumeItems(ItemStack.with((Object[])new Object[]{Items.sand, 8, Items.pyratite, 2}));
            crafter.outputItem = new ItemStack(Items.silicon, 15);
            crafter.craftTime = 120.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.pyratiteMixer, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.consumeItems(ItemStack.with((Object[])new Object[]{Items.coal, 1, Items.sand, 2}));
            crafter.outputItem = new ItemStack(Items.pyratite, 2);
            crafter.craftTime = 60.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.siliconArcFurnace, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.consume((Consume)new ConsumeItems(ItemStack.with((Object[])new Object[]{Items.sand, 5})));
            crafter.outputItems = ItemStack.with((Object[])new Object[]{Items.silicon, 5});
            crafter.craftTime = 60.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.cultivator, (Cons<Content>)((Cons)content -> {
            AttributeCrafter crafter = (AttributeCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeLiquid);
            crafter.consume((Consume)new ConsumeLiquid(Liquids.water, 0.3f));
            crafter.outputItems = ItemStack.with((Object[])new Object[]{Items.sporePod, 2});
            crafter.craftTime = 60.0f;
            crafter.consume((Consume)new ConsumePower(6.0f, 0.0f, false));
        }));
        NHPostProcess.adjustContent((Content)Blocks.blastMixer, (Cons<Content>)((Cons)content -> {
            GenericCrafter crafter = (GenericCrafter)content;
            crafter.removeConsumers(consume -> consume instanceof ConsumeItems);
            crafter.consume((Consume)new ConsumeItems(ItemStack.with((Object[])new Object[]{Items.sporePod, 3, Items.pyratite, 3})));
            crafter.outputItems = ItemStack.with((Object[])new Object[]{Items.blastCompound, 3});
            crafter.craftTime = 90.0f;
        }));
    }

    private static void overrideItem() {
        NHPostProcess.adjustContent((Content)Items.tungsten, (Cons<Content>)((Cons)content -> {
            Item item = (Item)content;
            item.shownPlanets.addAll((Object[])new Planet[]{Planets.serpulo});
        }));
        NHPostProcess.adjustContent((Content)Items.carbide, (Cons<Content>)((Cons)content -> {
            Item item = (Item)content;
            item.shownPlanets.addAll((Object[])new Planet[]{Planets.serpulo});
        }));
        NHPostProcess.adjustContent((Content)Items.plastanium, (Cons<Content>)((Cons)content -> {
            Item item = (Item)content;
            item.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir});
        }));
        NHPostProcess.adjustContent((Content)Items.titanium, (Cons<Content>)((Cons)content -> {
            Item item = (Item)content;
            item.shownPlanets.addAll((Object[])new Planet[]{Planets.erekir});
        }));
        NHPostProcess.adjustContent((Content)Items.silicon, (Cons<Content>)((Cons)content -> {
            Item item = (Item)content;
            item.hardness = 3;
        }));
    }

    private static void overrideUnit() {
        for (UnitType type : Vars.content.units()) {
            type.envRequired = 0;
            type.envDisabled = 0;
            type.envEnabled = -1;
        }
        NHPostProcess.adjustContent((Content)UnitTypes.tecta, (Cons<Content>)((Cons)content -> {
            UnitType unitType = (UnitType)content;
            unitType.abilities.each(ability -> ability instanceof ShieldArcAbility, ability -> {
                ((ShieldArcAbility)ability).chanceDeflect = -1.0f;
            });
        }));
        NHPostProcess.hideContent((UnlockableContent)Blocks.payloadConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.payloadRouter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.reinforcedPayloadConveyor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.reinforcedPayloadRouter);
        NHPostProcess.hideContent((UnlockableContent)Blocks.deconstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.smallDeconstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.constructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.largeConstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.groundFactory);
        NHPostProcess.hideContent((UnlockableContent)Blocks.airFactory);
        NHPostProcess.hideContent((UnlockableContent)Blocks.navalFactory);
        NHPostProcess.hideContent((UnlockableContent)Blocks.additiveReconstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.multiplicativeReconstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.exponentialReconstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.tetrativeReconstructor);
        NHPostProcess.hideContent((UnlockableContent)Blocks.tankFabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.tankRefabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.tankAssembler);
        NHPostProcess.hideContent((UnlockableContent)Blocks.mechFabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.mechRefabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.mechAssembler);
        NHPostProcess.hideContent((UnlockableContent)Blocks.shipFabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.shipRefabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.shipAssembler);
        NHPostProcess.hideContent((UnlockableContent)Blocks.primeRefabricator);
        NHPostProcess.hideContent((UnlockableContent)Blocks.basicAssemblerModule);
    }

    private static void overrideCoreUnit() {
        NHPostProcess.adjustContent((Content)Blocks.coreShard, (Cons<Content>)((Cons)content -> {
            CoreBlock core = (CoreBlock)content;
            core.buildVisibility = BuildVisibility.shown;
            core.armor = 5.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.coreFoundation, (Cons<Content>)((Cons)content -> {
            CoreBlock core = (CoreBlock)content;
            core.armor = 10.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.coreNucleus, (Cons<Content>)((Cons)content -> {
            CoreBlock core = (CoreBlock)content;
            core.armor = 15.0f;
        }));
        NHPostProcess.adjustContent((Content)Blocks.coreBastion, (Cons<Content>)((Cons)content -> {
            CoreBlock core = (CoreBlock)content;
            core.incinerateNonBuildable = false;
            core.requiresCoreZone = false;
        }));
        NHPostProcess.adjustContent((Content)Blocks.coreCitadel, (Cons<Content>)((Cons)content -> {
            CoreBlock core = (CoreBlock)content;
            core.incinerateNonBuildable = false;
            core.requiresCoreZone = false;
        }));
        NHPostProcess.adjustContent((Content)Blocks.coreAcropolis, (Cons<Content>)((Cons)content -> {
            CoreBlock core = (CoreBlock)content;
            core.incinerateNonBuildable = false;
            core.requiresCoreZone = false;
        }));
        NHPostProcess.adjustContent((Content)UnitTypes.alpha, (Cons<Content>)((Cons)content -> {
            UnitType unitType = (UnitType)content;
            unitType.mineSpeed = 8.0f;
            unitType.weapons.each(weapon -> Objects.equals(weapon.name, "small-basic-weapon"), weapon -> {
                weapon.reload = 15.0f;
            });
        }));
        NHPostProcess.adjustContent((Content)UnitTypes.beta, (Cons<Content>)((Cons)content -> {
            UnitType unitType = (UnitType)content;
            unitType.mineSpeed = 10.0f;
            unitType.weapons.each(weapon -> Objects.equals(weapon.name, "small-mount-weapon"), weapon -> {
                weapon.reload = 20.0f;
            });
        }));
        NHPostProcess.adjustContent((Content)UnitTypes.gamma, (Cons<Content>)((Cons)content -> {
            UnitType unitType = (UnitType)content;
            unitType.mineSpeed = 12.5f;
            unitType.weapons.each(weapon -> Objects.equals(weapon.name, "small-mount-weapon"), weapon -> {
                weapon.reload = 16.0f;
            });
        }));
    }

    private static void overrideUnitShield() {
        for (UnitType type : Vars.content.units()) {
            if (type.abilities.contains(ability -> ability instanceof PassiveShield)) continue;
            type.abilities.add((Object)new PassiveShield(type.health));
        }
    }

    private static ItemStack[] hugeItemReq() {
        ItemStack[] out = new ItemStack[Vars.content.items().size];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new ItemStack(Vars.content.item(i), 114514);
        }
        return out;
    }

    private static void hideContent(UnlockableContent content) {
        if (content instanceof Block) {
            Block block = (Block)content;
            block.buildVisibility = BuildVisibility.hidden;
            block.envRequired = 0;
            block.instantDeconstruct = true;
        }
    }

    private static void adjustContent(Content content, Cons<Content> modifier) {
        modifier.get((Object)content);
    }
}

