/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.graphics.gl.Shader;
import arc.scene.ui.layout.Scl;
import arc.util.Time;
import mindustry.Vars;
import mindustry.graphics.Shaders;
import mindustry.mod.Mods;
import newhorizon.NewHorizon;
import newhorizon.content.NHContent;

public class NHShaders {
    public static ModShader gravityTrap;
    public static ModShader quantum;
    public static ModShader statusXWave;
    public static ModSurfaceShader displaceGlitch;

    public static void init() {
        gravityTrap = new ModShader("VFX_gravityTrap"){

            public void apply() {
                this.setUniformf("u_scale", Scl.scl((float)1.0f));
                this.setUniformf("u_time", Time.time / Scl.scl((float)1.0f));
                this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
                this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
            }
        };
        statusXWave = new ModShader("VFX_obliqueWave"){

            public void apply() {
                this.setUniformf("u_texsize", Core.camera.width * Vars.renderer.getDisplayScale(), Core.camera.height * Vars.renderer.getDisplayScale());
                this.setUniformf("u_invsize", 1.0f / Core.camera.width * Vars.renderer.getDisplayScale(), 1.0f / Core.camera.height * Vars.renderer.getDisplayScale());
                this.setUniformf("u_time", Time.time);
            }
        };
        displaceGlitch = new ModSurfaceShader("VFX_displaceGlitch"){

            @Override
            public void apply() {
                this.setUniformf("u_texsize", Core.graphics.getWidth(), Core.graphics.getHeight());
                this.setUniformf("u_time", Time.time / Scl.scl((float)1.0f));
                this.setUniformf("u_intensity", this.intensity);
                if (this.hasUniform("u_noise")) {
                    if (this.noiseTex1 == null) {
                        this.noiseTex1 = this.getTexture() == null ? (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class) : this.getTexture();
                    }
                    this.noiseTex1.bind(1);
                    this.texture.bind(0);
                    this.setUniformi("u_noise", 1);
                }
            }

            @Override
            public String textureName() {
                return super.textureName();
            }

            @Override
            public void loadNoise() {
                super.loadNoise();
                this.noiseTex1 = NHContent.noise;
            }

            @Override
            public Texture getTexture() {
                return NHContent.noise;
            }
        };
        quantum = new ModSurfaceShader("noise_quantum"){

            @Override
            public String textureName() {
                return super.textureName();
            }

            @Override
            public void loadNoise() {
                super.loadNoise();
                this.noiseTex2 = NHContent.darkerNoise;
                this.noiseTex1 = NHContent.smoothNoise;
            }

            @Override
            public Texture getTexture() {
                return NHContent.smoothNoise;
            }
        };
    }

    public static Fi getShaderFi(String file) {
        Mods.LoadedMod mod = NewHorizon.MOD;
        Fi shaders = mod.root.child("shaders");
        if (shaders.exists() && shaders.child(file).exists()) {
            return shaders.child(file);
        }
        return Shaders.getShaderFi((String)file);
    }

    public static class ModShader
    extends Shader {
        public ModShader(String vert, String frag) {
            super(NHShaders.getShaderFi(vert + ".vert"), NHShaders.getShaderFi(frag + ".frag"));
        }

        public ModShader(String frag) {
            super(NHShaders.getShaderFi("screenspace.vert"), NHShaders.getShaderFi(frag + ".frag"));
        }
    }

    public static class ModSurfaceShader
    extends ModShader {
        public float intensity = 0.0f;
        public Texture texture;
        protected Texture noiseTex1;
        protected Texture noiseTex2;

        public ModSurfaceShader(String frag) {
            super("screenspace", frag);
            this.loadNoise();
        }

        public Texture getTexture() {
            return null;
        }

        public String textureName() {
            return "noise";
        }

        public void loadNoise() {
            Core.assets.load((String)new StringBuilder().append((String)"sprites/").append((String)this.textureName()).append((String)".png").toString(), Texture.class).loaded = t -> {
                t.setFilter(Texture.TextureFilter.linear);
                t.setWrap(Texture.TextureWrap.repeat);
            };
        }

        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformf("u_time", Time.time);
            if (this.hasUniform("u_noise")) {
                if (this.noiseTex1 == null) {
                    this.noiseTex1 = this.getTexture() == null ? (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class) : this.getTexture();
                }
                this.noiseTex1.bind(1);
                ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                this.setUniformi("u_noise", 1);
            }
            if (this.hasUniform("u_noise_2")) {
                if (this.noiseTex2 == null) {
                    this.noiseTex2 = (Texture)Core.assets.get("sprites/noise.png", Texture.class);
                }
                this.noiseTex2.bind(1);
                ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                this.setUniformi("u_noise_2", 1);
            }
        }
    }
}

