/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Icon;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.StatValues;
import newhorizon.expand.bullets.TypeDamageBulletType;

public class NHStatValues {
    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, int indent, boolean showUnit) {
        return table -> {
            table.row();
            Seq orderedKeys = map.keys().toSeq();
            orderedKeys.sort();
            for (UnlockableContent t : orderedKeys) {
                boolean compact = t instanceof UnitType && !showUnit || indent > 0;
                BulletType type = (BulletType)map.get((Object)t);
                if (type.spawnUnit != null && type.spawnUnit.weapons.size > 0) {
                    NHStatValues.ammo(ObjectMap.of((Object[])new Object[]{t, ((Weapon)type.spawnUnit.weapons.first()).bullet}), indent, false).display(table);
                    continue;
                }
                table.table(Styles.grayPanel, bt -> {
                    bt.left().top().defaults().padRight(3.0f).left();
                    if (!compact && !(t instanceof Turret)) {
                        bt.table(title -> {
                            title.image(NHStatValues.icon(t)).size(24.0f).padRight(4.0f).right().scaling(Scaling.fit).top();
                            title.add((CharSequence)t.localizedName).padRight(10.0f).left().top();
                        });
                        bt.row();
                    }
                    if (type instanceof TypeDamageBulletType) {
                        TypeDamageBulletType typeDamageBulletType = (TypeDamageBulletType)type;
                        typeDamageBulletType.buildStat(type, t, (Table)bt, compact);
                    } else {
                        Collapser coll;
                        if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                            if (type.continuousDamage() > 0.0f) {
                                bt.add((CharSequence)(Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.continuousDamage())}) + StatUnit.perSecond.localized()));
                            } else {
                                bt.add((CharSequence)Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.damage)}));
                            }
                        }
                        NHStatValues.buildSharedBulletTypeStat(type, t, bt, compact);
                        if (type.intervalBullet != null) {
                            bt.row();
                            Table ic = new Table();
                            StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{t, type.intervalBullet}), (boolean)true, (boolean)false).display(ic);
                            coll = new Collapser(ic, true);
                            coll.setDuration(0.1f);
                            bt.table(it -> {
                                it.left().defaults().left();
                                it.add((CharSequence)Core.bundle.format("bullet.interval", new Object[]{Strings.autoFixed((float)((float)type.intervalBullets / type.bulletInterval * 60.0f), (int)2)}));
                                it.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                    i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                                }).size(8.0f).padLeft(16.0f).expandX();
                            });
                            bt.row();
                            bt.add((Element)coll);
                        }
                        if (type.fragBullet != null) {
                            bt.row();
                            Table fc = new Table();
                            StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{t, type.fragBullet}), (boolean)true, (boolean)false).display(fc);
                            coll = new Collapser(fc, true);
                            coll.setDuration(0.1f);
                            bt.table(ft -> {
                                ft.left().defaults().left();
                                ft.add((CharSequence)Core.bundle.format("bullet.frags", new Object[]{type.fragBullets}));
                                ft.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                    i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                                }).size(8.0f).padLeft(16.0f).expandX();
                            });
                            bt.row();
                            bt.add((Element)coll);
                        }
                    }
                }).padLeft((float)(indent * 5)).padTop(5.0f).padBottom(compact ? 0.0f : 5.0f).growX().margin(compact ? 0.0f : 10.0f);
                table.row();
            }
        };
    }

    public static void buildSharedBulletTypeStat(BulletType type, UnlockableContent t, Table bt, boolean compact) {
        block19: {
            block20: {
                if (type.buildingDamageMultiplier != 1.0f) {
                    NHStatValues.sep(bt, Core.bundle.format("bullet.buildingdamage", new Object[]{NHStatValues.ammoStat((int)(type.buildingDamageMultiplier * 100.0f - 100.0f))}));
                }
                if (type.rangeChange != 0.0f && !compact) {
                    NHStatValues.sep(bt, Core.bundle.format("bullet.range", new Object[]{NHStatValues.ammoStat(type.rangeChange / 8.0f)}));
                }
                if (compact || Mathf.equal((float)type.ammoMultiplier, (float)1.0f) || !type.displayAmmoMultiplier) break block19;
                if (!(t instanceof Turret)) break block20;
                Turret turret = (Turret)t;
                if (!turret.displayAmmoMultiplier) break block19;
            }
            NHStatValues.sep(bt, Core.bundle.format("bullet.multiplier", new Object[]{(int)type.ammoMultiplier}));
        }
        if (!compact && !Mathf.equal((float)type.reloadMultiplier, (float)1.0f)) {
            int val = (int)(type.reloadMultiplier * 100.0f - 100.0f);
            NHStatValues.sep(bt, Core.bundle.format("bullet.reload", new Object[]{NHStatValues.ammoStat(val)}));
        }
        if (type.knockback > 0.0f) {
            NHStatValues.sep(bt, Core.bundle.format("bullet.knockback", new Object[]{Strings.autoFixed((float)type.knockback, (int)2)}));
        }
        if (type.healPercent > 0.0f) {
            NHStatValues.sep(bt, Core.bundle.format("bullet.healpercent", new Object[]{Strings.autoFixed((float)type.healPercent, (int)2)}));
        }
        if (type.healAmount > 0.0f) {
            NHStatValues.sep(bt, Core.bundle.format("bullet.healamount", new Object[]{Strings.autoFixed((float)type.healAmount, (int)2)}));
        }
        if (type.pierce || type.pierceCap != -1) {
            NHStatValues.sep(bt, type.pierceCap == -1 ? "@bullet.infinitepierce" : Core.bundle.format("bullet.pierce", new Object[]{type.pierceCap}));
        }
        if (type.incendAmount > 0) {
            NHStatValues.sep(bt, "@bullet.incendiary");
        }
        if (type.homingPower > 0.01f) {
            NHStatValues.sep(bt, "@bullet.homing");
        }
        if (type.lightning > 0) {
            NHStatValues.sep(bt, Core.bundle.format("bullet.lightning", new Object[]{type.lightning, Float.valueOf(type.lightningDamage < 0.0f ? type.damage : type.lightningDamage)}));
        }
        if (type.pierceArmor) {
            NHStatValues.sep(bt, "@bullet.armorpierce");
        }
        if (type.maxDamageFraction > 0.0f) {
            NHStatValues.sep(bt, Core.bundle.format("bullet.maxdamagefraction", new Object[]{(int)(type.maxDamageFraction * 100.0f)}));
        }
        if (type.suppressionRange > 0.0f) {
            NHStatValues.sep(bt, Core.bundle.format("bullet.suppression", new Object[]{Strings.autoFixed((float)(type.suppressionDuration / 60.0f), (int)2), Strings.fixed((float)(type.suppressionRange / 8.0f), (int)1)}));
        }
        if (type.status != StatusEffects.none) {
            NHStatValues.sep(bt, (type.status.hasEmoji() ? type.status.emoji() : "") + "[stat]" + type.status.localizedName + (type.status.reactive ? "" : "[lightgray] ~ [stat]" + (int)(type.statusDuration / 60.0f) + "[lightgray] " + Core.bundle.get("unit.seconds"))).with(c -> StatValues.withTooltip((Element)c, (UnlockableContent)type.status));
        }
        if (!type.targetMissiles) {
            NHStatValues.sep(bt, "@bullet.notargetsmissiles");
        }
        if (!type.targetBlocks) {
            NHStatValues.sep(bt, "@bullet.notargetsbuildings");
        }
    }

    public static StatValue boosters(float reload, float maxUsed, float multiplier, boolean baseReload, Boolf<Liquid> filter, boolean noReloadBoost) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get((Object)liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> {
                            info.add((CharSequence)liquid.localizedName).left().row();
                            info.add((CharSequence)(Strings.autoFixed((float)(maxUsed * 60.0f), (int)2) + StatUnit.perSecond.localized())).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            float reloadRate = (baseReload ? 1.0f : 0.0f) + maxUsed * multiplier * liquid.heatCapacity;
                            float standardReload = baseReload ? reload : reload / (maxUsed * multiplier * 0.4f);
                            float result = standardReload / (reload / reloadRate);
                            if (!noReloadBoost) {
                                bt.add((CharSequence)Core.bundle.format("bullet.reload", new Object[]{Strings.autoFixed((float)(result * 100.0f), (int)2)})).pad(5.0f).right().row();
                            }
                            bt.add((CharSequence)Core.bundle.format("nh.stat.speed-up-turret-coolant", new Object[]{Strings.autoFixed((float)((liquid.heatCapacity + 1.0f) * 100.0f), (int)2), Strings.autoFixed((float)(1.0f / (liquid.heatCapacity + 1.0f) * 100.0f), (int)0)})).pad(5.0f);
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue weapons(UnitType unit, Seq<Weapon> weapons) {
        return table -> {
            table.row();
            for (int i = 0; i < weapons.size; ++i) {
                Weapon weapon = (Weapon)weapons.get(i);
                if (weapon.flipSprite || !weapon.hasStats(unit)) continue;
                TextureRegion region = !weapon.name.isEmpty() ? Core.atlas.find(weapon.name + "-preview", weapon.region) : null;
                table.table(Styles.grayPanel, w -> {
                    w.left().top().defaults().padRight(3.0f).left();
                    if (region != null && region.found() && weapon.showStatSprite) {
                        w.image(region).size(60.0f).scaling(Scaling.bounded).left().top();
                    }
                    w.row();
                    if (weapon.inaccuracy > 0.0f) {
                        w.row();
                        w.add((CharSequence)("[lightgray]" + Stat.inaccuracy.localized() + ": [white]" + (int)weapon.inaccuracy + " " + StatUnit.degrees.localized()));
                    }
                    if (!weapon.alwaysContinuous && weapon.reload > 0.0f) {
                        w.row();
                        w.add((CharSequence)("[lightgray]" + Stat.reload.localized() + ": " + (weapon.mirror ? "2x " : "") + "[white]" + Strings.autoFixed((float)(60.0f / weapon.reload * (float)weapon.shoot.shots), (int)2) + " " + StatUnit.perSecond.localized()));
                    }
                    NHStatValues.ammo(ObjectMap.of((Object[])new Object[]{unit, weapon.bullet}), 0, false).display(w);
                }).growX().pad(5.0f).margin(10.0f);
                table.row();
            }
        };
    }

    private static Cell<?> sep(Table table, String text) {
        table.row();
        return table.add((CharSequence)text);
    }

    private static String ammoStat(float val) {
        return (val > 0.0f ? "[stat]+" : "[negstat]") + Strings.autoFixed((float)val, (int)1);
    }

    private static TextureRegion icon(UnlockableContent t) {
        return t.uiIcon;
    }
}

