/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.MinerAI;
import mindustry.audio.SoundLoop;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.abilities.EnergyFieldAbility;
import mindustry.entities.abilities.ForceFieldAbility;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.abilities.MoveLightningAbility;
import mindustry.entities.abilities.RepairFieldAbility;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.entities.abilities.ShieldRegenFieldAbility;
import mindustry.entities.abilities.StatusFieldAbility;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousFlameBulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.HaloPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.part.ShapePart;
import mindustry.entities.pattern.ShootAlternate;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.pattern.ShootHelix;
import mindustry.entities.pattern.ShootMulti;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.pattern.ShootSine;
import mindustry.entities.pattern.ShootSpread;
import mindustry.entities.pattern.ShootSummon;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Mechc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.ammo.ItemAmmoType;
import mindustry.type.ammo.PowerAmmoType;
import mindustry.type.weapons.PointDefenseWeapon;
import mindustry.type.weapons.RepairBeamWeapon;
import mindustry.world.meta.BlockFlag;
import newhorizon.NHSetting;
import newhorizon.NewHorizon;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHContent;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.bullets.AccelBulletType;
import newhorizon.expand.bullets.AdaptedSapBulletType;
import newhorizon.expand.bullets.AdaptedShootHelix;
import newhorizon.expand.bullets.ChainBulletType;
import newhorizon.expand.bullets.DelayedPointBulletType;
import newhorizon.expand.bullets.EffectBulletType;
import newhorizon.expand.bullets.LightningLinkerBulletType;
import newhorizon.expand.bullets.ShieldBreakerType;
import newhorizon.expand.bullets.StrafeLaser;
import newhorizon.expand.bullets.TextureMissileType;
import newhorizon.expand.bullets.adapt.AdaptBulletType;
import newhorizon.expand.bullets.adapt.AdaptLaserBulletType;
import newhorizon.expand.bullets.adapt.PosLightningType;
import newhorizon.expand.entities.UltFire;
import newhorizon.expand.units.AdaptedTimedKillUnit;
import newhorizon.expand.units.AncientEngine;
import newhorizon.expand.units.BoostAbility;
import newhorizon.expand.units.EnergyUnit;
import newhorizon.expand.units.ablility.AdaptedHealAbility;
import newhorizon.expand.units.ablility.GravityTrapAbility;
import newhorizon.expand.units.ablility.HealFieldAbility;
import newhorizon.expand.units.ablility.ShockWaveAbility;
import newhorizon.expand.units.ablility.TurretShield;
import newhorizon.expand.units.ai.InterceptorAI;
import newhorizon.expand.units.ai.ProbeAI;
import newhorizon.expand.units.ai.SniperAI;
import newhorizon.expand.units.ai.SurroundAI;
import newhorizon.expand.units.unitEntity.NucleoidEntity;
import newhorizon.expand.units.unitEntity.PesterEntity;
import newhorizon.expand.units.unitEntity.ProbeEntity;
import newhorizon.expand.units.unitType.AncientUnitType;
import newhorizon.expand.units.unitType.NHUnitType;
import newhorizon.expand.units.unitType.content.Destruction;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;
import newhorizon.util.func.NHPixmap;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.EffectWrapper;
import newhorizon.util.graphic.OptionalMultiEffect;

public class NHUnitTypes {
    public static final Color OColor = Color.valueOf((String)"565666");
    public static final byte ANCIENT_GROUND = 10;
    public static final byte ANCIENT_AIR = 11;
    public static final byte OTHERS = -128;
    public static final byte GROUND_LINE_1 = 0;
    public static final byte AIR_LINE_1 = 1;
    public static final byte AIR_LINE_2 = 2;
    public static final byte ENERGY_LINE_1 = 3;
    public static final byte NAVY_LINE_1 = 6;
    public static Weapon BasicCannon;
    public static Weapon laserCannon;
    public static Weapon laugraTurret;
    public static Weapon ancientPulseLaser;
    public static Weapon ancientPulseLaserSmall;
    public static Weapon ancientSecTurret;
    public static Weapon ancientLightningBallTurret;
    public static Weapon ancientPrism;
    public static Weapon posLiTurret;
    public static Weapon closeAATurret;
    public static Weapon collapserCannon;
    public static Weapon collapserLaser;
    public static Weapon multipleLauncher;
    public static Weapon smallCannon;
    public static Weapon mainCannon;
    public static Weapon pointDefenceWeaponC;
    public static NHUnitType guardian;
    public static NHUnitType gather;
    public static NHUnitType saviour;
    public static NHUnitType rhino;
    public static NHUnitType restrictionEnzyme;
    public static NHUnitType nucleoid;
    public static NHUnitType pester;
    public static NHUnitType laugra;
    public static NHUnitType macrophage;
    public static NHUnitType ancientProbe;
    public static NHUnitType assaulter;
    public static NHUnitType anvil;
    public static NHUnitType collapser;
    public static NHUnitType origin;
    public static NHUnitType thynomo;
    public static NHUnitType aliotiat;
    public static NHUnitType tarlidor;
    public static NHUnitType annihilation;
    public static NHUnitType sin;
    public static NHUnitType sharp;
    public static NHUnitType branch;
    public static NHUnitType warper;
    public static NHUnitType naxos;
    public static NHUnitType destruction;
    public static NHUnitType longinus;
    public static NHUnitType hurricane;
    public static NHUnitType ghost;
    public static NHUnitType zarkov;
    public static NHUnitType declining;
    public static NHUnitType liv;
    public static Seq<StatusEffect> statuses;

    private static void loadPreviousWeapon() {
        ancientSecTurret = new Weapon(NewHorizon.name("pester-secondary-laser")){
            {
                this.shootY = 3.0f;
                this.shootX = -1.0f;
                this.recoil = 1.0f;
                this.reload = 16.0f;
                this.rotate = true;
                this.mirror = true;
                this.rotateSpeed = 4.0f;
                this.autoTarget = true;
                this.controllable = false;
                this.shootSound = NHSounds.gauss;
                this.bullet = new PosLightningType(120.0f){
                    {
                        super(damage);
                        this.maxRange = 160.0f;
                        this.lifetime = 48.0f;
                        this.boltNum = 1;
                        this.hitEffect = NHFx.hitSpark;
                        this.lightColor = this.lightningColor = NHColor.ancient;
                        this.hitColor = this.lightningColor;
                    }
                };
            }
        };
        laserCannon = new Weapon(NewHorizon.name("laser-cannon")){
            {
                this.rotate = true;
                this.autoTarget = true;
                this.alternate = true;
                this.top = true;
                this.mirror = true;
                this.controllable = false;
                this.predictTarget = false;
                this.x = 22.0f;
                this.y = -50.0f;
                this.reload = 12.0f;
                this.recoil = 3.0f;
                this.inaccuracy = 0.0f;
                this.shoot = new ShootPattern();
                this.rotateSpeed = 25.0f;
                this.shootSound = NHSounds.gauss;
                this.bullet = new ShrapnelBulletType(){
                    {
                        this.lifetime = 45.0f;
                        this.length = 200.0f;
                        this.damage = 180.0f;
                        this.status = StatusEffects.shocked;
                        this.statusDuration = 60.0f;
                        this.fromColor = NHColor.lightSkyFront;
                        this.toColor = NHColor.lightSkyBack;
                        this.serrationSpaceOffset = 40.0f;
                        this.width = 6.0f;
                        this.shootEffect = NHFx.lightningHitSmall(NHColor.lightSkyBack);
                        this.smokeEffect = new MultiEffect(new Effect[]{NHFx.lightSkyCircleSplash, new Effect(this.lifetime + 10.0f, b -> {
                            Draw.color((Color)this.fromColor, (Color)this.toColor, (float)b.fin());
                            Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.75f * b.fout()));
                        })});
                    }
                };
            }
        };
        pointDefenceWeaponC = new PointDefenseWeapon(NewHorizon.name("cannon")){
            {
                this.color = NHColor.lightSkyFront;
                this.alternate = true;
                this.top = true;
                this.mirror = true;
                this.reload = 6.0f;
                this.targetInterval = 6.0f;
                this.targetSwitchInterval = 6.0f;
                this.bullet = new BulletType(){
                    {
                        this.shootEffect = NHFx.shootLineSmall(color);
                        this.hitEffect = NHFx.lightningHitSmall;
                        this.hitColor = color;
                        this.maxRange = 240.0f;
                        this.damage = 150.0f;
                    }
                };
            }
        };
        mainCannon = new Weapon(NewHorizon.name("main-cannon")){
            {
                this.rotate = true;
                this.mirror = false;
                this.alternate = false;
                this.cooldownTime = 240.0f;
                this.recoil = 7.0f;
                this.inaccuracy = 4.0f;
                this.velocityRnd = 0.075f;
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 3;
                        this.firstShotDelay = 280.0f;
                        this.shotDelay = 20.0f;
                    }
                };
                this.rotateSpeed = 1.0f;
                this.shootSound = NHSounds.flak2;
                this.shootCone = 5.0f;
                this.shootY = 6.0f;
                this.reload = 300.0f;
                this.shake = 7.0f;
                this.ejectEffect = Fx.blastsmoke;
                this.bullet = NHBullets.declineProjectile;
            }

            public void draw(Unit unit, WeaponMount mount) {
                super.draw(unit, mount);
                if (!unit.isLocal()) {
                    return;
                }
                float z = Draw.z();
                float rotation = unit.rotation - 90.0f;
                float weaponRotation = rotation + (this.rotate ? mount.rotation : 0.0f);
                float fin = Mathf.clamp((float)(1.0f - (mount.reload - 10.0f) / this.reload));
                float wx = unit.x + Angles.trnsx((float)rotation, (float)this.x, (float)this.y) + Angles.trnsx((float)weaponRotation, (float)0.0f, (float)this.recoil);
                float wy = unit.y + Angles.trnsy((float)rotation, (float)this.x, (float)this.y) + Angles.trnsy((float)weaponRotation, (float)0.0f, (float)this.recoil);
                if (fin == 1.0f) {
                    return;
                }
                TextureRegion arrowRegion = NHContent.arrowRegion;
                Draw.z((float)100.0f);
                Draw.color((Color)this.bullet.hitColor);
                float railF = Mathf.curve((float)Interp.pow2Out.apply(fin), (float)0.0f, (float)0.25f) * Mathf.curve((float)Interp.pow4Out.apply(1.0f - fin), (float)0.0f, (float)0.1f) * fin;
                float length = Math.min(this.bullet.range, Mathf.dst((float)wx, (float)wy, (float)unit.aimX, (float)unit.aimY));
                float spacing = 25.0f;
                int i = 0;
                while ((float)i <= length / spacing) {
                    Tmp.v1.trns(weaponRotation + 90.0f, (float)i * spacing * Mathf.curve((float)Interp.pow4Out.apply(1.0f - fin), (float)0.0f, (float)0.1f) + this.shootY);
                    float f = Interp.pow3Out.apply(Mathf.clamp((float)((fin * length - (float)i * spacing) / spacing))) * (0.6f + railF * 0.4f) * 0.8f;
                    Draw.rect((TextureRegion)arrowRegion, (float)(wx + Tmp.v1.x), (float)(wy + Tmp.v1.y), (float)((float)arrowRegion.width * Draw.scl * f), (float)((float)arrowRegion.height * Draw.scl * f), (float)weaponRotation);
                    ++i;
                }
                Tmp.v1.trns(weaponRotation + 90.0f, 0.0f, (2.0f - railF) * 5.0f);
                Tmp.v2.trns(weaponRotation + 90.0f, this.shootY);
                Lines.stroke((float)(railF * 2.0f));
                for (int i2 : Mathf.signs) {
                    Lines.lineAngle((float)(wx + Tmp.v1.x * (float)i2 + Tmp.v2.x), (float)(wy + Tmp.v1.y * (float)i2 + Tmp.v2.y), (float)(weaponRotation + 90.0f), (float)(length * (0.75f + railF / 4.0f) * Mathf.curve((float)(Interp.pow5Out.apply(1.0f - fin) * Mathf.curve((float)Interp.pow4Out.apply(1.0f - fin), (float)0.0f, (float)0.1f)), (float)0.0f, (float)0.1f)));
                }
                Draw.reset();
                Draw.z((float)z);
            }

            public void update(Unit unit, WeaponMount mount) {
                boolean can = unit.canShoot();
                float lastReload = mount.reload;
                mount.reload = Math.max(mount.reload - Time.delta * unit.reloadMultiplier, 0.0f);
                mount.recoil = Mathf.approachDelta((float)mount.recoil, (float)0.0f, (float)(unit.reloadMultiplier / this.recoilTime));
                if (this.recoils > 0) {
                    if (mount.recoils == null) {
                        mount.recoils = new float[this.recoils];
                    }
                    for (int i = 0; i < this.recoils; ++i) {
                        mount.recoils[i] = Mathf.approachDelta((float)mount.recoils[i], (float)0.0f, (float)(unit.reloadMultiplier / this.recoilTime));
                    }
                }
                mount.smoothReload = Mathf.lerpDelta((float)mount.smoothReload, (float)(mount.reload / this.reload), (float)this.smoothReloadSpeed);
                mount.charge = mount.charging && this.shoot.firstShotDelay > 0.0f ? Mathf.approachDelta((float)mount.charge, (float)1.0f, (float)(1.0f / this.shoot.firstShotDelay)) : 0.0f;
                float warmupTarget = can && mount.shoot || this.continuous && mount.bullet != null || mount.charging ? 1.0f : 0.0f;
                mount.warmup = this.linearWarmup ? Mathf.approachDelta((float)mount.warmup, (float)warmupTarget, (float)this.shootWarmupSpeed) : Mathf.lerpDelta((float)mount.warmup, (float)warmupTarget, (float)this.shootWarmupSpeed);
                if (can) {
                    mount.targetRotation = Angles.angle((float)unit.x, (float)unit.y, (float)unit.aimX, (float)unit.aimY) - unit.rotation;
                    mount.rotation = Angles.moveToward((float)mount.rotation, (float)mount.targetRotation, (float)(this.rotateSpeed * Time.delta));
                }
                float weaponRotation = unit.rotation - 90.0f + (this.rotate ? mount.rotation : this.baseRotation);
                float mountX = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
                float mountY = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
                float bulletX = mountX + Angles.trnsx((float)weaponRotation, (float)this.shootX, (float)this.shootY);
                float bulletY = mountY + Angles.trnsy((float)weaponRotation, (float)this.shootX, (float)this.shootY);
                float shootAngle = this.bulletRotation(unit, mount, bulletX, bulletY);
                if (!this.controllable && this.autoTarget) {
                    float f;
                    mount.retarget -= Time.delta;
                    if (f <= 0.0f) {
                        mount.target = this.findTarget(unit, mountX, mountY, this.bullet.range, this.bullet.collidesAir, this.bullet.collidesGround);
                        float f2 = mount.retarget = mount.target == null ? this.targetInterval : this.targetSwitchInterval;
                    }
                    if (mount.target != null && this.checkTarget(unit, mount.target, mountX, mountY, this.bullet.range)) {
                        mount.target = null;
                    }
                    boolean shoot = false;
                    if (mount.target != null) {
                        boolean bl = shoot = mount.target.within(mountX, mountY, this.bullet.range + Math.abs(this.shootY) + (mount.target instanceof Sized ? ((Sized)mount.target).hitSize() / 2.0f : 0.0f)) && can;
                        if (this.predictTarget) {
                            Vec2 to = Predict.intercept((Position)unit, (Position)mount.target, (float)this.bullet.speed);
                            mount.aimX = to.x;
                            mount.aimY = to.y;
                        } else {
                            mount.aimX = mount.target.x();
                            mount.aimY = mount.target.y();
                        }
                    }
                    mount.shoot = mount.rotate = shoot;
                }
                if (this.alwaysShooting) {
                    mount.shoot = true;
                }
                if (this.continuous && mount.bullet != null) {
                    if (!mount.bullet.isAdded() || mount.bullet.time >= mount.bullet.lifetime || mount.bullet.type != this.bullet) {
                        mount.bullet = null;
                    } else {
                        mount.bullet.rotation(weaponRotation + 90.0f);
                        mount.bullet.set(bulletX, bulletY);
                        mount.reload = this.reload;
                        mount.recoil = 1.0f;
                        unit.vel.add(Tmp.v1.trns(unit.rotation + 180.0f, mount.bullet.type.recoil * Time.delta));
                        if (this.shootSound != Sounds.none && !Vars.headless) {
                            if (mount.sound == null) {
                                mount.sound = new SoundLoop(this.shootSound, 1.0f);
                            }
                            mount.sound.update(bulletX, bulletY, true);
                        }
                        if (this.alwaysContinuous && mount.shoot) {
                            mount.bullet.time = mount.bullet.lifetime * mount.bullet.type.optimalLifeFract * mount.warmup;
                            mount.bullet.keepAlive = true;
                            unit.apply(this.shootStatus, this.shootStatusDuration);
                        }
                    }
                } else {
                    mount.heat = Math.max(mount.heat - Time.delta * unit.reloadMultiplier / this.cooldownTime, 0.0f);
                    if (mount.sound != null) {
                        mount.sound.update(bulletX, bulletY, false);
                    }
                }
                boolean wasFlipped = mount.side;
                if (this.otherSide != -1 && this.alternate && mount.side == this.flipSprite && mount.reload <= this.reload / 2.0f && lastReload > this.reload / 2.0f) {
                    unit.mounts[this.otherSide].side = !unit.mounts[this.otherSide].side;
                    boolean bl = mount.side = !mount.side;
                }
                if (mount.shoot && can && (!this.bullet.killShooter || mount.totalShots <= 0) && (!this.useAmmo || unit.ammo > 0.0f || !Vars.state.rules.unitAmmo || unit.team.rules().infiniteAmmo) && (!this.alternate || wasFlipped == this.flipSprite) && mount.warmup >= this.minWarmup && unit.vel.len() >= this.minShootVelocity && (mount.reload <= 1.0E-4f || this.alwaysContinuous && mount.bullet == null) && (this.alwaysShooting || Angles.within((float)(this.rotate ? mount.rotation : unit.rotation + this.baseRotation), (float)mount.targetRotation, (float)this.shootCone))) {
                    this.shoot(unit, mount, bulletX, bulletY, shootAngle);
                    mount.reload = this.reload;
                    if (this.useAmmo) {
                        unit.ammo -= 1.0f;
                        if (unit.ammo < 0.0f) {
                            unit.ammo = 0.0f;
                        }
                    }
                }
            }
        };
        multipleLauncher = new Weapon(NewHorizon.name("mult-launcher")){
            {
                this.reload = 60.0f;
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 3;
                        this.shotDelay = 8.0f;
                    }
                };
                this.shake = 3.0f;
                this.shootX = 2.0f;
                this.xRand = 5.0f;
                this.mirror = true;
                this.rotateSpeed = 2.5f;
                this.alternate = true;
                this.shootSound = NHSounds.launch;
                this.shootCone = 30.0f;
                this.shootY = 5.0f;
                this.top = true;
                this.rotate = true;
                this.bullet = new BasicBulletType(5.25f, 150.0f, NHBullets.STRIKE){
                    {
                        super(arg0, arg1, arg2);
                        this.lifetime = 60.0f;
                        this.knockback = 12.0f;
                        this.width = 11.0f;
                        this.height = 28.0f;
                        this.trailWidth = 2.2f;
                        this.trailLength = 20;
                        this.drawSize = 300.0f;
                        this.homingDelay = 5.0f;
                        this.homingPower = 0.0075f;
                        this.homingRange = 140.0f;
                        this.splashDamageRadius = 16.0f;
                        this.splashDamage = this.damage * 0.75f;
                        this.trailColor = this.hitColor = NHColor.lightSkyBack;
                        this.lightningColor = this.hitColor;
                        this.lightColor = this.hitColor;
                        this.backColor = this.hitColor;
                        this.frontColor = NHColor.lightSkyFront;
                        this.hitEffect = NHFx.circleSplash(this.backColor, 40.0f, 4, 40.0f, 6.0f);
                        this.despawnEffect = NHFx.hitSparkLarge;
                        this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                        this.smokeEffect = Fx.shootBigSmoke2;
                        this.trailChance = 0.6f;
                        this.trailEffect = NHFx.trailToGray;
                        this.hitShake = 3.0f;
                        this.hitSound = Sounds.beamPlasma;
                    }
                };
            }
        };
        posLiTurret = new Weapon(NewHorizon.name("pos-li-blaster")){
            {
                this.shake = 1.0f;
                this.shoot = new ShootPattern();
                this.rotate = false;
                this.predictTarget = false;
                this.alternate = true;
                this.top = true;
                this.reload = 45.0f;
                this.shootY = 4.0f;
                this.shootSound = NHSounds.laser3;
                this.heatColor = NHColor.lightSkyBack;
                this.bullet = new PosLightningType(20.0f){
                    {
                        super(damage);
                        this.lightningColor = NHColor.lightSkyBack;
                        this.maxRange = 180.0f;
                        this.hitEffect = NHFx.lightningHitSmall(this.lightningColor);
                        this.lightningLength = 1;
                        this.lightningLengthRand = 4;
                    }
                };
            }
        };
        closeAATurret = new Weapon(NewHorizon.name("anti-air-pulse-laser")){
            {
                this.shake = 0.0f;
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 2;
                        this.shotDelay = 6.0f;
                    }
                };
                this.top = true;
                this.rotate = true;
                this.heatColor = NHColor.lightSkyBack;
                this.shootSound = NHSounds.laser5;
                this.shootY = 3.0f;
                this.recoil = 2.0f;
                this.x = 9.5f;
                this.y = -7.0f;
                this.reload = 25.0f;
                this.autoTarget = true;
                this.predictTarget = false;
                this.controllable = false;
                BasicBulletType b = (BasicBulletType)NHBullets.basicSkyFrag;
                b.width *= 0.75f;
                b.height *= 0.75f;
                b.damage *= 0.75f;
                b.trailWidth *= 0.75f;
                this.bullet = b;
            }
        };
        smallCannon = new Weapon(NewHorizon.name("cannon")){
            {
                this.rotate = true;
                this.mirror = true;
                this.top = true;
                this.reload = 45.0f;
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 3;
                        this.shotDelay = 8.0f;
                    }
                };
                this.controllable = false;
                this.autoTarget = true;
                this.shake = 3.0f;
                this.inaccuracy = 4.0f;
                this.rotateSpeed = 2.5f;
                this.alternate = true;
                this.shootSound = NHSounds.scatter;
                this.shootCone = 15.0f;
                this.shootY = 5.0f;
                this.bullet = new BasicBulletType(5.0f, 20.0f){
                    {
                        super(arg0, arg1);
                        this.backColor = this.lightColor = NHColor.lightSkyBack;
                        this.lightningColor = this.lightColor;
                        this.trailColor = this.lightColor;
                        this.hitColor = this.lightColor;
                        this.frontColor = NHColor.lightSkyFront;
                        this.width = 8.0f;
                        this.height = 20.0f;
                        this.lifetime = 55.0f;
                        this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                        this.shootEffect = NHFx.shootLineSmall(this.backColor);
                        this.smokeEffect = Fx.shootSmallSmoke;
                        this.despawnEffect = NHFx.square(this.backColor, 15.0f, 2, 14.0f, 3.0f);
                    }
                };
            }
        };
    }

    private static void loadWeapon() {
        ancientPulseLaserSmall = new Weapon(NewHorizon.name("ancient-pulse-laser-small")){
            {
                this.reload = 12.0f;
                this.recoil = 1.0f;
                this.inaccuracy = 0.0f;
                this.shootSound = NHSounds.gauss;
                this.mirror = false;
                this.rotate = true;
                this.predictTarget = false;
                this.rotateSpeed = 2.55f;
                this.shootY += 6.0f;
                this.heatColor = NHColor.ancientHeat;
                this.bullet = new AdaptedSapBulletType(){
                    {
                        this.length = 320.0f;
                        this.damage = 50.0f;
                        this.sapStrength = 0.35f;
                        this.hitColor = this.color = NHColor.ancientLightMid;
                        this.lightColor = this.color;
                        this.width = 0.22f;
                        this.keepVelocity = false;
                        this.status = NHStatusEffects.intercepted;
                        this.statusDuration = 30.0f;
                    }
                };
            }
        };
        ancientPulseLaser = new Weapon(NewHorizon.name("ancient-pulse-laser")){
            {
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 24;
                        this.shotDelay = 2.0f;
                    }
                };
                this.heatColor = NHColor.ancientHeat;
                this.targetInterval = 30.0f;
                this.targetSwitchInterval = 240.0f;
                this.mirror = false;
                this.rotate = true;
                this.predictTarget = false;
                this.rotateSpeed = 1.75f;
                this.shootY = 10.0f;
                this.shootX = 2.5f;
                this.shake = 1.0f;
                this.shootSound = NHSounds.laser5;
                this.recoil = 1.0f;
                this.inaccuracy = 0.0f;
                this.xRand = 1.0f;
                this.reload = 390.0f;
                this.bullet = new RailBulletType(){
                    {
                        this.length = 320.0f;
                        this.damage = 160.0f;
                        this.hitColor = NHColor.ancientLightMid;
                        this.hitEffect = this.endEffect = Fx.hitBulletColor;
                        this.pierceDamageFactor = 0.4f;
                        this.status = NHStatusEffects.emp1;
                        this.statusDuration = 180.0f;
                        this.smokeEffect = Fx.colorSpark;
                        this.endEffect = new Effect(16.0f, e -> {
                            Draw.color((Color)e.color);
                            Drawf.tri((float)e.x, (float)e.y, (float)(e.fout() * 1.5f), (float)6.0f, (float)e.rotation);
                        });
                        this.shootEffect = new Effect(16.0f, e -> {
                            Draw.color((Color)e.color);
                            float w = 1.2f + 4.0f * e.fout();
                            Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(30.0f * e.fout()), (float)e.rotation);
                            Draw.color((Color)e.color);
                            for (int i : Mathf.signs) {
                                Drawf.tri((float)e.x, (float)e.y, (float)(w * 0.9f), (float)(22.0f * e.fout()), (float)(e.rotation + (float)i * 60.0f));
                            }
                            Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(4.0f * e.fout()), (float)(e.rotation + 180.0f));
                        });
                        this.lineEffect = new Effect(25.0f, e -> {
                            if (!(e.data instanceof Vec2)) {
                                return;
                            }
                            Vec2 v = (Vec2)e.data;
                            Draw.color((Color)e.color);
                            Lines.stroke((float)(e.fout() + 0.5f));
                            Fx.rand.setSeed((long)e.id);
                            for (int i = 0; i < 7; ++i) {
                                Fx.v.trns(e.rotation, Fx.rand.random(8.0f, v.dst(e.x, e.y) - 8.0f));
                                Lines.lineAngleCenter((float)(e.x + Fx.v.x), (float)(e.y + Fx.v.y), (float)(e.rotation + e.finpow()), (float)(e.foutpowdown() * 20.0f * Fx.rand.random(0.5f, 1.0f) + 0.3f));
                            }
                            e.scaled(16.0f, b -> {
                                Lines.stroke((float)(b.fout() * 1.5f));
                                Draw.color((Color)e.color);
                                Lines.line((float)e.x, (float)e.y, (float)v.x, (float)v.y);
                            });
                        });
                    }

                    public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
                        super.hitTile(b, build, x, y, initialHealth, direct);
                        build.applySlowdown(0.25f, 180.0f);
                    }
                };
            }

            protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
                super.shoot(unit, mount, shootX, shootY, rotation);
                mount.retarget = this.targetSwitchInterval;
            }
        };
        ancientPrism = new Weapon(NewHorizon.name("ancient-prism")){
            {
                this.shootSound = NHSounds.laser4;
                this.y = 0.0f;
                this.x = 0.0f;
                this.shootY = 3.0f;
                this.layerOffset = 0.005f;
                this.shootCone = 5.0f;
                this.rotateSpeed = 2.5f;
                this.rotate = true;
                this.mirror = false;
                this.predictTarget = false;
                this.reload = 240.0f;
                this.inaccuracy = 0.0f;
                this.recoil = 1.25f;
                this.shootWarmupSpeed /= 2.0f;
                this.minWarmup = 0.935f;
                this.cooldownTime = this.reload - 30.0f;
                this.parts.add((Object)new RegionPart("-barrel"){
                    {
                        super(arg0);
                        this.outline = true;
                        this.moveY = -4.0f;
                        this.heatLayerOffset = 0.0f;
                        this.heatLightOpacity = 0.4f;
                        this.progress = DrawPart.PartProgress.recoil;
                        this.heatColor = NHColor.ancientHeat;
                    }
                }, (Object)new RegionPart("-back"){
                    {
                        super(arg0);
                        this.outline = true;
                        this.heatLayerOffset = 0.0f;
                        this.heatLightOpacity = 0.4f;
                        this.heatColor = NHColor.ancientHeat;
                    }
                });
                this.bullet = new DelayedPointBulletType(){
                    {
                        this.width = 10.0f;
                        this.damage = 230.0f;
                        this.hitColor = NHColor.ancientLightMid;
                        this.lightningColor = this.trailColor = NHColor.ancientLightMid;
                        this.lightColor = this.trailColor;
                        this.rangeOverride = 320.0f;
                        this.trailEffect = Fx.none;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.despawnEffect = NHFx.square45_6_45;
                        shootStatus = NHStatusEffects.stronghold;
                        shootStatusDuration = 0.0f;
                        this.status = StatusEffects.melting;
                        this.statusDuration = 600.0f;
                        this.hitShake = 2.0f;
                        this.despawnShake = 2.0f;
                        this.collidesGround = true;
                        this.collidesAir = true;
                        this.fragBullets = 1;
                        this.fragBullet = new ChainBulletType(80.0f){
                            {
                                super(damage);
                                this.length = 0.0f;
                                this.collidesGround = true;
                                this.collidesAir = true;
                                this.quietShoot = true;
                                this.hitColor = NHColor.ancientLightMid;
                                this.lightningColor = this.trailColor = NHColor.lightSkyMiddle;
                                this.lightColor = this.trailColor;
                                this.thick = 7.0f;
                                this.maxHit = 3;
                                this.hitEffect = NHFx.lightningHitSmall;
                                this.effectController = (t, f) -> DelayedPointBulletType.laser.at(f.getX(), f.getY(), this.thick, this.hitColor, (Object)new Vec2().set(t));
                            }
                        };
                        this.shootEffect = EffectWrapper.wrap(NHFx.shootSquare(45.0f, 8, 4.0f, 45.0f, 40.0f, 25.0f), this.hitColor);
                        this.smokeEffect = EffectWrapper.wrap(NHFx.hugeSmokeLong, Color.gray);
                    }
                };
            }

            public void update(Unit unit, WeaponMount mount) {
                super.update(unit, mount);
            }
        };
        ancientLightningBallTurret = new Weapon(NewHorizon.name("pester-cannon")){
            {
                this.x = 56.0f;
                this.y = -48.0f;
                this.shootY = 18.0f;
                this.rotate = true;
                this.rotateSpeed = 1.4f;
                this.shoot = new ShootPattern();
                this.shootSound = NHSounds.thermo;
                this.recoil = 3.0f;
                this.reload = 90.0f;
                this.bullet = NHBullets.ancientBall;
            }
        };
        laugraTurret = new Weapon(NewHorizon.name("laugra-turret")){
            {
                this.y = 0.0f;
                this.x = 0.0f;
                this.rotate = true;
                this.rotateSpeed = 3.5f;
                this.alternate = false;
                this.mirror = false;
                this.layerOffset = 0.15f;
                this.shootWarmupSpeed /= 2.0f;
                this.minWarmup = 0.9f;
                this.recoil = 2.25f;
                this.shake = 8.0f;
                this.reload = 180.0f;
                this.shootY = 25.0f;
                this.cooldownTime = 45.0f;
                this.heatColor = NHColor.ancientHeat;
                this.shoot = new ShootAlternate(){
                    {
                        this.shots = 2;
                        this.shotDelay = 0.0f;
                        this.spread = 12.3f;
                    }
                };
                this.inaccuracy = 1.3f;
                this.shootSound = NHSounds.flak;
                this.bullet = NHBullets.laugraBullet;
                this.parts.add((Object)new RegionPart("-panel"){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.outline = true;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.moveX = -2.0f;
                        this.moveRot = -6.0f;
                        this.moveY = -2.0f;
                        this.progress = DrawPart.PartProgress.warmup;
                    }
                }, (Object)new RegionPart("-barrel"){
                    {
                        super(arg0);
                        this.outline = true;
                        this.under = true;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.moveY = -6.0f;
                        this.progress = DrawPart.PartProgress.recoil;
                    }
                }, (Object)new HaloPart(){
                    {
                        this.shapes = 1;
                        this.layer = 101.0f;
                        this.x = 0.0f;
                        this.y = -32.0f;
                        this.color = NHColor.ancient;
                        this.hollow = true;
                        this.sides = 4;
                        this.stroke = 0.0f;
                        this.strokeTo = 1.1f;
                        this.radiusTo = 6.0f;
                        this.rotateSpeed = 1.2f;
                        this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.reload, 0.3f);
                    }
                });
            }
        };
        BasicCannon = new Weapon(NewHorizon.name("basic-weapon")){
            {
                this.shoot = new ShootPattern();
                this.shootSound = NHSounds.rapidLaser;
                this.rotateSpeed = 12.0f;
                this.reload = 20.0f;
                this.shootY = 6.0f;
                this.shootX = -1.6f;
                this.rotate = true;
                this.mirror = true;
                this.top = true;
                this.bullet = new BasicBulletType(){
                    {
                        this.width = 8.0f;
                        this.height = 28.0f;
                        this.trailWidth = 1.0f;
                        this.trailLength = 7;
                        this.speed = 12.0f;
                        this.lifetime = 24.0f;
                        this.drag = 0.015f;
                        this.lightColor = this.lightningColor = NHColor.lightSkyBack;
                        this.backColor = this.lightningColor;
                        this.hitColor = this.lightningColor;
                        this.trailColor = this.lightningColor;
                        this.frontColor = NHColor.lightSkyFront;
                        this.damage = 25.0f;
                        this.smokeEffect = Fx.shootSmallSmoke;
                        this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                        this.despawnEffect = NHFx.circleSplash(this.backColor, 40.0f, 3, 18.0f, 4.0f);
                        this.hitEffect = NHFx.lightSkyCircleSplash;
                    }
                };
            }
        };
        laserCannon = new Weapon(NewHorizon.name("laser-cannon")){
            {
                this.rotate = true;
                this.autoTarget = true;
                this.top = true;
                this.alternate = false;
                this.mirror = false;
                this.x = 22.0f;
                this.y = -50.0f;
                this.reload = 70.0f;
                this.recoil = 1.75f;
                this.inaccuracy = 2.0f;
                this.shootY = 6.0f;
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 3;
                        this.shotDelay = 12.0f;
                    }
                };
                this.shake = 1.0f;
                this.rotateSpeed = 18.0f;
                this.shootSound = NHSounds.synchro;
                this.bullet = new BasicBulletType(3.8f, 50.0f){
                    {
                        super(arg0, arg1);
                        this.speed = 12.0f;
                        this.trailLength = 12;
                        this.trailWidth = 2.0f;
                        this.lifetime = 60.0f;
                        this.despawnEffect = NHFx.square45_4_45;
                        this.hitEffect = new Effect(45.0f, e -> {
                            Draw.color((Color)NHColor.lightSkyFront, (Color)NHColor.lightSkyBack, (float)e.fin());
                            Lines.stroke((float)(1.75f * e.fout()));
                            if (NHSetting.enableDetails()) {
                                Lines.spikes((float)e.x, (float)e.y, (float)(28.0f * e.finpow()), (float)(5.0f * e.fout() + 8.0f * e.fin(NHInterp.parabola4Reversed)), (int)4, (float)45.0f);
                            }
                            Lines.square((float)e.x, (float)e.y, (float)(14.0f * e.fin((Interp)Interp.pow3Out)), (float)45.0f);
                        });
                        this.knockback = 4.0f;
                        this.width = 15.0f;
                        this.height = 37.0f;
                        this.lightningDamage = this.damage * 0.65f;
                        this.trailColor = this.hitColor = NHColor.lightSkyBack;
                        this.lightningColor = this.hitColor;
                        this.lightColor = this.hitColor;
                        this.backColor = this.hitColor;
                        this.frontColor = NHColor.lightSkyFront;
                        this.lightning = 2;
                        this.lightningLengthRand = 3;
                        this.lightningLength = 3;
                        this.smokeEffect = Fx.shootBigSmoke2;
                        this.trailChance = 0.2f;
                        this.trailEffect = NHFx.skyTrail;
                        this.drag = 0.015f;
                        this.hitShake = 2.0f;
                        this.hitSound = Sounds.explosion;
                    }

                    public void hit(Bullet b) {
                        super.hit(b);
                        UltFire.createChance((Teamc)b, 12.0f, 0.05f);
                    }
                };
            }
        };
        collapserCannon = new Weapon(NewHorizon.name("collapser-cannon")){
            {
                this.mirror = true;
                this.alternate = true;
                this.rotate = true;
                this.top = true;
                this.reload = 60.0f;
                this.shake = 12.0f;
                this.heatColor = NHColor.thurmixRed;
                this.shootSound = NHSounds.laser4;
                this.shootY = 16.0f;
                this.inaccuracy = 0.0f;
                this.shoot = new ShootSpread(){
                    {
                        this.shots = 3;
                        this.shotDelay = 2.25f;
                        this.spread = 1.0f;
                    }
                };
                this.rotateSpeed = 2.0f;
                this.ejectEffect = NHFx.hugeSmoke;
                this.shootCone = 20.0f;
                this.bullet = new AdaptLaserBulletType(){
                    {
                        this.damage = 800.0f;
                        this.hitColor = NHColor.thurmixRed;
                        this.colors = new Color[]{this.hitColor.cpy().mul(1.0f, 1.0f, 1.0f, 0.45f), this.hitColor, NHColor.thurmixRedLight, Color.white};
                        this.length = 600.0f;
                        this.width = 14.0f;
                        this.lifetime = PosLightning.lifetime + 5.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lengthFalloff = 0.8f;
                        this.sideLength = 40.0f;
                        this.sideWidth = 0.5f;
                        this.sideAngle = 30.0f;
                        this.largeHit = true;
                        this.hitEffect = NHFx.instHit(this.hitColor, 2, 36.0f);
                        this.shootEffect = NHFx.square(this.hitColor, 15.0f, 2, 8.0f, 2.0f);
                    }
                };
            }
        };
    }

    public static void load() {
        NHUnitTypes.loadWeapon();
        NHUnitTypes.loadPreviousWeapon();
        liv = new NHUnitType("liv"){
            {
                this.outlineColor = OColor;
                this.itemCapacity = 150;
                this.payloadCapacity = 256.0f;
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.scannerDown});
                this.aiController = BuilderAI::new;
                this.fogRadius = 40.0f;
                this.outlineRadius = 4;
                this.lightRadius = 20.0f;
                this.lightOpacity = 0.1f;
                this.flying = true;
                this.health = 1000.0f;
                this.armor = 5.0f;
                this.hitSize = 18.0f;
                this.drag /= 5.0f;
                this.rotateSpeed = 4.5f;
                this.speed = 4.5f;
                this.accel = 0.5f;
                this.engineSize = 0.0f;
                this.engineColor = NHColor.lightSky;
                this.buildBeamOffset = 6.0f;
                this.buildSpeed = 3.0f;
                this.mineTier = 3;
                this.mineSpeed = 12.0f;
                this.engines.add((Object)new UnitType.UnitEngine(4.5f, -7.2f, 2.2f, -115.0f), (Object)new UnitType.UnitEngine(0.0f, -9.8f, 2.8f, -90.0f), (Object)new UnitType.UnitEngine(-4.5f, -7.2f, 2.2f, -65.0f));
                this.abilities.add((Object)new BoostAbility(false, 1.5f, 90.0f));
                this.weapons.add((Object)new Weapon(){
                    {
                        this.reload = 42.0f;
                        this.recoil = 1.5f;
                        this.inaccuracy = 5.0f;
                        this.shootSound = NHSounds.thermoShoot;
                        this.top = false;
                        this.alternate = true;
                        this.mirror = true;
                        this.rotate = false;
                        this.rotateSpeed = 2.55f;
                        this.heatColor = NHColor.lightSky;
                        this.shootCone = 30.0f;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 5;
                                this.shotDelay = 5.0f;
                            }
                        };
                        this.bullet = new BasicBulletType(4.5f, 20.0f){
                            {
                                super(arg0, arg1);
                                ejectEffect = Fx.none;
                                this.trailWidth = 1.5f;
                                this.trailLength = 15;
                                this.drawSize = 200.0f;
                                this.status = StatusEffects.shocked;
                                this.statusDuration = 30.0f;
                                this.lifetime = 40.0f;
                                this.homingPower = 0.1f;
                                this.homingRange = 120.0f;
                                this.width = 10.0f;
                                this.height = 25.0f;
                                this.keepVelocity = true;
                                this.knockback = 0.75f;
                                this.lightningColor = this.hitColor = NHColor.lightSkyBack;
                                this.lightColor = this.hitColor;
                                this.backColor = this.hitColor;
                                this.trailColor = this.hitColor;
                                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.45f);
                                this.trailChance = 0.1f;
                                this.trailParam = 1.0f;
                                this.trailEffect = NHFx.trailToGray;
                                this.despawnEffect = NHFx.square(this.backColor, 18.0f, 2, 12.0f, 2.0f);
                                this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                                this.shootEffect = NHFx.shootLineSmall(this.backColor);
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.buildingDamageMultiplier = 0.2f;
                            }
                        };
                    }
                });
                this.strafePenalty = 0.3f;
            }
        };
        macrophage = new AncientUnitType("macrophage"){
            {
                this.aiController = SurroundAI::new;
                this.constructor = EntityMapping.idMap[3];
                this.fogRadius = 40.0f;
                this.outlineRadius = 4;
                this.faceTarget = false;
                this.lightRadius = 20.0f;
                this.lightOpacity = 0.1f;
                this.flying = true;
                this.lowAltitude = true;
                this.health = 8000.0f;
                this.armor = 22.0f;
                this.hitSize = 36.0f;
                this.drag /= 5.0f;
                this.rotateSpeed = 1.4f;
                this.speed = 3.75f;
                this.accel = 0.16f;
                this.engineOffset = 15.0f;
                this.engineSize = -1.0f;
                this.strafePenalty = 0.3f;
                this.abilities.add((Object)new AdaptedHealAbility(200.0f, 1200.0f, this.hitSize * 2.0f, this.healColor).modify((Cons<AdaptedHealAbility>)((Cons)a -> {
                    a.selfHealReloadTime = 640.0f;
                    a.selfHealAmount /= 12.0f;
                })), (Object)new TurretShield(){
                    {
                        this.radius = hitSize + 16.0f;
                        this.angle = 130.0f;
                        this.regen = 7.0f;
                        this.cooldown = 600.0f;
                        this.max = 3000.0f;
                        this.width = 24.0f;
                        this.drawWidth = 12.0f;
                        this.whenShooting = true;
                        this.chanceDeflect = -1.0f;
                    }
                });
                this.addEngine(-1.5f, -22.75f, 0.0f, 5.0f, true);
                this.addEngine(-10.5f, -22.5f, 0.0f, 3.0f, true);
                this.addEngine(-5.25f, -22.75f, 0.0f, 4.0f, true);
                this.weapons.add((Object)NHUnitTypes.copyAndMove(ancientPulseLaser, -10.0f, -9.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(ancientPulseLaserSmall, 10.75f, -3.25f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(ancientPulseLaserSmall, 7.25f, -14.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMoveAnd(ancientPrism, 8.55f, -8.5f, (Cons<Weapon>)((Cons)w -> {
                    w.layerOffset = -1.0f;
                    w.reload += 60.0f;
                    w.rotateSpeed += 0.35f;
                })));
                this.targetFlags = new BlockFlag[]{BlockFlag.turret, BlockFlag.factory, BlockFlag.reactor, BlockFlag.generator, null, BlockFlag.core};
            }

            public void load() {
                super.load();
            }

            public void drawBody(Unit unit) {
                this.applyColor(unit);
                Draw.rect((TextureRegion)this.region, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
                Tmp.v1.trns(unit.rotation, Mathf.clamp((float)(unit.vel.len2() / (this.speed * this.speed / 3.0f))) * -4.0f);
                Draw.rect((TextureRegion)this.legRegion, (float)(unit.x + Tmp.v1.x), (float)(unit.y + Tmp.v1.y), (float)(unit.rotation - 90.0f));
                Draw.reset();
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        restrictionEnzyme = new AncientUnitType("restriction-enzyme"){
            {
                this.speed = 0.6f;
                this.drag = 0.1f;
                this.hitSize = 21.0f;
                this.rotateSpeed = 3.0f;
                this.health = 3200.0f;
                this.armor = 10.0f;
                this.fogRadius = 30.0f;
                this.stepShake = 0.75f;
                this.legCount = 4;
                this.legLength = 22.0f;
                this.legGroupSize = 2;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legExtension = -3.0f;
                this.legBaseOffset = 7.0f;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.925f;
                this.legForwardScl = 0.9075f;
                this.legMoveSpace = 1.085f;
                this.hovering = true;
                this.shadowElevation = 0.22f;
                this.groundLayer = 74.0f;
                this.faceTarget = false;
                this.abilities.add((Object)new AdaptedHealAbility(150.0f, 900.0f, this.hitSize * 1.5f, this.healColor).modify((Cons<AdaptedHealAbility>)((Cons)a -> {
                    a.selfHealReloadTime = 420.0f;
                    a.selfHealAmount /= 16.0f;
                })), (Object)new TurretShield(){
                    {
                        this.radius = hitSize - 4.0f;
                        this.angle = 120.0f;
                        this.regen = 5.0f;
                        this.cooldown = 600.0f;
                        this.max = 2000.0f;
                        this.width = 22.0f;
                        this.drawWidth = 11.0f;
                        this.whenShooting = true;
                        this.chanceDeflect = -1.0f;
                    }
                }, (Object)new ShockWaveAbility(150.0f, 80.0f, 60.0f, this.healColor).modify((Cons<ShockWaveAbility>)((Cons)a -> {
                    a.status(NHStatusEffects.emp1, Float.valueOf(45.0f));
                    a.maxSpeed = 0.1f;
                    a.boltNum = 0;
                    a.boltWidth = 1.0f;
                    a.shootSound = Sounds.explosionDull;
                })));
                this.weapons.add((Object)ancientPrism);
                this.parts.add((Object)new RegionPart("-sustainer-1"){
                    {
                        super(arg0);
                        this.layerOffset = -0.001f;
                        this.heatLayerOffset = 0.0f;
                        this.outline = true;
                        this.mirror = true;
                        this.under = true;
                        this.x = 6.5f;
                        this.y = -6.5f;
                        this.moveX = -7.25f;
                        this.moveY = 7.25f;
                        this.heatLightOpacity = 0.75f;
                        this.heatColor = Pal.techBlue;
                        this.progress = DrawPart.PartProgress.warmup;
                        this.heatProgress = DrawPart.PartProgress.warmup.compress(0.85f, 0.975f);
                    }
                });
                this.parts.add((Object)new RegionPart("-sustainer-2"){
                    {
                        super(arg0);
                        this.layerOffset = -0.001f;
                        this.heatLayerOffset = 0.0f;
                        this.outline = true;
                        this.mirror = true;
                        this.under = true;
                        this.x = 6.5f;
                        this.y = 6.5f;
                        this.moveX = -7.25f;
                        this.moveY = -7.25f;
                        this.heatLightOpacity = 0.75f;
                        this.heatColor = Pal.techBlue;
                        this.progress = DrawPart.PartProgress.warmup;
                        this.heatProgress = DrawPart.PartProgress.warmup.compress(0.85f, 0.975f);
                    }
                });
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        ancientProbe = new AncientUnitType("ancient-probe"){
            {
                this.aiController = ProbeAI::new;
                this.controller = u -> new ProbeAI();
                this.fogRadius = 60.0f;
                this.bounded = false;
                this.drawMinimap = false;
                this.faceTarget = true;
                this.lightRadius = 20.0f;
                this.lightOpacity = 0.1f;
                this.flying = true;
                this.health = 1500.0f;
                this.armor = 10.0f;
                this.hitSize = 16.0f;
                this.drag /= 3.0f;
                this.targetAir = false;
                this.targetGround = true;
                this.isEnemy = false;
                this.targetPriority = -3.0f;
                this.rotateSpeed = 1.7f;
                this.speed = 1.55f;
                this.accel = 0.34f;
                this.engineOffset = 14.0f;
                this.engineSize = -1.0f;
                this.parts.add((Object)new RegionPart("-antenna"){
                    {
                        super(arg0);
                        this.layerOffset = -0.05f;
                        this.outline = true;
                        this.moveRot = -45.0f;
                        this.x = 3.5f;
                        this.y = -4.5f;
                        this.moveY = 2.5f;
                        this.moveX = 1.0f;
                        this.progress = DrawPart.PartProgress.warmup.compress(0.35f, 0.65f);
                    }
                });
                this.parts.add((Object)new RegionPart("-antenna"){
                    {
                        super(arg0);
                        this.layerOffset = -0.05f;
                        this.outline = true;
                        this.x = 4.5f;
                        this.y = -2.5f;
                        this.moveY = 8.0f;
                        this.progress = DrawPart.PartProgress.warmup.compress(0.35f, 0.65f);
                    }
                });
                this.parts.add((Object)new RegionPart("-antenna"){
                    {
                        super(arg0);
                        this.layerOffset = -0.05f;
                        this.outline = true;
                        this.moveRot = 45.0f;
                        this.x = -5.0f;
                        this.y = -2.5f;
                        this.yScl = 0.5f;
                        this.growY = 0.5f;
                        this.progress = DrawPart.PartProgress.warmup.compress(0.35f, 0.65f);
                    }
                });
                this.parts.add((Object)new RegionPart("-antenna"){
                    {
                        super(arg0);
                        this.layerOffset = -0.05f;
                        this.outline = true;
                        this.x = -5.0f;
                        this.y = -2.5f;
                        this.yScl = 0.5f;
                        this.growY = 0.5f;
                        this.moveY = 7.0f;
                        this.progress = DrawPart.PartProgress.warmup.compress(0.35f, 0.65f);
                    }
                });
                this.targetFlags = new BlockFlag[]{BlockFlag.turret, BlockFlag.reactor, BlockFlag.generator, BlockFlag.factory, BlockFlag.core, null};
                float d = Mathf.random((int)2);
                this.engines.add((Object)new AncientEngine(-3.25f, -5.25f, 5.0f, -90.0f, d));
                this.engines.add((Object)new AncientEngine(2.5f, -5.5f, 5.0f, -90.0f, d));
                this.engines.add((Object)new AncientEngine(-3.25f, -5.0f, 7.0f, -90.0f).a(0.3f));
                this.engines.add((Object)new AncientEngine(2.5f, -5.0f, 7.0f, -90.0f).a(0.3f));
                this.weapons.add((Object)new Weapon(){
                    {
                        this.reload = 1.0E8f;
                        this.bullet = new BulletType(){
                            {
                                this.rangeOverride = 400.0f;
                            }
                        };
                        this.autoTarget = true;
                        this.controllable = false;
                        this.shootCone = 360.0f;
                        this.shootWarmupSpeed /= 3.0f;
                        targetAir = false;
                        targetGround = true;
                        this.rotate = false;
                    }

                    public void addStats(UnitType u, Table t) {
                        t.add((CharSequence)Core.bundle.get("scanner"));
                    }

                    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
                    }
                });
                this.weapons.add((Object)new PointDefenseWeapon(NewHorizon.name("pester-secondary-laser")){
                    {
                        super(arg0);
                        this.color = NHColor.ancientLightMid;
                        this.mirror = false;
                        this.rotate = true;
                        this.top = true;
                        this.x = -1.0f;
                        this.y = -4.75f;
                        this.reload = 6.0f;
                        this.targetInterval = 8.0f;
                        this.targetSwitchInterval = 8.0f;
                        this.rotateSpeed = 8.0f;
                        this.shootCone = 30.0f;
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = NHFx.shootLineSmall(color);
                                this.hitEffect = NHFx.lightningHitSmall;
                                this.hitColor = color;
                                this.maxRange = 360.0f;
                                this.damage = 150.0f;
                            }
                        };
                    }
                });
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        nucleoid = new AncientUnitType("nucleoid"){
            {
                float i;
                this.aiController = FlyingAI::new;
                this.createScorch = false;
                ++this.outlineRadius;
                this.fogRadius = 120.0f;
                this.engineOffset = 140.25f;
                this.engineSize = -1.0f;
                this.deathExplosionEffect = Fx.none;
                this.deathSound = NHSounds.jumpIn;
                this.crashDamageMultiplier = 0.0f;
                this.faceTarget = false;
                this.lowAltitude = true;
                this.itemCapacity = 500;
                this.health = 1000000.0f;
                this.speed = 0.175f;
                this.accel = 0.04f;
                this.drag = 0.035f;
                this.flying = true;
                this.hitSize = 200.0f;
                this.armor = 220.0f;
                this.rotateSpeed = 0.25f;
                this.buildSpeed = 20.0f;
                this.targetFlags = new BlockFlag[]{BlockFlag.turret, BlockFlag.core, null};
                this.engines.add((Object)new AncientEngine(-41.25f, -190.5f, 4.0f, -90.0f));
                this.engines.add((Object)new AncientEngine(-41.25f, -187.0f, 6.5f, -90.0f, 0.45f, 0.6f, 2.6f));
                this.engines.add((Object)new AncientEngine(64.0f, -170.0f, 7.0f, -90.0f));
                this.engines.add((Object)new AncientEngine(64.0f, -167.0f, 7.0f, -90.0f, 0.45f, 0.6f, 2.6f));
                final float o = Mathf.random((int)5);
                for (i = -18.0f; i < 34.0f; i += 2.0f) {
                    this.engines.add((Object)new AncientEngine(i, -190.5f, 4.0f, -90.0f, o));
                }
                i = -16.0f;
                while ((double)i <= 32.0) {
                    this.engines.add((Object)new AncientEngine(i, -187.0f, 6.5f, -90.0f, 0.335f, 0.8f, 2.6f){
                        {
                            super(x, y, radius, rotation, alphaBase, sizeSclPlus, sizeSclMin);
                            this.phaseOffset = o;
                        }
                    });
                    i += 6.0f;
                }
                this.abilities.add((Object)new AdaptedHealAbility(3000.0f, 180.0f, 220.0f, this.healColor).modify((Cons<AdaptedHealAbility>)((Cons)a -> {
                    a.selfHealReloadTime = 300.0f;
                })));
                this.abilities.add((Object)new Ability(){
                    {
                        this.display = false;
                    }

                    public void death(Unit unit) {
                        Effect.shake((float)(unit.hitSize / 10.0f), (float)(unit.hitSize / 8.0f), (float)unit.x, (float)unit.y);
                        NHFx.circleOut.at(unit.x, unit.y, unit.hitSize, unit.team.color);
                        NHFx.jumpTrailOut.at(unit.x, unit.y, unit.rotation, unit.team.color, (Object)unit.type);
                        NHSounds.jumpIn.at(unit.x, unit.y, 1.0f, 3.0f);
                    }
                });
                this.abilities.add((Object)new ShockWaveAbility(180.0f, 320.0f, 2000.0f, NHColor.ancientLightMid).status(StatusEffects.unmoving, Float.valueOf(300.0f), NHStatusEffects.scannerDown, Float.valueOf(300.0f), NHStatusEffects.emp3, Float.valueOf(300.0f), NHStatusEffects.entangled, Float.valueOf(300.0f), StatusEffects.disarmed, Float.valueOf(300.0f)).modify((Cons<ShockWaveAbility>)((Cons)a -> {
                    a.knockback = 400.0f;
                    a.shootEffect = new MultiEffect(new Effect[]{NHFx.circleOut, NHFx.hitSpark(a.hitColor, 55.0f, 40, a.range + 30.0f, 3.0f, 8.0f), NHFx.crossBlastArrow45, NHFx.smoothColorCircle(NHColor.ancientLightMid.cpy().a(0.3f), a.range, 60.0f)});
                })));
                Weapon cannon = new Weapon(NewHorizon.name("ancient-cannon")){
                    {
                        super(arg0);
                        this.mirror = false;
                        this.layerOffset = 0.01f;
                        this.rotate = true;
                        this.shootSound = Sounds.shootSmite;
                        this.reload = 90.0f;
                        this.rotateSpeed = 1.55f;
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.under = true;
                                this.layerOffset = -0.00175f;
                                this.moveY = -4.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                        this.shoot = new AdaptedShootHelix(){
                            {
                                this.shots = 3;
                                this.mag = 1.15f;
                                this.scl = 6.0f;
                                this.shotDelay = 15.0f;
                                this.offset = 75.398224f;
                            }
                        };
                        this.inaccuracy = 1.5f;
                        this.velocityRnd = 0.075f;
                        this.bullet = new AdaptBulletType(){
                            {
                                this.lifetime = 50.0f;
                                this.trailLength = 14;
                                this.trailWidth = 1.6f;
                                this.keepVelocity = true;
                                this.speed = 19.0f;
                                this.damage = 400.0f;
                                this.lightColor = this.lightningColor = NHColor.ancient;
                                this.backColor = this.lightningColor;
                                this.hitColor = this.lightningColor;
                                this.trailColor = NHColor.ancientLightMid;
                                this.frontColor = NHColor.ancientLight;
                                this.width = 9.0f;
                                this.height = 30.0f;
                                this.hitSound = Sounds.beamPlasma;
                                this.hitShake = 18.0f;
                                this.despawnShake = 18.0f;
                                this.pierceArmor = true;
                                this.pierceCap = 4;
                                this.smokeEffect = NHFx.hugeSmokeGray;
                                this.shootEffect = EffectWrapper.wrap(NHFx.shootLine(33.0f, 28.0f), this.hitColor);
                                this.despawnEffect = NHFx.square45_6_45;
                                this.hitEffect = new MultiEffect(new Effect[]{NHFx.hitSpark, NHFx.square45_4_45});
                            }
                        };
                    }
                };
                this.parts.add((Object)new RegionPart("-backwings"){
                    {
                        super(arg0);
                        this.outline = true;
                        this.layerOffset = -1.0f;
                        this.x = -41.5f;
                        this.y = -201.0f;
                    }
                }, (Object)new RegionPart("-backwings"){
                    {
                        super(arg0);
                        this.outline = true;
                        this.layerOffset = -1.0f;
                        this.x = 27.5f;
                        this.y = -201.0f;
                    }
                });
                Weapon pds = NHUnitTypes.copyAnd(ancientPrism, (Cons<Weapon>)((Cons)w -> {
                    w.shootStatus = StatusEffects.none;
                    w.reload = 90.0f;
                    w.bullet = w.bullet.copy();
                    if (w.bullet instanceof DelayedPointBulletType) {
                        DelayedPointBulletType b = (DelayedPointBulletType)w.bullet;
                        b.rangeOverride = 960.0f;
                        b.despawnEffect = EffectWrapper.wrap(NHFx.circle, b.hitColor, 40.0f);
                        b.damage = 2000.0f;
                        b.lightning = 2;
                        b.lightningDamage = b.damage;
                        b.lightningLengthRand = 6;
                        b.lightningLength = 6;
                        b.fragBullet = b.fragBullet.copy();
                        b.fragBullet.damage = 800.0f;
                    }
                }));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, -16.25f, 9.5f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, -56.5f, 52.5f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, 36.25f, -20.75f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, -69.5f, -137.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, -46.75f, -159.25f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, 36.75f, -166.25f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pds, 68.75f, -77.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(cannon, -46.75f, -15.5f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(cannon, -46.75f, -15.5f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(cannon, -20.25f, 168.5f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(cannon, 44.25f, -44.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMoveAnd(ancientLightningBallTurret, 5.5f, -168.0f, (Cons<Weapon>)((Cons)w -> {
                    w.mirror = false;
                    w.shoot.shotDelay = 12.0f;
                    w.shoot = w.shoot.copy();
                    w.shoot.shots = 3;
                    AccelBulletType Tbullet = (AccelBulletType)NHBullets.ancientBall.copy();
                    Tbullet.velocityBegin += 8.0f;
                    Tbullet.velocityIncrease -= 8.0f;
                    Tbullet.shootEffect = NHFx.blast(NHColor.ancient, 12.0f);
                    Tbullet.smokeEffect = NHFx.shootCircleSmall(NHColor.ancient);
                    Tbullet.fragBullets = 2;
                    w.bullet = Tbullet;
                })));
                this.weapons.add((Object)new Weapon(NewHorizon.name("ancient-executor")){
                    {
                        super(arg0);
                        this.x = 43.5f;
                        this.y = -109.75f;
                        this.mirror = false;
                        this.layerOffset = 0.15f;
                        this.rotate = true;
                        this.rotateSpeed = 0.75f;
                        this.reload = 90.0f;
                        this.inaccuracy = 1.5f;
                        this.velocityRnd = 0.075f;
                        this.shootSound = NHSounds.railGunBlast;
                        this.shoot = new ShootBarrel(){
                            {
                                this.shots = 2;
                                this.barrels = new float[]{-20.0f, 31.0f, 0.0f, 20.0f, 31.0f, 0.0f};
                            }
                        };
                        this.bullet = new AdaptBulletType(){
                            {
                                this.lifetime = 40.0f;
                                this.trailLength = 90;
                                this.trailWidth = 3.6f;
                                this.keepVelocity = true;
                                this.speed = 28.0f;
                                this.damage = 1000.0f;
                                this.removeAfterPierce = false;
                                this.lightColor = this.lightningColor = NHColor.ancient;
                                this.backColor = this.lightningColor;
                                this.hitColor = this.lightningColor;
                                this.trailColor = NHColor.ancientLightMid;
                                this.frontColor = NHColor.ancientLight;
                                this.width = 18.0f;
                                this.height = 60.0f;
                                this.homingPower = 0.01f;
                                this.homingRange = 300.0f;
                                this.homingDelay = 5.0f;
                                this.hitSound = Sounds.beamPlasma;
                                this.hitShake = 18.0f;
                                this.despawnShake = 18.0f;
                                this.status = NHStatusEffects.entangled;
                                this.statusDuration = 1200.0f;
                                this.pierceBuilding = true;
                                this.pierceArmor = true;
                                this.pierce = true;
                                this.lightning = 3;
                                this.lightningLength = 6;
                                this.lightningLengthRand = 18;
                                this.lightningDamage = 400.0f;
                                this.smokeEffect = EffectWrapper.wrap(NHFx.hitSparkHuge, this.hitColor);
                                this.shootEffect = NHFx.instShoot(this.backColor, this.frontColor);
                                this.despawnEffect = NHFx.lightningHitLarge;
                                this.hitEffect = new MultiEffect(new Effect[]{NHFx.hitSpark(this.backColor, 75.0f, 24, 90.0f, 2.0f, 12.0f), NHFx.square45_6_45, NHFx.lineCircleOut(this.backColor, 18.0f, 20.0f, 2.0f), NHFx.sharpBlast(this.backColor, this.frontColor, 120.0f, 40.0f)});
                            }

                            public void createFrags(Bullet b, float x, float y) {
                                super.createFrags(b, x, y);
                                Bullet bu = NHBullets.nuBlackHole.create(b, x, y, 0.0f);
                            }
                        };
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.outline = true;
                                this.moveY = -5.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                    }

                    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
                        return Units.bestTarget((Team)unit.team, (float)x, (float)y, (float)range, u -> u.checkTarget(air, ground), t -> ground, (Units.Sortf)UnitSorts.strongest);
                    }
                });
                this.weapons.add((Object)new Weapon(this.name + "-missile"){
                    {
                        super(arg0);
                        this.reload = 240.0f;
                        this.xRand = 10.0f;
                        this.shootY = 75.0f;
                        this.showStatSprite = false;
                        this.layerOffset = 0.002f;
                        this.shoot = new ShootMulti((ShootPattern)new ShootBarrel(){
                            {
                                this.shots = 3;
                                this.barrels = new float[]{-96.0f, 0.0f, 0.0f, -82.0f, 0.0f, 0.0f, -110.0f, 0.0f, 0.0f};
                            }
                        }, new ShootPattern[]{new ShootPattern(){
                            {
                                this.shots = 15;
                                this.shotDelay = 4.5f;
                            }
                        }});
                        this.velocityRnd = 0.05f;
                        this.shootSound = NHSounds.launch;
                        this.bullet = new AccelBulletType(9.2f, 500.0f){
                            {
                                super(speed, damage);
                                this.sprite = NHBullets.MISSILE_LARGE;
                                this.width = 6.0f;
                                this.height = 16.0f;
                                this.shrinkY = 0.0f;
                                this.accelerateBegin = 0.1f;
                                this.accelerateEnd = 0.6f;
                                this.velocityBegin = 3.0f;
                                this.velocityIncrease = 11.0f;
                                this.lightColor = this.lightningColor = NHColor.ancient;
                                this.hitColor = this.lightningColor;
                                this.backColor = this.lightningColor;
                                this.trailColor = Color.gray;
                                this.frontColor = NHColor.ancientLight;
                                this.homingPower = 0.08f;
                                this.homingDelay = 5.0f;
                                this.lifetime = 120.0f;
                                this.hitEffect = NHFx.instHit(this.backColor, 2, 30.0f);
                                this.despawnEffect = NHFx.shootCircleSmall(this.backColor);
                                this.lightning = 1;
                                this.lightningLengthRand = 12;
                                this.lightningLength = 3;
                                this.lightningDamage = 300.0f;
                                this.smokeEffect = Fx.shootPyraFlame;
                                this.shootEffect = NHFx.hugeSmokeGray;
                                if (NHSetting.enableDetails()) {
                                    this.trailColor = NHColor.trail;
                                    this.trailWidth = 2.0f;
                                    this.trailLength = 12;
                                }
                            }

                            public void updateHoming(Bullet b) {
                                if (b.time >= this.homingDelay) {
                                    Entityc entityc = b.owner;
                                    if (entityc instanceof Unit) {
                                        Unit u = (Unit)entityc;
                                        if (u.isPlayer()) {
                                            Player p = u.getPlayer();
                                            b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo(p.mouseX, p.mouseY), (float)(this.homingPower * Time.delta * 50.0f)));
                                        } else {
                                            super.updateHoming(b);
                                        }
                                    } else {
                                        super.updateHoming(b);
                                    }
                                }
                            }
                        };
                        this.minWarmup = 0.9f;
                        this.shootWarmupSpeed /= 3.0f;
                        this.shootCone = 360.0f;
                        this.baseRotation = 90.0f;
                        this.recoil = 2.0f;
                        this.rotate = false;
                        this.mirror = false;
                        this.parts.add((Object)new RegionPart("-cooler"){
                            {
                                super(arg0);
                                this.outline = true;
                                this.under = true;
                                this.rotation = -90.0f;
                                this.y = 49.5f;
                                this.x = -69.5f;
                                this.moveY = -7.0f;
                                this.progress = DrawPart.PartProgress.warmup;
                            }
                        }, (Object)new RegionPart("-silo"){
                            {
                                super(arg0);
                                this.outline = true;
                                this.under = true;
                                this.rotation = -90.0f;
                                this.y = 62.5f;
                                this.x = -78.75f;
                            }
                        });
                    }
                });
            }
        };
        laugra = new AncientUnitType("laugra"){
            {
                this.crushDamage = 20.0f;
                this.health = 22000.0f;
                this.armor = 45.0f;
                this.rotateSpeed = 3.0f;
                this.speed = 1.75f;
                this.squareShape = true;
                this.omniMovement = false;
                this.rotateMoveFirst = true;
                this.envDisabled = 0;
                this.hitSize = 50.0f;
                this.accel = 0.25f;
                this.treadRects = new Rect[]{new Rect(-85.0f, -104.0f, 28.0f, 208.0f)};
                this.hovering = true;
                this.hoverable = true;
                Weapon w = ancientSecTurret.copy();
                w.reload = 12.0f;
                w.bullet = new BasicBulletType(){
                    {
                        this.width = 9.0f;
                        this.height = 28.0f;
                        this.trailWidth = 1.3f;
                        this.trailLength = 7;
                        this.speed = 12.0f;
                        this.lifetime = 24.0f;
                        this.drag = 0.015f;
                        this.lightColor = this.lightningColor = NHColor.ancient;
                        this.backColor = this.lightningColor;
                        this.hitColor = this.lightningColor;
                        this.trailColor = this.lightningColor;
                        this.frontColor = Color.white;
                        this.damage = 60.0f;
                        this.smokeEffect = Fx.shootSmallSmoke;
                        this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                        this.despawnEffect = NHFx.square45_4_45;
                        this.hitEffect = NHFx.hitSpark;
                    }
                };
                this.abilities.add((Object)new GravityTrapAbility(240.0f), (Object)new AdaptedHealAbility(800.0f, 1200.0f, this.hitSize * 2.0f, this.healColor).modify((Cons<AdaptedHealAbility>)((Cons)a -> {
                    a.selfHealReloadTime = 640.0f;
                    a.selfHealAmount /= 12.0f;
                })));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(w, 18.5f, 11.0f), (Object)NHUnitTypes.copyAndMove(w, 18.5f, -13.0f));
                this.weapons.add((Object)laugraTurret);
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        pester = new AncientUnitType("pester"){
            {
                this.trailScl = 2.0f;
                this.fogRadius = 70.0f;
                ++this.outlineRadius;
                this.engineOffset = 45.25f;
                this.engineSize = -1.0f;
                this.abilities.add((Object)new MoveEffectAbility(){
                    {
                        this.minVelocity = 0.0f;
                        this.rotateEffect = false;
                        this.effectParam = engineSize;
                        this.parentizeEffects = true;
                        this.teamColor = true;
                        this.display = false;
                        this.y = -engineOffset;
                        this.effect = new Effect(33.0f, b -> {
                            Draw.color((Color)b.color);
                            Angles.randLenVectors((long)b.id, (int)((int)(b.rotation / 8.0f)), (float)(b.rotation / 5.0f + b.rotation * 2.0f * b.fin()), (x, y) -> Fill.circle((float)(b.x + x), (float)(b.y + y), (float)(b.fout() * b.rotation / 2.25f)));
                        });
                    }
                });
                this.abilities.add((Object)new ShieldArcAbility(){
                    {
                        this.radius = 160.0f;
                        this.angle = 270.0f;
                        this.regen = 50.0f;
                        this.cooldown = 600.0f;
                        this.max = 100000.0f;
                        this.width = 15.0f;
                        this.whenShooting = false;
                        this.chanceDeflect = -1.0f;
                    }
                }, (Object)new AdaptedHealAbility(1500.0f, 900.0f, this.hitSize * 2.0f, this.healColor).modify((Cons<AdaptedHealAbility>)((Cons)a -> {
                    a.selfHealReloadTime = 480.0f;
                    a.selfHealAmount /= 8.0f;
                })));
                class 1PestEngine
                extends UnitType.UnitEngine {
                    float triScl;

                    public 1PestEngine(float x, float y, float radius, float rotation, float triScl) {
                        super(x, y, radius, rotation);
                        this.triScl = 1.0f;
                        this.triScl = triScl;
                    }

                    public 1PestEngine(float x, float y, float radius, float rotation) {
                        super(x, y, radius, rotation);
                        this.triScl = 1.0f;
                    }

                    public void draw(Unit unit) {
                        float scale;
                        UnitType type = unit.type;
                        float f = scale = type.useEngineElevation ? unit.elevation : 1.0f;
                        if (scale <= 1.0E-4f) {
                            return;
                        }
                        float rot = unit.rotation - 90.0f;
                        Color color = unit.team.color;
                        Tmp.v1.set(this.x, this.y).rotate(rot).add((Position)unit);
                        float ex = Tmp.v1.x;
                        float ey = Tmp.v1.y;
                        Draw.color((Color)color);
                        Fill.circle((float)ex, (float)ey, (float)((this.radius + Mathf.absin((float)Time.time, (float)4.0f, (float)(this.radius / 4.0f))) * scale));
                        float ang = Time.time * 1.5f;
                        for (int i : Mathf.signs) {
                            DrawFunc.tri(ex, ey, this.radius / 3.0f * this.triScl, this.radius * 2.35f * this.triScl, ang + (float)(90 * i));
                        }
                        ang *= -1.5f;
                        for (int i : Mathf.signs) {
                            DrawFunc.tri(ex, ey, this.radius / 4.0f * this.triScl, this.radius * 1.85f * this.triScl, ang + (float)(90 * i));
                        }
                        Draw.color((Color)Color.white);
                        Fill.circle((float)ex, (float)ey, (float)((this.radius + Mathf.absin((float)Time.time, (float)4.0f, (float)(this.radius / 4.0f))) * 0.785f * scale));
                        Draw.color((Color)Color.black);
                        Fill.circle((float)ex, (float)ey, (float)((this.radius + Mathf.absin((float)Time.time, (float)4.0f, (float)(this.radius / 4.0f))) * 0.7f * scale));
                    }
                }
                this.engines.add((Object)new 1PestEngine(0.0f, -this.engineOffset, 16.0f, -90.0f));
                this.engines.add((Object)new 1PestEngine(0.0f, -115.0f, 6.0f, -90.0f, 0.3f));
                this.engines.add((Object)new AncientEngine(0.0f, -this.engineOffset, 16.0f, -90.0f){
                    {
                        super(x, y, radius, rotation);
                        this.forceZ = 114.0f;
                        this.alphaSclMin = 1.0f;
                        this.alphaBase = 1.0f;
                    }
                });
                this.engines.add((Object)new AncientEngine(0.0f, -115.0f, 8.0f, -90.0f, 0.3f){
                    {
                        super(x, y, radius, rotation, phaseOffset);
                        this.forceZ = 114.0f;
                        this.alphaSclMin = 1.0f;
                        this.alphaBase = 1.0f;
                    }
                });
                this.engineLayer = 110.005f;
                Weapon laser = new Weapon(this.name + "-laser"){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.rotateSpeed = 2.15f;
                        this.rotate = true;
                        this.parts.add((Object)new RegionPart("-shooter"){
                            {
                                super(arg0);
                                this.layerOffset = 0.05f;
                                this.moveY = 7.5f;
                                this.progress = DrawPart.PartProgress.warmup;
                            }
                        }, (Object)new RegionPart("-top"){
                            {
                                super(arg0);
                                this.layerOffset = 0.075f;
                                this.outline = false;
                            }
                        });
                        this.shootSound = NHSounds.laser5;
                        this.reload = 60.0f;
                        this.shootWarmupSpeed = 0.05f;
                        this.shoot = new AdaptedShootHelix(){
                            {
                                this.flip = true;
                                this.shots = 5;
                                this.mag = 1.15f;
                                this.scl = 6.0f;
                                this.shotDelay = 3.3f;
                                this.offset = 75.398224f;
                                this.firstShotDelay = 10.0f;
                            }
                        };
                        this.shootY = 9.0f;
                        this.velocityRnd = 0.075f;
                        this.bullet = NHBullets.ancientStd;
                    }
                };
                PointDefenseWeapon pdf = new PointDefenseWeapon(){
                    {
                        this.beamEffect = Fx.chainLightning;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -engineOffset;
                        this.reload = 5.0f;
                        this.targetInterval = 10.0f;
                        this.targetSwitchInterval = 8.0f;
                        this.shootSound = NHSounds.gauss;
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = Fx.none;
                                this.hitEffect = NHFx.lightningHitSmall;
                                this.maxRange = 320.0f;
                                this.damage = 200.0f;
                            }
                        };
                    }

                    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
                        if (!(mount.target instanceof Bullet)) {
                            return;
                        }
                        Bullet target = (Bullet)mount.target;
                        if (target.damage() > this.bullet.damage) {
                            target.damage(target.damage() - this.bullet.damage);
                        } else {
                            target.remove();
                        }
                        this.beamEffect.at(shootX, shootY, rotation, unit.team.color, (Object)new Vec2().set((Position)target));
                        this.bullet.shootEffect.at(shootX, shootY, rotation, unit.team.color);
                        this.bullet.hitEffect.at(target.x, target.y, 12.0f, unit.team.color);
                        this.shootSound.at(shootX, shootY, Mathf.random((float)0.9f, (float)1.1f));
                        mount.recoil = 1.0f;
                        mount.heat = 1.0f;
                    }
                };
                this.weapons.add((Object)NHUnitTypes.copyAndMove(laser, 34.5f, 1.25f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(laser, 30.0f, -74.5f));
                this.weapons.add((Object)ancientLightningBallTurret);
                this.weapons.add((Object)new Weapon(){
                    {
                        this.y = -engineOffset;
                        this.x = 0.0f;
                        this.shootSound = Sounds.beamLustre;
                        this.rotationLimit = 5.0f;
                        this.rotateSpeed = 0.75f;
                        this.rotate = true;
                        this.mirror = false;
                        this.continuous = true;
                        this.predictTarget = false;
                        this.reload = 480.0f;
                        this.shootCone = 5.0f;
                        this.bullet = new ContinuousLaserBulletType(){
                            {
                                this.length = 800.0f;
                                this.hitColor = this.lightColor = NHColor.ancient;
                                this.lightningColor = this.lightColor;
                                this.lifetime = 120.0f;
                                this.width = 8.0f;
                                this.status = NHStatusEffects.entangled;
                                this.statusDuration = 30.0f;
                                this.damage = 350.0f;
                                this.lightningDamage = 120.0f;
                                this.lightning = 2;
                                this.lightningLengthRand = 10;
                                this.lightningLength = 10;
                                this.hitEffect = NHFx.square45_8_45;
                                this.shootEffect = Fx.none;
                                this.smokeEffect = NHFx.hugeSmokeGray;
                                this.largeHit = true;
                                this.backLength += 12.0f;
                                this.frontLength += 20.0f;
                                this.colors = new Color[]{Color.white.cpy().a(0.0f), Color.white, Color.white};
                            }

                            public void init(Bullet b) {
                                super.init(b);
                                NHFx.lightningHitLarge.at(b.x, b.y, b.team.color);
                                Sounds.shootLaser.at((Position)b);
                            }

                            public void hit(Bullet b, float x, float y) {
                                Entityc entityc;
                                this.hitEffect.at(x, y, b.rotation(), b.team.color);
                                this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
                                Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
                                if (this.fragOnHit) {
                                    this.createFrags(b, x, y);
                                }
                                this.createPuddles(b, x, y);
                                this.createIncend(b, x, y);
                                this.createUnits(b, x, y);
                                if (this.suppressionRange > 0.0f) {
                                    Damage.applySuppression((Team)b.team, (float)b.x, (float)b.y, (float)this.suppressionRange, (float)this.suppressionDuration, (float)0.0f, (float)this.suppressionEffectChance, (Position)new Vec2(b.x, b.y));
                                }
                                this.createSplashDamage(b, x, y);
                                for (int i = 0; i < this.lightning; ++i) {
                                    Lightning.create((Bullet)b, (Color)b.team.color, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)x, (float)y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                                }
                                if (!Vars.headless && Mathf.chanceDelta((double)0.1)) {
                                    PosLightning.createEffect((Position)b, (Position)Tmp.v1.set(x, y), b.team.color, 1, 2.2f);
                                }
                                if ((entityc = b.owner) instanceof Healthc) {
                                    Healthc h = (Healthc)entityc;
                                    h.heal(80.0f);
                                }
                            }

                            public void applyDamage(Bullet b) {
                                Damage.collideLine((Bullet)b, (Team)b.team, (float)b.x, (float)b.y, (float)b.rotation(), (float)this.currentLength(b), (boolean)this.largeHit, (boolean)this.laserAbsorb, (int)this.pierceCap);
                            }

                            public void draw(Bullet b) {
                                float realLength = Damage.findLaserLength((Bullet)b, (float)this.length);
                                float fout = Mathf.clamp((float)(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f));
                                float baseLen = realLength * fout;
                                float rot = b.rotation();
                                for (int i = 0; i < this.colors.length; ++i) {
                                    Draw.color((Color)Tmp.c1.set(b.team.color).lerp(this.colors[i], (float)i / ((float)this.colors.length + 1.0f)).mul(1.0f + Mathf.absin((float)Time.time, (float)1.0f, (float)0.1f)));
                                    float colorFin = (float)i / (float)(this.colors.length - 1);
                                    float baseStroke = Mathf.lerp((float)this.strokeFrom, (float)this.strokeTo, (float)colorFin);
                                    float stroke = (this.width + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * fout * baseStroke;
                                    float ellipseLenScl = Mathf.lerp((float)(1.0f - (float)i / (float)this.colors.length), (float)1.0f, (float)this.pointyScaling);
                                    Lines.stroke((float)stroke);
                                    Lines.lineAngle((float)b.x, (float)b.y, (float)rot, (float)(baseLen - this.frontLength), (boolean)false);
                                    Drawf.flameFront((float)b.x, (float)b.y, (int)this.divisions, (float)(rot + 180.0f), (float)this.backLength, (float)(stroke / 2.0f));
                                    Tmp.v1.trnsExact(rot, baseLen - this.frontLength);
                                    Drawf.flameFront((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (int)this.divisions, (float)rot, (float)(this.frontLength * ellipseLenScl), (float)(stroke / 2.0f));
                                }
                                Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
                                Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)this.lightStroke, (Color)b.team.color, (float)0.7f);
                                Draw.reset();
                            }
                        };
                    }
                });
                this.weapons.add((Object)NHUnitTypes.copyAndMove(ancientSecTurret, 42.0f, 55.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(ancientSecTurret, 51.5f, -80.5f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(ancientSecTurret, 37.0f, -95.75f));
                this.weapons.add((Object)pdf);
                this.weapons.add((Object)pdf.copy());
                this.weapons.add((Object)pdf.copy());
                this.lowAltitude = true;
                this.itemCapacity = 500;
                this.health = 220000.0f;
                this.speed = 0.45f;
                this.accel = 0.04f;
                this.drag = 0.025f;
                this.flying = true;
                this.hitSize = 130.0f;
                this.armor = 150.0f;
                this.rotateSpeed = 0.35f;
                this.buildSpeed = 10.0f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        hurricane = new NHUnitType("hurricane"){
            {
                this.drawShields = false;
                this.outlineColor = OColor;
                ++this.outlineRadius;
                this.constructor = EntityMapping.map((int)3);
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 20.0f, -31.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 16.0f, -22.0f));
                this.weapons.add((Object)new Weapon(){
                    {
                        this.rotate = false;
                        this.mirror = true;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 8;
                                this.shotDelay = 10.0f;
                            }
                        };
                        this.reload = 150.0f;
                        this.x = 27.75f;
                        this.y = -4.0f;
                        this.shootSound = NHSounds.launch;
                        this.bullet = new TextureMissileType(200.0f, NewHorizon.name("ann-missile")){
                            {
                                super(damage, bulletSprite);
                                this.velocityBegin = 2.0f;
                                this.velocityIncrease = 12.0f;
                                this.accelInterp = Interp.pow2In;
                                this.lightningDamage = this.damage * 0.6f;
                                this.lightningLengthRand = 8;
                                this.lightningLength = 8;
                                this.splashDamage = this.damage;
                                this.scaledSplashDamage = true;
                                this.splashDamageRadius = 30.0f;
                                this.incendAmount = 2;
                                this.incendChance = 0.08f;
                                this.incendSpread = 24.0f;
                                this.makeFire = true;
                                this.lifetime = 70.0f;
                                this.trailEffect = NHFx.trailToGray;
                                this.trailParam = 3.0f;
                                this.trailChance = 0.3f;
                                this.trailLength = 18;
                                this.trailWidth = 1.6f;
                                this.homingPower = 0.075f;
                                this.homingRange = 200.0f;
                                this.homingDelay = 10.0f;
                                this.width = 5.0f;
                                this.height = 18.0f;
                                this.lightColor = this.lightningColor = NHColor.lightSkyBack;
                                this.hitColor = this.lightningColor;
                                this.backColor = this.lightningColor;
                                this.trailColor = this.lightningColor;
                                this.frontColor = NHColor.lightSkyFront;
                                this.smokeEffect = Fx.none;
                                this.shootEffect = Fx.none;
                                this.hitEffect = NHFx.blast(this.backColor, this.splashDamageRadius);
                                this.despawnEffect = NHFx.hitSparkLarge;
                                this.despawnShake = 3.0f;
                                this.hitShake = 3.0f;
                                this.despawnSound = this.hitSound = Sounds.explosion;
                            }
                        };
                    }
                }, (Object)new Weapon(){
                    {
                        this.predictTarget = false;
                        this.mirror = false;
                        this.rotate = true;
                        this.rotationLimit = 5.0f;
                        this.rotateSpeed = 0.5f;
                        this.continuous = true;
                        this.alternate = false;
                        this.shake = 5.0f;
                        this.shootY = 47.0f;
                        this.reload = 220.0f;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 1;
                            }
                        };
                        this.x = 0.0f;
                        this.y = 25.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 4.4f;
                        this.bullet = NHBullets.atomSeparator.copy();
                        this.bullet.lifetime = 300.0f;
                        this.bullet.damage = 200.0f;
                        this.bullet.shootEffect = NHFx.lightningHitLarge(NHColor.lightSkyBack);
                        ((ContinuousFlameBulletType)this.bullet).lengthInterp = NHInterp.laser;
                        this.shootSound = Sounds.beamPlasma;
                        this.shootStatus = StatusEffects.slow;
                        this.shootStatusDuration = this.bullet.lifetime + 40.0f;
                    }
                }, (Object)new Weapon(NewHorizon.name("swepter")){
                    {
                        super(arg0);
                        this.mirror = false;
                        this.top = true;
                        this.rotate = true;
                        this.rotationLimit = 240.0f;
                        this.alternate = false;
                        this.shake = 5.0f;
                        this.shootY = 17.0f;
                        this.reload = 300.0f;
                        this.rotateSpeed = 2.15f;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 1;
                            }
                        };
                        this.y = -40.0f;
                        this.x = 0.0f;
                        this.inaccuracy = 3.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 5.4f;
                        this.bullet = new LightningLinkerBulletType(2.5f, 250.0f){
                            {
                                super(speed, damage);
                                this.rangeOverride = 480.0f;
                                this.trailWidth = 8.0f;
                                this.trailLength = 40;
                                this.lightColor = this.lightningColor = NHColor.lightSkyBack;
                                this.trailColor = this.lightningColor;
                                this.backColor = this.lightningColor;
                                this.frontColor = Color.white;
                                this.randomGenerateRange = 280.0f;
                                this.randomLightningNum = 5;
                                this.linkRange = 280.0f;
                                this.scaleLife = true;
                                this.hittable = false;
                                this.hitModifier = UltFire::create;
                                this.size /= 1.5f;
                                this.drag = 0.0065f;
                                this.fragLifeMin = 0.125f;
                                this.fragLifeMax = 0.45f;
                                this.fragVelocityMax = 0.75f;
                                this.fragVelocityMin = 0.25f;
                                this.fragBullets = 13;
                                this.fragBullet = NHBullets.basicSkyFrag;
                                this.hitSound = Sounds.explosion;
                                this.drawSize = 40.0f;
                                this.splashDamageRadius = 240.0f;
                                this.splashDamage = 200.0f;
                                this.status = NHStatusEffects.ultFireBurn;
                                this.lifetime = 300.0f;
                                this.despawnEffect = Fx.none;
                                this.hitEffect = new Effect(50.0f, e -> {
                                    Draw.color((Color)NHColor.lightSkyBack);
                                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 44.0f));
                                    Lines.stroke((float)(e.fout() * 3.2f));
                                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 80.0f));
                                    Lines.stroke((float)(e.fout() * 2.5f));
                                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 50.0f));
                                    Angles.randLenVectors((long)e.id, (int)30, (float)(18.0f + 80.0f * e.fin()), (x, y) -> {
                                        Lines.stroke((float)(e.fout() * 3.2f));
                                        Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 14.0f + 5.0f));
                                    });
                                    Draw.color((Color)Color.white);
                                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 30.0f));
                                });
                                this.shootEffect = new Effect(30.0f, e -> {
                                    Draw.color((Color)NHColor.lightSkyBack);
                                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 32.0f));
                                    Draw.color((Color)Color.white);
                                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 20.0f));
                                });
                                this.smokeEffect = new Effect(40.0f, 100.0f, e -> {
                                    Draw.color((Color)NHColor.lightSkyBack);
                                    Lines.stroke((float)(e.fout() * 3.7f));
                                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 100.0f + 15.0f));
                                    Lines.stroke((float)(e.fout() * 2.5f));
                                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 60.0f + 15.0f));
                                    Angles.randLenVectors((long)e.id, (int)15, (float)(7.0f + 60.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(4.0f + e.fout() * 16.0f)));
                                });
                            }

                            @Override
                            public void despawned(Bullet b) {
                                super.despawned(b);
                                UltFire.createChance((Teamc)b, this.splashDamageRadius / 2.0f, 0.5f);
                            }
                        };
                        this.shootSound = Sounds.shootLaser;
                    }
                }, (Object)new Weapon(NewHorizon.name("impulse")){
                    {
                        super(arg0);
                        this.heatColor = NHColor.lightSkyBack;
                        this.top = true;
                        this.rotate = true;
                        this.shootY = 8.0f;
                        this.reload = 50.0f;
                        this.x = 40.0f;
                        this.y = -30.0f;
                        this.rotateSpeed = 6.0f;
                        this.inaccuracy = 6.0f;
                        this.velocityRnd = 0.38f;
                        this.alternate = false;
                        this.ejectEffect = Fx.none;
                        this.recoil = 1.7f;
                        this.shootSound = Sounds.beamPlasma;
                        this.bullet = new ChainBulletType(400.0f){
                            {
                                super(damage);
                                this.length = 360.0f;
                                this.status = StatusEffects.shocked;
                                this.lightColor = this.lightningColor = NHColor.lightSkyBack;
                                this.hitColor = this.lightningColor;
                                this.shootEffect = NHFx.hitSparkLarge;
                                this.hitEffect = NHFx.lightningHitSmall;
                                this.smokeEffect = NHFx.hugeSmokeGray;
                            }
                        };
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 3;
                                this.shotDelay = 15.0f;
                            }
                        };
                    }
                });
                for (int i : Mathf.signs) {
                    this.engines.add((Object)new UnitType.UnitEngine((float)i * 44.25f, -49.0f, 7.0f, (float)(-90 + 8 * i)));
                }
                this.abilities.add((Object)new RepairFieldAbility(4000.0f, 160.0f, 240.0f){
                    {
                        super(arg0, arg1, arg2);
                        this.healEffect = NHFx.healEffectSky;
                        this.activeEffect = NHFx.activeEffectSky;
                    }
                });
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.weak, NHStatusEffects.emp2, NHStatusEffects.emp3, NHStatusEffects.emp1, NHStatusEffects.scrambler, NHStatusEffects.scannerDown, NHStatusEffects.ultFireBurn, StatusEffects.melting, StatusEffects.burning, StatusEffects.shocked, StatusEffects.electrified});
                this.lowAltitude = true;
                this.itemCapacity = 500;
                this.health = 72000.0f;
                this.speed = 1.0f;
                this.accel = 0.04f;
                this.drag = 0.025f;
                this.flying = true;
                this.hitSize = 100.0f;
                this.armor = 60.0f;
                this.engineOffset = 60.0f;
                this.engineSize = 20.0f;
                this.rotateSpeed = 0.75f;
                this.buildSpeed = 2.8f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        assaulter = new NHUnitType("assaulter"){
            {
                this.constructor = EntityMapping.map((int)3);
                this.itemCapacity = 10;
                this.hitSize = 16.0f;
                this.armor = 8.0f;
                this.health = 220.0f;
                this.speed = 3.0f;
                this.rotateSpeed = 2.75f;
                this.accel = 0.075f;
                this.drag = 0.035f;
                this.flying = true;
                this.engineOffset = 12.0f;
                this.engineSize = 3.0f;
                this.buildSpeed = 0.0f;
                this.abilities.add((Object)new BoostAbility(false, 1.5f, 15.0f));
                this.maxRange = 148.0f;
                this.range = 148.0f;
                this.targetFlags = new BlockFlag[]{BlockFlag.turret, BlockFlag.factory, BlockFlag.reactor, BlockFlag.generator, BlockFlag.core, null};
                this.weapons.add((Object)new Weapon(){
                    {
                        this.reload = 155.0f;
                        this.shoot = new ShootPattern(){
                            {
                                this.firstShotDelay = 120.0f;
                            }
                        };
                        this.shootStatus = NHStatusEffects.stronghold;
                        this.shootStatusDuration = 680.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.shootY = 15.0f;
                        this.parentizeEffects = true;
                        this.continuous = true;
                        this.alternate = false;
                        this.mirror = false;
                        this.shootCone = 5.0f;
                        this.chargeSound = Sounds.chargeCorvus;
                        this.shootSound = Sounds.shootLaser;
                        this.bullet = new LaserBulletType(200.0f){
                            {
                                super(arg0);
                                this.chargeEffect = new Effect(120.0f, e -> {
                                    Draw.color((Color)NHColor.thurmixRed);
                                    float p = NHInterp.upThenFastDown.apply(e.fin());
                                    Lines.stroke((float)(p * 2.0f));
                                    Lines.circle((float)e.x, (float)e.y, (float)(45.0f * p));
                                    Lines.spikes((float)e.x, (float)e.y, (float)((65.0f - e.fin() * 45.0f) * p), (float)((e.fin() * 26.0f + 3.0f) * p), (int)4, (float)(45.0f + e.rotation));
                                    Lines.stroke((float)(e.finpow() * 3.0f));
                                    Lines.circle((float)e.x, (float)e.y, (float)(72.0f * e.fout((Interp)Interp.pow5Out)));
                                    Fill.circle((float)e.x, (float)e.y, (float)(6.0f * e.fin()));
                                    Draw.color((Color)NHColor.thurmixRedLight);
                                    Fill.circle((float)e.x, (float)e.y, (float)(3.5f * e.fin()));
                                }).followParent(true);
                                this.colors = new Color[]{NHColor.thurmixRed.cpy().mul(1.0f, 1.0f, 1.0f, 0.3f), NHColor.thurmixRed, Color.white};
                                this.length = 180.0f;
                                this.width = 18.0f;
                                this.lengthFalloff = 0.6f;
                                this.sideLength = 90.0f;
                                this.sideWidth = 1.35f;
                                this.sideAngle = 40.0f;
                                this.lightningSpacing = 40.0f;
                                this.lightningLength = 2;
                                this.lightningDelay = 1.1f;
                                this.lightningLengthRand = 10;
                                this.lightningDamage = this.damage / 5.0f;
                                this.lightningAngleRand = 40.0f;
                                this.hitColor = this.lightningColor = NHColor.thurmixRed;
                                this.smokeEffect = this.shootEffect = Fx.none;
                                this.hitEffect = NHFx.laserHit(NHColor.thurmixRed);
                                this.lifetime = 30.0f;
                                this.status = NHStatusEffects.weak;
                                this.statusDuration = 60.0f;
                                this.killShooter = true;
                                this.keepVelocity = false;
                            }

                            public void init(Bullet b) {
                                super.init(b);
                                if (this.killShooter && b.owner() instanceof Healthc) {
                                    ((Healthc)b.owner()).kill();
                                }
                            }
                        };
                    }
                });
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        rhino = new NHUnitType("rhino"){
            {
                this.outlineColor = OColor;
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.ultFireBurn, NHStatusEffects.emp1, NHStatusEffects.emp2, StatusEffects.shocked, StatusEffects.burning, StatusEffects.melting, StatusEffects.electrified, StatusEffects.wet, StatusEffects.slow, StatusEffects.blasted});
                this.aiController = BuilderAI::new;
                this.defaultCommand = UnitCommand.rebuildCommand;
                this.constructor = EntityMapping.map((int)3);
                this.abilities.add((Object)new BoostAbility());
                this.weapons.add((Object)new RepairBeamWeapon("point-defense-mount"){
                    {
                        super(arg0);
                        this.y = -8.5f;
                        this.x = 0.0f;
                        this.shootY = 4.0f;
                        this.mirror = false;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 1.0f;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 120.0f;
                            }
                        };
                    }
                });
                this.armor = 12.0f;
                this.buildBeamOffset = 6.0f;
                this.buildSpeed = 5.0f;
                this.hitSize = 20.0f;
                this.flying = true;
                this.drag = 0.06f;
                this.accel = 0.12f;
                this.itemCapacity = 200;
                this.speed = 1.0f;
                this.health = 3000.0f;
                this.engineSize = 3.4f;
                this.engineOffset = 10.5f;
                this.isEnemy = false;
                this.lowAltitude = true;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        naxos = new NHUnitType("naxos"){
            {
                this.outlineColor = OColor;
                this.constructor = EntityMapping.map((int)3);
                this.health = 8500.0f;
                this.speed = 3.0f;
                this.accel = 0.75f;
                this.drag = 0.015f;
                this.flying = true;
                this.targetAir = true;
                this.targetGround = false;
                this.circleTarget = true;
                this.hitSize = 16.0f;
                this.armor = 40.0f;
                this.engineOffset = 12.5f;
                this.engineSize = 5.0f;
                this.rotateSpeed = 4.75f;
                this.lowAltitude = false;
                this.aiController = InterceptorAI::new;
                for (int i : Mathf.signs) {
                    this.engines.add((Object)new UnitType.UnitEngine((float)i * 14.25f, -14.5f, 3.0f, (float)(-90 + i * 15)));
                }
                this.abilities.add((Object)new BoostAbility(2.25f, 160.0f));
                this.weapons.add((Object)new Weapon(NewHorizon.name("impulse-side")){
                    {
                        super(arg0);
                        this.alternate = true;
                        this.mirror = true;
                        this.rotate = false;
                        this.top = false;
                        this.reload = 45.0f;
                        this.inaccuracy = 5.0f;
                        this.x = -10.5f;
                        this.y = -2.0f;
                        this.shootY = 6.0f;
                        this.shootX = 1.0f;
                        this.shootCone = 30.0f;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 3;
                                this.shotDelay = 8.0f;
                            }
                        };
                        this.shootSound = NHSounds.laser5;
                        this.bullet = new AdaptBulletType(){
                            {
                                this.trailLength = 20;
                                this.trailWidth = 2.5f;
                                this.backColor = this.hitColor = NHColor.lightSkyBack;
                                this.lightningColor = this.hitColor;
                                this.lightColor = this.hitColor;
                                this.trailColor = this.hitColor;
                                this.frontColor = NHColor.lightSkyFront;
                                this.speed = 7.0f;
                                this.damage = 200.0f;
                                this.sprite = "missile-large";
                                this.width = 10.0f;
                                this.height = 30.0f;
                                this.weaveScale = 7.0f;
                                this.weaveMag = 0.8f;
                                this.homingDelay = 8.0f;
                                this.homingPower = 0.7f;
                                this.homingRange = 200.0f;
                                this.splashDamageRadius = 60.0f;
                                this.splashDamage = this.damage / 2.0f;
                                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                                this.smokeEffect = Fx.shootBigSmoke;
                                this.hitEffect = NHFx.blast(this.backColor, this.splashDamageRadius);
                                this.despawnEffect = NHFx.hitSparkLarge;
                                this.hitShake = 5.0f;
                                this.despawnShake = 5.0f;
                                this.collides = true;
                                this.collidesAir = true;
                                this.collidesTiles = false;
                                this.collidesGround = false;
                            }
                        };
                    }
                }, (Object)new Weapon(){
                    {
                        this.reload = 180.0f;
                        this.shootSound = Sounds.beamPlasma;
                        this.x = 0.0f;
                        this.continuous = true;
                        this.mirror = false;
                        this.rotate = false;
                        this.alternate = false;
                        this.top = false;
                        this.minShootVelocity = 2.0f;
                        this.shootStatus = NHStatusEffects.invincible;
                        this.shootStatusDuration = 360.0f;
                        this.bullet = new BulletType(){
                            {
                                this.impact = true;
                                this.keepVelocity = false;
                                this.collides = false;
                                this.pierce = true;
                                this.hittable = false;
                                this.absorbable = false;
                                this.pierceArmor = true;
                                this.collidesAir = true;
                                this.collidesTiles = false;
                                this.collidesGround = false;
                                this.damage = 100.0f;
                                this.lightning = 1;
                                this.lightningDamage = this.damage / 4.0f;
                                this.lightningLength = 10;
                                this.lightningLengthRand = 15;
                                this.knockback = 30.0f;
                                this.lifetime = 360.0f;
                                this.status = StatusEffects.melting;
                                this.statusDuration = 60.0f;
                                this.maxRange = 80.0f;
                                this.speed = 1.0E-4f;
                                this.trailColor = this.hitColor = NHColor.lightSkyBack;
                                this.lightningColor = this.hitColor;
                                this.lightColor = this.hitColor;
                                this.hitEffect = NHFx.square(this.hitColor, 30.0f, 3, 80.0f, 5.0f);
                                this.despawnEffect = Fx.none;
                                this.shootEffect = NHFx.instShoot(this.hitColor, NHColor.lightSkyFront);
                                this.smokeEffect = NHFx.square(this.hitColor, 45.0f, 5, 60.0f, 5.0f);
                            }

                            public float continuousDamage() {
                                return this.damage / 5.0f * 60.0f;
                            }

                            public float estimateDPS() {
                                return this.damage * 100.0f / 5.0f * 3.0f;
                            }

                            public void hit(Bullet b, float x, float y) {
                                super.hit(b, x, y);
                                if (b.owner instanceof Healthc) {
                                    ((Healthc)b.owner).heal(b.damage / 3.0f);
                                }
                            }

                            public void update(Bullet b) {
                                if (b.timer(1, 5.0f)) {
                                    Damage.collideLine((Bullet)b, (Team)b.team, (float)b.x, (float)b.y, (float)b.rotation(), (float)this.maxRange, (boolean)true, (boolean)false);
                                }
                                if (shake > 0.0f) {
                                    Effect.shake((float)shake, (float)shake, (Position)b);
                                }
                            }

                            public void draw(Bullet b) {
                                float f = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.015f) * Mathf.curve((float)b.fout(), (float)0.0f, (float)0.025f);
                                float sine = 1.0f + Mathf.absin((float)0.7f, (float)0.075f);
                                float stroke = 6.0f;
                                float offset = 8.0f;
                                float rot = b.rotation();
                                Draw.color((Color)this.hitColor);
                                Tmp.v1.trns(rot, 0.0f, stroke).scl(f * sine);
                                Tmp.v2.trns(rot, 0.0f, stroke + stroke).scl(f * sine);
                                Tmp.v3.trns(rot, this.maxRange).scl(f);
                                for (int i : Mathf.signs) {
                                    Fill.tri((float)(b.x + Tmp.v1.x * (float)i), (float)(b.y + Tmp.v1.y * (float)i), (float)(b.x + Tmp.v2.x * (float)i), (float)(b.y + Tmp.v2.y * (float)i), (float)(b.x + Tmp.v3.x), (float)(b.y + Tmp.v3.y));
                                }
                                Draw.reset();
                            }
                        };
                    }
                });
                this.targetFlags = new BlockFlag[]{null};
                this.buildBeamOffset = 15.0f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        annihilation = new NHUnitType("annihilation"){
            {
                this.outlineColor = OColor;
                this.drawShields = false;
                this.weapons.add((Object)new Weapon(NewHorizon.name("large-launcher")){
                    {
                        super(arg0);
                        this.top = false;
                        this.rotate = false;
                        this.alternate = true;
                        this.shake = 3.5f;
                        this.shootY = 16.0f;
                        this.x = 20.0f;
                        this.recoil = 5.4f;
                        this.predictTarget = false;
                        this.shootCone = 30.0f;
                        this.reload = 40.0f;
                        this.shoot = new ShootSpread(){
                            {
                                this.spread = 10.0f;
                                this.shots = 4;
                                shootCone = 30.0f;
                            }
                        };
                        this.inaccuracy = 4.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = new ShrapnelBulletType(){
                            {
                                this.width -= 2.0f;
                                this.hitLarge = true;
                                this.length = 200.0f;
                                this.damage = 300.0f;
                                this.status = NHStatusEffects.ultFireBurn;
                                this.statusDuration = 120.0f;
                                this.fromColor = NHColor.lightSkyFront;
                                this.toColor = NHColor.lightSkyBack;
                                this.shootEffect = NHFx.lightningHitSmall(NHColor.lightSkyBack);
                                this.smokeEffect = new MultiEffect(new Effect[]{NHFx.lightSkyCircleSplash, new Effect(this.lifetime + 10.0f, b -> {
                                    Draw.color((Color)this.fromColor, (Color)this.toColor, (float)b.fin());
                                    Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.75f * b.fout()));
                                })});
                            }
                        };
                        this.shootSound = Sounds.shoot;
                    }
                }, (Object)new Weapon(NewHorizon.name("large-launcher")){
                    {
                        super(arg0);
                        this.top = false;
                        this.rotate = false;
                        this.alternate = true;
                        this.shake = 3.5f;
                        this.shootY = 16.0f;
                        this.x = 20.0f;
                        this.recoil = 5.4f;
                        this.predictTarget = false;
                        this.shootCone = 30.0f;
                        this.reload = 40.0f;
                        this.shoot = new ShootSpread(){
                            {
                                this.spread = 60.0f;
                                this.shots = 2;
                                shootCone = 60.0f;
                                this.firstShotDelay = 10.0f;
                            }
                        };
                        this.inaccuracy = 4.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = new ShrapnelBulletType(){
                            {
                                this.width -= 2.0f;
                                this.hitLarge = true;
                                this.length = 80.0f;
                                this.damage = 100.0f;
                                this.status = NHStatusEffects.ultFireBurn;
                                this.statusDuration = 120.0f;
                                this.fromColor = NHColor.lightSkyFront;
                                this.toColor = NHColor.lightSkyBack;
                                this.shootEffect = NHFx.lightningHitSmall(NHColor.lightSkyBack);
                                this.smokeEffect = new MultiEffect(new Effect[]{NHFx.lightSkyCircleSplash, new Effect(this.lifetime + 10.0f, b -> {
                                    Draw.color((Color)this.fromColor, (Color)this.toColor, (float)b.fin());
                                    Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.75f * b.fout()));
                                })});
                            }
                        };
                        this.shootSound = Sounds.shoot;
                    }
                }, (Object)new Weapon(){
                    {
                        this.mirror = false;
                        this.rotate = true;
                        this.alternate = true;
                        this.rotateSpeed = 25.0f;
                        this.x = 0.0f;
                        this.y = 8.0f;
                        this.recoil = 2.7f;
                        this.shootY = 7.0f;
                        this.shootCone = 40.0f;
                        this.reload = 180.0f;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 8;
                                this.shotDelay = 16.0f;
                            }
                        };
                        this.inaccuracy = 5.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = NHBullets.annMissile;
                        this.shootSound = NHSounds.launch;
                    }
                });
                this.abilities.add((Object)new ForceFieldAbility(120.0f, 2.0f, 10000.0f, 800.0f, 4, 0.0f));
                this.engineOffset = 15.0f;
                this.engineSize = 6.5f;
                this.speed = 0.275f;
                this.hitSize = 33.0f;
                this.health = 22000.0f;
                this.buildSpeed = 2.8f;
                this.armor = 25.0f;
                this.rotateSpeed = 1.8f;
                this.singleTarget = false;
                this.fallSpeed = 0.016f;
                this.mechStepParticles = true;
                this.stepShake = 0.5f;
                this.canBoost = true;
                this.mechLandShake = 6.0f;
                this.boostMultiplier = 3.5f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
                NHPixmap.outlineLegs(packer, this);
            }
        };
        sharp = new NHUnitType("sharp"){
            {
                this.outlineColor = OColor;
                this.constructor = EntityMapping.map((int)3);
                this.itemCapacity = 15;
                this.health = 140.0f;
                this.armor = 1.0f;
                this.engineOffset = 10.0f;
                this.engineSize = 2.8f;
                this.speed = 1.5f;
                this.flying = true;
                this.accel = 0.08f;
                this.drag = 0.02f;
                this.baseRotateSpeed = 1.5f;
                this.rotateSpeed = 2.5f;
                this.hitSize = 10.0f;
                this.singleTarget = true;
                this.weapons.add((Object)new Weapon(){
                    {
                        this.top = false;
                        this.rotate = false;
                        this.alternate = false;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.reload = 45.0f;
                        this.shoot = new ShootHelix(){
                            {
                                this.shots = 4;
                                this.shotDelay = 5.0f;
                            }
                        };
                        this.inaccuracy = 5.0f;
                        this.ejectEffect = Fx.none;
                        this.velocityRnd = 0.125f;
                        this.shake = 2.0f;
                        maxRange = 140.0f;
                        this.bullet = new BasicBulletType(3.5f, 6.0f){
                            {
                                super(arg0, arg1);
                                this.trailWidth = 1.0f;
                                this.trailLength = 10;
                                this.drawSize = 200.0f;
                                this.homingPower = 0.1f;
                                this.homingRange = 120.0f;
                                this.width = 5.0f;
                                this.height = 25.0f;
                                this.keepVelocity = true;
                                this.knockback = 0.75f;
                                this.lightningColor = this.hitColor = NHColor.lightSkyBack;
                                this.lightColor = this.hitColor;
                                this.backColor = this.hitColor;
                                this.trailColor = this.hitColor;
                                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.45f);
                                this.trailChance = 0.1f;
                                this.trailParam = 1.0f;
                                this.trailEffect = NHFx.trailToGray;
                                this.despawnEffect = NHFx.square(this.backColor, 18.0f, 2, 12.0f, 2.0f);
                                this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                                this.shootEffect = NHFx.shootLineSmall(this.backColor);
                                this.smokeEffect = Fx.shootBigSmoke2;
                            }
                        };
                        this.shootSound = NHSounds.thermoShoot;
                    }
                });
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        branch = new NHUnitType("branch"){
            {
                this.outlineColor = OColor;
                this.constructor = EntityMapping.map((int)3);
                this.weapons.add((Object)new Weapon(){
                    {
                        this.top = false;
                        this.rotate = true;
                        this.alternate = true;
                        this.mirror = false;
                        this.shoot = new ShootPattern(){
                            {
                                this.shotDelay = 3.0f;
                                this.shots = 5;
                            }
                        };
                        this.x = 0.0f;
                        this.y = -10.0f;
                        this.reload = 45.0f;
                        this.inaccuracy = 4.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = new FlakBulletType(2.55f, 15.0f){
                            {
                                super(arg0, arg1);
                                this.collidesGround = true;
                                this.sprite = NHBullets.CIRCLE_BOLT;
                                this.trailLength = 15;
                                this.trailWidth = 3.0f;
                                this.weaveMag = 4.0f;
                                this.weaveScale = 4.0f;
                                this.splashDamageRadius = 20.0f;
                                this.explodeRange = this.splashDamageRadius / 1.5f;
                                this.splashDamage = this.damage;
                                this.homingDelay = 5.0f;
                                this.homingPower = 0.005f;
                                this.homingRange = 80.0f;
                                this.lifetime = 60.0f;
                                this.shrinkY = 0.0f;
                                this.shrinkX = 0.0f;
                                this.lightColor = this.trailColor = NHColor.lightSkyBack;
                                this.hitColor = this.trailColor;
                                this.lightningColor = this.trailColor;
                                this.backColor = this.trailColor;
                                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.55f);
                                this.height = 8.0f;
                                this.width = 8.0f;
                                this.smokeEffect = Fx.shootBigSmoke;
                                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                                this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                                this.despawnEffect = NHFx.shootCircleSmall(this.backColor);
                            }
                        };
                        this.shootSound = Sounds.shootMissile;
                    }
                });
                this.engineOffset = 9.0f;
                this.engineSize = 3.0f;
                this.speed = 2.4f;
                this.accel = 0.06f;
                this.drag = 0.035f;
                this.hitSize = 14.0f;
                this.health = 460.0f;
                this.buildSpeed = 0.5f;
                this.baseRotateSpeed = 1.5f;
                this.rotateSpeed = 2.5f;
                this.armor = 3.5f;
                this.flying = true;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        warper = new NHUnitType("warper"){
            {
                this.outlineColor = OColor;
                this.aiController = SurroundAI::new;
                this.constructor = EntityMapping.map((int)3);
                this.weapons.add((Object)new Weapon(){
                    {
                        this.top = false;
                        this.rotate = true;
                        this.alternate = true;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -10.0f;
                        this.reload = 6.0f;
                        this.inaccuracy = 3.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = NHBullets.warperBullet;
                        this.shootSound = NHSounds.blaster;
                    }
                });
                this.abilities.add((Object)new MoveLightningAbility(10.0f, 16, 0.2f, 12.0f, 4.0f, 6.0f, NHColor.lightSkyBack));
                this.targetAir = false;
                this.maxRange = 200.0f;
                this.engineOffset = 14.0f;
                this.engineSize = 4.0f;
                this.speed = 5.0f;
                this.accel = 0.04f;
                this.drag = 0.0075f;
                this.circleTarget = true;
                this.hitSize = 14.0f;
                this.health = 1000.0f;
                this.baseRotateSpeed = 1.5f;
                this.rotateSpeed = 2.5f;
                this.armor = 3.5f;
                this.flying = true;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        origin = new NHUnitType("origin"){
            {
                this.outlineColor = OColor;
                this.weapons.add((Object)new Weapon(NewHorizon.name("origin-weapon")){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.top = false;
                        this.rotate = true;
                        this.rotationLimit = 15.0f;
                        this.x = 5.0f;
                        this.y = -1.0f;
                        this.shootY = 6.0f;
                        this.reload = 15.0f;
                        this.shoot = new ShootSpread(){
                            {
                                this.shots = 3;
                                this.spread = 3.0f;
                            }
                        };
                        this.inaccuracy = 4.0f;
                        this.velocityRnd = 0.15f;
                        this.shootSound = NHSounds.scatter;
                        this.shake = 0.75f;
                        this.bullet = new BasicBulletType(4.0f, 7.0f){
                            {
                                super(arg0, arg1);
                                this.width = 5.0f;
                                this.height = 25.0f;
                                this.lightColor = this.hitColor = NHColor.lightSkyBack;
                                this.lightningColor = this.hitColor;
                                this.backColor = this.hitColor;
                                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.45f);
                                this.shootEffect = NHFx.shootLineSmall(this.backColor);
                                this.despawnEffect = NHFx.square(this.hitColor, 16.0f, 2, 12.0f, 2.0f);
                                this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.lifetime = 45.0f;
                            }
                        };
                    }
                });
                this.speed = 0.6f;
                this.hitSize = 8.0f;
                this.health = 160.0f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
                NHPixmap.outlineLegs(packer, this);
            }
        };
        thynomo = new NHUnitType("thynomo"){
            {
                this.outlineColor = OColor;
                this.weapons.add((Object)new Weapon(NewHorizon.name("thynomo-weapon")){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.top = false;
                        this.rotate = true;
                        this.rotationLimit = 15.0f;
                        this.x = 8.0f;
                        this.y = 1.0f;
                        this.shootY = 9.5f;
                        this.reload = 90.0f;
                        this.shootCone = 25.0f;
                        this.shootStatus = StatusEffects.slow;
                        this.shootStatusDuration = 90.0f;
                        this.continuous = true;
                        this.shootSound = Sounds.beamPlasma;
                        this.bullet = new ContinuousLaserBulletType(18.0f){
                            {
                                super(arg0);
                                this.length = 120.0f;
                                this.width = 2.55f;
                                this.incendChance = 0.025f;
                                this.incendSpread = 5.0f;
                                this.incendAmount = 1;
                                this.shake = 3.0f;
                                this.colors = new Color[]{NHColor.lightSkyFront.cpy().mul(0.8f, 0.85f, 0.9f, 0.2f), NHColor.lightSkyBack.cpy().mul(1.0f, 1.0f, 1.0f, 0.5f), NHColor.lightSkyBack, Color.white};
                                this.oscScl = 0.4f;
                                this.oscMag = 1.5f;
                                this.lifetime = 90.0f;
                                this.lightColor = this.hitColor = NHColor.lightSkyBack;
                                this.hitEffect = NHFx.lightSkyCircleSplash;
                                this.shootEffect = NHFx.square(this.hitColor, 22.0f, 4, 16.0f, 3.0f);
                                this.smokeEffect = Fx.shootBigSmoke;
                            }
                        };
                    }
                });
                this.boostMultiplier = 2.0f;
                this.health = 650.0f;
                this.rotateSpeed = 2.5f;
                this.canBoost = true;
                this.armor = 9.0f;
                this.mechLandShake = 2.0f;
                this.riseSpeed = 0.05f;
                this.mechFrontSway = 0.55f;
                this.speed = 0.4f;
                this.hitSize = 15.0f;
                this.engineOffset = 7.4f;
                this.engineSize = 4.25f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
                NHPixmap.outlineLegs(packer, this);
            }
        };
        ghost = new NHUnitType("ghost"){
            {
                this.outlineColor = OColor;
                this.health = 1200.0f;
                this.speed = 1.75f;
                this.drag = 0.18f;
                this.hitSize = 20.0f;
                this.armor = 12.0f;
                this.accel = 0.1f;
                this.rotateSpeed = 2.0f;
                this.buildSpeed = 3.0f;
                this.weapons.add((Object)NHUnitTypes.copyAndMove(smallCannon, 12.0f, -7.0f), (Object)NHUnitTypes.copyAndMove(smallCannon, 5.0f, -1.0f), (Object)new Weapon(NewHorizon.name("laser-cannon")){
                    {
                        super(arg0);
                        this.rotate = true;
                        this.top = true;
                        this.rotateSpeed = 3.0f;
                        this.x = 0.0f;
                        this.y = -11.0f;
                        this.recoil = 2.0f;
                        this.mirror = false;
                        this.reload = 60.0f;
                        this.shootY = 5.0f;
                        this.shootCone = 12.0f;
                        this.shake = 8.0f;
                        this.inaccuracy = 3.0f;
                        this.shoot = new ShootPattern();
                        this.predictTarget = true;
                        this.shootSound = Sounds.shootLaser;
                        this.bullet = new BasicBulletType(2.0f, 90.0f, "mine-bullet"){
                            {
                                super(arg0, arg1, arg2);
                                this.scaleLife = true;
                                this.keepVelocity = false;
                                this.trailLength = 22;
                                this.trailWidth = 4.0f;
                                this.drawSize = 120.0f;
                                this.recoil = 1.5f;
                                this.trailChance = 0.1f;
                                this.trailParam = 4.0f;
                                this.trailEffect = NHFx.trailToGray;
                                this.spin = 3.0f;
                                this.shrinkY = 0.15f;
                                this.shrinkX = 0.15f;
                                this.width = 25.0f;
                                this.height = 25.0f;
                                this.lifetime = 160.0f;
                                this.status = StatusEffects.blasted;
                                this.lightningColor = this.hitColor = NHColor.lightSkyBack;
                                this.lightColor = this.hitColor;
                                this.trailColor = this.hitColor;
                                this.backColor = this.hitColor;
                                this.frontColor = NHColor.lightSkyFront;
                                this.splashDamage = this.damage / 3.0f;
                                this.splashDamageRadius = 24.0f;
                                this.lightningLength = 2;
                                this.lightningLengthRand = 4;
                                this.lightningDamage = 10.0f;
                                this.hitSound = Sounds.explosion;
                                this.hitShake = 8.0f;
                                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.despawnEffect = NHFx.lightningHitLarge(this.backColor);
                                this.hitEffect = NHFx.hugeSmokeGray;
                            }
                        };
                    }
                });
                this.trailLength = 70;
                this.waveTrailX = 5.0f;
                this.waveTrailY = -13.0f;
                this.trailScl = 1.65f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        zarkov = new NHUnitType("zarkov"){
            {
                this.outlineColor = OColor;
                this.weapons.add((Object)NHUnitTypes.copyAndMove(multipleLauncher, 8.0f, -22.0f), (Object)NHUnitTypes.copyAndMove(multipleLauncher, 16.0f, -8.0f), (Object)NHUnitTypes.copyAnd(smallCannon, (Cons<Weapon>)((Cons)weapon -> {
                    weapon.x = 8.5f;
                    weapon.y = 5.75f;
                    weapon.autoTarget = true;
                    weapon.controllable = false;
                })));
                this.health = 12000.0f;
                this.speed = 1.0f;
                this.drag = 0.18f;
                this.hitSize = 42.0f;
                this.armor = 16.0f;
                this.accel = 0.1f;
                this.rotateSpeed = 1.6f;
                this.buildSpeed = 3.0f;
                this.trailLength = 70;
                this.waveTrailX = 7.0f;
                this.waveTrailY = -25.0f;
                this.trailScl = 2.6f;
                this.abilities.add((Object)new RepairFieldAbility(200.0f, 180.0f, 120.0f){
                    {
                        super(arg0, arg1, arg2);
                        this.healEffect = NHFx.healEffectSky;
                        this.activeEffect = NHFx.activeEffectSky;
                    }
                });
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        tarlidor = new NHUnitType("tarlidor"){
            {
                this.outlineColor = OColor;
                this.abilities.add((Object)new ShieldRegenFieldAbility(50.0f, 50.0f, 600.0f, 800.0f));
                this.weapons.add((Object)new Weapon(NewHorizon.name("stiken")){
                    {
                        super(arg0);
                        this.top = false;
                        this.shake = 3.0f;
                        this.shootY = 13.0f;
                        this.reload = 50.0f;
                        this.rotate = true;
                        this.rotateSpeed = 0.85f;
                        this.rotationLimit = 10.0f;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 2;
                                this.shotDelay = 7.0f;
                            }
                        };
                        this.x = 17.5f;
                        this.inaccuracy = 3.0f;
                        this.alternate = true;
                        this.ejectEffect = Fx.none;
                        this.recoil = 4.4f;
                        this.bullet = new ShieldBreakerType(6.25f, 40.0f, 650.0f){
                            {
                                super(speed, damage, shieldDamage);
                                this.drawSize = 500.0f;
                                this.trailLength = 18;
                                this.trailWidth = 3.5f;
                                this.spin = 2.75f;
                                this.despawnEffect = NHFx.square45_6_45;
                                this.hitEffect = new Effect(45.0f, e -> {
                                    Draw.color((Color)NHColor.lightSkyFront, (Color)NHColor.lightSkyBack, (float)e.fin());
                                    Lines.stroke((float)(2.5f * e.fout()));
                                    DrawFunc.randLenVectors(e.id, e.fin((Interp)Interp.pow3Out), 3, 6.0f, 21.0f, (x1, y1, fin, fout) -> Lines.square((float)(e.x + x1), (float)(e.y + y1), (float)(14.0f * Interp.pow3Out.apply(fin)), (float)45.0f));
                                });
                                this.lifetime = 55.0f;
                                this.pierceCap = 8;
                                this.width = 20.0f;
                                this.height = 44.0f;
                                this.lightColor = NHColor.lightSkyFront;
                                this.hitColor = this.trailColor = NHColor.lightSkyBack;
                                this.lightningColor = this.trailColor;
                                this.backColor = this.trailColor;
                                this.shootEffect = NHFx.shootLineSmall(this.backColor);
                                this.frontColor = NHColor.lightSkyFront;
                                this.lightning = 3;
                                this.lightningDamage = this.damage / 4.0f;
                                this.lightningLength = 3;
                                this.lightningLengthRand = 10;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.hitShake = 4.0f;
                                this.hitSound = Sounds.beamPlasma;
                                this.shrinkY = 0.7f;
                                this.shrinkX = 0.7f;
                            }
                        };
                        this.shootSound = NHSounds.laser4;
                    }
                }, (Object)new Weapon(NewHorizon.name("arc-blaster")){
                    {
                        super(arg0);
                        this.top = true;
                        this.rotate = true;
                        this.shootY = 12.0f;
                        this.reload = 45.0f;
                        this.shoot = new ShootHelix(){
                            {
                                this.shots = 2;
                                this.scl = 4.0f;
                                this.shotDelay = 3.8f;
                            }
                        };
                        this.rotateSpeed = 5.0f;
                        this.inaccuracy = 6.0f;
                        this.velocityRnd = 0.38f;
                        this.x = 8.0f;
                        this.alternate = false;
                        this.ejectEffect = Fx.none;
                        this.recoil = 1.7f;
                        this.bullet = NHBullets.basicSkyFrag;
                        this.shootSound = Sounds.beamPlasma;
                    }
                });
                this.engineOffset = 13.0f;
                this.engineSize = 6.5f;
                this.speed = 0.4f;
                this.hitSize = 20.0f;
                this.health = 7000.0f;
                this.buildSpeed = 1.8f;
                this.armor = 6.0f;
                this.rotateSpeed = 3.3f;
                this.fallSpeed = 0.016f;
                this.mechStepParticles = true;
                this.stepShake = 0.15f;
                this.canBoost = true;
                this.mechLandShake = 6.0f;
                this.boostMultiplier = 3.5f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
                NHPixmap.outlineLegs(packer, this);
            }
        };
        aliotiat = new NHUnitType("aliotiat"){
            {
                this.outlineColor = OColor;
                this.weapons.add((Object)NHUnitTypes.copyAndMoveAnd(posLiTurret, 10.0f, 3.0f, (Cons<Weapon>)((Cons)w -> {
                    w.shoot = new ShootPattern();
                    w.shoot.firstShotDelay = w.reload / 2.0f;
                })), (Object)NHUnitTypes.copyAndMove(posLiTurret, 10.0f, 3.0f), (Object)NHUnitTypes.copyAndMove(posLiTurret, 10.0f, 3.0f), (Object)NHUnitTypes.copyAndMove(posLiTurret, 6.0f, -2.0f));
                this.engineOffset = 10.0f;
                this.engineSize = 4.5f;
                this.speed = 0.35f;
                this.hitSize = 22.0f;
                this.health = 1200.0f;
                this.buildSpeed = 1.2f;
                this.armor = 5.0f;
                this.rotateSpeed = 2.8f;
                this.singleTarget = false;
                this.fallSpeed = 0.016f;
                this.mechStepParticles = true;
                this.stepShake = 0.15f;
                this.canBoost = true;
                this.mechLandShake = 6.0f;
                this.boostMultiplier = 3.5f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
                NHPixmap.outlineLegs(packer, this);
            }
        };
        gather = new NHUnitType("gather"){
            {
                this.outlineColor = OColor;
                this.aiController = MinerAI::new;
                this.defaultCommand = UnitCommand.mineCommand;
                this.constructor = EntityMapping.map((int)3);
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.ultFireBurn, NHStatusEffects.emp1, NHStatusEffects.emp2, StatusEffects.shocked, StatusEffects.burning, StatusEffects.melting, StatusEffects.electrified, StatusEffects.wet, StatusEffects.slow, StatusEffects.blasted});
                this.weapons.add((Object)new RepairBeamWeapon("repair-beam-weapon-center"){
                    {
                        super(arg0);
                        this.y = -6.5f;
                        this.x = 0.0f;
                        this.shootY = 6.0f;
                        this.mirror = false;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 0.6f;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 120.0f;
                            }
                        };
                    }
                });
                this.armor = 12.0f;
                this.hitSize = 16.0f;
                this.flying = true;
                this.drag = 0.06f;
                this.accel = 0.12f;
                this.itemCapacity = 120;
                this.speed = 1.2f;
                this.health = 1200.0f;
                this.engineSize = 3.4f;
                this.engineOffset = 9.2f;
                this.range = 80.0f;
                this.isEnemy = false;
                this.mineTier = 8;
                this.mineSpeed = 10.0f;
                this.lowAltitude = true;
                this.mineItems.addAll((Object[])new Item[]{NHItems.zeta, Items.beryllium, Items.tungsten});
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
                NHPixmap.outlineLegs(packer, this);
            }
        };
        saviour = new NHUnitType("saviour"){
            {
                this.outlineColor = OColor;
                this.aiController = SniperAI::new;
                this.defaultCommand = UnitCommand.repairCommand;
                this.hitSize = 55.0f;
                this.armor = 36.0f;
                this.health = 34000.0f;
                this.speed = 0.9f;
                this.rotateSpeed = 0.75f;
                this.accel = 0.04f;
                this.drag = 0.035f;
                this.flying = true;
                this.engineOffset = 22.0f;
                this.engineSize = 12.0f;
                this.buildSpeed = 8.0f;
                this.drawShields = false;
                this.lowAltitude = true;
                this.buildBeamOffset = 43.0f;
                this.payloadCapacity = 1600.0f;
                this.targetFlags = new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator, BlockFlag.battery, null};
                this.ammoType = new PowerAmmoType();
                for (int i : Mathf.signs) {
                    this.engines.add((Object)new UnitType.UnitEngine((float)i * 30.25f, -28.75f, 5.0f, (float)(-90 + i * 45)));
                    this.engines.add((Object)new UnitType.UnitEngine((float)i * 48.0f, -13.0f, 4.0f, (float)(-90 + i * 45)));
                }
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.ultFireBurn, NHStatusEffects.weak, NHStatusEffects.scannerDown, NHStatusEffects.emp1, NHStatusEffects.emp2, NHStatusEffects.emp3, StatusEffects.burning, StatusEffects.melting, NHStatusEffects.scrambler});
                this.weapons.add((Object)new Weapon(){
                    {
                        this.shootY = 0.0f;
                        this.shootX = 0.0f;
                        this.x = 0.0f;
                        this.y = 22.0f;
                        this.reload = 180.0f;
                        this.rotate = true;
                        this.rotationLimit = 160.0f;
                        this.mirror = false;
                        this.shootCone = 15.0f;
                        this.shake = 5.0f;
                        this.shootSound = Sounds.beamPlasma;
                        this.bullet = new ShieldBreakerType(6.0f, 30.0f, "mine-bullet", 3000.0f){
                            {
                                super(speed, damage, bulletSprite, shieldDamage);
                                this.rangeOverride = 400.0f;
                                this.scaleLife = true;
                                this.shootEffect = this.hitEffect = Fx.hitEmpSpark;
                                this.smokeEffect = Fx.healWave;
                                this.despawnEffect = NHFx.circleSplash(Pal.heal, 75.0f, 8, 68.0f, 7.0f);
                                this.lightningColor = this.hitColor = Pal.heal;
                                this.trailColor = this.hitColor;
                                this.lightColor = this.hitColor;
                                this.backColor = this.hitColor;
                                this.frontColor = Color.white;
                                this.trailEffect = NHFx.trailSolid;
                                this.trailParam = 4.0f;
                                this.trailChance = 0.5f;
                                this.lifetime = 100.0f;
                                this.height = 25.0f;
                                this.width = 25.0f;
                                this.shrinkY = 0.0f;
                                this.shrinkX = 0.0f;
                                this.spin = 4.0f;
                                this.trailWidth = 3.5f;
                                this.trailLength = 18;
                                this.pierceBuilding = true;
                                this.pierceCap = 8;
                                this.status = NHStatusEffects.scannerDown;
                                this.statusDuration = 180.0f;
                            }
                        };
                    }
                }, (Object)new PointDefenseWeapon("point-defense-mount"){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.x = 52.0f;
                        this.y = -5.0f;
                        this.reload = 6.0f;
                        this.targetInterval = 6.0f;
                        this.targetSwitchInterval = 8.0f;
                        this.bullet = new BulletType(){
                            {
                                color = Pal.heal;
                                this.shootEffect = Fx.hitFlamePlasma;
                                this.hitEffect = Fx.hitMeltHeal;
                                this.maxRange = 240.0f;
                                this.damage = 150.0f;
                            }
                        };
                    }
                }, (Object)new RepairBeamWeapon("repair-beam-weapon-center-large"){
                    {
                        super(arg0);
                        this.x = 17.0f;
                        this.y = -21.0f;
                        this.shootY = 6.0f;
                        this.beamWidth = 0.8f;
                        this.repairSpeed = 4.0f;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 160.0f;
                            }
                        };
                    }
                }, (Object)new Weapon(NewHorizon.name("saviour-cannon-smaller")){
                    {
                        super(arg0);
                        this.top = true;
                        this.rotate = true;
                        this.rotationLimit = 60.0f;
                        this.rotateSpeed = 1.5f;
                        this.alternate = true;
                        this.mirror = true;
                        this.shake = 2.0f;
                        this.shootY = 20.0f;
                        this.x = 32.0f;
                        this.y = -7.0f;
                        this.reload = 75.0f;
                        this.recoil = 7.0f;
                        this.shootSound = NHSounds.laser3;
                        this.cooldownTime = 40.0f;
                        this.bullet = NHBullets.saviourBullet;
                    }
                });
                this.abilities.add((Object)new ForceFieldAbility(160.0f, 60.0f, 15000.0f, 900.0f, 8, 0.0f), (Object)new RepairFieldAbility(1500.0f, 180.0f, 400.0f), (Object)new HealFieldAbility(Pal.heal, 360.0f, 0.0f, 22.0f, 400.0f, 0.15f){
                    {
                        super(scanColor, reloadTime, spawnX, spawnY, range, healMount);
                        this.effectRadius = 6.0f;
                        this.sectors = 6;
                        this.sectorRad = 0.065f;
                    }
                }, (Object)new GravityTrapAbility(240.0f));
            }

            public void load() {
                super.load();
                this.shadowRegion = this.outlineRegion;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        destruction = new Destruction();
        longinus = new NHUnitType("longinus"){
            {
                this.outlineColor = OColor;
                this.aiController = SniperAI::new;
                this.constructor = EntityMapping.map((int)3);
                this.fogRadius = 100.0f;
                this.lowAltitude = true;
                this.health = 10000.0f;
                this.speed = 0.45f;
                this.outlineRadius = 4;
                this.strafePenalty = 0.8f;
                this.accel = 0.02f;
                this.drag = 0.025f;
                this.flying = true;
                this.circleTarget = false;
                this.rotateMoveFirst = false;
                this.hitSize = 50.0f;
                this.armor = 15.0f;
                this.engineOffset = 46.0f;
                this.engineSize = 12.0f;
                this.rotateSpeed = 0.65f;
                this.ammoType = new ItemAmmoType(NHItems.presstanium);
                this.targetFlags = new BlockFlag[]{BlockFlag.turret, null, BlockFlag.reactor, BlockFlag.generator, BlockFlag.core};
                for (int i : Mathf.signs) {
                    this.engines.add((Object)new UnitType.UnitEngine(21.5f * (float)i, -43.5f, 5.0f, (float)(-90 + 45 * i)));
                }
                this.weapons.add((Object)new Weapon(NewHorizon.name("longinus-weapon")){
                    {
                        super(arg0);
                        this.shootY = 42.0f;
                        this.minWarmup = 0.95f;
                        healColor = NHColor.thurmixRed;
                        this.shoot = new ShootHelix(){
                            {
                                this.shots = 3;
                                this.shotDelay = 18.0f;
                                this.mag = 2.2f;
                                this.scl = 2.2f;
                            }
                        };
                        this.parts.add((Object)new RegionPart("-ejector"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.recoil, 0.15f);
                                this.turretShading = true;
                                this.under = true;
                                this.mirror = true;
                                this.x = 15.0f;
                                this.y = 26.5f;
                                this.moveX = 6.0f;
                                this.moveY = -6.0f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-ejector"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.recoil, 0.15f);
                                this.turretShading = true;
                                this.under = true;
                                this.mirror = true;
                                this.x = 17.0f;
                                this.y = 14.5f;
                                this.moveX = 6.0f;
                                this.moveY = -6.0f;
                            }
                        });
                        this.parts.add((Object)new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.smoothReload.inv().delay(0.65f).curve((Interp)Interp.pow3Out);
                                this.y = shootY - 6.0f;
                                this.sides = 4;
                                this.color = NHColor.lightSkyBack;
                                this.colorTo = NHColor.lightSkyMiddle;
                                this.rotateSpeed = 2.0f;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 1.5f;
                                this.radius = 2.0f;
                                this.radiusTo = 8.0f;
                                this.moveY = 11.0f;
                                this.layer = 110.0f;
                            }
                        });
                        this.parts.add((Object)new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.smoothReload.inv().delay(0.65f).curve((Interp)Interp.pow3Out);
                                this.y = shootY - 6.0f;
                                this.sides = 4;
                                this.color = NHColor.lightSkyBack;
                                this.colorTo = NHColor.lightSkyMiddle;
                                this.rotateSpeed = -1.0f;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 1.25f;
                                this.radius = 4.0f;
                                this.radiusTo = 10.0f;
                                this.moveY = 11.0f;
                                this.layer = 110.0f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-panel"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.outline = false;
                                this.mirror = true;
                                this.x = 9.25f;
                                this.y = 20.5f;
                                this.moveX = -1.0f;
                                this.moveY = -1.0f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-main-charger"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.recoil.inv().curve((Interp)Interp.pow3Out), 0.15f);
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, 8.0f, 0.0f));
                                this.turretShading = true;
                                this.under = true;
                                this.layerOffset = -0.005f;
                                this.heatLayerOffset = -0.005f;
                                this.heatColor = Pal.sap;
                                this.mirror = true;
                                this.x = 16.0f;
                                this.y = -18.0f;
                                this.moveX = 10.75f;
                                this.moveY = -2.0f;
                                this.moveRot = -45.0f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-charger"){
                            {
                                super(arg0);
                                this.turretShading = true;
                                this.under = true;
                                this.heatLayerOffset = -0.005f;
                                this.mirror = true;
                                this.x = 10.0f;
                                this.y = 45.5f;
                                this.moveX = -6.0f;
                                this.moveY = 0.0f;
                            }
                        });
                        this.x = 0.0f;
                        this.y = -9.0f;
                        this.recoil = 10.0f;
                        this.reload = 420.0f;
                        this.cooldownTime = 150.0f;
                        this.rotationLimit = 10.0f;
                        this.shake = 12.0f;
                        this.rotateSpeed = 0.55f;
                        this.rotate = false;
                        this.shootCone = 3.0f;
                        this.top = false;
                        this.mirror = false;
                        this.shootSound = NHSounds.railGunBlast;
                        this.soundPitchMax = 1.1f;
                        this.soundPitchMin = 0.9f;
                        this.layerOffset = -5.0E-4f;
                        this.bullet = new AdaptBulletType(){
                            {
                                this.recoil = 0.095f;
                                this.lifetime = 40.0f;
                                this.speed = 25.0f;
                                this.damage = 600.0f;
                                this.shieldDamageMultiplier = 0.2f;
                                this.trailLength = 200;
                                this.trailWidth = 2.0f;
                                this.keepVelocity = false;
                                this.lightColor = this.lightningColor = NHColor.lightSkyBack;
                                this.backColor = this.lightningColor;
                                this.hitColor = this.lightningColor;
                                this.trailColor = this.lightningColor;
                                this.frontColor = NHColor.lightSkyFront;
                                this.width = 10.0f;
                                this.height = 40.0f;
                                this.hitSound = Sounds.beamPlasma;
                                this.hitShake = 18.0f;
                                this.despawnShake = 18.0f;
                                this.pierceArmor = true;
                                this.lightning = 3;
                                this.lightningLength = 6;
                                this.lightningLengthRand = 18;
                                this.lightningDamage = 200.0f;
                                this.smokeEffect = NHFx.square(this.hitColor, 80.0f, 8, 48.0f, 6.0f);
                                this.shootEffect = NHFx.instShoot(this.backColor, this.frontColor);
                                this.despawnEffect = NHFx.lightningHitLarge;
                                this.hitEffect = new MultiEffect(new Effect[]{NHFx.hitSpark(this.backColor, 75.0f, 24, 90.0f, 2.0f, 12.0f), NHFx.square45_6_45, NHFx.lineCircleOut(this.backColor, 18.0f, 20.0f, 2.0f), NHFx.sharpBlast(this.backColor, this.frontColor, 120.0f, 40.0f)});
                                this.despawnHit = true;
                            }

                            public void hit(Bullet b, float x, float y) {
                                super.hit(b, x, y);
                                UltFire.createChance(x, y, 12.0f, 0.15f, b.team);
                            }
                        };
                        this.shootStatus = StatusEffects.slow;
                        this.shootStatusDuration = this.bullet.lifetime * 1.5f;
                    }
                });
                this.weapons.add((Object)NHUnitTypes.copyAnd(BasicCannon, (Cons<Weapon>)((Cons)weapon -> {
                    weapon.x = 19.5f;
                    weapon.y = -28.0f;
                    weapon.autoTarget = true;
                    weapon.controllable = false;
                })), (Object)NHUnitTypes.copyAnd(BasicCannon, (Cons<Weapon>)((Cons)weapon -> {
                    weapon.x = 10.0f;
                    weapon.y = -46.0f;
                    weapon.autoTarget = true;
                    weapon.controllable = false;
                })), (Object)NHUnitTypes.copyAndMove(laserCannon, 0.0f, -25.5f));
            }

            public void drawSoftShadow(Unit unit) {
                float z = Draw.z();
                Draw.z((float)(z - 0.01f));
                super.drawSoftShadow(unit);
                Draw.z((float)z);
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        declining = new NHUnitType("declining"){
            {
                this.outlineColor = OColor;
                this.weapons.add((Object)NHUnitTypes.copyAndMove(mainCannon, 0.0f, -17.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(mainCannon, 0.0f, 25.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(mainCannon, 0.0f, -56.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 30.0f, -30.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 36.0f, -35.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 24.0f, -35.0f));
                this.weapons.add((Object)laserCannon);
                this.abilities.add((Object)new TurretShield(){
                    {
                        this.radius = hitSize + 112.0f;
                        this.angle = 130.0f;
                        this.regen = 15.0f;
                        this.cooldown = 600.0f;
                        this.max = 30000.0f;
                        this.width = 24.0f;
                        this.drawWidth = 12.0f;
                        this.whenShooting = false;
                        this.chanceDeflect = -1.0f;
                    }
                });
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.weak, NHStatusEffects.emp2, NHStatusEffects.emp3, NHStatusEffects.emp1, NHStatusEffects.scrambler, NHStatusEffects.scannerDown, NHStatusEffects.ultFireBurn, StatusEffects.melting, StatusEffects.burning, StatusEffects.shocked, StatusEffects.electrified});
                this.targetFlags = new BlockFlag[]{BlockFlag.unitAssembler, BlockFlag.turret, BlockFlag.reactor, BlockFlag.generator, null};
                this.health = 55000.0f;
                this.speed = 0.55f;
                this.drag = 0.18f;
                this.hitSize = 65.0f;
                this.armor = 32.0f;
                this.accel = 0.1f;
                this.rotateSpeed = 0.5f;
                this.buildSpeed = 2.0f;
                this.waveTrailX = 20.0f;
                this.waveTrailY = -49.0f;
                this.trailLength = 70;
                this.trailScl = 4.0f;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }
        };
        sin = new NHUnitType("sin"){
            {
                this.outlineColor = OColor;
                this.abilities.add((Object)new ForceFieldAbility(128.0f, 25.0f, 30000.0f, 900.0f, 4, 0.0f), (Object)new StatusFieldAbility(NHStatusEffects.phased, 245.0f, 240.0f, 240.0f){
                    {
                        super(arg0, arg1, arg2, arg3);
                        this.activeEffect = NHFx.lineSquareOut(NHColor.lightSkyBack, 60.0f, 240.0f, 4.0f, 45.0f);
                        this.applyEffect = NHFx.lineSquareOut(NHColor.lightSkyBack, 30.0f, 45.0f, 1.0f, 45.0f);
                    }
                });
                this.drawShields = false;
                this.engineOffset = 18.0f;
                this.engineSize = 9.0f;
                this.speed = 0.2f;
                this.hitSize = 52.0f;
                this.health = 80000.0f;
                this.buildSpeed = 4.0f;
                this.armor = 80.0f;
                this.ammoType = new ItemAmmoType(NHItems.presstanium);
                this.weapons.add((Object)new Weapon(NewHorizon.name("sin-cannon")){
                    {
                        super(arg0);
                        this.top = false;
                        this.rotate = true;
                        this.rotationLimit = 13.0f;
                        this.rotateSpeed = 0.75f;
                        this.alternate = true;
                        this.shake = 3.5f;
                        this.shootY = 32.0f;
                        this.x = 42.0f;
                        this.y = -2.0f;
                        this.recoil = 3.4f;
                        this.predictTarget = true;
                        this.shootCone = 30.0f;
                        this.reload = 60.0f;
                        this.parts.add((Object)new RegionPart("-shooter"){
                            {
                                super(arg0);
                                this.turretShading = true;
                                this.under = true;
                                this.outline = true;
                                this.mirror = false;
                                this.moveY = -8.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 3;
                                this.shotDelay = 3.5f;
                            }
                        };
                        this.velocityRnd = 0.075f;
                        this.inaccuracy = 6.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = new BasicBulletType(8.0f, 200.0f, NHBullets.STRIKE){
                            {
                                super(arg0, arg1, arg2);
                                this.backColor = this.lightColor = NHColor.lightSkyBack;
                                this.lightningColor = this.lightColor;
                                this.trailColor = this.lightColor;
                                this.frontColor = NHColor.lightSkyFront;
                                this.lightning = 2;
                                this.lightningCone = 360.0f;
                                this.lightningLength = 8;
                                this.lightningLengthRand = 8;
                                this.homingPower = 0.0f;
                                this.scaleLife = true;
                                this.collides = false;
                                this.trailLength = 15;
                                this.trailWidth = 3.5f;
                                this.splashDamage = this.lightningDamage = this.damage;
                                this.splashDamageRadius = 48.0f;
                                this.lifetime = 95.0f;
                                this.width = 22.0f;
                                this.height = 35.0f;
                                this.trailEffect = NHFx.trailToGray;
                                this.trailParam = 3.0f;
                                this.trailChance = 0.35f;
                                this.hitShake = 7.0f;
                                this.hitSound = Sounds.explosion;
                                this.hitEffect = NHFx.hitSpark(this.backColor, 75.0f, 24, 95.0f, 2.8f, 16.0f);
                                this.smokeEffect = new OptionalMultiEffect(NHFx.hugeSmokeGray, NHFx.circleSplash(this.backColor, 60.0f, 8, 60.0f, 6.0f));
                                this.shootEffect = NHFx.hitSpark(this.backColor, 30.0f, 15, 35.0f, 1.7f, 8.0f);
                                this.despawnEffect = NHFx.blast(this.backColor, 60.0f);
                                this.fragBullet = NHBullets.basicSkyFrag;
                                this.fragBullets = 5;
                                this.fragLifeMax = 0.6f;
                                this.fragLifeMin = 0.2f;
                                this.fragVelocityMax = 0.35f;
                                this.fragVelocityMin = 0.074f;
                            }

                            public void hit(Bullet b, float x, float y) {
                                super.hit(b, x, y);
                                UltFire.createChance((Teamc)b, this.splashDamageRadius, 0.4f);
                            }
                        };
                        this.shootSound = Sounds.shootArtillery;
                    }
                }, (Object)new Weapon(){
                    {
                        this.mirror = false;
                        this.rotate = true;
                        this.rotateSpeed = 25.0f;
                        this.x = 0.0f;
                        this.y = 12.0f;
                        this.recoil = 2.7f;
                        this.shootY = 7.0f;
                        this.shootCone = 40.0f;
                        this.velocityRnd = 0.075f;
                        this.reload = 150.0f;
                        this.xRand = 18.0f;
                        this.shoot = new ShootSine(){
                            {
                                this.shots = 12;
                                this.shotDelay = 4.0f;
                            }
                        };
                        this.inaccuracy = 5.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = NHBullets.annMissile;
                        this.shootSound = NHSounds.launch;
                    }
                });
                this.weapons.add((Object)NHUnitTypes.copyAndMove(multipleLauncher, 26.0f, -12.5f));
                this.weapons.add((Object)NHUnitTypes.copyAnd(laserCannon, (Cons<Weapon>)((Cons)w -> {
                    w.mirror = false;
                    w.x = 0.0f;
                    w.y = 14.0f;
                })));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 22.0f, 18.0f));
                this.weapons.add((Object)NHUnitTypes.copyAndMove(pointDefenceWeaponC, 25.0f, 2.0f));
                this.immunities.addAll((Object[])new StatusEffect[]{NHStatusEffects.scannerDown, NHStatusEffects.weak, NHStatusEffects.ultFireBurn, NHStatusEffects.emp1, NHStatusEffects.emp2, NHStatusEffects.emp3, NHStatusEffects.scrambler, StatusEffects.disarmed, StatusEffects.melting, StatusEffects.burning, StatusEffects.wet, StatusEffects.shocked, StatusEffects.tarred, StatusEffects.muddy, StatusEffects.slow, StatusEffects.disarmed});
                this.groundLayer = 75.1f;
                this.mechLandShake = 12.0f;
                this.stepShake = 5.0f;
                this.rotateSpeed = 1.0f;
                this.fallSpeed = 0.03f;
                this.mechStepParticles = true;
                this.canDrown = false;
                this.mechFrontSway = 2.2f;
                this.mechSideSway = 0.8f;
                this.canBoost = true;
                this.boostMultiplier = 2.5f;
            }
        };
        anvil = new NHUnitType("anvil"){
            {
                this.outlineColor = OColor;
                this.constructor = EntityMapping.map((int)3);
                this.abilities.addAll((Object[])new Ability[]{new EnergyFieldAbility(180.0f, 150.0f, 300.0f){
                    {
                        super(arg0, arg1, arg2);
                        this.color = NHColor.thurmixRed;
                        this.y = -9.0f;
                        this.healEffect = new Effect(11.0f, e -> {
                            Draw.color((Color)NHColor.thurmixRed);
                            Lines.stroke((float)(e.fout() * 2.0f));
                            Lines.circle((float)e.x, (float)e.y, (float)(2.0f + e.finpow() * 7.0f));
                        });
                        this.status = NHStatusEffects.emp1;
                        this.sectors = 4;
                        this.sectorRad = 0.16f;
                        this.healPercent = 0.25f;
                        this.statusDuration = 120.0f;
                        this.shootSound = NHSounds.synchro;
                    }
                }, new ShieldArcAbility(){
                    {
                        this.radius = 120.0f;
                        this.angle = 120.0f;
                        this.regen = 20.0f;
                        this.cooldown = 600.0f;
                        this.max = 25000.0f;
                        this.width = 20.0f;
                        this.whenShooting = true;
                        this.chanceDeflect = -1.0f;
                    }
                }});
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.weak, NHStatusEffects.emp2, NHStatusEffects.emp3, NHStatusEffects.emp1, NHStatusEffects.scrambler, NHStatusEffects.scannerDown, NHStatusEffects.ultFireBurn, StatusEffects.melting, StatusEffects.burning, StatusEffects.shocked, StatusEffects.electrified});
                this.hitSize = 70.0f;
                this.armor = 52.0f;
                this.health = 78000.0f;
                this.speed = 1.0f;
                this.rotateSpeed = 0.75f;
                this.accel = 0.06f;
                this.drag = 0.035f;
                this.flying = true;
                this.engineOffset = 65.0f;
                this.engineSize = 24.0f;
                this.buildSpeed = 5.0f;
                this.drawShields = true;
                this.lowAltitude = true;
                this.buildBeamOffset = 63.0f;
                this.payloadCapacity = 576.0f;
                Weapon weapon = new Weapon(NewHorizon.name("anvil-cannon")){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.rotate = true;
                        this.rotateSpeed = 1.25f;
                        this.rotationLimit = 35.0f;
                        this.alternate = true;
                        this.top = true;
                        this.shootY = 31.0f;
                        this.recoil = 1.0f;
                        this.recoilTime = 90.0f;
                        this.reload = 160.0f;
                        this.shootCone = 15.0f;
                        this.layerOffset = 0.003f;
                        this.parts.add((Object)new RegionPart("-shooter"){
                            {
                                super(arg0);
                                this.moveY = -7.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.outline = true;
                                this.turretShading = true;
                                this.under = true;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-panel"){
                            {
                                super(arg0);
                                this.outline = true;
                                this.under = true;
                                this.x = 5.0f;
                                this.y = -0.25f;
                                this.moveRot = -45.0f;
                                this.moveX = 4.0f;
                                this.moveY = -1.0f;
                                this.layerOffset = -0.001f;
                                this.progress = DrawPart.PartProgress.warmup.add(DrawPart.PartProgress.recoil.mul(0.3f));
                            }
                        });
                        this.bullet = new ShieldBreakerType(9.0f, 400.0f, 1200.0f){
                            {
                                super(speed, damage, shieldDamage);
                                this.sprite = NHBullets.MISSILE_LARGE;
                                this.backColor = this.lightColor = NHColor.thurmixRed;
                                this.lightningColor = this.lightColor;
                                this.trailColor = this.lightColor;
                                this.frontColor = NHColor.thurmixRedLight;
                                this.lightning = 2;
                                this.lightningCone = 360.0f;
                                this.lightningLength = 12;
                                this.lightningLengthRand = 12;
                                this.homingPower = 0.0f;
                                this.lifetime = 45.0f;
                                this.trailLength = 15;
                                this.trailWidth = 3.5f;
                                this.splashDamage = this.lightningDamage = this.damage * 0.7f;
                                this.splashDamageRadius = 40.0f;
                                this.width = 22.0f;
                                this.height = 35.0f;
                                this.despawnShake = 3.0f;
                                this.hitShake = 3.0f;
                                this.hitSound = this.despawnSound = Sounds.explosion;
                                this.hitEffect = new OptionalMultiEffect(NHFx.blast(this.backColor, 60.0f), NHFx.hitSpark(this.backColor, 75.0f, 8, 80.0f, 2.0f, 12.0f));
                                this.smokeEffect = NHFx.hugeSmokeGray;
                                this.shootEffect = NHFx.shootLineSmall(this.backColor);
                                this.despawnEffect = NHFx.lightningHitLarge(this.backColor);
                                this.status = NHStatusEffects.weak;
                                this.statusDuration = 180.0f;
                            }
                        };
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 3;
                                this.shotDelay = 14.0f;
                            }
                        };
                        this.inaccuracy = 3.0f;
                        this.velocityRnd = 0.095f;
                        this.x = 30.0f;
                        this.y = -2.0f;
                        this.shootSound = NHSounds.flak;
                        this.shake = 4.0f;
                    }
                };
                Weapon aaTurret = new Weapon(NewHorizon.name("rapid-laser-cannon")){
                    {
                        super(arg0);
                        this.mirror = true;
                        this.rotate = true;
                        this.alternate = true;
                        this.top = true;
                        this.autoTarget = true;
                        this.rotateSpeed = 30.0f;
                        this.shootY = 10.0f;
                        this.recoil = 2.0f;
                        this.reload = 12.0f;
                        this.heatColor = Pal.redderDust;
                        this.cooldownTime = 45.0f;
                        this.bullet = new ShrapnelBulletType(){
                            {
                                this.length = 520.0f;
                                this.damage = 300.0f;
                                this.status = StatusEffects.slow;
                                this.statusDuration = 60.0f;
                                this.width = 11.0f;
                                this.fromColor = NHColor.thurmixRedLight;
                                this.lightningColor = this.toColor = NHColor.thurmixRed;
                                this.lightColor = this.toColor;
                                this.hitColor = this.toColor;
                                this.shootEffect = NHFx.lightningHitSmall(this.toColor);
                                this.smokeEffect = new OptionalMultiEffect(new Effect(this.lifetime + 2.0f, b -> {
                                    Draw.color((Color)this.fromColor, (Color)this.toColor, (float)b.fin());
                                    Fill.circle((float)b.x, (float)b.y, (float)(this.width / 2.0f * b.fout()));
                                    DrawFunc.tri(b.x, b.y, this.width / 1.75f * b.fout(Interp.circleIn), 30.0f, b.rotation + 60.0f);
                                    DrawFunc.tri(b.x, b.y, this.width / 1.75f * b.fout(Interp.circleIn), 30.0f, b.rotation - 60.0f);
                                }), NHFx.hitSpark(this.toColor, 35.0f, 6, 24.0f, 1.75f, 8.0f));
                            }
                        };
                        this.shoot = new ShootPattern();
                        this.x = 20.0f;
                        this.y = -34.0f;
                        this.shootSound = NHSounds.synchro;
                        this.shake = 1.0f;
                    }
                };
                PointDefenseWeapon pointDefenseWeapon = new PointDefenseWeapon(NewHorizon.name("anvil-point-cannon")){
                    {
                        super(arg0);
                        this.color = NHColor.thurmixRed;
                        this.x = 14.0f;
                        this.y = -2.0f;
                        this.reload = 6.0f;
                        this.targetInterval = 6.0f;
                        this.targetSwitchInterval = 8.0f;
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = NHFx.shootLineSmall(color);
                                this.hitEffect = NHFx.lightningHitSmall(color);
                                this.maxRange = 280.0f;
                                this.damage = 120.0f;
                            }
                        };
                    }
                };
                this.weapons.addAll((Object[])new Weapon[]{weapon, NHUnitTypes.copyAndMove(weapon, 50.0f, -24.0f), aaTurret, NHUnitTypes.copyAndMove(aaTurret, 12.0f, -12.0f), pointDefenseWeapon, NHUnitTypes.copyAndMove((Weapon)pointDefenseWeapon, 13.0f, 41.0f)});
                this.range = 500.0f;
                this.ammoType = new PowerAmmoType();
                this.targetFlags = new BlockFlag[]{BlockFlag.factory, BlockFlag.turret, BlockFlag.reactor, BlockFlag.generator, BlockFlag.core, null};
            }
        };
        guardian = new NHUnitType("guardian"){
            public final float outerEyeScl = 0.25f;
            public final float innerEyeScl = 0.18f;
            public final float[][] rotator = new float[][]{{75.0f, 0.0f, 8.5f, 1.35f, 0.1f}, {55.0f, 0.0f, 6.5f, -1.7f, 0.1f}, {25.0f, 0.0f, 13.0f, 0.75f, 0.3f}, {100.0f, 33.5f, 11.0f, 0.75f, 0.7f}, {60.0f, -20.0f, 6.0f, -0.5f, 1.25f}};
            public final float bodySize = 24.0f;
            public Effect slopeEffect = NHFx.boolSelector;
            {
                this.clipSize = 260.0f;
                this.engineLayer = 110.0f;
                this.engineOffset = 5.0f;
                this.deathExplosionEffect = Fx.none;
                this.deathSound = Sounds.beamPlasma;
                this.trailLength = 40;
                this.trailScl = 3.0f;
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.scannerDown, NHStatusEffects.weak, StatusEffects.wet, StatusEffects.shocked, StatusEffects.tarred, StatusEffects.burning, StatusEffects.melting, StatusEffects.blasted, StatusEffects.corroded, StatusEffects.electrified, StatusEffects.freezing, StatusEffects.muddy, NHStatusEffects.emp1, NHStatusEffects.emp2, NHStatusEffects.emp3, NHStatusEffects.quantization});
                this.armor = 20.0f;
                this.hitSize = 45.0f;
                this.speed = 1.5f;
                this.accel = 0.07f;
                this.drag = 0.075f;
                this.health = 30000.0f;
                this.itemCapacity = 0;
                this.rotateSpeed = 6.0f;
                this.engineSize = 8.0f;
                this.flying = true;
                this.trailLength = 70;
                this.buildSpeed = 10.0f;
                this.crashDamageMultiplier = Mathf.clamp((float)(this.hitSize / 10.0f), (float)1.0f, (float)10.0f);
                this.payloadCapacity = -1.0f;
                this.buildBeamOffset = 0.0f;
                this.weapons.add((Object)new Weapon(){
                    {
                        this.reload = 180.0f;
                        this.shootY = 0.0f;
                        this.shootX = 0.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.shootCone = 360.0f;
                        this.shootSound = NHSounds.blaster;
                        this.bullet = NHBullets.guardianBullet;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 15;
                                this.shotDelay = 3.0f;
                            }

                            public void shoot(int totalShots, ShootPattern.BulletHandler handler) {
                                for (int i = 0; i < this.shots; ++i) {
                                    handler.shoot(0.0f, 0.0f, (float)Mathf.random((int)360), this.firstShotDelay + this.shotDelay * (float)i);
                                }
                            }
                        };
                    }
                }, (Object)new Weapon(){
                    {
                        this.reload = 120.0f;
                        this.shootY = 0.0f;
                        this.shootX = 0.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.rotateSpeed = 360.0f;
                        this.shootSound = NHSounds.hugeShoot;
                        this.velocityRnd = 0.015f;
                        this.shoot = new ShootMulti((ShootPattern)new ShootSummon(0.0f, 0.0f, 220.0f, 0.0f){
                            {
                                super(arg0, arg1, arg2, arg3);
                                this.shots = 3;
                                this.shotDelay = 1.0f;
                            }
                        }, new ShootPattern[]{new ShootSpread(){
                            {
                                this.shots = 2;
                                this.spread = 2.0f;
                                this.shotDelay = 25.0f;
                            }
                        }});
                        this.bullet = NHBullets.guardianBulletLightningBall;
                    }
                }, (Object)new Weapon(){
                    {
                        this.shootCone = 30.0f;
                        this.predictTarget = false;
                        this.top = false;
                        this.mirror = false;
                        this.rotate = true;
                        this.shootY = 0.0f;
                        this.shootX = 0.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.continuous = false;
                        this.rotateSpeed = 100.0f;
                        this.reload = 600.0f;
                        this.shootStatus = NHStatusEffects.intercepted;
                        this.shootStatusDuration = 180.0f;
                        this.shoot = new ShootSummon(0.0f, 0.0f, 180.0f, 0.0f){
                            {
                                super(arg0, arg1, arg2, arg3);
                                this.shots = 3;
                            }
                        };
                        this.shake = 13.0f;
                        this.shootSound = Sounds.none;
                        this.bullet = new StrafeLaser(300.0f){
                            {
                                super(damage);
                                this.strafeAngle = 0.0f;
                            }

                            @Override
                            public void init(Bullet b) {
                                super.init(b);
                                Sounds.beamPlasma.at((Position)b);
                            }

                            @Override
                            public void hit(Bullet b, float x, float y) {
                                super.hit(b, x, y);
                                if (b.owner instanceof Unit) {
                                    Unit from = (Unit)b.owner;
                                    if (from.dead || !from.isAdded() || from.healthf() > 0.99f) {
                                        return;
                                    }
                                    from.heal(this.damage / 20.0f);
                                    if (Vars.headless || !NHSetting.enableDetails()) {
                                        return;
                                    }
                                    PosLightning.createEffect((Position)b, (Position)from, b.team.color, 2, Mathf.random((float)1.5f, (float)3.0f));
                                }
                            }

                            @Override
                            public void draw(Bullet b) {
                                Tmp.c1.set(b.team.color).lerp(Color.white, Mathf.absin((float)4.0f, (float)0.1f));
                                super.draw(b);
                                Draw.z((float)110.0f);
                                float fout = b.fout(0.25f) * Mathf.curve((float)b.fin(), (float)0.0f, (float)0.125f);
                                Draw.color((Color)Tmp.c1);
                                Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.225f * fout));
                                if (b.owner instanceof Unit) {
                                    Unit unit = (Unit)b.owner;
                                    if (!unit.dead) {
                                        Draw.z((float)100.0f);
                                        Lines.stroke((float)((this.width / 3.0f + Mathf.absin((float)Time.time, (float)4.0f, (float)0.8f)) * fout));
                                        Lines.line((float)b.x, (float)b.y, (float)unit.x, (float)unit.y, (boolean)false);
                                    }
                                }
                                for (int i : Mathf.signs) {
                                    DrawFunc.tri(b.x, b.y, 6.0f * fout, 10.0f + 50.0f * fout, Time.time * 1.5f + (float)(90 * i));
                                    DrawFunc.tri(b.x, b.y, 6.0f * fout, 20.0f + 60.0f * fout, Time.time * -1.0f + (float)(90 * i));
                                }
                                Draw.z((float)110.001f);
                                Draw.color((Color)b.team.color, (Color)Color.white, (float)0.25f);
                                Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.85f * fout));
                                Draw.color((Color)Color.black);
                                Fill.circle((float)b.x, (float)b.y, (float)(this.width / 2.155f * fout));
                                Draw.z((float)100.0f);
                                Draw.reset();
                                float f = this.dataRot ? b.fdata : b.rotation() + this.getRotation(b);
                                float maxRange = this.maxRange * fout;
                                float realLength = NHFunc.findLaserLength(b, f, maxRange);
                                Tmp.v1.trns(f, realLength);
                                Tmp.v2.trns(f, 0.0f, this.width / 2.0f * fout);
                                Tmp.v3.setZero();
                                if (realLength < maxRange) {
                                    Tmp.v3.set(Tmp.v2).scl((maxRange - realLength) / maxRange);
                                }
                                Draw.color((Color)Tmp.c1);
                                Tmp.v2.scl(0.9f);
                                Tmp.v3.scl(0.9f);
                                Fill.quad((float)(b.x - Tmp.v2.x), (float)(b.y - Tmp.v2.y), (float)(b.x + Tmp.v2.x), (float)(b.y + Tmp.v2.y), (float)(b.x + Tmp.v1.x + Tmp.v3.x), (float)(b.y + Tmp.v1.y + Tmp.v3.y), (float)(b.x + Tmp.v1.x - Tmp.v3.x), (float)(b.y + Tmp.v1.y - Tmp.v3.y));
                                if (realLength < maxRange) {
                                    Fill.circle((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)Tmp.v3.len());
                                }
                                Tmp.v2.scl(1.2f);
                                Tmp.v3.scl(1.2f);
                                Draw.alpha((float)0.5f);
                                Fill.quad((float)(b.x - Tmp.v2.x), (float)(b.y - Tmp.v2.y), (float)(b.x + Tmp.v2.x), (float)(b.y + Tmp.v2.y), (float)(b.x + Tmp.v1.x + Tmp.v3.x), (float)(b.y + Tmp.v1.y + Tmp.v3.y), (float)(b.x + Tmp.v1.x - Tmp.v3.x), (float)(b.y + Tmp.v1.y - Tmp.v3.y));
                                if (realLength < maxRange) {
                                    Fill.circle((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)Tmp.v3.len());
                                }
                                Draw.alpha((float)1.0f);
                                Draw.color((Color)Color.black);
                                Draw.z((float)(Draw.z() + 0.01f));
                                Tmp.v2.scl(0.5f);
                                Fill.quad((float)(b.x - Tmp.v2.x), (float)(b.y - Tmp.v2.y), (float)(b.x + Tmp.v2.x), (float)(b.y + Tmp.v2.y), (float)(b.x + (Tmp.v1.x + Tmp.v3.x) / 3.0f), (float)(b.y + (Tmp.v1.y + Tmp.v3.y) / 3.0f), (float)(b.x + (Tmp.v1.x - Tmp.v3.x) / 3.0f), (float)(b.y + (Tmp.v1.y - Tmp.v3.y) / 3.0f));
                                Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)(this.width * 1.5f), (Color)this.getColor(b), (float)0.7f);
                                Draw.reset();
                                Draw.z((float)(Draw.z() - 0.01f));
                            }
                        };
                    }

                    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
                        super.shoot(unit, mount, shootX, shootY, rotation);
                        NHFx.crossSpinBlast.at(unit.x, unit.y, unit.rotation, unit.team.color, (Object)unit);
                    }
                });
                this.aiController = SniperAI::new;
                this.targetFlags = new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator, BlockFlag.turret, null};
            }

            public void load() {
                super.load();
                this.uiIcon = this.fullIcon = Core.atlas.find(NewHorizon.name("jump-gate-pointer"));
                this.shadowRegion = this.fullIcon;
            }

            @Override
            public void init() {
                super.init();
                if (this.trailLength < 0) {
                    this.trailLength = 96;
                }
                if (this.slopeEffect == NHFx.boolSelector) {
                    this.slopeEffect = new Effect(30.0f, b -> {
                        if (!(b.data instanceof Integer)) {
                            return;
                        }
                        int i = (Integer)b.data();
                        Draw.color((Color)b.color);
                        Angles.randLenVectors((long)b.id, (int)((int)(b.rotation / 8.0f)), (float)(b.rotation / 4.0f + b.rotation * 2.0f * b.fin()), (x, y) -> Fill.circle((float)(b.x + x), (float)(b.y + y), (float)(b.fout() * b.rotation / 2.25f)));
                        Lines.stroke((float)((i < 0 ? b.fin(Interp.pow2InInverse) : b.fout((Interp)Interp.pow2Out)) * 2.0f));
                        Lines.circle((float)b.x, (float)b.y, (float)((i > 0 ? b.fin(Interp.pow2InInverse) + 0.5f : b.fout((Interp)Interp.pow2Out)) * b.rotation));
                    }).layer(100.0f);
                }
                this.engineSize = 6.0f;
                this.engineSize *= -1.0f;
            }

            public void draw(Unit unit) {
                super.draw(unit);
            }

            public void drawBody(Unit unit) {
                float sizeF = 1.0f + Mathf.absin((float)4.0f, (float)0.1f);
                Draw.z((float)95.0f);
                Draw.color((Color)Color.black);
                Fill.circle((float)unit.x, (float)unit.y, (float)(24.0f * sizeF * 0.71f * unit.healthf()));
                Drawf.light((float)unit.x, (float)unit.y, (float)(unit.hitSize * 4.05f), (Color)unit.team.color, (float)0.68f);
                Draw.z((float)110.001f);
                Draw.color((Color)unit.team.color, (Color)Color.white, (float)(Mathf.absin((float)4.0f, (float)0.3f) + Mathf.clamp((float)unit.hitTime) / 5.0f * 3.0f));
                Draw.alpha((float)0.65f);
                Fill.circle((float)unit.x, (float)unit.y, (float)(24.0f * sizeF * 1.1f));
                Draw.alpha((float)1.0f);
                Fill.circle((float)unit.x, (float)unit.y, (float)(24.0f * sizeF));
                for (float[] j : this.rotator) {
                    for (int i : Mathf.signs) {
                        float ang = Time.time * j[3] + 90.0f + (float)(90 * i) + Mathf.randomSeed((long)unit.id, (float)360.0f);
                        Tmp.v1.trns(ang, this.hitSize * j[4]).add((Position)unit);
                        DrawFunc.arrow(Tmp.v1.x, Tmp.v1.y, j[2], j[0], j[1], ang);
                    }
                }
                Draw.color((Color)Tmp.c1.set(unit.team.color).lerp(Color.white, 0.65f));
                Fill.circle((float)unit.x, (float)unit.y, (float)(24.0f * sizeF * 0.75f * unit.healthf()));
                Draw.color((Color)Color.black);
                Fill.circle((float)unit.x, (float)unit.y, (float)(24.0f * sizeF * 0.7f * unit.healthf()));
                Draw.color((Color)unit.team.color);
                Tmp.v1.set(unit.aimX, unit.aimY).sub((Position)unit).nor().scl(3.6000001f);
                Fill.circle((float)(Tmp.v1.x + unit.x), (float)(Tmp.v1.y + unit.y), (float)(24.0f * sizeF * 0.25f));
                Draw.color((Color)unit.team.color, (Color)Color.white, (float)(Mathf.absin((float)4.0f, (float)0.3f) + 0.45f));
                Tmp.v1.setLength(24.0f * sizeF * 0.06999999f);
                Fill.circle((float)(Tmp.v1.x + unit.x), (float)(Tmp.v1.y + unit.y), (float)(24.0f * sizeF * 0.18f));
                Draw.reset();
            }

            public void update(Unit unit) {
                super.update(unit);
                if (Mathf.chanceDelta((double)0.1)) {
                    for (int i : Mathf.signs) {
                        this.slopeEffect.at(unit.x + Mathf.range((float)24.0f), unit.y + Mathf.range((float)24.0f), 24.0f, unit.team.color, (Object)i);
                    }
                }
            }

            public void drawCell(Unit unit) {
            }

            public void drawItems(Unit unit) {
                super.drawItems(unit);
            }

            public void drawLight(Unit unit) {
                Drawf.light((float)unit.x, (float)unit.y, (float)72.0f, (Color)unit.team.color, (float)this.lightOpacity);
            }

            public void drawMech(Mechc mech) {
            }

            public void drawOutline(Unit unit) {
            }

            public void drawEngines(Unit unit) {
            }

            public void drawTrail(Unit unit) {
            }

            public <T extends Unit> void drawPayload(T unit) {
            }

            public void drawShadow(Unit unit) {
            }

            public void drawShield(Unit unit) {
                float alpha = unit.shieldAlpha();
                float radius = unit.hitSize() * 1.3f;
                Fill.light((float)unit.x, (float)unit.y, (int)Lines.circleVertices((float)radius), (float)radius, (Color)Tmp.c1.set(Pal.shield), (Color)Tmp.c2.set(unit.team.color).a(0.7f).lerp(Color.white, Mathf.clamp((float)(unit.hitTime() / 2.0f))).a(Pal.shield.a * alpha));
            }

            public void drawSoftShadow(Unit unit) {
            }

            public void drawWeapons(Unit unit) {
            }
        };
        collapser = new NHUnitType("collapser"){
            {
                this.outlineColor = OColor;
                this.abilities.add((Object)new ForceFieldAbility(180.0f, 60.0f, 80000.0f, 900.0f, 10, 0.0f));
                this.constructor = EntityMapping.map((int)3);
                this.fallSpeed = 0.008f;
                this.drawShields = false;
                this.faceTarget = false;
                this.immunities = ObjectSet.with((Object[])new StatusEffect[]{NHStatusEffects.weak, NHStatusEffects.emp2, NHStatusEffects.emp3, NHStatusEffects.emp1, NHStatusEffects.scrambler, NHStatusEffects.scannerDown, NHStatusEffects.ultFireBurn, StatusEffects.melting, StatusEffects.burning, StatusEffects.shocked, StatusEffects.electrified});
                this.deathExplosionEffect = new OptionalMultiEffect(NHFx.blast(NHColor.thurmixRed, 400.0f), new Effect(300.0f, 1600.0f, e -> {
                    Rand rand = NHFunc.rand;
                    float rad = 150.0f;
                    rand.setSeed((long)e.id);
                    Draw.color((Color)Color.white, (Color)NHColor.thurmixRed, (float)(e.fin() + 0.6f));
                    float circleRad = e.fin(Interp.circleOut) * rad * 4.0f;
                    Lines.stroke((float)(12.0f * e.fout()));
                    Lines.circle((float)e.x, (float)e.y, (float)circleRad);
                    for (int i2 = 0; i2 < 16; ++i2) {
                        Tmp.v1.set(1.0f, 0.0f).setToRandomDirection(rand).scl(circleRad);
                        DrawFunc.tri(e.x + Tmp.v1.x, e.y + Tmp.v1.y, rand.random(circleRad / 16.0f, circleRad / 12.0f) * e.fout(), rand.random(circleRad / 4.0f, circleRad / 1.5f) * (1.0f + e.fin()) / 2.0f, Tmp.v1.angle() - 180.0f);
                    }
                    e.scaled(120.0f, i -> {
                        Draw.color((Color)Color.white, (Color)NHColor.thurmixRed, (float)(i.fin() + 0.4f));
                        Fill.circle((float)i.x, (float)i.y, (float)(rad * i.fout()));
                        Lines.stroke((float)(18.0f * i.fout()));
                        Lines.circle((float)i.x, (float)i.y, (float)(i.fin(Interp.circleOut) * rad * 1.2f));
                        Angles.randLenVectors((long)i.id, (int)40, (float)(rad / 3.0f), (float)(rad * i.fin((Interp)Interp.pow2Out)), (x, y) -> Lines.lineAngle((float)(i.x + x), (float)(i.y + y), (float)Mathf.angle((float)x, (float)y), (float)(i.fslope() * 25.0f + 10.0f)));
                        if (NHSetting.enableDetails()) {
                            Angles.randLenVectors((long)i.id, (int)((int)(rad / 4.0f)), (float)(rad / 6.0f), (float)(rad * (1.0f + i.fout(Interp.circleOut)) / 1.5f), (x, y) -> {
                                float angle = Mathf.angle((float)x, (float)y);
                                float width = i.foutpowdown() * rand.random(rad / 6.0f, rad / 3.0f);
                                float length = rand.random(rad / 2.0f, rad * 5.0f) * i.fout(Interp.circleOut);
                                Draw.color((Color)NHColor.thurmixRed);
                                DrawFunc.tri(i.x + x, i.y + y, width, rad / 3.0f * i.fout(Interp.circleOut), angle - 180.0f);
                                DrawFunc.tri(i.x + x, i.y + y, width, length, angle);
                                Draw.color((Color)Color.black);
                                DrawFunc.tri(i.x + x, i.y + y, (width *= i.fout()) / 2.0f, rad / 3.0f * i.fout(Interp.circleOut) * 0.9f * i.fout(), angle - 180.0f);
                                DrawFunc.tri(i.x + x, i.y + y, width / 2.0f, length / 1.5f * i.fout(), angle);
                            });
                        }
                        Draw.color((Color)Color.black);
                        Fill.circle((float)i.x, (float)i.y, (float)(rad * i.fout() * 0.75f));
                    });
                    Drawf.light((float)e.x, (float)e.y, (float)(rad * e.fslope() * 4.0f), (Color)NHColor.thurmixRed, (float)0.7f);
                }).layer(110.001f));
                this.fallEffect = NHFx.blast(NHColor.thurmixRed, 120.0f);
                this.targetGround = true;
                this.targetAir = true;
                this.weapons.addAll((Object[])new Weapon[]{NHUnitTypes.copyAndMove(collapserCannon, 60.0f, -50.0f), NHUnitTypes.copyAndMove(collapserCannon, 40.0f, -20.0f), NHUnitTypes.copyAndMove(collapserCannon, 32.0f, 60.0f), new Weapon(NewHorizon.name("collapser-laser")){
                    {
                        super(arg0);
                        this.y = -42.0f;
                        this.x = 0.0f;
                        this.shootY = 25.0f;
                        this.shoot = new ShootSpread(){
                            {
                                this.shots = 3;
                                this.shotDelay = 15.0f;
                                this.spread = 3.0f;
                            }
                        };
                        this.inaccuracy = 3.0f;
                        this.reload = 150.0f;
                        this.rotateSpeed = 1.5f;
                        this.rotate = true;
                        this.top = true;
                        this.shootSound = NHSounds.flak;
                        this.alternate = false;
                        this.mirror = false;
                        this.bullet = NHBullets.collapserBullet;
                    }
                }, new Weapon(){
                    float rangeWeapon = 520.0f;
                    {
                        this.y = 25.425f;
                        this.x = 0.0f;
                        this.shootY = 0.0f;
                        this.shoot = new ShootPattern();
                        this.reload = 900.0f;
                        this.rotateSpeed = 100.0f;
                        this.rotate = true;
                        this.top = false;
                        this.predictTarget = false;
                        this.alternate = false;
                        this.mirror = false;
                        this.heatColor = NHColor.thurmixRed;
                        this.shootSound = NHSounds.hugeShoot;
                        this.bullet = new EffectBulletType(480.0f){
                            {
                                super(lifetime);
                                this.hittable = false;
                                this.collides = false;
                                this.collidesGround = true;
                                this.collidesAir = true;
                                this.collidesTiles = true;
                                this.speed = 100.0f;
                                this.despawnHit = true;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 800.0f;
                                this.splashDamage = 800.0f;
                                this.lightningDamage = 200.0f;
                                this.lightning = 36;
                                this.lightningLength = 60;
                                this.lightningLengthRand = 60;
                                rangeWeapon = 400.0f;
                                this.despawnShake = 40.0f;
                                this.hitShake = 40.0f;
                                clipSize = 800.0f;
                                this.drawSize = 800.0f;
                                this.trailColor = this.lightningColor = NHColor.thurmixRed;
                                this.lightColor = this.lightningColor;
                                this.hitColor = this.lightningColor;
                                this.fragBullets = 22;
                                this.fragBullet = NHBullets.collapserBullet;
                                this.hitSound = NHSounds.hugeBlast;
                                this.hitSoundVolume = 4.0f;
                                this.fragLifeMax = 1.1f;
                                this.fragLifeMin = 0.7f;
                                this.fragVelocityMax = 0.6f;
                                this.fragVelocityMin = 0.2f;
                                this.status = NHStatusEffects.weak;
                                this.statusDuration = 3000.0f;
                                this.shootEffect = NHFx.lightningHitLarge(this.hitColor);
                                this.hitEffect = NHFx.hitSpark(this.hitColor, 240.0f, 220, 900.0f, 8.0f, 27.0f);
                                this.despawnEffect = NHFx.collapserBulletExplode;
                            }

                            protected float calculateRange() {
                                return rangeWeapon;
                            }

                            public void despawned(Bullet b) {
                                super.despawned(b);
                                Vec2 vec = new Vec2().set((Position)b);
                                float damageMulti = b.damageMultiplier();
                                Team team = b.team;
                                int i = 0;
                                while ((float)i < this.splashDamageRadius / 28.0f) {
                                    int finalI = i;
                                    Time.run((float)((float)i * this.despawnEffect.lifetime / (this.splashDamageRadius / 16.0f)), () -> Damage.damage((Team)team, (float)vec.x, (float)vec.y, (float)(8 * (finalI + 6)), (float)(this.splashDamage * damageMulti), (boolean)true));
                                    ++i;
                                }
                                Units.nearby((Team)team, (float)vec.x, (float)vec.y, (float)(this.splashDamageRadius * 2.0f), u -> {
                                    u.heal((1.0f - u.healthf()) / 3.0f * u.maxHealth());
                                    u.apply(StatusEffects.overclock, 360.0f);
                                });
                                Units.nearbyEnemies((Team)team, (float)vec.x, (float)vec.y, (float)(this.splashDamageRadius * 2.0f), u -> u.apply(NHStatusEffects.scannerDown, 600.0f));
                                if (!NHSetting.enableDetails()) {
                                    return;
                                }
                                float rad = 120.0f;
                                float spacing = 2.5f;
                                int k = 0;
                                while ((float)k < (this.despawnEffect.lifetime - NHFx.chainLightningFadeReversed.lifetime) / spacing) {
                                    Time.run((float)((float)k * spacing), () -> {
                                        for (int j : Mathf.signs) {
                                            Vec2 v = Tmp.v6.rnd(rad * 2.0f + Mathf.random((float)(rad * 4.0f))).add(vec);
                                            (j > 0 ? NHFx.chainLightningFade : NHFx.chainLightningFadeReversed).at(v.x, v.y, 12.0f, this.hitColor, (Object)vec);
                                        }
                                    });
                                    ++k;
                                }
                            }

                            public void update(Bullet b) {
                                float rad = 120.0f;
                                Effect.shake((float)(8.0f * b.fin()), (float)6.0f, (Position)b);
                                if (b.timer(1, 12.0f)) {
                                    Seq entites = new Seq();
                                    Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)(rad * 2.5f * (1.0f + b.fin()) / 2.0f), arg_0 -> ((Seq)entites).add(arg_0));
                                    Units.nearbyBuildings((float)b.x, (float)b.y, (float)(rad * 2.5f * (1.0f + b.fin()) / 2.0f), e -> {
                                        if (e.team != b.team) {
                                            entites.add(e);
                                        }
                                    });
                                    entites.shuffle();
                                    entites.truncate(15);
                                    Object object = entites.iterator();
                                    while (object.hasNext()) {
                                        Teamc e2 = (Teamc)object.next();
                                        PosLightning.create((Entityc)b, b.team, (Position)b, (Position)e2, this.lightningColor, false, this.lightningDamage, 5 + Mathf.random((int)5), 2.5f, 1, (Cons<Position>)((Cons)p -> NHFx.lightningHitSmall.at(p.getX(), p.getY(), 0.0f, this.lightningColor)));
                                    }
                                }
                                if (NHSetting.enableDetails() && b.lifetime() - b.time() > NHFx.chainLightningFadeReversed.lifetime) {
                                    for (int i = 0; i < 2; ++i) {
                                        if (!Mathf.chanceDelta((double)(0.2 * (double)Mathf.curve((float)b.fin(), (float)0.0f, (float)0.8f)))) continue;
                                        for (int j : Mathf.signs) {
                                            Sounds.shootArc.at(b.x, b.y, 1.0f, 0.3f);
                                            Vec2 v = Tmp.v6.rnd(rad / 2.0f + Mathf.random((float)(rad * 2.0f)) * (1.0f + Mathf.curve((float)b.fin(), (float)0.0f, (float)0.9f)) / 1.5f).add((Position)b);
                                            (j > 0 ? NHFx.chainLightningFade : NHFx.chainLightningFadeReversed).at(v.x, v.y, 12.0f, this.hitColor, (Object)b);
                                        }
                                    }
                                }
                                if (b.fin() > 0.05f && Mathf.chanceDelta((double)(b.fin() * 0.3f + 0.02f))) {
                                    NHSounds.blaster.at(b.x, b.y, 1.0f, 0.3f);
                                    Tmp.v1.rnd(rad / 4.0f * b.fin());
                                    NHFx.shuttleLerp.at(b.x + Tmp.v1.x, b.y + Tmp.v1.y, Tmp.v1.angle(), this.hitColor, (Object)Float.valueOf(Mathf.random((float)rad, (float)(rad * 3.0f)) * (Mathf.curve((float)b.fin((Interp)Interp.pow2In), (float)0.0f, (float)0.7f) + 2.0f) / 3.0f));
                                }
                            }

                            @Override
                            public void draw(Bullet b) {
                                float fin = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.02f);
                                float f = fin * Mathf.curve((float)b.fout(), (float)0.0f, (float)0.1f);
                                float rad = 120.0f;
                                float z = Draw.z();
                                float circleF = (b.fout((Interp)Interp.pow2In) + 1.0f) / 2.0f;
                                Draw.color((Color)this.hitColor);
                                Lines.stroke((float)(rad / 20.0f * b.fin()));
                                Lines.circle((float)b.x, (float)b.y, (float)(rad * b.fout((Interp)Interp.pow3In)));
                                Lines.circle((float)b.x, (float)b.y, (float)(b.fin(Interp.circleOut) * rad * 3.0f * Mathf.curve((float)b.fout(), (float)0.0f, (float)0.05f)));
                                Rand rand = NHFunc.rand;
                                rand.setSeed((long)b.id);
                                for (int i = 0; i < (int)(rad / 3.0f); ++i) {
                                    Tmp.v1.trns(rand.random(360.0f) + rand.range(1.0f) * rad / 5.0f * b.fin((Interp)Interp.pow2Out), rad / 2.05f * circleF + rand.random(rad * (1.0f + b.fin(Interp.circleOut)) / 1.8f));
                                    float angle = Tmp.v1.angle();
                                    DrawFunc.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, (b.fin() + 1.0f) / 2.0f * 28.0f + (float)rand.random(0, 8), rad / 16.0f * (b.fin((Interp)Interp.exp5In) + 0.25f), angle);
                                    DrawFunc.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, (b.fin() + 1.0f) / 2.0f * 12.0f + (float)rand.random(0, 2), rad / 12.0f * (b.fin((Interp)Interp.exp5In) + 0.5f) / 1.2f, angle - 180.0f);
                                }
                                Angles.randLenVectors((long)(b.id + 1), (int)((int)(rad / 3.0f)), (float)(rad / 4.0f * circleF), (float)(rad * (1.0f + b.fin((Interp)Interp.pow3Out)) / 3.0f), (x, y) -> {
                                    float angle = Mathf.angle((float)x, (float)y);
                                    DrawFunc.tri(b.x + x, b.y + y, rad / 8.0f * (1.0f + b.fout()) / 2.2f, (b.fout() * 3.0f + 1.0f) / 3.0f * 25.0f + (float)rand.random(4, 12) * (b.fout(Interp.circleOut) + 1.0f) / 2.0f, angle);
                                    DrawFunc.tri(b.x + x, b.y + y, rad / 8.0f * (1.0f + b.fout()) / 2.2f, (b.fout() * 3.0f + 1.0f) / 3.0f * 9.0f + (float)rand.random(0, 2) * (b.fin() + 1.0f) / 2.0f, angle - 180.0f);
                                });
                                Drawf.light((float)b.x, (float)b.y, (float)(rad * f * (b.fin() + 1.0f) * 2.0f), (Color)Draw.getColor(), (float)0.7f);
                                Draw.z((float)110.001f);
                                Draw.color((Color)this.hitColor);
                                Fill.circle((float)b.x, (float)b.y, (float)(rad * fin * circleF / 2.0f));
                                Draw.color((Color)NHColor.thurmixRedDark);
                                Fill.circle((float)b.x, (float)b.y, (float)(rad * fin * circleF * 0.75f / 2.0f));
                                Draw.z((float)99.9f);
                                Draw.color((Color)NHColor.thurmixRedDark);
                                Fill.circle((float)b.x, (float)b.y, (float)(rad * fin * circleF * 0.8f / 2.0f));
                                Draw.z((float)z);
                            }
                        };
                    }

                    public void draw(Unit unit, WeaponMount mount) {
                        float z = Draw.z();
                        Tmp.v1.trns(unit.rotation, this.y);
                        float f = 1.0f - mount.reload / this.reload;
                        float rad = 12.0f;
                        float f1 = Mathf.curve((float)f, (float)0.4f, (float)1.0f);
                        Draw.z((float)100.0f);
                        Draw.color((Color)this.heatColor);
                        for (int i : Mathf.signs) {
                            for (int j : Mathf.signs) {
                                DrawFunc.tri(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, f1 * rad / 3.0f + (float)Mathf.num((j > 0 ? 1 : 0) != 0) * 2.0f * (f1 + 1.0f) / 2.0f, (rad * 3.0f + (float)Mathf.num((j > 0 ? 1 : 0) != 0) * 20.0f) * f1, (float)j * Time.time + (float)(90 * i));
                            }
                        }
                        TextureRegion arrowRegion = NHContent.arrowRegion;
                        Tmp.v6.set(mount.aimX, mount.aimY).sub((Position)unit);
                        Tmp.v2.set(mount.aimX, mount.aimY).sub((Position)unit).nor().scl(Math.min(Tmp.v6.len(), this.rangeWeapon)).add((Position)unit);
                        for (int l = 0; l < 4; ++l) {
                            float angle = 45 + 90 * l;
                            for (int i = 0; i < 4; ++i) {
                                Tmp.v3.trns(angle, (float)((i - 4) * 8 + 8)).add(Tmp.v2);
                                float fS = (100.0f - (Time.time + (float)(25 * i)) % 100.0f) / 100.0f * f1 / 4.0f;
                                Draw.rect((TextureRegion)arrowRegion, (float)Tmp.v3.x, (float)Tmp.v3.y, (float)((float)arrowRegion.width * fS), (float)((float)arrowRegion.height * fS), (float)(angle + 90.0f));
                            }
                        }
                        Lines.stroke((float)((1.5f + Mathf.absin((float)(Time.time + 4.0f), (float)8.0f, (float)1.5f)) * f1), (Color)this.heatColor);
                        Lines.square((float)Tmp.v2.x, (float)Tmp.v2.y, (float)(4.0f + Mathf.absin((float)8.0f, (float)4.0f)), (float)45.0f);
                        Lines.stroke((float)(rad / 2.5f * mount.heat), (Color)this.heatColor);
                        Lines.circle((float)(unit.x + Tmp.v1.x), (float)(unit.y + Tmp.v1.y), (float)(rad * 2.0f * (1.0f - mount.heat)));
                        Draw.color((Color)this.heatColor);
                        Fill.circle((float)(unit.x + Tmp.v1.x), (float)(unit.y + Tmp.v1.y), (float)(f * rad));
                        Lines.stroke((float)(f * 1.5f));
                        DrawFunc.circlePercentFlip(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, f * rad + 5.0f, Time.time, 20.0f);
                        Draw.color((Color)Color.white);
                        Fill.circle((float)(unit.x + Tmp.v1.x), (float)(unit.y + Tmp.v1.y), (float)(f * rad * 0.7f));
                        Draw.z((float)z);
                    }

                    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
                        this.shootSound.at(shootX, shootY, Mathf.random((float)this.soundPitchMin, (float)this.soundPitchMax));
                        BulletType ammo = this.bullet;
                        float lifeScl = ammo.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)shootX, (float)shootY, (float)mount.aimX, (float)mount.aimY) / ammo.range)) : 1.0f;
                        Tmp.v6.set(mount.aimX, mount.aimY).sub((Position)unit);
                        Tmp.v1.set(mount.aimX, mount.aimY).sub((Position)unit).nor().scl(Math.min(Tmp.v6.len(), this.rangeWeapon)).add((Position)unit);
                        Bullet b = this.bullet.create((Entityc)unit, unit.team, Tmp.v1.x, Tmp.v1.y, 0.0f);
                        b.vel.setZero();
                        b.set((Position)Tmp.v1);
                        unit.apply(this.shootStatus, this.shootStatusDuration);
                        if (Vars.headless) {
                            return;
                        }
                        Vec2 vec2 = new Vec2().trns(unit.rotation, this.y).add((Position)unit);
                        PosLightning.createEffect((Position)vec2, (Position)b, NHColor.thurmixRed, 3, 2.5f);
                        for (int i = 0; i < 5; ++i) {
                            Time.run((float)((float)i * 6.0f), () -> NHFx.chainLightningFade.at(vec2.x, vec2.y, (float)Mathf.random((int)8, (int)14), NHColor.thurmixRed, (Object)b));
                        }
                        ammo.shootEffect.at(shootX, shootY, rotation);
                        ammo.smokeEffect.at(shootX, shootY, rotation);
                    }
                }});
                this.hitSize = 140.0f;
                this.speed = 0.5f;
                this.health = 180000.0f;
                this.rotateSpeed = 0.65f;
                this.engineSize = 30.0f;
                this.buildSpeed = 10.0f;
                this.engineOffset = 68.0f;
                this.itemCapacity = 300;
                this.armor = 180.0f;
                this.lowAltitude = true;
                this.flying = true;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(43.25f, -79.5f, 10.0f, 315.0f)});
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                NHPixmap.createIcons(packer, this);
            }

            public void drawCell(Unit unit) {
                super.drawCell(unit);
                Draw.z((float)110.001f);
                Draw.color((Color)unit.team.color, (Color)Color.white, (float)Mathf.absin((float)4.0f, (float)0.3f));
                Lines.stroke((float)(3.0f + Mathf.absin((float)10.0f, (float)0.55f)));
                DrawFunc.circlePercent(unit.x, unit.y, unit.hitSize, unit.healthf(), 0.0f);
                for (int i = 0; i < 4; ++i) {
                    float rotation = Time.time * 1.5f + (float)(i * 90);
                    Tmp.v1.trns(rotation, this.hitSize * 1.1f).add((Position)unit);
                    Draw.rect((TextureRegion)NHContent.arrowRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)(rotation + 90.0f));
                }
                Draw.z((float)90.0f);
                Draw.reset();
            }
        };
    }

    public static Weapon copyAnd(Weapon weapon, Cons<Weapon> modifier) {
        Weapon n = weapon.copy();
        modifier.get((Object)n);
        return n;
    }

    public static Weapon copyAndMove(Weapon weapon, float x, float y) {
        Weapon n = weapon.copy();
        n.x = x;
        n.y = y;
        return n;
    }

    public static Weapon copyAndMoveAnd(Weapon weapon, float x, float y, Cons<Weapon> modifier) {
        Weapon n = weapon.copy();
        n.x = x;
        n.y = y;
        modifier.get((Object)n);
        return n;
    }

    public static void immunise(UnitType type) {
        if (statuses == null) {
            statuses = Vars.content.statusEffects().copy();
            statuses.retainAll(s -> s.disarm || s.damage > 0.0f || s.healthMultiplier * s.reloadMultiplier * s.buildSpeedMultiplier * s.speedMultiplier < 1.0f);
            statuses.add((Object)NHStatusEffects.scannerDown);
            statuses.remove((Object)StatusEffects.overclock);
            statuses.remove((Object)StatusEffects.overdrive);
            statuses.remove((Object)NHStatusEffects.stronghold);
            statuses.remove((Object)NHStatusEffects.quantization);
            statuses.add((Object)StatusEffects.wet);
            statuses.add((Object)StatusEffects.unmoving);
        }
        type.immunities.addAll(statuses);
    }

    static {
        EntityMapping.nameMap.put((Object)NewHorizon.name("destruction"), (Object)EntityMapping.idMap[3]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("declining"), (Object)EntityMapping.idMap[20]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("zarkov"), (Object)EntityMapping.idMap[20]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("ghost"), (Object)EntityMapping.idMap[20]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("relay"), (Object)EntityMapping.idMap[20]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("saviour"), (Object)EntityMapping.idMap[5]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("liv"), (Object)EntityMapping.idMap[5]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("air-raid-missile"), AdaptedTimedKillUnit::new);
        EntityMapping.nameMap.put((Object)NewHorizon.name("origin"), (Object)EntityMapping.idMap[4]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("thynomo"), (Object)EntityMapping.idMap[4]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("aliotiat"), (Object)EntityMapping.idMap[4]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("tarlidor"), (Object)EntityMapping.idMap[4]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("annihilation"), (Object)EntityMapping.idMap[4]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("sin"), (Object)EntityMapping.idMap[4]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("pester"), PesterEntity::new);
        EntityMapping.nameMap.put((Object)NewHorizon.name("laugra"), (Object)EntityMapping.idMap[43]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("nucleoid"), NucleoidEntity::new);
        EntityMapping.nameMap.put((Object)NewHorizon.name("restriction-enzyme"), (Object)EntityMapping.idMap[24]);
        EntityMapping.nameMap.put((Object)NewHorizon.name("ancient-probe"), ProbeEntity::new);
        EntityMapping.nameMap.put((Object)NewHorizon.name("guardian"), EnergyUnit::new);
    }
}

