/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Geometry;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.liquid.LiquidJunction;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.meta.BuildVisibility;
import newhorizon.content.NHItems;
import newhorizon.expand.block.distribution.item.AdaptStackConveyor;
import newhorizon.expand.block.distribution.item.logistics.AdaptDirectionalGate;
import newhorizon.expand.block.distribution.item.logistics.AdaptDirectionalMerger;
import newhorizon.expand.block.distribution.item.logistics.AdaptDirectionalRouter;
import newhorizon.expand.block.distribution.item.logistics.AdaptDirectionalUnloader;
import newhorizon.expand.block.distribution.item.logistics.AdaptGate;
import newhorizon.expand.block.distribution.item.logistics.AdaptItemBridge;
import newhorizon.expand.block.distribution.item.logistics.AdaptJunction;
import newhorizon.expand.block.distribution.item.logistics.AdaptSorter;
import newhorizon.expand.block.distribution.item.logistics.AdaptUnloader;
import newhorizon.expand.block.distribution.liquid.AdaptConduit;
import newhorizon.expand.block.distribution.liquid.AdaptLiquidBridge;
import newhorizon.expand.block.distribution.liquid.AdaptLiquidDirectionalUnloader;
import newhorizon.util.graphic.SpriteUtil;

public class DistributionBlock {
    public static Block conveyor;
    public static Block logisticsJunction;
    public static Block logisticsDirectionalRouter;
    public static Block logisticsDirectionalMerger;
    public static Block logisticsDirectionalGate;
    public static Block logisticsOmniGate;
    public static Block logisticsOmniSorter;
    public static Block logisticsOmniBlocker;
    public static Block conveyorBridge;
    public static Block conveyorBridgeExtend;
    public static Block conveyorUnloader;
    public static Block rapidUnloader;
    public static Block stackRail;
    public static Block steadyStackRail;
    public static Block lightStackLoader;
    public static Block heavyStackLoader;
    public static Block conduit;
    public static Block conduitJunction;
    public static Block conduitRouter;
    public static Block liquidBridge;
    public static Block liquidBridgeExtend;
    public static Block liquidUnloader;

    public static void load() {
        conveyor = new Conveyor("hard-light-rail"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.health = 300;
                this.speed = 0.115f;
                this.displayedSpeed = 15.0f;
                this.placeableLiquid = true;
                this.drawTeamOverlay = false;
                this.buildType = () -> new Conveyor.ConveyorBuild(){

                    public void draw() {
                        Draw.mixcol((Color)this.team.color, (float)0.5f);
                        int frame = this.enabled && this.clogHeat <= 0.5f ? (int)(Time.time * speed * 8.0f * this.timeScale * this.efficiency % 4.0f) : 0;
                        Draw.z((float)29.5f);
                        for (int i = 0; i < 4; ++i) {
                            if ((this.blending & 1 << i) == 0) continue;
                            int dir = this.rotation - i;
                            float rot = i == 0 ? (float)(this.rotation * 90) : (float)(dir * 90);
                            Draw.rect((TextureRegion)this.sliced(regions[0][frame], i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top), (float)(this.x + (float)(Geometry.d4x((int)dir) * 8) * 0.75f), (float)(this.y + (float)(Geometry.d4y((int)dir) * 8) * 0.75f), (float)rot);
                        }
                        Draw.z((float)29.8f);
                        Draw.rect((TextureRegion)regions[this.blendbits][frame], (float)this.x, (float)this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
                        Draw.mixcol();
                        float layer = 29.9f;
                        float wwidth = Vars.world.unitWidth();
                        float wheight = Vars.world.unitHeight();
                        float scaling = 0.01f;
                        for (int i = 0; i < this.len; ++i) {
                            Item item = this.ids[i];
                            Tmp.v1.trns((float)(this.rotation * 90), 8.0f, 0.0f);
                            Tmp.v2.trns((float)(this.rotation * 90), -4.0f, this.xs[i] * 8.0f / 2.0f);
                            float ix = this.x + Tmp.v1.x * this.ys[i] + Tmp.v2.x;
                            float iy = this.y + Tmp.v1.y * this.ys[i] + Tmp.v2.y;
                            Draw.z((float)(layer + (ix / wwidth + iy / wheight) * scaling));
                            Draw.rect((TextureRegion)item.fullIcon, (float)ix, (float)iy, (float)5.0f, (float)5.0f);
                        }
                    }
                };
            }

            public void load() {
                super.load();
                this.regions = SpriteUtil.split((TextureRegion)Core.atlas.find(this.name + "-full"), 32, 32, 1);
            }

            public TextureRegion[] icons() {
                return new TextureRegion[]{Core.atlas.find(this.name)};
            }
        };
        stackRail = new AdaptStackConveyor("stack-rail"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1, NHItems.presstanium, 1, NHItems.juniorProcessor, 1}));
                this.health = 300;
                this.speed = 0.1f;
                this.canOverdrive = false;
                this.placeableLiquid = true;
            }
        };
        steadyStackRail = new AdaptStackConveyor("steady-stack-rail"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10, NHItems.multipleSteel, 1, NHItems.seniorProcessor, 1}));
                this.health = 600;
                this.speed = 0.3f;
                this.canOverdrive = false;
                this.placeableLiquid = true;
            }
        };
        lightStackLoader = new AdaptStackConveyor("light-stack-loader"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 5, NHItems.presstanium, 10, NHItems.juniorProcessor, 10}));
                this.health = 300;
                this.speed = 0.1f;
                this.itemCapacity = 15;
                this.onlyCarry = false;
                this.canOverdrive = false;
                this.placeableLiquid = true;
            }
        };
        heavyStackLoader = new AdaptStackConveyor("heavy-stack-loader"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10, NHItems.multipleSteel, 10, NHItems.seniorProcessor, 10}));
                this.health = 600;
                this.speed = 0.1f;
                this.itemCapacity = 60;
                this.onlyCarry = false;
                this.canOverdrive = false;
                this.placeableLiquid = true;
            }
        };
        conveyorBridge = new AdaptItemBridge("logistics-bridge"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 5, Items.silicon, 4}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.hasPower = false;
                this.range = 6;
                this.health = 300;
                this.placeableLiquid = true;
            }
        };
        conveyorBridgeExtend = new AdaptItemBridge("logistics-extend-bridge"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10, NHItems.multipleSteel, 5}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.hasPower = false;
                this.range = 12;
                this.health = 600;
                this.placeableLiquid = true;
            }
        };
        logisticsJunction = new AdaptJunction("logistics-junction"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.health = 300;
                this.speed = 3.0f;
                this.capacity = 1;
                this.placeableLiquid = true;
            }
        };
        logisticsDirectionalRouter = new AdaptDirectionalRouter("logistics-directional-router"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.health = 300;
                this.speed = 4.0f;
                this.placeableLiquid = true;
            }
        };
        logisticsDirectionalMerger = new AdaptDirectionalMerger("logistics-directional-merger"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.health = 300;
                this.speed = 4.0f;
                this.placeableLiquid = true;
            }
        };
        logisticsDirectionalGate = new AdaptDirectionalGate("logistics-directional-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.health = 300;
                this.speed = 4.0f;
                this.placeableLiquid = true;
            }
        };
        logisticsOmniGate = new AdaptGate("logistics-omni-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.placeableLiquid = true;
                this.health = 300;
            }
        };
        logisticsOmniSorter = new AdaptSorter("logistics-omni-sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.invert = false;
                this.placeableLiquid = true;
                this.health = 300;
            }
        };
        logisticsOmniBlocker = new AdaptSorter("logistics-omni-blocker"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.invert = true;
                this.placeableLiquid = true;
                this.health = 300;
            }
        };
        conveyorUnloader = new AdaptDirectionalUnloader("logistics-unloader"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.health = 300;
                this.speed = 3.6363637f;
                this.hasPower = true;
                this.conductivePower = true;
                this.placeableLiquid = true;
            }
        };
        rapidUnloader = new AdaptUnloader("rapid-unloader"){
            {
                this.requirements(Category.distribution, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10, Items.silicon, 4}));
                this.health = 300;
                this.speed = 0.5f;
                this.placeableLiquid = true;
            }
        };
        conduit = new AdaptConduit("conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1, Items.silicon, 1}));
                this.health = 300;
                this.liquidCapacity = 150.0f;
                this.liquidPressure = 1.2f;
                this.leaks = false;
                this.placeableLiquid = true;
            }
        };
        conduitJunction = new LiquidJunction("logistics-liquid-junction"){
            {
                this.requirements(Category.liquid, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1, Items.silicon, 4}));
                this.placeableLiquid = true;
                this.solid = false;
                this.underBullets = true;
                this.health = 300;
            }
        };
        conduitRouter = new LiquidRouter("logistics-liquid-router"){
            {
                this.requirements(Category.liquid, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 1, Items.silicon, 4}));
                this.placeableLiquid = true;
                this.solid = false;
                this.underBullets = true;
                this.health = 300;
                this.liquidCapacity = 250.0f;
            }
        };
        liquidBridge = new AdaptLiquidBridge("logistics-liquid-bridge"){
            {
                this.requirements(Category.liquid, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 5, Items.silicon, 4}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.hasPower = false;
                this.range = 6;
                this.health = 300;
                this.liquidCapacity = 250.0f;
                this.placeableLiquid = true;
            }
        };
        liquidBridgeExtend = new AdaptLiquidBridge("logistics-extend-liquid-bridge"){
            {
                this.requirements(Category.liquid, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10, NHItems.multipleSteel, 5}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.hasPower = false;
                this.range = 12;
                this.health = 600;
                this.liquidCapacity = 250.0f;
                this.placeableLiquid = true;
            }
        };
        ((AdaptConduit)DistributionBlock.conduit).junctionReplacement = conduitJunction;
        ((AdaptConduit)DistributionBlock.conduit).bridgeReplacement = liquidBridge;
        liquidUnloader = new AdaptLiquidDirectionalUnloader("logistics-liquid-unloader"){
            {
                this.requirements(Category.liquid, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 5}));
                this.buildVisibility = BuildVisibility.shown;
                this.alwaysUnlocked = true;
                this.hasPower = true;
                this.conductivePower = true;
                this.placeableLiquid = true;
                this.health = 300;
                this.liquidCapacity = 250.0f;
            }
        };
        ((Conveyor)DistributionBlock.conveyor).junctionReplacement = logisticsJunction;
        ((Conveyor)DistributionBlock.conveyor).bridgeReplacement = conveyorBridge;
    }
}

