/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.power.Battery;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawGlowRegion;
import mindustry.world.draw.DrawLiquidTile;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawParticles;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BuildVisibility;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.expand.block.drawer.DrawRegionFlip;
import newhorizon.expand.block.drawer.DrawRegionRotated;
import newhorizon.expand.block.power.GravityWell;
import newhorizon.expand.block.production.factory.RecipeGenericCrafter;
import newhorizon.expand.draw.DrawLiquidAnimatedOffset;
import newhorizon.expand.draw.DrawLiquidSmelt;
import newhorizon.expand.draw.DrawPistonsOffset;
import newhorizon.expand.draw.DrawRegionOffset;
import newhorizon.util.graphic.EffectWrapper;

public class PowerBlock {
    public static Block nitrogenDissociator;
    public static Block crystalDecompositionThermalGenerator;
    public static Block hydroFuelCell;
    public static Block zetaGenerator;
    public static Block anodeFusionReactor;
    public static Block cathodeFusionReactor;
    public static Block thermoReactor;
    public static Block armorBattery;
    public static Block armorBatteryLarge;
    public static Block armorBatteryHuge;
    public static Block gravityTrapMidantha;
    public static Block gravityTrapSerpulo;
    public static Block gravityTrapErekir;
    public static Block gravityTrapSmall;
    public static Block gravityTrap;

    public static void load() {
        gravityTrapSmall = new GravityWell("gravity-trap"){
            {
                this.requirements(Category.power, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{Items.titanium, 10, Items.tungsten, 8}));
                this.size = 2;
                this.health = 640;
                this.gravityRange = 64.0f;
            }
        };
        gravityTrap = new GravityWell("gravity-trap-heavy"){
            {
                this.requirements(Category.power, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 15, NHItems.multipleSteel, 20}));
                this.size = 3;
                this.health = 1250;
                this.gravityRange = 120.0f;
            }
        };
        armorBattery = new Battery("armor-battery"){
            {
                this.requirements(Category.power, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 10, NHItems.juniorProcessor, 5}));
                this.size = 1;
                this.health = 600;
                this.armor = 20.0f;
                this.consumePowerBuffered(10000.0f);
            }
        };
        armorBatteryLarge = new Battery("armor-battery-large"){
            {
                this.requirements(Category.power, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 40, NHItems.juniorProcessor, 10, NHItems.zeta, 50}));
                this.size = 3;
                this.health = 2000;
                this.armor = 30.0f;
                this.consumePowerBuffered(100000.0f);
            }
        };
        armorBatteryHuge = new Battery("armor-battery-huge"){
            {
                this.requirements(Category.power, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 60, NHItems.seniorProcessor, 40, NHItems.zeta, 200}));
                this.size = 5;
                this.health = 5000;
                this.armor = 50.0f;
                this.consumePowerBuffered(1000000.0f);
            }
        };
        crystalDecompositionThermalGenerator = new RecipeGenericCrafter("crystal-decomposition-thermal-generator"){
            {
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 10, NHItems.graphite, 25, NHItems.silicon, 25}));
                this.addLink(new int[]{2, 0, 1, 2, 1, 1});
                this.size = 2;
                this.health = 300;
                this.armor = 2.0f;
                this.itemCapacity = 20;
                this.liquidCapacity = 30.0f;
                this.powerProduction = 8.0f;
                this.outputsPower = true;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-base";
                        this.x = 4.0f;
                        this.layer = 29.0f;
                    }
                }, new DrawRegionRotated(){
                    {
                        this.suffix = "-rot";
                        this.x = 4.0f;
                    }
                }, new DrawRegionOffset("-glow", 4.0f, 0.0f, true, 0.1f), new DrawLiquidSmelt(){
                    {
                        this.x = -1.0f;
                        this.y = 0.0f;
                        this.fixedAlpha = 0.68f;
                        this.flameRad = 1.0f;
                        this.circleSpace = 1.8f;
                        this.circleStroke = 1.0f;
                        this.colorLerp = 0.08f;
                        this.particles = 4;
                        this.particleLen = 1.0f;
                    }
                }, new DrawLiquidAnimatedOffset(){
                    {
                        this.alpha = 1.0f;
                        this.offsetX = 2.0f;
                        this.offsetY = 0.0f;
                        this.glow = false;
                    }
                }, new DrawPistonsOffset(){
                    {
                        this.sides = 1;
                        this.sinMag = 0.0f;
                        this.sinScl = 0.0f;
                        this.lenOffset = -1.0f;
                        this.angleOffset = 0.0f;
                        this.offsetX = 5.0f;
                        this.offsetY = 0.0f;
                        this.suffix = "-piston-t";
                    }
                }, new DrawPistonsOffset(){
                    {
                        this.sides = 1;
                        this.sinMag = 2.5f;
                        this.sinScl = 6.0f;
                        this.lenOffset = -1.0f;
                        this.angleOffset = 0.0f;
                        this.offsetX = 5.1f;
                        this.offsetY = 0.0f;
                        this.suffix = "-piston";
                    }
                }, new DrawPistonsOffset(){
                    {
                        this.sides = 1;
                        this.sinMag = 2.5f;
                        this.sinScl = 6.0f;
                        this.lenOffset = -1.0f;
                        this.angleOffset = 0.0f;
                        this.sinOffset = 1.5707964f;
                        this.offsetX = 5.1f;
                        this.offsetY = 0.0f;
                        this.suffix = "-piston1";
                    }
                }});
            }
        };
        nitrogenDissociator = new RecipeGenericCrafter("nitrogen-dissociator"){
            {
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 50, NHItems.juniorProcessor, 20, Items.silicon, 100}));
                this.health = 300;
                this.size = 3;
                this.rotate = false;
                this.itemCapacity = 30;
                this.liquidCapacity = 100.0f;
                this.outputsPower = true;
                this.powerProduction = 5.0f;
                this.ignoreLiquidFullness = true;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.nitrogen, 4.1f), new DrawDefault(), new DrawParticles(){
                    {
                        this.color = Color.valueOf((String)"d4f0ff");
                        this.alpha = 0.6f;
                        this.particleSize = 4.0f;
                        this.particles = 10;
                        this.particleRad = 12.0f;
                        this.particleLife = 140.0f;
                    }
                }});
            }
        };
        hydroFuelCell = new ConsumeGenerator("hydro-fuel-cell"){
            {
                this.size = 2;
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.metalOxhydrigen, 60, NHItems.juniorProcessor, 45, NHItems.presstanium, 60}));
                this.lightColor = Pal.techBlue;
                this.consumeEffect = EffectWrapper.wrap(NHFx.hugeSmokeLong, Liquids.hydrogen.color.cpy().lerp(Liquids.nitrogen.color, 0.4f).a(0.56f));
                this.generateEffect = new Effect(45.0f, e -> {
                    Draw.color((Color)this.lightColor, (Color)Color.white, (float)(e.fin() * 0.66f));
                    Lines.stroke((float)(e.fout() * 1.375f));
                    Lines.spikes((float)e.x, (float)e.y, (float)(0.45f + 5.0f * e.finpow()), (float)(5.5f * e.fout()), (int)4, (float)45.0f);
                });
                this.powerProduction = 30.0f;
                this.health = 320;
                this.itemCapacity = 40;
                this.liquidCapacity = 30.0f;
                this.itemDuration = 240.0f;
                this.consumeItem(NHItems.metalOxhydrigen, 4);
                this.consumeLiquid(Liquids.nitrogen, 0.033333335f);
                this.squareSprite = false;
                this.hasItems = true;
                this.hasLiquids = true;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.nitrogen, 2.0f), new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.color = Liquids.hydrogen.color;
                    }
                }});
            }
        };
        zetaGenerator = new RecipeGenericCrafter("zeta-generator"){
            {
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.metalOxhydrigen, 120, NHItems.juniorProcessor, 80, NHItems.zeta, 100, NHItems.carbide, 150}));
                this.size = 3;
                this.health = 1350;
                this.armor = 10.0f;
                this.itemCapacity = 30;
                this.liquidCapacity = 30.0f;
                this.rotate = false;
                this.powerProduction = 50.0f;
                this.outputsPower = true;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(NHLiquids.xenFluid), new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.color = NHItems.zeta.color;
                    }
                }});
                this.lightColor = NHItems.zeta.color.cpy().lerp(Color.white, 0.125f);
                this.updateEffect = this.craftEffect = NHFx.square(this.lightColor, 30.0f, 5, 20.0f, 4.0f);
            }
        };
        anodeFusionReactor = new RecipeGenericCrafter("anode-fusion-reactor"){
            {
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 300, NHItems.phaseFabric, 300, NHItems.surgeAlloy, 450, NHItems.carbide, 600, NHItems.multipleSteel, 240}));
                this.addLink(new int[]{-2, -1, 1, -2, 0, 1, -2, 1, 1, -2, 2, 1, 3, -1, 1, 3, 0, 1, 3, 1, 1, 3, 2, 1});
                this.size = 4;
                this.health = 3000;
                this.armor = 10.0f;
                this.itemCapacity = 45;
                this.liquidCapacity = 45.0f;
                this.outputsPower = true;
                this.powerProduction = 200.0f;
                this.drawer = new DrawRegionFlip("-rot");
                this.lightColor = NHItems.zeta.color.cpy().lerp(Color.white, 0.125f);
                this.updateEffect = this.craftEffect = NHFx.square(this.lightColor, 30.0f, 5, 20.0f, 4.0f);
            }
        };
        cathodeFusionReactor = new RecipeGenericCrafter("cathode-fusion-reactor"){
            {
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 300, NHItems.phaseFabric, 300, NHItems.surgeAlloy, 450, NHItems.carbide, 600, NHItems.multipleSteel, 240}));
                this.addLink(new int[]{-2, -1, 1, -2, 0, 1, -2, 1, 1, -2, 2, 1, 3, -1, 1, 3, 0, 1, 3, 1, 1, 3, 2, 1});
                this.size = 4;
                this.health = 3000;
                this.armor = 10.0f;
                this.itemCapacity = 45;
                this.liquidCapacity = 45.0f;
                this.outputsPower = true;
                this.powerProduction = 200.0f;
                this.drawer = new DrawRegionFlip("-rot");
                this.lightColor = NHItems.zeta.color.cpy().lerp(Color.white, 0.125f);
                this.updateEffect = this.craftEffect = NHFx.square(this.lightColor, 30.0f, 5, 20.0f, 4.0f);
            }
        };
        thermoReactor = new RecipeGenericCrafter("thermo-reactor"){
            {
                this.requirements(Category.power, ItemStack.with((Object[])new Object[]{NHItems.phaseFabric, 300, NHItems.surgeAlloy, 450, NHItems.carbide, 600, NHItems.multipleSteel, 240}));
                this.addLink(new int[]{-1, 3, 2, 1, 3, 1, 1, 4, 1, 3, 0, 2, 3, -1, 1, 4, -1, 1, -1, -4, 2, 1, -4, 1, 1, -3, 1, -4, -1, 2, -4, 1, 1, -3, 1, 1});
                this.size = 5;
                this.health = 10000;
                this.rotate = false;
                this.armor = 20.0f;
                this.itemCapacity = 45;
                this.liquidCapacity = 45.0f;
                this.powerProduction = 1500.0f;
                this.outputsPower = true;
                this.drawer = new DrawDefault();
                this.lightColor = NHItems.zeta.color.cpy().lerp(Color.white, 0.125f);
                this.updateEffect = this.craftEffect = NHFx.square(this.lightColor, 30.0f, 5, 20.0f, 4.0f);
            }
        };
    }
}

