/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.meta.Stat;
import newhorizon.expand.block.inner.LinkBlock;
import newhorizon.expand.block.production.factory.MultiBlock;
import newhorizon.expand.block.production.factory.MultiBlockEntity;

public abstract class BasicMultiBlock
extends Block
implements MultiBlock {
    public Seq<Point2> linkPos = new Seq();
    public IntSeq linkSize = new IntSeq();
    public boolean canMirror = true;
    public int[] rotations = new int[]{0, 1, 2, 3, 0, 1, 2, 3};
    public final int checkTimer = this.timers++;

    public BasicMultiBlock(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.size);
        this.stats.add(Stat.size, "@x@", new Object[]{this.getMaxSize((int)this.size, (int)0).x, this.getMaxSize((int)this.size, (int)0).y});
    }

    @Override
    public Seq<Point2> linkBlockPos() {
        return this.linkPos;
    }

    @Override
    public IntSeq linkBlockSize() {
        return this.linkSize;
    }

    @Override
    public Block mirrorBlock() {
        return this;
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return super.canPlaceOn(tile, team, rotation) && this.checkLink(tile, team, this.size, rotation);
    }

    public void placeBegan(Tile tile, Block previous) {
        this.createPlaceholder(tile, this.size);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> {
            if (rotation % 2 == 0) {
                return Math.abs(point.x - other.x) == this.getMaxSize((int)this.size, (int)rotation).x;
            }
            return Math.abs(point.y - other.y) == this.getMaxSize((int)this.size, (int)rotation).y;
        });
    }

    public void flipRotation(BuildPlan req, boolean x) {
        if (this.canMirror) {
            if (this.mirrorBlock() != null) {
                req.rotation = this.rotations[req.rotation + (x ? 0 : 4)];
            }
        } else {
            super.flipRotation(req, x);
        }
    }

    public class BasicMultiBuilding
    extends Building
    implements MultiBlockEntity {
        public boolean linkCreated = false;
        public Seq<Building> linkEntities;
        public Seq<Building[]> linkProximityMap;
        public Tile teamPos;
        public Tile statusPos;
        public int dumpIndex = 0;

        public void created() {
            super.created();
            this.linkProximityMap = new Seq();
            if (BasicMultiBlock.this.instantBuild || !Vars.state.rules.editor && Vars.state.rules.instantBuild && Vars.state.rules.infiniteResources) {
                this.linkEntities = BasicMultiBlock.this.setLinkBuild(this, this.block, this.tile, this.team, BasicMultiBlock.this.size, this.rotation);
                this.linkCreated = true;
                this.updateLinkProximity();
            }
        }

        public void updateTile() {
            if (this.isPayload()) {
                return;
            }
            if (!this.linkCreated) {
                this.linkEntities = BasicMultiBlock.this.setLinkBuild(this, this.block, this.tile, this.team, BasicMultiBlock.this.size, this.rotation);
                this.linkCreated = true;
                this.updateLinkProximity();
            }
            if (this.timer(BasicMultiBlock.this.checkTimer, 600.0f)) {
                boolean linkValid = true;
                for (Tile t : BasicMultiBlock.this.getLinkTiles(this.tile, BasicMultiBlock.this.size, this.rotation)) {
                    Building building = t.build;
                    if (building instanceof LinkBlock.LinkBuild) {
                        LinkBlock.LinkBuild lb = (LinkBlock.LinkBuild)building;
                        if (lb.linkBuild == this && lb.isValid()) continue;
                    }
                    linkValid = false;
                    break;
                }
                if (!linkValid) {
                    this.linkEntities.each(Building::kill);
                    this.kill();
                }
            }
            super.updateTile();
        }

        @Override
        public void updateLinkProximity() {
            if (this.linkEntities != null) {
                this.linkProximityMap.clear();
                for (Building link : this.linkEntities) {
                    for (Building linkProx : link.proximity) {
                        if (linkProx == this || this.linkEntities.contains((Object)linkProx) || !this.checkValidPair(linkProx, link)) continue;
                        this.linkProximityMap.add((Object)new Building[]{linkProx, link});
                    }
                }
                for (Building prox : this.proximity) {
                    if (this.linkEntities.contains((Object)prox) || !this.checkValidPair(prox, this)) continue;
                    this.linkProximityMap.add((Object)new Building[]{prox, this});
                }
            }
        }

        public boolean checkValidPair(Building target, Building source) {
            for (Building[] pair : this.linkProximityMap) {
                Building pairTarget = pair[0];
                Building pairSource = pair[1];
                if (target != pairTarget || target.relativeTo(pairSource) != target.relativeTo(source)) continue;
                return false;
            }
            return true;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.updateLinkProximity();
        }

        public void onRemoved() {
            BasicMultiBlock.this.createPlaceholder(this.tile, BasicMultiBlock.this.size);
        }

        public void incrementDumpIndex(int prox) {
            this.dumpIndex = (this.dumpIndex + 1) % prox;
        }

        public boolean dump(Item todump) {
            if (!this.block.hasItems || this.items.total() == 0 || this.linkProximityMap.size == 0 || todump != null && !this.items.has(todump)) {
                return false;
            }
            int dump = this.dumpIndex;
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (todump == null) {
                    for (int ii = 0; ii < Vars.content.items().size; ++ii) {
                        Item item;
                        if (!this.items.has(ii) || !target.acceptItem(source, item = (Item)Vars.content.items().get(ii)) || !this.canDump(target, item)) continue;
                        target.handleItem(source, item);
                        this.items.remove(item, 1);
                        this.incrementDumpIndex(this.linkProximityMap.size);
                        return true;
                    }
                } else if (target.acceptItem(source, todump) && this.canDump(target, todump)) {
                    target.handleItem(source, todump);
                    this.items.remove(todump, 1);
                    this.incrementDumpIndex(this.linkProximityMap.size);
                    return true;
                }
                this.incrementDumpIndex(this.linkProximityMap.size);
            }
            return false;
        }

        public void dumpLiquid(Liquid liquid, float scaling, int outputDir) {
            int dump = this.cdump;
            if (this.liquids.get(liquid) <= 1.0E-4f) {
                return;
            }
            if (!Vars.net.client() && Vars.state.isCampaign() && this.team == Vars.state.rules.defaultTeam) {
                liquid.unlock();
            }
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                float fract;
                float ofract;
                this.incrementDumpIndex(this.linkProximityMap.size);
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (outputDir != -1 && (outputDir + this.rotation) % 4 != this.relativeTo(target) || (target = target.getLiquidDestination(source, liquid)) == null || !target.block.hasLiquids || !this.canDumpLiquid(target, liquid) || target.liquids == null || !((ofract = target.liquids.get(liquid) / target.block.liquidCapacity) < (fract = this.liquids.get(liquid) / this.block.liquidCapacity))) continue;
                this.transferLiquid(target, (fract - ofract) * this.block.liquidCapacity / scaling, liquid);
            }
        }

        public boolean dumpPayload(Payload todump) {
            int dump = this.dumpIndex;
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (todump != null && this.getPayloads().get(todump.content()) > 0 && target.acceptPayload(source, todump)) {
                    target.handlePayload((Building)this, todump);
                    this.getPayloads().remove(todump.content(), 1);
                    if (target instanceof PayloadConveyor.PayloadConveyorBuild) {
                        Fx.payloadDeposit.at(this.x, this.y, this.angleTo((Position)target), (Object)new UnitAssembler.YeetData(new Vec2(target.x, target.y), todump.content()));
                    }
                    this.incrementDumpIndex(this.linkProximityMap.size);
                    return true;
                }
                this.incrementDumpIndex(this.linkProximityMap.size);
            }
            return false;
        }

        public void offload(Item item) {
            this.produced(item, 1);
            int dump = this.dumpIndex;
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                this.incrementDumpIndex(this.linkProximityMap.size);
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (!target.acceptItem(source, item) || !this.canDump(target, item)) continue;
                target.handleItem(source, item);
                return;
            }
            this.handleItem(this, item);
        }

        public boolean canPickup() {
            return false;
        }

        public void drawTeam() {
            this.teamPos = Vars.world.tile(this.tileX() + BasicMultiBlock.this.teamOverlayPos((int)BasicMultiBlock.this.size, (int)this.rotation).x, this.tileY() + BasicMultiBlock.this.teamOverlayPos((int)BasicMultiBlock.this.size, (int)this.rotation).y);
            if (this.teamPos != null) {
                Draw.z((float)35.0f);
                Draw.color((Color)this.team.color);
                Draw.rect((String)"block-border", (float)this.teamPos.worldx(), (float)this.teamPos.worldy());
                Draw.color();
            }
        }

        public void drawStatus() {
            this.statusPos = Vars.world.tile(this.tileX() + BasicMultiBlock.this.statusOverlayPos((int)BasicMultiBlock.this.size, (int)this.rotation).x, this.tileY() + BasicMultiBlock.this.statusOverlayPos((int)BasicMultiBlock.this.size, (int)this.rotation).y);
            if (this.block.enableDrawStatus && this.block.consumers.length > 0) {
                float multiplier = this.block.size > 1 ? 1.0f : 0.64f;
                Draw.z((float)71.0f);
                Draw.color((Color)Pal.gray);
                Fill.square((float)this.statusPos.worldx(), (float)this.statusPos.worldy(), (float)(2.5f * multiplier), (float)45.0f);
                Draw.color((Color)this.status().color);
                Fill.square((float)this.statusPos.worldx(), (float)this.statusPos.worldy(), (float)(1.5f * multiplier), (float)45.0f);
                Draw.color();
            }
        }
    }
}

