/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.ability.passive;

import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHStats;

public class AccumulateAccelerate
extends Ability {
    public float reloadMultiplier = 1.0f;
    public float maxMultiplier = 5.0f;
    public float increasePerTick = 0.0033333334f;
    public float decreasePerTick = 0.033333335f;

    public void update(Unit unit) {
        super.update(unit);
        float increment = (unit.isShooting ? this.increasePerTick : -this.decreasePerTick) * Time.delta;
        this.reloadMultiplier = Mathf.clamp((float)(this.reloadMultiplier + increment), (float)1.0f, (float)this.maxMultiplier);
        unit.reloadMultiplier *= this.reloadMultiplier;
    }

    public void addStats(Table t) {
        t.add((CharSequence)("[lightgray]" + NHStats.increaseWhenShooting.localized() + ": [white]+" + Strings.autoFixed((float)(this.increasePerTick * 60.0f * 100.0f), (int)0) + "%" + StatUnit.perSecond.localized()));
        t.row();
        t.add((CharSequence)("[lightgray]" + NHStats.decreaseNotShooting.localized() + ": [white]-" + Strings.autoFixed((float)(this.decreasePerTick * 60.0f * 100.0f), (int)0) + "%" + StatUnit.perSecond.localized()));
        t.row();
        t.add((CharSequence)("[lightgray]" + NHStats.maxBoostPercent.localized() + ": [white]" + Strings.autoFixed((float)(this.maxMultiplier * 100.0f), (int)0) + "%"));
    }
}

