/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.ancient;

import arc.Core;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.type.Item;
import mindustry.world.Tile;
import newhorizon.content.NHFx;
import newhorizon.expand.block.turrets.ShootMatchTurret;

public class CaptureableTurret
extends ShootMatchTurret {
    public float captureInvicibility = 420.0f;
    public float shakeOnDestroy = -1.0f;
    public boolean cheatIfEnemy = true;
    public Effect replaceEffect = NHFx.crossBlastArrow45;
    public Item fallbackItem = null;

    public CaptureableTurret(String name) {
        super(name);
        this.replaceable = false;
    }

    public void init() {
        super.init();
        if (this.shakeOnDestroy < 0.0f) {
            this.shakeOnDestroy = this.size;
        }
        this.fallbackItem = (Item)this.ammoTypes.keys().toSeq().first();
    }

    public boolean isVisible() {
        return Vars.state.rules.editor || Vars.state.rules.infiniteResources;
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.rules.editor || Vars.state.rules.infiniteResources;
    }

    public class CaptureableTurretBuild
    extends ShootMatchTurret.ShootMatchTurretBuild {
        public Team lastDamage;
        public float iframes;

        public CaptureableTurretBuild() {
            super(CaptureableTurret.this);
            this.lastDamage = Team.derelict;
            this.iframes = -1.0f;
        }

        public boolean canControl() {
            return CaptureableTurret.this.playerControllable && !this.logicShooting;
        }

        public void damage(@Nullable Team source, float damage) {
            if (this.iframes > 0.0f) {
                return;
            }
            if (source != null && source != this.team) {
                this.lastDamage = source;
            }
            super.damage(source, damage);
        }

        public void updateTile() {
            super.updateTile();
            this.iframes -= Time.delta;
            if (this.cheating() && this.acceptItem(null, CaptureableTurret.this.fallbackItem)) {
                this.handleItem(null, CaptureableTurret.this.fallbackItem);
            }
        }

        public void changeTeam(Team next) {
            super.changeTeam(next);
        }

        public boolean cheating() {
            return super.cheating() || CaptureableTurret.this.cheatIfEnemy && this.team == Vars.state.rules.waveTeam;
        }

        public boolean canPickup() {
            return false;
        }

        public void onDestroyed() {
            Effect.shake((float)CaptureableTurret.this.shakeOnDestroy, (float)CaptureableTurret.this.shakeOnDestroy, (float)this.x, (float)this.y);
            NHFx.square45_8_45.at(this.x, this.y, 0.0f, this.lastDamage.color);
            NHFx.square45_6_45_Charge.at(this.x, this.y, 0.0f, this.lastDamage.color);
            NHFx.circleOut.at(this.x, this.y, (float)(8 * CaptureableTurret.this.size), this.lastDamage.color);
            CaptureableTurret.this.replaceEffect.at(this.x, this.y, CaptureableTurret.this.lightRadius, this.lastDamage.color);
        }

        public void afterDestroyed() {
            float rot = this.rotation;
            float warmup = this.warmupHold;
            if (!Vars.net.client()) {
                this.tile.setBlock(this.block, this.lastDamage);
                CaptureableTurretBuild b = (CaptureableTurretBuild)this.tile.build;
                b.rotation = rot;
                b.warmupHold = warmup;
            }
            Core.app.post(() -> this.tile.setNet(this.block, this.lastDamage, 0));
            if (!Vars.net.client()) {
                ((CaptureableTurretBuild)this.tile.build).iframes = CaptureableTurret.this.captureInvicibility;
            }
        }
    }
}

