/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.commandable;

import arc.audio.Sound;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import newhorizon.expand.block.commandable.CommandableAttackerBlock;

public class AirRaider
extends CommandableAttackerBlock {
    public float shootSpread = 38.0f;
    public Effect shootEffect = Fx.none;
    public Effect smokeEffect = Fx.none;
    public Effect triggeredEffect = Fx.none;
    public Sound shootSound = Sounds.shootArtillery;
    public float shake = 4.0f;
    public float velocityRnd = 0.015f;
    public float inaccuracy = 3.0f;
    public float cooldownSpeed = 0.075f;
    protected int totalShots = 0;
    protected Vec2 tr = new Vec2();

    public AirRaider(String name) {
        super(name);
        this.reloadTime = 600.0f;
        this.range = 1000.0f;
        this.spread = 40.0f;
        this.prepareDelay = 90.0f;
        this.unloadable = false;
    }

    @Override
    public void setStats() {
        super.setStats();
    }

    public class AirRaiderBuild
    extends CommandableAttackerBlock.CommandableAttackerBlockBuild {
        public AirRaiderBuild() {
            super(AirRaider.this);
        }

        @Override
        public void shoot(Vec2 target) {
            super.shoot(target);
            AirRaider.this.shoot.shoot(AirRaider.this.totalShots, (xOffset, yOffset, angle, delay, mover) -> {
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> this.bullet(xOffset, yOffset, angle, mover));
                } else {
                    this.bullet(xOffset, yOffset, angle, mover);
                }
                ++AirRaider.this.totalShots;
            });
        }

        protected void bullet(float xOffset, float yOffset, float angleOffset, Mover mover) {
            if (!this.isValid()) {
                return;
            }
            AirRaider.this.tr.setToRandomDirection().scl(AirRaider.this.shootSpread);
            Tmp.v5.setToRandomDirection().scl(AirRaider.this.spread).add(this.lastConfirmedTarget);
            float aimAngle = this.angleTo((Position)this.lastConfirmedTarget);
            float bulletX = this.x + Angles.trnsx((float)aimAngle, (float)xOffset, (float)yOffset) + Mathf.range((float)AirRaider.this.shootSpread);
            float bulletY = this.y + Angles.trnsy((float)aimAngle, (float)xOffset, (float)yOffset) + Mathf.range((float)AirRaider.this.shootSpread);
            float lifeScl = AirRaider.this.bullet.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)bulletX, (float)bulletY, (float)Tmp.v5.x, (float)Tmp.v5.y) / AirRaider.this.bullet.range)) : 1.0f;
            float angle = aimAngle + Mathf.range((float)AirRaider.this.inaccuracy);
            Bullet shootBullet = AirRaider.this.bullet.create(this.self(), this.team, bulletX, bulletY, angle, -1.0f, 1.0f - AirRaider.this.velocityRnd + Mathf.random((float)AirRaider.this.velocityRnd), lifeScl, null, mover, Tmp.v5.x, Tmp.v5.y);
            Effect.shake((float)AirRaider.this.shake, (float)AirRaider.this.shake, (Position)((Position)this.self()));
            AirRaider.this.bullet.shootEffect.at(bulletX, bulletY, angle, AirRaider.this.bullet.hitColor, (Object)this.unit);
            AirRaider.this.bullet.smokeEffect.at(bulletX, bulletY, angle, AirRaider.this.bullet.hitColor, (Object)this.unit);
            Effect fshootEffect = AirRaider.this.shootEffect == Fx.none ? AirRaider.this.bullet.shootEffect : AirRaider.this.shootEffect;
            Effect fsmokeEffect = AirRaider.this.smokeEffect == Fx.none ? AirRaider.this.bullet.smokeEffect : AirRaider.this.smokeEffect;
            fshootEffect.at(this.x + AirRaider.this.tr.x, this.y + AirRaider.this.tr.y, (float)this.rotation);
            fsmokeEffect.at(this.x + AirRaider.this.tr.x, this.y + AirRaider.this.tr.y, (float)this.rotation);
            AirRaider.this.shootSound.at(this.x + AirRaider.this.tr.x, this.y + AirRaider.this.tr.y, Mathf.random((float)0.9f, (float)1.1f));
        }
    }
}

