/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.commandable;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Damagec;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.expand.block.commandable.CommandableAttackerBlock;
import newhorizon.expand.block.commandable.CommandableBlock;
import newhorizon.util.func.NHFunc;

public class BombLauncher
extends CommandableAttackerBlock {
    public TextureRegion bombRegion;
    public TextureRegion[] gunBarrelRegion = new TextureRegion[4];
    public Sound shootSound = NHSounds.launch;
    public Color baseColor = Pal.redderDust;
    public float bombVelPerTile = 2.0f;

    public BombLauncher(String name) {
        super(name);
        this.storage = 4;
        this.range = 800.0f;
        this.spread = 80.0f;
        this.prepareDelay = 30.0f;
    }

    @Override
    public void setStats() {
        super.setStats();
    }

    public void init() {
        super.init();
        if (this.bullet.shootEffect == NHFx.boolSelector) {
            this.bullet.shootEffect = NHFx.square(this.baseColor, 50.0f, 6, (float)(this.size * 8) * 2.0f, this.size);
        }
    }

    @Override
    public void load() {
        super.load();
        this.bombRegion = Core.atlas.find(this.name + "-bomb", (TextureRegion)Core.atlas.find("launchpod"));
    }

    public class BombEntity
    extends CommandableBlock.CommandEntity
    implements Damagec {
        public static final float width = 3.3f;
        public static final float floatX = 10.0f;
        public static final float floatY = 30.0f;
        public boolean added;
        public boolean parent;
        public Vec2 target;
        public float damage;
        public float radius;
        public Trail trail;

        public BombEntity() {
            this(Team.derelict, 50.0f, (Position)Vec2.ZERO, -1.0f, -1.0f, false);
        }

        public BombEntity(Team team, float lifetime, Position from, float x, float y, boolean parent) {
            this.team = team;
            this.lifetime = lifetime;
            this.parent = parent;
            this.x = from.getX();
            this.y = from.getY();
            this.target = new Vec2(x, y);
            this.trail = new Trail(16);
        }

        public BombEntity init(Team team, float lifetime, Position from, float x, float y, boolean parent) {
            this.team = team;
            this.lifetime = lifetime;
            this.parent = parent;
            this.x = from.getX();
            this.y = from.getY();
            this.target = new Vec2(x, y);
            this.trail = new Trail(16);
            return this;
        }

        public BombEntity setDamage(float damage, float radius) {
            this.damage = damage;
            this.radius = radius;
            return this;
        }

        public float cx() {
            return this.x + (this.parent ? this.fin((Interp)Interp.pow2In) : this.fout((Interp)Interp.pow2Out)) * (10.0f + Mathf.randomSeedRange((long)(this.id() + 3), (float)10.0f));
        }

        public float cy() {
            return this.y + (this.parent ? this.fin((Interp)Interp.pow2In) * 1.25f : this.fout((Interp)Interp.pow5Out)) * (30.0f + Mathf.randomSeedRange((long)(this.id() + 2), (float)30.0f));
        }

        @Override
        public void draw() {
            float scl = this.parent ? this.fin() : this.fout();
            float alpha = this.parent ? this.fout((Interp)Interp.pow5Out) : this.fin((Interp)Interp.pow5In);
            float scale = (1.0f - alpha) * 1.3f + 1.0f;
            float cx = this.cx();
            float cy = this.cy();
            float rotation = this.fin() * (130.0f + Mathf.randomSeedRange((long)this.id(), (float)50.0f));
            Draw.z((float)110.001f);
            float rad = 0.2f + this.fslope();
            if (this.parent) {
                Draw.color((Color)BombLauncher.this.baseColor);
                Fill.light((float)cx, (float)cy, (int)10, (float)(25.0f * (rad + scale - 1.0f)), (Color)Tmp.c2.set(Pal.engine).a(alpha), (Color)Tmp.c1.set(Pal.engine).a(0.0f));
            }
            Draw.alpha((float)alpha);
            this.trail.draw(BombLauncher.this.baseColor, 3.3f);
            Draw.color((Color)BombLauncher.this.baseColor);
            if (this.parent) {
                for (int i = 0; i < 4; ++i) {
                    Drawf.tri((float)cx, (float)cy, (float)6.0f, (float)(40.0f * (rad + scale - 1.0f) * Mathf.curve((float)this.fout(), (float)0.0f, (float)0.5f)), (float)((float)i * 90.0f + rotation));
                }
            }
            Draw.color();
            float rw = (float)BombLauncher.this.bombRegion.width * Draw.scl * scale;
            float rh = (float)BombLauncher.this.bombRegion.height * Draw.scl * scale;
            Draw.alpha((float)alpha);
            Draw.z((float)116.0f);
            Draw.rect((TextureRegion)BombLauncher.this.bombRegion, (float)cx, (float)cy, (float)rw, (float)rh, (float)rotation);
            Drawf.light((float)cx, (float)cy, (float)(50.0f * (this.parent ? this.fout() : this.fin())), (Color)BombLauncher.this.baseColor, (float)0.7f);
            Tmp.v1.trns(225.0f, (this.parent ? this.fin((Interp)Interp.pow2In) * 1.25f : this.fout((Interp)Interp.pow5Out)) * (30.0f + Mathf.randomSeedRange((long)(this.id() + 2), (float)30.0f)));
            Draw.z((float)76.0f);
            Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.22f * alpha));
            Draw.rect((TextureRegion)BombLauncher.this.bombRegion, (float)(cx + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)rw, (float)rh, (float)rotation);
            Draw.reset();
        }

        public void hit() {
            Bullet b = BombLauncher.this.bullet.create((Entityc)this, this.team, this.x, this.y, 0.0f, 0.0f, 0.001f);
        }

        @Override
        public void update() {
            this.time = Math.min(this.time + Time.delta, this.lifetime);
            this.trail.update(this.cx(), this.cy());
            if (Mathf.chance((double)BombLauncher.this.bullet.trailChance)) {
                BombLauncher.this.bullet.trailEffect.at(this.cx(), this.cy(), BombLauncher.this.bullet.trailParam, BombLauncher.this.baseColor);
            }
            if (this.time >= this.lifetime) {
                this.remove();
            }
        }

        @Override
        public void remove() {
            Fx.trailFade.at(this.x, this.y, 3.3f, BombLauncher.this.baseColor, (Object)this.trail.copy());
            if (this.parent) {
                BombEntity next = (BombEntity)Pools.obtain(BombEntity.class, () -> new BombEntity());
                next.init(this.team, this.lifetime / 1.5f, (Position)this.target, this.target.x, this.target.y, false);
                Time.run((float)(this.target.dst((Position)this) / 8.0f * BombLauncher.this.bombVelPerTile), next::add);
            } else {
                this.hit();
            }
            Groups.draw.remove((Entityc)this);
            Groups.all.remove((Entityc)this);
            this.added = false;
        }

        public float damage() {
            return this.damage;
        }

        public void damage(float damage) {
            this.damage = damage;
        }
    }

    public class BombLauncherBuild
    extends CommandableAttackerBlock.CommandableAttackerBlockBuild {
        public BombLauncherBuild() {
            super(BombLauncher.this);
        }

        @Override
        public void draw() {
            super.draw();
            Draw.draw((float)Draw.z(), () -> {
                if (this.reload / BombLauncher.this.reloadTime > 1.0f) {
                    Draw.rect((TextureRegion)BombLauncher.this.bombRegion, (float)this.x, (float)this.y);
                } else {
                    Drawf.construct((float)this.x, (float)this.y, (TextureRegion)BombLauncher.this.bombRegion, (Color)BombLauncher.this.baseColor, (float)0.0f, (float)(this.reload / BombLauncher.this.reloadTime), (float)(Mathf.curve((float)(1.0f - this.reload / BombLauncher.this.reloadTime), (float)0.0f, (float)0.15f) * this.warmup), (float)this.totalProgress);
                }
            });
        }

        @Override
        public void shoot(Vec2 target) {
            super.shoot(target);
            Effect.shake((float)(BombLauncher.this.bullet.despawnShake / 2.0f), (float)BombLauncher.this.bullet.despawnShake, (Position)this);
            BombLauncher.this.bullet.shootEffect.at((Position)this);
            BombLauncher.this.bullet.smokeEffect.at((Position)this);
            BombLauncher.this.shootSound.at((Position)this);
            Rand rand = NHFunc.rand;
            rand.setSeed((long)this.tileX() + (long)this.tileY() * 31L + (long)target.hashCode() * 17L);
            BombEntity bomb = (BombEntity)Pools.obtain(BombEntity.class, () -> new BombEntity());
            bomb.init(this.team, 80.0f, (Position)this, target.x + rand.range(BombLauncher.this.spread) + Mathf.range((float)12.0f), target.y + rand.range(BombLauncher.this.spread) + Mathf.range((float)12.0f), true);
            bomb.add();
        }
    }
}

