/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.commandable;

import arc.func.Cons;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.entities.EntityGroup;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.io.TypeIO;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import newhorizon.NHGroups;

public abstract class CommandableBlock
extends Block {
    protected static final Seq<CommandableBlockBuild> participantsTmp = new Seq();
    public DrawBlock drawer = new DrawDefault();
    public float warmupSpeed = 0.02f;
    public float warmupFallSpeed = 0.0075f;
    public float range;
    public float reloadTime = 60.0f;
    public float configureChargeTime = 60.0f;
    protected int commandPos = -1;

    public CommandableBlock(String name) {
        super(name);
        this.timers = 4;
        this.solid = true;
        this.configurable = true;
        this.sync = true;
        this.update = true;
        this.config(Vec2.class, CommandableBlockBuild::commandAll);
        this.config(Point2.class, (b, p) -> {
            b.setTarget((Point2)p);
            this.commandPos = p.pack();
        });
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)this, out);
    }

    public boolean sameGroup(Block other) {
        return ((Object)((Object)this)).equals(other);
    }

    public abstract class CommandableBlockBuild
    extends Building
    implements Ranged {
        protected final Vec2 targetVec = new Vec2().set((Position)this);
        protected final Vec2 lastConfirmedTarget = new Vec2();
        public boolean initiateConfigure = false;
        public float configureChargeProgress = 0.0f;
        public float reload;
        public float warmup;
        public float totalProgress;
        public BlockUnitc unit;
        public int target = -1;
        public float logicControlTime = -1.0f;

        public int getTarget() {
            return this.target;
        }

        public void setTarget(Point2 point2) {
            this.target = point2.pack();
            this.target();
        }

        public abstract void command(Vec2 var1);

        public abstract void commandAll(Vec2 var1);

        public abstract boolean canCommand(Vec2 var1);

        public abstract boolean isCharging();

        public abstract boolean shouldCharge();

        public boolean isChargingConfigure() {
            return this.initiateConfigure;
        }

        public boolean shouldChargeConfigure() {
            return this.configureChargeProgress < CommandableBlock.this.configureChargeTime && this.initiateConfigure;
        }

        public boolean configureChargeComplete() {
            return this.configureChargeProgress >= CommandableBlock.this.configureChargeTime && this.initiateConfigure;
        }

        public Vec2 target() {
            Tile tile = Vars.world.tile(this.target);
            if (tile != null) {
                return this.targetVec.set((Position)tile);
            }
            return this.targetVec.set((Position)this.self());
        }

        public void updateTile() {
            if (this.unit != null) {
                this.unit.health(this.health);
                this.unit.rotation((float)this.rotation);
                this.unit.team(this.team);
                this.unit.set(this.x, this.y);
            }
            if (this.shouldCharge()) {
                this.reload += this.edelta() * this.warmup;
            }
            if (this.efficiency > 0.0f) {
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)CommandableBlock.this.warmupSpeed);
                this.totalProgress += this.warmup * this.edelta();
            } else {
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)CommandableBlock.this.warmupFallSpeed);
            }
        }

        public void updateShoot() {
        }

        public void updateControl() {
        }

        public void created() {
            this.unit = (BlockUnitc)UnitTypes.block.create(this.team);
            this.unit.tile((Building)this);
        }

        public void read(Reads read, byte v) {
            this.warmup = read.f();
            this.reload = read.f();
            TypeIO.readVec2((Reads)read, (Vec2)this.targetVec);
            super.read(read);
        }

        public void write(Writes write) {
            write.f(this.warmup);
            write.f(this.reload);
            TypeIO.writeVec2((Writes)write, (Vec2)this.targetVec);
        }

        public float range() {
            return CommandableBlock.this.range;
        }

        public void draw() {
            CommandableBlock.this.drawer.draw((Building)this);
        }

        public float warmup() {
            return this.warmup;
        }

        public float totalProgress() {
            return this.totalProgress;
        }

        public float progress() {
            return 0.0f;
        }

        public void add() {
            if (!this.added) {
                NHGroups.commandableBuilds.add((Object)this);
            }
            super.add();
        }

        public void remove() {
            if (this.added) {
                NHGroups.commandableBuilds.remove((Object)this);
            }
            super.remove();
        }
    }

    public static class CommandEntity
    implements Drawc,
    Timedc,
    Teamc {
        public Cons<Teamc> act;
        public boolean added;
        public transient int id = EntityGroup.nextId();
        public transient float time;
        public transient float lifetime;
        public transient float x;
        public transient float y;
        public transient Team team;

        public float clipSize() {
            return 500.0f;
        }

        public void draw() {
        }

        public void update() {
            this.time = Math.min(this.time + Time.delta, this.lifetime);
            if (this.time >= this.lifetime) {
                this.remove();
            }
        }

        public void remove() {
            Groups.draw.remove((Entityc)this);
            Groups.all.remove((Entityc)this);
            this.added = false;
        }

        public void add() {
            if (this.added) {
                return;
            }
            Groups.all.add((Entityc)this);
            Groups.draw.add((Entityc)this);
            this.added = true;
        }

        public boolean isLocal() {
            return this instanceof Unitc && ((Unitc)this).controller() == Vars.player;
        }

        public boolean isRemote() {
            return this instanceof Unitc && ((Unitc)this).isPlayer() && !this.isLocal();
        }

        public float fin() {
            return this.time / this.lifetime;
        }

        public float time() {
            return this.time;
        }

        public void time(float time) {
            this.time = time;
        }

        public float lifetime() {
            return this.lifetime;
        }

        public void lifetime(float lifetime) {
            this.lifetime = lifetime;
        }

        public <T extends Entityc> T self() {
            return (T)this;
        }

        public <T> T as() {
            return (T)this;
        }

        public void set(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void set(Position pos) {
            this.set(pos.getX(), pos.getY());
        }

        public void trns(float x, float y) {
            this.set(this.x + x, this.y + y);
        }

        public void trns(Position pos) {
            this.trns(pos.getX(), pos.getY());
        }

        public int tileX() {
            return 0;
        }

        public int tileY() {
            return 0;
        }

        public Floor floorOn() {
            return null;
        }

        public Building buildOn() {
            return null;
        }

        public Block blockOn() {
            return null;
        }

        public boolean onSolid() {
            return false;
        }

        public Tile tileOn() {
            return null;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float x() {
            return this.x;
        }

        public void x(float x) {
            this.x = x;
        }

        public float y() {
            return this.y;
        }

        public void y(float y) {
            this.y = y;
        }

        public boolean isAdded() {
            return this.added;
        }

        public int classId() {
            return 1001;
        }

        public boolean serialize() {
            return false;
        }

        public void read(Reads read) {
        }

        public void write(Writes write) {
        }

        public void afterRead() {
        }

        public void afterReadAll() {
        }

        public void beforeWrite() {
        }

        public int id() {
            return this.id;
        }

        public void id(int id) {
            this.id = id;
        }

        public String toString() {
            return "CommandEntity{added=" + this.added + ", id=" + this.id + ", x=" + this.x + ", y=" + this.y + ", lifetime=" + this.lifetime + '}';
        }

        public boolean inFogTo(Team viewer) {
            return this.team != viewer && !Vars.fogControl.isVisible(viewer, this.x, this.y);
        }

        public boolean cheating() {
            return this.team.rules().cheat;
        }

        public CoreBlock.CoreBuild core() {
            return this.team.core();
        }

        public CoreBlock.CoreBuild closestCore() {
            return this.team.core();
        }

        public CoreBlock.CoreBuild closestEnemyCore() {
            return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
        }

        public Team team() {
            return this.team;
        }

        public void team(Team team) {
            this.team = team;
        }
    }
}

