/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.Queue;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHFx;
import newhorizon.content.NHStats;
import newhorizon.util.graphic.SpriteUtil;

public class AdaptWall
extends Wall {
    private final Seq<Building> toDamage = new Seq();
    private final Queue<Building> queue = new Queue();
    public TextureRegion[] atlasRegion;
    public float damageReduction = 0.1f;
    public float maxShareStep = 3.0f;

    public AdaptWall(String name) {
        super(name);
        this.size = 1;
        this.insulated = true;
        this.absorbLasers = true;
        this.placeableLiquid = true;
        this.crushDamageMultiplier = 1.0f;
        this.clipSize = 18.0f;
        this.teamPassable = true;
    }

    public void load() {
        super.load();
        this.atlasRegion = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-atlas"), 32, 32, 1, SpriteUtil.ATLAS_INDEX_4_12);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.damageReduction, this.damageReduction * 100.0f, StatUnit.percent);
    }

    public class AdaptWallBuild
    extends Building {
        public Seq<AdaptWallBuild> connectedWalls = new Seq();
        public int drawIndex = 0;

        public void updateDrawRegion() {
            int i;
            this.drawIndex = 0;
            for (i = 0; i < SpriteUtil.orthogonalPos.length; ++i) {
                Point2 pos = SpriteUtil.orthogonalPos[i];
                Building build = Vars.world.build(this.tileX() + pos.x, this.tileY() + pos.y);
                if (!this.checkWall(build)) continue;
                this.drawIndex += 1 << i;
            }
            for (i = 0; i < SpriteUtil.diagonalPos.length; ++i) {
                Point2[] posArray = SpriteUtil.diagonalPos[i];
                boolean out = true;
                for (Point2 pos : posArray) {
                    Building build = Vars.world.build(this.tileX() + pos.x, this.tileY() + pos.y);
                    if (this.checkWall(build)) continue;
                    out = false;
                    break;
                }
                if (!out) continue;
                this.drawIndex += 1 << i + 4;
            }
            this.drawIndex = SpriteUtil.ATLAS_INDEX_4_12_MAP.get(this.drawIndex);
        }

        public void findLinkWalls() {
            AdaptWall.this.toDamage.clear();
            AdaptWall.this.queue.clear();
            AdaptWall.this.queue.addLast((Object)this);
            while (((AdaptWall)AdaptWall.this).queue.size > 0) {
                Building wall = (Building)AdaptWall.this.queue.removeFirst();
                AdaptWall.this.toDamage.addUnique((Object)wall);
                for (Building next : wall.proximity) {
                    if (!this.linkValid(next) || AdaptWall.this.toDamage.contains((Object)next)) continue;
                    AdaptWall.this.toDamage.add((Object)next);
                    AdaptWall.this.queue.addLast((Object)next);
                }
            }
        }

        public boolean linkValid(Building build) {
            return this.checkWall(build) && Mathf.dstm((float)this.tileX(), (float)this.tileY(), (float)build.tileX(), (float)build.tileY()) <= AdaptWall.this.maxShareStep;
        }

        public boolean checkWall(Building build) {
            return build != null && build.block == this.block;
        }

        public void drawSelect() {
            super.drawSelect();
            this.findLinkWalls();
            for (Building wall : AdaptWall.this.toDamage) {
                Draw.color((Color)this.team.color);
                Draw.alpha((float)0.5f);
                Fill.square((float)wall.x, (float)wall.y, (float)2.0f);
            }
            Draw.reset();
        }

        public void updateProximityWall() {
            this.connectedWalls.clear();
            for (Point2 point : SpriteUtil.proximityPos) {
                Building other = Vars.world.build(this.tile.x + point.x, this.tile.y + point.y);
                if (other == null || other.team != this.team || !this.checkWall(other)) continue;
                this.connectedWalls.add((Object)((AdaptWallBuild)other));
            }
            this.updateDrawRegion();
        }

        public void drawTeam() {
            Draw.color((Color)this.team.color);
            Draw.alpha((float)0.25f);
            Draw.z((float)29.5f);
            Fill.square((float)this.x, (float)this.y, (float)5.0f);
            Draw.color();
        }

        public boolean checkSolid() {
            return false;
        }

        public boolean collision(Bullet other) {
            if (other.type.absorbable) {
                other.absorb();
            }
            return super.collision(other);
        }

        public void damage(Bullet bullet, Team source, float damage) {
            super.damage(bullet, source, damage);
        }

        public float handleDamage(float amount) {
            this.findLinkWalls();
            float shareDamage = amount / (float)((AdaptWall)AdaptWall.this).toDamage.size * (1.0f - AdaptWall.this.damageReduction);
            for (Building b : AdaptWall.this.toDamage) {
                this.damageShared(b, shareDamage);
            }
            return shareDamage;
        }

        public void damageShared(Building building, float damage) {
            if (building.dead()) {
                return;
            }
            float dm = Vars.state.rules.blockHealth(this.team);
            damage = Mathf.zero((float)dm) ? building.health + 1.0f : (damage /= dm);
            if (!Vars.net.client()) {
                building.health -= damage;
            }
            if (this.damaged()) {
                this.healthChanged();
            }
            if (building.health <= 0.0f) {
                Call.buildDestroyed((Building)building);
            }
            NHFx.shareDamage.at(building.x, building.y, (float)(building.block.size * 8) / 2.0f, this.team.color, (Object)Float.valueOf(Mathf.clamp((float)(damage / ((float)this.block.health * 0.1f)))));
        }

        public void draw() {
            Draw.z((float)31.0f);
            Draw.rect((TextureRegion)AdaptWall.this.atlasRegion[this.drawIndex], (float)this.x, (float)this.y);
        }

        public void updateProximity() {
            super.updateProximity();
            this.updateProximityWall();
            for (AdaptWallBuild other : this.connectedWalls) {
                other.updateProximityWall();
            }
        }

        public void onRemoved() {
            for (AdaptWallBuild other : this.connectedWalls) {
                other.updateProximityWall();
            }
            super.onRemoved();
        }
    }
}

