/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.EnumSet;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.util.graphic.OptionalMultiEffect;

public class FireExtinguisher
extends Block {
    public float range = 280.0f;
    public float intensity = 500.0f;
    public float reloadTime = 120.0f;
    public float coolantMultiplier = 1.0f;
    public Color baseColor = NHColor.lightSkyBack;
    public Effect extinguishEffect = new OptionalMultiEffect(NHFx.circle, new Effect(50.0f, 500.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.65f));
        Fill.circle((float)e.x, (float)e.y, (float)(4.0f * e.fout()));
        Lines.stroke((float)(3.0f * e.fout()));
        Lines.spikes((float)e.x, (float)e.y, (float)(e.rotation * e.finpow()), (float)(5.0f * e.fout() + e.rotation / 10.0f * e.fslope()), (int)4, (float)45.0f);
    }), new Effect(25.0f, e -> {
        Draw.z((float)99.9f);
        Fill.light((float)e.x, (float)e.y, (int)Lines.circleVertices((float)(e.rotation * e.finpow())), (float)(e.rotation * e.finpow()), (Color)Color.clear, (Color)Tmp.c1.set(e.color).lerp(Color.white, e.fout() * 0.65f).lerp(Color.clear, 0.3f + 0.7f * e.fin((Interp)Interp.exp5In)));
    }));

    public FireExtinguisher(String name) {
        super(name);
        this.hasItems = true;
        this.hasPower = true;
        this.hasLiquids = true;
        this.update = true;
        this.solid = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.extinguisher});
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.reload, 60.0f / this.reloadTime, StatUnit.perSecond);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.abilities, this.intensity, StatUnit.seconds);
    }

    public void init() {
        super.init();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Vars.player.team().color);
    }

    public class FireExtinguisherBuild
    extends Building
    implements Ranged {
        public float reload = 0.0f;
        public boolean activated = true;

        public boolean isActive() {
            return this.activated;
        }

        public void updateTile() {
            if (this.timer.get(20.0f)) {
                this.activated = false;
                Vars.indexer.eachBlock((Teamc)this, this.range(), b -> Fires.has((int)b.tileX(), (int)b.tileY()), b -> {
                    this.activated = this.efficiency > 0.0f;
                });
            }
            if (this.activated) {
                if (this.reload < FireExtinguisher.this.reloadTime) {
                    this.reload += this.edelta();
                } else {
                    this.reload = 0.0f;
                    this.consume();
                    FireExtinguisher.this.extinguishEffect.at(this.x, this.y, this.range(), FireExtinguisher.this.baseColor);
                    Geometry.circle((int)this.tileX(), (int)this.tileY(), (int)Mathf.ceil((float)(this.range() / 8.0f)), (x1, y1) -> Fires.extinguish((Tile)Vars.world.tile(x1, y1), (float)FireExtinguisher.this.intensity));
                }
            }
        }

        public float range() {
            return FireExtinguisher.this.range;
        }

        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)this.range(), (Color)this.team.color);
        }
    }
}

