/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Posc;
import mindustry.gen.Sounds;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.type.StatusEffect;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHFx;
import newhorizon.util.feature.PosLightning;

public class ShockwaveGenerator
extends Block {
    public float knockback = 0.0f;
    public float blastShake = 8.0f;
    public float range = 160.0f;
    public float reloadTime = 90.0f;
    public float damage = 10.0f;
    public float heal = 0.0f;
    public float chargerOffset = (float)(8 * this.size) / 4.0f;
    public float rotateOffset = 0.0f;
    public boolean targetHost = true;
    public boolean targetFriendly = false;
    public float statusDuration = 60.0f;
    public StatusEffect status = StatusEffects.none;
    public StatusEffect positiveStatus = StatusEffects.none;
    public Effect generateEffect = Fx.none;
    public Effect acceptEffect = Fx.none;
    public Sound blastSound = Sounds.explosion;
    public int generateLiNum = 3;
    public int generateLiLen = 10;
    public int generateLenRand = 0;
    public float lightningDamage = 120.0f;
    public Color lightningColor = Color.valueOf((String)"#FFBDAD");
    public int gettingBoltNum = 0;
    public DrawBlock drawer = new DrawDefault();

    public ShockwaveGenerator(String name) {
        super(name);
        this.timers = 2;
        this.update = true;
        this.solid = true;
        this.attacks = true;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.damage, this.damage);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)this, out);
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public class StaticChargeBlasterBuild
    extends Building
    implements Ranged {
        public float reload;
        public float totalProgress;
        public Posc target;

        protected void findTarget() {
            this.target = Units.closestTarget((Team)this.team, (float)this.x, (float)this.y, (float)this.range());
        }

        protected boolean validateTarget() {
            return !Units.invalidateTarget((Posc)this.target, (Team)this.team, (float)this.x, (float)this.y) && this.target instanceof Unitc;
        }

        public float range() {
            return ShockwaveGenerator.this.range;
        }

        public void updateTile() {
            if (!this.validateTarget()) {
                this.target = null;
            }
            if (this.efficiency > 0.0f) {
                this.totalProgress += this.edelta();
                this.updateCharging();
                if (this.timer(0, 20.0f)) {
                    this.findTarget();
                }
                if (this.validateTarget() && this.reload >= ShockwaveGenerator.this.reloadTime) {
                    if (ShockwaveGenerator.this.targetHost) {
                        this.blast();
                    }
                    if (ShockwaveGenerator.this.targetFriendly) {
                        this.effectFriend();
                    }
                    this.extra();
                    this.reload = 0.0f;
                    this.consume();
                }
            }
        }

        protected void updateCharging() {
            if (this.reload < ShockwaveGenerator.this.reloadTime) {
                this.reload += Time.delta * this.efficiency;
            }
        }

        protected void effectFriend() {
            Units.nearby((Team)this.team, (float)this.x, (float)this.y, (float)this.range(), unit -> {
                unit.apply(ShockwaveGenerator.this.positiveStatus, ShockwaveGenerator.this.statusDuration);
                ShockwaveGenerator.this.acceptEffect.at((Position)unit);
                unit.heal(ShockwaveGenerator.this.heal);
            });
        }

        protected void blast() {
            Units.nearbyEnemies((Team)this.team, (float)this.x, (float)this.y, (float)ShockwaveGenerator.this.range, unit -> {
                unit.apply(ShockwaveGenerator.this.status, ShockwaveGenerator.this.statusDuration);
                unit.impulse(Tmp.v3.set((Position)unit).sub(this.x, this.y).nor().scl(ShockwaveGenerator.this.knockback * 40.0f));
                ShockwaveGenerator.this.acceptEffect.at((Position)unit);
                PosLightning.create((Entityc)this, this.team, (Position)this, (Position)unit, ShockwaveGenerator.this.lightningColor, false, ShockwaveGenerator.this.damage, 0, 2.5f, ShockwaveGenerator.this.gettingBoltNum, (Cons<Position>)((Cons)p -> NHFx.lightningHitSmall.at(p.getX(), p.getY(), ShockwaveGenerator.this.lightningColor)));
            });
        }

        protected void extra() {
            Effect.shake((float)ShockwaveGenerator.this.blastShake, (float)ShockwaveGenerator.this.blastShake, (Position)this);
            ShockwaveGenerator.this.generateEffect.at((Position)this);
            ShockwaveGenerator.this.blastSound.at((Position)this, Mathf.random((float)0.9f, (float)1.1f));
            for (int i = 0; i < ShockwaveGenerator.this.generateLiNum; ++i) {
                Lightning.create((Team)this.team, (Color)ShockwaveGenerator.this.lightningColor, (float)(ShockwaveGenerator.this.lightningDamage < 0.0f ? ShockwaveGenerator.this.damage : ShockwaveGenerator.this.lightningDamage), (float)this.x, (float)this.y, (float)Mathf.range((float)360.0f), (int)(ShockwaveGenerator.this.generateLiLen + Mathf.random((int)ShockwaveGenerator.this.generateLenRand)));
            }
        }

        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)ShockwaveGenerator.this.range, (Color)this.team.color);
        }

        public void draw() {
            ShockwaveGenerator.this.drawer.draw((Building)this);
        }

        public float warmup() {
            return this.reload / ShockwaveGenerator.this.reloadTime;
        }

        public float totalProgress() {
            return this.totalProgress;
        }
    }
}

