/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.item;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.Eachable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.meta.Stat;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.SpriteUtil;

public class AdaptStackConveyor
extends StackConveyor {
    public boolean onlyCarry = true;
    public TextureRegion edge2Region;
    public TextureRegion[] topRegions;

    public AdaptStackConveyor(String name) {
        super(name);
        this.canOverdrive = false;
        this.placeableLiquid = true;
    }

    public void setStats() {
        super.setStats();
        if (this.onlyCarry) {
            this.stats.remove(Stat.itemsMoved);
        }
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        Draw.rect((TextureRegion)(this.onlyCarry ? this.regions[0] : this.topRegions[plan.rotation]), (float)plan.drawx(), (float)plan.drawy(), (float)(this.onlyCarry ? (float)(plan.rotation * 90) : 0.0f));
        if (this.onlyCarry) {
            for (int i = 0; i < 4; ++i) {
                if ((bits[3] & 1 << i) != 0) continue;
                Draw.rect((TextureRegion)this.edgeRegion, (float)plan.drawx(), (float)plan.drawy(), (float)((plan.rotation - i) * 90));
            }
        }
    }

    public void load() {
        super.load();
        this.edge2Region = Core.atlas.find(this.name + "-edge-d");
        this.topRegions = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-top"), 32, 32, 1);
    }

    public class AdaptStackConveyorBuild
    extends StackConveyor.StackConveyorBuild {
        public AdaptStackConveyorBuild() {
            super((StackConveyor)AdaptStackConveyor.this);
        }

        public void draw() {
            Draw.z((float)29.8f);
            if (AdaptStackConveyor.this.onlyCarry) {
                int i;
                Draw.rect((TextureRegion)AdaptStackConveyor.this.regions[this.state], (float)this.x, (float)this.y, (float)this.rotdeg());
                for (i = 0; i < 4; ++i) {
                    if ((this.blendprox & 1 << i) != 0) continue;
                    int rot = Mathf.mod((int)(this.rotation - i), (int)4);
                    if (rot <= 1) {
                        Draw.rect((TextureRegion)AdaptStackConveyor.this.edgeRegion, (float)this.x, (float)this.y, (float)(rot * 90));
                        continue;
                    }
                    Draw.rect((TextureRegion)AdaptStackConveyor.this.edge2Region, (float)this.x, (float)this.y, (float)(rot * 90));
                }
                if (this.state == 1) {
                    for (i = 0; i < 4; ++i) {
                        int dir = this.rotation - i;
                        Building near = this.nearby(dir);
                        if ((this.blendprox & 1 << i) == 0 || i == 0 || near == null || near.block.squareSprite) continue;
                        Draw.rect((TextureRegion)AdaptStackConveyor.this.sliced(AdaptStackConveyor.this.regions[0], Autotiler.SliceMode.bottom), (float)(this.x + (float)(Geometry.d4x((int)dir) * 8) * 0.75f), (float)(this.y + (float)(Geometry.d4y((int)dir) * 8) * 0.75f), (float)(dir * 90));
                    }
                } else if (this.state == 2 && (this.blendprox & 1) != 0 && !this.front().block.squareSprite) {
                    Draw.rect((TextureRegion)AdaptStackConveyor.this.sliced(AdaptStackConveyor.this.regions[0], Autotiler.SliceMode.top), (float)(this.x + (float)(Geometry.d4x((int)this.rotation) * 8) * 0.75f), (float)(this.y + (float)(Geometry.d4y((int)this.rotation) * 8) * 0.75f), (float)((float)this.rotation * 90.0f));
                }
            } else {
                Draw.rect((TextureRegion)AdaptStackConveyor.this.topRegions[this.rotation], (float)this.x, (float)this.y);
            }
            Draw.z((float)29.9f);
            Tile from = Vars.world.tile(this.link);
            if (this.link == -1 || from == null || this.lastItem == null) {
                return;
            }
            Tmp.v1.set(from.worldx(), from.worldy());
            Tmp.v2.set(this.x, this.y);
            Tmp.v1.interpolate(Tmp.v2, 1.0f - this.cooldown, Interp.linear);
            float size = 5.0f * Mathf.lerp((float)Math.min((float)this.items.total() / (float)AdaptStackConveyor.this.itemCapacity, 1.0f), (float)1.0f, (float)0.4f);
            Drawf.shadow((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(size * 1.2f));
            Draw.rect((TextureRegion)this.lastItem.fullIcon, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)size, (float)size, (float)0.0f);
            DrawFunc.drawText(this.items.total() + "", Tmp.v1.x, Tmp.v1.y - 2.0f);
        }

        public void onProximityUpdate() {
            if (AdaptStackConveyor.this.onlyCarry) {
                super.onProximityUpdate();
                if (this.state == 1) {
                    this.state = 0;
                }
            } else {
                this.state = 1;
            }
        }

        public void updateTile() {
            super.updateTile();
        }
    }
}

