/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.item.logistics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.blocks.distribution.DirectionalUnloader;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.NewHorizon;

public class AdaptDirectionalUnloader
extends DirectionalUnloader {
    public TextureRegion[] topRegions = new TextureRegion[4];
    public TextureRegion baseRegion;
    public TextureRegion itemRegion;

    public AdaptDirectionalUnloader(String name) {
        super(name);
    }

    public void load() {
        super.load();
        for (int i = 0; i < this.topRegions.length; ++i) {
            this.topRegions[i] = Core.atlas.find(this.name + "-top-" + i);
        }
        this.baseRegion = Core.atlas.find(NewHorizon.name("logistics-base"));
        this.itemRegion = Core.atlas.find(this.name + "-item");
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.baseRegion, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegions[plan.rotation], (float)plan.drawx(), (float)plan.drawy());
        this.drawPlanConfig(plan, list);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.speed);
        this.stats.add(Stat.speed, 15.0f, StatUnit.itemsSecond);
    }

    public class AdaptDirectionalUnloaderBuild
    extends DirectionalUnloader.DirectionalUnloaderBuild {
        public AdaptDirectionalUnloaderBuild() {
            super((DirectionalUnloader)AdaptDirectionalUnloader.this);
        }

        public void updateTile() {
            float f;
            float inc = this.unloadItem == null ? this.edelta() : this.edelta() / 16.5f * 30.0f;
            this.unloadTimer += inc;
            if (f >= AdaptDirectionalUnloader.this.speed) {
                Building front = this.front();
                Building back = this.back();
                if (front != null && back != null && back.items != null && front.team == this.team && back.team == this.team && back.canUnload()) {
                    if (this.unloadItem == null) {
                        Seq itemseq = Vars.content.items();
                        int itemc = itemseq.size;
                        for (int i = 0; i < itemc; ++i) {
                            Item item = (Item)itemseq.get((i + this.offset) % itemc);
                            if (!back.items.has(item) || !front.acceptItem((Building)this, item)) continue;
                            front.handleItem((Building)this, item);
                            back.items.remove(item, 1);
                            back.itemTaken(item);
                            ++this.offset;
                            this.offset %= itemc;
                            break;
                        }
                    } else if (back.items.has(this.unloadItem) && front.acceptItem((Building)this, this.unloadItem)) {
                        front.handleItem((Building)this, this.unloadItem);
                        back.items.remove(this.unloadItem, 1);
                        back.itemTaken(this.unloadItem);
                    }
                }
                this.unloadTimer %= AdaptDirectionalUnloader.this.speed;
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)AdaptDirectionalUnloader.this.baseRegion, (float)this.x, (float)this.y);
            if (this.unloadItem != null) {
                Draw.color((Color)this.unloadItem.color);
                Draw.rect((TextureRegion)AdaptDirectionalUnloader.this.itemRegion, (float)this.x, (float)this.y);
                Draw.color();
            }
            Draw.rect((TextureRegion)AdaptDirectionalUnloader.this.topRegions[this.rotation], (float)this.x, (float)this.y);
        }

        public void drawSelect() {
            this.drawIO();
            Draw.reset();
        }

        private void drawIO() {
            Building front = this.front();
            Building back = this.back();
            if (this.unloadItem != null && front != null && front.items != null && back != null && back.items != null && back.items.has((int)this.unloadItem.id)) {
                float alpha = Math.abs(100.0f - Time.time * 2.0f % 100.0f) / 100.0f;
                float ix = front.x;
                float iy = front.y;
                float ox = back.x;
                float oy = back.y;
                float px = Mathf.lerp((float)ix, (float)ox, (float)alpha);
                float py = Mathf.lerp((float)iy, (float)oy, (float)alpha);
                Draw.z((float)35.0f);
                Draw.color((Color)Pal.gray);
                Lines.stroke((float)2.5f);
                Fill.square((float)ix, (float)iy, (float)2.5f, (float)45.0f);
                Fill.square((float)ox, (float)oy, (float)2.5f, (float)45.0f);
                Lines.stroke((float)4.0f);
                Lines.line((float)ix, (float)iy, (float)ox, (float)oy);
                Draw.z((float)35.0001f);
                Draw.color((Color)(this.unloadItem == null ? Pal.gray : this.unloadItem.color));
                Fill.square((float)ix, (float)iy, (float)1.0f, (float)45.0f);
                Fill.square((float)ox, (float)oy, (float)1.0f, (float)45.0f);
                Lines.stroke((float)1.0f);
                Lines.line((float)ix, (float)iy, (float)ox, (float)oy);
                Draw.z((float)35.0002f);
                Draw.mixcol((Color)Draw.getColor(), (float)1.0f);
                Draw.color();
                Fill.square((float)px, (float)py, (float)1.0f, (float)45.0f);
                Draw.mixcol();
            }
        }
    }
}

