/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.item.logistics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.util.func.MathUtil;

public class AdaptItemBridge
extends ItemBridge {
    public static final int maxLinks = 3;
    public TextureRegion topRegion;

    public AdaptItemBridge(String name) {
        super(name);
        this.range = 6;
        this.placeableLiquid = true;
        this.drawTeamOverlay = false;
        this.allowDiagonal = true;
    }

    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    public void drawBridge(BuildPlan req, float ox, float oy, float flip) {
        if (Mathf.zero((float)Renderer.bridgeOpacity)) {
            return;
        }
        Draw.alpha((float)Renderer.bridgeOpacity);
        Lines.stroke((float)this.bridgeWidth);
        Tmp.v1.set(ox, oy).sub(req.drawx(), req.drawy()).setLength(2.0f);
        Lines.line((TextureRegion)this.bridgeRegion, (float)(req.drawx() + Tmp.v1.x), (float)(req.drawy() + Tmp.v1.y), (float)(ox - Tmp.v1.x), (float)(oy - Tmp.v1.y), (boolean)false);
        Draw.rect((TextureRegion)this.arrowRegion, (float)((req.drawx() + ox) / 2.0f), (float)((req.drawy() + oy) / 2.0f), (float)(Angles.angle((float)req.drawx(), (float)req.drawy(), (float)ox, (float)oy) + flip));
        Draw.reset();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile link = this.findLink(x, y);
        Drawf.dashCircle((float)(x * 8), (float)(y * 8), (float)(this.range * 8), (Color)Pal.placing);
        Draw.reset();
        Draw.color((Color)Pal.placing);
        Lines.stroke((float)1.0f);
        if (link != null && Math.abs(link.x - x) + Math.abs(link.y - y) > 1) {
            Lines.line((float)(x * 8), (float)(y * 8), (float)(link.x * 8), (float)(link.y * 8));
            Draw.rect((String)"bridge-arrow", (float)((float)(x * 8 + link.x * 8) / 2.0f), (float)((float)(y * 8 + link.y * 8) / 2.0f), (float)Angles.angle((float)link.x, (float)link.y, (float)x, (float)y));
        }
        Draw.reset();
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble) {
        if (other == null || tile == null || !this.positionsValid(tile.x, tile.y, other.x, other.y)) {
            return false;
        }
        return (other.block() == tile.block() && tile.block() == this || !(tile.block() instanceof ItemBridge) && other.block() == this) && (other.team() == tile.team() || tile.block() != this) && (!checkDouble || ((ItemBridge.ItemBridgeBuild)other.build).link != tile.pos());
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> MathUtil.dst(point, other) <= (float)this.range);
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        return Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2) <= (float)this.range;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, (float)this.range, StatUnit.blocks);
    }

    public class AdaptItemBridgeBuild
    extends ItemBridge.ItemBridgeBuild {
        public AdaptItemBridgeBuild() {
            super((ItemBridge)AdaptItemBridge.this);
        }

        public void updateTransport(Building other) {
            if (this.timer(0, 1.0f)) {
                Item item = this.items.take();
                if (item != null && other.acceptItem((Building)this, item)) {
                    other.handleItem((Building)this, item);
                    this.moved = true;
                } else if (item != null) {
                    this.items.add(item, 1);
                    this.items.undoFlow(item);
                }
                this.transportCounter -= AdaptItemBridge.this.transportTime;
            }
        }

        public void drawConfigure() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)(AdaptItemBridge.this.range * 8), (Color)Pal.placing);
            Drawf.select((float)this.x, (float)this.y, (float)((float)(this.tile.block().size * 8) / 2.0f + 2.0f), (Color)Pal.accent);
        }

        public void checkIncoming() {
            super.checkIncoming();
            for (int idx = 0; idx < this.incoming.size; ++idx) {
                int i = this.incoming.items[idx];
                Tile other = Vars.world.tile(i);
                if (idx <= 2) continue;
                other.build.configure((Object)-1);
                this.incoming.removeIndex(idx);
                --idx;
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)AdaptItemBridge.this.region, (float)this.x, (float)this.y);
            Draw.z((float)70.1f);
            Draw.rect((TextureRegion)AdaptItemBridge.this.topRegion, (float)this.x, (float)this.y);
            Draw.z((float)70.0f);
            Tile other = Vars.world.tile(this.link);
            if (!AdaptItemBridge.this.linkValid(this.tile, other)) {
                return;
            }
            if (Mathf.zero((float)Renderer.bridgeOpacity)) {
                return;
            }
            Lines.stroke((float)AdaptItemBridge.this.bridgeWidth);
            Lines.line((TextureRegion)AdaptItemBridge.this.bridgeRegion, (float)this.x, (float)this.y, (float)other.worldx(), (float)other.worldy(), (boolean)false);
            float dst = Mathf.dst((float)this.x, (float)this.y, (float)other.worldx(), (float)other.worldy()) - 2.0f;
            float ang = Angles.angle((float)this.x, (float)this.y, (float)other.worldx(), (float)other.worldy());
            int seg = Mathf.round((float)(dst / 8.0f));
            if (seg == 0) {
                return;
            }
            for (int i = 0; i < seg; ++i) {
                Tmp.v1.trns(ang, dst / (float)seg * (float)i + 1.0f).add((Position)this);
                Draw.alpha((float)(Mathf.absin((float)((float)i - this.time / AdaptItemBridge.this.arrowTimeScl), (float)AdaptItemBridge.this.arrowPeriod, (float)1.0f) * this.warmup * Renderer.bridgeOpacity));
                Draw.rect((TextureRegion)AdaptItemBridge.this.arrowRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)ang);
            }
            Draw.color();
            Draw.reset();
        }
    }
}

