/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.liquid;

import arc.Core;
import arc.Graphics;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.DirectionLiquidBridge;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.blocks.liquid.LiquidJunction;
import newhorizon.util.graphic.SpriteUtil;

public class AdaptConduit
extends Conduit {
    public TextureRegion[] topMaskRegions;

    public AdaptConduit(String name) {
        super(name);
        this.canOverdrive = false;
        this.placeableLiquid = true;
        this.config(Boolean.class, (build, armored) -> {
            build.armored = armored;
        });
    }

    public void load() {
        super.load();
        this.topMaskRegions = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-top"), 32, 32, 1);
    }

    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        if (tile.build instanceof AdaptConduitBuild && ((AdaptConduitBuild)tile.build).armored) {
            return otherblock.outputsLiquid && this.blendsArmored(tile, rotation, otherx, othery, otherrot, otherblock) || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasLiquids || otherblock instanceof LiquidJunction;
        }
        return super.blends(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        Draw.scl((float)bits[1], (float)bits[2]);
        Draw.color((Color)this.botColor);
        Draw.alpha((float)0.5f);
        Draw.rect((TextureRegion)this.botRegions[bits[0]], (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.color();
        Draw.rect((TextureRegion)this.topMaskRegions[bits[0]], (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.scl();
    }

    public class AdaptConduitBuild
    extends Conduit.ConduitBuild {
        public boolean armored;

        public AdaptConduitBuild() {
            super((Conduit)AdaptConduit.this);
            this.armored = false;
        }

        public void draw() {
            Draw.z((float)30.0f);
            Draw.scl((float)this.xscl, (float)this.yscl);
            this.drawAt(this.x, this.y, this.blendbits, this.rotation, Autotiler.SliceMode.none);
            Draw.reset();
        }

        protected void drawAt(float x, float y, int bits, int rotation, Autotiler.SliceMode slice) {
            float angle = (float)rotation * 90.0f;
            Draw.color((Color)AdaptConduit.this.botColor);
            Draw.rect((TextureRegion)AdaptConduit.this.sliced(AdaptConduit.this.botRegions[bits], slice), (float)x, (float)y, (float)angle);
            int frame = this.liquids.current().getAnimationFrame();
            int gas = this.liquids.current().gas ? 1 : 0;
            float ox = 0.0f;
            float oy = 0.0f;
            TextureRegion liquidr = Vars.renderer.fluidFrames[gas][frame];
            float xscl = Draw.xscl;
            float yscl = Draw.yscl;
            Draw.scl((float)1.0f, (float)1.0f);
            Drawf.liquid((TextureRegion)AdaptConduit.this.sliced(liquidr, slice), (float)(x + ox), (float)(y + oy), (float)this.smoothLiquid, (Color)this.liquids.current().color.write(Tmp.c1).a(1.0f));
            Draw.scl((float)xscl, (float)yscl);
            Draw.rect((TextureRegion)AdaptConduit.this.sliced(AdaptConduit.this.topMaskRegions[bits + (this.armored ? 5 : 0)], slice), (float)x, (float)y, (float)angle);
        }

        public void tapped() {
            super.tapped();
            Fx.placeBlock.at((Position)this, (float)AdaptConduit.this.size);
            Sounds.click.at((Position)this);
            this.configure(!this.armored);
            this.onProximityUpdate();
        }

        public Graphics.Cursor getCursor() {
            return this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
        }

        public Object config() {
            return this.armored;
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            if (this.armored) {
                return super.acceptLiquid(source, liquid) && (this.tile == null || source.block instanceof Conduit || source.block instanceof DirectionLiquidBridge || source.block instanceof LiquidJunction || source.tile.absoluteRelativeTo((int)this.tile.x, (int)this.tile.y) == this.rotation || !source.proximity.contains((Object)this));
            }
            return super.acceptLiquid(source, liquid);
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.armored);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.armored = read.bool();
        }
    }
}

