/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.liquid;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.gen.Building;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;
import newhorizon.expand.block.distribution.item.logistics.AdaptItemBridge;

public class AdaptLiquidBridge
extends AdaptItemBridge {
    public AdaptLiquidBridge(String name) {
        super(name);
        this.hasItems = false;
        this.hasLiquids = true;
        this.outputsLiquid = true;
        this.canOverdrive = false;
        this.group = BlockGroup.liquids;
        this.envEnabled = -1;
    }

    public class AdaptLiquidBridgeBuild
    extends AdaptItemBridge.AdaptItemBridgeBuild {
        @Override
        public void updateTransport(Building other) {
            if (this.warmup >= 0.25f) {
                this.moved |= this.moveLiquid(other, this.liquids.current()) > 0.05f;
            }
        }

        public void doDump() {
            this.dumpLiquid(this.liquids.current(), 1.0f);
        }

        @Override
        public void draw() {
            Draw.rect((TextureRegion)AdaptLiquidBridge.this.region, (float)this.x, (float)this.y);
            Draw.z((float)70.1f);
            Draw.rect((TextureRegion)AdaptLiquidBridge.this.topRegion, (float)this.x, (float)this.y);
            Draw.z((float)70.0f);
            Tile other = Vars.world.tile(this.link);
            if (!AdaptLiquidBridge.this.linkValid(this.tile, other)) {
                return;
            }
            if (Mathf.zero((float)Renderer.bridgeOpacity)) {
                return;
            }
            Lines.stroke((float)AdaptLiquidBridge.this.bridgeWidth);
            Lines.line((TextureRegion)AdaptLiquidBridge.this.bridgeRegion, (float)this.x, (float)this.y, (float)other.worldx(), (float)other.worldy(), (boolean)false);
            float dst = Mathf.dst((float)this.x, (float)this.y, (float)other.worldx(), (float)other.worldy()) - 2.0f;
            float ang = Angles.angle((float)this.x, (float)this.y, (float)other.worldx(), (float)other.worldy());
            int seg = Mathf.round((float)(dst / 8.0f));
            if (seg == 0) {
                return;
            }
            for (int i = 0; i < seg; ++i) {
                Tmp.v1.trns(ang, dst / (float)seg * (float)i + 1.0f).add((Position)this);
                Draw.alpha((float)(Mathf.absin((float)((float)i - this.time / AdaptLiquidBridge.this.arrowTimeScl), (float)AdaptLiquidBridge.this.arrowPeriod, (float)1.0f) * this.warmup * Renderer.bridgeOpacity));
                Draw.rect((TextureRegion)AdaptLiquidBridge.this.arrowRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)ang);
            }
            Draw.color();
            Draw.reset();
        }
    }
}

