/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.func.Floatf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;
import newhorizon.content.NHContent;
import newhorizon.util.graphic.DrawFunc;

public class ArcCharge
extends DrawPart {
    protected static final Rand rand = new Rand();
    protected static final Vec2 tr = new Vec2();
    protected static final Vec2 tr2 = new Vec2();
    public float size = 13.75f;
    public Color color;
    public DrawPart.PartProgress progress;
    public float chargeCircleFrontRad = 18.0f;
    public float chargeCircleBackRad = 8.0f;
    public Interp curve = Interp.pow3;
    public float lightningCircleInScl = 0.85f;
    public float lightningCircleOutScl = 1.1f;
    public Interp lightningCircleCurve = Interp.pow3Out;
    public Floatf<DrawPart.PartParams> chargeY = t -> 1.0f;
    public Floatf<DrawPart.PartParams> shootY = t -> 1.0f;

    public void draw(DrawPart.PartParams params) {
        float rot;
        int i;
        Draw.z((float)109.0f);
        Draw.color((Color)this.color);
        float x = params.x;
        float y = params.y;
        float rotation = params.rotation;
        float fin = this.progress.getClamp(params);
        Lines.stroke((float)(3.0f * Mathf.curve((float)fin, (float)0.1f, (float)0.2f)));
        tr2.trns(rotation, this.chargeY.get((Object)params));
        tr.trns(rotation, this.shootY.get((Object)params));
        Tmp.v2.set(tr).sub(tr2);
        float length = Tmp.v2.len();
        Tmp.v2.set(tr).add(tr2);
        DrawFunc.circlePercent(x + Tmp.v2.x / 2.0f, y + Tmp.v2.y / 2.0f, length / 2.0f, Mathf.curve((float)fin, (float)0.1f, (float)1.0f), rotation - Mathf.curve((float)fin, (float)0.1f, (float)1.0f) * 180.0f - 180.0f);
        float scl = this.size * 8.0f * this.lightningCircleCurve.apply(fin);
        float fin_9 = Mathf.curve((float)fin, (float)0.95f, (float)1.0f);
        float sclSign = this.size * 8.0f * this.lightningCircleCurve.apply(fin_9);
        Lines.stroke((float)(fin * this.lightningCircleInScl * 4.5f));
        Lines.circle((float)x, (float)y, (float)(scl * this.lightningCircleInScl));
        for (i = 0; i < 4; ++i) {
            rot = Time.time + (float)(i * 90);
            Tmp.v1.trns(rot, sclSign * this.lightningCircleInScl + Lines.getStroke() * 2.0f).add(x, y);
            Draw.rect((TextureRegion)NHContent.arrowRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)((float)NHContent.arrowRegion.width * Draw.scl * fin_9), (float)((float)NHContent.arrowRegion.height * Draw.scl * fin_9), (float)(rot + 90.0f));
        }
        Lines.stroke((float)(fin * this.lightningCircleOutScl * 4.5f));
        Lines.circle((float)x, (float)y, (float)(scl * this.lightningCircleOutScl));
        for (i = 0; i < 4; ++i) {
            rot = -Time.time * 1.5f + (float)(i * 90);
            Tmp.v1.trns(rot, sclSign * this.lightningCircleOutScl + Lines.getStroke() * 3.0f).add(x, y);
            Draw.rect((TextureRegion)NHContent.pointerRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)((float)NHContent.pointerRegion.width * Draw.scl * fin_9), (float)((float)NHContent.pointerRegion.height * Draw.scl * fin_9), (float)(rot + 90.0f));
        }
        if ((fin = Mathf.curve((float)fin, (float)0.25f, (float)1.0f)) < 0.01f) {
            return;
        }
        Fill.circle((float)(x + ArcCharge.tr2.x), (float)(y + ArcCharge.tr2.y), (float)(fin * this.chargeCircleBackRad));
        Lines.stroke((float)(fin * 3.0f - 1.0f));
        DrawFunc.circlePercentFlip(x + ArcCharge.tr2.x, y + ArcCharge.tr2.y, fin * (this.chargeCircleBackRad + 5.0f), Time.time, 20.0f);
        Draw.color((Color)Color.white);
        Fill.circle((float)(x + ArcCharge.tr2.x), (float)(y + ArcCharge.tr2.y), (float)(fin * this.chargeCircleBackRad * 0.7f));
        float cameraFin = (1.0f + 2.0f * DrawFunc.cameraDstScl(x + ArcCharge.tr.x, y + ArcCharge.tr.y, Vars.mobile ? 200.0f : 320.0f)) / 3.0f;
        float triWidth = fin * this.chargeCircleFrontRad / 3.5f * cameraFin;
        Draw.color((Color)this.color);
        for (int i2 : Mathf.signs) {
            Fill.tri((float)(x + ArcCharge.tr.x), (float)(y + ArcCharge.tr.y + triWidth), (float)(x + ArcCharge.tr.x), (float)(y + ArcCharge.tr.y - triWidth), (float)(x + ArcCharge.tr.x + (float)i2 * cameraFin * this.chargeCircleFrontRad * (23.0f + Mathf.absin((float)10.0f, (float)0.75f)) * (fin * 1.25f + 1.0f)), (float)(y + ArcCharge.tr.y));
            Drawf.tri((float)(x + ArcCharge.tr.x), (float)(y + ArcCharge.tr.y), (float)((fin + 1.0f) / 2.0f * this.chargeCircleFrontRad / 1.5f), (float)(this.chargeCircleFrontRad * 10.0f * fin), (float)((float)(i2 * 90) + Time.time * 1.25f));
            Drawf.tri((float)(x + ArcCharge.tr.x), (float)(y + ArcCharge.tr.y), (float)((fin + 1.0f) / 2.0f * this.chargeCircleFrontRad / 2.0f), (float)(this.chargeCircleFrontRad * 6.5f * fin), (float)((float)(i2 * 90) - Time.time));
        }
        Fill.circle((float)(x + ArcCharge.tr.x), (float)(y + ArcCharge.tr.y), (float)(fin * this.chargeCircleFrontRad));
        DrawFunc.circlePercentFlip(x + ArcCharge.tr.x, y + ArcCharge.tr.y, fin * (this.chargeCircleFrontRad + 5.0f), Time.time, 20.0f);
        Draw.color((Color)Color.white);
        Fill.circle((float)(x + ArcCharge.tr.x), (float)(y + ArcCharge.tr.y), (float)(fin * this.chargeCircleFrontRad * 0.7f));
    }
}

