/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import newhorizon.content.NHContent;

public class DrawArrowSequence
extends DrawPart {
    public float x;
    public float y;
    public float rotation;
    public TextureRegion arrowRegion;
    public String arrowName;
    public float layer = 100.0f;
    public float layerOffset = 0.0f;
    public Color color = Color.white;
    public Color colorTo = Color.white;
    public float colorToFinScl = 0.7f;
    public Blending blending = Blending.normal;
    public float opacity = 1.0f;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.reload.inv().mul(DrawPart.PartProgress.warmup);
    public DrawPart.PartProgress colorProgress = DrawPart.PartProgress.reload.inv().mul(DrawPart.PartProgress.warmup).compress(0.35f, 0.75f);
    public float spacing = 12.0f;
    public int arrows = 8;
    public float scl = 12.0f;
    public float maintainScl = 0.125f;

    public DrawArrowSequence() {
    }

    public DrawArrowSequence(String arrowName) {
        this.arrowName = arrowName;
    }

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z((float)(z - 1.0E-4f));
        }
        Draw.z((float)(Draw.z() + this.layerOffset));
        float prevZ = Draw.z();
        float fin = this.progress.getClamp(params);
        float fout = 1.0f - fin;
        Tmp.v5.trns(params.rotation, this.y, this.x).add(params.x, params.y);
        TextureRegion arrowRegion = NHContent.arrowRegion;
        Draw.color((Color)this.color, (Color)this.colorTo, (float)(this.colorToFinScl * this.colorProgress.get(params)));
        Draw.blend((Blending)this.blending);
        Draw.alpha((float)this.opacity);
        float railF = Mathf.curve((float)Interp.pow2Out.apply(fin), (float)0.0f, (float)0.25f) * Mathf.curve((float)Interp.pow4Out.apply(fout), (float)0.0f, (float)0.3f) * fin;
        for (int i = 0; i < this.arrows; ++i) {
            Tmp.v1.trns(params.rotation + this.rotation, (float)i * this.spacing).add(Tmp.v5);
            float f = Interp.pow3Out.apply(Mathf.clamp((float)(fin * (float)this.arrows - (float)i))) * (0.6f + railF * 0.4f);
            Draw.rect((TextureRegion)arrowRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)((float)arrowRegion.width * Draw.scl * f), (float)((float)arrowRegion.height * Draw.scl * f), (float)(params.rotation - 90.0f));
        }
        Draw.blend();
        Draw.reset();
        Draw.z((float)prevZ);
    }

    public void load(String name) {
        this.arrowRegion = this.arrowName != null ? Core.atlas.find(this.arrowName) : NHContent.arrowRegion;
    }
}

