/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.world.draw.DrawCrucibleFlame;

public class DrawCrucibleFlameRotated
extends DrawCrucibleFlame {
    public float flameX;
    public float flameY;

    public void draw(Building build) {
        if (build.warmup() > 0.0f && this.flameColor.a > 0.001f) {
            Tmp.v1.set(this.flameX, this.flameY).rotate(build.rotdeg()).add(build.x, build.y);
            Lines.stroke((float)(this.circleStroke * build.warmup()));
            float si = Mathf.absin((float)this.flameRadiusScl, (float)this.flameRadiusMag);
            float a = this.alpha * build.warmup();
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)this.midColor, (float)a);
            Fill.circle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(this.flameRad + si));
            Draw.color((Color)this.flameColor, (float)a);
            Lines.circle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)((this.flameRad + this.circleSpace + si) * build.warmup()));
            float base = Time.time / this.particleLife;
            rand.setSeed((long)build.id);
            for (int i = 0; i < this.particles; ++i) {
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float angle = rand.random(360.0f) + Time.time / this.rotateScl % 360.0f;
                float len = this.particleRad * this.particleInterp.apply(fout);
                Draw.alpha((float)(a * (1.0f - Mathf.curve((float)fin, (float)(1.0f - this.fadeMargin)))));
                Fill.circle((float)(Tmp.v1.x + Angles.trnsx((float)angle, (float)len)), (float)(Tmp.v1.y + Angles.trnsy((float)angle, (float)len)), (float)(this.particleSize * fin * build.warmup()));
            }
            Draw.blend();
            Draw.reset();
        }
    }
}

