/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawFlame;

public class DrawFlameRotated
extends DrawFlame {
    public boolean drawFlame = true;
    public String suffix = "";
    public float x;
    public float y;
    public float flameX;
    public float flameY;

    public DrawFlameRotated(float x, float y, Color flameColor) {
        super(flameColor);
        this.x = x;
        this.y = y;
    }

    public DrawFlameRotated(Color flameColor) {
        super(flameColor);
    }

    public DrawFlameRotated() {
    }

    public void load(Block block) {
        this.top = Core.atlas.find(block.name + this.suffix);
        block.clipSize = Math.max(block.clipSize, (this.lightRadius + this.lightSinMag) * 2.0f * (float)block.size);
    }

    public void draw(Building build) {
        if (build.warmup() > 0.0f && this.flameColor.a > 0.001f) {
            float g = 0.3f;
            float r = 0.06f;
            float cr = Mathf.random((float)0.1f);
            Tmp.v1.set(this.x, this.y).rotate(build.rotdeg());
            Draw.z((float)30.01f);
            Draw.alpha((float)build.warmup());
            if (this.drawFlame) {
                Draw.rect((TextureRegion)this.top, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)build.rotdeg());
            }
            Draw.alpha((float)((1.0f - g + Mathf.absin((float)Time.time, (float)8.0f, (float)g) + Mathf.random((float)r) - r) * build.warmup()));
            Tmp.v1.set(this.flameX, this.flameY).rotate(build.rotdeg());
            Draw.tint((Color)this.flameColor);
            Fill.circle((float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)(this.flameRadius + Mathf.absin((float)Time.time, (float)this.flameRadiusScl, (float)this.flameRadiusMag) + cr));
            Draw.color((float)1.0f, (float)1.0f, (float)1.0f, (float)build.warmup());
            Fill.circle((float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)(this.flameRadiusIn + Mathf.absin((float)Time.time, (float)this.flameRadiusScl, (float)this.flameRadiusInMag) + cr));
            Draw.color();
        }
    }
}

