/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.world.draw.DrawBlock;

public class DrawParticleFlow
extends DrawBlock {
    public float startX;
    public float startY;
    public float endX;
    public float endY;
    public float length = 1.5f;
    public float stroke = 0.6f;
    public float range = 4.0f;
    public Color color = Pal.techBlue.cpy().lerp(Color.white, 0.4f);
    public float particleAlpha = 1.0f;
    public float particleLife = 90.0f;
    public int particles = 45;
    public boolean ignoreRot2_3 = false;

    public void draw(Building build) {
        if (build.warmup() > 0.0f && this.color.a > 0.001f) {
            Lines.stroke((float)(this.stroke * build.warmup()));
            float ang = Angles.angle((float)this.startX, (float)this.startY, (float)this.endX, (float)this.endY);
            float realAng = ang + this.getRot(build);
            float base = Time.time / this.particleLife;
            rand.setSeed((long)build.id);
            for (int i = 0; i < this.particles; ++i) {
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float shift = rand.random(-this.range, this.range);
                float shiftAng = rand.nextBoolean() ? realAng + 90.0f : realAng - 90.0f;
                Tmp.v1.set((this.endX - this.startX) * fin, (this.endY - this.startY) * fin).add(this.startX, this.startY).rotate(this.getRot(build));
                Tmp.v2.trns(shiftAng, shift).add(Tmp.v1).add((Position)build);
                Draw.color((Color)this.color);
                Draw.alpha((float)(this.particleAlpha * build.warmup()));
                Lines.lineAngle((float)Tmp.v2.x, (float)Tmp.v2.y, (float)realAng, (float)this.length);
            }
            Draw.reset();
        }
    }

    public float getRot(Building build) {
        int rot = this.ignoreRot2_3 ? build.rotation % 2 : build.rotation;
        return rot * 90;
    }
}

