/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.draw.DrawDefault;

public class DrawPrinter
extends DrawDefault {
    public Color printColor;
    public Color lightColor;
    public float moveLength = 8.0f;
    public Item toPrint;
    public float time;
    public TextureRegion bottom;
    public TextureRegion lightRegion;

    public DrawPrinter(Item item) {
        this.toPrint = item;
    }

    public void draw(Building entity) {
        Draw.rect((TextureRegion)this.bottom, (float)entity.x, (float)entity.y);
        Draw.color((Color)this.printColor);
        Draw.alpha((float)entity.warmup());
        float sin = Mathf.sin((float)entity.totalProgress(), (float)this.time, (float)this.moveLength);
        for (int i : Mathf.signs) {
            Lines.lineAngleCenter((float)(entity.x + (float)i * sin), (float)entity.y, (float)90.0f, (float)12.0f);
            Lines.lineAngleCenter((float)entity.x, (float)(entity.y + (float)i * sin), (float)0.0f, (float)12.0f);
        }
        Draw.reset();
        Draw.rect((TextureRegion)entity.block.region, (float)entity.x, (float)entity.y);
        Draw.draw((float)35.0f, () -> Drawf.construct((float)entity.x, (float)entity.y, (TextureRegion)this.toPrint.fullIcon, (Color)this.printColor, (float)0.0f, (float)entity.progress(), (float)entity.progress(), (float)(entity.totalProgress() * 3.0f)));
        if (this.lightColor.a > 0.001f) {
            Draw.color((Color)this.lightColor, (float)entity.warmup());
            Draw.blend((Blending)Blending.additive);
            Draw.alpha((float)(entity.warmup() * 0.85f));
            Draw.rect((TextureRegion)this.lightRegion, (float)entity.x, (float)entity.y);
            Draw.blend();
            Draw.reset();
        }
    }

    public void drawLight(Building build) {
        Drawf.light((float)build.x, (float)build.y, (float)(build.warmup() * (float)build.block.size * 8.0f), (Color)this.lightColor, (float)0.7f);
    }

    public void load(Block block) {
        this.bottom = Core.atlas.find(block.name + "-bottom");
        this.lightRegion = Core.atlas.find(block.name + "-light");
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.bottom, block.region};
    }
}

