/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Tmp;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRegionFlip
extends DrawBlock {
    public TextureRegion region;
    public String suffix = "";
    public float layer = -1.0f;
    public float x = 0.0f;
    public float y = 0.0f;

    public DrawRegionFlip(String suffix) {
        this.suffix = suffix;
    }

    public DrawRegionFlip() {
    }

    public void draw(Building build) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        Tmp.v1.set(this.x, this.y).rotate(build.rotdeg() % 180.0f).add((Position)build);
        this.drawRegion(Tmp.v1.x, Tmp.v1.y, build.rotation);
        Draw.z((float)z);
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawRegion(plan.drawx(), plan.drawy(), plan.rotation);
    }

    public void drawRegion(float x, float y, int rotation) {
        if (rotation % 2 == 0) {
            Draw.rect((TextureRegion)this.region, (float)x, (float)y);
        } else {
            Draw.rect((TextureRegion)this.region, (float)x, (float)y, (float)((float)this.region.width / 8.0f * 2.0f), (float)((float)(-this.region.height) / 8.0f * 2.0f), (float)90.0f);
        }
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.region};
    }

    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
    }
}

