/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Tmp;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRegionRotatedDiagonal
extends DrawBlock {
    public TextureRegion[] region;
    public String suffix = "";
    public float layer = -1.0f;
    public float x = 0.0f;
    public float y = 0.0f;

    public DrawRegionRotatedDiagonal(String suffix) {
        this.suffix = suffix;
    }

    public DrawRegionRotatedDiagonal() {
    }

    public void draw(Building build) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        Tmp.v1.set(this.x, this.y).rotate(build.rotdeg() % 180.0f).add((Position)build);
        Draw.rect((TextureRegion)this.region[build.rotation % 2], (float)Tmp.v1.x, (float)Tmp.v1.y);
        Draw.z((float)z);
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region[plan.rotation % 2], (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.region[0]};
    }

    public void load(Block block) {
        this.region = new TextureRegion[2];
        for (int i = 0; i < 2; ++i) {
            this.region[i] = Core.atlas.find(block.name + this.suffix + "-" + i);
        }
    }
}

