/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRotator
extends DrawBlock {
    public String suffix = "-rotator";
    public TextureRegion rotator;
    public float x;
    public float y;
    public float rotateSpeed = 1.25f;
    public float primaryRotation = 0.0f;
    public boolean usesSpinDraw = false;

    public DrawRotator(boolean usesSpinDraw) {
        this.usesSpinDraw = usesSpinDraw;
    }

    public DrawRotator(float rotateSpeed, boolean usesSpinDraw) {
        this.rotateSpeed = rotateSpeed;
        this.usesSpinDraw = usesSpinDraw;
    }

    public DrawRotator(float rotateSpeed, String suffix) {
        this.suffix = suffix;
        this.rotateSpeed = rotateSpeed;
    }

    public DrawRotator(float rotateSpeed, float primaryRotation, String suffix) {
        this.suffix = suffix;
        this.rotateSpeed = rotateSpeed;
        this.primaryRotation = primaryRotation;
    }

    public DrawRotator(float rotateSpeed) {
        this.rotateSpeed = rotateSpeed;
    }

    public DrawRotator(float rotateSpeed, float primaryRotation) {
        this.rotateSpeed = rotateSpeed;
        this.primaryRotation = primaryRotation;
    }

    public DrawRotator() {
    }

    public void draw(Building build) {
        if (this.usesSpinDraw) {
            Drawf.spinSprite((TextureRegion)this.rotator, (float)(build.x + this.x), (float)(build.y + this.y), (float)(build.totalProgress() * this.rotateSpeed + this.primaryRotation));
        } else {
            Draw.rect((TextureRegion)this.rotator, (float)(build.x + this.x), (float)(build.y + this.y), (float)(build.totalProgress() * this.rotateSpeed + this.primaryRotation));
        }
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.rotator, (float)(plan.drawx() + this.x), (float)(plan.drawy() + this.y), (float)this.primaryRotation);
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.rotator};
    }

    public void load(Block block) {
        this.rotator = Core.atlas.find(block.name + this.suffix);
    }
}

