/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import mindustry.Vars;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class ArmorFloor
extends Floor {
    public Floor solidReact;
    public TextureRegion large;
    public TextureRegion[][] split;

    public ArmorFloor(String name, int variants, Floor solidReact) {
        super(name, variants);
        this.solidReact = solidReact;
        this.oreDefault = false;
        this.needsSurface = false;
    }

    public ArmorFloor(String name, int variants) {
        this(name, variants, null);
    }

    protected boolean doEdge(Tile tile, Tile otherTile, Floor other) {
        return !(this.solidReact != null && other.blendGroup == this.solidReact || other.realBlendId(otherTile) <= this.realBlendId(tile) && this.edges != null);
    }

    public void init() {
        if (this.solidReact != null) {
            this.blendGroup = this.solidReact;
        }
        super.init();
    }

    public void drawBase(Tile tile) {
        Mathf.rand.setSeed((long)tile.pos());
        Draw.rect((TextureRegion)this.variantRegions[Mathf.randomSeed((long)tile.pos(), (int)0, (int)Math.max(0, this.variantRegions.length - 1))], (float)tile.worldx(), (float)tile.worldy());
        int rx = tile.x / 2 * 2;
        int ry = tile.y / 2 * 2;
        if (Core.atlas.isFound(this.large) && this.eq(rx, ry) && (double)Mathf.randomSeed((long)Point2.pack((int)rx, (int)ry)) < 0.5) {
            Draw.rect((TextureRegion)this.split[tile.x % 2][1 - tile.y % 2], (float)tile.worldx(), (float)tile.worldy());
        } else {
            Draw.rect((TextureRegion)this.variantRegions[Mathf.randomSeed((long)tile.pos(), (int)0, (int)Math.max(0, this.variantRegions.length - 1))], (float)tile.worldx(), (float)tile.worldy());
        }
        Draw.alpha((float)1.0f);
        this.drawEdges(tile);
        this.drawOverlay(tile);
    }

    public void load() {
        super.load();
        this.large = Core.atlas.find(this.name + "-large");
        this.split = this.large.split(32, 32);
    }

    boolean eq(int rx, int ry) {
        return rx < Vars.world.width() - 1 && ry < Vars.world.height() - 1 && Vars.world.tile(rx + 1, ry).floor() == this && Vars.world.tile(rx, ry + 1).floor() == this && Vars.world.tile(rx, ry).floor() == this && Vars.world.tile(rx + 1, ry + 1).floor() == this;
    }
}

